/*
 * COPYRIGHT:       See COPYING in the top level directory
 * PROJECT:         ReactOS ReactX
 * FILE:            dll/directx/d3d9/d3d9_private.h
 * PURPOSE:         d3d9.dll internal structures
 * PROGRAMERS:      Gregor Brunmar <gregor (dot) brunmar (at) home (dot) se>
 */
#ifndef _D3D9_PRIVATE_H_
#define _D3D9_PRIVATE_H_

#include "d3d9_common.h"
#include <ddraw.h>
#include "d3d9_callbacks.h"

#define D3D9_INT_MAX_NUM_ADAPTERS   12

#define D3D9_INT_D3DCAPS8_VALID     1
#define D3D9_INT_D3DCAPS9_VALID     2

typedef struct _D3D9_Unknown6BC
{
/* 0x0000 */    HANDLE hDirectDrawLocal;
/* 0x0004 */    LPDWORD pUnknown0004;
/* 0x0008 */    DWORD dwUnknown0008;
/* 0x000c */    CHAR szDeviceName[CCHDEVICENAME];
/* 0x002c */    HLOCAL swDDICreateDirectDrawObject;
/* 0x0030 */    DWORD dwUnknown0030;
/* 0x0034 */    ULONG DeviceUniq;
/* 0x0038 */    DWORD dwUnknown0038;
/* 0x003c */    DWORD dwUnknown003c;
/* 0x0040 */    D3DFORMAT RawDisplayFormat;
/* 0x0044 */    D3DFORMAT DisplayFormat;
/* 0x0048 */    LONG lDisplayPitch;
/* 0x004c */    DWORD MajorDxVersion;
/* 0x0050 */    RECT DeviceRect;
/* 0x0060 */    DWORD dwUnknown0060;
/* 0x0064 */    DWORD unknown0064;  // = 0
/* 0x0068 */    BOOL bIsXPorLater;
/* 0x006c */    DWORD DevVenId;     // DeviceId << 10 | VendorId
#ifdef _WIN32
/* 0x0070 */    LARGE_INTEGER   DriverVersion;
#else
/* 0x0070 */    DWORD           DriverVersionLowPart;
/* 0x0074 */    DWORD           DriverVersionHighPart;
#endif
/* 0x0078 */    DWORD bForceDriverFlagsOn;
/* 0x007c */    DWORD bForceDriverFlagsOff;
/* 0x0080 */    DWORD dwUnknown0080;
/* 0x0084 */    DWORD dwCaps;
/* 0x0088 */    DWORD dwSVBCaps;
/* 0x008c */    HMODULE _unknown0151;
/* 0x0090 */    DWORD dwUnknown0090;
/* 0x0094 */    D3DDEVTYPE DeviceType;
/* 0x0098 */    DWORD dwUnknown0098;
/* 0x009c */    DWORD dwUnknown009c;
/* 0x00a0 */    DWORD dwUnknown00a0;
/* 0x00a4 */    DWORD dwUnknown00a4;
/* 0x00a8 */    DWORD dwUnknown00a8;
/* 0x00ac */    DWORD dwUnknown00ac;
/* 0x00b0 */    DWORD dwUnknown00b0;
/* 0x00b4 */    DWORD dwUnknown00b4;
/* 0x00b8 */    DWORD dwUnknown00b8;
/* 0x00BC */    DDGAMMARAMP GammaRamp;
} D3D9_Unknown6BC;

typedef struct _D3D9_DRIVERCAPS
{
/* 0x0000 */    D3DCAPS9 DriverCaps9;
/* 0x0130 */    DWORD dwDisplayWidth;
/* 0x0134 */    DWORD dwDisplayHeight;
/* 0x0138 */    D3DFORMAT RawDisplayFormat;
/* 0x013c */    D3DFORMAT DisplayFormat;
/* 0x0140 */    DWORD dwRefreshRate;
/* 0x0144 */    DWORD unknown0081;
/* 0x0148 */    DWORD dwSVBCaps;
/* 0x014c */    DWORD dwVSBCaps;
/* 0x0150 */    DWORD dwSVBCaps2;
/* 0x0154 */    DWORD dwDriverCaps;
/* 0x0158 */    DWORD NumSupportedFormatOps;
/* 0x015c */    LPDDSURFACEDESC pSupportedFormatOps;
/* 0x0160 */    DWORD unknown0088;
/* 0x0164 */    DWORD NumSupportedExtendedModes;
/* 0x0168 */    D3DDISPLAYMODE* pSupportedExtendedModes;
/* 0x016c */    ULONG ulUniqueAdapterGroupId;
/* 0x0170 */    DWORD NumSupportedQueries;
/* 0x0174 */    D3DQUERYTYPE* pSupportedQueriesList;
} D3D9_DRIVERCAPS, FAR *LPD3D9_DRIVERCAPS;

typedef struct _tagD3D9_CALLBACKS
{
/* 0x0000 */    DWORD DdCreateSurface;
/* 0x0004 */    DWORD DdDestroySurface;
/* 0x0008 */    DWORD DdLock;
/* 0x000c */    DWORD DdUnlock;
/* 0x0010 */    DWORD D3dContextCreate;
/* 0x0014 */    DWORD D3dContextDestroy;
/* 0x0018 */    DWORD unknown0100;
/* 0x001c */    DWORD unknown0101;
/* 0x0020 */    DWORD unknown0102;
/* 0x0024 */    DWORD D3dDrawPrimitives2;
/* 0x0028 */    DWORD DdGetDriverState;
/* 0x002c */    DWORD D3dValidateTextureStageState;
/* 0x0030 */    DWORD unknown0106;
/* 0x0034 */    DWORD unknown0107;
/* 0x0038 */    DWORD DdBlt;
/* 0x003c */    DWORD DdGetScanLine;
/* 0x0040 */    DWORD DdWaitForVerticalBlank;
/* 0x0044 */    DWORD DdFlip;
/* 0x0048 */    DWORD DdGetBltStatus;
/* 0x004c */    DWORD DdGetFlipStatus;
/* 0x0050 */    LPD3D9_GETAVAILDRIVERMEMORY DdGetAvailDriverMemory;
/* 0x0054 */    DWORD unknown0115;
/* 0x0058 */    DWORD DdSetMode;
/* 0x005c */    DWORD DdSetExclusiveMode;
/* 0x0060 */    DWORD DdFlipToGDISurface;
/* 0x0064 */    DWORD unknown0119;
/* 0x0068 */    DWORD unknown0120;
/* 0x006c */    DWORD unknown0121;
/* 0x0070 */    DWORD unknown0122;
/* 0x0074 */    DWORD unknown0123;
/* 0x0078 */    DWORD unknown0124;
/* 0x007c */    DWORD DXVAGetGuids;
/* 0x0080 */    DWORD DXVAGetCompressedBufferInfo;
/* 0x0084 */    DWORD DXVAGetUncompressedFormats;
/* 0x0088 */    DWORD DXVAGetInternalInfo;
/* 0x008c */    DWORD DXVACreate;
/* 0x0090 */    DWORD DXVADestroy;
/* 0x0094 */    DWORD DXVABeginFrame;
/* 0x0098 */    DWORD DXVAEndFrame;
/* 0x009c */    DWORD DXVAExecute;
/* 0x00a0 */    DWORD DXVAQueryStatus;
/* 0x00a4 */    D3DDEVTYPE DeviceType;
} D3D9_CALLBACKS;

typedef struct _D3D9_DEVICEDATA
{
/* 0x0000 */    D3D9_DRIVERCAPS DriverCaps;
/* 0x0178 */    D3D9_CALLBACKS D3D9Callbacks;
/* 0x0220 */    CHAR szDeviceName[CCHDEVICENAME];
/* 0x0240 */    HDC hDC;
/* 0x0244 */    GUID DisplayGuid;
/* 0x0254 */    struct _D3D9_Unknown6BC* pUnknown6BC;
/* 0x0258 */    D3DDEVTYPE DeviceType;
/* 0x025c */    HMODULE hD3DRefDll;
/* 0x0260 */    DWORD unknown0152;
} D3D9_DEVICEDATA, FAR *LPD3D9_DEVICEDATA;

typedef struct _Direct3D9DisplayAdapterInfo
{
/* 0x0000 */    GUID DisplayGuid;
/* 0x0010 */    CHAR szDeviceName[MAX_PATH];
/* 0x0114 */    DWORD dwStateFlags;
/* 0x0118 */    BOOL bInUseFlag;
/* 0x011c */    DWORD MasterAdapterIndex;
/* 0x0120 */    DWORD AdapterIndexInGroup;
/* 0x0124 */    DWORD NumAdaptersInGroup;
/* 0x0128 */    DWORD NumSupportedD3DFormats;
/* 0x012c */    DWORD NumSupportedD3DExtendedFormats;
/* 0x0130 */    D3DDISPLAYMODE* pSupportedD3DFormats;
/* 0x0134 */    D3DDISPLAYMODE* pSupportedD3DExtendedFormats;
/* 0x0138 */    D3DFORMAT Supported16bitFormat;
/* 0x013c */    D3D9_DRIVERCAPS DriverCaps;
/* 0x02b4 */    DWORD unknown000104;
/* 0x02b8 */    DWORD unknown000105;
} Direct3D9DisplayAdapterInfo, FAR* LPDIRECT3D9_DISPLAYADAPTER;

typedef struct _DIRECT3D9_INT
{
/* 0x0000 */    struct IDirect3D9Vtbl *lpVtbl; /* LPDIRECTD3D9 function table */
/* 0x0004 */    CRITICAL_SECTION d3d9_cs;
/* 0x001c */    DWORD unknown000007;    /* 0x00000001 */
/* 0x0020 */    DWORD dwProcessId;
/* 0x0024 */    struct _DIRECT3D9_INT *lpInt;
/* 0x0028 */    LONG lRefCnt;          /* Increases and decreases by AddRef() and Release() */
/* 0x002c */    UINT NumDisplayAdapters;
/* 0x0030 */    Direct3D9DisplayAdapterInfo DisplayAdapters[D3D9_INT_MAX_NUM_ADAPTERS];
/* 0x2100 */    DWORD unknown002112;
/* 0x2104 */    DWORD unknown002113;
/* 0x2108 */    DWORD unknown002114;
/* 0x210c */    DWORD unknown002115;
/* 0x2110 */    DWORD unknown002116;
/* 0x2114 */    DWORD unknown002117;
/* 0x2118 */    DWORD unknown002118;
/* 0x211c */    DWORD unknown002119;
/* 0x2120 */    DWORD unknown002120;
/* 0x2124 */    DWORD unknown002121;
/* 0x2128 */    DWORD unknown002122;
/* 0x212c */    DWORD unknown002123;
/* 0x2130 */    DWORD unknown002124;
/* 0x2134 */    DWORD unknown002125;
/* 0x2138 */    DWORD unknown002126;
/* 0x213c */    DWORD unknown002127;
/* 0x2140 */    DWORD unknown002128;
/* 0x2144 */    DWORD unknown002129;
/* 0x2148 */    DWORD unknown002130;
/* 0x214c */    DWORD unknown002131;
/* 0x2150 */    DWORD unknown002132;
/* 0x2154 */    DWORD unknown002133;
/* 0x2158 */    DWORD unknown002134;
/* 0x215c */    DWORD unknown002135;
/* 0x2160 */    DWORD unknown002136;
/* 0x2164 */    DWORD unknown002137;
/* 0x2168 */    DWORD unknown002138;
/* 0x216c */    DWORD unknown002139;
/* 0x2170 */    DWORD unknown002140;
/* 0x2174 */    DWORD unknown002141;
/* 0x2178 */    DWORD unknown002142;
/* 0x217c */    DWORD unknown002143;
/* 0x2180 */    DWORD unknown002144;
/* 0x2184 */    DWORD unknown002145;
/* 0x2188 */    DWORD unknown002146;
/* 0x218c */    DWORD unknown002147;
/* 0x2190 */    DWORD unknown002148;
/* 0x2194 */    DWORD unknown002149;
/* 0x2198 */    DWORD unknown002150;
/* 0x219c */    DWORD unknown002151;
/* 0x21a0 */    DWORD unknown002152;
/* 0x21a4 */    DWORD unknown002153;
/* 0x21a8 */    DWORD unknown002154;
/* 0x21ac */    DWORD unknown002155;
/* 0x21b0 */    DWORD unknown002156;
/* 0x21b4 */    DWORD unknown002157;
/* 0x21b8 */    DWORD unknown002158;
/* 0x21bc */    DWORD unknown002159;
/* 0x21c0 */    DWORD unknown002160;
/* 0x21c4 */    DWORD unknown002161;
/* 0x21c8 */    DWORD unknown002162;
/* 0x21cc */    DWORD unknown002163;
/* 0x21d0 */    DWORD unknown002164;
/* 0x21d4 */    DWORD unknown002165;
/* 0x21d8 */    DWORD unknown002166;
/* 0x21dc */    DWORD unknown002167;
/* 0x21e0 */    DWORD unknown002168;
/* 0x21e4 */    DWORD unknown002169;
/* 0x21e8 */    DWORD unknown002170;
/* 0x21ec */    DWORD unknown002171;
/* 0x21f0 */    DWORD unknown002172;
/* 0x21f4 */    DWORD unknown002173;
/* 0x21f8 */    DWORD unknown002174;
/* 0x21fc */    DWORD unknown002175;
/* 0x2200 */    DWORD unknown002176;
/* 0x2204 */    DWORD unknown002177;
/* 0x2208 */    DWORD unknown002178;
/* 0x220c */    DWORD unknown002179;
/* 0x2210 */    DWORD unknown002180;
/* 0x2214 */    DWORD unknown002181;
/* 0x2218 */    DWORD unknown002182;
/* 0x221c */    DWORD unknown002183;
/* 0x2220 */    DWORD unknown002184;
/* 0x2224 */    DWORD unknown002185;
/* 0x2228 */    DWORD unknown002186;
/* 0x222c */    DWORD unknown002187;
/* 0x2230 */    DWORD unknown002188;
/* 0x2234 */    DWORD unknown002189;
/* 0x2238 */    DWORD unknown002190;
/* 0x223c */    DWORD unknown002191;
/* 0x2240 */    DWORD unknown002192;
/* 0x2244 */    DWORD unknown002193;
/* 0x2248 */    DWORD unknown002194;
/* 0x224c */    DWORD unknown002195;
/* 0x2250 */    DWORD unknown002196;
/* 0x2254 */    DWORD unknown002197;
/* 0x2258 */    DWORD unknown002198;
/* 0x225c */    DWORD unknown002199;
/* 0x2260 */    DWORD unknown002200;
/* 0x2264 */    DWORD unknown002201;
/* 0x2268 */    DWORD unknown002202;
/* 0x226c */    DWORD unknown002203;
/* 0x2270 */    DWORD unknown002204;
/* 0x2274 */    DWORD unknown002205;
/* 0x2278 */    DWORD unknown002206;
/* 0x227c */    DWORD unknown002207;
/* 0x2280 */    DWORD unknown002208;
/* 0x2284 */    DWORD unknown002209;
/* 0x2288 */    DWORD NumSupportedRefFormatOps;
/* 0x228c */    LPDDSURFACEDESC pSupportedRefFormatOps;
/* 0x2290 */    DWORD unknown002212;
/* 0x2294 */    DWORD unknown002213;
/* 0x2298 */    DWORD unknown002214;
/* 0x229c */    DWORD unknown002215;
/* 0x22a0 */    DWORD unknown002216;
/* 0x22a4 */    DWORD unknown002217;
/* 0x22a8 */    DWORD unknown002218;
/* 0x22ac */    DWORD unknown002219;
/* 0x22b0 */    DWORD unknown002220;
/* 0x22b4 */    DWORD unknown002221;
/* 0x22b8 */    DWORD unknown002222;
/* 0x22bc */    DWORD unknown002223;
/* 0x22c0 */    DWORD unknown002224;
/* 0x22c4 */    DWORD unknown002225;
/* 0x22c8 */    DWORD unknown002226;
/* 0x22cc */    DWORD unknown002227;
/* 0x22d0 */    DWORD unknown002228;
/* 0x22d4 */    DWORD unknown002229;
/* 0x22d8 */    DWORD unknown002230;
/* 0x22dc */    DWORD unknown002231;
/* 0x22e0 */    DWORD unknown002232;
/* 0x22e4 */    DWORD unknown002233;
/* 0x22e8 */    DWORD unknown002234;
/* 0x22ec */    DWORD unknown002235;
/* 0x22f0 */    DWORD unknown002236;
/* 0x22f4 */    DWORD unknown002237;
/* 0x22f8 */    DWORD unknown002238;
/* 0x22fc */    DWORD unknown002239;
/* 0x2300 */    DWORD unknown002240;
/* 0x2304 */    DWORD unknown002241;
/* 0x2308 */    DWORD unknown002242;
/* 0x230c */    DWORD unknown002243;
/* 0x2310 */    DWORD unknown002244;
/* 0x2314 */    DWORD unknown002245;
/* 0x2318 */    DWORD unknown002246;
/* 0x231c */    DWORD unknown002247;
/* 0x2320 */    DWORD unknown002248;
/* 0x2324 */    DWORD unknown002249;
/* 0x2328 */    DWORD unknown002250;
/* 0x232c */    DWORD unknown002251;
/* 0x2330 */    DWORD unknown002252;
/* 0x2334 */    DWORD unknown002253;
/* 0x2338 */    DWORD unknown002254;
/* 0x233c */    DWORD unknown002255;
/* 0x2340 */    DWORD unknown002256;
/* 0x2344 */    DWORD unknown002257;
/* 0x2348 */    DWORD unknown002258;
/* 0x234c */    DWORD unknown002259;
/* 0x2350 */    DWORD unknown002260;
/* 0x2354 */    DWORD unknown002261;
/* 0x2358 */    DWORD unknown002262;
/* 0x235c */    DWORD unknown002263;
/* 0x2360 */    DWORD unknown002264;
/* 0x2364 */    DWORD unknown002265;
/* 0x2368 */    DWORD unknown002266;
/* 0x236c */    DWORD unknown002267;
/* 0x2370 */    DWORD unknown002268;
/* 0x2374 */    DWORD unknown002269;
/* 0x2378 */    DWORD unknown002270;
/* 0x237c */    DWORD unknown002271;
/* 0x2380 */    DWORD unknown002272;
/* 0x2384 */    DWORD unknown002273;
/* 0x2388 */    DWORD unknown002274;
/* 0x238c */    DWORD unknown002275;
/* 0x2390 */    DWORD unknown002276;
/* 0x2394 */    DWORD unknown002277;
/* 0x2398 */    DWORD unknown002278;
/* 0x239c */    DWORD unknown002279;
/* 0x23a0 */    DWORD unknown002280;
/* 0x23a4 */    DWORD unknown002281;
/* 0x23a8 */    DWORD unknown002282;
/* 0x23ac */    DWORD unknown002283;
/* 0x23b0 */    DWORD unknown002284;
/* 0x23b4 */    DWORD unknown002285;
/* 0x23b8 */    DWORD unknown002286;
/* 0x23bc */    DWORD unknown002287;
/* 0x23c0 */    DWORD unknown002288;
/* 0x23c4 */    DWORD unknown002289;
/* 0x23c8 */    DWORD unknown002290;
/* 0x23cc */    DWORD unknown002291;
/* 0x23d0 */    DWORD unknown002292;
/* 0x23d4 */    DWORD unknown002293;
/* 0x23d8 */    DWORD unknown002294;
/* 0x23dc */    DWORD unknown002295;
/* 0x23e0 */    DWORD unknown002296;
/* 0x23e4 */    DWORD unknown002297;
/* 0x23e8 */    DWORD unknown002298;
/* 0x23ec */    DWORD unknown002299;
/* 0x23f0 */    DWORD unknown002300;
/* 0x23f4 */    DWORD unknown002301;
/* 0x23f8 */    DWORD unknown002302;
/* 0x23fc */    DWORD unknown002303;
/* 0x2400 */    DWORD unknown002304;
/* 0x2404 */    DWORD unknown002305;
/* 0x2408 */    DWORD unknown002306;
/* 0x240c */    DWORD unknown002307;
/* 0x2410 */    DWORD unknown002308;
/* 0x2414 */    DWORD unknown002309;
/* 0x2418 */    DWORD unknown002310;
/* 0x241c */    DWORD unknown002311;
/* 0x2420 */    DWORD unknown002312;
/* 0x2424 */    DWORD unknown002313;
/* 0x2428 */    DWORD unknown002314;
/* 0x242c */    DWORD unknown002315;
/* 0x2430 */    DWORD unknown002316;
/* 0x2434 */    DWORD unknown002317;
/* 0x2438 */    DWORD unknown002318;
/* 0x243c */    DWORD unknown002319;
/* 0x2440 */    DWORD unknown002320;
/* 0x2444 */    DWORD unknown002321;
/* 0x2448 */    DWORD unknown002322;
/* 0x244c */    DWORD unknown002323;
/* 0x2450 */    DWORD unknown002324;
/* 0x2454 */    DWORD unknown002325;
/* 0x2458 */    DWORD unknown002326;
/* 0x245c */    DWORD unknown002327;
/* 0x2460 */    DWORD unknown002328;
/* 0x2464 */    DWORD unknown002329;
/* 0x2468 */    DWORD unknown002330;
/* 0x246c */    DWORD unknown002331;
/* 0x2470 */    DWORD unknown002332;
/* 0x2474 */    DWORD unknown002333;
/* 0x2478 */    DWORD unknown002334;
/* 0x247c */    DWORD unknown002335;
/* 0x2480 */    DWORD unknown002336;
/* 0x2484 */    DWORD unknown002337;
/* 0x2488 */    DWORD unknown002338;
/* 0x248c */    DWORD unknown002339;
/* 0x2490 */    DWORD unknown002340;
/* 0x2494 */    DWORD unknown002341;
/* 0x2498 */    DWORD unknown002342;
/* 0x249c */    DWORD unknown002343;
/* 0x24a0 */    DWORD unknown002344;
/* 0x24a4 */    DWORD unknown002345;
/* 0x24a8 */    DWORD unknown002346;
/* 0x24ac */    DWORD unknown002347;
/* 0x24b0 */    DWORD unknown002348;
/* 0x24b4 */    DWORD unknown002349;
/* 0x24b8 */    DWORD unknown002350;
/* 0x24bc */    DWORD unknown002351;
/* 0x24c0 */    DWORD unknown002352;
/* 0x24c4 */    DWORD unknown002353;
/* 0x24c8 */    DWORD unknown002354;
/* 0x24cc */    DWORD unknown002355;
/* 0x24d0 */    DWORD unknown002356;
/* 0x24d4 */    DWORD unknown002357;
/* 0x24d8 */    DWORD unknown002358;
/* 0x24dc */    DWORD unknown002359;
/* 0x24e0 */    DWORD unknown002360;
/* 0x24e4 */    DWORD unknown002361;
/* 0x24e8 */    DWORD unknown002362;
/* 0x24ec */    DWORD unknown002363;
/* 0x24f0 */    DWORD unknown002364;
/* 0x24f4 */    DWORD unknown002365;
/* 0x24f8 */    DWORD unknown002366;
/* 0x24fc */    DWORD unknown002367;
/* 0x2500 */    DWORD unknown002368;
/* 0x2504 */    DWORD unknown002369;
/* 0x2508 */    DWORD unknown002370;
/* 0x250c */    DWORD unknown002371;
/* 0x2510 */    DWORD unknown002372;
/* 0x2514 */    DWORD unknown002373;
/* 0x2518 */    DWORD unknown002374;
/* 0x251c */    DWORD unknown002375;
/* 0x2520 */    DWORD unknown002376;
/* 0x2524 */    DWORD unknown002377;
/* 0x2528 */    DWORD unknown002378;
/* 0x252c */    DWORD unknown002379;
/* 0x2530 */    DWORD unknown002380;
/* 0x2534 */    DWORD unknown002381;
/* 0x2538 */    DWORD unknown002382;
/* 0x253c */    DWORD unknown002383;
/* 0x2540 */    DWORD unknown002384;
/* 0x2544 */    DWORD unknown002385;
/* 0x2548 */    DWORD unknown002386;
/* 0x254c */    DWORD unknown002387;
/* 0x2550 */    DWORD unknown002388;
/* 0x2554 */    DWORD unknown002389;
/* 0x2558 */    DWORD unknown002390;
/* 0x255c */    DWORD unknown002391;
/* 0x2560 */    DWORD unknown002392;
/* 0x2564 */    DWORD unknown002393;
/* 0x2568 */    DWORD unknown002394;
/* 0x256c */    DWORD unknown002395;
/* 0x2570 */    DWORD unknown002396;
/* 0x2574 */    DWORD unknown002397;
/* 0x2578 */    DWORD unknown002398;
/* 0x257c */    DWORD unknown002399;
/* 0x2580 */    DWORD unknown002400;
/* 0x2584 */    DWORD unknown002401;
/* 0x2588 */    DWORD unknown002402;
/* 0x258c */    DWORD unknown002403;
/* 0x2590 */    DWORD unknown002404;
/* 0x2594 */    DWORD unknown002405;
/* 0x2598 */    DWORD unknown002406;
/* 0x259c */    DWORD unknown002407;
/* 0x25a0 */    DWORD unknown002408;
/* 0x25a4 */    DWORD unknown002409;
/* 0x25a8 */    DWORD unknown002410;
/* 0x25ac */    DWORD unknown002411;
/* 0x25b0 */    DWORD unknown002412;
/* 0x25b4 */    DWORD unknown002413;
/* 0x25b8 */    DWORD unknown002414;
/* 0x25bc */    DWORD unknown002415;
/* 0x25c0 */    DWORD unknown002416;
/* 0x25c4 */    DWORD unknown002417;
/* 0x25c8 */    DWORD unknown002418;
/* 0x25cc */    DWORD unknown002419;
/* 0x25d0 */    DWORD unknown002420;
/* 0x25d4 */    DWORD unknown002421;
/* 0x25d8 */    DWORD unknown002422;
/* 0x25dc */    DWORD unknown002423;
/* 0x25e0 */    DWORD unknown002424;
/* 0x25e4 */    DWORD unknown002425;
/* 0x25e8 */    DWORD unknown002426;
/* 0x25ec */    DWORD unknown002427;
/* 0x25f0 */    DWORD unknown002428;
/* 0x25f4 */    DWORD unknown002429;
/* 0x25f8 */    DWORD unknown002430;
/* 0x25fc */    DWORD unknown002431;
/* 0x2600 */    DWORD unknown002432;
/* 0x2604 */    DWORD unknown002433;
/* 0x2608 */    DWORD unknown002434;
/* 0x260c */    DWORD unknown002435;
/* 0x2610 */    DWORD unknown002436;
/* 0x2614 */    DWORD unknown002437;
/* 0x2618 */    DWORD unknown002438;
/* 0x261c */    DWORD unknown002439;
/* 0x2620 */    DWORD unknown002440;
/* 0x2624 */    DWORD unknown002441;
/* 0x2628 */    DWORD unknown002442;
/* 0x262c */    DWORD unknown002443;
/* 0x2630 */    DWORD unknown002444;
/* 0x2634 */    DWORD unknown002445;
/* 0x2638 */    DWORD unknown002446;
/* 0x263c */    DWORD unknown002447;
/* 0x2640 */    DWORD unknown002448;
/* 0x2644 */    DWORD unknown002449;
/* 0x2648 */    DWORD unknown002450;
/* 0x264c */    DWORD unknown002451;
/* 0x2650 */    DWORD unknown002452;
/* 0x2654 */    DWORD unknown002453;
/* 0x2658 */    DWORD unknown002454;
/* 0x265c */    DWORD unknown002455;
/* 0x2660 */    DWORD unknown002456;
/* 0x2664 */    DWORD unknown002457;
/* 0x2668 */    DWORD unknown002458;
/* 0x266c */    DWORD unknown002459;
/* 0x2670 */    DWORD unknown002460;
/* 0x2674 */    DWORD unknown002461;
/* 0x2678 */    DWORD unknown002462;
/* 0x267c */    DWORD unknown002463;
/* 0x2680 */    DWORD unknown002464;
/* 0x2684 */    DWORD unknown002465;
/* 0x2688 */    DWORD unknown002466;
/* 0x268c */    DWORD unknown002467;
/* 0x2690 */    DWORD unknown002468;
/* 0x2694 */    DWORD unknown002469;
/* 0x2698 */    DWORD unknown002470;
/* 0x269c */    DWORD unknown002471;
/* 0x26a0 */    DWORD unknown002472;
/* 0x26a4 */    DWORD unknown002473;
/* 0x26a8 */    DWORD unknown002474;
/* 0x26ac */    DWORD unknown002475;
/* 0x26b0 */    DWORD unknown002476;
/* 0x26b4 */    DWORD unknown002477;
/* 0x26b8 */    DWORD unknown002478;
/* 0x26bc */    DWORD unknown002479;
/* 0x26c0 */    DWORD unknown002480;
/* 0x26c4 */    DWORD unknown002481;
/* 0x26c8 */    DWORD unknown002482;
/* 0x26cc */    DWORD unknown002483;
/* 0x26d0 */    DWORD unknown002484;
/* 0x26d4 */    DWORD unknown002485;
/* 0x26d8 */    DWORD unknown002486;
/* 0x26dc */    DWORD unknown002487;
/* 0x26e0 */    DWORD unknown002488;
/* 0x26e4 */    DWORD unknown002489;
/* 0x26e8 */    DWORD unknown002490;
/* 0x26ec */    DWORD unknown002491;
/* 0x26f0 */    DWORD unknown002492;
/* 0x26f4 */    DWORD unknown002493;
/* 0x26f8 */    DWORD unknown002494;
/* 0x26fc */    DWORD unknown002495;
/* 0x2700 */    DWORD unknown002496;
/* 0x2704 */    DWORD unknown002497;
/* 0x2708 */    DWORD unknown002498;
/* 0x270c */    DWORD unknown002499;
/* 0x2710 */    DWORD unknown002500;
/* 0x2714 */    DWORD unknown002501;
/* 0x2718 */    DWORD unknown002502;
/* 0x271c */    DWORD unknown002503;
/* 0x2720 */    DWORD unknown002504;
/* 0x2724 */    DWORD unknown002505;
/* 0x2728 */    DWORD unknown002506;
/* 0x272c */    DWORD unknown002507;
/* 0x2730 */    DWORD unknown002508;
/* 0x2734 */    DWORD unknown002509;
/* 0x2738 */    DWORD unknown002510;
/* 0x273c */    DWORD unknown002511;
/* 0x2740 */    DWORD unknown002512;
/* 0x2744 */    DWORD unknown002513;
/* 0x2748 */    DWORD unknown002514;
/* 0x274c */    DWORD unknown002515;
/* 0x2750 */    DWORD unknown002516;
/* 0x2754 */    DWORD unknown002517;
/* 0x2758 */    DWORD unknown002518;
/* 0x275c */    DWORD unknown002519;
/* 0x2760 */    DWORD unknown002520;
/* 0x2764 */    DWORD unknown002521;
/* 0x2768 */    DWORD unknown002522;
/* 0x276c */    DWORD unknown002523;
/* 0x2770 */    DWORD unknown002524;
/* 0x2774 */    DWORD unknown002525;
/* 0x2778 */    DWORD unknown002526;
/* 0x277c */    DWORD unknown002527;
/* 0x2780 */    DWORD unknown002528;
/* 0x2784 */    DWORD unknown002529;
/* 0x2788 */    DWORD unknown002530;
/* 0x278c */    DWORD unknown002531;
/* 0x2790 */    DWORD unknown002532;
/* 0x2794 */    DWORD unknown002533;
/* 0x2798 */    DWORD unknown002534;
/* 0x279c */    DWORD unknown002535;
/* 0x27a0 */    DWORD unknown002536;
/* 0x27a4 */    DWORD unknown002537;
/* 0x27a8 */    DWORD unknown002538;
/* 0x27ac */    DWORD unknown002539;
/* 0x27b0 */    DWORD unknown002540;
/* 0x27b4 */    DWORD unknown002541;
/* 0x27b8 */    DWORD unknown002542;
/* 0x27bc */    DWORD unknown002543;
/* 0x27c0 */    DWORD unknown002544;
/* 0x27c4 */    DWORD unknown002545;
/* 0x27c8 */    DWORD unknown002546;
/* 0x27cc */    DWORD unknown002547;
/* 0x27d0 */    DWORD unknown002548;
/* 0x27d4 */    DWORD unknown002549;
/* 0x27d8 */    DWORD unknown002550;
/* 0x27dc */    DWORD unknown002551;
/* 0x27e0 */    DWORD unknown002552;
/* 0x27e4 */    DWORD unknown002553;
/* 0x27e8 */    DWORD unknown002554;
/* 0x27ec */    DWORD unknown002555;
/* 0x27f0 */    DWORD unknown002556;
/* 0x27f4 */    DWORD unknown002557;
/* 0x27f8 */    DWORD unknown002558;
/* 0x27fc */    DWORD unknown002559;
/* 0x2800 */    DWORD unknown002560;
/* 0x2804 */    DWORD unknown002561;
/* 0x2808 */    DWORD unknown002562;
/* 0x280c */    DWORD unknown002563;
/* 0x2810 */    DWORD unknown002564;
/* 0x2814 */    DWORD unknown002565;
/* 0x2818 */    DWORD unknown002566;
/* 0x281c */    DWORD unknown002567;
/* 0x2820 */    DWORD unknown002568;
/* 0x2824 */    DWORD unknown002569;
/* 0x2828 */    DWORD unknown002570;
/* 0x282c */    DWORD unknown002571;
/* 0x2830 */    DWORD unknown002572;
/* 0x2834 */    DWORD unknown002573;
/* 0x2838 */    DWORD unknown002574;
/* 0x283c */    DWORD unknown002575;
/* 0x2840 */    DWORD unknown002576;
/* 0x2844 */    DWORD unknown002577;
/* 0x2848 */    DWORD unknown002578;
/* 0x284c */    DWORD unknown002579;
/* 0x2850 */    DWORD unknown002580;
/* 0x2854 */    DWORD unknown002581;
/* 0x2858 */    DWORD unknown002582;
/* 0x285c */    DWORD unknown002583;
/* 0x2860 */    DWORD unknown002584;
/* 0x2864 */    DWORD unknown002585;
/* 0x2868 */    DWORD unknown002586;
/* 0x286c */    DWORD unknown002587;
/* 0x2870 */    DWORD unknown002588;
/* 0x2874 */    DWORD unknown002589;
/* 0x2878 */    DWORD unknown002590;
/* 0x287c */    DWORD unknown002591;
/* 0x2880 */    DWORD unknown002592;
/* 0x2884 */    DWORD unknown002593;
/* 0x2888 */    DWORD unknown002594;
/* 0x288c */    DWORD unknown002595;
/* 0x2890 */    DWORD unknown002596;
/* 0x2894 */    DWORD unknown002597;
/* 0x2898 */    DWORD unknown002598;
/* 0x289c */    DWORD unknown002599;
/* 0x28a0 */    DWORD unknown002600;
/* 0x28a4 */    DWORD unknown002601;
/* 0x28a8 */    DWORD unknown002602;
/* 0x28ac */    DWORD unknown002603;
/* 0x28b0 */    DWORD unknown002604;
/* 0x28b4 */    DWORD unknown002605;
/* 0x28b8 */    DWORD unknown002606;
/* 0x28bc */    DWORD unknown002607;
/* 0x28c0 */    DWORD unknown002608;
/* 0x28c4 */    DWORD unknown002609;
/* 0x28c8 */    DWORD unknown002610;
/* 0x28cc */    DWORD unknown002611;
/* 0x28d0 */    DWORD unknown002612;
/* 0x28d4 */    DWORD unknown002613;
/* 0x28d8 */    DWORD unknown002614;
/* 0x28dc */    DWORD unknown002615;
/* 0x28e0 */    DWORD unknown002616;
/* 0x28e4 */    DWORD unknown002617;
/* 0x28e8 */    DWORD unknown002618;
/* 0x28ec */    DWORD unknown002619;
/* 0x28f0 */    DWORD unknown002620;
/* 0x28f4 */    DWORD unknown002621;
/* 0x28f8 */    DWORD unknown002622;
/* 0x28fc */    DWORD unknown002623;
/* 0x2900 */    DWORD unknown002624;
/* 0x2904 */    DWORD unknown002625;
/* 0x2908 */    DWORD unknown002626;
/* 0x290c */    DWORD unknown002627;
/* 0x2910 */    DWORD unknown002628;
/* 0x2914 */    DWORD unknown002629;
/* 0x2918 */    DWORD unknown002630;
/* 0x291c */    DWORD unknown002631;
/* 0x2920 */    DWORD unknown002632;
/* 0x2924 */    DWORD unknown002633;
/* 0x2928 */    DWORD unknown002634;
/* 0x292c */    DWORD unknown002635;
/* 0x2930 */    DWORD unknown002636;
/* 0x2934 */    DWORD unknown002637;
/* 0x2938 */    DWORD unknown002638;
/* 0x293c */    DWORD unknown002639;
/* 0x2940 */    DWORD unknown002640;
/* 0x2944 */    DWORD unknown002641;
/* 0x2948 */    DWORD unknown002642;
/* 0x294c */    DWORD unknown002643;
/* 0x2950 */    DWORD unknown002644;
/* 0x2954 */    DWORD unknown002645;
/* 0x2958 */    DWORD unknown002646;
/* 0x295c */    DWORD unknown002647;
/* 0x2960 */    DWORD unknown002648;
/* 0x2964 */    DWORD unknown002649;
/* 0x2968 */    DWORD unknown002650;
/* 0x296c */    DWORD unknown002651;
/* 0x2970 */    DWORD unknown002652;
/* 0x2974 */    DWORD unknown002653;
/* 0x2978 */    DWORD unknown002654;
/* 0x297c */    DWORD unknown002655;
/* 0x2980 */    DWORD unknown002656;
/* 0x2984 */    DWORD unknown002657;
/* 0x2988 */    DWORD unknown002658;
/* 0x298c */    DWORD unknown002659;
/* 0x2990 */    DWORD unknown002660;
/* 0x2994 */    DWORD unknown002661;
/* 0x2998 */    DWORD unknown002662;
/* 0x299c */    DWORD unknown002663;
/* 0x29a0 */    DWORD unknown002664;
/* 0x29a4 */    DWORD unknown002665;
/* 0x29a8 */    DWORD unknown002666;
/* 0x29ac */    DWORD unknown002667;
/* 0x29b0 */    DWORD unknown002668;
/* 0x29b4 */    DWORD unknown002669;
/* 0x29b8 */    DWORD unknown002670;
/* 0x29bc */    DWORD unknown002671;
/* 0x29c0 */    DWORD unknown002672;
/* 0x29c4 */    DWORD unknown002673;
/* 0x29c8 */    DWORD unknown002674;
/* 0x29cc */    DWORD unknown002675;
/* 0x29d0 */    DWORD unknown002676;
/* 0x29d4 */    DWORD unknown002677;
/* 0x29d8 */    DWORD unknown002678;
/* 0x29dc */    DWORD unknown002679;
/* 0x29e0 */    DWORD unknown002680;
/* 0x29e4 */    DWORD unknown002681;
/* 0x29e8 */    DWORD unknown002682;
/* 0x29ec */    DWORD unknown002683;
/* 0x29f0 */    DWORD unknown002684;
/* 0x29f4 */    DWORD unknown002685;
/* 0x29f8 */    DWORD unknown002686;
/* 0x29fc */    DWORD unknown002687;
/* 0x2a00 */    DWORD unknown002688;
/* 0x2a04 */    DWORD unknown002689;
/* 0x2a08 */    DWORD unknown002690;
/* 0x2a0c */    DWORD unknown002691;
/* 0x2a10 */    DWORD unknown002692;
/* 0x2a14 */    DWORD unknown002693;
/* 0x2a18 */    DWORD unknown002694;
/* 0x2a1c */    DWORD unknown002695;
/* 0x2a20 */    DWORD unknown002696;
/* 0x2a24 */    DWORD unknown002697;
/* 0x2a28 */    DWORD unknown002698;
/* 0x2a2c */    DWORD unknown002699;
/* 0x2a30 */    DWORD unknown002700;
/* 0x2a34 */    DWORD unknown002701;
/* 0x2a38 */    DWORD unknown002702;
/* 0x2a3c */    DWORD unknown002703;
/* 0x2a40 */    DWORD unknown002704;
/* 0x2a44 */    DWORD unknown002705;
/* 0x2a48 */    DWORD unknown002706;
/* 0x2a4c */    DWORD unknown002707;
/* 0x2a50 */    DWORD unknown002708;
/* 0x2a54 */    DWORD unknown002709;
/* 0x2a58 */    DWORD unknown002710;
/* 0x2a5c */    DWORD unknown002711;
/* 0x2a60 */    DWORD unknown002712;
/* 0x2a64 */    DWORD unknown002713;
/* 0x2a68 */    DWORD unknown002714;
/* 0x2a6c */    DWORD unknown002715;
/* 0x2a70 */    DWORD unknown002716;
/* 0x2a74 */    DWORD unknown002717;
/* 0x2a78 */    DWORD unknown002718;
/* 0x2a7c */    DWORD unknown002719;
/* 0x2a80 */    DWORD unknown002720;
/* 0x2a84 */    DWORD unknown002721;
/* 0x2a88 */    DWORD unknown002722;
/* 0x2a8c */    DWORD unknown002723;
/* 0x2a90 */    DWORD unknown002724;
/* 0x2a94 */    DWORD unknown002725;
/* 0x2a98 */    DWORD unknown002726;
/* 0x2a9c */    DWORD unknown002727;
/* 0x2aa0 */    DWORD unknown002728;
/* 0x2aa4 */    DWORD unknown002729;
/* 0x2aa8 */    DWORD unknown002730;
/* 0x2aac */    DWORD unknown002731;
/* 0x2ab0 */    DWORD unknown002732;
/* 0x2ab4 */    DWORD unknown002733;
/* 0x2ab8 */    DWORD unknown002734;
/* 0x2abc */    DWORD unknown002735;
/* 0x2ac0 */    DWORD unknown002736;
/* 0x2ac4 */    DWORD unknown002737;
/* 0x2ac8 */    DWORD unknown002738;
/* 0x2acc */    DWORD unknown002739;
/* 0x2ad0 */    DWORD unknown002740;
/* 0x2ad4 */    DWORD unknown002741;
/* 0x2ad8 */    DWORD unknown002742;
/* 0x2adc */    DWORD unknown002743;
/* 0x2ae0 */    DWORD unknown002744;
/* 0x2ae4 */    DWORD unknown002745;
/* 0x2ae8 */    DWORD unknown002746;
/* 0x2aec */    DWORD unknown002747;
/* 0x2af0 */    DWORD unknown002748;
/* 0x2af4 */    DWORD unknown002749;
/* 0x2af8 */    DWORD unknown002750;
/* 0x2afc */    DWORD unknown002751;
/* 0x2b00 */    DWORD unknown002752;
/* 0x2b04 */    DWORD unknown002753;
/* 0x2b08 */    DWORD unknown002754;
/* 0x2b0c */    DWORD unknown002755;
/* 0x2b10 */    DWORD unknown002756;
/* 0x2b14 */    DWORD unknown002757;
/* 0x2b18 */    DWORD unknown002758;
/* 0x2b1c */    DWORD unknown002759;
/* 0x2b20 */    DWORD unknown002760;
/* 0x2b24 */    DWORD unknown002761;
/* 0x2b28 */    DWORD unknown002762;
/* 0x2b2c */    DWORD unknown002763;
/* 0x2b30 */    DWORD unknown002764;
/* 0x2b34 */    DWORD unknown002765;
/* 0x2b38 */    DWORD unknown002766;
/* 0x2b3c */    DWORD unknown002767;
/* 0x2b40 */    DWORD unknown002768;
/* 0x2b44 */    DWORD unknown002769;
/* 0x2b48 */    DWORD unknown002770;
/* 0x2b4c */    DWORD unknown002771;
/* 0x2b50 */    DWORD unknown002772;
/* 0x2b54 */    DWORD unknown002773;
/* 0x2b58 */    DWORD unknown002774;
/* 0x2b5c */    DWORD unknown002775;
/* 0x2b60 */    DWORD unknown002776;
/* 0x2b64 */    DWORD unknown002777;
/* 0x2b68 */    DWORD unknown002778;
/* 0x2b6c */    DWORD unknown002779;
/* 0x2b70 */    DWORD unknown002780;
/* 0x2b74 */    DWORD unknown002781;
/* 0x2b78 */    DWORD unknown002782;
/* 0x2b7c */    DWORD unknown002783;
/* 0x2b80 */    DWORD unknown002784;
/* 0x2b84 */    DWORD unknown002785;
/* 0x2b88 */    DWORD unknown002786;
/* 0x2b8c */    DWORD unknown002787;
/* 0x2b90 */    DWORD unknown002788;
/* 0x2b94 */    DWORD unknown002789;
/* 0x2b98 */    DWORD unknown002790;
/* 0x2b9c */    DWORD unknown002791;
/* 0x2ba0 */    DWORD unknown002792;
/* 0x2ba4 */    DWORD unknown002793;
/* 0x2ba8 */    DWORD unknown002794;
/* 0x2bac */    DWORD unknown002795;
/* 0x2bb0 */    DWORD unknown002796;
/* 0x2bb4 */    DWORD unknown002797;
/* 0x2bb8 */    DWORD unknown002798;
/* 0x2bbc */    DWORD unknown002799;
/* 0x2bc0 */    DWORD unknown002800;
/* 0x2bc4 */    DWORD unknown002801;
/* 0x2bc8 */    DWORD unknown002802;
/* 0x2bcc */    DWORD unknown002803;
/* 0x2bd0 */    DWORD unknown002804;
/* 0x2bd4 */    DWORD unknown002805;
/* 0x2bd8 */    DWORD unknown002806;
/* 0x2bdc */    DWORD unknown002807;
/* 0x2be0 */    DWORD unknown002808;
/* 0x2be4 */    DWORD unknown002809;
/* 0x2be8 */    DWORD unknown002810;
/* 0x2bec */    DWORD unknown002811;
/* 0x2bf0 */    DWORD unknown002812;
/* 0x2bf4 */    DWORD unknown002813;
/* 0x2bf8 */    DWORD unknown002814;
/* 0x2bfc */    DWORD unknown002815;
/* 0x2c00 */    DWORD unknown002816;
/* 0x2c04 */    DWORD unknown002817;
/* 0x2c08 */    DWORD unknown002818;
/* 0x2c0c */    DWORD unknown002819;
/* 0x2c10 */    DWORD unknown002820;
/* 0x2c14 */    DWORD unknown002821;
/* 0x2c18 */    DWORD unknown002822;
/* 0x2c1c */    DWORD unknown002823;
/* 0x2c20 */    DWORD unknown002824;
/* 0x2c24 */    DWORD unknown002825;
/* 0x2c28 */    DWORD unknown002826;
/* 0x2c2c */    DWORD unknown002827;
/* 0x2c30 */    DWORD unknown002828;
/* 0x2c34 */    DWORD unknown002829;
/* 0x2c38 */    DWORD unknown002830;
/* 0x2c3c */    DWORD unknown002831;
/* 0x2c40 */    DWORD unknown002832;
/* 0x2c44 */    DWORD unknown002833;
/* 0x2c48 */    DWORD unknown002834;
/* 0x2c4c */    DWORD unknown002835;
/* 0x2c50 */    DWORD unknown002836;
/* 0x2c54 */    DWORD unknown002837;
/* 0x2c58 */    DWORD unknown002838;
/* 0x2c5c */    DWORD unknown002839;
/* 0x2c60 */    DWORD unknown002840;
/* 0x2c64 */    DWORD unknown002841;
/* 0x2c68 */    DWORD unknown002842;
/* 0x2c6c */    DWORD unknown002843;
/* 0x2c70 */    DWORD unknown002844;
/* 0x2c74 */    DWORD unknown002845;
/* 0x2c78 */    DWORD unknown002846;
/* 0x2c7c */    DWORD unknown002847;
/* 0x2c80 */    DWORD unknown002848;
/* 0x2c84 */    DWORD unknown002849;
/* 0x2c88 */    DWORD unknown002850;
/* 0x2c8c */    DWORD unknown002851;
/* 0x2c90 */    DWORD unknown002852;
/* 0x2c94 */    DWORD unknown002853;
/* 0x2c98 */    DWORD unknown002854;
/* 0x2c9c */    DWORD unknown002855;
/* 0x2ca0 */    DWORD unknown002856;
/* 0x2ca4 */    DWORD unknown002857;
/* 0x2ca8 */    DWORD unknown002858;
/* 0x2cac */    DWORD unknown002859;
/* 0x2cb0 */    DWORD unknown002860;
/* 0x2cb4 */    DWORD unknown002861;
/* 0x2cb8 */    DWORD unknown002862;
/* 0x2cbc */    DWORD unknown002863;
/* 0x2cc0 */    DWORD unknown002864;
/* 0x2cc4 */    DWORD unknown002865;
/* 0x2cc8 */    DWORD unknown002866;
/* 0x2ccc */    DWORD unknown002867;
/* 0x2cd0 */    DWORD unknown002868;
/* 0x2cd4 */    DWORD unknown002869;
/* 0x2cd8 */    DWORD unknown002870;
/* 0x2cdc */    DWORD unknown002871;
/* 0x2ce0 */    DWORD unknown002872;
/* 0x2ce4 */    DWORD unknown002873;
/* 0x2ce8 */    DWORD unknown002874;
/* 0x2cec */    DWORD unknown002875;
/* 0x2cf0 */    DWORD unknown002876;
/* 0x2cf4 */    DWORD unknown002877;
/* 0x2cf8 */    DWORD unknown002878;
/* 0x2cfc */    DWORD unknown002879;
/* 0x2d00 */    DWORD unknown002880;
/* 0x2d04 */    DWORD unknown002881;
/* 0x2d08 */    DWORD unknown002882;
/* 0x2d0c */    DWORD unknown002883;
/* 0x2d10 */    DWORD unknown002884;
/* 0x2d14 */    DWORD unknown002885;
/* 0x2d18 */    DWORD unknown002886;
/* 0x2d1c */    DWORD unknown002887;
/* 0x2d20 */    DWORD unknown002888;
/* 0x2d24 */    DWORD unknown002889;
/* 0x2d28 */    DWORD unknown002890;
/* 0x2d2c */    DWORD unknown002891;
/* 0x2d30 */    DWORD unknown002892;
/* 0x2d34 */    DWORD unknown002893;
/* 0x2d38 */    DWORD unknown002894;
/* 0x2d3c */    DWORD unknown002895;
/* 0x2d40 */    DWORD unknown002896;
/* 0x2d44 */    DWORD unknown002897;
/* 0x2d48 */    DWORD unknown002898;
/* 0x2d4c */    DWORD unknown002899;
/* 0x2d50 */    DWORD unknown002900;
/* 0x2d54 */    DWORD unknown002901;
/* 0x2d58 */    DWORD unknown002902;
/* 0x2d5c */    DWORD unknown002903;
/* 0x2d60 */    DWORD unknown002904;
/* 0x2d64 */    DWORD unknown002905;
/* 0x2d68 */    DWORD unknown002906;
/* 0x2d6c */    DWORD unknown002907;
/* 0x2d70 */    DWORD unknown002908;
/* 0x2d74 */    DWORD unknown002909;
/* 0x2d78 */    DWORD unknown002910;
/* 0x2d7c */    DWORD unknown002911;
/* 0x2d80 */    DWORD unknown002912;
/* 0x2d84 */    DWORD unknown002913;
/* 0x2d88 */    DWORD unknown002914;
/* 0x2d8c */    DWORD unknown002915;
/* 0x2d90 */    DWORD unknown002916;
/* 0x2d94 */    DWORD unknown002917;
/* 0x2d98 */    DWORD unknown002918;
/* 0x2d9c */    DWORD unknown002919;
/* 0x2da0 */    DWORD unknown002920;
/* 0x2da4 */    DWORD unknown002921;
/* 0x2da8 */    DWORD unknown002922;
/* 0x2dac */    DWORD unknown002923;
/* 0x2db0 */    DWORD unknown002924;
/* 0x2db4 */    DWORD unknown002925;
/* 0x2db8 */    DWORD unknown002926;
/* 0x2dbc */    DWORD unknown002927;
/* 0x2dc0 */    DWORD unknown002928;
/* 0x2dc4 */    DWORD unknown002929;
/* 0x2dc8 */    DWORD unknown002930;
/* 0x2dcc */    DWORD unknown002931;
/* 0x2dd0 */    DWORD unknown002932;
/* 0x2dd4 */    DWORD unknown002933;
/* 0x2dd8 */    DWORD unknown002934;
/* 0x2ddc */    DWORD unknown002935;
/* 0x2de0 */    DWORD unknown002936;
/* 0x2de4 */    DWORD unknown002937;
/* 0x2de8 */    DWORD unknown002938;
/* 0x2dec */    DWORD unknown002939;
/* 0x2df0 */    DWORD unknown002940;
/* 0x2df4 */    DWORD unknown002941;
/* 0x2df8 */    DWORD unknown002942;
/* 0x2dfc */    DWORD unknown002943;
/* 0x2e00 */    DWORD unknown002944;
/* 0x2e04 */    DWORD unknown002945;
/* 0x2e08 */    DWORD unknown002946;
/* 0x2e0c */    DWORD unknown002947;
/* 0x2e10 */    DWORD unknown002948;
/* 0x2e14 */    DWORD unknown002949;
/* 0x2e18 */    DWORD unknown002950;
/* 0x2e1c */    DWORD unknown002951;
/* 0x2e20 */    DWORD unknown002952;
/* 0x2e24 */    DWORD unknown002953;
/* 0x2e28 */    DWORD unknown002954;
/* 0x2e2c */    DWORD unknown002955;
/* 0x2e30 */    DWORD unknown002956;
/* 0x2e34 */    DWORD unknown002957;
/* 0x2e38 */    DWORD unknown002958;
/* 0x2e3c */    DWORD unknown002959;
/* 0x2e40 */    DWORD unknown002960;
/* 0x2e44 */    DWORD unknown002961;
/* 0x2e48 */    DWORD unknown002962;
/* 0x2e4c */    DWORD unknown002963;
/* 0x2e50 */    DWORD unknown002964;
/* 0x2e54 */    DWORD unknown002965;
/* 0x2e58 */    DWORD unknown002966;
/* 0x2e5c */    DWORD unknown002967;
/* 0x2e60 */    DWORD unknown002968;
/* 0x2e64 */    DWORD unknown002969;
/* 0x2e68 */    DWORD unknown002970;
/* 0x2e6c */    DWORD unknown002971;
/* 0x2e70 */    DWORD unknown002972;
/* 0x2e74 */    DWORD unknown002973;
/* 0x2e78 */    DWORD unknown002974;
/* 0x2e7c */    DWORD unknown002975;
/* 0x2e80 */    DWORD unknown002976;
/* 0x2e84 */    DWORD unknown002977;
/* 0x2e88 */    DWORD unknown002978;
/* 0x2e8c */    DWORD unknown002979;
/* 0x2e90 */    DWORD unknown002980;
/* 0x2e94 */    DWORD unknown002981;
/* 0x2e98 */    DWORD unknown002982;
/* 0x2e9c */    DWORD unknown002983;
/* 0x2ea0 */    DWORD unknown002984;
/* 0x2ea4 */    DWORD unknown002985;
/* 0x2ea8 */    DWORD unknown002986;
/* 0x2eac */    DWORD unknown002987;
/* 0x2eb0 */    DWORD unknown002988;
/* 0x2eb4 */    DWORD unknown002989;
/* 0x2eb8 */    DWORD unknown002990;
/* 0x2ebc */    DWORD unknown002991;
/* 0x2ec0 */    DWORD unknown002992;
/* 0x2ec4 */    DWORD unknown002993;
/* 0x2ec8 */    DWORD unknown002994;
/* 0x2ecc */    DWORD unknown002995;
/* 0x2ed0 */    DWORD unknown002996;
/* 0x2ed4 */    DWORD unknown002997;
/* 0x2ed8 */    DWORD unknown002998;
/* 0x2edc */    DWORD unknown002999;
/* 0x2ee0 */    DWORD unknown003000;
/* 0x2ee4 */    DWORD unknown003001;
/* 0x2ee8 */    DWORD unknown003002;
/* 0x2eec */    DWORD unknown003003;
/* 0x2ef0 */    DWORD unknown003004;
/* 0x2ef4 */    DWORD unknown003005;
/* 0x2ef8 */    DWORD unknown003006;
/* 0x2efc */    DWORD unknown003007;
/* 0x2f00 */    DWORD unknown003008;
/* 0x2f04 */    DWORD unknown003009;
/* 0x2f08 */    DWORD unknown003010;
/* 0x2f0c */    DWORD unknown003011;
/* 0x2f10 */    DWORD unknown003012;
/* 0x2f14 */    DWORD unknown003013;
/* 0x2f18 */    DWORD unknown003014;
/* 0x2f1c */    DWORD unknown003015;
/* 0x2f20 */    DWORD unknown003016;
/* 0x2f24 */    DWORD unknown003017;
/* 0x2f28 */    DWORD unknown003018;
/* 0x2f2c */    DWORD unknown003019;
/* 0x2f30 */    DWORD unknown003020;
/* 0x2f34 */    DWORD unknown003021;
/* 0x2f38 */    DWORD unknown003022;
/* 0x2f3c */    DWORD unknown003023;
/* 0x2f40 */    DWORD unknown003024;
/* 0x2f44 */    DWORD unknown003025;
/* 0x2f48 */    DWORD unknown003026;
/* 0x2f4c */    DWORD unknown003027;
/* 0x2f50 */    DWORD unknown003028;
/* 0x2f54 */    DWORD unknown003029;
/* 0x2f58 */    DWORD unknown003030;
/* 0x2f5c */    DWORD unknown003031;
/* 0x2f60 */    DWORD unknown003032;
/* 0x2f64 */    DWORD unknown003033;
/* 0x2f68 */    DWORD unknown003034;
/* 0x2f6c */    DWORD unknown003035;
/* 0x2f70 */    DWORD unknown003036;
/* 0x2f74 */    DWORD unknown003037;
/* 0x2f78 */    DWORD unknown003038;
/* 0x2f7c */    DWORD unknown003039;
/* 0x2f80 */    DWORD unknown003040;
/* 0x2f84 */    DWORD unknown003041;
/* 0x2f88 */    DWORD unknown003042;
/* 0x2f8c */    DWORD unknown003043;
/* 0x2f90 */    DWORD unknown003044;
/* 0x2f94 */    DWORD unknown003045;
/* 0x2f98 */    DWORD unknown003046;
/* 0x2f9c */    DWORD unknown003047;
/* 0x2fa0 */    DWORD unknown003048;
/* 0x2fa4 */    DWORD unknown003049;
/* 0x2fa8 */    DWORD unknown003050;
/* 0x2fac */    DWORD unknown003051;
/* 0x2fb0 */    DWORD unknown003052;
/* 0x2fb4 */    DWORD unknown003053;
/* 0x2fb8 */    DWORD unknown003054;
/* 0x2fbc */    DWORD unknown003055;
/* 0x2fc0 */    DWORD unknown003056;
/* 0x2fc4 */    DWORD unknown003057;
/* 0x2fc8 */    DWORD unknown003058;
/* 0x2fcc */    DWORD unknown003059;
/* 0x2fd0 */    DWORD unknown003060;
/* 0x2fd4 */    DWORD unknown003061;
/* 0x2fd8 */    DWORD unknown003062;
/* 0x2fdc */    DWORD unknown003063;
/* 0x2fe0 */    DWORD unknown003064;
/* 0x2fe4 */    DWORD unknown003065;
/* 0x2fe8 */    DWORD unknown003066;
/* 0x2fec */    DWORD unknown003067;
/* 0x2ff0 */    DWORD unknown003068;
/* 0x2ff4 */    DWORD unknown003069;
/* 0x2ff8 */    DWORD unknown003070;
/* 0x2ffc */    DWORD unknown003071;
/* 0x3000 */    DWORD unknown003072;
/* 0x3004 */    DWORD unknown003073;
/* 0x3008 */    DWORD unknown003074;
/* 0x300c */    DWORD unknown003075;
/* 0x3010 */    DWORD unknown003076;
/* 0x3014 */    DWORD unknown003077;
/* 0x3018 */    DWORD unknown003078;
/* 0x301c */    DWORD unknown003079;
/* 0x3020 */    DWORD unknown003080;
/* 0x3024 */    DWORD unknown003081;
/* 0x3028 */    DWORD unknown003082;
/* 0x302c */    DWORD unknown003083;
/* 0x3030 */    DWORD unknown003084;
/* 0x3034 */    DWORD unknown003085;
/* 0x3038 */    DWORD unknown003086;
/* 0x303c */    DWORD unknown003087;
/* 0x3040 */    DWORD unknown003088;
/* 0x3044 */    DWORD unknown003089;
/* 0x3048 */    DWORD unknown003090;
/* 0x304c */    DWORD unknown003091;
/* 0x3050 */    DWORD unknown003092;
/* 0x3054 */    DWORD unknown003093;
/* 0x3058 */    DWORD unknown003094;
/* 0x305c */    DWORD unknown003095;
/* 0x3060 */    DWORD unknown003096;
/* 0x3064 */    DWORD unknown003097;
/* 0x3068 */    DWORD unknown003098;
/* 0x306c */    DWORD unknown003099;
/* 0x3070 */    DWORD unknown003100;
/* 0x3074 */    DWORD unknown003101;
/* 0x3078 */    DWORD unknown003102;
/* 0x307c */    DWORD unknown003103;
/* 0x3080 */    DWORD unknown003104;
/* 0x3084 */    DWORD unknown003105;
/* 0x3088 */    DWORD unknown003106;
/* 0x308c */    DWORD unknown003107;
/* 0x3090 */    DWORD unknown003108;
/* 0x3094 */    DWORD unknown003109;
/* 0x3098 */    DWORD unknown003110;
/* 0x309c */    DWORD unknown003111;
/* 0x30a0 */    DWORD unknown003112;
/* 0x30a4 */    DWORD unknown003113;
/* 0x30a8 */    DWORD unknown003114;
/* 0x30ac */    DWORD unknown003115;
/* 0x30b0 */    DWORD unknown003116;
/* 0x30b4 */    DWORD unknown003117;
/* 0x30b8 */    DWORD unknown003118;
/* 0x30bc */    DWORD unknown003119;
/* 0x30c0 */    DWORD unknown003120;
/* 0x30c4 */    DWORD unknown003121;
/* 0x30c8 */    DWORD unknown003122;
/* 0x30cc */    DWORD unknown003123;
/* 0x30d0 */    DWORD unknown003124;
/* 0x30d4 */    DWORD unknown003125;
/* 0x30d8 */    DWORD unknown003126;
/* 0x30dc */    DWORD unknown003127;
/* 0x30e0 */    DWORD unknown003128;
/* 0x30e4 */    DWORD unknown003129;
/* 0x30e8 */    DWORD unknown003130;
/* 0x30ec */    DWORD unknown003131;
/* 0x30f0 */    DWORD unknown003132;
/* 0x30f4 */    DWORD unknown003133;
/* 0x30f8 */    DWORD unknown003134;
/* 0x30fc */    DWORD unknown003135;
/* 0x3100 */    DWORD unknown003136;
/* 0x3104 */    DWORD unknown003137;
/* 0x3108 */    DWORD unknown003138;
/* 0x310c */    DWORD unknown003139;
/* 0x3110 */    DWORD unknown003140;
/* 0x3114 */    DWORD unknown003141;
/* 0x3118 */    DWORD unknown003142;
/* 0x311c */    DWORD unknown003143;
/* 0x3120 */    DWORD unknown003144;
/* 0x3124 */    DWORD unknown003145;
/* 0x3128 */    DWORD unknown003146;
/* 0x312c */    DWORD unknown003147;
/* 0x3130 */    DWORD unknown003148;
/* 0x3134 */    DWORD unknown003149;
/* 0x3138 */    DWORD unknown003150;
/* 0x313c */    DWORD unknown003151;
/* 0x3140 */    DWORD unknown003152;
/* 0x3144 */    DWORD unknown003153;
/* 0x3148 */    DWORD unknown003154;
/* 0x314c */    DWORD unknown003155;
/* 0x3150 */    DWORD unknown003156;
/* 0x3154 */    DWORD unknown003157;
/* 0x3158 */    DWORD unknown003158;
/* 0x315c */    DWORD unknown003159;
/* 0x3160 */    DWORD unknown003160;
/* 0x3164 */    DWORD unknown003161;
/* 0x3168 */    DWORD unknown003162;
/* 0x316c */    DWORD unknown003163;
/* 0x3170 */    DWORD unknown003164;
/* 0x3174 */    DWORD unknown003165;
/* 0x3178 */    DWORD unknown003166;
/* 0x317c */    DWORD unknown003167;
/* 0x3180 */    DWORD unknown003168;
/* 0x3184 */    DWORD unknown003169;
/* 0x3188 */    DWORD unknown003170;
/* 0x318c */    DWORD unknown003171;
/* 0x3190 */    DWORD unknown003172;
/* 0x3194 */    DWORD unknown003173;
/* 0x3198 */    DWORD unknown003174;
/* 0x319c */    DWORD unknown003175;
/* 0x31a0 */    DWORD unknown003176;
/* 0x31a4 */    DWORD unknown003177;
/* 0x31a8 */    DWORD unknown003178;
/* 0x31ac */    DWORD unknown003179;
/* 0x31b0 */    DWORD unknown003180;
/* 0x31b4 */    DWORD unknown003181;
/* 0x31b8 */    DWORD unknown003182;
/* 0x31bc */    DWORD unknown003183;
/* 0x31c0 */    DWORD unknown003184;
/* 0x31c4 */    DWORD unknown003185;
/* 0x31c8 */    DWORD unknown003186;
/* 0x31cc */    DWORD unknown003187;
/* 0x31d0 */    DWORD unknown003188;
/* 0x31d4 */    DWORD unknown003189;
/* 0x31d8 */    DWORD unknown003190;
/* 0x31dc */    DWORD unknown003191;
/* 0x31e0 */    DWORD unknown003192;
/* 0x31e4 */    DWORD unknown003193;
/* 0x31e8 */    DWORD unknown003194;
/* 0x31ec */    DWORD unknown003195;
/* 0x31f0 */    DWORD unknown003196;
/* 0x31f4 */    DWORD unknown003197;
/* 0x31f8 */    DWORD unknown003198;
/* 0x31fc */    DWORD unknown003199;
/* 0x3200 */    DWORD unknown003200;
/* 0x3204 */    DWORD unknown003201;
/* 0x3208 */    DWORD unknown003202;
/* 0x320c */    DWORD unknown003203;
/* 0x3210 */    DWORD unknown003204;
/* 0x3214 */    DWORD unknown003205;
/* 0x3218 */    DWORD unknown003206;
/* 0x321c */    DWORD unknown003207;
/* 0x3220 */    DWORD unknown003208;
/* 0x3224 */    DWORD unknown003209;
/* 0x3228 */    DWORD unknown003210;
/* 0x322c */    DWORD unknown003211;
/* 0x3230 */    DWORD unknown003212;
/* 0x3234 */    DWORD unknown003213;
/* 0x3238 */    DWORD unknown003214;
/* 0x323c */    DWORD unknown003215;
/* 0x3240 */    DWORD unknown003216;
/* 0x3244 */    DWORD unknown003217;
/* 0x3248 */    DWORD unknown003218;
/* 0x324c */    DWORD unknown003219;
/* 0x3250 */    DWORD unknown003220;
/* 0x3254 */    DWORD unknown003221;
/* 0x3258 */    DWORD unknown003222;
/* 0x325c */    DWORD unknown003223;
/* 0x3260 */    DWORD unknown003224;
/* 0x3264 */    DWORD unknown003225;
/* 0x3268 */    DWORD unknown003226;
/* 0x326c */    DWORD unknown003227;
/* 0x3270 */    DWORD unknown003228;
/* 0x3274 */    DWORD unknown003229;
/* 0x3278 */    DWORD unknown003230;
/* 0x327c */    DWORD unknown003231;
/* 0x3280 */    DWORD unknown003232;
/* 0x3284 */    DWORD unknown003233;
/* 0x3288 */    DWORD unknown003234;
/* 0x328c */    DWORD unknown003235;
/* 0x3290 */    DWORD unknown003236;
/* 0x3294 */    DWORD unknown003237;
/* 0x3298 */    DWORD unknown003238;
/* 0x329c */    DWORD unknown003239;
/* 0x32a0 */    DWORD unknown003240;
/* 0x32a4 */    DWORD unknown003241;
/* 0x32a8 */    DWORD unknown003242;
/* 0x32ac */    DWORD unknown003243;
/* 0x32b0 */    DWORD unknown003244;
/* 0x32b4 */    DWORD unknown003245;
/* 0x32b8 */    DWORD unknown003246;
/* 0x32bc */    DWORD unknown003247;
/* 0x32c0 */    DWORD unknown003248;
/* 0x32c4 */    DWORD unknown003249;
/* 0x32c8 */    DWORD unknown003250;
/* 0x32cc */    DWORD unknown003251;
/* 0x32d0 */    DWORD unknown003252;
/* 0x32d4 */    DWORD unknown003253;
/* 0x32d8 */    DWORD unknown003254;
/* 0x32dc */    DWORD unknown003255;
/* 0x32e0 */    DWORD unknown003256;
/* 0x32e4 */    DWORD unknown003257;
/* 0x32e8 */    DWORD unknown003258;
/* 0x32ec */    DWORD unknown003259;
/* 0x32f0 */    DWORD unknown003260;
/* 0x32f4 */    DWORD unknown003261;
/* 0x32f8 */    DWORD unknown003262;
/* 0x32fc */    DWORD unknown003263;
/* 0x3300 */    DWORD unknown003264;
/* 0x3304 */    DWORD unknown003265;
/* 0x3308 */    DWORD unknown003266;
/* 0x330c */    DWORD unknown003267;
/* 0x3310 */    DWORD unknown003268;
/* 0x3314 */    DWORD unknown003269;
/* 0x3318 */    DWORD unknown003270;
/* 0x331c */    DWORD unknown003271;
/* 0x3320 */    DWORD unknown003272;
/* 0x3324 */    DWORD unknown003273;
/* 0x3328 */    DWORD NumSupportedSoftwareFormatOps;
/* 0x332c */    LPDDSURFACEDESC pSupportedSoftwareFormatOps;
/* 0x3330 */    DWORD unknown003276;
/* 0x3334 */    DWORD unknown003277;
/* 0x3338 */    DWORD unknown003278;
/* 0x333c */    DWORD unknown003279;
/* 0x3340 */    DWORD unknown003280;
/* 0x3344 */    DWORD unknown003281;
/* 0x3348 */    DWORD unknown003282;
/* 0x334c */    DWORD unknown003283;
/* 0x3350 */    DWORD unknown003284;
/* 0x3354 */    DWORD unknown003285;
/* 0x3358 */    DWORD unknown003286;
/* 0x335c */    DWORD unknown003287;
/* 0x3360 */    DWORD unknown003288;
/* 0x3364 */    DWORD unknown003289;
/* 0x3368 */    DWORD unknown003290;
/* 0x336c */    DWORD unknown003291;
/* 0x3370 */    DWORD unknown003292;
/* 0x3374 */    DWORD unknown003293;
/* 0x3378 */    DWORD unknown003294;
/* 0x337c */    DWORD unknown003295;
/* 0x3380 */    DWORD unknown003296;
/* 0x3384 */    DWORD unknown003297;
/* 0x3388 */    DWORD unknown003298;
/* 0x338c */    DWORD unknown003299;
/* 0x3390 */    DWORD unknown003300;
/* 0x3394 */    DWORD unknown003301;
/* 0x3398 */    DWORD unknown003302;
/* 0x339c */    DWORD unknown003303;
/* 0x33a0 */    DWORD unknown003304;
/* 0x33a4 */    DWORD unknown003305;
/* 0x33a8 */    DWORD unknown003306;
/* 0x33ac */    DWORD unknown003307;
/* 0x33b0 */    DWORD unknown003308;
/* 0x33b4 */    DWORD unknown003309;
/* 0x33b8 */    DWORD unknown003310;
/* 0x33bc */    DWORD unknown003311;
/* 0x33c0 */    DWORD unknown003312;
/* 0x33c4 */    DWORD unknown003313;
/* 0x33c8 */    DWORD unknown003314;
/* 0x33cc */    DWORD unknown003315;
/* 0x33d0 */    DWORD unknown003316;
/* 0x33d4 */    DWORD unknown003317;
/* 0x33d8 */    DWORD unknown003318;
/* 0x33dc */    DWORD unknown003319;
/* 0x33e0 */    DWORD unknown003320;
/* 0x33e4 */    DWORD unknown003321;
/* 0x33e8 */    DWORD unknown003322;
/* 0x33ec */    DWORD unknown003323;
/* 0x33f0 */    DWORD unknown003324;
/* 0x33f4 */    DWORD unknown003325;
/* 0x33f8 */    DWORD unknown003326;
/* 0x33fc */    DWORD unknown003327;
/* 0x3400 */    DWORD unknown003328;
/* 0x3404 */    DWORD unknown003329;
/* 0x3408 */    DWORD unknown003330;
/* 0x340c */    DWORD unknown003331;
/* 0x3410 */    DWORD unknown003332;
/* 0x3414 */    DWORD unknown003333;
/* 0x3418 */    DWORD unknown003334;
/* 0x341c */    DWORD unknown003335;
/* 0x3420 */    DWORD unknown003336;
/* 0x3424 */    DWORD unknown003337;
/* 0x3428 */    DWORD unknown003338;
/* 0x342c */    DWORD unknown003339;
/* 0x3430 */    DWORD unknown003340;
/* 0x3434 */    DWORD unknown003341;
/* 0x3438 */    DWORD unknown003342;
/* 0x343c */    DWORD unknown003343;
/* 0x3440 */    DWORD unknown003344;
/* 0x3444 */    DWORD unknown003345;
/* 0x3448 */    DWORD unknown003346;
/* 0x344c */    DWORD unknown003347;
/* 0x3450 */    DWORD unknown003348;
/* 0x3454 */    DWORD unknown003349;
/* 0x3458 */    DWORD unknown003350;
/* 0x345c */    DWORD unknown003351;
/* 0x3460 */    DWORD unknown003352;
/* 0x3464 */    DWORD unknown003353;
/* 0x3468 */    DWORD unknown003354;
/* 0x346c */    DWORD unknown003355;
/* 0x3470 */    DWORD unknown003356;
/* 0x3474 */    DWORD unknown003357;
/* 0x3478 */    DWORD unknown003358;
/* 0x347c */    DWORD unknown003359;
/* 0x3480 */    DWORD unknown003360;
/* 0x3484 */    DWORD unknown003361;
/* 0x3488 */    DWORD unknown003362;
/* 0x348c */    DWORD unknown003363;
/* 0x3490 */    DWORD unknown003364;
/* 0x3494 */    DWORD unknown003365;
/* 0x3498 */    DWORD unknown003366;
/* 0x349c */    DWORD unknown003367;
/* 0x34a0 */    DWORD unknown003368;
/* 0x34a4 */    DWORD unknown003369;
/* 0x34a8 */    DWORD unknown003370;
/* 0x34ac */    DWORD unknown003371;
/* 0x34b0 */    DWORD unknown003372;
/* 0x34b4 */    DWORD unknown003373;
/* 0x34b8 */    DWORD unknown003374;
/* 0x34bc */    DWORD unknown003375;
/* 0x34c0 */    DWORD unknown003376;
/* 0x34c4 */    DWORD unknown003377;
/* 0x34c8 */    DWORD unknown003378;
/* 0x34cc */    DWORD unknown003379;
/* 0x34d0 */    DWORD unknown003380;
/* 0x34d4 */    DWORD unknown003381;
/* 0x34d8 */    DWORD unknown003382;
/* 0x34dc */    DWORD unknown003383;
/* 0x34e0 */    DWORD unknown003384;
/* 0x34e4 */    DWORD unknown003385;
/* 0x34e8 */    DWORD unknown003386;
/* 0x34ec */    DWORD unknown003387;
/* 0x34f0 */    DWORD unknown003388;
/* 0x34f4 */    DWORD unknown003389;
/* 0x34f8 */    DWORD unknown003390;
/* 0x34fc */    DWORD unknown003391;
/* 0x3500 */    DWORD unknown003392;
/* 0x3504 */    DWORD unknown003393;
/* 0x3508 */    DWORD unknown003394;
/* 0x350c */    DWORD unknown003395;
/* 0x3510 */    DWORD unknown003396;
/* 0x3514 */    DWORD unknown003397;
/* 0x3518 */    DWORD unknown003398;
/* 0x351c */    DWORD unknown003399;
/* 0x3520 */    DWORD unknown003400;
/* 0x3524 */    DWORD unknown003401;
/* 0x3528 */    DWORD unknown003402;
/* 0x352c */    DWORD unknown003403;
/* 0x3530 */    DWORD unknown003404;
/* 0x3534 */    DWORD unknown003405;
/* 0x3538 */    DWORD unknown003406;
/* 0x353c */    DWORD unknown003407;
/* 0x3540 */    DWORD unknown003408;
/* 0x3544 */    DWORD unknown003409;
/* 0x3548 */    DWORD unknown003410;
/* 0x354c */    DWORD unknown003411;
/* 0x3550 */    DWORD unknown003412;
/* 0x3554 */    DWORD unknown003413;
/* 0x3558 */    DWORD unknown003414;
/* 0x355c */    DWORD unknown003415;
/* 0x3560 */    DWORD unknown003416;
/* 0x3564 */    DWORD unknown003417;
/* 0x3568 */    DWORD unknown003418;
/* 0x356c */    DWORD unknown003419;
/* 0x3570 */    DWORD unknown003420;
/* 0x3574 */    DWORD unknown003421;
/* 0x3578 */    DWORD unknown003422;
/* 0x357c */    DWORD unknown003423;
/* 0x3580 */    DWORD unknown003424;
/* 0x3584 */    DWORD unknown003425;
/* 0x3588 */    DWORD unknown003426;
/* 0x358c */    DWORD unknown003427;
/* 0x3590 */    DWORD unknown003428;
/* 0x3594 */    DWORD unknown003429;
/* 0x3598 */    DWORD unknown003430;
/* 0x359c */    DWORD unknown003431;
/* 0x35a0 */    DWORD unknown003432;
/* 0x35a4 */    DWORD unknown003433;
/* 0x35a8 */    DWORD unknown003434;
/* 0x35ac */    DWORD unknown003435;
/* 0x35b0 */    DWORD unknown003436;
/* 0x35b4 */    DWORD unknown003437;
/* 0x35b8 */    DWORD unknown003438;
/* 0x35bc */    DWORD unknown003439;
/* 0x35c0 */    DWORD unknown003440;
/* 0x35c4 */    DWORD unknown003441;
/* 0x35c8 */    DWORD unknown003442;
/* 0x35cc */    DWORD unknown003443;
/* 0x35d0 */    DWORD unknown003444;
/* 0x35d4 */    DWORD unknown003445;
/* 0x35d8 */    DWORD unknown003446;
/* 0x35dc */    DWORD unknown003447;
/* 0x35e0 */    DWORD unknown003448;
/* 0x35e4 */    DWORD unknown003449;
/* 0x35e8 */    DWORD unknown003450;
/* 0x35ec */    DWORD unknown003451;
/* 0x35f0 */    DWORD unknown003452;
/* 0x35f4 */    DWORD unknown003453;
/* 0x35f8 */    DWORD unknown003454;
/* 0x35fc */    DWORD unknown003455;
/* 0x3600 */    DWORD unknown003456;
/* 0x3604 */    DWORD unknown003457;
/* 0x3608 */    DWORD unknown003458;
/* 0x360c */    DWORD unknown003459;
/* 0x3610 */    DWORD unknown003460;
/* 0x3614 */    DWORD unknown003461;
/* 0x3618 */    DWORD unknown003462;
/* 0x361c */    DWORD unknown003463;
/* 0x3620 */    DWORD unknown003464;
/* 0x3624 */    DWORD unknown003465;
/* 0x3628 */    DWORD unknown003466;
/* 0x362c */    DWORD unknown003467;
/* 0x3630 */    DWORD unknown003468;
/* 0x3634 */    DWORD unknown003469;
/* 0x3638 */    DWORD unknown003470;
/* 0x363c */    DWORD unknown003471;
/* 0x3640 */    DWORD unknown003472;
/* 0x3644 */    DWORD unknown003473;
/* 0x3648 */    DWORD unknown003474;
/* 0x364c */    DWORD unknown003475;
/* 0x3650 */    DWORD unknown003476;
/* 0x3654 */    DWORD unknown003477;
/* 0x3658 */    DWORD unknown003478;
/* 0x365c */    DWORD unknown003479;
/* 0x3660 */    DWORD unknown003480;
/* 0x3664 */    DWORD unknown003481;
/* 0x3668 */    DWORD unknown003482;
/* 0x366c */    DWORD unknown003483;
/* 0x3670 */    DWORD unknown003484;
/* 0x3674 */    DWORD unknown003485;
/* 0x3678 */    DWORD unknown003486;
/* 0x367c */    DWORD unknown003487;
/* 0x3680 */    DWORD unknown003488;
/* 0x3684 */    DWORD unknown003489;
/* 0x3688 */    DWORD unknown003490;
/* 0x368c */    DWORD unknown003491;
/* 0x3690 */    DWORD unknown003492;
/* 0x3694 */    DWORD unknown003493;
/* 0x3698 */    DWORD unknown003494;
/* 0x369c */    DWORD unknown003495;
/* 0x36a0 */    DWORD unknown003496;
/* 0x36a4 */    DWORD unknown003497;
/* 0x36a8 */    DWORD unknown003498;
/* 0x36ac */    DWORD unknown003499;
/* 0x36b0 */    DWORD unknown003500;
/* 0x36b4 */    DWORD unknown003501;
/* 0x36b8 */    DWORD unknown003502;
/* 0x36bc */    DWORD unknown003503;
/* 0x36c0 */    DWORD unknown003504;
/* 0x36c4 */    DWORD unknown003505;
/* 0x36c8 */    DWORD unknown003506;
/* 0x36cc */    DWORD unknown003507;
/* 0x36d0 */    DWORD unknown003508;
/* 0x36d4 */    DWORD unknown003509;
/* 0x36d8 */    DWORD unknown003510;
/* 0x36dc */    DWORD unknown003511;
/* 0x36e0 */    DWORD unknown003512;
/* 0x36e4 */    DWORD unknown003513;
/* 0x36e8 */    DWORD unknown003514;
/* 0x36ec */    DWORD unknown003515;
/* 0x36f0 */    DWORD unknown003516;
/* 0x36f4 */    DWORD unknown003517;
/* 0x36f8 */    DWORD unknown003518;
/* 0x36fc */    DWORD unknown003519;
/* 0x3700 */    DWORD unknown003520;
/* 0x3704 */    DWORD unknown003521;
/* 0x3708 */    DWORD unknown003522;
/* 0x370c */    DWORD unknown003523;
/* 0x3710 */    DWORD unknown003524;
/* 0x3714 */    DWORD unknown003525;
/* 0x3718 */    DWORD unknown003526;
/* 0x371c */    DWORD unknown003527;
/* 0x3720 */    DWORD unknown003528;
/* 0x3724 */    DWORD unknown003529;
/* 0x3728 */    DWORD unknown003530;
/* 0x372c */    DWORD unknown003531;
/* 0x3730 */    DWORD unknown003532;
/* 0x3734 */    DWORD unknown003533;
/* 0x3738 */    DWORD unknown003534;
/* 0x373c */    DWORD unknown003535;
/* 0x3740 */    DWORD unknown003536;
/* 0x3744 */    DWORD unknown003537;
/* 0x3748 */    DWORD unknown003538;
/* 0x374c */    DWORD unknown003539;
/* 0x3750 */    DWORD unknown003540;
/* 0x3754 */    DWORD unknown003541;
/* 0x3758 */    DWORD unknown003542;
/* 0x375c */    DWORD unknown003543;
/* 0x3760 */    DWORD unknown003544;
/* 0x3764 */    DWORD unknown003545;
/* 0x3768 */    DWORD unknown003546;
/* 0x376c */    DWORD unknown003547;
/* 0x3770 */    DWORD unknown003548;
/* 0x3774 */    DWORD unknown003549;
/* 0x3778 */    DWORD unknown003550;
/* 0x377c */    DWORD unknown003551;
/* 0x3780 */    DWORD unknown003552;
/* 0x3784 */    DWORD unknown003553;
/* 0x3788 */    DWORD unknown003554;
/* 0x378c */    DWORD unknown003555;
/* 0x3790 */    DWORD unknown003556;
/* 0x3794 */    DWORD unknown003557;
/* 0x3798 */    DWORD unknown003558;
/* 0x379c */    DWORD unknown003559;
/* 0x37a0 */    DWORD unknown003560;
/* 0x37a4 */    DWORD unknown003561;
/* 0x37a8 */    DWORD unknown003562;
/* 0x37ac */    DWORD unknown003563;
/* 0x37b0 */    DWORD unknown003564;
/* 0x37b4 */    DWORD unknown003565;
/* 0x37b8 */    DWORD unknown003566;
/* 0x37bc */    DWORD unknown003567;
/* 0x37c0 */    DWORD unknown003568;
/* 0x37c4 */    DWORD unknown003569;
/* 0x37c8 */    DWORD unknown003570;
/* 0x37cc */    DWORD unknown003571;
/* 0x37d0 */    DWORD unknown003572;
/* 0x37d4 */    DWORD unknown003573;
/* 0x37d8 */    DWORD unknown003574;
/* 0x37dc */    DWORD unknown003575;
/* 0x37e0 */    DWORD unknown003576;
/* 0x37e4 */    DWORD unknown003577;
/* 0x37e8 */    DWORD unknown003578;
/* 0x37ec */    DWORD unknown003579;
/* 0x37f0 */    DWORD unknown003580;
/* 0x37f4 */    DWORD unknown003581;
/* 0x37f8 */    DWORD unknown003582;
/* 0x37fc */    DWORD unknown003583;
/* 0x3800 */    DWORD unknown003584;
/* 0x3804 */    DWORD unknown003585;
/* 0x3808 */    DWORD unknown003586;
/* 0x380c */    DWORD unknown003587;
/* 0x3810 */    DWORD unknown003588;
/* 0x3814 */    DWORD unknown003589;
/* 0x3818 */    DWORD unknown003590;
/* 0x381c */    DWORD unknown003591;
/* 0x3820 */    DWORD unknown003592;
/* 0x3824 */    DWORD unknown003593;
/* 0x3828 */    DWORD unknown003594;
/* 0x382c */    DWORD unknown003595;
/* 0x3830 */    DWORD unknown003596;
/* 0x3834 */    DWORD unknown003597;
/* 0x3838 */    DWORD unknown003598;
/* 0x383c */    DWORD unknown003599;
/* 0x3840 */    DWORD unknown003600;
/* 0x3844 */    DWORD unknown003601;
/* 0x3848 */    DWORD unknown003602;
/* 0x384c */    DWORD unknown003603;
/* 0x3850 */    DWORD unknown003604;
/* 0x3854 */    DWORD unknown003605;
/* 0x3858 */    DWORD unknown003606;
/* 0x385c */    DWORD unknown003607;
/* 0x3860 */    DWORD unknown003608;
/* 0x3864 */    DWORD unknown003609;
/* 0x3868 */    DWORD unknown003610;
/* 0x386c */    DWORD unknown003611;
/* 0x3870 */    DWORD unknown003612;
/* 0x3874 */    DWORD unknown003613;
/* 0x3878 */    DWORD unknown003614;
/* 0x387c */    DWORD unknown003615;
/* 0x3880 */    DWORD unknown003616;
/* 0x3884 */    DWORD unknown003617;
/* 0x3888 */    DWORD unknown003618;
/* 0x388c */    DWORD unknown003619;
/* 0x3890 */    DWORD unknown003620;
/* 0x3894 */    DWORD unknown003621;
/* 0x3898 */    DWORD unknown003622;
/* 0x389c */    DWORD unknown003623;
/* 0x38a0 */    DWORD unknown003624;
/* 0x38a4 */    DWORD unknown003625;
/* 0x38a8 */    DWORD unknown003626;
/* 0x38ac */    DWORD unknown003627;
/* 0x38b0 */    DWORD unknown003628;
/* 0x38b4 */    DWORD unknown003629;
/* 0x38b8 */    DWORD unknown003630;
/* 0x38bc */    DWORD unknown003631;
/* 0x38c0 */    DWORD unknown003632;
/* 0x38c4 */    DWORD unknown003633;
/* 0x38c8 */    DWORD unknown003634;
/* 0x38cc */    DWORD unknown003635;
/* 0x38d0 */    DWORD unknown003636;
/* 0x38d4 */    DWORD unknown003637;
/* 0x38d8 */    DWORD unknown003638;
/* 0x38dc */    DWORD unknown003639;
/* 0x38e0 */    DWORD unknown003640;
/* 0x38e4 */    DWORD unknown003641;
/* 0x38e8 */    DWORD unknown003642;
/* 0x38ec */    DWORD unknown003643;
/* 0x38f0 */    DWORD unknown003644;
/* 0x38f4 */    DWORD unknown003645;
/* 0x38f8 */    DWORD unknown003646;
/* 0x38fc */    DWORD unknown003647;
/* 0x3900 */    DWORD unknown003648;
/* 0x3904 */    DWORD unknown003649;
/* 0x3908 */    DWORD unknown003650;
/* 0x390c */    DWORD unknown003651;
/* 0x3910 */    DWORD unknown003652;
/* 0x3914 */    DWORD unknown003653;
/* 0x3918 */    DWORD unknown003654;
/* 0x391c */    DWORD unknown003655;
/* 0x3920 */    DWORD unknown003656;
/* 0x3924 */    DWORD unknown003657;
/* 0x3928 */    DWORD unknown003658;
/* 0x392c */    DWORD unknown003659;
/* 0x3930 */    DWORD unknown003660;
/* 0x3934 */    DWORD unknown003661;
/* 0x3938 */    DWORD unknown003662;
/* 0x393c */    DWORD unknown003663;
/* 0x3940 */    DWORD unknown003664;
/* 0x3944 */    DWORD unknown003665;
/* 0x3948 */    DWORD unknown003666;
/* 0x394c */    DWORD unknown003667;
/* 0x3950 */    DWORD unknown003668;
/* 0x3954 */    DWORD unknown003669;
/* 0x3958 */    DWORD unknown003670;
/* 0x395c */    DWORD unknown003671;
/* 0x3960 */    DWORD unknown003672;
/* 0x3964 */    DWORD unknown003673;
/* 0x3968 */    DWORD unknown003674;
/* 0x396c */    DWORD unknown003675;
/* 0x3970 */    DWORD unknown003676;
/* 0x3974 */    DWORD unknown003677;
/* 0x3978 */    DWORD unknown003678;
/* 0x397c */    DWORD unknown003679;
/* 0x3980 */    DWORD unknown003680;
/* 0x3984 */    DWORD unknown003681;
/* 0x3988 */    DWORD unknown003682;
/* 0x398c */    DWORD unknown003683;
/* 0x3990 */    DWORD unknown003684;
/* 0x3994 */    DWORD unknown003685;
/* 0x3998 */    DWORD unknown003686;
/* 0x399c */    DWORD unknown003687;
/* 0x39a0 */    DWORD unknown003688;
/* 0x39a4 */    DWORD unknown003689;
/* 0x39a8 */    DWORD unknown003690;
/* 0x39ac */    DWORD unknown003691;
/* 0x39b0 */    DWORD unknown003692;
/* 0x39b4 */    DWORD unknown003693;
/* 0x39b8 */    DWORD unknown003694;
/* 0x39bc */    DWORD unknown003695;
/* 0x39c0 */    DWORD unknown003696;
/* 0x39c4 */    DWORD unknown003697;
/* 0x39c8 */    DWORD unknown003698;
/* 0x39cc */    DWORD unknown003699;
/* 0x39d0 */    DWORD unknown003700;
/* 0x39d4 */    DWORD unknown003701;
/* 0x39d8 */    DWORD unknown003702;
/* 0x39dc */    DWORD unknown003703;
/* 0x39e0 */    DWORD unknown003704;
/* 0x39e4 */    DWORD unknown003705;
/* 0x39e8 */    DWORD unknown003706;
/* 0x39ec */    DWORD unknown003707;
/* 0x39f0 */    DWORD unknown003708;
/* 0x39f4 */    DWORD unknown003709;
/* 0x39f8 */    DWORD unknown003710;
/* 0x39fc */    DWORD unknown003711;
/* 0x3a00 */    DWORD unknown003712;
/* 0x3a04 */    DWORD unknown003713;
/* 0x3a08 */    DWORD unknown003714;
/* 0x3a0c */    DWORD unknown003715;
/* 0x3a10 */    DWORD unknown003716;
/* 0x3a14 */    DWORD unknown003717;
/* 0x3a18 */    DWORD unknown003718;
/* 0x3a1c */    DWORD unknown003719;
/* 0x3a20 */    DWORD unknown003720;
/* 0x3a24 */    DWORD unknown003721;
/* 0x3a28 */    DWORD unknown003722;
/* 0x3a2c */    DWORD unknown003723;
/* 0x3a30 */    DWORD unknown003724;
/* 0x3a34 */    DWORD unknown003725;
/* 0x3a38 */    DWORD unknown003726;
/* 0x3a3c */    DWORD unknown003727;
/* 0x3a40 */    DWORD unknown003728;
/* 0x3a44 */    DWORD unknown003729;
/* 0x3a48 */    DWORD unknown003730;
/* 0x3a4c */    DWORD unknown003731;
/* 0x3a50 */    DWORD unknown003732;
/* 0x3a54 */    DWORD unknown003733;
/* 0x3a58 */    DWORD unknown003734;
/* 0x3a5c */    DWORD unknown003735;
/* 0x3a60 */    DWORD unknown003736;
/* 0x3a64 */    DWORD unknown003737;
/* 0x3a68 */    DWORD unknown003738;
/* 0x3a6c */    DWORD unknown003739;
/* 0x3a70 */    DWORD unknown003740;
/* 0x3a74 */    DWORD unknown003741;
/* 0x3a78 */    DWORD unknown003742;
/* 0x3a7c */    DWORD unknown003743;
/* 0x3a80 */    DWORD unknown003744;
/* 0x3a84 */    DWORD unknown003745;
/* 0x3a88 */    DWORD unknown003746;
/* 0x3a8c */    DWORD unknown003747;
/* 0x3a90 */    DWORD unknown003748;
/* 0x3a94 */    DWORD unknown003749;
/* 0x3a98 */    DWORD unknown003750;
/* 0x3a9c */    DWORD unknown003751;
/* 0x3aa0 */    DWORD unknown003752;
/* 0x3aa4 */    DWORD unknown003753;
/* 0x3aa8 */    DWORD unknown003754;
/* 0x3aac */    DWORD unknown003755;
/* 0x3ab0 */    DWORD unknown003756;
/* 0x3ab4 */    DWORD unknown003757;
/* 0x3ab8 */    DWORD unknown003758;
/* 0x3abc */    DWORD unknown003759;
/* 0x3ac0 */    DWORD unknown003760;
/* 0x3ac4 */    DWORD unknown003761;
/* 0x3ac8 */    DWORD unknown003762;
/* 0x3acc */    DWORD unknown003763;
/* 0x3ad0 */    DWORD unknown003764;
/* 0x3ad4 */    DWORD unknown003765;
/* 0x3ad8 */    DWORD unknown003766;
/* 0x3adc */    DWORD unknown003767;
/* 0x3ae0 */    DWORD unknown003768;
/* 0x3ae4 */    DWORD unknown003769;
/* 0x3ae8 */    DWORD unknown003770;
/* 0x3aec */    DWORD unknown003771;
/* 0x3af0 */    DWORD unknown003772;
/* 0x3af4 */    DWORD unknown003773;
/* 0x3af8 */    DWORD unknown003774;
/* 0x3afc */    DWORD unknown003775;
/* 0x3b00 */    DWORD unknown003776;
/* 0x3b04 */    DWORD unknown003777;
/* 0x3b08 */    DWORD unknown003778;
/* 0x3b0c */    DWORD unknown003779;
/* 0x3b10 */    DWORD unknown003780;
/* 0x3b14 */    DWORD unknown003781;
/* 0x3b18 */    DWORD unknown003782;
/* 0x3b1c */    DWORD unknown003783;
/* 0x3b20 */    DWORD unknown003784;
/* 0x3b24 */    DWORD unknown003785;
/* 0x3b28 */    DWORD unknown003786;
/* 0x3b2c */    DWORD unknown003787;
/* 0x3b30 */    DWORD unknown003788;
/* 0x3b34 */    DWORD unknown003789;
/* 0x3b38 */    DWORD unknown003790;
/* 0x3b3c */    DWORD unknown003791;
/* 0x3b40 */    DWORD unknown003792;
/* 0x3b44 */    DWORD unknown003793;
/* 0x3b48 */    DWORD unknown003794;
/* 0x3b4c */    DWORD unknown003795;
/* 0x3b50 */    DWORD unknown003796;
/* 0x3b54 */    DWORD unknown003797;
/* 0x3b58 */    DWORD unknown003798;
/* 0x3b5c */    DWORD unknown003799;
/* 0x3b60 */    DWORD unknown003800;
/* 0x3b64 */    DWORD unknown003801;
/* 0x3b68 */    DWORD unknown003802;
/* 0x3b6c */    DWORD unknown003803;
/* 0x3b70 */    DWORD unknown003804;
/* 0x3b74 */    DWORD unknown003805;
/* 0x3b78 */    DWORD unknown003806;
/* 0x3b7c */    DWORD unknown003807;
/* 0x3b80 */    DWORD unknown003808;
/* 0x3b84 */    DWORD unknown003809;
/* 0x3b88 */    DWORD unknown003810;
/* 0x3b8c */    DWORD unknown003811;
/* 0x3b90 */    DWORD unknown003812;
/* 0x3b94 */    DWORD unknown003813;
/* 0x3b98 */    DWORD unknown003814;
/* 0x3b9c */    DWORD unknown003815;
/* 0x3ba0 */    DWORD unknown003816;
/* 0x3ba4 */    DWORD unknown003817;
/* 0x3ba8 */    DWORD unknown003818;
/* 0x3bac */    DWORD unknown003819;
/* 0x3bb0 */    DWORD unknown003820;
/* 0x3bb4 */    DWORD unknown003821;
/* 0x3bb8 */    DWORD unknown003822;
/* 0x3bbc */    DWORD unknown003823;
/* 0x3bc0 */    DWORD unknown003824;
/* 0x3bc4 */    DWORD unknown003825;
/* 0x3bc8 */    DWORD unknown003826;
/* 0x3bcc */    DWORD unknown003827;
/* 0x3bd0 */    DWORD unknown003828;
/* 0x3bd4 */    DWORD unknown003829;
/* 0x3bd8 */    DWORD unknown003830;
/* 0x3bdc */    DWORD unknown003831;
/* 0x3be0 */    DWORD unknown003832;
/* 0x3be4 */    DWORD unknown003833;
/* 0x3be8 */    DWORD unknown003834;
/* 0x3bec */    DWORD unknown003835;
/* 0x3bf0 */    DWORD unknown003836;
/* 0x3bf4 */    DWORD unknown003837;
/* 0x3bf8 */    DWORD unknown003838;
/* 0x3bfc */    DWORD unknown003839;
/* 0x3c00 */    DWORD unknown003840;
/* 0x3c04 */    DWORD unknown003841;
/* 0x3c08 */    DWORD unknown003842;
/* 0x3c0c */    DWORD unknown003843;
/* 0x3c10 */    DWORD unknown003844;
/* 0x3c14 */    DWORD unknown003845;
/* 0x3c18 */    DWORD unknown003846;
/* 0x3c1c */    DWORD unknown003847;
/* 0x3c20 */    DWORD unknown003848;
/* 0x3c24 */    DWORD unknown003849;
/* 0x3c28 */    DWORD unknown003850;
/* 0x3c2c */    DWORD unknown003851;
/* 0x3c30 */    DWORD unknown003852;
/* 0x3c34 */    DWORD unknown003853;
/* 0x3c38 */    DWORD unknown003854;
/* 0x3c3c */    DWORD unknown003855;
/* 0x3c40 */    DWORD unknown003856;
/* 0x3c44 */    DWORD unknown003857;
/* 0x3c48 */    DWORD unknown003858;
/* 0x3c4c */    DWORD unknown003859;
/* 0x3c50 */    DWORD unknown003860;
/* 0x3c54 */    DWORD unknown003861;
/* 0x3c58 */    DWORD unknown003862;
/* 0x3c5c */    DWORD unknown003863;
/* 0x3c60 */    DWORD unknown003864;
/* 0x3c64 */    DWORD unknown003865;
/* 0x3c68 */    DWORD unknown003866;
/* 0x3c6c */    DWORD unknown003867;
/* 0x3c70 */    DWORD unknown003868;
/* 0x3c74 */    DWORD unknown003869;
/* 0x3c78 */    DWORD unknown003870;
/* 0x3c7c */    DWORD unknown003871;
/* 0x3c80 */    DWORD unknown003872;
/* 0x3c84 */    DWORD unknown003873;
/* 0x3c88 */    DWORD unknown003874;
/* 0x3c8c */    DWORD unknown003875;
/* 0x3c90 */    DWORD unknown003876;
/* 0x3c94 */    DWORD unknown003877;
/* 0x3c98 */    DWORD unknown003878;
/* 0x3c9c */    DWORD unknown003879;
/* 0x3ca0 */    DWORD unknown003880;
/* 0x3ca4 */    DWORD unknown003881;
/* 0x3ca8 */    DWORD unknown003882;
/* 0x3cac */    DWORD unknown003883;
/* 0x3cb0 */    DWORD unknown003884;
/* 0x3cb4 */    DWORD unknown003885;
/* 0x3cb8 */    DWORD unknown003886;
/* 0x3cbc */    DWORD unknown003887;
/* 0x3cc0 */    DWORD unknown003888;
/* 0x3cc4 */    DWORD unknown003889;
/* 0x3cc8 */    DWORD unknown003890;
/* 0x3ccc */    DWORD unknown003891;
/* 0x3cd0 */    DWORD unknown003892;
/* 0x3cd4 */    DWORD unknown003893;
/* 0x3cd8 */    DWORD unknown003894;
/* 0x3cdc */    DWORD unknown003895;
/* 0x3ce0 */    DWORD unknown003896;
/* 0x3ce4 */    DWORD unknown003897;
/* 0x3ce8 */    DWORD unknown003898;
/* 0x3cec */    DWORD unknown003899;
/* 0x3cf0 */    DWORD unknown003900;
/* 0x3cf4 */    DWORD unknown003901;
/* 0x3cf8 */    DWORD unknown003902;
/* 0x3cfc */    DWORD unknown003903;
/* 0x3d00 */    DWORD unknown003904;
/* 0x3d04 */    DWORD unknown003905;
/* 0x3d08 */    DWORD unknown003906;
/* 0x3d0c */    DWORD unknown003907;
/* 0x3d10 */    DWORD unknown003908;
/* 0x3d14 */    DWORD unknown003909;
/* 0x3d18 */    DWORD unknown003910;
/* 0x3d1c */    DWORD unknown003911;
/* 0x3d20 */    DWORD unknown003912;
/* 0x3d24 */    DWORD unknown003913;
/* 0x3d28 */    DWORD unknown003914;
/* 0x3d2c */    DWORD unknown003915;
/* 0x3d30 */    DWORD unknown003916;
/* 0x3d34 */    DWORD unknown003917;
/* 0x3d38 */    DWORD unknown003918;
/* 0x3d3c */    DWORD unknown003919;
/* 0x3d40 */    DWORD unknown003920;
/* 0x3d44 */    DWORD unknown003921;
/* 0x3d48 */    DWORD unknown003922;
/* 0x3d4c */    DWORD unknown003923;
/* 0x3d50 */    DWORD unknown003924;
/* 0x3d54 */    DWORD unknown003925;
/* 0x3d58 */    DWORD unknown003926;
/* 0x3d5c */    DWORD unknown003927;
/* 0x3d60 */    DWORD unknown003928;
/* 0x3d64 */    DWORD unknown003929;
/* 0x3d68 */    DWORD unknown003930;
/* 0x3d6c */    DWORD unknown003931;
/* 0x3d70 */    DWORD unknown003932;
/* 0x3d74 */    DWORD unknown003933;
/* 0x3d78 */    DWORD unknown003934;
/* 0x3d7c */    DWORD unknown003935;
/* 0x3d80 */    DWORD unknown003936;
/* 0x3d84 */    DWORD unknown003937;
/* 0x3d88 */    DWORD unknown003938;
/* 0x3d8c */    DWORD unknown003939;
/* 0x3d90 */    DWORD unknown003940;
/* 0x3d94 */    DWORD unknown003941;
/* 0x3d98 */    DWORD unknown003942;
/* 0x3d9c */    DWORD unknown003943;
/* 0x3da0 */    DWORD unknown003944;
/* 0x3da4 */    DWORD unknown003945;
/* 0x3da8 */    DWORD unknown003946;
/* 0x3dac */    DWORD unknown003947;
/* 0x3db0 */    DWORD unknown003948;
/* 0x3db4 */    DWORD unknown003949;
/* 0x3db8 */    DWORD unknown003950;
/* 0x3dbc */    DWORD unknown003951;
/* 0x3dc0 */    DWORD unknown003952;
/* 0x3dc4 */    DWORD unknown003953;
/* 0x3dc8 */    DWORD unknown003954;
/* 0x3dcc */    DWORD unknown003955;
/* 0x3dd0 */    DWORD unknown003956;
/* 0x3dd4 */    DWORD unknown003957;
/* 0x3dd8 */    DWORD unknown003958;
/* 0x3ddc */    DWORD unknown003959;
/* 0x3de0 */    DWORD unknown003960;
/* 0x3de4 */    DWORD unknown003961;
/* 0x3de8 */    DWORD unknown003962;
/* 0x3dec */    DWORD unknown003963;
/* 0x3df0 */    DWORD unknown003964;
/* 0x3df4 */    DWORD unknown003965;
/* 0x3df8 */    DWORD unknown003966;
/* 0x3dfc */    DWORD unknown003967;
/* 0x3e00 */    DWORD unknown003968;
/* 0x3e04 */    DWORD unknown003969;
/* 0x3e08 */    DWORD unknown003970;
/* 0x3e0c */    DWORD unknown003971;
/* 0x3e10 */    DWORD unknown003972;
/* 0x3e14 */    DWORD unknown003973;
/* 0x3e18 */    DWORD unknown003974;
/* 0x3e1c */    DWORD unknown003975;
/* 0x3e20 */    DWORD unknown003976;
/* 0x3e24 */    DWORD unknown003977;
/* 0x3e28 */    DWORD unknown003978;
/* 0x3e2c */    DWORD unknown003979;
/* 0x3e30 */    DWORD unknown003980;
/* 0x3e34 */    DWORD unknown003981;
/* 0x3e38 */    DWORD unknown003982;
/* 0x3e3c */    DWORD unknown003983;
/* 0x3e40 */    DWORD unknown003984;
/* 0x3e44 */    DWORD unknown003985;
/* 0x3e48 */    DWORD unknown003986;
/* 0x3e4c */    DWORD unknown003987;
/* 0x3e50 */    DWORD unknown003988;
/* 0x3e54 */    DWORD unknown003989;
/* 0x3e58 */    DWORD unknown003990;
/* 0x3e5c */    DWORD unknown003991;
/* 0x3e60 */    DWORD unknown003992;
/* 0x3e64 */    DWORD unknown003993;
/* 0x3e68 */    DWORD unknown003994;
/* 0x3e6c */    DWORD unknown003995;
/* 0x3e70 */    DWORD unknown003996;
/* 0x3e74 */    DWORD unknown003997;
/* 0x3e78 */    DWORD unknown003998;
/* 0x3e7c */    DWORD unknown003999;
/* 0x3e80 */    DWORD unknown004000;
/* 0x3e84 */    DWORD unknown004001;
/* 0x3e88 */    DWORD unknown004002;
/* 0x3e8c */    DWORD unknown004003;
/* 0x3e90 */    DWORD unknown004004;
/* 0x3e94 */    DWORD unknown004005;
/* 0x3e98 */    DWORD unknown004006;
/* 0x3e9c */    DWORD unknown004007;
/* 0x3ea0 */    DWORD unknown004008;
/* 0x3ea4 */    DWORD unknown004009;
/* 0x3ea8 */    DWORD unknown004010;
/* 0x3eac */    DWORD unknown004011;
/* 0x3eb0 */    DWORD unknown004012;
/* 0x3eb4 */    DWORD unknown004013;
/* 0x3eb8 */    DWORD unknown004014;
/* 0x3ebc */    DWORD unknown004015;
/* 0x3ec0 */    DWORD unknown004016;
/* 0x3ec4 */    DWORD unknown004017;
/* 0x3ec8 */    DWORD unknown004018;
/* 0x3ecc */    DWORD unknown004019;
/* 0x3ed0 */    DWORD unknown004020;
/* 0x3ed4 */    DWORD unknown004021;
/* 0x3ed8 */    DWORD unknown004022;
/* 0x3edc */    DWORD unknown004023;
/* 0x3ee0 */    DWORD unknown004024;
/* 0x3ee4 */    DWORD unknown004025;
/* 0x3ee8 */    DWORD unknown004026;
/* 0x3eec */    DWORD unknown004027;
/* 0x3ef0 */    DWORD unknown004028;
/* 0x3ef4 */    DWORD unknown004029;
/* 0x3ef8 */    DWORD unknown004030;
/* 0x3efc */    DWORD unknown004031;
/* 0x3f00 */    DWORD unknown004032;
/* 0x3f04 */    DWORD unknown004033;
/* 0x3f08 */    DWORD unknown004034;
/* 0x3f0c */    DWORD unknown004035;
/* 0x3f10 */    DWORD unknown004036;
/* 0x3f14 */    DWORD unknown004037;
/* 0x3f18 */    DWORD unknown004038;
/* 0x3f1c */    DWORD unknown004039;
/* 0x3f20 */    DWORD unknown004040;
/* 0x3f24 */    DWORD unknown004041;
/* 0x3f28 */    DWORD unknown004042;
/* 0x3f2c */    DWORD unknown004043;
/* 0x3f30 */    DWORD unknown004044;
/* 0x3f34 */    DWORD unknown004045;
/* 0x3f38 */    DWORD unknown004046;
/* 0x3f3c */    DWORD unknown004047;
/* 0x3f40 */    DWORD unknown004048;
/* 0x3f44 */    DWORD unknown004049;
/* 0x3f48 */    DWORD unknown004050;
/* 0x3f4c */    DWORD unknown004051;
/* 0x3f50 */    DWORD unknown004052;
/* 0x3f54 */    DWORD unknown004053;
/* 0x3f58 */    DWORD unknown004054;
/* 0x3f5c */    DWORD unknown004055;
/* 0x3f60 */    DWORD unknown004056;
/* 0x3f64 */    DWORD unknown004057;
/* 0x3f68 */    DWORD unknown004058;
/* 0x3f6c */    DWORD unknown004059;
/* 0x3f70 */    DWORD unknown004060;
/* 0x3f74 */    DWORD unknown004061;
/* 0x3f78 */    DWORD unknown004062;
/* 0x3f7c */    DWORD unknown004063;
/* 0x3f80 */    DWORD unknown004064;
/* 0x3f84 */    DWORD unknown004065;
/* 0x3f88 */    DWORD unknown004066;
/* 0x3f8c */    DWORD unknown004067;
/* 0x3f90 */    DWORD unknown004068;
/* 0x3f94 */    DWORD unknown004069;
/* 0x3f98 */    DWORD unknown004070;
/* 0x3f9c */    DWORD unknown004071;
/* 0x3fa0 */    DWORD unknown004072;
/* 0x3fa4 */    DWORD unknown004073;
/* 0x3fa8 */    DWORD unknown004074;
/* 0x3fac */    DWORD unknown004075;
/* 0x3fb0 */    DWORD unknown004076;
/* 0x3fb4 */    DWORD unknown004077;
/* 0x3fb8 */    DWORD unknown004078;
/* 0x3fbc */    DWORD unknown004079;
/* 0x3fc0 */    DWORD unknown004080;
/* 0x3fc4 */    DWORD unknown004081;
/* 0x3fc8 */    DWORD unknown004082;
/* 0x3fcc */    DWORD unknown004083;
/* 0x3fd0 */    DWORD unknown004084;
/* 0x3fd4 */    DWORD unknown004085;
/* 0x3fd8 */    DWORD unknown004086;
/* 0x3fdc */    DWORD unknown004087;
/* 0x3fe0 */    DWORD unknown004088;
/* 0x3fe4 */    DWORD unknown004089;
/* 0x3fe8 */    DWORD unknown004090;
/* 0x3fec */    DWORD unknown004091;
/* 0x3ff0 */    DWORD unknown004092;
/* 0x3ff4 */    DWORD unknown004093;
/* 0x3ff8 */    DWORD unknown004094;
/* 0x3ffc */    DWORD unknown004095;
/* 0x4000 */    DWORD unknown004096;
/* 0x4004 */    DWORD unknown004097;
/* 0x4008 */    DWORD unknown004098;
/* 0x400c */    DWORD unknown004099;
/* 0x4010 */    DWORD unknown004100;
/* 0x4014 */    DWORD unknown004101;
/* 0x4018 */    DWORD unknown004102;
/* 0x401c */    DWORD unknown004103;
/* 0x4020 */    DWORD unknown004104;
/* 0x4024 */    DWORD unknown004105;
/* 0x4028 */    DWORD unknown004106;
/* 0x402c */    DWORD unknown004107;
/* 0x4030 */    DWORD unknown004108;
/* 0x4034 */    DWORD unknown004109;
/* 0x4038 */    DWORD unknown004110;
/* 0x403c */    DWORD unknown004111;
/* 0x4040 */    DWORD unknown004112;
/* 0x4044 */    DWORD unknown004113;
/* 0x4048 */    DWORD unknown004114;
/* 0x404c */    DWORD unknown004115;
/* 0x4050 */    DWORD unknown004116;
/* 0x4054 */    DWORD unknown004117;
/* 0x4058 */    DWORD unknown004118;
/* 0x405c */    DWORD unknown004119;
/* 0x4060 */    DWORD unknown004120;
/* 0x4064 */    DWORD unknown004121;
/* 0x4068 */    DWORD unknown004122;
/* 0x406c */    DWORD unknown004123;
/* 0x4070 */    DWORD unknown004124;
/* 0x4074 */    DWORD unknown004125;
/* 0x4078 */    DWORD unknown004126;
/* 0x407c */    DWORD unknown004127;
/* 0x4080 */    DWORD unknown004128;
/* 0x4084 */    DWORD unknown004129;
/* 0x4088 */    DWORD unknown004130;
/* 0x408c */    DWORD unknown004131;
/* 0x4090 */    DWORD unknown004132;
/* 0x4094 */    DWORD unknown004133;
/* 0x4098 */    DWORD unknown004134;
/* 0x409c */    DWORD unknown004135;
/* 0x40a0 */    DWORD unknown004136;
/* 0x40a4 */    DWORD unknown004137;
/* 0x40a8 */    DWORD unknown004138;
/* 0x40ac */    DWORD unknown004139;
/* 0x40b0 */    DWORD unknown004140;
/* 0x40b4 */    DWORD unknown004141;
/* 0x40b8 */    DWORD unknown004142;
/* 0x40bc */    DWORD unknown004143;
/* 0x40c0 */    DWORD unknown004144;
/* 0x40c4 */    DWORD unknown004145;
/* 0x40c8 */    DWORD unknown004146;
/* 0x40cc */    DWORD unknown004147;
/* 0x40d0 */    DWORD unknown004148;
/* 0x40d4 */    DWORD unknown004149;
/* 0x40d8 */    DWORD unknown004150;
/* 0x40dc */    DWORD unknown004151;
/* 0x40e0 */    DWORD unknown004152;
/* 0x40e4 */    DWORD unknown004153;
/* 0x40e8 */    DWORD unknown004154;
/* 0x40ec */    DWORD unknown004155;
/* 0x40f0 */    DWORD unknown004156;
/* 0x40f4 */    DWORD unknown004157;
/* 0x40f8 */    DWORD unknown004158;
/* 0x40fc */    DWORD unknown004159;
/* 0x4100 */    DWORD unknown004160;
/* 0x4104 */    DWORD unknown004161;
/* 0x4108 */    DWORD unknown004162;
/* 0x410c */    DWORD unknown004163;
/* 0x4110 */    DWORD unknown004164;
/* 0x4114 */    DWORD unknown004165;
/* 0x4118 */    DWORD unknown004166;
/* 0x411c */    DWORD unknown004167;
/* 0x4120 */    DWORD unknown004168;
/* 0x4124 */    DWORD unknown004169;
/* 0x4128 */    DWORD unknown004170;
/* 0x412c */    DWORD unknown004171;
/* 0x4130 */    DWORD unknown004172;
/* 0x4134 */    DWORD unknown004173;
/* 0x4138 */    DWORD unknown004174;
/* 0x413c */    DWORD unknown004175;
/* 0x4140 */    DWORD unknown004176;
/* 0x4144 */    DWORD unknown004177;
/* 0x4148 */    DWORD unknown004178;
/* 0x414c */    DWORD unknown004179;
/* 0x4150 */    DWORD unknown004180;
/* 0x4154 */    DWORD unknown004181;
/* 0x4158 */    DWORD unknown004182;
/* 0x415c */    DWORD unknown004183;
/* 0x4160 */    DWORD unknown004184;
/* 0x4164 */    DWORD unknown004185;
/* 0x4168 */    DWORD unknown004186;
/* 0x416c */    DWORD unknown004187;
/* 0x4170 */    DWORD unknown004188;
/* 0x4174 */    DWORD unknown004189;
/* 0x4178 */    DWORD unknown004190;
/* 0x417c */    DWORD unknown004191;
/* 0x4180 */    DWORD unknown004192;
/* 0x4184 */    DWORD unknown004193;
/* 0x4188 */    DWORD unknown004194;
/* 0x418c */    DWORD unknown004195;
/* 0x4190 */    DWORD unknown004196;
/* 0x4194 */    DWORD unknown004197;
/* 0x4198 */    DWORD unknown004198;
/* 0x419c */    DWORD unknown004199;
/* 0x41a0 */    DWORD unknown004200;
/* 0x41a4 */    DWORD unknown004201;
/* 0x41a8 */    DWORD unknown004202;
/* 0x41ac */    DWORD unknown004203;
/* 0x41b0 */    DWORD unknown004204;
/* 0x41b4 */    DWORD unknown004205;
/* 0x41b8 */    DWORD unknown004206;
/* 0x41bc */    DWORD unknown004207;
/* 0x41c0 */    DWORD unknown004208;
/* 0x41c4 */    DWORD unknown004209;
/* 0x41c8 */    DWORD unknown004210;
/* 0x41cc */    DWORD unknown004211;
/* 0x41d0 */    DWORD unknown004212;
/* 0x41d4 */    DWORD unknown004213;
/* 0x41d8 */    DWORD unknown004214;
/* 0x41dc */    DWORD unknown004215;
/* 0x41e0 */    DWORD unknown004216;
/* 0x41e4 */    DWORD unknown004217;
/* 0x41e8 */    DWORD unknown004218;
/* 0x41ec */    DWORD unknown004219;
/* 0x41f0 */    DWORD unknown004220;
/* 0x41f4 */    DWORD unknown004221;
/* 0x41f8 */    DWORD unknown004222;
/* 0x41fc */    DWORD unknown004223;
/* 0x4200 */    DWORD unknown004224;
/* 0x4204 */    DWORD unknown004225;
/* 0x4208 */    DWORD unknown004226;
/* 0x420c */    DWORD unknown004227;
/* 0x4210 */    DWORD unknown004228;
/* 0x4214 */    DWORD unknown004229;
/* 0x4218 */    DWORD unknown004230;
/* 0x421c */    DWORD unknown004231;
/* 0x4220 */    DWORD unknown004232;
/* 0x4224 */    DWORD unknown004233;
/* 0x4228 */    DWORD unknown004234;
/* 0x422c */    DWORD unknown004235;
/* 0x4230 */    DWORD unknown004236;
/* 0x4234 */    DWORD unknown004237;
/* 0x4238 */    DWORD unknown004238;
/* 0x423c */    DWORD unknown004239;
/* 0x4240 */    DWORD unknown004240;
/* 0x4244 */    DWORD unknown004241;
/* 0x4248 */    DWORD unknown004242;
/* 0x424c */    DWORD unknown004243;
/* 0x4250 */    DWORD unknown004244;
/* 0x4254 */    DWORD unknown004245;
/* 0x4258 */    DWORD unknown004246;
/* 0x425c */    DWORD unknown004247;
/* 0x4260 */    DWORD unknown004248;
/* 0x4264 */    DWORD unknown004249;
/* 0x4268 */    DWORD unknown004250;
/* 0x426c */    DWORD unknown004251;
/* 0x4270 */    DWORD unknown004252;
/* 0x4274 */    DWORD unknown004253;
/* 0x4278 */    DWORD unknown004254;
/* 0x427c */    DWORD unknown004255;
/* 0x4280 */    DWORD unknown004256;
/* 0x4284 */    DWORD unknown004257;
/* 0x4288 */    DWORD unknown004258;
/* 0x428c */    DWORD unknown004259;
/* 0x4290 */    DWORD unknown004260;
/* 0x4294 */    DWORD unknown004261;
/* 0x4298 */    DWORD unknown004262;
/* 0x429c */    DWORD unknown004263;
/* 0x42a0 */    DWORD unknown004264;
/* 0x42a4 */    DWORD unknown004265;
/* 0x42a8 */    DWORD unknown004266;
/* 0x42ac */    DWORD unknown004267;
/* 0x42b0 */    DWORD unknown004268;
/* 0x42b4 */    DWORD unknown004269;
/* 0x42b8 */    DWORD unknown004270;
/* 0x42bc */    DWORD unknown004271;
/* 0x42c0 */    DWORD unknown004272;
/* 0x42c4 */    DWORD unknown004273;
/* 0x42c8 */    DWORD unknown004274;
/* 0x42cc */    DWORD unknown004275;
/* 0x42d0 */    DWORD unknown004276;
/* 0x42d4 */    DWORD unknown004277;
/* 0x42d8 */    DWORD unknown004278;
/* 0x42dc */    DWORD unknown004279;
/* 0x42e0 */    DWORD unknown004280;
/* 0x42e4 */    DWORD unknown004281;
/* 0x42e8 */    DWORD unknown004282;
/* 0x42ec */    DWORD unknown004283;
/* 0x42f0 */    DWORD unknown004284;
/* 0x42f4 */    DWORD unknown004285;
/* 0x42f8 */    DWORD unknown004286;
/* 0x42fc */    DWORD unknown004287;
/* 0x4300 */    DWORD unknown004288;
/* 0x4304 */    DWORD unknown004289;
/* 0x4308 */    DWORD unknown004290;
/* 0x430c */    DWORD unknown004291;
/* 0x4310 */    DWORD unknown004292;
/* 0x4314 */    DWORD unknown004293;
/* 0x4318 */    DWORD unknown004294;
/* 0x431c */    DWORD unknown004295;
/* 0x4320 */    DWORD unknown004296;
/* 0x4324 */    DWORD unknown004297;
/* 0x4328 */    DWORD unknown004298;
/* 0x432c */    DWORD unknown004299;
/* 0x4330 */    DWORD unknown004300;
/* 0x4334 */    DWORD unknown004301;
/* 0x4338 */    DWORD unknown004302;
/* 0x433c */    DWORD unknown004303;
/* 0x4340 */    DWORD unknown004304;
/* 0x4344 */    DWORD unknown004305;
/* 0x4348 */    DWORD unknown004306;
/* 0x434c */    DWORD unknown004307;
/* 0x4350 */    DWORD unknown004308;
/* 0x4354 */    DWORD unknown004309;
/* 0x4358 */    DWORD unknown004310;
/* 0x435c */    DWORD unknown004311;
/* 0x4360 */    DWORD unknown004312;
/* 0x4364 */    DWORD unknown004313;
/* 0x4368 */    DWORD unknown004314;
/* 0x436c */    DWORD unknown004315;
/* 0x4370 */    DWORD unknown004316;
/* 0x4374 */    DWORD unknown004317;
/* 0x4378 */    DWORD unknown004318;
/* 0x437c */    DWORD unknown004319;
/* 0x4380 */    DWORD unknown004320;
/* 0x4384 */    DWORD unknown004321;
/* 0x4388 */    DWORD unknown004322;
/* 0x438c */    DWORD unknown004323;
/* 0x4390 */    DWORD unknown004324;
/* 0x4394 */    DWORD unknown004325;
/* 0x4398 */    DWORD unknown004326;
/* 0x439c */    DWORD unknown004327;
/* 0x43a0 */    DWORD unknown004328;
/* 0x43a4 */    DWORD unknown004329;
/* 0x43a8 */    DWORD unknown004330;
/* 0x43ac */    DWORD unknown004331;
/* 0x43b0 */    DWORD unknown004332;
/* 0x43b4 */    DWORD unknown004333;
/* 0x43b8 */    DWORD unknown004334;
/* 0x43bc */    DWORD unknown004335;
/* 0x43c0 */    DWORD unknown004336;
/* 0x43c4 */    DWORD unknown004337;
/* 0x43c8 */    DWORD unknown004338;
/* 0x43cc */    DWORD unknown004339;
/* 0x43d0 */    DWORD unknown004340;
/* 0x43d4 */    DWORD unknown004341;
/* 0x43d8 */    DWORD unknown004342;
/* 0x43dc */    DWORD unknown004343;
/* 0x43e0 */    DWORD unknown004344;
/* 0x43e4 */    DWORD unknown004345;
/* 0x43e8 */    DWORD unknown004346;
/* 0x43ec */    DWORD unknown004347;
/* 0x43f0 */    DWORD unknown004348;
/* 0x43f4 */    DWORD unknown004349;
/* 0x43f8 */    DWORD unknown004350;
/* 0x43fc */    DWORD unknown004351;
/* 0x4400 */    DWORD unknown004352;
/* 0x4404 */    DWORD unknown004353;
/* 0x4408 */    DWORD unknown004354;
/* 0x440c */    DWORD unknown004355;
/* 0x4410 */    DWORD unknown004356;
/* 0x4414 */    DWORD unknown004357;
/* 0x4418 */    DWORD unknown004358;
/* 0x441c */    DWORD unknown004359;
/* 0x4420 */    DWORD unknown004360;
/* 0x4424 */    DWORD unknown004361;
/* 0x4428 */    DWORD unknown004362;
/* 0x442c */    DWORD unknown004363;
/* 0x4430 */    DWORD unknown004364;
/* 0x4434 */    DWORD unknown004365;
/* 0x4438 */    DWORD unknown004366;
/* 0x443c */    DWORD unknown004367;
/* 0x4440 */    DWORD unknown004368;
/* 0x4444 */    DWORD unknown004369;
/* 0x4448 */    DWORD unknown004370;
/* 0x444c */    DWORD unknown004371;
/* 0x4450 */    DWORD unknown004372;
/* 0x4454 */    DWORD unknown004373;
/* 0x4458 */    DWORD unknown004374;
/* 0x445c */    DWORD unknown004375;
/* 0x4460 */    DWORD unknown004376;
/* 0x4464 */    DWORD unknown004377;
/* 0x4468 */    DWORD unknown004378;
/* 0x446c */    DWORD unknown004379;
/* 0x4470 */    DWORD unknown004380;
/* 0x4474 */    DWORD unknown004381;
/* 0x4478 */    DWORD unknown004382;
/* 0x447c */    DWORD unknown004383;
/* 0x4480 */    DWORD unknown004384;
/* 0x4484 */    DWORD unknown004385;
/* 0x4488 */    DWORD unknown004386;
/* 0x448c */    DWORD unknown004387;
/* 0x4490 */    DWORD unknown004388;
/* 0x4494 */    DWORD unknown004389;
/* 0x4498 */    DWORD unknown004390;
/* 0x449c */    DWORD unknown004391;
/* 0x44a0 */    DWORD unknown004392;
/* 0x44a4 */    DWORD unknown004393;
/* 0x44a8 */    DWORD unknown004394;
/* 0x44ac */    DWORD unknown004395;
/* 0x44b0 */    DWORD unknown004396;
/* 0x44b4 */    DWORD unknown004397;
/* 0x44b8 */    DWORD unknown004398;
/* 0x44bc */    DWORD unknown004399;
/* 0x44c0 */    DWORD unknown004400;
/* 0x44c4 */    DWORD unknown004401;
/* 0x44c8 */    DWORD unknown004402;
/* 0x44cc */    DWORD unknown004403;
/* 0x44d0 */    DWORD unknown004404;
/* 0x44d4 */    DWORD unknown004405;
/* 0x44d8 */    DWORD unknown004406;
/* 0x44dc */    DWORD unknown004407;
/* 0x44e0 */    DWORD unknown004408;
/* 0x44e4 */    DWORD unknown004409;
/* 0x44e8 */    DWORD unknown004410;
/* 0x44ec */    DWORD unknown004411;
/* 0x44f0 */    DWORD unknown004412;
/* 0x44f4 */    DWORD unknown004413;
/* 0x44f8 */    DWORD unknown004414;
/* 0x44fc */    DWORD unknown004415;
/* 0x4500 */    DWORD unknown004416;
/* 0x4504 */    DWORD unknown004417;
/* 0x4508 */    DWORD unknown004418;
/* 0x450c */    DWORD unknown004419;
/* 0x4510 */    DWORD unknown004420;
/* 0x4514 */    DWORD unknown004421;
/* 0x4518 */    DWORD unknown004422;
/* 0x451c */    DWORD unknown004423;
/* 0x4520 */    DWORD unknown004424;
/* 0x4524 */    DWORD unknown004425;
/* 0x4528 */    DWORD unknown004426;
/* 0x452c */    DWORD unknown004427;
/* 0x4530 */    DWORD unknown004428;
/* 0x4534 */    DWORD unknown004429;
/* 0x4538 */    DWORD unknown004430;
/* 0x453c */    DWORD unknown004431;
/* 0x4540 */    DWORD unknown004432;
/* 0x4544 */    DWORD unknown004433;
/* 0x4548 */    DWORD unknown004434;
/* 0x454c */    DWORD unknown004435;
/* 0x4550 */    DWORD unknown004436;
/* 0x4554 */    DWORD unknown004437;
/* 0x4558 */    DWORD unknown004438;
/* 0x455c */    DWORD unknown004439;
/* 0x4560 */    DWORD unknown004440;
/* 0x4564 */    DWORD unknown004441;
/* 0x4568 */    DWORD unknown004442;
/* 0x456c */    DWORD unknown004443;
/* 0x4570 */    DWORD unknown004444;
/* 0x4574 */    DWORD unknown004445;
/* 0x4578 */    DWORD unknown004446;
/* 0x457c */    DWORD unknown004447;
/* 0x4580 */    DWORD unknown004448;
/* 0x4584 */    DWORD unknown004449;
/* 0x4588 */    DWORD unknown004450;
/* 0x458c */    DWORD unknown004451;
/* 0x4590 */    DWORD unknown004452;
/* 0x4594 */    DWORD unknown004453;
/* 0x4598 */    DWORD unknown004454;
/* 0x459c */    DWORD unknown004455;
/* 0x45a0 */    DWORD unknown004456;
/* 0x45a4 */    DWORD unknown004457;
/* 0x45a8 */    DWORD unknown004458;
/* 0x45ac */    DWORD unknown004459;
/* 0x45b0 */    DWORD unknown004460;
/* 0x45b4 */    DWORD unknown004461;
/* 0x45b8 */    DWORD unknown004462;
/* 0x45bc */    DWORD unknown004463;
/* 0x45c0 */    DWORD unknown004464;
/* 0x45c4 */    DWORD unknown004465;
/* 0x45c8 */    DWORD unknown004466;
/* 0x45cc */    DWORD unknown004467;
/* 0x45d0 */    DWORD unknown004468;
/* 0x45d4 */    DWORD unknown004469;
/* 0x45d8 */    DWORD unknown004470;
/* 0x45dc */    DWORD unknown004471;
/* 0x45e0 */    DWORD unknown004472;
/* 0x45e4 */    DWORD unknown004473;
/* 0x45e8 */    DWORD unknown004474;
/* 0x45ec */    DWORD unknown004475;
/* 0x45f0 */    DWORD unknown004476;
/* 0x45f4 */    DWORD unknown004477;
/* 0x45f8 */    DWORD unknown004478;
/* 0x45fc */    DWORD unknown004479;
/* 0x4600 */    DWORD unknown004480;
/* 0x4604 */    DWORD unknown004481;
/* 0x4608 */    DWORD unknown004482;
/* 0x460c */    DWORD unknown004483;
/* 0x4610 */    DWORD unknown004484;
/* 0x4614 */    DWORD unknown004485;
/* 0x4618 */    DWORD unknown004486;
/* 0x461c */    DWORD unknown004487;
/* 0x4620 */    DWORD unknown004488;
/* 0x4624 */    DWORD unknown004489;
/* 0x4628 */    DWORD unknown004490;
/* 0x462c */    DWORD unknown004491;
/* 0x4630 */    DWORD unknown004492;
/* 0x4634 */    DWORD unknown004493;
/* 0x4638 */    DWORD unknown004494;
/* 0x463c */    DWORD unknown004495;
/* 0x4640 */    DWORD unknown004496;
/* 0x4644 */    DWORD unknown004497;
/* 0x4648 */    DWORD unknown004498;
/* 0x464c */    DWORD unknown004499;
/* 0x4650 */    DWORD unknown004500;
/* 0x4654 */    DWORD unknown004501;
/* 0x4658 */    DWORD unknown004502;
/* 0x465c */    DWORD unknown004503;
/* 0x4660 */    DWORD unknown004504;
/* 0x4664 */    DWORD unknown004505;
/* 0x4668 */    DWORD unknown004506;
/* 0x466c */    DWORD unknown004507;
/* 0x4670 */    DWORD unknown004508;
/* 0x4674 */    DWORD unknown004509;
/* 0x4678 */    DWORD unknown004510;
/* 0x467c */    DWORD unknown004511;
/* 0x4680 */    DWORD unknown004512;
/* 0x4684 */    DWORD unknown004513;
/* 0x4688 */    DWORD unknown004514;
/* 0x468c */    DWORD unknown004515;
/* 0x4690 */    DWORD unknown004516;
/* 0x4694 */    DWORD unknown004517;
/* 0x4698 */    DWORD unknown004518;
/* 0x469c */    DWORD unknown004519;
/* 0x46a0 */    DWORD unknown004520;
/* 0x46a4 */    DWORD unknown004521;    // Software only
/* 0x46a8 */    DWORD unknown004522;
/* 0x46ac */    DWORD unknown004523;
/* 0x46b0 */    DWORD unknown004524;
/* 0x46b4 */    DWORD unknown004525;
/* 0x46b8 */    DWORD unknown004526;
/* 0x46bc */    DWORD unknown004527;
/* 0x46c0 */    DWORD unknown004528;
/* 0x46c4 */    DWORD unknown004529;
/* 0x46c8 */    DWORD unknown004530;
/* 0x46cc */    DWORD unknown004531;
/* 0x46d0 */    DWORD unknown004532;
/* 0x46d4 */    DWORD unknown004533;
/* 0x46d8 */    DWORD unknown004534;
/* 0x46dc */    DWORD unknown004535;
/* 0x46e0 */    DWORD unknown004536;
/* 0x46e4 */    DWORD unknown004537;
/* 0x46e8 */    DWORD unknown004538;
/* 0x46ec */    DWORD unknown004539;
/* 0x46f0 */    DWORD unknown004540;
/* 0x46f4 */    DWORD unknown004541;
/* 0x46f8 */    DWORD unknown004542;
/* 0x46fc */    DWORD unknown004543;
/* 0x4700 */    DWORD unknown004544;
/* 0x4704 */    DWORD unknown004545;
/* 0x4708 */    DWORD unknown004546;
/* 0x470c */    DWORD unknown004547;
/* 0x4710 */    DWORD unknown004548;
/* 0x4714 */    DWORD unknown004549;
/* 0x4718 */    DWORD unknown004550;
/* 0x471c */    DWORD unknown004551;
/* 0x4720 */    DWORD unknown004552;
/* 0x4724 */    DWORD unknown004553;
/* 0x4728 */    DWORD unknown004554;
/* 0x472c */    DWORD unknown004555;
/* 0x4730 */    DWORD unknown004556;
/* 0x4734 */    DWORD unknown004557;
/* 0x4738 */    DWORD unknown004558;
/* 0x473c */    DWORD unknown004559;
/* 0x4740 */    DWORD unknown004560;
/* 0x4744 */    DWORD unknown004561;
/* 0x4748 */    DWORD unknown004562;
/* 0x474c */    DWORD unknown004563;
/* 0x4750 */    DWORD unknown004564;
/* 0x4754 */    DWORD unknown004565;
/* 0x4758 */    DWORD unknown004566;
/* 0x475c */    DWORD unknown004567;
/* 0x4760 */    DWORD unknown004568;
/* 0x4764 */    DWORD unknown004569;
/* 0x4768 */    DWORD unknown004570;
/* 0x476c */    DWORD unknown004571;
/* 0x4770 */    DWORD unknown004572;
/* 0x4774 */    DWORD unknown004573;
/* 0x4778 */    DWORD unknown004574;
/* 0x477c */    DWORD unknown004575;
/* 0x4780 */    DWORD unknown004576;
/* 0x4784 */    DWORD unknown004577;
/* 0x4788 */    DWORD unknown004578;
/* 0x478c */    DWORD unknown004579;
/* 0x4790 */    DWORD unknown004580;
/* 0x4794 */    DWORD unknown004581;
/* 0x4798 */    DWORD unknown004582;
/* 0x479c */    DWORD unknown004583;
/* 0x47a0 */    DWORD unknown004584;
/* 0x47a4 */    DWORD unknown004585;
/* 0x47a8 */    DWORD unknown004586;
/* 0x47ac */    DWORD unknown004587;
/* 0x47b0 */    DWORD unknown004588;
/* 0x47b4 */    UINT SDKVersion;
} DIRECT3D9_INT, FAR *LPDIRECT3D9_INT;

#endif // _D3D9_PRIVATE_H_
