
#ifdef _M_ARM

#include <kxarm.h>

    MACRO
    DEFINE_WRAPPER_FUNC $n, $off, $x
        LCLS _FuncName
_FuncName SETS "_wrapper_func_":CC:"$n"
        NESTED_ENTRY $_FuncName
            __assertfail
        NESTED_END $_FuncName
    MEND

#else

#include <asm.inc>

.code

MACRO(DEFINE_WRAPPER_FUNC, n, off, x)
#ifdef _M_IX86
PUBLIC _wrapper_func_&n&
_wrapper_func_&n&:
    mov eax, [esp+4]
    mov eax, [eax+4]
    mov [esp+4], eax
    mov eax, [eax]
    jmp dword ptr [eax+off]
#elif defined(_M_AMD64)
PUBLIC wrapper_func_&n&
wrapper_func_&n&:
    mov rcx, [rcx+4]
    mov rax, [rcx]
    jmp qword ptr [rax+off]
#else
#error Unimplemented
#endif
ENDM

#endif

    DEFINE_WRAPPER_FUNC 3, 12, 24
    DEFINE_WRAPPER_FUNC 4, 16, 32
    DEFINE_WRAPPER_FUNC 5, 20, 40
    DEFINE_WRAPPER_FUNC 6, 24, 48
    DEFINE_WRAPPER_FUNC 7, 28, 56
    DEFINE_WRAPPER_FUNC 8, 32, 64
    DEFINE_WRAPPER_FUNC 9, 36, 72
    DEFINE_WRAPPER_FUNC 10, 40, 80
    DEFINE_WRAPPER_FUNC 11, 44, 88
    DEFINE_WRAPPER_FUNC 12, 48, 96
    DEFINE_WRAPPER_FUNC 13, 52, 104
    DEFINE_WRAPPER_FUNC 14, 56, 112
    DEFINE_WRAPPER_FUNC 15, 60, 120
    DEFINE_WRAPPER_FUNC 16, 64, 128
    DEFINE_WRAPPER_FUNC 17, 68, 136
    DEFINE_WRAPPER_FUNC 18, 72, 144
    DEFINE_WRAPPER_FUNC 19, 76, 152
    DEFINE_WRAPPER_FUNC 20, 80, 160
    DEFINE_WRAPPER_FUNC 21, 84, 168
    DEFINE_WRAPPER_FUNC 22, 88, 176
    DEFINE_WRAPPER_FUNC 23, 92, 184
    DEFINE_WRAPPER_FUNC 24, 96, 192
    DEFINE_WRAPPER_FUNC 25, 100, 200
    DEFINE_WRAPPER_FUNC 26, 104, 208
    DEFINE_WRAPPER_FUNC 27, 108, 216
    DEFINE_WRAPPER_FUNC 28, 112, 224
    DEFINE_WRAPPER_FUNC 29, 116, 232
    DEFINE_WRAPPER_FUNC 30, 120, 240
    DEFINE_WRAPPER_FUNC 31, 124, 248
    DEFINE_WRAPPER_FUNC 32, 128, 256
    DEFINE_WRAPPER_FUNC 33, 132, 264
    DEFINE_WRAPPER_FUNC 34, 136, 272
    DEFINE_WRAPPER_FUNC 35, 140, 280
    DEFINE_WRAPPER_FUNC 36, 144, 288
    DEFINE_WRAPPER_FUNC 37, 148, 296
    DEFINE_WRAPPER_FUNC 38, 152, 304
    DEFINE_WRAPPER_FUNC 39, 156, 312
    DEFINE_WRAPPER_FUNC 40, 160, 320
    DEFINE_WRAPPER_FUNC 41, 164, 328
    DEFINE_WRAPPER_FUNC 42, 168, 336
    DEFINE_WRAPPER_FUNC 43, 172, 344
    DEFINE_WRAPPER_FUNC 44, 176, 352
    DEFINE_WRAPPER_FUNC 45, 180, 360
    DEFINE_WRAPPER_FUNC 46, 184, 368
    DEFINE_WRAPPER_FUNC 47, 188, 376
    DEFINE_WRAPPER_FUNC 48, 192, 384
    DEFINE_WRAPPER_FUNC 49, 196, 392
    DEFINE_WRAPPER_FUNC 50, 200, 400
    DEFINE_WRAPPER_FUNC 51, 204, 408
    DEFINE_WRAPPER_FUNC 52, 208, 416
    DEFINE_WRAPPER_FUNC 53, 212, 424
    DEFINE_WRAPPER_FUNC 54, 216, 432
    DEFINE_WRAPPER_FUNC 55, 220, 440
    DEFINE_WRAPPER_FUNC 56, 224, 448
    DEFINE_WRAPPER_FUNC 57, 228, 456
    DEFINE_WRAPPER_FUNC 58, 232, 464
    DEFINE_WRAPPER_FUNC 59, 236, 472
    DEFINE_WRAPPER_FUNC 60, 240, 480
    DEFINE_WRAPPER_FUNC 61, 244, 488
    DEFINE_WRAPPER_FUNC 62, 248, 496
    DEFINE_WRAPPER_FUNC 63, 252, 504
    DEFINE_WRAPPER_FUNC 64, 256, 512
    DEFINE_WRAPPER_FUNC 65, 260, 520
    DEFINE_WRAPPER_FUNC 66, 264, 528
    DEFINE_WRAPPER_FUNC 67, 268, 536
    DEFINE_WRAPPER_FUNC 68, 272, 544
    DEFINE_WRAPPER_FUNC 69, 276, 552
    DEFINE_WRAPPER_FUNC 70, 280, 560
    DEFINE_WRAPPER_FUNC 71, 284, 568
    DEFINE_WRAPPER_FUNC 72, 288, 576
    DEFINE_WRAPPER_FUNC 73, 292, 584
    DEFINE_WRAPPER_FUNC 74, 296, 592
    DEFINE_WRAPPER_FUNC 75, 300, 600
    DEFINE_WRAPPER_FUNC 76, 304, 608
    DEFINE_WRAPPER_FUNC 77, 308, 616
    DEFINE_WRAPPER_FUNC 78, 312, 624
    DEFINE_WRAPPER_FUNC 79, 316, 632
    DEFINE_WRAPPER_FUNC 80, 320, 640
    DEFINE_WRAPPER_FUNC 81, 324, 648
    DEFINE_WRAPPER_FUNC 82, 328, 656
    DEFINE_WRAPPER_FUNC 83, 332, 664
    DEFINE_WRAPPER_FUNC 84, 336, 672
    DEFINE_WRAPPER_FUNC 85, 340, 680
    DEFINE_WRAPPER_FUNC 86, 344, 688
    DEFINE_WRAPPER_FUNC 87, 348, 696
    DEFINE_WRAPPER_FUNC 88, 352, 704
    DEFINE_WRAPPER_FUNC 89, 356, 712
    DEFINE_WRAPPER_FUNC 90, 360, 720
    DEFINE_WRAPPER_FUNC 91, 364, 728
    DEFINE_WRAPPER_FUNC 92, 368, 736
    DEFINE_WRAPPER_FUNC 93, 372, 744
    DEFINE_WRAPPER_FUNC 94, 376, 752
    DEFINE_WRAPPER_FUNC 95, 380, 760
    DEFINE_WRAPPER_FUNC 96, 384, 768
    DEFINE_WRAPPER_FUNC 97, 388, 776
    DEFINE_WRAPPER_FUNC 98, 392, 784
    DEFINE_WRAPPER_FUNC 99, 396, 792

    END
