#ifndef _FBT_HCI_ERROR_H
#define _FBT_HCI_ERROR_H

#define FBT_HCI_ERROR_SUCCESS                               				0x00
#define FBT_HCI_UNKNOWN_HCI_COMMAND											0x01
#define FBT_HCI_UNKNOWN_CONNECTION_IDENTIFIER								0x02
#define FBT_HCI_HARDWARE_FAILURE											0x03
#define FBT_HCI_PAGE_TIMEOUT												0x04
#define FBT_HCI_AUTHENTICATION_FAILURE										0x05
#define FBT_HCI_PIN_MISSING													0x06
#define FBT_HCI_MEMORY_CAPACITY_EXCEEDED									0x07
#define FBT_HCI_CONNECTION_TIMEOUT											0x08
#define FBT_HCI_CONNECTION_LIMIT EXCEEDED									0x09
#define FBT_HCI_SYNCHRONOUS_CONNECTION_LIMIT_TO_A_DEVICE EXCEEDED			0x0a
#define FBT_HCI_ACL_CONNECTION_ALREADY_EXISTS								0x0b
#define FBT_HCI_COMMAND_DISALLOWED											0x0c
#define FBT_HCI_CONNECTION_REJECTED_DUE_TO_LIMITED RESOURCES				0x0d
#define FBT_HCI_CONNECTION_REJECTED_DUE_TO_SECURITY REASONS					0x0e
#define FBT_HCI_CONNECTION_REJECTED_DUE_TO_UNACCEPTABLE BD_ADDR				0x0f
#define FBT_HCI_CONNECTION_ACCEPT_TIMEOUT_EXCEEDED							0x10
#define FBT_HCI_UNSUPPORTED_FEATURE_OR_PARAMETER VALUE						0x11
#define FBT_HCI_INVALID_HCI_COMMAND_PARAMETERS								0x12
#define FBT_HCI_REMOTE_USER_TERMINATED_CONNECTION							0x13
#define FBT_HCI_REMOTE_DEVICE_TERMINATED_CONNECTION_DUE_TO_LOW_RESOURCES	0x14
#define FBT_HCI_REMOTE_DEVICE_TERMINATED_CONNECTION_DUE_TO_POWER OFF		0x15
#define FBT_HCI_CONNECTION_TERMINATED_BY_LOCAL_HOST							0x16
#define FBT_HCI_REPEATED_ATTEMPTS											0x17
#define FBT_HCI_PAIRING_NOT ALLOWED											0x18
#define FBT_HCI_UNKNOWN_LMP_PDU												0x19
#define FBT_HCI_UNSUPPORTED_REMOTE_FEATURE									0x1a
#define FBT_HCI_SCO_OFFSET_REJECTED											0x1b
#define FBT_HCI_SCO_INTERVAL_REJECTED										0x1c
#define FBT_HCI_SCO_AIR_MODE_REJECTED										0x1d
#define FBT_HCI_INVALID_LMP_PARAMETERS										0x1e
#define FBT_HCI_UNSPECIFIED_ERROR											0x1f
#define FBT_HCI_UNSUPPORTED_LMP_PARAMETER_VALUE								0x20
#define FBT_HCI_ROLE_CHANGE_NOT_ALLOWED										0x21
#define FBT_HCI_LMP_RESPONSE_TIMEOUT										0x22
#define FBT_HCI_LMP_ERROR_TRANSACTION_COLLISION								0x23
#define FBT_HCI_LMP_PDU_NOT_ALLOWED											0x24
#define FBT_HCI_ENCRYPTION_MODE_NOT_ACCEPTABLE								0x25
#define FBT_HCI_LINK_KEY_CAN_NOT_BE_CHANGED									0x26
#define FBT_HCI_REQUESTED_QOS_NOT_SUPPORTED									0x27
#define FBT_HCI_INSTANT_PASSED												0x28
#define FBT_HCI_PAIRING_WITH_UNIT_KEY_NOT_SUPPORTED							0x29
#define FBT_HCI_DIFFERENT_TRANSACTION_COLLISION								0x2a
#define FBT_HCI_QOS_UNACCEPTABLE PARAMETER									0x2c
#define FBT_HCI_QOS_REJECTED												0x2d
#define FBT_HCI_CHANNEL_CLASSIFICATION_NOT_SUPPORTED						0x2e
#define FBT_HCI_INSUFFICIENT_SECURITY										0x2f
#define FBT_HCI_PARAMETER_OUT_OF_MANDATORY_RANGE							0x30
#define FBT_HCI_ROLE_SWITCH_PENDING											0x32
#define FBT_HCI_RESERVED_SLOT_VIOLATION										0x34
#define FBT_HCI_ROLE_SWITCH_FAILED											0x35

#define FBT_HCI_SUCCESS(x) (x==FBT_HCI_ERROR_SUCCESS)

#endif // _FBT_HCI_ERROR_H