#ifndef REG_H
#define REG_H

class CReg
{
	public:
		// Constructor
		CReg(LPCSTR lpszSubKey, HKEY hRootKey=HKEY_CURRENT_USER, REGSAM regSam=KEY_ALL_ACCESS, BOOL bCreate=TRUE);
		
		// Destructor
		~CReg();

		// Get the specified registry value
		BOOL GetValue(LPCSTR lpszValueName, LPVOID lpvData, DWORD *dwBuffSize=NULL, DWORD *dwDataType=NULL);
		BOOL GetValue(LPCSTR lpszValueName, LPSTR lpszValue, DWORD dwBalueSize);
//		BOOL GetValue(LPCSTR lpszValueName, CString &szData, DWORD *dwDataType=NULL);
		BOOL GetValue(LPCSTR lpszValueName, DWORD &dwData);
		BOOL GetValue(LPCSTR lpszValueName, BOOL &bData);
		
		// Set the specified registry value
		BOOL SetValue(LPCSTR lpszValueName, const LPVOID lpvData, DWORD dwDataSize, DWORD dwDataType=REG_SZ);
		BOOL SetValue(LPCSTR lpszValueName, LPCSTR lpszValue, DWORD dwDataSize=0, DWORD dwDataType=REG_SZ);
		BOOL SetValue(LPCSTR lpszValueName, LPSTR lpszValue, DWORD dwValueSize);
//		BOOL SetValue(LPCSTR lpszValueName, CString &szData, DWORD dwDataSize=0, DWORD dwDataType=REG_SZ);
		BOOL SetValue(LPCSTR lpszValueName, DWORD dwData);
		BOOL SetValue(LPCSTR lpszValueName, BOOL bData);

		// Delete a value in the key
		BOOL DeleteValue(LPCSTR lpszValueName);

		// Delete all the values in the key
		BOOL DeleteValues();
		
		// Delete a sub key
		BOOL DeleteKey(LPCSTR lpszKeyName);

		// Retrieve the names of the values in the key
//		BOOL EnumerateValues(CStringArray &nszValueNames);
		
		BOOL IsValid() {return m_hKey!=NULL;}

	protected:
		// Create a new registry key
		LONG Create(LPCSTR lpszSubKey, HKEY hRootKey, HKEY *hKey=NULL, REGSAM regSam=NULL);

		// Open the specified registry key (creates if non-existant)
		LONG Open(LPCSTR lpszSubKey, HKEY hRootKey, HKEY *hKey=NULL, REGSAM regSam=NULL, BOOL bCreate=TRUE);

		BOOL DeleteKey(HKEY hRootKey, HKEY hKey, LPCSTR szKey, LPCSTR szSubKey);
		
//		CString	m_szKey;		// Name of key this object wraps
		char	m_szKey[1024];	// Name of key this object wraps
		HKEY	m_hRootKey;		// Root key of the wrapped key
		HKEY	m_hKey;			// Key generated by Open/Create
		
};

#endif