#ifndef _SETUPAPI_H_
#define _SETUPAPI_H_

#include <commctrl.h>
#if defined(_WIN64)
#include <pshpack8.h>
#else
#include <pshpack1.h>
#endif
#ifdef __cplusplus
extern "C" {
#endif

#ifndef _SETUPAPI_
#define WINSETUPAPI DECLSPEC_IMPORT
#else
#define WINSETUPAPI
#endif

#define LINE_LEN	256
#define MAX_INF_STRING_LENGTH	4096
#define MAX_TITLE_LEN	60
#define MAX_INSTRUCTION_LEN	256
#define MAX_LABEL_LEN	30
#define MAX_SERVICE_NAME_LEN	256
#define MAX_SUBTITLE_LEN	256
#define SP_MAX_MACHINENAME_LENGTH	(MAX_PATH + 3)

#define COPYFLG_WARN_IF_SKIP	0x00000001
#define COPYFLG_NOSKIP	0x00000002
#define COPYFLG_NOVERSIONCHECK	0x00000004
#define COPYFLG_FORCE_FILE_IN_USE	0x00000008
#define COPYFLG_NO_OVERWRITE	0x00000010
#define COPYFLG_NO_VERSION_DIALOG	0x00000020
#define COPYFLG_OVERWRITE_OLDER_ONLY	0x00000040
#define COPYFLG_REPLACEONLY	0x00000400
#define COPYFLG_NODECOMP	0x00000800
#define COPYFLG_REPLACE_BOOT_FILE	0x00001000
#define COPYFLG_NOPRUNE	0x00002000
#define DELFLG_IN_USE	0x00000001
#define DELFLG_IN_USE1	0x00010000
#define DI_REMOVEDEVICE_GLOBAL	0x00000001
#define DI_REMOVEDEVICE_CONFIGSPECIFIC	0x00000002
#define DI_UNREMOVEDEVICE_CONFIGSPECIFIC	0x00000002
#define DI_SHOWOEM	0x00000001
#define DI_SHOWCOMPAT	0x00000002
#define DI_SHOWCLASS	0x00000004
#define DI_SHOWALL	0x00000007
#define DI_NOVCP	0x00000008
#define DI_DIDCOMPAT	0x00000010
#define DI_DIDCLASS	0x00000020
#define DI_AUTOASSIGNRES	0x00000040
#define DI_NEEDRESTART	0x00000080
#define DI_NEEDREBOOT	0x00000100
#define DI_NOBROWSE	0x00000200
#define DI_MULTMFGS	0x00000400
#define DI_DISABLED	0x00000800
#define DI_GENERALPAGE_ADDED	0x00001000
#define DI_RESOURCEPAGE_ADDED	0x00002000
#define DI_PROPERTIES_CHANGE	0x00004000
#define DI_INF_IS_SORTED	0x00008000
#define DI_ENUMSINGLEINF	0x00010000
#define DI_DONOTCALLCONFIGMG	0x00020000
#define DI_INSTALLDISABLED	0x00040000
#define DI_COMPAT_FROM_CLASS	0x00080000
#define DI_CLASSINSTALLPARAMS	0x00100000
#define DI_NODI_DEFAULTACTION	0x00200000
#define DI_QUIETINSTALL	0x00800000
#define DI_NOFILECOPY	0x01000000
#define DI_FORCECOPY	0x02000000
#define DI_DRIVERPAGE_ADDED	0x04000000
#define DI_USECI_SELECTSTRINGS	0x08000000
#define DI_OVERRIDE_INFFLAGS	0x10000000
#define DI_PROPS_NOCHANGEUSAGE	0x20000000
#define DI_NOSELECTICONS	0x40000000
#define DI_NOWRITE_IDS	0x80000000
#define DI_FLAGSEX_USEOLDINFSEARCH	0x00000001
#define DI_FLAGSEX_AUTOSELECTRANK0	0x00000002
#define DI_FLAGSEX_CI_FAILED	0x00000004
#define DI_FLAGSEX_DIDINFOLIST	0x00000010
#define DI_FLAGSEX_DIDCOMPATINFO	0x00000020
#define DI_FLAGSEX_FILTERCLASSES	0x00000040
#define DI_FLAGSEX_SETFAILEDINSTALL	0x00000080
#define DI_FLAGSEX_DEVICECHANGE	0x00000100
#define DI_FLAGSEX_ALWAYSWRITEIDS	0x00000200
#define DI_FLAGSEX_PROPCHANGE_PENDING	0x00000400
#define DI_FLAGSEX_ALLOWEXCLUDEDDRVS	0x00000800
#define DI_FLAGSEX_NOUIONQUERYREMOVE	0x00001000
#define DI_FLAGSEX_USECLASSFORCOMPAT	0x00002000
#define DI_FLAGSEX_OLDINF_IN_CLASSLIST	0x00004000
#define DI_FLAGSEX_NO_DRVREG_MODIFY	0x00008000
#define DI_FLAGSEX_IN_SYSTEM_SETUP	0x00010000
#define DI_FLAGSEX_INET_DRIVER	0x00020000
#define DI_FLAGSEX_APPENDDRIVERLIST	0x00040000
#define DI_FLAGSEX_PREINSTALLBACKUP	0x00080000
#define DI_FLAGSEX_BACKUPONREPLACE	0x00100000
#define DI_FLAGSEX_DRIVERLIST_FROM_URL	0x00200000
#define DI_FLAGSEX_RESERVED1	0x00400000
#define DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS	0x00800000
#define DI_FLAGSEX_POWERPAGE_ADDED	0x01000000
#if (_SETUPAPI_VER >= 0x0501)
#define DI_FLAGSEX_FILTERSIMILARDRIVERS	0x02000000
#define DI_FLAGSEX_INSTALLEDDRIVER	0x04000000
#define DI_FLAGSEX_NO_CLASSLIST_NODE_MERGE	0x08000000
#define DI_FLAGSEX_ALTPLATFORM_DRVSEARCH	0x10000000
#define DI_FLAGSEX_RESTART_DEVICE_ONLY	0x20000000
#endif
#define DIBCI_NOINSTALLCLASS	0x00000001
#define DIBCI_NODISPLAYCLASS	0x00000002
#define DICD_GENERATE_ID	0x00000001
#define DICD_INHERIT_CLASSDRVS	0x00000002
#define DICS_ENABLE	1
#define DICS_FLAG_GLOBAL	1
#define DICS_DISABLE	2
#define DICS_FLAG_CONFIGSPECIFIC	2
#define DICS_PROPCHANGE	3
#define DICS_START	4
#define DICS_FLAG_CONFIGGENERAL	4
#define DICS_STOP	5
#define DIF_SELECTDEVICE                    1
#define DIF_INSTALLDEVICE                   2
#define DIF_ASSIGNRESOURCES                 3
#define DIF_PROPERTIES                      4
#define DIF_REMOVE                          5
#define DIF_FIRSTTIMESETUP                  6
#define DIF_FOUNDDEVICE                     7
#define DIF_SELECTCLASSDRIVERS              8
#define DIF_VALIDATECLASSDRIVERS            9
#define DIF_INSTALLCLASSDRIVERS            10
#define DIF_CALCDISKSPACE                  11
#define DIF_DESTROYPRIVATEDATA             12
#define DIF_VALIDATEDRIVER                 13
#define DIF_MOVEDEVICE                     14
#define DIF_DETECT                         15
#define DIF_INSTALLWIZARD                  16
#define DIF_DESTROYWIZARDDATA              17
#define DIF_PROPERTYCHANGE                 18
#define DIF_ENABLECLASS                    19
#define DIF_DETECTVERIFY                   20
#define DIF_INSTALLDEVICEFILES             21
#define DIF_UNREMOVE                       22
#define DIF_SELECTBESTCOMPATDRV            23
#define DIF_ALLOW_INSTALL                  24
#define DIF_REGISTERDEVICE                 25
#define DIF_NEWDEVICEWIZARD_PRESELECT      26
#define DIF_NEWDEVICEWIZARD_SELECT         27
#define DIF_NEWDEVICEWIZARD_PREANALYZE     28
#define DIF_NEWDEVICEWIZARD_POSTANALYZE    29
#define DIF_NEWDEVICEWIZARD_FINISHINSTALL  30
#define DIF_UNUSED1                        31
#define DIF_INSTALLINTERFACES              32
#define DIF_DETECTCANCEL                   33
#define DIF_REGISTER_COINSTALLERS          34
#define DIF_ADDPROPERTYPAGE_ADVANCED       35
#define DIF_ADDPROPERTYPAGE_BASIC          36
#define DIF_RESERVED1                      37
#define DIF_TROUBLESHOOTER                 38
#define DIF_POWERMESSAGEWAKE               39
#define DIF_ADDREMOTEPROPERTYPAGE_ADVANCED 40
#define DIF_UPDATEDRIVER_UI                41
#define DIF_FINISHINSTALL_ACTION           42
#define DIF_RESERVED2                      48

#define DIGCDP_FLAG_BASIC	0x00000001
#define DIGCDP_FLAG_ADVANCED	0x00000002
#if (_SETUPAPI_VER >= 0x0501)
#define DIGCDP_FLAG_REMOTE_BASIC    0x00000003
#define DIGCDP_FLAG_REMOTE_ADVANCED 0x00000004
#endif
#define DIGCF_DEFAULT	0x00000001
#define DIGCF_PRESENT	0x00000002
#define DIGCF_ALLCLASSES	0x00000004
#define DIGCF_PROFILE	0x00000008
#define DIGCF_DEVICEINTERFACE	0x00000010
#define DIGCF_INTERFACEDEVICE	0x00000010
#define DIOCR_INSTALLER	0x00000001
#define DIOCR_INTERFACE	0x00000002
#define DIODI_NO_ADD	0x00000001
#define DIOD_INHERIT_CLASSDRVS	0x00000002
#define DIOD_CANCEL_REMOVE	0x00000004
#define DIREG_DEV	0x00000001
#define DIREG_DRV	0x00000002
#define DIREG_BOTH	0x00000004
#define DIRID_ABSOLUTE	-1
#define DIRID_NULL	0
#define DIRID_SRCPATH	1
#define DIRID_WINDOWS	10
#define DIRID_SYSTEM	11
#define DIRID_DRIVERS	12
#define DIRID_INF	17
#define DIRID_HELP	18
#define DIRID_FONTS	20
#define DIRID_VIEWERS	21
#define DIRID_COLOR	23
#define DIRID_APPS	24
#define DIRID_SHARED	25
#define DIRID_BOOT	30
#define DIRID_SYSTEM16	50
#define DIRID_SPOOL	51
#define DIRID_SPOOLDRIVERS	52
#define DIRID_USERPROFILE	53
#define DIRID_LOADER	54
#define DIRID_PRINTPROCESSOR	55
#define DIRID_COMMON_STARTMENU	16406
#define DIRID_COMMON_PROGRAMS	16407
#define DIRID_COMMON_STARTUP	16408
#define DIRID_COMMON_DESKTOPDIRECTORY	16409
#define DIRID_COMMON_FAVORITES	16415
#define DIRID_COMMON_APPDATA	16419
#define DIRID_PROGRAM_FILES	16422
#define DIRID_SYSTEM_X86	16425
#define DIRID_PROGRAM_FILES_X86	16426
#define DIRID_PROGRAM_FILES_COMMON	16427
#define DIRID_PROGRAM_FILES_COMMONX86	16428
#define DIRID_COMMON_TEMPLATES	16429
#define DIRID_COMMON_DOCUMENTS	16430
#define DIRID_USER	0x8000
#define DIRID_ABSOLUTE_16BIT	0xffff
#define DIRID_IOSUBSYS	DIRID_DRIVERS
#define DIRID_DEFAULT	DIRID_SYSTEM
#define DMI_MASK	0x00000001
#define DMI_BKCOLOR	0x00000002
#define DMI_USERECT	0x00000004
#define DN_ROOT_ENUMERATED	0x00000001
#define DN_DRIVER_LOADED	0x00000002
#define DN_ENUM_LOADED	0x00000004
#define DN_STARTED	0x00000008
#define DN_MANUAL	0x00000010
#define DN_NEED_TO_ENUM	0x00000020
#define DN_NOT_FIRST_TIME	0x00000040
#define DN_HARDWARE_ENUM	0x00000080
#define DN_LIAR	0x00000100
#define DN_HAS_MARK	0x00000200
#define DN_HAS_PROBLEM	0x00000400
#define DN_FILTERED	0x00000800
#define DN_MOVED	0x00001000
#define DN_DISABLEABLE	0x00002000
#define DN_REMOVABLE	0x00004000
#define DN_PRIVATE_PROBLEM	0x00008000
#define DN_MF_PARENT	0x00010000
#define DN_MF_CHILD	0x00020000
#define DN_WILL_BE_REMOVED	0x00040000
#define DN_NOT_FIRST_TIMEE	0x00080000
#define DN_STOP_FREE_RES	0x00100000
#define DN_REBAL_CANDIDATE	0x00200000
#define DN_BAD_PARTIAL	0x00400000
#define DN_NT_ENUMERATOR	0x00800000
#define DN_NT_DRIVER	0x01000000
#define DN_NEEDS_LOCKING	0x02000000
#define DN_ARM_WAKEUP	0x04000000
#define DN_APM_ENUMERATOR	0x08000000
#define DN_APM_DRIVER	0x10000000
#define DN_SILENT_INSTALL	0x20000000
#define DN_NO_SHOW_IN_DM	0x40000000
#define DN_BOOT_LOG_PROB	0x80000000
#define DNF_DUPDESC	0x00000001
#define DNF_OLDDRIVER	0x00000002
#define DNF_EXCLUDEFROMLIST	0x00000004
#define DNF_NODRIVER	0x00000008
#define DNF_LEGACYINF	0x00000010
#define DNF_CLASS_DRIVER	0x00000020
#define DNF_COMPATIBLE_DRIVER	0x00000040
#define DNF_INET_DRIVER	0x00000080
#define DNF_UNUSED1	0x00000100
#define DNF_INDEXED_DRIVER	0x00000200
#define DNF_OLD_INET_DRIVER	0x00000400
#define DNF_BAD_DRIVER	0x00000800
#define DNF_DUPPROVIDER	0x00001000
#define DPROMPT_SUCCESS	0
#define DPROMPT_CANCEL	1
#define DPROMPT_SKIPFILE	2
#define DPROMPT_BUFFERTOOSMALL	3
#define DPROMPT_OUTOFMEMORY	4
#define DRIVER_HARDWAREID_RANK	0x00000FFF
#define DYNAWIZ_FLAG_PAGESADDED	0x00000001
#define DYNAWIZ_FLAG_INSTALLDET_NEXT	0x00000002
#define DYNAWIZ_FLAG_INSTALLDET_PREV	0x00000004
#define DYNAWIZ_FLAG_ANALYZE_HANDLECONFLICT	0x00000008
#define ENABLECLASS_QUERY	0
#define ENABLECLASS_SUCCESS	1
#define ENABLECLASS_FAILURE	2
#define ERROR_EXPECTED_SECTION_NAME	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0)
#define ERROR_BAD_SECTION_NAME_LINE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|1)
#define ERROR_SECTION_NAME_TOO_LONG	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|2)
#define ERROR_GENERAL_SYNTAX	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|3)
#define ERROR_WRONG_INF_STYLE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x100)
#define ERROR_NOT_INSTALLED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x1000)
#define ERROR_SECTION_NOT_FOUND	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x101)
#define ERROR_LINE_NOT_FOUND	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x102)
#define ERROR_NO_BACKUP	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x103)
#define ERROR_NO_ASSOCIATED_CLASS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x200)
#define ERROR_CLASS_MISMATCH	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x201)
#define ERROR_DUPLICATE_FOUND	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x202)
#define ERROR_NO_DRIVER_SELECTED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x203)
#define ERROR_KEY_DOES_NOT_EXIST	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x204)
#define ERROR_INVALID_DEVINST_NAME	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x205)
#define ERROR_INVALID_CLASS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x206)
#define ERROR_DEVINST_ALREADY_EXISTS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x207)
#define ERROR_DEVINFO_NOT_REGISTERED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x208)
#define ERROR_INVALID_REG_PROPERTY	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x209)
#define ERROR_NO_INF	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20A)
#define ERROR_NO_SUCH_DEVINST	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20B)
#define ERROR_CANT_LOAD_CLASS_ICON	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20C)
#define ERROR_INVALID_CLASS_INSTALLER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20D)
#define ERROR_DI_DO_DEFAULT	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20E)
#define ERROR_DI_NOFILECOPY	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20F)
#define ERROR_INVALID_HWPROFILE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x210)
#define ERROR_NO_DEVICE_SELECTED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x211)
#define ERROR_DEVINFO_LIST_LOCKED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x212)
#define ERROR_DEVINFO_DATA_LOCKED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x213)
#define ERROR_DI_BAD_PATH	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x214)
#define ERROR_NO_CLASSINSTALL_PARAMS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x215)
#define ERROR_FILEQUEUE_LOCKED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x216)
#define ERROR_BAD_SERVICE_INSTALLSECT	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x217)
#define ERROR_NO_CLASS_DRIVER_LIST	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x218)
#define ERROR_NO_ASSOCIATED_SERVICE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x219)
#define ERROR_NO_DEFAULT_DEVICE_INTERFACE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21A)
#define ERROR_DEVICE_INTERFACE_ACTIVE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21B)
#define ERROR_DEVICE_INTERFACE_REMOVED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21C)
#define ERROR_BAD_INTERFACE_INSTALLSECT	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21D)
#define ERROR_NO_SUCH_INTERFACE_CLASS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21E)
#define ERROR_INVALID_REFERENCE_STRING	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21F)
#define ERROR_INVALID_MACHINENAME	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x220)
#define ERROR_REMOTE_COMM_FAILURE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x221)
#define ERROR_MACHINE_UNAVAILABLE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x222)
#define ERROR_NO_CONFIGMGR_SERVICES	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x223)
#define ERROR_INVALID_PROPPAGE_PROVIDER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x224)
#define ERROR_NO_SUCH_DEVICE_INTERFACE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x225)
#define ERROR_DI_POSTPROCESSING_REQUIRED	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x226)
#define ERROR_INVALID_COINSTALLER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x227)
#define ERROR_NO_COMPAT_DRIVERS	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x228)
#define ERROR_NO_DEVICE_ICON	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x229)
#define ERROR_INVALID_INF_LOGCONFIG	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22A)
#define ERROR_DI_DONT_INSTALL	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22B)
#define ERROR_INVALID_FILTER_DRIVER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22C)
#define ERROR_NON_WINDOWS_NT_DRIVER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22D)
#define ERROR_NON_WINDOWS_DRIVER	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22E)
#define ERROR_NO_CATALOG_FOR_OEM_INF	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22F)
#define ERROR_DEVINSTALL_QUEUE_NONNATIVE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x230)
#define ERROR_NOT_DISABLEABLE	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x231)
#define ERROR_CANT_REMOVE_DEVINST	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x232)
#define ERROR_IN_WOW64	(APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x235)
#define ERROR_INTERFACE_DEVICE_ACTIVE	ERROR_DEVICE_INTERFACE_ACTIVE
#define ERROR_INTERFACE_DEVICE_REMOVED	ERROR_DEVICE_INTERFACE_REMOVED
#define ERROR_NO_DEFAULT_INTERFACE_DEVICE	ERROR_NO_DEFAULT_DEVICE_INTERFACE
#define ERROR_NO_SUCH_INTERFACE_DEVICE	ERROR_NO_SUCH_DEVICE_INTERFACE
#define ERROR_WRONG_INF_TYPE              (APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x24A)

#define FILEOP_COPY	0
#define FILEOP_ABORT	0
#define FILE_COMPRESSION_NONE	0
#define FILEOP_RENAME	1
#define FILEOP_DOIT	1
#define FILE_COMPRESSION_WINLZA	1
#define FILEOP_DELETE	2
#define FILEOP_SKIP	2
#define FILE_COMPRESSION_MSZIP	2
#define FILEOP_BACKUP	3
#define FILE_COMPRESSION_NTCAB	3
#define FILEOP_NEWPATH	4
#define FILEOP_RETRY	FILEOP_DOIT
#define FLG_ADDREG_TYPE_SZ	0x00000000
#define FLG_ADDREG_BINVALUETYPE	0x00000001
#define FLG_ADDREG_NOCLOBBER	0x00000002
#define FLG_ADDREG_DELVAL	0x00000004
#define FLG_ADDREG_APPEND	0x00000008
#define FLG_ADDREG_KEYONLY	0x00000010
#define FLG_ADDREG_OVERWRITEONLY	0x00000020
#if (_SETUPAPI_VER >= 0x0501)
#define FLG_ADDREG_64BITKEY	0x00001000
#define FLG_ADDREG_KEYONLY_COMMON	0x00002000
#define FLG_ADDREG_32BITKEY	0x00004000
#define FLG_ADDREG_DELREG_BIT	0x00008000
#endif
#define FLG_ADDREG_TYPE_MULTI_SZ	0x00010000
#define FLG_ADDREG_TYPE_EXPAND_SZ	0x00020000
#define FLG_ADDREG_TYPE_BINARY	(0x00000000|FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_DWORD	(0x00010000|FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_NONE	(0x00020000|FLG_ADDREG_BINVALUETYPE)
#define FLG_ADDREG_TYPE_MASK	(0xFFFF0000|FLG_ADDREG_BINVALUETYPE)
#define FLG_DELREG_VALUE	0x00000000
#if (_SETUPAPI_VER >= 0x0501)
#define FLG_DELREG_TYPE_MASK	FLG_ADDREG_TYPE_MASK
#define FLG_DELREG_TYPE_SZ	FLG_ADDREG_TYPE_SZ
#define FLG_DELREG_TYPE_MULTI_SZ	FLG_ADDREG_TYPE_MULTI_SZ
#define FLG_DELREG_TYPE_EXPAND_SZ	FLG_ADDREG_TYPE_EXPAND_SZ
#define FLG_DELREG_TYPE_BINARY	FLG_ADDREG_TYPE_BINARY
#define FLG_DELREG_TYPE_DWORD	FLG_ADDREG_TYPE_DWORD
#define FLG_DELREG_TYPE_NONE	FLG_ADDREG_TYPE_NONE
#define FLG_DELREG_64BITKEY	FLG_ADDREG_64BITKEY
#define FLG_DELREG_KEYONLY_COMMON	FLG_ADDREG_KEYONLY_COMMON
#define FLG_DELREG_32BITKEY	FLG_ADDREG_32BITKEY
#define FLG_DELREG_OPERATION_MASK	0x000000FE
#define FLG_DELREG_MULTI_SZ_DELSTRING	(0x00000002|FLG_DELREG_TYPE_MULTI_SZ|FLG_ADDREG_DELREG_BIT)
#endif
#define FLG_BITREG_CLEARBITS	0x00000000
#define FLG_BITREG_SETBITS	0x00000001
#define FLG_PROFITEM_CURRENTUSER	0x00000001
#define FLG_PROFITEM_DELETE	0x00000002
#define FLG_PROFITEM_GROUP	0x00000004
#define FLG_PROFITEM_CSIDL	0x00000008
#define FLG_REGSVR_DLLREGISTER	0x00000001
#define FLG_REGSVR_DLLINSTALL	0x00000002
#define MIN_IDD_DYNAWIZ_RESOURCE_ID	10000
#define MAX_IDD_DYNAWIZ_RESOURCE_ID	11000
#define IDD_DYNAWIZ_FIRSTPAGE	10000
#define IDD_DYNAWIZ_SELECT_PREVPAGE	10001
#define IDD_DYNAWIZ_SELECT_NEXTPAGE	10002
#define IDD_DYNAWIZ_ANALYZE_PREVPAGE	10003
#define IDD_DYNAWIZ_ANALYZE_NEXTPAGE	10004
#define IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE	10006
#define IDD_DYNAWIZ_INSTALLDETECTED_NEXTPAGE	10007
#define IDD_DYNAWIZ_INSTALLDETECTED_NODEVS	10008
#define IDD_DYNAWIZ_SELECTDEV_PAGE	10009
#define IDD_DYNAWIZ_ANALYZEDEV_PAGE	10010
#define IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE	10011
#define IDD_DYNAWIZ_SELECTCLASS_PAGE	10012
#define IDF_NOBROWSE	0x00000001
#define IDF_NOSKIP	0x00000002
#define IDF_NODETAILS	0x00000004
#define IDF_NOCOMPRESSED	0x00000008
#define IDF_CHECKFIRST	0x00000100
#define IDF_NOBEEP	0x00000200
#define IDF_NOFOREGROUND	0x00000400
#define IDF_WARNIFSKIP	0x00000800
#define IDF_OEMDISK	0x80000000
#define IDI_RESOURCEFIRST	159
#define IDI_RESOURCE	159
#define IDI_RESOURCELAST	161
#define IDI_RESOURCEOVERLAYFIRST	161
#define IDI_RESOURCEOVERLAYLAST	161
#define IDI_CONFLICT	161
#define IDI_PROBLEM_OVL	500
#define IDI_DISABLED_OVL	501
#define IDI_FORCED_OVL	502
#define IDI_CLASSICON_OVERLAYFIRST	500
#define IDI_CLASSICON_OVERLAYLAST	502
#define INF_STYLE_NONE	0x00000000
#define INF_STYLE_OLDNT	0x00000001
#define INF_STYLE_WIN4	0x00000002
#define INF_STYLE_CACHE_ENABLE	0x00000010
#define INF_STYLE_CACHE_DISABLE	0x00000020
#define INFINFO_INF_SPEC_IS_HINF	1
#define INFINFO_INF_NAME_IS_ABSOLUTE	2
#define INFINFO_DEFAULT_SEARCH	3
#define INFINFO_REVERSE_DEFAULT_SEARCH	4
#define INFINFO_INF_PATH_LIST_SEARCH	5
#define LogSevInformation	0
#define LogSevWarning	1
#define LogSevError	2
#define LogSevFatalError	3
#define LogSevMaximum	4
#define LogSeverity	DWORD
#define MAX_INSTALLWIZARD_DYNAPAGES	20
#define NDW_INSTALLFLAG_DIDFACTDEFS	0x00000001
#define NDW_INSTALLFLAG_HARDWAREALLREADYIN	0x00000002
#define NDW_INSTALLFLAG_NEEDSHUTDOWN	0x00000200
#define NDW_INSTALLFLAG_EXPRESSINTRO	0x00000400
#define NDW_INSTALLFLAG_SKIPISDEVINSTALLED	0x00000800
#define NDW_INSTALLFLAG_NODETECTEDDEVS	0x00001000
#define NDW_INSTALLFLAG_INSTALLSPECIFIC	0x00002000
#define NDW_INSTALLFLAG_SKIPCLASSLIST	0x00004000
#define NDW_INSTALLFLAG_CI_PICKED_OEM	0x00008000
#define NDW_INSTALLFLAG_PCMCIAMODE	0x00010000
#define NDW_INSTALLFLAG_PCMCIADEVICE	0x00020000
#define NDW_INSTALLFLAG_USERCANCEL	0x00040000
#define NDW_INSTALLFLAG_KNOWNCLASS	0x00080000
#define NDW_INSTALLFLAG_NEEDRESTART	0x00000080
#define NDW_INSTALLFLAG_NEEDREBOOT	0x00000100
#define SETDIRID_NOT_FULL_PATH	0x00000001
#define SP_COPY_DELETESOURCE	0x0000001
#define SP_COPY_REPLACEONLY	0x0000002
#define SP_COPY_NEWER	0x0000004
#define SP_COPY_NEWER_OR_SAME	0x0000004
#define SP_COPY_NOOVERWRITE	0x0000008
#define SP_COPY_NODECOMP	0x0000010
#define SP_COPY_LANGUAGEAWARE	0x0000020
#define SP_COPY_SOURCE_ABSOLUTE	0x0000040
#define SP_COPY_SOURCEPATH_ABSOLUTE	0x0000080
#define SP_COPY_IN_USE_NEEDS_REBOOT	0x0000100
#define SP_COPY_FORCE_IN_USE	0x0000200
#define SP_COPY_NOSKIP	0x0000400
#define SP_COPY_FORCE_NOOVERWRITE	0x0001000
#define SP_COPY_FORCE_NEWER	0x0002000
#define SP_COPY_WARNIFSKIP	0x0004000
#define SP_COPY_NOBROWSE	0x0008000
#define SP_COPY_NEWER_ONLY	0x0010000
#define SP_COPY_SOURCE_SIS_MASTER	0x0020000
#define SP_COPY_OEMINF_CATALOG_ONLY	0x0040000
#define SP_COPY_REPLACE_BOOT_FILE	0x0080000
#define SP_COPY_NOPRUNE	0x0100000
#define SP_FLAG_CABINETCONTINUATION	0x0000800
#define SPCRP_SECURITY	23
#define SPCRP_SECURITY_SDS	24
#define SPCRP_DEVTYPE	25
#define SPCRP_EXCLUSIVE	26
#define SPCRP_CHARACTERISTICS	27
#define SPCRP_MAXIMUM_PROPERTY	28
#define SPDIT_NODRIVER	0
#define SPDIT_CLASSDRIVER	1
#define SPDIT_COMPATDRIVER	2
#define SPDRP_DEVICEDESC	0
#define SPDRP_HARDWAREID	1
#define SPDRP_COMPATIBLEIDS	2
#define SPDRP_UNUSED0	3
#define SPDRP_SERVICE	4
#define SPDRP_UNUSED1	5
#define SPDRP_UNUSED2	6
#define SPDRP_CLASS	7
#define SPDRP_CLASSGUID	8
#define SPDRP_DRIVER	9
#define SPDRP_CONFIGFLAGS	10
#define SPDRP_MFG	11
#define SPDRP_FRIENDLYNAME	12
#define SPDRP_LOCATION_INFORMATION	13
#define SPDRP_PHYSICAL_DEVICE_OBJECT_NAME	14
#define SPDRP_CAPABILITIES	15
#define SPDRP_UI_NUMBER	16
#define SPDRP_UPPERFILTERS	17
#define SPDRP_LOWERFILTERS	18
#define SPDRP_BUSTYPEGUID	19
#define SPDRP_LEGACYBUSTYPE	20
#define SPDRP_BUSNUMBER	21
#define SPDRP_ENUMERATOR_NAME	22
#define SPDRP_SECURITY	23
#define SPDRP_SECURITY_SDS	24
#define SPDRP_DEVTYPE	25
#define SPDRP_EXCLUSIVE	26
#define SPDRP_CHARACTERISTICS	27
#define SPDRP_ADDRESS	28
#define SPDRP_UI_NUMBER_DESC_FORMAT	29
#define SPDRP_DEVICE_POWER_DATA	30
#define SPDRP_REMOVAL_POLICY	31
#define SPDRP_REMOVAL_POLICY_HW_DEFAULT	32
#define SPDRP_REMOVAL_POLICY_OVERRIDE	33
#define SPDRP_INSTALL_STATE	34
#define SPDRP_MAXIMUM_PROPERTY	35
#define SPDSL_IGNORE_DISK	1
#define SPDSL_DISALLOW_NEGATIVE_ADJUST	2

#define SPFILENOTIFY_STARTQUEUE	1
#define SPFILENOTIFY_ENDQUEUE	2
#define SPFILENOTIFY_STARTSUBQUEUE	3
#define SPFILENOTIFY_ENDSUBQUEUE	4
#define SPFILENOTIFY_STARTDELETE	5
#define SPFILENOTIFY_ENDDELETE	6
#define SPFILENOTIFY_DELETEERROR	7
#define SPFILENOTIFY_STARTRENAME	8
#define SPFILENOTIFY_ENDRENAME	9
#define SPFILENOTIFY_RENAMEERROR	10
#define SPFILENOTIFY_STARTCOPY	11
#define SPFILENOTIFY_ENDCOPY	12
#define SPFILENOTIFY_COPYERROR	13
#define SPFILENOTIFY_NEEDMEDIA	14
#define SPFILENOTIFY_QUEUESCAN	15
#define SPFILENOTIFY_CABINETINFO	16
#define SPFILENOTIFY_FILEINCABINET	17
#define SPFILENOTIFY_NEEDNEWCABINET	18
#define SPFILENOTIFY_FILEEXTRACTED	19
#define SPFILENOTIFY_FILEOPDELAYED	20
#define SPFILENOTIFY_STARTBACKUP	21
#define SPFILENOTIFY_BACKUPERROR	22
#define SPFILENOTIFY_ENDBACKUP	23
#define SPFILENOTIFY_QUEUESCAN_EX	24
#define SPFILENOTIFY_STARTREGISTRATION	25
#define SPFILENOTIFY_ENDREGISTRATION	26
#define SPFILENOTIFY_LANGMISMATCH	0x00010000
#define SPFILENOTIFY_TARGETEXISTS	0x00020000
#define SPFILENOTIFY_TARGETNEWER	0x00040000
#define SPFILELOG_SYSTEMLOG	0x00000001
#define SPFILELOG_OEMFILE	0x00000001
#define SPFILELOG_FORCENEW	0x00000002
#define SPFILELOG_QUERYONLY	0x00000004
#define SPFILEQ_FILE_IN_USE	0x00000001
#define SPFILEQ_REBOOT_RECOMMENDED	0x00000002
#define SPFILEQ_REBOOT_IN_PROGRESS	0x00000004
#define SPINT_ACTIVE	0x00000001
#define SPINT_DEFAULT	0x00000002
#define SPINT_REMOVED	0x00000004
#define SPID_ACTIVE	0x00000001
#define SPID_DEFAULT	0x00000002
#define SPID_REMOVED	0x00000004
#define SPINST_LOGCONFIG	0x00000001
#define SPINST_INIFILES	0x00000002
#define SPINST_REGISTRY	0x00000004
#define SPINST_INI2REG	0x00000008
#define SPINST_FILES	0x00000010
#define SPINST_BITREG	0x00000020
#define SPINST_REGSVR	0x00000040
#define SPINST_UNREGSVR	0x00000080
#define SPINST_PROFILEITEMS	0x00000100
#if (_SETUPAPI_VER >= 0x0501)
#define SPINST_COPYINF	0x00000200
#define SPINST_ALL	0x000003ff
#else
#define SPINST_ALL	0x000001ff
#endif
#define SPINST_SINGLESECTION	0x00010000
#define SPINST_LOGCONFIG_IS_FORCED	0x00020000
#define SPINST_LOGCONFIGS_ARE_OVERRIDES	0x00040000
#if (_SETUPAPI_VER >= 0x0501)
#define SPINST_REGISTERCALLBACKAWARE	0x00080000
#endif
#define SPOST_NONE	0
#define SPOST_PATH	1
#define SPOST_URL	2
#define SPOST_MAX	3
#define SPPSR_SELECT_DEVICE_RESOURCES	1
#define SPPSR_ENUM_BASIC_DEVICE_PROPERTIES	2
#define SPPSR_ENUM_ADV_DEVICE_PROPERTIES	3
#define SPQ_SCAN_FILE_PRESENCE	0x00000001
#define SPQ_DELAYED_COPY	0x00000001
#define SPQ_SCAN_FILE_VALIDITY	0x00000002
#define SPQ_SCAN_USE_CALLBACK	0x00000004
#define SPQ_SCAN_USE_CALLBACKEX	0x00000008
#define SPQ_SCAN_INFORM_USER	0x00000010
#define SPQ_SCAN_PRUNE_COPY_QUEUE	0x00000020
#define SPRDI_FIND_DUPS	0x00000001

#define SPSVCINST_TAGTOFRONT               0x00000001
#define SPSVCINST_ASSOCSERVICE             0x00000002
#define SPSVCINST_DELETEEVENTLOGENTRY      0x00000004
#define SPSVCINST_NOCLOBBER_DISPLAYNAME    0x00000008
#define SPSVCINST_NOCLOBBER_STARTTYPE      0x00000010
#define SPSVCINST_NOCLOBBER_ERRORCONTROL   0x00000020
#define SPSVCINST_NOCLOBBER_LOADORDERGROUP 0x00000040
#define SPSVCINST_NOCLOBBER_DEPENDENCIES   0x00000080
#define SPSVCINST_NOCLOBBER_DESCRIPTION    0x00000100
#define SPSVCINST_STOPSERVICE              0x00000200
#define SPSVCINST_CLOBBER_SECURITY         0x00000400
#define SPSVCINST_STARTSERVICE             0x00000800

#define SPWPT_SELECTDEVICE	0x00000001
#define SPWP_USE_DEVINFO_DATA	0x00000001
#define SRCINFO_PATH	1
#define SRCINFO_TAGFILE	2
#define SRCINFO_DESCRIPTION	3
#define SRCINFO_FLAGS	4
#define SRCLIST_TEMPORARY	0x00000001
#define SRCLIST_NOBROWSE	0x00000002
#define SRCLIST_SYSTEM	0x00000010
#define SRCLIST_USER	0x00000020
#define SRCLIST_SYSIFADMIN	0x00000040
#define SRCLIST_SUBDIRS	0x00000100
#define SRCLIST_APPEND	0x00000200
#define SRCLIST_NOSTRIPPLATFORM	0x00000400
#define SPREG_SUCCESS	0x00000000
#define SPREG_LOADLIBRARY	0x00000001
#define SPREG_GETPROCADDR	0x00000002
#define SPREG_REGSVR	0x00000003
#define SPREG_DLLINSTALL	0x00000004
#define SPREG_TIMEOUT	0x00000005
#define SPREG_UNKNOWN	0xFFFFFFFF

/* Flags for StringTableAddString and StringTableLookUpString */
#define ST_CASE_SENSITIVE_COMPARE	0x00000001

/* SetupUninstallOEMInf Flags values */
#define SUOI_FORCEDELETE 0x00000001

#ifndef RC_INVOKED
typedef PVOID HINF;
typedef PVOID HDSKSPC;
typedef PVOID HDEVINFO;
typedef PVOID HSPFILEQ;
typedef PVOID HSPFILELOG;
typedef UINT DI_FUNCTION;

typedef PVOID HSTRING_TABLE;

typedef enum {
    SetupFileLogSourceFilename,
    SetupFileLogChecksum,
    SetupFileLogDiskTagfile,
    SetupFileLogDiskDescription,
    SetupFileLogOtherInfo,
    SetupFileLogMax
} SetupFileLogInfo;
typedef struct _INFCONTEXT {
    PVOID Inf;
    PVOID CurrentInf;
    UINT Section;
    UINT Line;
} INFCONTEXT, *PINFCONTEXT;
typedef struct _SP_INF_INFORMATION {
    DWORD InfStyle;
    DWORD InfCount;
    BYTE VersionData[ANYSIZE_ARRAY];
} SP_INF_INFORMATION, *PSP_INF_INFORMATION;
typedef struct _SP_INF_SIGNER_INFO_A {
  DWORD cbSize;
  CHAR CatalogFile;
  CHAR DigitalSigner;
  CHAR DigitalSignerVersion;
} SP_INF_SIGNER_INFO_A, *PSP_INF_SIGNER_INFO_A;
typedef struct _SP_INF_SIGNER_INFO_W {
  DWORD cbSize;
  WCHAR CatalogFile;
  WCHAR DigitalSigner;
  WCHAR DigitalSignerVersion;
} SP_INF_SIGNER_INFO_W, *PSP_INF_SIGNER_INFO_W;
typedef struct _SP_ALTPLATFORM_INFO_V1 {
    DWORD cbSize;
    DWORD Platform;
    DWORD MajorVersion;
    DWORD MinorVersion;
    WORD  ProcessorArchitecture;
    WORD  Reserved;
} SP_ALTPLATFORM_INFO_V1, *PSP_ALTPLATFORM_INFO_V1;
typedef struct _SP_ALTPLATFORM_INFO_V2 {
  DWORD cbSize;
  DWORD Platform;
  DWORD MajorVersion;
  DWORD MinorVersion;
  WORD  ProcessorArchitecture;
    union
    {
        WORD  Reserved;
        WORD  Flags;
    } DUMMYUNIONNAME;
  DWORD FirstValidatedMajorVersion;
  DWORD FirstValidatedMinorVersion;
} SP_ALTPLATFORM_INFO_V2, *PSP_ALTPLATFORM_INFO_V2;
#if _WIN32_WINNT <= 0x0500
typedef SP_ALTPLATFORM_INFO_V1 SP_ALTPLATFORM_INFO;
typedef PSP_ALTPLATFORM_INFO_V1 PSP_ALTPLATFORM_INFO;
#else
typedef SP_ALTPLATFORM_INFO_V2 SP_ALTPLATFORM_INFO;
typedef PSP_ALTPLATFORM_INFO_V2 PSP_ALTPLATFORM_INFO;
#endif
typedef struct _SP_ORIGINAL_FILE_INFO_A {
    DWORD  cbSize;
    CHAR   OriginalInfName[MAX_PATH];
    CHAR   OriginalCatalogName[MAX_PATH];
} SP_ORIGINAL_FILE_INFO_A, *PSP_ORIGINAL_FILE_INFO_A;
typedef struct _SP_ORIGINAL_FILE_INFO_W {
    DWORD  cbSize;
    WCHAR  OriginalInfName[MAX_PATH];
    WCHAR  OriginalCatalogName[MAX_PATH];
} SP_ORIGINAL_FILE_INFO_W, *PSP_ORIGINAL_FILE_INFO_W;
typedef struct _FILEPATHS_A {
    PCSTR  Target;
    PCSTR  Source;
    UINT   Win32Error;
    DWORD  Flags;
} FILEPATHS_A, *PFILEPATHS_A;
typedef struct _FILEPATHS_W {
    PCWSTR Target;
    PCWSTR Source;
    UINT   Win32Error;
    DWORD  Flags;
} FILEPATHS_W, *PFILEPATHS_W;
typedef struct _SOURCE_MEDIA_A {
    PCSTR Reserved;
    PCSTR Tagfile;
    PCSTR Description;
    PCSTR SourcePath;
    PCSTR SourceFile;
    DWORD Flags;
} SOURCE_MEDIA_A, *PSOURCE_MEDIA_A;
typedef struct _SOURCE_MEDIA_W {
    PCWSTR Reserved;
    PCWSTR Tagfile;
    PCWSTR Description;
    PCWSTR SourcePath;
    PCWSTR SourceFile;
    DWORD  Flags;
} SOURCE_MEDIA_W, *PSOURCE_MEDIA_W;
typedef struct _CABINET_INFO_A {
    PCSTR CabinetPath;
    PCSTR CabinetFile;
    PCSTR DiskName;
    USHORT SetId;
    USHORT CabinetNumber;
} CABINET_INFO_A, *PCABINET_INFO_A;
typedef struct _CABINET_INFO_W {
    PCWSTR CabinetPath;
    PCWSTR CabinetFile;
    PCWSTR DiskName;
    USHORT SetId;
    USHORT CabinetNumber;
} CABINET_INFO_W, *PCABINET_INFO_W;
typedef struct _FILE_IN_CABINET_INFO_A {
    PCSTR NameInCabinet;
    DWORD FileSize;
    DWORD Win32Error;
    WORD  DosDate;
    WORD  DosTime;
    WORD  DosAttribs;
    CHAR  FullTargetName[MAX_PATH];
} FILE_IN_CABINET_INFO_A, *PFILE_IN_CABINET_INFO_A;
typedef struct _FILE_IN_CABINET_INFO_W {
    PCWSTR NameInCabinet;
    DWORD  FileSize;
    DWORD  Win32Error;
    WORD   DosDate;
    WORD   DosTime;
    WORD   DosAttribs;
    WCHAR  FullTargetName[MAX_PATH];
} FILE_IN_CABINET_INFO_W, *PFILE_IN_CABINET_INFO_W;
typedef struct _SP_FILE_COPY_PARAMS_A {
    DWORD    cbSize;
    HSPFILEQ QueueHandle;
    PCSTR    SourceRootPath;
    PCSTR    SourcePath;
    PCSTR    SourceFilename;
    PCSTR    SourceDescription;
    PCSTR    SourceTagfile;
    PCSTR    TargetDirectory;
    PCSTR    TargetFilename;
    DWORD    CopyStyle;
    HINF     LayoutInf;
    PCSTR    SecurityDescriptor;
} SP_FILE_COPY_PARAMS_A, *PSP_FILE_COPY_PARAMS_A;
typedef struct _SP_FILE_COPY_PARAMS_W {
    DWORD    cbSize;
    HSPFILEQ QueueHandle;
    PCWSTR   SourceRootPath;
    PCWSTR   SourcePath;
    PCWSTR   SourceFilename;
    PCWSTR   SourceDescription;
    PCWSTR   SourceTagfile;
    PCWSTR   TargetDirectory;
    PCWSTR   TargetFilename;
    DWORD    CopyStyle;
    HINF     LayoutInf;
    PCWSTR   SecurityDescriptor;
} SP_FILE_COPY_PARAMS_W, *PSP_FILE_COPY_PARAMS_W;
typedef struct _SP_DEVINFO_DATA {
    DWORD cbSize;
    GUID  ClassGuid;
    DWORD DevInst;
    ULONG_PTR Reserved;
} SP_DEVINFO_DATA, *PSP_DEVINFO_DATA;
typedef struct _SP_DEVICE_INTERFACE_DATA {
    DWORD cbSize;
    GUID  InterfaceClassGuid;
    DWORD Flags;
    ULONG_PTR Reserved;
} SP_DEVICE_INTERFACE_DATA, *PSP_DEVICE_INTERFACE_DATA;
/* For backward compatability */
typedef SP_DEVICE_INTERFACE_DATA  SP_INTERFACE_DEVICE_DATA, *PSP_INTERFACE_DEVICE_DATA;

typedef struct _SP_DEVICE_INTERFACE_DETAIL_DATA_A {
    DWORD  cbSize;
    CHAR   DevicePath[ANYSIZE_ARRAY];
} SP_DEVICE_INTERFACE_DETAIL_DATA_A, *PSP_DEVICE_INTERFACE_DETAIL_DATA_A;
typedef struct _SP_DEVICE_INTERFACE_DETAIL_DATA_W {
    DWORD  cbSize;
    WCHAR  DevicePath[ANYSIZE_ARRAY];
} SP_DEVICE_INTERFACE_DETAIL_DATA_W, *PSP_DEVICE_INTERFACE_DETAIL_DATA_W;
/* For backward compatability */
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_INTERFACE_DEVICE_DETAIL_DATA_A,
    *PSP_INTERFACE_DEVICE_DETAIL_DATA_A;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA_W,
    *PSP_INTERFACE_DEVICE_DETAIL_DATA_W;

typedef struct _SP_DEVINFO_LIST_DETAIL_DATA_A {
    DWORD  cbSize;
    GUID   ClassGuid;
    HANDLE RemoteMachineHandle;
    CHAR   RemoteMachineName[SP_MAX_MACHINENAME_LENGTH];
} SP_DEVINFO_LIST_DETAIL_DATA_A, *PSP_DEVINFO_LIST_DETAIL_DATA_A;
typedef struct _SP_DEVINFO_LIST_DETAIL_DATA_W {
    DWORD  cbSize;
    GUID   ClassGuid;
    HANDLE RemoteMachineHandle;
    WCHAR  RemoteMachineName[SP_MAX_MACHINENAME_LENGTH];
} SP_DEVINFO_LIST_DETAIL_DATA_W, *PSP_DEVINFO_LIST_DETAIL_DATA_W;

typedef UINT (CALLBACK* PSP_FILE_CALLBACK_A)(PVOID,UINT,UINT_PTR,UINT_PTR);
typedef UINT (CALLBACK* PSP_FILE_CALLBACK_W)(PVOID,UINT,UINT_PTR,UINT_PTR);
typedef struct _SP_DEVINSTALL_PARAMS_A {
    DWORD             cbSize;
    DWORD             Flags;
    DWORD             FlagsEx;
    HWND              hwndParent;
    PSP_FILE_CALLBACK_A InstallMsgHandler;
    PVOID             InstallMsgHandlerContext;
    HSPFILEQ          FileQueue;
    ULONG_PTR         ClassInstallReserved;
    DWORD             Reserved;
    CHAR              DriverPath[MAX_PATH];
} SP_DEVINSTALL_PARAMS_A, *PSP_DEVINSTALL_PARAMS_A;
typedef struct _SP_DEVINSTALL_PARAMS_W {
    DWORD             cbSize;
    DWORD             Flags;
    DWORD             FlagsEx;
    HWND              hwndParent;
    PSP_FILE_CALLBACK_W InstallMsgHandler;
    PVOID             InstallMsgHandlerContext;
    HSPFILEQ          FileQueue;
    ULONG_PTR         ClassInstallReserved;
    DWORD             Reserved;
    WCHAR             DriverPath[MAX_PATH];
} SP_DEVINSTALL_PARAMS_W, *PSP_DEVINSTALL_PARAMS_W;
typedef struct _SP_CLASSINSTALL_HEADER {
    DWORD       cbSize;
    DI_FUNCTION InstallFunction;
} SP_CLASSINSTALL_HEADER, *PSP_CLASSINSTALL_HEADER;
typedef struct _SP_ENABLECLASS_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    GUID                   ClassGuid;
    DWORD                  EnableMessage;
} SP_ENABLECLASS_PARAMS, *PSP_ENABLECLASS_PARAMS;
typedef struct _SP_MOVEDEV_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    SP_DEVINFO_DATA        SourceDeviceInfoData;
} SP_MOVEDEV_PARAMS, *PSP_MOVEDEV_PARAMS;
typedef struct _SP_PROPCHANGE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  StateChange;
    DWORD                  Scope;
    DWORD                  HwProfile;
} SP_PROPCHANGE_PARAMS, *PSP_PROPCHANGE_PARAMS;
typedef struct _SP_REMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD Scope;
    DWORD HwProfile;
} SP_REMOVEDEVICE_PARAMS, *PSP_REMOVEDEVICE_PARAMS;
typedef struct _SP_UNREMOVEDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD Scope;
    DWORD HwProfile;
} SP_UNREMOVEDEVICE_PARAMS, *PSP_UNREMOVEDEVICE_PARAMS;
typedef struct _SP_SELECTDEVICE_PARAMS_A {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    CHAR                   Title[MAX_TITLE_LEN];
    CHAR                   Instructions[MAX_INSTRUCTION_LEN];
    CHAR                   ListLabel[MAX_LABEL_LEN];
    CHAR                   SubTitle[MAX_SUBTITLE_LEN];
    BYTE                   Reserved[2];
} SP_SELECTDEVICE_PARAMS_A, *PSP_SELECTDEVICE_PARAMS_A;
typedef struct _SP_SELECTDEVICE_PARAMS_W {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    WCHAR                  Title[MAX_TITLE_LEN];
    WCHAR                  Instructions[MAX_INSTRUCTION_LEN];
    WCHAR                  ListLabel[MAX_LABEL_LEN];
    WCHAR                  SubTitle[MAX_SUBTITLE_LEN];
} SP_SELECTDEVICE_PARAMS_W, *PSP_SELECTDEVICE_PARAMS_W;
typedef struct _SP_REGISTER_CONTROL_STATUSA {
    DWORD                  cbSize;
    PCSTR                  FileName;
    DWORD                  Win32Error;
    DWORD                  FailureCode;
} SP_REGISTER_CONTROL_STATUSA, *PSP_REGISTER_CONTROL_STATUSA;
typedef struct _SP_REGISTER_CONTROL_STATUSW {
    DWORD                  cbSize;
    PCWSTR                 FileName;
    DWORD                  Win32Error;
    DWORD                  FailureCode;
} SP_REGISTER_CONTROL_STATUSW, *PSP_REGISTER_CONTROL_STATUSW;

typedef BOOL (CALLBACK* PDETECT_PROGRESS_NOTIFY)(PVOID,DWORD);
typedef struct _SP_DETECTDEVICE_PARAMS {
    SP_CLASSINSTALL_HEADER  ClassInstallHeader;
    PDETECT_PROGRESS_NOTIFY DetectProgressNotify;
    PVOID                   ProgressNotifyParam;
} SP_DETECTDEVICE_PARAMS, *PSP_DETECTDEVICE_PARAMS;
typedef struct _SP_INSTALLWIZARD_DATA {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Flags;
    HPROPSHEETPAGE         DynamicPages[MAX_INSTALLWIZARD_DYNAPAGES];
    DWORD                  NumDynamicPages;
    DWORD                  DynamicPageFlags;
    DWORD                  PrivateFlags;
    LPARAM                 PrivateData;
    HWND                   hwndWizardDlg;
} SP_INSTALLWIZARD_DATA, *PSP_INSTALLWIZARD_DATA;
typedef struct _SP_NEWDEVICEWIZARD_DATA {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    DWORD                  Flags;
    HPROPSHEETPAGE         DynamicPages[MAX_INSTALLWIZARD_DYNAPAGES];
    DWORD                  NumDynamicPages;
    HWND                   hwndWizardDlg;
} SP_NEWDEVICEWIZARD_DATA, *PSP_NEWDEVICEWIZARD_DATA;
typedef SP_NEWDEVICEWIZARD_DATA SP_ADDPROPERTYPAGE_DATA,
    *PSP_ADDPROPERTYPAGE_DATA;
typedef struct _SP_TROUBLESHOOTER_PARAMS_A {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    CHAR                   ChmFile[MAX_PATH];
    CHAR                   HtmlTroubleShooter[MAX_PATH];
} SP_TROUBLESHOOTER_PARAMS_A, *PSP_TROUBLESHOOTER_PARAMS_A;
typedef struct _SP_TROUBLESHOOTER_PARAMS_W {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    WCHAR                  ChmFile[MAX_PATH];
    WCHAR                  HtmlTroubleShooter[MAX_PATH];
} SP_TROUBLESHOOTER_PARAMS_W, *PSP_TROUBLESHOOTER_PARAMS_W;
typedef struct _SP_POWERMESSAGEWAKE_PARAMS_A {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    CHAR                   PowerMessageWake[LINE_LEN*2];
} SP_POWERMESSAGEWAKE_PARAMS_A, *PSP_POWERMESSAGEWAKE_PARAMS_A;
typedef struct _SP_POWERMESSAGEWAKE_PARAMS_W {
    SP_CLASSINSTALL_HEADER ClassInstallHeader;
    WCHAR                  PowerMessageWake[LINE_LEN*2];
} SP_POWERMESSAGEWAKE_PARAMS_W, *PSP_POWERMESSAGEWAKE_PARAMS_W;
typedef struct _SP_DRVINFO_DATA_V2_A {
    DWORD     cbSize;
    DWORD     DriverType;
    ULONG_PTR Reserved;
    CHAR      Description[LINE_LEN];
    CHAR      MfgName[LINE_LEN];
    CHAR      ProviderName[LINE_LEN];
    FILETIME  DriverDate;
    DWORDLONG DriverVersion;
} SP_DRVINFO_DATA_V2_A, *PSP_DRVINFO_DATA_V2_A;
typedef struct _SP_DRVINFO_DATA_V2_W {
    DWORD     cbSize;
    DWORD     DriverType;
    ULONG_PTR Reserved;
    WCHAR     Description[LINE_LEN];
    WCHAR     MfgName[LINE_LEN];
    WCHAR     ProviderName[LINE_LEN];
    FILETIME  DriverDate;
    DWORDLONG DriverVersion;
} SP_DRVINFO_DATA_V2_W, *PSP_DRVINFO_DATA_V2_W;
typedef struct _SP_DRVINFO_DATA_V1_A {
    DWORD     cbSize;
    DWORD     DriverType;
    ULONG_PTR Reserved;
    CHAR      Description[LINE_LEN];
    CHAR      MfgName[LINE_LEN];
    CHAR      ProviderName[LINE_LEN];
} SP_DRVINFO_DATA_V1_A, *PSP_DRVINFO_DATA_V1_A;
typedef struct _SP_DRVINFO_DATA_V1_W {
    DWORD     cbSize;
    DWORD     DriverType;
    ULONG_PTR Reserved;
    WCHAR     Description[LINE_LEN];
    WCHAR     MfgName[LINE_LEN];
    WCHAR     ProviderName[LINE_LEN];
} SP_DRVINFO_DATA_V1_W, *PSP_DRVINFO_DATA_V1_W;

#ifdef UNICODE
typedef SP_DRVINFO_DATA_V1_W SP_DRVINFO_DATA_V1, *PSP_DRVINFO_DATA_V1;
typedef SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_V2, *PSP_DRVINFO_DATA_V2;
#else
typedef SP_DRVINFO_DATA_V1_A SP_DRVINFO_DATA_V1, *PSP_DRVINFO_DATA_V1;
typedef SP_DRVINFO_DATA_V2_A SP_DRVINFO_DATA_V2, *PSP_DRVINFO_DATA_V2;
#endif

#if USE_SP_DRVINFO_DATA_V1
typedef SP_DRVINFO_DATA_V1_A SP_DRVINFO_DATA_A, *PSP_DRVINFO_DATA_A;
typedef SP_DRVINFO_DATA_V1_W SP_DRVINFO_DATA_W, *PSP_DRVINFO_DATA_W;
typedef SP_DRVINFO_DATA_V1 SP_DRVINFO_DATA, *PSP_DRVINFO_DATA;
#else
typedef SP_DRVINFO_DATA_V2_A SP_DRVINFO_DATA_A, *PSP_DRVINFO_DATA_A;
typedef SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_W, *PSP_DRVINFO_DATA_W;
typedef SP_DRVINFO_DATA_V2 SP_DRVINFO_DATA, *PSP_DRVINFO_DATA;
#endif

typedef DWORD (CALLBACK* PSP_DETSIG_CMPPROC)(HDEVINFO,PSP_DEVINFO_DATA,PSP_DEVINFO_DATA,PVOID);

typedef struct _SP_DRVINFO_DETAIL_DATA_A {
    DWORD    cbSize;
    FILETIME InfDate;
    DWORD    CompatIDsOffset;
    DWORD    CompatIDsLength;
    ULONG_PTR Reserved;
    CHAR     SectionName[LINE_LEN];
    CHAR     InfFileName[MAX_PATH];
    CHAR     DrvDescription[LINE_LEN];
    CHAR     HardwareID[ANYSIZE_ARRAY];
} SP_DRVINFO_DETAIL_DATA_A, *PSP_DRVINFO_DETAIL_DATA_A;
typedef struct _SP_DRVINFO_DETAIL_DATA_W {
    DWORD    cbSize;
    FILETIME InfDate;
    DWORD    CompatIDsOffset;
    DWORD    CompatIDsLength;
    ULONG_PTR Reserved;
    WCHAR    SectionName[LINE_LEN];
    WCHAR    InfFileName[MAX_PATH];
    WCHAR    DrvDescription[LINE_LEN];
    WCHAR    HardwareID[ANYSIZE_ARRAY];
} SP_DRVINFO_DETAIL_DATA_W, *PSP_DRVINFO_DETAIL_DATA_W;
typedef struct _SP_DRVINSTALL_PARAMS {
    DWORD cbSize;
    DWORD Rank;
    DWORD Flags;
    DWORD_PTR PrivateData;
    DWORD Reserved;
} SP_DRVINSTALL_PARAMS, *PSP_DRVINSTALL_PARAMS;


typedef struct _COINSTALLER_CONTEXT_DATA {
    BOOL  PostProcessing;
    DWORD InstallResult;
    PVOID PrivateData;
} COINSTALLER_CONTEXT_DATA, *PCOINSTALLER_CONTEXT_DATA;
typedef struct _SP_CLASSIMAGELIST_DATA {
    DWORD      cbSize;
    HIMAGELIST ImageList;
    ULONG_PTR  Reserved;
} SP_CLASSIMAGELIST_DATA, *PSP_CLASSIMAGELIST_DATA;
typedef struct _SP_PROPSHEETPAGE_REQUEST {
    DWORD            cbSize;
    DWORD            PageRequested;
    HDEVINFO         DeviceInfoSet;
    PSP_DEVINFO_DATA DeviceInfoData;
} SP_PROPSHEETPAGE_REQUEST, *PSP_PROPSHEETPAGE_REQUEST;
typedef struct _SP_BACKUP_QUEUE_PARAMS_A {
    DWORD    cbSize;
    CHAR     FullInfPath[MAX_PATH];
    INT      FilenameOffset;
} SP_BACKUP_QUEUE_PARAMS_A, *PSP_BACKUP_QUEUE_PARAMS_A;
typedef struct _SP_BACKUP_QUEUE_PARAMS_W {
    DWORD    cbSize;
    WCHAR    FullInfPath[MAX_PATH];
    INT      FilenameOffset;
} SP_BACKUP_QUEUE_PARAMS_W, *PSP_BACKUP_QUEUE_PARAMS_W;


#ifdef UNICODE
typedef SP_ORIGINAL_FILE_INFO_W SP_ORIGINAL_FILE_INFO, *PSP_ORIGINAL_FILE_INFO;
typedef FILEPATHS_W FILEPATHS, *PFILEPATHS;
typedef SOURCE_MEDIA_W SOURCE_MEDIA, *PSOURCE_MEDIA;
typedef CABINET_INFO_W CABINET_INFO, *PCABINET_INFO;
typedef FILE_IN_CABINET_INFO_W FILE_IN_CABINET_INFO, *PFILE_IN_CABINET_INFO;
typedef SP_FILE_COPY_PARAMS_W SP_FILE_COPY_PARAMS, PSP_FILE_COPY_PARAMS;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_DEVICE_INTERFACE_DETAIL_DATA,
    *PSP_DEVICE_INTERFACE_DETAIL_DATA;
typedef SP_INTERFACE_DEVICE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA,
    *PSP_INTERFACE_DEVICE_DETAIL_DATA; /* deprecated */
typedef SP_DEVINFO_LIST_DETAIL_DATA_W SP_DEVINFO_LIST_DETAIL_DATA,
    *PSP_DEVINFO_LIST_DETAIL_DATA;
typedef SP_DEVINSTALL_PARAMS_W SP_DEVINSTALL_PARAMS, *PSP_DEVINSTALL_PARAMS;
typedef SP_SELECTDEVICE_PARAMS_W SP_SELECTDEVICE_PARAMS, *PSP_SELECTDEVICE_PARAMS;
typedef SP_TROUBLESHOOTER_PARAMS_W SP_TROUBLESHOOTER_PARAMS,
    *PSP_TROUBLESHOOTER_PARAMS;
typedef SP_POWERMESSAGEWAKE_PARAMS_W SP_POWERMESSAGEWAKE_PARAMS,
    *PSP_POWERMESSAGEWAKE_PARAMS;
typedef SP_DRVINFO_DETAIL_DATA_W SP_DRVINFO_DETAIL_DATA,
     *PSP_DRVINFO_DETAIL_DATA;
typedef SP_BACKUP_QUEUE_PARAMS_W SP_BACKUP_QUEUE_PARAMS,
    *PSP_BACKUP_QUEUE_PARAMS;
typedef SP_REGISTER_CONTROL_STATUSW SP_REGISTER_CONTROL_STATUS, *PSP_REGISTER_CONTROL_STATUS;
#else
typedef SP_ORIGINAL_FILE_INFO_A SP_ORIGINAL_FILE_INFO, *PSP_ORIGINAL_FILE_INFO;
typedef FILEPATHS_A FILEPATHS, *PFILEPATHS;
typedef SOURCE_MEDIA_A SOURCE_MEDIA, *PSOURCE_MEDIA;
typedef CABINET_INFO_A CABINET_INFO, *PCABINET_INFO;
typedef FILE_IN_CABINET_INFO_A FILE_IN_CABINET_INFO, *PFILE_IN_CABINET_INFO;
typedef SP_FILE_COPY_PARAMS_A SP_FILE_COPY_PARAMS, *PSP_FILE_COPY_PARAMS;
typedef SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_DEVICE_INTERFACE_DETAIL_DATA,
    *PSP_DEVICE_INTERFACE_DETAIL_DATA;
typedef SP_INTERFACE_DEVICE_DETAIL_DATA_A SP_INTERFACE_DEVICE_DETAIL_DATA,
    *PSP_INTERFACE_DEVICE_DETAIL_DATA; /* deprecated */
typedef SP_DEVINFO_LIST_DETAIL_DATA_A SP_DEVINFO_LIST_DETAIL_DATA,
    *PSP_DEVINFO_LIST_DETAIL_DATA;
typedef SP_DEVINSTALL_PARAMS_A SP_DEVINSTALL_PARAMS, *PSP_DEVINSTALL_PARAMS;
typedef SP_SELECTDEVICE_PARAMS_A SP_SELECTDEVICE_PARAMS,
    *PSP_SELECTDEVICE_PARAMS;
typedef SP_TROUBLESHOOTER_PARAMS_A SP_TROUBLESHOOTER_PARAMS,
    *PSP_TROUBLESHOOTER_PARAMS;
typedef SP_POWERMESSAGEWAKE_PARAMS_A SP_POWERMESSAGEWAKE_PARAMS,
    *PSP_POWERMESSAGEWAKE_PARAMS;
typedef SP_DRVINFO_DETAIL_DATA_A SP_DRVINFO_DETAIL_DATA,
    *PSP_DRVINFO_DETAIL_DATA;
typedef SP_BACKUP_QUEUE_PARAMS_A SP_BACKUP_QUEUE_PARAMS,
    *PSP_BACKUP_QUEUE_PARAMS;
typedef SP_REGISTER_CONTROL_STATUSA SP_REGISTER_CONTROL_STATUS, *PSP_REGISTER_CONTROL_STATUS;
#endif /* UNICODE */


WINSETUPAPI LONG WINAPI AddTagToGroupOrderList(PCWSTR, DWORD, DWORD);
WINSETUPAPI VOID WINAPI AssertFail(LPSTR, UINT, LPSTR);
WINSETUPAPI DWORD WINAPI CaptureStringArg(PCWSTR, PWSTR*);
WINSETUPAPI BOOL WINAPI DelayedMove(PCWSTR, PCWSTR);
WINSETUPAPI BOOL WINAPI DoesUserHavePrivilege(PCWSTR);
WINSETUPAPI BOOL WINAPI FileExists(PCWSTR, PWIN32_FIND_DATAW);
WINSETUPAPI DWORD WINAPI GetSetFileTimestamp(PCWSTR, PFILETIME, PFILETIME, PFILETIME, BOOLEAN);
WINSETUPAPI VOID WINAPI InstallHinfSectionA(_In_ HWND, _In_ HINSTANCE, _In_ PCSTR, _In_ INT);
WINSETUPAPI VOID WINAPI InstallHinfSectionW(_In_ HWND, _In_ HINSTANCE, _In_ PCWSTR, _In_ INT);
WINSETUPAPI BOOL WINAPI IsUserAdmin(VOID);
WINSETUPAPI VOID WINAPI MyFree(PVOID);
WINSETUPAPI PVOID WINAPI MyMalloc(DWORD);
WINSETUPAPI PVOID WINAPI MyRealloc(PVOID, DWORD);
WINSETUPAPI LONG WINAPI QueryRegistryValue(HKEY, PCWSTR, PBYTE*, PDWORD, PDWORD);
WINSETUPAPI DWORD WINAPI RetreiveFileSecurity(PCWSTR, PSECURITY_DESCRIPTOR*);

WINSETUPAPI BOOL WINAPI SetupAddInstallSectionToDiskSpaceListA(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCSTR, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddInstallSectionToDiskSpaceListW(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddSectionToDiskSpaceListA(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddSectionToDiskSpaceListW(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddToDiskSpaceListA(_In_ HDSKSPC, _In_ PCSTR, _In_ LONGLONG, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddToDiskSpaceListW(_In_ HDSKSPC, _In_ PCWSTR, _In_ LONGLONG, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAddToSourceListA(_In_ DWORD, _In_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupAddToSourceListW(_In_ DWORD, _In_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupAdjustDiskSpaceListA(_In_ HDSKSPC, _In_ LPCSTR, _In_ LONGLONG, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupAdjustDiskSpaceListW(_In_ HDSKSPC, _In_ LPCWSTR, _In_ LONGLONG, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI UINT WINAPI SetupBackupErrorA(_In_ HWND, _In_opt_ PCSTR, _In_ PCSTR, _In_opt_ PCSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI UINT WINAPI SetupBackupErrorW(_In_ HWND, _In_opt_ PCWSTR, _In_ PCWSTR, _In_opt_ PCWSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupCancelTemporary(VOID);
WINSETUPAPI BOOL WINAPI SetupCloseFileQueue(_In_ HSPFILEQ);
WINSETUPAPI VOID WINAPI SetupCloseInfFile(_In_ HINF);
WINSETUPAPI VOID WINAPI SetupCloseLog(VOID);
WINSETUPAPI BOOL WINAPI SetupCommitFileQueueA(_In_opt_ HWND, _In_ HSPFILEQ, _In_ PSP_FILE_CALLBACK_A, _In_ PVOID);
WINSETUPAPI BOOL WINAPI SetupCommitFileQueueW(_In_opt_ HWND, _In_ HSPFILEQ, _In_ PSP_FILE_CALLBACK_W, _In_ PVOID);

WINSETUPAPI
UINT
WINAPI
SetupCopyErrorA(
  _In_ HWND hwndParent,
  _In_opt_ PCSTR DialogTitle,
  _In_opt_ PCSTR DiskName,
  _In_ PCSTR PathToSource,
  _In_ PCSTR SourceFile,
  _In_opt_ PCSTR TargetPathFile,
  _In_ UINT Win32ErrorCode,
  _In_ DWORD Style,
  _Out_writes_opt_(PathBufferSize) PSTR PathBuffer,
  _In_ DWORD PathBufferSize,
  _Out_opt_ PDWORD PathRequiredSize);

WINSETUPAPI
UINT
WINAPI
SetupCopyErrorW(
  _In_ HWND hwndParent,
  _In_opt_ PCWSTR DialogTitle,
  _In_opt_ PCWSTR DiskName,
  _In_ PCWSTR PathToSource,
  _In_ PCWSTR SourceFile,
  _In_opt_ PCWSTR TargetPathFile,
  _In_ UINT Win32ErrorCode,
  _In_ DWORD Style,
  _Out_writes_opt_(PathBufferSize) PWSTR PathBuffer,
  _In_ DWORD PathBufferSize,
  _Out_opt_ PDWORD PathRequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupCopyOEMInfA(
  _In_ PCSTR SourceInfFileName,
  _In_opt_ PCSTR OEMSourceMediaLocation,
  _In_ DWORD OEMSourceMediaType,
  _In_ DWORD CopyStyle,
  _Out_writes_opt_(DestinationInfFileNameSize) PSTR DestinationInfFileName,
  _In_ DWORD DestinationInfFileNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PSTR *DestinationInfFileNameComponent);

WINSETUPAPI
BOOL
WINAPI
SetupCopyOEMInfW(
  _In_ PCWSTR SourceInfFileName,
  _In_opt_ PCWSTR OEMSourceMediaLocation,
  _In_ DWORD OEMSourceMediaType,
  _In_ DWORD CopyStyle,
  _Out_writes_opt_(DestinationInfFileNameSize) PWSTR DestinationInfFileName,
  _In_ DWORD DestinationInfFileNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PWSTR  *DestinationInfFileNameComponent);

WINSETUPAPI HDSKSPC WINAPI SetupCreateDiskSpaceListA(_Reserved_ PVOID, _Reserved_ DWORD, _In_ UINT);
WINSETUPAPI HDSKSPC WINAPI SetupCreateDiskSpaceListW(_Reserved_ PVOID, _Reserved_ DWORD, _In_ UINT);
WINSETUPAPI DWORD WINAPI SetupDecompressOrCopyFileA(_In_ PCSTR, _In_ PCSTR, _In_opt_ PUINT);
WINSETUPAPI DWORD WINAPI SetupDecompressOrCopyFileW(_In_ PCWSTR, _In_ PCWSTR, _In_opt_ PUINT);
WINSETUPAPI UINT WINAPI SetupDefaultQueueCallbackA(_In_ PVOID, _In_ UINT, _In_ UINT_PTR, _In_ UINT_PTR);
WINSETUPAPI UINT WINAPI SetupDefaultQueueCallbackW(_In_ PVOID, _In_ UINT, _In_ UINT_PTR, _In_ UINT_PTR);
WINSETUPAPI UINT WINAPI SetupDeleteErrorA(_In_ HWND, _In_opt_ PCSTR, _In_ PCSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI UINT WINAPI SetupDeleteErrorW(_In_ HWND, _In_opt_ PCWSTR, _In_ PCWSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDestroyDiskSpaceList(_Inout_ HDSKSPC);
WINSETUPAPI BOOL WINAPI SetupDiAskForOEMDisk(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiBuildClassInfoList(
  _In_ DWORD Flags,
  _Out_writes_to_opt_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiBuildClassInfoListExA(
  _In_ DWORD Flags,
  _Out_writes_to_opt_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiBuildClassInfoListExW(
  _In_ DWORD Flags,
  _Out_writes_to_opt_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiBuildDriverInfoList(_In_ HDEVINFO, _Inout_opt_ PSP_DEVINFO_DATA, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiCallClassInstaller(_In_ DI_FUNCTION, _In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiCancelDriverInfoSearch(_In_ HDEVINFO);
WINSETUPAPI BOOL WINAPI SetupDiChangeState(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiClassGuidsFromNameA(
  _In_ PCSTR ClassName,
  _Out_writes_to_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiClassGuidsFromNameW(
  _In_ PCWSTR ClassName,
  _Out_writes_to_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiClassGuidsFromNameExA(
  _In_ PCSTR ClassName,
  _Out_writes_to_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiClassGuidsFromNameExW(
  _In_ PCWSTR ClassName,
  _Out_writes_to_(ClassGuidListSize, *RequiredSize) LPGUID ClassGuidList,
  _In_ DWORD ClassGuidListSize,
  _Out_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiClassNameFromGuidA(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassNameSize) PSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiClassNameFromGuidW(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassNameSize) PWSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiClassNameFromGuidExA(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassNameSize) PSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiClassNameFromGuidExW(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassNameSize) PWSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiCreateDeviceInfoA(_In_ HDEVINFO, _In_ PCSTR, _In_ CONST GUID*, _In_opt_ PCSTR, _In_opt_ HWND, _In_ DWORD, _Out_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiCreateDeviceInfoW(_In_ HDEVINFO, _In_ PCWSTR, _In_ CONST GUID*, _In_opt_ PCWSTR, _In_opt_ HWND, _In_ DWORD, _Out_opt_ PSP_DEVINFO_DATA);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoList(_In_opt_ CONST GUID*, _In_opt_ HWND);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoListExA(_In_opt_ CONST GUID*, _In_opt_ HWND, _In_opt_ PCSTR, _Reserved_ PVOID);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiCreateDeviceInfoListExW(_In_opt_ CONST GUID*, _In_opt_ HWND, _In_opt_ PCWSTR, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiCreateDeviceInterfaceA(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ CONST GUID*, _In_opt_ PCSTR, _In_ DWORD, _Out_opt_ PSP_DEVICE_INTERFACE_DATA);
WINSETUPAPI BOOL WINAPI SetupDiCreateDeviceInterfaceW(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ CONST GUID*, _In_opt_ PCWSTR, _In_ DWORD, _Out_opt_ PSP_DEVICE_INTERFACE_DATA);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiCreateDeviceInterfaceRegKeyA(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA, _Reserved_ DWORD, _In_ REGSAM, _In_opt_ HINF, _In_opt_ PCSTR);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiCreateDeviceInterfaceRegKeyW(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA, _Reserved_ DWORD, _In_ REGSAM, _In_opt_ HINF, _In_opt_ PCWSTR);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiCreateDevRegKeyA(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_opt_ HINF, _In_opt_ PCSTR);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiCreateDevRegKeyW(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_opt_ HINF, _In_opt_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupDiDeleteDeviceInfo(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiDeleteDeviceInterfaceData(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA);
WINSETUPAPI BOOL WINAPI SetupDiDeleteDeviceInterfaceRegKey(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA, _Reserved_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiDeleteDevRegKey(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiDestroyClassImageList(_In_ PSP_CLASSIMAGELIST_DATA);
WINSETUPAPI BOOL WINAPI SetupDiDestroyDeviceInfoList(_In_ HDEVINFO);
WINSETUPAPI BOOL WINAPI SetupDiDestroyDriverInfoList(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ DWORD);
WINSETUPAPI INT WINAPI SetupDiDrawMiniIcon(_In_ HDC, _In_ RECT, _In_ INT, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiEnumDeviceInfo(_In_ HDEVINFO, _In_ DWORD, _Out_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiEnumDeviceInterfaces(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ CONST GUID*, _In_ DWORD, _Out_ PSP_DEVICE_INTERFACE_DATA);
WINSETUPAPI BOOL WINAPI SetupDiEnumDriverInfoA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _Out_ PSP_DRVINFO_DATA_A);
WINSETUPAPI BOOL WINAPI SetupDiEnumDriverInfoW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _Out_ PSP_DRVINFO_DATA_W);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetActualSectionToInstallA(
  _In_ HINF InfHandle,
  _In_ PCSTR InfSectionName,
  _Out_writes_opt_(InfSectionWithExtSize) PSTR InfSectionWithExt,
  _In_ DWORD InfSectionWithExtSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PSTR *Extension);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetActualSectionToInstallW(
  _In_ HINF InfHandle,
  _In_ PCWSTR InfSectionName,
  _Out_writes_opt_(InfSectionWithExtSize) PWSTR InfSectionWithExt,
  _In_ DWORD InfSectionWithExtSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PWSTR *Extension);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetActualSectionToInstallExA(
  _In_ HINF InfHandle,
  _In_ PCSTR InfSectionName,
  _In_opt_ PSP_ALTPLATFORM_INFO AlternatePlatformInfo,
  _Out_writes_opt_(InfSectionWithExtSize) PSTR InfSectionWithExt,
  _In_ DWORD InfSectionWithExtSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PSTR *Extension,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetActualSectionToInstallExW(
  _In_ HINF InfHandle,
  _In_ PCWSTR InfSectionName,
  _In_opt_ PSP_ALTPLATFORM_INFO AlternatePlatformInfo,
  _Out_writes_opt_(InfSectionWithExtSize) PWSTR InfSectionWithExt,
  _In_ DWORD InfSectionWithExtSize,
  _Out_opt_ PDWORD RequiredSize,
  _Out_opt_ PWSTR *Extension,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiGetClassBitmapIndex(_In_opt_ CONST GUID*, _Out_ PINT);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassDescriptionA(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassDescriptionSize) PSTR ClassDescription,
  _In_ DWORD ClassDescriptionSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassDescriptionW(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassDescriptionSize) PWSTR ClassDescription,
  _In_ DWORD ClassDescriptionSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassDescriptionExA(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassDescriptionSize) PSTR ClassDescription,
  _In_ DWORD ClassDescriptionSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassDescriptionExW(
  _In_ CONST GUID *ClassGuid,
  _Out_writes_(ClassDescriptionSize) PWSTR ClassDescription,
  _In_ DWORD ClassDescriptionSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiGetClassDevPropertySheetsA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ LPPROPSHEETHEADERA, _In_ DWORD, _Out_opt_ PDWORD, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiGetClassDevPropertySheetsW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ LPPROPSHEETHEADERW, _In_ DWORD, _Out_opt_ PDWORD, _In_ DWORD);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsA(_In_opt_ CONST GUID*, _In_opt_ PCSTR, _In_opt_ HWND, _In_ DWORD);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsW(_In_opt_ CONST GUID*, _In_opt_ PCWSTR, _In_opt_ HWND, _In_ DWORD);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsExA(_In_opt_ CONST GUID*, _In_opt_ PCSTR, _In_opt_ HWND, _In_ DWORD, _In_opt_ HDEVINFO, _In_opt_ PCSTR, _Reserved_ PVOID);
_Check_return_ WINSETUPAPI HDEVINFO WINAPI SetupDiGetClassDevsExW(_In_opt_ CONST GUID*, _In_opt_ PCWSTR, _In_opt_ HWND, _In_ DWORD, _In_opt_ HDEVINFO, _In_opt_ PCWSTR, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiGetClassImageIndex(_In_ PSP_CLASSIMAGELIST_DATA, _In_ CONST GUID*, _Out_ PINT);
WINSETUPAPI BOOL WINAPI SetupDiGetClassImageList(_Out_ PSP_CLASSIMAGELIST_DATA);
WINSETUPAPI BOOL WINAPI SetupDiGetClassImageListExA(_Out_ PSP_CLASSIMAGELIST_DATA, _In_opt_ PCSTR, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiGetClassImageListExW(_Out_ PSP_CLASSIMAGELIST_DATA, _In_opt_ PCWSTR, _Reserved_ PVOID);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassInstallParamsA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _Out_writes_bytes_to_opt_(ClassInstallParamsSize, *RequiredSize) PSP_CLASSINSTALL_HEADER ClassInstallParams,
  _In_ DWORD ClassInstallParamsSize,
  _Out_opt_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassInstallParamsW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _Out_writes_bytes_to_opt_(ClassInstallParamsSize, *RequiredSize) PSP_CLASSINSTALL_HEADER ClassInstallParams,
  _In_ DWORD ClassInstallParamsSize,
  _Out_opt_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassRegistryPropertyA(
  _In_ CONST GUID *ClassGuid,
  _In_ DWORD Property,
  _Out_opt_ PDWORD PropertyRegDataType,
  _Out_writes_bytes_to_(PropertyBufferSize, *RequiredSize) PBYTE PropertyBuffer,
  _In_ DWORD PropertyBufferSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetClassRegistryPropertyW(
  _In_ CONST GUID *ClassGuid,
  _In_ DWORD Property,
  _Out_opt_ PDWORD PropertyRegDataType,
  _Out_writes_bytes_to_(PropertyBufferSize, *RequiredSize) PBYTE PropertyBuffer,
  _In_ DWORD PropertyBufferSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName, 
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInfoListClass(_In_ HDEVINFO, _Out_ LPGUID);
WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInfoListDetailA(_In_ HDEVINFO, _Out_ PSP_DEVINFO_LIST_DETAIL_DATA_A);
WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInfoListDetailW(_In_ HDEVINFO, _Out_ PSP_DEVINFO_LIST_DETAIL_DATA_W);
WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInstallParamsA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Out_ PSP_DEVINSTALL_PARAMS_A);
WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInstallParamsW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Out_ PSP_DEVINSTALL_PARAMS_W);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceInstanceIdA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVINFO_DATA DeviceInfoData,
  _Out_writes_opt_(DeviceInstanceIdSize) PSTR DeviceInstanceId,
  _In_ DWORD DeviceInstanceIdSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceInstanceIdW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVINFO_DATA DeviceInfoData,
  _Out_writes_opt_(DeviceInstanceIdSize) PWSTR DeviceInstanceId,
  _In_ DWORD DeviceInstanceIdSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupDiGetDeviceInterfaceAlias(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA, _In_ CONST GUID*, _Out_ PSP_DEVICE_INTERFACE_DATA);

_Success_(return != FALSE)
_At_((LPSTR)DeviceInterfaceDetailData->DevicePath, _Post_z_)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceInterfaceDetailA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData,
  _Inout_updates_bytes_to_opt_(DeviceInterfaceDetailDataSize, *RequiredSize) PSP_DEVICE_INTERFACE_DETAIL_DATA_A DeviceInterfaceDetailData, 
  _In_ DWORD DeviceInterfaceDetailDataSize,
  _Out_opt_ _Out_range_(>=, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA_A)) PDWORD RequiredSize,
  _Out_opt_ PSP_DEVINFO_DATA DeviceInfoData);

_Success_(return != FALSE)
_At_((LPWSTR)DeviceInterfaceDetailData->DevicePath, _Post_z_)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceInterfaceDetailW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData,
  _Out_writes_bytes_to_opt_(DeviceInterfaceDetailDataSize, *RequiredSize) PSP_DEVICE_INTERFACE_DETAIL_DATA_W DeviceInterfaceDetailData,
  _In_ DWORD DeviceInterfaceDetailDataSize,
  _Out_opt_ _Out_range_(>=, sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA_W)) PDWORD RequiredSize,
  _Out_opt_ PSP_DEVINFO_DATA DeviceInfoData);

_Success_(return != FALSE)
_When_((*PropertyRegDataType == REG_SZ), _At_((PSTR) PropertyBuffer, _Post_valid_))
_When_((*PropertyRegDataType == REG_MULTI_SZ), _At_((PZZSTR) PropertyBuffer, _Post_valid_))
WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceRegistryPropertyA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ DWORD Property,
  _Out_opt_ PDWORD PropertyRegDataType, 
  _Out_writes_bytes_to_opt_(PropertyBufferSize, *RequiredSize) PBYTE PropertyBuffer,
  _In_ DWORD PropertyBufferSize,
  _Out_opt_ PDWORD RequiredSize);

_Success_(return != FALSE)
_When_((*PropertyRegDataType == REG_SZ), _At_((PWSTR) PropertyBuffer, _Post_valid_))
_When_((*PropertyRegDataType == REG_MULTI_SZ), _At_((PZZWSTR) PropertyBuffer, _Post_valid_))
WINSETUPAPI
BOOL
WINAPI
SetupDiGetDeviceRegistryPropertyW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ DWORD Property,
  _Out_opt_ PDWORD PropertyRegDataType,
  _Out_writes_bytes_to_opt_(PropertyBufferSize, *RequiredSize) PBYTE PropertyBuffer,
  _In_ DWORD PropertyBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetDriverInfoDetailA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ PSP_DRVINFO_DATA_A DriverInfoData,
  _Inout_updates_bytes_opt_(DriverInfoDetailDataSize) PSP_DRVINFO_DETAIL_DATA_A DriverInfoDetailData, 
  _In_ DWORD DriverInfoDetailDataSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetDriverInfoDetailW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ PSP_DRVINFO_DATA_W DriverInfoData,
  _Inout_updates_bytes_opt_(DriverInfoDetailDataSize) PSP_DRVINFO_DETAIL_DATA_W DriverInfoDetailData,
  _In_ DWORD DriverInfoDetailDataSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupDiGetDriverInstallParamsA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DRVINFO_DATA_A, _Out_ PSP_DRVINSTALL_PARAMS);
WINSETUPAPI BOOL WINAPI SetupDiGetDriverInstallParamsW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DRVINFO_DATA_W, _Out_ PSP_DRVINSTALL_PARAMS);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileFriendlyNameA(
  _In_ DWORD HwProfile,
  _Out_writes_(FriendlyNameSize) PSTR FriendlyName,
  _In_ DWORD FriendlyNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileFriendlyNameW(
  _In_ DWORD HwProfile,
  _Out_writes_(FriendlyNameSize) PWSTR FriendlyName,
  _In_ DWORD FriendlyNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileFriendlyNameExA(
  _In_ DWORD HwProfile,
  _Out_writes_(FriendlyNameSize) PSTR FriendlyName,
  _In_ DWORD FriendlyNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileFriendlyNameExW(
  _In_ DWORD HwProfile,
  _Out_writes_(FriendlyNameSize) PWSTR FriendlyName,
  _In_ DWORD FriendlyNameSize,
  _Out_opt_ PDWORD RequiredSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiGetHwProfileFriendlyNameW(DWORD,PWSTR,DWORD,PDWORD);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileList(
  _Out_writes_to_(HwProfileListSize, *RequiredSize) PDWORD HwProfileList,
  _In_ DWORD HwProfileListSize,
  _Out_ PDWORD RequiredSize,
  _Out_opt_ PDWORD CurrentlyActiveIndex);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileListExA(
  _Out_writes_to_(HwProfileListSize, *RequiredSize) PDWORD HwProfileList,
  _In_ DWORD HwProfileListSize,
  _Out_ PDWORD RequiredSize,
  _Out_opt_ PDWORD CurrentlyActiveIndex,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupDiGetHwProfileListExW(
  _Out_writes_to_(HwProfileListSize, *RequiredSize) PDWORD HwProfileList,
  _In_ DWORD HwProfileListSize,
  _Out_ PDWORD RequiredSize,
  _Out_opt_ PDWORD CurrentlyActiveIndex,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetINFClassA(
  _In_ PCSTR InfName,
  _Out_ LPGUID ClassGuid,
  _Out_writes_(ClassNameSize) PSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiGetINFClassW(
  _In_ PCWSTR InfName,
  _Out_ LPGUID ClassGuid,
  _Out_writes_(ClassNameSize) PWSTR ClassName,
  _In_ DWORD ClassNameSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupDiGetSelectedDevice(_In_ HDEVINFO, _Out_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiGetSelectedDriverA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Out_ PSP_DRVINFO_DATA_A);
WINSETUPAPI BOOL WINAPI SetupDiGetSelectedDriverW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Out_ PSP_DRVINFO_DATA_W);
WINSETUPAPI HPROPSHEETPAGE WINAPI SetupDiGetWizardPage(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_INSTALLWIZARD_DATA, _In_ DWORD, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupDiInstallClassA(_In_opt_ HWND, _In_ PCSTR, _In_ DWORD, _In_opt_ HSPFILEQ);
WINSETUPAPI BOOL WINAPI SetupDiInstallClassW(_In_opt_ HWND, _In_ PCWSTR, _In_ DWORD, _In_opt_ HSPFILEQ);
WINSETUPAPI BOOL WINAPI SetupDiInstallClassExA(_In_opt_ HWND, _In_opt_ PCSTR, _In_ DWORD, _In_opt_ HSPFILEQ, _In_opt_ CONST GUID*, _Reserved_ PVOID, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiInstallClassExW(_In_opt_ HWND, _In_opt_ PCWSTR, _In_ DWORD, _In_opt_ HSPFILEQ, _In_opt_ CONST GUID*, _Reserved_ PVOID, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiInstallDevice(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiInstallDeviceInterfaces(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiInstallDriverFiles(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiLoadClassIcon(_In_ CONST GUID*, _Out_opt_ HICON*, _Out_opt_ PINT);
WINSETUPAPI BOOL WINAPI SetupDiMoveDuplicateDevice(HDEVINFO,PSP_DEVINFO_DATA);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiOpenClassRegKey(_In_opt_ CONST GUID*, _In_ REGSAM);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiOpenClassRegKeyExA(_In_opt_ CONST GUID*, _In_ REGSAM, _In_ DWORD, _In_opt_ PCSTR, _Reserved_ PVOID);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiOpenClassRegKeyExW(_In_opt_ CONST GUID*, _In_ REGSAM, _In_ DWORD, _In_opt_ PCWSTR, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupDiOpenDeviceInfoA(_In_ HDEVINFO, _In_ PCSTR, _In_opt_ HWND, _In_ DWORD, _Out_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiOpenDeviceInfoW(_In_ HDEVINFO, _In_ PCWSTR, _In_opt_ HWND, _In_ DWORD, _Out_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiOpenDeviceInterfaceA(_In_ HDEVINFO, _In_ PCSTR, _In_ DWORD, _Out_opt_ PSP_DEVICE_INTERFACE_DATA);
WINSETUPAPI BOOL WINAPI SetupDiOpenDeviceInterfaceW(_In_ HDEVINFO, _In_ PCWSTR, _In_ DWORD, _Out_opt_ PSP_DEVICE_INTERFACE_DATA);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiOpenDeviceInterfaceRegKey(_In_ HDEVINFO, _In_ PSP_DEVICE_INTERFACE_DATA, _Reserved_ DWORD, _In_ REGSAM);
_Check_return_ WINSETUPAPI HKEY WINAPI SetupDiOpenDevRegKey(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA, _In_ DWORD, _In_ DWORD, _In_ DWORD, _In_ REGSAM);
WINSETUPAPI BOOL WINAPI SetupDiRegisterCoDeviceInstallers(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiRegisterDeviceInfo(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA, _In_ DWORD, _In_opt_ PSP_DETSIG_CMPPROC, _In_opt_ PVOID, _Out_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiRemoveDevice(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiRemoveDeviceInterface(_In_ HDEVINFO, _Inout_ PSP_DEVICE_INTERFACE_DATA);
WINSETUPAPI BOOL WINAPI SetupDiRestartDevices(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiSelectBestCompatDrv(_In_ HDEVINFO, _Inout_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiSelectDevice(_In_ HDEVINFO, _Inout_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiSelectOEMDrv(_In_opt_ HWND, _In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetClassInstallParamsA(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_reads_bytes_opt_(ClassInstallParamsSize) PSP_CLASSINSTALL_HEADER ClassInstallParams,
  _In_ DWORD ClassInstallParamsSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetClassInstallParamsW(
  _In_ HDEVINFO DeviceInfoSet,
  _In_opt_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_reads_bytes_opt_(ClassInstallParamsSize) PSP_CLASSINSTALL_HEADER ClassInstallParams,
  _In_ DWORD ClassInstallParamsSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetClassRegistryPropertyA(
  _In_ CONST GUID *ClassGuid,
  _In_ DWORD Property,
  _In_reads_bytes_opt_(PropertyBufferSize) CONST BYTE *PropertyBuffer, 
  _In_ DWORD PropertyBufferSize,
  _In_opt_ PCSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetClassRegistryPropertyW(
  _In_ CONST GUID *ClassGuid,
  _In_ DWORD Property,
  _In_reads_bytes_opt_(PropertyBufferSize) CONST BYTE *PropertyBuffer,
  _In_ DWORD PropertyBufferSize,
  _In_opt_ PCWSTR MachineName,
  _Reserved_ PVOID Reserved);

WINSETUPAPI BOOL WINAPI SetupDiSetDeviceInstallParamsA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DEVINSTALL_PARAMS_A);
WINSETUPAPI BOOL WINAPI SetupDiSetDeviceInstallParamsW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DEVINSTALL_PARAMS_W);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetDeviceRegistryPropertyA(
  _In_ HDEVINFO DeviceInfoSet,
  _Inout_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ DWORD Property,
  _In_reads_bytes_opt_(PropertyBufferSize) CONST BYTE *PropertyBuffer,
  _In_ DWORD PropertyBufferSize);

WINSETUPAPI
BOOL
WINAPI
SetupDiSetDeviceRegistryPropertyW(
  _In_ HDEVINFO DeviceInfoSet,
  _Inout_ PSP_DEVINFO_DATA DeviceInfoData,
  _In_ DWORD Property,
  _In_reads_bytes_opt_(PropertyBufferSize) CONST BYTE *PropertyBuffer,
  _In_ DWORD PropertyBufferSize);

WINSETUPAPI BOOL WINAPI SetupDiSetDriverInstallParamsA(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DRVINFO_DATA_A, _In_ PSP_DRVINSTALL_PARAMS);
WINSETUPAPI BOOL WINAPI SetupDiSetDriverInstallParamsW(_In_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _In_ PSP_DRVINFO_DATA_W, _In_ PSP_DRVINSTALL_PARAMS);
WINSETUPAPI BOOL WINAPI SetupDiSetSelectedDevice(_In_ HDEVINFO, _In_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupDiSetSelectedDriverA(_In_ HDEVINFO, _Inout_opt_ PSP_DEVINFO_DATA, _Inout_opt_ PSP_DRVINFO_DATA_A);
WINSETUPAPI BOOL WINAPI SetupDiSetSelectedDriverW(_In_ HDEVINFO, _Inout_opt_ PSP_DEVINFO_DATA, _Inout_opt_ PSP_DRVINFO_DATA_W);
WINSETUPAPI BOOL WINAPI SetupDiUnremoveDevice(_In_ HDEVINFO, _Inout_ PSP_DEVINFO_DATA);
WINSETUPAPI HDSKSPC WINAPI SetupDuplicateDiskSpaceListA(_In_ HDSKSPC, _Reserved_ PVOID, _Reserved_ DWORD, _In_ UINT);
WINSETUPAPI HDSKSPC WINAPI SetupDuplicateDiskSpaceListW(_In_ HDSKSPC, _Reserved_ PVOID, _Reserved_ DWORD, _In_ UINT);
WINSETUPAPI BOOL WINAPI SetupFindFirstLineA(_In_ HINF, _In_ PCSTR, _In_opt_ PCSTR, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupFindFirstLineW(_In_ HINF, _In_ PCWSTR, _In_opt_ PCWSTR, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupFindNextLine(_In_ PINFCONTEXT, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupFindNextMatchLineA(_In_ PINFCONTEXT, _In_opt_ PCSTR, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupFindNextMatchLineW(_In_ PINFCONTEXT, _In_opt_ PCWSTR, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupFreeA(PCSTR**,UINT);
WINSETUPAPI BOOL WINAPI SetupFreeW(PCWSTR**,UINT);
WINSETUPAPI BOOL WINAPI SetupGetBackupInformationA(_In_ HSPFILEQ, _Inout_ PSP_BACKUP_QUEUE_PARAMS_A);
WINSETUPAPI BOOL WINAPI SetupGetBackupInformationW(_In_ HSPFILEQ, _Inout_ PSP_BACKUP_QUEUE_PARAMS_W);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupGetBinaryField(
  _In_ PINFCONTEXT Context,
  _In_ DWORD FieldIndex,
  _Out_writes_bytes_to_opt_(ReturnBufferSize, *RequiredSize) PBYTE ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ LPDWORD RequiredSize);

WINSETUPAPI DWORD WINAPI SetupGetFieldCount(_In_ PINFCONTEXT);
WINSETUPAPI DWORD WINAPI SetupGetFileCompressionInfoA(_In_ PCSTR, _Out_ PSTR*, _Out_ PDWORD, _Out_ PDWORD, _Out_ PUINT);
WINSETUPAPI DWORD WINAPI SetupGetFileCompressionInfoW(_In_ PCWSTR, _Out_ PWSTR*, _Out_ PDWORD, _Out_ PDWORD, _Out_ PUINT);

WINSETUPAPI
BOOL
WINAPI
SetupGetFileCompressionInfoExA(
  _In_ PCSTR SourceFileName,
  _In_reads_opt_(ActualSourceFileNameBufferLen) PSTR ActualSourceFileNameBuffer,
  _In_ DWORD ActualSourceFileNameBufferLen,
  _Out_opt_ PDWORD RequiredBufferLen, 
  _Out_ PDWORD SourceFileSize,
  _Out_ PDWORD TargetFileSize,
  _Out_ PUINT CompressionType);

WINSETUPAPI
BOOL
WINAPI
SetupGetFileCompressionInfoExW(
  _In_ PCWSTR SourceFileName,
  _In_reads_opt_(ActualSourceFileNameBufferLen) PWSTR ActualSourceFileNameBuffer,
  _In_ DWORD ActualSourceFileNameBufferLen,
  _Out_opt_ PDWORD RequiredBufferLen,
  _Out_ PDWORD SourceFileSize,
  _Out_ PDWORD TargetFileSize,
  _Out_ PUINT CompressionType);

WINSETUPAPI
BOOL
WINAPI
SetupGetInfFileListA(
  _In_opt_ PCSTR DirectoryPath,
  _In_ DWORD InfStyle,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer, 
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetInfFileListW(
  _In_opt_ PCWSTR DirectoryPath,
  _In_ DWORD InfStyle,
  _Out_writes_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupGetInfInformationA(
  _In_ LPCVOID InfSpec,
  _In_ DWORD SearchControl,
  _Out_writes_bytes_to_opt_(ReturnBufferSize, *RequiredSize) PSP_INF_INFORMATION ReturnBuffer, 
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

_Success_(return != FALSE)
WINSETUPAPI
BOOL
WINAPI
SetupGetInfInformationW(
  _In_ LPCVOID InfSpec,
  _In_ DWORD SearchControl,
  _Out_writes_bytes_to_opt_(ReturnBufferSize, *RequiredSize) PSP_INF_INFORMATION ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupGetIntField(_In_ PINFCONTEXT, _In_ DWORD, _Out_ PINT);
WINSETUPAPI BOOL WINAPI SetupGetLineByIndexA(_In_ HINF, _In_ PCSTR, _In_ DWORD, _Out_ PINFCONTEXT);
WINSETUPAPI BOOL WINAPI SetupGetLineByIndexW(_In_ HINF, _In_ PCWSTR, _In_ DWORD, _Out_ PINFCONTEXT);
WINSETUPAPI LONG WINAPI SetupGetLineCountA(_In_ HINF, _In_ PCSTR);
WINSETUPAPI LONG WINAPI SetupGetLineCountW(_In_ HINF, _In_ PCWSTR);

WINSETUPAPI
BOOL
WINAPI
SetupGetLineTextA(
  _In_opt_ PINFCONTEXT Context,
  _In_opt_ HINF InfHandle,
  _In_opt_ PCSTR Section,
  _In_opt_ PCSTR Key,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetLineTextW(
  _In_opt_ PINFCONTEXT Context,
  _In_opt_ HINF InfHandle,
  _In_opt_ PCWSTR Section,
  _In_opt_ PCWSTR Key,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetMultiSzFieldA(
  _In_ PINFCONTEXT Context,
  _In_ DWORD FieldIndex,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ LPDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetMultiSzFieldW(
  _In_ PINFCONTEXT Context,
  _In_ DWORD FieldIndex,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ LPDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetSourceFileLocationA(
  _In_ HINF InfHandle,
  _In_opt_ PINFCONTEXT InfContext,
  _In_opt_ PCSTR FileName,
  _Out_ PUINT SourceId,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetSourceFileLocationW(
  _In_ HINF InfHandle,
  _In_opt_ PINFCONTEXT InfContext,
  _In_opt_ PCWSTR FileName,
  _Out_ PUINT SourceId,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupGetSourceFileSizeA(_In_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCSTR, _In_opt_ PCSTR, _Out_ PDWORD, _In_ UINT);
WINSETUPAPI BOOL WINAPI SetupGetSourceFileSizeW(_In_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _Out_ PDWORD, _In_ UINT);

WINSETUPAPI
BOOL
WINAPI
SetupGetSourceInfoA(
  _In_ HINF InfHandle,
  _In_ UINT SourceId,
  _In_ UINT InfoDesired,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetSourceInfoW(
  _In_ HINF InfHandle,
  _In_ UINT SourceId,
  _In_ UINT InfoDesired,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetStringFieldA(
  _In_ PINFCONTEXT Context,
  _In_ DWORD FieldIndex,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetStringFieldW(
  _In_ PINFCONTEXT Context,
  _In_ DWORD FieldIndex,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetTargetPathA(
  _In_ HINF InfHandle,
  _In_opt_ PINFCONTEXT InfContext,
  _In_opt_ PCSTR Section,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupGetTargetPathW(
  _In_ HINF InfHandle,
  _In_opt_ PINFCONTEXT InfContext,
  _In_opt_ PCWSTR Section,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI PVOID WINAPI SetupInitDefaultQueueCallback(_In_opt_ HWND);
WINSETUPAPI PVOID WINAPI SetupInitDefaultQueueCallbackEx(_In_opt_ HWND, _In_opt_ HWND, _In_ UINT, _Reserved_ DWORD, _Reserved_ PVOID);
WINSETUPAPI HSPFILELOG WINAPI SetupInitializeFileLogA(_In_opt_ PCSTR, _In_ DWORD);
WINSETUPAPI HSPFILELOG WINAPI SetupInitializeFileLogW(_In_opt_ PCWSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupInstallFileA(_In_opt_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ DWORD, _In_opt_ PSP_FILE_CALLBACK_A, _In_opt_ PVOID);
WINSETUPAPI BOOL WINAPI SetupInstallFileW(_In_opt_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ DWORD, _In_opt_ PSP_FILE_CALLBACK_W, _In_opt_ PVOID);
WINSETUPAPI BOOL WINAPI SetupInstallFileExA(_In_opt_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ DWORD, _In_opt_ PSP_FILE_CALLBACK_A, _In_opt_ PVOID, _Out_ PBOOL);
WINSETUPAPI BOOL WINAPI SetupInstallFileExW(_In_opt_ HINF, _In_opt_ PINFCONTEXT, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ DWORD, _In_opt_ PSP_FILE_CALLBACK_W, _In_opt_ PVOID, _Out_ PBOOL);
WINSETUPAPI BOOL WINAPI SetupInstallFilesFromInfSectionA(_In_ HINF, _In_opt_ HINF, _In_ HSPFILEQ, _In_ PCSTR, _In_opt_ PCSTR, _In_ UINT);
WINSETUPAPI BOOL WINAPI SetupInstallFilesFromInfSectionW(_In_ HINF, _In_opt_ HINF, _In_ HSPFILEQ, _In_ PCWSTR, _In_opt_ PCWSTR, _In_ UINT);
WINSETUPAPI BOOL WINAPI SetupInstallFromInfSectionA(_In_opt_ HWND, _In_ HINF, _In_ PCSTR, _In_ UINT, _In_opt_ HKEY, _In_opt_ PCSTR, _In_ UINT, _In_opt_ PSP_FILE_CALLBACK_A, _In_opt_ PVOID, _In_opt_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupInstallFromInfSectionW(_In_opt_ HWND, _In_ HINF, _In_ PCWSTR, _In_ UINT, _In_opt_ HKEY, _In_opt_ PCWSTR, _In_ UINT, _In_opt_ PSP_FILE_CALLBACK_W, _In_opt_ PVOID, _In_opt_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA);
WINSETUPAPI BOOL WINAPI SetupInstallServicesFromInfSectionA(_In_ HINF, _In_ PCSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupInstallServicesFromInfSectionW(_In_ HINF, _In_ PCWSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupInstallServicesFromInfSectionExA(_In_ HINF, _In_ PCSTR, _In_ DWORD, _In_opt_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Reserved_ PVOID, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupInstallServicesFromInfSectionExW(_In_ HINF, _In_ PCWSTR, _In_ DWORD, _In_opt_ HDEVINFO, _In_opt_ PSP_DEVINFO_DATA, _Reserved_ PVOID, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupIterateCabinetA(_In_ PCSTR, _Reserved_ DWORD, _In_ PSP_FILE_CALLBACK_A, _In_ PVOID);
WINSETUPAPI BOOL WINAPI SetupIterateCabinetW(_In_ PCWSTR, _Reserved_ DWORD, _In_ PSP_FILE_CALLBACK_W, _In_ PVOID);
WINSETUPAPI BOOL WINAPI SetupLogErrorA(_In_ LPCSTR, _In_ LogSeverity);
WINSETUPAPI BOOL WINAPI SetupLogErrorW(_In_ LPCWSTR, _In_ LogSeverity);
WINSETUPAPI BOOL WINAPI SetupLogFileA(_In_ HSPFILELOG, _In_opt_ PCSTR, _In_ PCSTR, _In_ PCSTR, _In_ DWORD, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupLogFileW(_In_ HSPFILELOG, _In_opt_ PCWSTR, _In_ PCWSTR, _In_ PCWSTR, _In_ DWORD, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ DWORD);

WINSETUPAPI
BOOL
WINAPI
SetupOpenAppendInfFileA(
  _In_opt_ PCSTR FileName,
  _In_ HINF InfHandle,
  _Out_opt_ PUINT ErrorLine);

WINSETUPAPI
BOOL
WINAPI
SetupOpenAppendInfFileW(
  _In_opt_ PCWSTR FileName,
  _In_ HINF InfHandle,
  _Out_opt_ PUINT ErrorLine);

WINSETUPAPI HSPFILEQ WINAPI SetupOpenFileQueue(VOID);

WINSETUPAPI
HINF
WINAPI
SetupOpenInfFileA(
  _In_ PCSTR FileName,
  _In_opt_ PCSTR InfClass,
  _In_ DWORD InfStyle,
  _Out_opt_ PUINT ErrorLine);

WINSETUPAPI
HINF
WINAPI
SetupOpenInfFileW(
  _In_ PCWSTR FileName,
  _In_opt_ PCWSTR InfClass,
  _In_ DWORD InfStyle,
  _Out_opt_ PUINT ErrorLine);

WINSETUPAPI BOOL WINAPI SetupOpenLog(_In_ BOOL);
WINSETUPAPI HINF WINAPI SetupOpenMasterInf(VOID);

WINSETUPAPI
UINT
WINAPI
SetupPromptForDiskA(
  _In_ HWND hwndParent,
  _In_opt_ PCSTR DialogTitle,
  _In_opt_ PCSTR DiskName,
  _In_opt_ PCSTR PathToSource,
  _In_ PCSTR FileSought,
  _In_opt_ PCSTR TagFile,
  _In_ DWORD DiskPromptStyle,
  _Out_writes_opt_(PathBufferSize) PSTR PathBuffer,
  _In_ DWORD PathBufferSize,
  _Out_opt_ PDWORD PathRequiredSize);

WINSETUPAPI
UINT
WINAPI
SetupPromptForDiskW(
  _In_ HWND hwndParent,
  _In_opt_ PCWSTR DialogTitle,
  _In_opt_ PCWSTR DiskName,
  _In_opt_ PCWSTR PathToSource,
  _In_ PCWSTR FileSought,
  _In_opt_ PCWSTR TagFile,
  _In_ DWORD DiskPromptStyle,
  _Out_writes_opt_(PathBufferSize) PWSTR PathBuffer,
  _In_ DWORD PathBufferSize,
  _Out_opt_ PDWORD PathRequiredSize);

WINSETUPAPI INT WINAPI SetupPromptReboot(_In_opt_ HSPFILEQ, _In_opt_ HWND, _In_ BOOL);
WINSETUPAPI BOOL WINAPI SetupQueryA(DWORD,PCSTR**,PUINT);
WINSETUPAPI BOOL WINAPI SetupQueryW(DWORD,PCWSTR**,PUINT);

WINSETUPAPI
BOOL
WINAPI
SetupQueryDrivesInDiskSpaceListA(
  _In_ HDSKSPC DiskSpace,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryDrivesInDiskSpaceListW(
  _In_ HDSKSPC DiskSpace,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryFileLogA(
  _In_ HSPFILELOG FileLogHandle,
  _In_opt_ PCSTR LogSectionName,
  _In_ PCSTR TargetFilename,
  _In_ SetupFileLogInfo DesiredInfo,
  _Out_writes_opt_(ReturnBufferSize) PSTR DataOut,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryFileLogW(
  _In_ HSPFILELOG FileLogHandle,
  _In_opt_ PCWSTR LogSectionName,
  _In_ PCWSTR TargetFilename,
  _In_ SetupFileLogInfo DesiredInfo,
  _Out_writes_opt_(ReturnBufferSize) PWSTR DataOut,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfFileInformationA(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfFileInformationW(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfOriginalFileInformationA(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _In_opt_ PSP_ALTPLATFORM_INFO AlternatePlatformInfo,
  _Out_ PSP_ORIGINAL_FILE_INFO_A OriginalFileInfo);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfOriginalFileInformationW(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _In_opt_ PSP_ALTPLATFORM_INFO AlternatePlatformInfo,
  _Out_ PSP_ORIGINAL_FILE_INFO_W OriginalFileInfo);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfVersionInformationA(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _In_opt_ PCSTR Key,
  _Out_writes_opt_(ReturnBufferSize) PSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI
BOOL
WINAPI
SetupQueryInfVersionInformationW(
  _In_ PSP_INF_INFORMATION InfInformation,
  _In_ UINT InfIndex,
  _In_opt_ PCWSTR Key,
  _Out_writes_opt_(ReturnBufferSize) PWSTR ReturnBuffer,
  _In_ DWORD ReturnBufferSize,
  _Out_opt_ PDWORD RequiredSize);

WINSETUPAPI BOOL WINAPI SetupQuerySpaceRequiredOnDriveA(_In_ HDSKSPC, _In_ PCSTR, _Out_ LONGLONG*, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupQuerySpaceRequiredOnDriveW(_In_ HDSKSPC, _In_ PCWSTR, _Out_ LONGLONG*, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupQueueCopyA(_In_ HSPFILEQ, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ PCSTR, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ PCSTR, _In_opt_ PCSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueCopyW(_In_ HSPFILEQ, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ PCWSTR, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ PCWSTR, _In_opt_ PCWSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueCopyIndirectA(_In_ PSP_FILE_COPY_PARAMS_A);
WINSETUPAPI BOOL WINAPI SetupQueueCopyIndirectW(_In_ PSP_FILE_COPY_PARAMS_W);
WINSETUPAPI BOOL WINAPI SetupQueueCopySectionA(_In_ HSPFILEQ, _In_opt_ PCSTR, _In_ HINF, _In_opt_ HINF, _In_ PCSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueCopySectionW(_In_ HSPFILEQ, _In_opt_ PCWSTR, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueDefaultCopyA(_In_ HSPFILEQ, _In_ HINF, _In_opt_ PCSTR, _In_ PCSTR, _In_opt_ PCSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueDefaultCopyW(_In_ HSPFILEQ, _In_ HINF, _In_opt_ PCWSTR, _In_ PCWSTR, _In_opt_ PCWSTR, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupQueueDeleteA(_In_ HSPFILEQ, _In_ PCSTR, _In_opt_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupQueueDeleteW(_In_ HSPFILEQ, _In_ PCWSTR, _In_opt_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupQueueDeleteSectionA(_In_ HSPFILEQ, _In_ HINF, _In_opt_ HINF, _In_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupQueueDeleteSectionW(_In_ HSPFILEQ, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupQueueRenameA(_In_ HSPFILEQ, _In_ PCSTR, _In_opt_ PCSTR, _In_opt_ PCSTR, _In_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupQueueRenameW(_In_ HSPFILEQ, _In_ PCWSTR, _In_opt_ PCWSTR, _In_opt_ PCWSTR, _In_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupQueueRenameSectionA(_In_ HSPFILEQ, _In_ HINF, _In_opt_ HINF, _In_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupQueueRenameSectionW(_In_ HSPFILEQ, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupRemoveFileLogEntryA(_In_ HSPFILELOG, _In_opt_ PCSTR, _In_opt_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupRemoveFileLogEntryW(_In_ HSPFILELOG, _In_opt_ PCWSTR, _In_opt_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupRemoveFromDiskSpaceListA(_In_ HDSKSPC, _In_ PCSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupRemoveFromDiskSpaceListW(_In_ HDSKSPC, _In_ PCWSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupRemoveFromSourceListA(_In_ DWORD, _In_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupRemoveFromSourceListW(_In_ DWORD, _In_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupRemoveInstallSectionFromDiskSpaceListA(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCSTR, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupRemoveInstallSectionFromDiskSpaceListW(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupRemoveSectionFromDiskSpaceListA(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI BOOL WINAPI SetupRemoveSectionFromDiskSpaceListW(_In_ HDSKSPC, _In_ HINF, _In_opt_ HINF, _In_ PCWSTR, _In_ UINT, _Reserved_ PVOID, _Reserved_ UINT);
WINSETUPAPI UINT WINAPI SetupRenameErrorA(_In_ HWND, _In_opt_ PCSTR, _In_ PCSTR, _In_ PCSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI UINT WINAPI SetupRenameErrorW(_In_ HWND, _In_opt_ PCWSTR, _In_ PCWSTR, _In_ PCWSTR, _In_ UINT, _In_ DWORD);
WINSETUPAPI BOOL WINAPI SetupScanFileQueueA(_In_ HSPFILEQ, _In_ DWORD, _In_opt_ HWND, _In_opt_ PSP_FILE_CALLBACK_A, _In_opt_ PVOID, _Out_ PDWORD);
WINSETUPAPI BOOL WINAPI SetupScanFileQueueW(_In_ HSPFILEQ, _In_ DWORD, _In_opt_ HWND, _In_opt_ PSP_FILE_CALLBACK_W, _In_opt_ PVOID, _Out_ PDWORD);
WINSETUPAPI BOOL WINAPI SetupSetDirectoryIdA(_In_ HINF, _In_ DWORD, _In_opt_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupSetDirectoryIdW(_In_ HINF, _In_ DWORD, _In_opt_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupSetDirectoryIdExA(_In_ HINF, _In_ DWORD, _In_opt_ PCSTR, _In_ DWORD, _Reserved_ DWORD, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupSetDirectoryIdExW(_In_ HINF, _In_ DWORD, _In_opt_ PCWSTR, _In_ DWORD, _Reserved_ DWORD, _Reserved_ PVOID);
WINSETUPAPI BOOL WINAPI SetupSetFileQueueAlternatePlatformA(_In_ HSPFILEQ, _In_opt_ PSP_ALTPLATFORM_INFO, _In_opt_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupSetFileQueueAlternatePlatformW(_In_ HSPFILEQ, _In_opt_ PSP_ALTPLATFORM_INFO, _In_opt_ PCWSTR);
WINSETUPAPI BOOL WINAPI SetupSetNonInteractiveMode(_In_ BOOL);
WINSETUPAPI BOOL WINAPI SetupSetPlatformPathOverrideA(_In_opt_ PCSTR);
WINSETUPAPI BOOL WINAPI SetupSetPlatformPathOverrideW(_In_opt_ PCWSTR);

WINSETUPAPI
BOOL
WINAPI
SetupSetSourceListA(
  _In_ DWORD Flags,
  _In_reads_(SourceCount) PCSTR *SourceList,
  _In_ UINT SourceCount);

WINSETUPAPI
BOOL
WINAPI
SetupSetSourceListW(
  _In_ DWORD Flags,
  _In_reads_(SourceCount) PCWSTR *SourceList,
  _In_ UINT SourceCount);

WINSETUPAPI VOID WINAPI SetupTermDefaultQueueCallback(_In_ PVOID);
WINSETUPAPI BOOL WINAPI SetupTerminateFileLog(_In_ HSPFILELOG);

WINSETUPAPI
BOOL
WINAPI
SetupUninstallOEMInfA(
  _In_ PCSTR InfFileName,
  _In_ DWORD Flags,
  _In_ PVOID Reserved);

WINSETUPAPI
BOOL
WINAPI
SetupUninstallOEMInfW(
  _In_ PCWSTR InfFileName,
  _In_ DWORD Flags,
  _In_ PVOID Reserved);

WINSETUPAPI DWORD WINAPI StampFileSecurity(PCWSTR, PSECURITY_DESCRIPTOR);


WINSETUPAPI DWORD WINAPI pSetupCaptureAndConvertAnsiArg(PCSTR, PWSTR*);
WINSETUPAPI VOID WINAPI pSetupCenterWindowRelativeToParent(HWND);
WINSETUPAPI BOOL WINAPI pSetupConcatenatePaths(LPWSTR, LPCWSTR, DWORD, LPDWORD);
WINSETUPAPI PWSTR WINAPI pSetupDuplicateString(PCWSTR);
WINSETUPAPI BOOL WINAPI pSetupEnablePrivilege(PCWSTR, BOOL);
WINSETUPAPI PWSTR WINAPI pSetupGetFileTitle(PCWSTR);
WINSETUPAPI BOOL WINAPI pSetupGetVersionInfoFromImage(LPWSTR, PULARGE_INTEGER, LPWORD);
WINSETUPAPI DWORD WINAPI pSetupGuidFromString(PCWSTR, LPGUID);
WINSETUPAPI BOOL WINAPI pSetupIsGuidNull(LPGUID);
WINSETUPAPI BOOL WINAPI pSetupIsUserAdmin(VOID);
WINSETUPAPI PWSTR WINAPI pSetupMultiByteToUnicode(PCSTR, UINT);
WINSETUPAPI DWORD WINAPI pSetupOpenAndMapForRead(PCWSTR, PDWORD, PHANDLE, PHANDLE, PVOID*);
WINSETUPAPI DWORD WINAPI pSetupStringFromGuid(LPGUID, PWSTR, DWORD);


WINSETUPAPI DWORD  WINAPI pSetupStringTableAddString(HSTRING_TABLE, LPWSTR, DWORD);
WINSETUPAPI DWORD  WINAPI pSetupStringTableAddStringEx(HSTRING_TABLE, LPWSTR, DWORD, LPVOID, DWORD);
WINSETUPAPI VOID   WINAPI pSetupStringTableDestroy(HSTRING_TABLE);
WINSETUPAPI HSTRING_TABLE WINAPI pSetupStringTableDuplicate(HSTRING_TABLE);
WINSETUPAPI BOOL   WINAPI pSetupStringTableGetExtraData(HSTRING_TABLE, DWORD, LPVOID, DWORD);
WINSETUPAPI HSTRING_TABLE WINAPI pSetupStringTableInitialize(VOID);
WINSETUPAPI HSTRING_TABLE WINAPI pSetupStringTableInitializeEx(DWORD, DWORD);
WINSETUPAPI DWORD  WINAPI pSetupStringTableLookUpString(HSTRING_TABLE, LPWSTR, DWORD);
WINSETUPAPI DWORD  WINAPI pSetupStringTableLookUpStringEx(HSTRING_TABLE, LPWSTR, DWORD, LPVOID, DWORD);
WINSETUPAPI BOOL   WINAPI pSetupStringTableSetExtraData(HSTRING_TABLE, DWORD, LPVOID, DWORD);
WINSETUPAPI LPWSTR WINAPI pSetupStringTableStringFromId(HSTRING_TABLE, DWORD);
WINSETUPAPI BOOL   WINAPI pSetupStringTableStringFromIdEx(HSTRING_TABLE, DWORD, LPWSTR, LPDWORD);

WINSETUPAPI PSTR WINAPI pSetupUnicodeToMultiByte(PCWSTR lpUnicodeStr, UINT uCodePage);
WINSETUPAPI BOOL WINAPI pSetupUnmapAndCloseFile(HANDLE, HANDLE, PVOID);


WINSETUPAPI DWORD WINAPI TakeOwnershipOfFile(PCWSTR);
WINSETUPAPI PSTR WINAPI UnicodeToMultiByte(PCWSTR lpUnicodeStr, UINT uCodePage);


/* for backward compatability */
#define SetupDiCreateInterfaceDeviceW	SetupDiCreateDeviceInterfaceW
#define SetupDiCreateInterfaceDeviceRegKeyW	SetupDiCreateDeviceInterfaceRegKeyW
#define SetupDiOpenInterfaceDeviceW	SetupDiOpenDeviceInterfaceW
#define SetupDiGetInterfaceDeviceDetailW	SetupDiGetDeviceInterfaceDetailW
#define SetupDiCreateInterfaceDeviceA	SetupDiCreateDeviceInterfaceA
#define SetupDiCreateInterfaceDeviceRegKeyA	SetupDiCreateDeviceInterfaceRegKeyA
#define SetupDiOpenInterfaceDeviceA	SetupDiOpenDeviceInterfaceA
#define SetupDiGetInterfaceDeviceDetailA	SetupDiGetDeviceInterfaceDetailA

#ifdef UNICODE
#define PSP_FILE_CALLBACK PSP_FILE_CALLBACK_W
#define InstallHinfSection InstallHinfSectionW
#define SetupAddInstallSectionToDiskSpaceList	SetupAddInstallSectionToDiskSpaceListW
#define SetupAddSectionToDiskSpaceList	SetupAddSectionToDiskSpaceListW
#define SetupAddToDiskSpaceList	SetupAddToDiskSpaceListW
#define SetupAddToSourceList	SetupAddToSourceListW
#define SetupAdjustDiskSpaceList	SetupAdjustDiskSpaceListW
#define SetupBackupError	SetupBackupErrorW
#define SetupCommitFileQueue	SetupCommitFileQueueW
#define SetupCopyError	SetupCopyErrorW
#define SetupCopyOEMInf	SetupCopyOEMInfW
#define SetupCreateDiskSpaceList	SetupCreateDiskSpaceListW
#define SetupDecompressOrCopyFile	SetupDecompressOrCopyFileW
#define SetupDefaultQueueCallback	SetupDefaultQueueCallbackW
#define SetupDeleteError	SetupDeleteErrorW
#define SetupDiBuildClassInfoListEx	SetupDiBuildClassInfoListExW
#define SetupDiClassGuidsFromNameEx	SetupDiClassGuidsFromNameExW
#define SetupDiClassGuidsFromName	SetupDiClassGuidsFromNameW
#define SetupDiClassNameFromGuidEx	SetupDiClassNameFromGuidExW
#define SetupDiClassNameFromGuid	SetupDiClassNameFromGuidW
#define SetupDiCreateDeviceInfoListEx	SetupDiCreateDeviceInfoListExW
#define SetupDiCreateDeviceInfo	SetupDiCreateDeviceInfoW
#define SetupDiCreateDeviceInterfaceRegKey	SetupDiCreateDeviceInterfaceRegKeyW
#define SetupDiCreateInterfaceDeviceRegKey	SetupDiCreateDeviceInterfaceRegKeyW
#define SetupDiCreateDeviceInterface	SetupDiCreateDeviceInterfaceW
#define SetupDiCreateInterfaceDevice	SetupDiCreateDeviceInterfaceW
#define SetupDiCreateDevRegKey	SetupDiCreateDevRegKeyW
#define SetupDiEnumDriverInfo	SetupDiEnumDriverInfoW
#define SetupDiGetActualSectionToInstall	SetupDiGetActualSectionToInstallW
#define SetupDiGetActualSectionToInstallEx	SetupDiGetActualSectionToInstallExW
#define SetupDiGetClassDescriptionEx	SetupDiGetClassDescriptionExW
#define SetupDiGetClassDescription	SetupDiGetClassDescriptionW
#define SetupDiGetClassDevPropertySheets	SetupDiGetClassDevPropertySheetsW
#define SetupDiGetClassDevsEx	SetupDiGetClassDevsExW
#define SetupDiGetClassDevs	SetupDiGetClassDevsW
#define SetupDiGetClassImageListEx	SetupDiGetClassImageListExW
#define SetupDiGetClassInstallParams	SetupDiGetClassInstallParamsW
#define SetupDiGetClassRegistryProperty	SetupDiGetClassRegistryPropertyW
#define SetupDiGetDeviceInfoListDetail	SetupDiGetDeviceInfoListDetailW
#define SetupDiGetDeviceInstallParams	SetupDiGetDeviceInstallParamsW
#define SetupDiGetDeviceInstanceId	SetupDiGetDeviceInstanceIdW
#define SetupDiGetDeviceInterfaceDetail	SetupDiGetDeviceInterfaceDetailW
#define SetupDiGetInterfaceDeviceDetail	SetupDiGetDeviceInterfaceDetailW
#define SetupDiGetDeviceRegistryProperty	SetupDiGetDeviceRegistryPropertyW
#define SetupDiGetDriverInfoDetail	SetupDiGetDriverInfoDetailW
#define SetupDiGetDriverInstallParams	SetupDiGetDriverInstallParamsW
#define SetupDiGetHwProfileFriendlyNameEx	SetupDiGetHwProfileFriendlyNameExW
#define SetupDiGetHwProfileFriendlyName	SetupDiGetHwProfileFriendlyNameW
#define SetupDiGetHwProfileListEx	SetupDiGetHwProfileListExW
#define SetupDiGetINFClass	SetupDiGetINFClassW
#define SetupDiGetSelectedDriver	SetupDiGetSelectedDriverW
#define SetupDiInstallClassEx	SetupDiInstallClassExW
#define SetupDiInstallClass	SetupDiInstallClassW
#define SetupDiOpenClassRegKeyEx	SetupDiOpenClassRegKeyExW
#define SetupDiOpenDeviceInfo	SetupDiOpenDeviceInfoW
#define SetupDiOpenDeviceInterface	SetupDiOpenDeviceInterfaceW
#define SetupDiOpenInterfaceDevice	SetupDiOpenDeviceInterfaceW
#define SetupDiSetClassInstallParams	SetupDiSetClassInstallParamsW
#define SetupDiSetClassRegistryProperty	SetupDiSetClassRegistryPropertyW
#define SetupDiSetDeviceInstallParams	SetupDiSetDeviceInstallParamsW
#define SetupDiSetDeviceRegistryProperty	SetupDiSetDeviceRegistryPropertyW
#define SetupDiSetDriverInstallParams	SetupDiSetDriverInstallParamsW
#define SetupDiSetSelectedDriver	SetupDiSetSelectedDriverW
#define SetupDuplicateDiskSpaceList	SetupDuplicateDiskSpaceListW
#define SetupFindFirstLine	SetupFindFirstLineW
#define SetupFindNextMatchLine	SetupFindNextMatchLineW
#define SetupFreeSourceList	SetupFreeSourceListW
#define SetupGetBackupInformation	SetupGetBackupInformationW
#define SetupGetFileCompressionInfo	SetupGetFileCompressionInfoW
#define SetupGetFileCompressionInfoEx	SetupGetFileCompressionInfoExW
#define SetupGetInfFileList	SetupGetInfFileListW
#define SetupGetInfInformation	SetupGetInfInformationW
#define SetupGetLineByIndex	SetupGetLineByIndexW
#define SetupGetLineCount	SetupGetLineCountW
#define SetupGetLineText	SetupGetLineTextW
#define SetupGetMultiSzField	SetupGetMultiSzFieldW
#define SetupGetSourceFileLocation	SetupGetSourceFileLocationW
#define SetupGetSourceFileSize	SetupGetSourceFileSizeW
#define SetupGetSourceInfo	SetupGetSourceInfoW
#define SetupGetStringField	SetupGetStringFieldW
#define SetupGetTargetPath	SetupGetTargetPathW
#define SetupInitializeFileLog	SetupInitializeFileLogW
#define SetupInstallFileEx	SetupInstallFileExW
#define SetupInstallFilesFromInfSection	SetupInstallFilesFromInfSectionW
#define SetupInstallFile	SetupInstallFileW
#define SetupInstallFromInfSection	SetupInstallFromInfSectionW
#define SetupInstallServicesFromInfSectionEx	SetupInstallServicesFromInfSectionExW
#define SetupInstallServicesFromInfSection	SetupInstallServicesFromInfSectionW
#define SetupIterateCabinet	SetupIterateCabinetW
#define SetupLogError	SetupLogErrorW
#define SetupLogFile	SetupLogFileW
#define SetupOpenAppendInfFile	SetupOpenAppendInfFileW
#define SetupOpenInfFile	SetupOpenInfFileW
#define SetupPromptForDisk	SetupPromptForDiskW
#define SetupQueryDrivesInDiskSpaceList	SetupQueryDrivesInDiskSpaceListW
#define SetupQueryFileLog	SetupQueryFileLogW
#define SetupQueryInfFileInformation	SetupQueryInfFileInformationW
#define SetupQueryInfOriginalFileInformation	SetupQueryInfOriginalFileInformationW
#define SetupQueryInfVersionInformation	SetupQueryInfVersionInformationW
#define SetupQuerySourceList	SetupQuerySourceListW
#define SetupQuerySpaceRequiredOnDrive	SetupQuerySpaceRequiredOnDriveW
#define SetupQueueCopyIndirect	SetupQueueCopyIndirectW
#define SetupQueueCopySection	SetupQueueCopySectionW
#define SetupQueueCopy	SetupQueueCopyW
#define SetupQueueDefaultCopy	SetupQueueDefaultCopyW
#define SetupQueueDeleteSection	SetupQueueDeleteSectionW
#define SetupQueueDelete	SetupQueueDeleteW
#define SetupQueueRenameSection	SetupQueueRenameSectionW
#define SetupQueueRename	SetupQueueRenameW
#define SetupRemoveFileLogEntry	SetupRemoveFileLogEntryW
#define SetupRemoveFromDiskSpaceList	SetupRemoveFromDiskSpaceListW
#define SetupRemoveFromSourceList	SetupRemoveFromSourceListW
#define SetupRemoveInstallSectionFromDiskSpaceList	SetupRemoveInstallSectionFromDiskSpaceListW
#define SetupRemoveSectionFromDiskSpaceList	SetupRemoveSectionFromDiskSpaceListW
#define SetupRenameError	SetupRenameErrorW
#define SetupScanFileQueue	SetupScanFileQueueW
#define SetupSetDirectoryIdEx	SetupSetDirectoryIdExW
#define SetupSetDirectoryId	SetupSetDirectoryIdW
#define SetupSetFileQueueAlternatePlatform	SetupSetFileQueueAlternatePlatformW
#define SetupSetPlatformPathOverride	SetupSetPlatformPathOverrideW
#define SetupSetSourceList	SetupSetSourceListW
#define SetupUninstallOEMInf    SetupUninstallOEMInfW
#else
#define PSP_FILE_CALLBACK PSP_FILE_CALLBACK_A
#define InstallHinfSection InstallHinfSectionA
#define SetupAddInstallSectionToDiskSpaceList	SetupAddInstallSectionToDiskSpaceListA
#define SetupAddSectionToDiskSpaceList	SetupAddSectionToDiskSpaceListA
#define SetupAddToDiskSpaceList	SetupAddToDiskSpaceListA
#define SetupAddToSourceList	SetupAddToSourceListA
#define SetupAdjustDiskSpaceList	SetupAdjustDiskSpaceListA
#define SetupBackupError	SetupBackupErrorA
#define SetupCommitFileQueue	SetupCommitFileQueueA
#define SetupCopyError	SetupCopyErrorA
#define SetupCopyOEMInf	SetupCopyOEMInfA
#define SetupCreateDiskSpaceList	SetupCreateDiskSpaceListA
#define SetupDecompressOrCopyFile	SetupDecompressOrCopyFileA
#define SetupDefaultQueueCallback	SetupDefaultQueueCallbackA
#define SetupDeleteError	SetupDeleteErrorA
#define SetupDiBuildClassInfoListEx	SetupDiBuildClassInfoListExA
#define SetupDiClassGuidsFromName	SetupDiClassGuidsFromNameA
#define SetupDiClassGuidsFromNameEx	SetupDiClassGuidsFromNameExA
#define SetupDiClassNameFromGuid	SetupDiClassNameFromGuidA
#define SetupDiClassNameFromGuidEx	SetupDiClassNameFromGuidExA
#define SetupDiCreateDeviceInfo	SetupDiCreateDeviceInfoA
#define SetupDiCreateDeviceInfoListEx	SetupDiCreateDeviceInfoListExA
#define SetupDiCreateDeviceInterface	SetupDiCreateDeviceInterfaceA
#define SetupDiCreateInterfaceDevice	SetupDiCreateDeviceInterfaceA
#define SetupDiCreateDeviceInterfaceRegKey	SetupDiCreateDeviceInterfaceRegKeyA
#define SetupDiCreateInterfaceDeviceRegKey	SetupDiCreateDeviceInterfaceRegKeyA
#define SetupDiCreateDevRegKey	SetupDiCreateDevRegKeyA
#define SetupDiDeleteInterfaceDeviceData	SetupDiDeleteDeviceInterfaceData
#define SetupDiEnumDriverInfo	SetupDiEnumDriverInfoA
#define SetupDiGetActualSectionToInstall	SetupDiGetActualSectionToInstallA
#define SetupDiGetActualSectionToInstallEx	SetupDiGetActualSectionToInstallExA
#define SetupDiGetClassDescription	SetupDiGetClassDescriptionA
#define SetupDiGetClassDescriptionEx	SetupDiGetClassDescriptionExA
#define SetupDiGetClassDevPropertySheets	SetupDiGetClassDevPropertySheetsA
#define SetupDiGetClassDevs	SetupDiGetClassDevsA
#define SetupDiGetClassDevsEx	SetupDiGetClassDevsExA
#define SetupDiGetClassImageListEx	SetupDiGetClassImageListExA
#define SetupDiGetClassInstallParams	SetupDiGetClassInstallParamsA
#define SetupDiGetClassRegistryProperty	SetupDiGetClassRegistryPropertyA
#define SetupDiGetDeviceInfoListDetail	SetupDiGetDeviceInfoListDetailA
#define SetupDiGetDeviceInstallParams	SetupDiGetDeviceInstallParamsA
#define SetupDiGetDeviceInstanceId	SetupDiGetDeviceInstanceIdA
#define SetupDiGetDeviceInterfaceDetail	SetupDiGetDeviceInterfaceDetailA
#define SetupDiGetInterfaceDeviceDetail	SetupDiGetDeviceInterfaceDetailA
#define SetupDiGetDeviceRegistryProperty	SetupDiGetDeviceRegistryPropertyA
#define SetupDiGetDriverInfoDetail	SetupDiGetDriverInfoDetailA
#define SetupDiGetDriverInstallParams	SetupDiGetDriverInstallParamsA
#define SetupDiGetHwProfileFriendlyName	SetupDiGetHwProfileFriendlyNameA
#define SetupDiGetHwProfileFriendlyNameEx	SetupDiGetHwProfileFriendlyNameExA
#define SetupDiGetHwProfileListEx	SetupDiGetHwProfileListExA
#define SetupDiGetINFClass	SetupDiGetINFClassA
#define SetupDiGetSelectedDriver	SetupDiGetSelectedDriverA
#define SetupDiInstallClass	SetupDiInstallClassA
#define SetupDiInstallClassEx	SetupDiInstallClassExA
#define SetupDiOpenClassRegKeyEx	SetupDiOpenClassRegKeyExA
#define SetupDiOpenDeviceInfo	SetupDiOpenDeviceInfoA
#define SetupDiOpenDeviceInterface	SetupDiOpenDeviceInterfaceA
#define SetupDiOpenInterfaceDevice	SetupDiOpenDeviceInterfaceA
#define SetupDiSetClassInstallParams	SetupDiSetClassInstallParamsA
#define SetupDiSetClassRegistryProperty	SetupDiSetClassRegistryPropertyA
#define SetupDiSetDeviceInstallParams	SetupDiSetDeviceInstallParamsA
#define SetupDiSetDeviceRegistryProperty	SetupDiSetDeviceRegistryPropertyA
#define SetupDiSetDriverInstallParams	SetupDiSetDriverInstallParamsA
#define SetupDiSetSelectedDriver	SetupDiSetSelectedDriverA
#define SetupDuplicateDiskSpaceList	SetupDuplicateDiskSpaceListA
#define SetupFindFirstLine	SetupFindFirstLineA
#define SetupFindNextMatchLine	SetupFindNextMatchLineA
#define SetupFreeSourceList	SetupFreeSourceListA
#define SetupGetBackupInformation	SetupGetBackupInformationA
#define SetupGetFileCompressionInfo	SetupGetFileCompressionInfoA
#define SetupGetFileCompressionInfoEx	SetupGetFileCompressionInfoExA
#define SetupGetInfFileList	SetupGetInfFileListA
#define SetupGetInfInformation	SetupGetInfInformationA
#define SetupGetLineByIndex	SetupGetLineByIndexA
#define SetupGetLineCount	SetupGetLineCountA
#define SetupGetLineText	SetupGetLineTextA
#define SetupGetMultiSzField	SetupGetMultiSzFieldA
#define SetupGetSourceFileLocation	SetupGetSourceFileLocationA
#define SetupGetSourceFileSize	SetupGetSourceFileSizeA
#define SetupGetSourceInfo	SetupGetSourceInfoA
#define SetupGetStringField	SetupGetStringFieldA
#define SetupGetTargetPath	SetupGetTargetPathA
#define SetupInitializeFileLog	SetupInitializeFileLogA
#define SetupInstallFile	SetupInstallFileA
#define SetupInstallFileEx	SetupInstallFileExA
#define SetupInstallFilesFromInfSection	SetupInstallFilesFromInfSectionA
#define SetupInstallFromInfSection	SetupInstallFromInfSectionA
#define SetupInstallServicesFromInfSection	SetupInstallServicesFromInfSectionA
#define SetupInstallServicesFromInfSectionEx	SetupInstallServicesFromInfSectionExA
#define SetupIterateCabinet	SetupIterateCabinetA
#define SetupLogError	SetupLogErrorA
#define SetupLogFile	SetupLogFileA
#define SetupOpenAppendInfFile	SetupOpenAppendInfFileA
#define SetupOpenInfFile	SetupOpenInfFileA
#define SetupPromptForDisk	SetupPromptForDiskA
#define SetupQueryDrivesInDiskSpaceList	SetupQueryDrivesInDiskSpaceListA
#define SetupQueryFileLog	SetupQueryFileLogA
#define SetupQueryInfFileInformation	SetupQueryInfFileInformationA
#define SetupQueryInfOriginalFileInformation	SetupQueryInfOriginalFileInformationA
#define SetupQueryInfVersionInformation	SetupQueryInfVersionInformationA
#define SetupQuerySourceList	SetupQuerySourceListA
#define SetupQuerySpaceRequiredOnDrive	SetupQuerySpaceRequiredOnDriveA
#define SetupQueueCopy	SetupQueueCopyA
#define SetupQueueCopyIndirect	SetupQueueCopyIndirectA
#define SetupQueueCopySection	SetupQueueCopySectionA
#define SetupQueueDefaultCopy	SetupQueueDefaultCopyA
#define SetupQueueDelete	SetupQueueDeleteA
#define SetupQueueDeleteSection	SetupQueueDeleteSectionA
#define SetupQueueRename	SetupQueueRenameA
#define SetupQueueRenameSection	SetupQueueRenameSectionA
#define SetupRemoveFileLogEntry	SetupRemoveFileLogEntryA
#define SetupRemoveFromDiskSpaceList	SetupRemoveFromDiskSpaceListA
#define SetupRemoveFromSourceList	SetupRemoveFromSourceListA
#define SetupRemoveInstallSectionFromDiskSpaceList	SetupRemoveInstallSectionFromDiskSpaceListA
#define SetupRemoveSectionFromDiskSpaceList	SetupRemoveSectionFromDiskSpaceListA
#define SetupRenameError	SetupRenameErrorA
#define SetupScanFileQueue	SetupScanFileQueueA
#define SetupSetDirectoryId	SetupSetDirectoryIdA
#define SetupSetDirectoryIdEx	SetupSetDirectoryIdExA
#define SetupSetFileQueueAlternatePlatform	SetupSetFileQueueAlternatePlatformA
#define SetupSetPlatformPathOverride	SetupSetPlatformPathOverrideA
#define SetupSetSourceList	SetupSetSourceListA
#define SetupUninstallOEMInf    SetupUninstallOEMInfA
#endif	/* UNICODE */

#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#include <poppack.h>
#endif /* _SETUPAPI_H_ */

