
;
; IMPORTANT: When a new language is added, all messages in this file need to be
; either translated or at least duplicated for the new language.
; This is a new requirement by MS mc.exe
; To do this, start with a regex replace:
; - In VS IDE: "Language=English\r\n(?<String>(?:[^\.].*\r\n)*\.\r\n)" -> "Language=English\r\n${String}Language=MyLanguage\r\n${String}"
;

MessageIdTypedef=ULONG

SeverityNames=(Success=0x0:STATUS_SEVERITY_SUCCESS
               Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
               Warning=0x2:STATUS_SEVERITY_WARNING
               Error=0x3:STATUS_SEVERITY_ERROR
              )

FacilityNames=(System=0x0:FACILITY_SYSTEM
               ITF=0x4:FACILITY_ITF
               WIN32=0x7:FACILITY_GENERAL
              )

LanguageNames=(English=0x409:MSG00409
               Russian=0x419:MSG00419
               Polish=0x415:MSG00415
               Romanian=0x418:MSG00418)

MessageId=0
Severity=Success
Facility=System
SymbolicName=ERROR_SUCCESS
Language=English
ERROR_SUCCESS - The operation completed successfully.
.
Language=Russian
ERROR_SUCCESS - Операция успешно завершена.
.
Language=Polish
ERROR_SUCCESS - Operacja ukończona pomyślnie.
.
Language=Romanian
ERROR_SUCCESS - Operația a fost finalizată cu succes.
.

MessageId=1
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FUNCTION
Language=English
ERROR_INVALID_FUNCTION - Incorrect function.
.
Language=Russian
ERROR_INVALID_FUNCTION - Неверная функция.
.
Language=Polish
ERROR_INVALID_FUNCTION - Niepoprawna funkcja.
.
Language=Romanian
ERROR_INVALID_FUNCTION - Funcție eronată.
.

MessageId=2
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_NOT_FOUND
Language=English
ERROR_FILE_NOT_FOUND - The system cannot find the file specified.
.
Language=Russian
ERROR_FILE_NOT_FOUND - Не удается найти указанный файл.
.
Language=Polish
ERROR_FILE_NOT_FOUND - Nie można odnaleźć określonego pliku.
.
Language=Romanian
ERROR_FILE_NOT_FOUND - Fișierul specificat nu poate fi găsit.
.

MessageId=3
Severity=Success
Facility=System
SymbolicName=ERROR_PATH_NOT_FOUND
Language=English
ERROR_PATH_NOT_FOUND - The system cannot find the path specified.
.
Language=Russian
ERROR_PATH_NOT_FOUND - Системе не удается найти указанный путь.
.
Language=Polish
ERROR_PATH_NOT_FOUND - System nie może odnaleźć określonej ścieżki.
.
Language=Romanian
ERROR_PATH_NOT_FOUND - Calea specificată nu a fost găsită.
.

MessageId=4
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_OPEN_FILES
Language=English
ERROR_TOO_MANY_OPEN_FILES - The system cannot open the file.
.
Language=Russian
ERROR_TOO_MANY_OPEN_FILES - Системе не удается открыть файл.
.
Language=Polish
ERROR_TOO_MANY_OPEN_FILES - System nie może otworzyć tego pliku.
.
Language=Romanian
ERROR_TOO_MANY_OPEN_FILES - Fișierul nu poate fi deschis.
.

MessageId=5
Severity=Success
Facility=System
SymbolicName=ERROR_ACCESS_DENIED
Language=English
ERROR_ACCESS_DENIED - Access is denied.
.
Language=Russian
ERROR_ACCESS_DENIED - Отказано в доступе.
.
Language=Polish
ERROR_ACCESS_DENIED - Odmowa dostępu.
.
Language=Romanian
ERROR_ACCESS_DENIED - Acces respins.
.

MessageId=6
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_HANDLE
Language=English
ERROR_INVALID_HANDLE - The handle is invalid.
.
Language=Russian
ERROR_INVALID_HANDLE - Неверный дескриптор.
.
Language=Polish
ERROR_INVALID_HANDLE - Nieprawidłowe dojście.
.
Language=Romanian
ERROR_INVALID_HANDLE - Identificator de gestiune eronat.
.

MessageId=7
Severity=Success
Facility=System
SymbolicName=ERROR_ARENA_TRASHED
Language=English
ERROR_ARENA_TRASHED - The storage control blocks were destroyed.
.
Language=Russian
ERROR_ARENA_TRASHED - Повреждены управляющие блоки памяти.
.
Language=Polish
ERROR_ARENA_TRASHED - Bloki kontroli magazynu zostały zniszczone.
.
Language=Romanian
ERROR_ARENA_TRASHED - Blocurile de control al stocării au fost deteriorate.
.

MessageId=8
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_ENOUGH_MEMORY
Language=English
ERROR_NOT_ENOUGH_MEMORY - Not enough storage is available to process this command.
.
Language=Russian
ERROR_NOT_ENOUGH_MEMORY - Недостаточно памяти для обработки команды.
.
Language=Polish
ERROR_NOT_ENOUGH_MEMORY - W magazynie brak miejsca dla wykonania tego polecenia.
.
Language=Romanian
ERROR_NOT_ENOUGH_MEMORY - Spațiul de stocare disponibil este insuficient pentru procesarea acestei comanzi.
.

MessageId=9
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_BLOCK
Language=English
ERROR_INVALID_BLOCK - The storage control block address is invalid.
.
Language=Russian
ERROR_INVALID_BLOCK - Неверный адрес управляющего блока памяти.
.
Language=Polish
ERROR_INVALID_BLOCK - Adres bloku kontroli magazynu jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_BLOCK - Adresa blocului de control al stocării nu este validă.
.

MessageId=10
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_ENVIRONMENT
Language=English
ERROR_BAD_ENVIRONMENT - The environment is incorrect.
.
Language=Russian
ERROR_BAD_ENVIRONMENT - Недопустимая среда.
.
Language=Polish
ERROR_BAD_ENVIRONMENT - Środowisko jest niepoprawne.
.
Language=Romanian
ERROR_BAD_ENVIRONMENT - Mediul current nu corespunde.
.

MessageId=11
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_FORMAT
Language=English
ERROR_BAD_FORMAT - An attempt was made to load a program with an incorrect format.
.
Language=Russian
ERROR_BAD_FORMAT - Попытка запустить программу с недопустимым форматом.
.
Language=Polish
ERROR_BAD_FORMAT - Próbowano załadować program w niepoprawnym formacie.
.
Language=Romanian
ERROR_BAD_FORMAT - Program cu format necorespunzător.
.

MessageId=12
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ACCESS
Language=English
ERROR_INVALID_ACCESS - The access code is invalid.
.
Language=Russian
ERROR_INVALID_ACCESS - Неверный код доступа.
.
Language=Polish
ERROR_INVALID_ACCESS - Nieprawidłowy kod dostępu.
.
Language=Romanian
ERROR_INVALID_ACCESS - Codul de acces nu este valid.
.

MessageId=13
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DATA
Language=English
ERROR_INVALID_DATA - The data is invalid.
.
Language=Russian
ERROR_INVALID_DATA - Недопустимые данные.
.
Language=Polish
ERROR_INVALID_DATA - Nieprawidłowe dane.
.
Language=Romanian
ERROR_INVALID_DATA - Date nevalide.
.

MessageId=14
Severity=Success
Facility=System
SymbolicName=ERROR_OUTOFMEMORY
Language=English
ERROR_OUTOFMEMORY - Not enough storage is available to complete this operation.
.
Language=Russian
ERROR_OUTOFMEMORY - Недостаточно памяти для завершения операции.
.
Language=Polish
ERROR_OUTOFMEMORY - W magazynie brak miejsca dla wykonania tej operacji.
.
Language=Romanian
ERROR_OUTOFMEMORY - Spațiul de stocare disponibil este insuficient pentru completarea acestei operații.
.

MessageId=15
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DRIVE
Language=English
ERROR_INVALID_DRIVE - The system cannot find the drive specified.
.
Language=Russian
ERROR_INVALID_DRIVE - Система не может найти указанное устройство.
.
Language=Polish
ERROR_INVALID_DRIVE - Nie można odnaleźć dysku.
.
Language=Romanian
ERROR_INVALID_DRIVE - Unitatea de stocare specificată a fost găsită.
.

MessageId=16
Severity=Success
Facility=System
SymbolicName=ERROR_CURRENT_DIRECTORY
Language=English
ERROR_CURRENT_DIRECTORY - The directory cannot be removed.
.
Language=Russian
ERROR_CURRENT_DIRECTORY - Этот каталог не может быть удален.
.
Language=Polish
ERROR_CURRENT_DIRECTORY - Nie można usunąć katalogu.
.
Language=Romanian
ERROR_CURRENT_DIRECTORY - Directorul nu poate fi eliminat.
.

MessageId=17
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SAME_DEVICE
Language=English
ERROR_NOT_SAME_DEVICE - The system cannot move the file to a different disk drive.
.
Language=Russian
ERROR_NOT_SAME_DEVICE - Система не может переместить файл на другое дисковое устройство.
.
Language=Polish
ERROR_NOT_SAME_DEVICE - Nie można przenieść pliku na inny dysk.
.
Language=Romanian
ERROR_NOT_SAME_DEVICE - Fișierul nu poate fi mutat pe o altă unitate de stocare.
.

MessageId=18
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_FILES
Language=English
ERROR_NO_MORE_FILES - There are no more files.
.
Language=Russian
ERROR_NO_MORE_FILES - Файлов больше нет.
.
Language=Polish
ERROR_NO_MORE_FILES - Brak dalszych plików.
.
Language=Romanian
ERROR_NOT_SAME_DEVICE - Fișierul nu poate fi mutat pe o altă unitate de stocare.
.

MessageId=19
Severity=Success
Facility=System
SymbolicName=ERROR_WRITE_PROTECT
Language=English
ERROR_WRITE_PROTECT - The media is write protected.
.
Language=Russian
ERROR_WRITE_PROTECT - Носитель защищен от записи.
.
Language=Polish
ERROR_WRITE_PROTECT - Nośnik jest zabezpieczony przed zapisem.
.
Language=Romanian
ERROR_WRITE_PROTECT - Mediul de stocare este protejat la scriere.
.

MessageId=20
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_UNIT
Language=English
ERROR_BAD_UNIT - The system cannot find the device specified.
.
Language=Russian
ERROR_BAD_UNIT - Система не может найти указанное устройство.
.
Language=Polish
ERROR_BAD_UNIT - Nie można odnaleźć urządzenia.
.
Language=Romanian
ERROR_BAD_UNIT - Dispozitivul specificat a fost găsit.
.

MessageId=21
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_READY
Language=English
ERROR_NOT_READY - The device is not ready.
.
Language=Russian
ERROR_NOT_READY - Устройство не готово.
.
Language=Polish
ERROR_NOT_READY - Urządzenie nie jest gotowe.
.
Language=Romanian
ERROR_NOT_READY - Dispozitivul nu este disponibil.
.

MessageId=22
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_COMMAND
Language=English
ERROR_BAD_COMMAND - The device does not recognize the command.
.
Language=Russian
ERROR_BAD_COMMAND - Устройство не распознает команду.
.
Language=Polish
ERROR_BAD_COMMAND - Urządzenie nie rozpoznaje polecenia.
.
Language=Romanian
ERROR_BAD_COMMAND - Dispozitivul nu recunoaște comanda.
.

MessageId=23
Severity=Success
Facility=System
SymbolicName=ERROR_CRC
Language=English
ERROR_CRC - Data error (cyclic redundancy check).
.
Language=Russian
ERROR_CRC - Ошибка в данных (циклический код с избыточностью).
.
Language=Polish
ERROR_CRC - Błąd danych (CRC).
.
Language=Romanian
ERROR_CRC - Eroare de date (sumă de control necorespunzătoare).
.

MessageId=24
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_LENGTH
Language=English
ERROR_BAD_LENGTH - The program issued a command but the command length is incorrect.
.
Language=Russian
ERROR_BAD_LENGTH - Программа выдала команду с недопустимой длиной.
.
Language=Polish
ERROR_BAD_LENGTH - Program wydał polecenie, ale długość polecenia jest niepoprawna.
.
Language=Romanian
ERROR_BAD_LENGTH - Comanda emisă de program are o lungime necorespunzătoare.
.

MessageId=25
Severity=Success
Facility=System
SymbolicName=ERROR_SEEK
Language=English
ERROR_SEEK - The drive cannot locate a specific area or track on the disk.
.
Language=Russian
ERROR_SEEK - Дисковое устройство не может обнаружить указанную область или дорожку.
.
Language=Polish
ERROR_SEEK - Nie można odnaleźć na dysku określonego obszaru lub ścieżki.
.
Language=Romanian
ERROR_SEEK - Unitatea de stocare nu poate localiza o anumită zonă sau pistă de pe disc.
.

MessageId=26
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_DOS_DISK
Language=English
ERROR_NOT_DOS_DISK - The specified disk or diskette cannot be accessed.
.
Language=Russian
ERROR_NOT_DOS_DISK - Нет доступа к диску или дискете.
.
Language=Polish
ERROR_NOT_DOS_DISK - Nie można uzyskać dostępu do określonego dysku lub dyskietki.
.
Language=Romanian
ERROR_NOT_DOS_DISK - Discul dur sau flexibil specificat nu poate fi accesat.
.

MessageId=27
Severity=Success
Facility=System
SymbolicName=ERROR_SECTOR_NOT_FOUND
Language=English
ERROR_SECTOR_NOT_FOUND - The drive cannot find the sector requested.
.
Language=Russian
ERROR_SECTOR_NOT_FOUND - Дисковое устройство не может обнаружить указанную область или дорожку.
.
Language=Polish
ERROR_SECTOR_NOT_FOUND - Nie można odnaleźć na dysku żądanego sektora.
.
Language=Romanian
ERROR_SECTOR_NOT_FOUND - Unitatea de stocare nu poate găsi sectorul solicitat.
.

MessageId=28
Severity=Success
Facility=System
SymbolicName=ERROR_OUT_OF_PAPER
Language=English
ERROR_OUT_OF_PAPER - The printer is out of paper.
.
Language=Russian
ERROR_OUT_OF_PAPER - В принтере закончилась бумага.
.
Language=Polish
ERROR_OUT_OF_PAPER - Brak papieru w drukarce.
.
Language=Romanian
ERROR_OUT_OF_PAPER - Imprimanta nu mai are hârtie.
.

MessageId=29
Severity=Success
Facility=System
SymbolicName=ERROR_WRITE_FAULT
Language=English
ERROR_WRITE_FAULT - The system cannot write to the specified device.
.
Language=Russian
ERROR_WRITE_FAULT - Система не может выполнить запись на указанное устройство.
.
Language=Polish
ERROR_WRITE_FAULT - System nie może zapisywać do określonego urządzenia.
.
Language=Romanian
ERROR_OUT_OF_PAPER - Imprimanta nu mai are hârtie.
.

MessageId=30
Severity=Success
Facility=System
SymbolicName=ERROR_READ_FAULT
Language=English
ERROR_READ_FAULT - The system cannot read from the specified device.
.
Language=Russian
ERROR_READ_FAULT - Системе не может выполнить чтение с указанного устройства.
.
Language=Polish
ERROR_READ_FAULT - System nie może czytać z określonego urządzenia.
.
Language=Romanian
ERROR_READ_FAULT - Eșec la citirea de pe dispozitivul specificat.
.

MessageId=31
Severity=Success
Facility=System
SymbolicName=ERROR_GEN_FAILURE
Language=English
ERROR_GEN_FAILURE - A device attached to the system is not functioning.
.
Language=Russian
ERROR_GEN_FAILURE - Устройство, подключенное к системе, не работает.
.
Language=Polish
ERROR_GEN_FAILURE - Urządzenie dołączone do komputera nie działa.
.
Language=Romanian
ERROR_GEN_FAILURE - Dispozitivul atașat nu funcționează.
.

MessageId=32
Severity=Success
Facility=System
SymbolicName=ERROR_SHARING_VIOLATION
Language=English
ERROR_SHARING_VIOLATION - The process cannot access the file because it is being used by another process.
.
Language=Russian
ERROR_SHARING_VIOLATION - Процесс не имеет доступа к файлу, поскольку файл используется другим процессом.
.
Language=Polish
ERROR_SHARING_VIOLATION - Proces nie może uzyskać dostępu do pliku, ponieważ jest on używany przez inny proces.
.
Language=Romanian
ERROR_SHARING_VIOLATION - Fișierul nu poate fi accesat în acest proces deoarece este utilizat într-un alt proces.
.

MessageId=33
Severity=Success
Facility=System
SymbolicName=ERROR_LOCK_VIOLATION
Language=English
ERROR_LOCK_VIOLATION - The process cannot access the file because another process has locked a portion of the file.
.
Language=Russian
ERROR_LOCK_VIOLATION - Процесс не имеет доступа к файлу, поскольку другой процесс заблокировал часть файла.
.
Language=Polish
ERROR_LOCK_VIOLATION - Proces nie może uzyskać dostępu do pliku, ponieważ inny proces zablokował jego część.
.
Language=Romanian
ERROR_LOCK_VIOLATION - Fișierul nu poate fi accesat în acest proces deoarece o porțiune a sa a fost blocată într-un alt proces.
.

MessageId=34
Severity=Success
Facility=System
SymbolicName=ERROR_WRONG_DISK
Language=English
ERROR_WRONG_DISK - The wrong diskette is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1.
.
Language=Russian
ERROR_WRONG_DISK - Вставте другую дискету. Вставьте %2 (серийный номер тома: %3) в дисковод %1.
.
Language=Polish
ERROR_WRONG_DISK - W stacji umieszczono niewłaściwą dyskietkę. Włóż dysk %2 (numer seryjny woluminu: %3) do stacji: %1.
.
Language=Romanian
ERROR_WRONG_DISK - Discul flexibil din unitate nu este necorespunzător. Introduceți %2 (Număr Serial de Volum: %3) în unitatea %1.
.

MessageId=36
Severity=Success
Facility=System
SymbolicName=ERROR_SHARING_BUFFER_EXCEEDED
Language=English
ERROR_SHARING_BUFFER_EXCEEDED - Too many files opened for sharing.
.
Language=Russian
ERROR_SHARING_BUFFER_EXCEEDED - Слишком много файлов открыто для совместного использования.
.
Language=Polish
ERROR_SHARING_BUFFER_EXCEEDED - Za dużo plików otwartych do udostępniania.
.
Language=Romanian
ERROR_SHARING_BUFFER_EXCEEDED - Numărul de fișiere deschise pentru partajare este prea mare.
.

MessageId=38
Severity=Success
Facility=System
SymbolicName=ERROR_HANDLE_EOF
Language=English
ERROR_HANDLE_EOF - Reached the end of the file.
.
Language=Russian
ERROR_HANDLE_EOF - Достигнут конец файла.
.
Language=Polish
ERROR_HANDLE_EOF - Osiągnięto koniec pliku.
.
Language=Romanian
ERROR_HANDLE_EOF - Sfârșitul fișierului a fost atins.
.

MessageId=39
Severity=Success
Facility=System
SymbolicName=ERROR_HANDLE_DISK_FULL
Language=English
ERROR_HANDLE_DISK_FULL - The disk is full.
.
Language=Russian
ERROR_HANDLE_DISK_FULL - Отсутствует место на диске.
.
Language=Polish
ERROR_HANDLE_DISK_FULL - Dysk jest zapełniony.
.
Language=Romanian
ERROR_HANDLE_DISK_FULL - Discul este plin.
.

MessageId=50
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SUPPORTED
Language=English
ERROR_NOT_SUPPORTED - The request is not supported.
.
Language=Russian
ERROR_NOT_SUPPORTED - Запрос не поддерживается.
.
Language=Polish
ERROR_NOT_SUPPORTED - Żądanie nie jest obsługiwane.
.
Language=Romanian
ERROR_NOT_SUPPORTED - Solicitarea nu este acceptată.
.

MessageId=51
Severity=Success
Facility=System
SymbolicName=ERROR_REM_NOT_LIST
Language=English
ERROR_REM_NOT_LIST - ReactOS cannot find the network path. Verify that the network path is correct and the destination computer is not busy or turned off. If ReactOS still cannot find the network path, contact your network administrator.
.
Language=Russian
ERROR_REM_NOT_LIST - Невозможно найти сетевой путь. Убедитесь, что сетевой путь указан верно, а конечный компьютер включен и не занят. Если система вновь не сможет найти путь, обратитесь к сетевому администратору.
.
Language=Polish
ERROR_REM_NOT_LIST - System ReactOS nie może odnaleźć ścieżki sieciowej. Sprawdź, czy ścieżka sieciowa jest poprawna i czy komputer docelowy nie jest zajęty lub wyłączony. Jeśli system ReactOS nadal nie będzie mógł odnaleźć ścieżki sieciowej, skontaktuj się z administratorem sieci.
.
Language=Romanian
ERROR_REM_NOT_LIST - Calea în rețea nu a fost găsită. Asigurați-vă că este corectă și că destinația în rețea este disponibilă fizic. Dacă veți întâmpina această problemă în continuare, contactați administratorul de rețea.
.

MessageId=52
Severity=Success
Facility=System
SymbolicName=ERROR_DUP_NAME
Language=English
ERROR_DUP_NAME - You were not connected because a duplicate name exists on the network. Go to System in the Control Panel to change the computer name and try again.
.
Language=Russian
ERROR_DUP_NAME - Вы не подключены, поскольку такое же имя уже существует в этой сети. Для присоединения к домену откройте компонент панели управления "Система", измените имя компьютера и повторите попытку. Для присоединения к рабочей группе выберите другое имя рабочей группы.
.
Language=Polish
ERROR_DUP_NAME - Połączenie nie zostało nawiązane, ponieważ w sieci istnieje duplikat nazwy. Jeśli przyłączasz się do domeny, przejdź do apletu System w Panelu sterowania, aby zmienić nazwę komputera, i spróbuj ponownie. Jeśli przyłączasz się do grupy roboczej, wybierz inną nazwę grupy.
.
Language=Romanian
ERROR_DUP_NAME - Nu poate fi realizată o conexiune deoarece un nume duplicat există deja în rețea. Puteți schimba numele calculatorului din Proprietăți pentru Sistem (în Panoul de Control) înainte de a reîncerca.
.

MessageId=53
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_NETPATH
Language=English
ERROR_BAD_NETPATH - The network path was not found.
.
Language=Russian
ERROR_BAD_NETPATH - Не найден сетевой путь.
.
Language=Polish
ERROR_BAD_NETPATH - Nie można odnaleźć ścieżki sieciowej.
.
Language=Romanian
ERROR_BAD_NETPATH - Calea în rețea a fost găsită.
.

MessageId=54
Severity=Success
Facility=System
SymbolicName=ERROR_NETWORK_BUSY
Language=English
ERROR_NETWORK_BUSY - The network is busy.
.
Language=Russian
ERROR_NETWORK_BUSY - Сеть занята.
.
Language=Polish
ERROR_NETWORK_BUSY - Sieć jest zajęta.
.
Language=Romanian
ERROR_NETWORK_BUSY - Rețeaua este ocupată.
.

MessageId=55
Severity=Success
Facility=System
SymbolicName=ERROR_DEV_NOT_EXIST
Language=English
ERROR_DEV_NOT_EXIST - The specified network resource or device is no longer available.
.
Language=Russian
ERROR_DEV_NOT_EXIST - Сетевой ресурс или устройство более недоступно.
.
Language=Polish
ERROR_DEV_NOT_EXIST - Określone zasoby sieciowe lub urządzenie są już niedostępne.
.
Language=Romanian
ERROR_DEV_NOT_EXIST - Dispozitivul specificat sau resursa în rețea nu mai este disponibilă.
.

MessageId=56
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_CMDS
Language=English
ERROR_TOO_MANY_CMDS - The network BIOS command limit has been reached.
.
Language=Russian
ERROR_TOO_MANY_CMDS - Достигнут предел числа команд NetBIOS.
.
Language=Polish
ERROR_TOO_MANY_CMDS - Osiągnięto limit poleceń systemu BIOS dla sieci.
.
Language=Romanian
ERROR_TOO_MANY_CMDS - Limita pentru comanda BIOS de rețea a fost atinsă.
.

MessageId=57
Severity=Success
Facility=System
SymbolicName=ERROR_ADAP_HDW_ERR
Language=English
ERROR_ADAP_HDW_ERR - A network adapter hardware error occurred.
.
Language=Russian
ERROR_ADAP_HDW_ERR - Аппаратная ошибка сетевой платы.
.
Language=Polish
ERROR_ADAP_HDW_ERR - Wystąpił błąd sprzętowy karty sieciowej.
.
Language=Romanian
ERROR_ADAP_HDW_ERR - Dispozitivul de rețea a raportat o eroare.
.

MessageId=58
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_NET_RESP
Language=English
ERROR_BAD_NET_RESP - The specified server cannot perform the requested operation.
.
Language=Russian
ERROR_BAD_NET_RESP - Указанный сервер не может выполнить требуемую операцию.
.
Language=Polish
ERROR_BAD_NET_RESP - Określony serwer nie może wykonać żądanej operacji.
.
Language=Romanian
ERROR_BAD_NET_RESP - Serverul specificat nu poate îndeplini operația solicitată.
.

MessageId=59
Severity=Success
Facility=System
SymbolicName=ERROR_UNEXP_NET_ERR
Language=English
ERROR_UNEXP_NET_ERR - An unexpected network error occurred.
.
Language=Russian
ERROR_UNEXP_NET_ERR - Непредвиденная сетевая ошибка.
.
Language=Polish
ERROR_UNEXP_NET_ERR - Wystąpił nieoczekiwany błąd sieciowy.
.
Language=Romanian
ERROR_UNEXP_NET_ERR - Eroare neașteptată de rețea.
.

MessageId=60
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_REM_ADAP
Language=English
ERROR_BAD_REM_ADAP - The remote adapter is not compatible.
.
Language=Russian
ERROR_BAD_REM_ADAP - Несовместимый удаленный контроллер.
.
Language=Polish
ERROR_BAD_REM_ADAP - Zdalna karta sieciowa jest niezgodna.
.
Language=Romanian
ERROR_BAD_REM_ADAP - Adaptor de rețea necompatibil.
.

MessageId=61
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTQ_FULL
Language=English
ERROR_PRINTQ_FULL - The printer queue is full.
.
Language=Russian
ERROR_PRINTQ_FULL - Очередь печати переполнена.
.
Language=Polish
ERROR_PRINTQ_FULL - Kolejka wydruku jest zapełniona.
.
Language=Romanian
ERROR_PRINTQ_FULL - Lista comenzilor de imprimare este plină.
.

MessageId=62
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SPOOL_SPACE
Language=English
ERROR_NO_SPOOL_SPACE - Space to store the file waiting to be printed is not available on the server.
.
Language=Russian
ERROR_NO_SPOOL_SPACE - На сервере нет места для хранения ожидающего печати файла.
.
Language=Polish
ERROR_NO_SPOOL_SPACE - Na serwerze nie ma miejsca na przechowywanie pliku oczekującego na wydruk.
.
Language=Romanian
ERROR_NO_SPOOL_SPACE - Serviciul de imprimare nu mai dispune de spațiu pentru fișierele în așteptare.
.

MessageId=63
Severity=Success
Facility=System
SymbolicName=ERROR_PRINT_CANCELLED
Language=English
ERROR_PRINT_CANCELLED - Your file waiting to be printed was deleted.
.
Language=Russian
ERROR_PRINT_CANCELLED - Ваш файл, находившийся в очереди вывода на печать, был удален.
.
Language=Polish
ERROR_PRINT_CANCELLED - Plik oczekujący na wydruk został usunięty.
.
Language=Romanian
ERROR_PRINT_CANCELLED - Fișierul dvs. în așteptarea imprimării a fost eliminat.
.

MessageId=64
Severity=Success
Facility=System
SymbolicName=ERROR_NETNAME_DELETED
Language=English
ERROR_NETNAME_DELETED - The specified network name is no longer available.
.
Language=Russian
ERROR_NETNAME_DELETED - Указанное сетевое имя более недоступно.
.
Language=Polish
ERROR_NETNAME_DELETED - Określona nazwa sieciowa już jest niedostępna.
.
Language=Romanian
ERROR_NETNAME_DELETED - Numele de rețea specificat nu mai este disponibil.
.

MessageId=65
Severity=Success
Facility=System
SymbolicName=ERROR_NETWORK_ACCESS_DENIED
Language=English
ERROR_NETWORK_ACCESS_DENIED - Network access is denied.
.
Language=Russian
ERROR_NETWORK_ACCESS_DENIED - Нет доступа к сети.
.
Language=Polish
ERROR_NETWORK_ACCESS_DENIED - Odmowa dostępu do sieci.
.
Language=Romanian
ERROR_NETWORK_ACCESS_DENIED - Accesul la rețea este respins.
.

MessageId=66
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DEV_TYPE
Language=English
ERROR_BAD_DEV_TYPE - The network resource type is not correct.
.
Language=Russian
ERROR_BAD_DEV_TYPE - Неверно указан тип сетевого ресурса.
.
Language=Polish
ERROR_BAD_DEV_TYPE - Typ zasobu sieciowego jest niepoprawny.
.
Language=Romanian
ERROR_BAD_DEV_TYPE - Tipul resursei de rețea nu este corespunzător.
.

MessageId=67
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_NET_NAME
Language=English
ERROR_BAD_NET_NAME - The network name cannot be found.
.
Language=Russian
ERROR_BAD_NET_NAME - Не найдено сетевое имя.
.
Language=Polish
ERROR_BAD_NET_NAME - Nie można odnaleźć nazwy sieciowej.
.
Language=Romanian
ERROR_BAD_NET_NAME - Numele de rețea nu este găsit.
.

MessageId=68
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_NAMES
Language=English
ERROR_TOO_MANY_NAMES - The name limit for the local computer network adapter card was exceeded.
.
Language=Russian
ERROR_TOO_MANY_NAMES - Превышен предел числа имен для сетевого адаптера локального компьютера.
.
Language=Polish
ERROR_TOO_MANY_NAMES - Przekroczono ograniczenie nazwy dla karty sieci lokalnej komputera.
.
Language=Romanian
ERROR_TOO_MANY_NAMES - Limita pentru numele plăcii adaptorului de rețea al calculatorului local a fost depășită.
.

MessageId=69
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_SESS
Language=English
ERROR_TOO_MANY_SESS - The network BIOS session limit was exceeded.
.
Language=Russian
ERROR_TOO_MANY_SESS - Превышен предел по числу сеансов NetBIOS.
.
Language=Polish
ERROR_TOO_MANY_SESS - Przekroczono limit sesji systemu BIOS dla sieci.
.
Language=Romanian
ERROR_TOO_MANY_SESS - Limita pentru sesiunea BIOS de rețea a fost depășită.
.

MessageId=70
Severity=Success
Facility=System
SymbolicName=ERROR_SHARING_PAUSED
Language=English
ERROR_SHARING_PAUSED - The remote server has been paused or is in the process of being started.
.
Language=Russian
ERROR_SHARING_PAUSED - Сервер сети был остановлен или находится в процессе запуска.
.
Language=Polish
ERROR_SHARING_PAUSED - Zdalny serwer przerwał pracę lub jest w trakcie procesu uruchamiania.
.
Language=Romanian
ERROR_SHARING_PAUSED - Serverul accesat la distanță fie este în pauză fie este în curs de repornire.
.

MessageId=71
Severity=Success
Facility=System
SymbolicName=ERROR_REQ_NOT_ACCEP
Language=English
ERROR_REQ_NOT_ACCEP - No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept.
.
Language=Russian
ERROR_REQ_NOT_ACCEP - Дополнительные подключения к этому удаленному компьютеру сейчас невозможны, так как их число достигло предела.
.
Language=Polish
ERROR_REQ_NOT_ACCEP - Do tego komputera zdalnego nie można obecnie uzyskać więcej połączeń, ponieważ istnieje już maksymalna akceptowalna liczba połączeń.
.
Language=Romanian
ERROR_REQ_NOT_ACCEP - Calculatorul accesat la distanță nu acceptă mai multe conexiuni deoarece limita în acest sens a fost deja atinsă.
.

MessageId=72
Severity=Success
Facility=System
SymbolicName=ERROR_REDIR_PAUSED
Language=English
ERROR_REDIR_PAUSED - The specified printer or disk device has been paused.
.
Language=Russian
ERROR_REDIR_PAUSED - Работа указанного принтера или дискового накопителя была остановлена.
.
Language=Polish
ERROR_REDIR_PAUSED - Określona drukarka lub urządzenie przerwały pracę.
.
Language=Romanian
ERROR_REDIR_PAUSED - Dispozitivul de disc sau imprimanta specificată este în pauză.
.

MessageId=80
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_EXISTS
Language=English
ERROR_FILE_EXISTS - The file exists.
.
Language=Russian
ERROR_FILE_EXISTS - Файл существует.
.
Language=Polish
ERROR_FILE_EXISTS - Plik istnieje.
.
Language=Romanian
ERROR_FILE_EXISTS - Fișierul există.
.

MessageId=82
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_MAKE
Language=English
ERROR_CANNOT_MAKE - The directory or file cannot be created.
.
Language=Russian
ERROR_CANNOT_MAKE - Не удается создать файл или папку.
.
Language=Polish
ERROR_CANNOT_MAKE - Nie można utworzyć katalogu lub pliku.
.
Language=Romanian
ERROR_CANNOT_MAKE - Fișierul sau directorul dat nu poate fi creat.
.

MessageId=83
Severity=Success
Facility=System
SymbolicName=ERROR_FAIL_I24
Language=English
ERROR_FAIL_I24 - Fail on INT 24.
.
Language=Russian
ERROR_FAIL_I24 - Сбой прерывания INT 24.
.
Language=Polish
ERROR_FAIL_I24 - Błąd przerwania INT 24.
.
Language=Romanian
ERROR_FAIL_I24 - Eroare la INT 24.
.

MessageId=84
Severity=Success
Facility=System
SymbolicName=ERROR_OUT_OF_STRUCTURES
Language=English
ERROR_OUT_OF_STRUCTURES - Storage to process this request is not available.
.
Language=Russian
ERROR_OUT_OF_STRUCTURES - Недостаточно памяти для обработки запроса.
.
Language=Polish
ERROR_OUT_OF_STRUCTURES - Pamięć do przetworzenia tego żądania jest niedostępna.
.
Language=Romanian
ERROR_OUT_OF_STRUCTURES - Necesarul de spațiu pentru această solicitare nu este disponibil.
.

MessageId=85
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_ASSIGNED
Language=English
ERROR_ALREADY_ASSIGNED - The local device name is already in use.
.
Language=Russian
ERROR_ALREADY_ASSIGNED - Имя локального устройства уже используется.
.
Language=Polish
ERROR_ALREADY_ASSIGNED - Nazwa lokalnego urządzenia jest już w użyciu.
.
Language=Romanian
ERROR_ALREADY_ASSIGNED - Acest nume de dispozitiv local este deja în uz.
.

MessageId=86
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PASSWORD
Language=English
ERROR_INVALID_PASSWORD - The specified network password is not correct.
.
Language=Russian
ERROR_INVALID_PASSWORD - Сетевой пароль указан неверно.
.
Language=Polish
ERROR_INVALID_PASSWORD - Określone hasło sieciowe jest niepoprawne.
.
Language=Romanian
ERROR_INVALID_PASSWORD - Parola specificată de rețea nu este corectă.
.

MessageId=87
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PARAMETER
Language=English
ERROR_INVALID_PARAMETER - The parameter is incorrect.
.
Language=Russian
ERROR_INVALID_PARAMETER - Параметр задан неверно.
.
Language=Polish
ERROR_INVALID_PARAMETER - Parametr jest niepoprawny.
.
Language=Romanian
ERROR_INVALID_PARAMETER - Parametru necorespunzător.
.

MessageId=88
Severity=Success
Facility=System
SymbolicName=ERROR_NET_WRITE_FAULT
Language=English
ERROR_NET_WRITE_FAULT - A write fault occurred on the network.
.
Language=Russian
ERROR_NET_WRITE_FAULT - Ошибка записи в сети.
.
Language=Polish
ERROR_NET_WRITE_FAULT - Wystąpił błąd zapisu w sieci.
.
Language=Romanian
ERROR_NET_WRITE_FAULT - Eroare de scriere în rețea.
.

MessageId=89
Severity=Success
Facility=System
SymbolicName=ERROR_NO_PROC_SLOTS
Language=English
ERROR_NO_PROC_SLOTS - The system cannot start another process at this time.
.
Language=Russian
ERROR_NO_PROC_SLOTS - В настоящее время системе не удается запустить другой процесс.
.
Language=Polish
ERROR_NO_PROC_SLOTS - System nie może teraz uruchomić innego procesu.
.
Language=Romanian
ERROR_NO_PROC_SLOTS - La moment în sistem nu pot fi lansate noi procese.
.

MessageId=100
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_SEMAPHORES
Language=English
ERROR_TOO_MANY_SEMAPHORES - Cannot create another system semaphore.
.
Language=Russian
ERROR_TOO_MANY_SEMAPHORES - Не удается создать еще один системный семафор.
.
Language=Polish
ERROR_TOO_MANY_SEMAPHORES - Nie można utworzyć innego semafora systemowego.
.
Language=Romanian
ERROR_TOO_MANY_SEMAPHORES - Un semafor nou de sistem nu poate fi creat.
.

MessageId=101
Severity=Success
Facility=System
SymbolicName=ERROR_EXCL_SEM_ALREADY_OWNED
Language=English
ERROR_EXCL_SEM_ALREADY_OWNED - The exclusive semaphore is owned by another process.
.
Language=Russian
ERROR_EXCL_SEM_ALREADY_OWNED - Семафор эксклюзивного доступа занят другим процессом.
.
Language=Polish
ERROR_EXCL_SEM_ALREADY_OWNED - Semafor wyłączny jest własnością innego procesu.
.
Language=Romanian
ERROR_EXCL_SEM_ALREADY_OWNED - Semaforul exclusiv aparține unui alt proces.
.

MessageId=102
Severity=Success
Facility=System
SymbolicName=ERROR_SEM_IS_SET
Language=English
ERROR_SEM_IS_SET - The semaphore is set and cannot be closed.
.
Language=Russian
ERROR_SEM_IS_SET - Семафор установлен и не может быть закрыт.
.
Language=Polish
ERROR_SEM_IS_SET - Semafor jest ustawiony i nie można go zamknąć.
.
Language=Romanian
ERROR_SEM_IS_SET - Semaforul este activ și nu poate fi închis.
.

MessageId=103
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_SEM_REQUESTS
Language=English
ERROR_TOO_MANY_SEM_REQUESTS - The semaphore cannot be set again.
.
Language=Russian
ERROR_TOO_MANY_SEM_REQUESTS - Семафор не может быть установлен повторно.
.
Language=Polish
ERROR_TOO_MANY_SEM_REQUESTS - Nie można ponownie zamknąć semafora.
.
Language=Romanian
ERROR_TOO_MANY_SEM_REQUESTS - Semaforul nu poate fi reactivat.
.

MessageId=104
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_AT_INTERRUPT_TIME
Language=English
ERROR_INVALID_AT_INTERRUPT_TIME - Cannot request exclusive semaphores at interrupt time.
.
Language=Russian
ERROR_INVALID_AT_INTERRUPT_TIME - Запросы к семафорам эксклюзивного доступа на время выполнения прерываний не допускаются.
.
Language=Polish
ERROR_INVALID_AT_INTERRUPT_TIME - Nie można żądać semaforów wyłącznych w czasie przerwania.
.
Language=Romanian
ERROR_INVALID_AT_INTERRUPT_TIME - Cererea de acces exclusiv la semafoare nu este permisă în timpul unei întreruperi.
.

MessageId=105
Severity=Success
Facility=System
SymbolicName=ERROR_SEM_OWNER_DIED
Language=English
ERROR_SEM_OWNER_DIED - The previous ownership of this semaphore has ended.
.
Language=Russian
ERROR_SEM_OWNER_DIED - Этот семафор более не принадлежит использовавшему его процессу.
.
Language=Polish
ERROR_SEM_OWNER_DIED - Poprzednia przynależność tego semafora skończyła się.
.
Language=Romanian
ERROR_SEM_OWNER_DIED - Apartenența acestui semafor la procesul său a luat sfârșit.
.

MessageId=106
Severity=Success
Facility=System
SymbolicName=ERROR_SEM_USER_LIMIT
Language=English
ERROR_SEM_USER_LIMIT - Insert the diskette for drive %1.
.
Language=Russian
ERROR_SEM_USER_LIMIT - Вставте дискету в дисковод %1.
.
Language=Polish
ERROR_SEM_USER_LIMIT - Włóż dyskietkę do stacji dysków %1.
.
Language=Romanian
ERROR_SEM_USER_LIMIT - Introduceți discul flexibil pentru unitatea %1.
.

MessageId=107
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_CHANGE
Language=English
ERROR_DISK_CHANGE - The program stopped because an alternate diskette was not inserted.
.
Language=Russian
ERROR_DISK_CHANGE - Программа была остановлена, так как нужный диск вставлен не был.
.
Language=Polish
ERROR_DISK_CHANGE - Program przestał działać, ponieważ nie włożono innej dyskietki.
.
Language=Romanian
ERROR_DISK_CHANGE - Programul a fost oprit deoarece nu a fost introdus un disc flexibil alternativ.
.

MessageId=108
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVE_LOCKED
Language=English
ERROR_DRIVE_LOCKED - The disk is in use or locked by another process.
.
Language=Russian
ERROR_DRIVE_LOCKED - Диск занят или заблокирован другим процессом.
.
Language=Polish
ERROR_DRIVE_LOCKED - Dysk jest w użyciu lub zablokowany przez inny proces.
.
Language=Romanian
ERROR_DRIVE_LOCKED - Discul este în uz sau este blocat de un alt proces.
.

MessageId=109
Severity=Success
Facility=System
SymbolicName=ERROR_BROKEN_PIPE
Language=English
ERROR_BROKEN_PIPE - The pipe has been ended.
.
Language=Russian
ERROR_BROKEN_PIPE - Канал был закрыт.
.
Language=Polish
ERROR_BROKEN_PIPE - Potok został zakończony.
.
Language=Romanian
ERROR_BROKEN_PIPE - Canalul a fost închis.
.

MessageId=110
Severity=Success
Facility=System
SymbolicName=ERROR_OPEN_FAILED
Language=English
ERROR_OPEN_FAILED - The system cannot open the device or file specified.
.
Language=Russian
ERROR_OPEN_FAILED - Системе не удается открыть указанное устройство или файл.
.
Language=Polish
ERROR_OPEN_FAILED - System nie może otworzyć określonego urządzenia lub pliku.
.
Language=Romanian
ERROR_OPEN_FAILED - Dispozitivul sau fișierul specificat nu poate fi deschis.
.

MessageId=111
Severity=Success
Facility=System
SymbolicName=ERROR_BUFFER_OVERFLOW
Language=English
ERROR_BUFFER_OVERFLOW - The file name is too long.
.
Language=Russian
ERROR_BUFFER_OVERFLOW - Указано слишком длинное имя файла.
.
Language=Polish
ERROR_BUFFER_OVERFLOW - Nazwa pliku jest za długa.
.
Language=Romanian
ERROR_BUFFER_OVERFLOW - Numele de fișier este prea lung.
.

MessageId=112
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_FULL
Language=English
ERROR_DISK_FULL - There is not enough space on the disk.
.
Language=Russian
ERROR_DISK_FULL - Недостаточно места на диске.
.
Language=Polish
ERROR_DISK_FULL - Za mało miejsca na dysku.
.
Language=Romanian
ERROR_DISK_FULL - Nu mai este spațiu suficient pe disc.
.

MessageId=113
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_SEARCH_HANDLES
Language=English
ERROR_NO_MORE_SEARCH_HANDLES - No more internal file identifiers available.
.
Language=Russian
ERROR_NO_MORE_SEARCH_HANDLES - Исчерпаны внутренние идентификаторы файлов.
.
Language=Polish
ERROR_NO_MORE_SEARCH_HANDLES - Brak dostępnych wewnętrznych identyfikatorów plików.
.
Language=Romanian
ERROR_NO_MORE_SEARCH_HANDLES - Nu mai sunt disponibili identificatori interni de fișier.
.

MessageId=114
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_TARGET_HANDLE
Language=English
ERROR_INVALID_TARGET_HANDLE - The target internal file identifier is incorrect.
.
Language=Russian
ERROR_INVALID_TARGET_HANDLE - Результирующий внутренний идентификатор файла неправилен.
.
Language=Polish
ERROR_INVALID_TARGET_HANDLE - Wewnętrzny identyfikator pliku docelowego jest niepoprawny.
.
Language=Romanian
ERROR_INVALID_TARGET_HANDLE - Identificatorul intern de fișier țintă este necorespunzător.
.

MessageId=117
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_CATEGORY
Language=English
ERROR_INVALID_CATEGORY - The IOCTL call made by the application program is not correct.
.
Language=Russian
ERROR_INVALID_CATEGORY - Вызов IOCTL приложением произведен неверно.
.
Language=Polish
ERROR_INVALID_CATEGORY - Wywołanie IOCTL wykonane przez program aplikacji jest niepoprawne.
.
Language=Romanian
ERROR_INVALID_CATEGORY - Apelul IOCTL efectuat de programul aplicație nu este corespunzător.
.

MessageId=118
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_VERIFY_SWITCH
Language=English
ERROR_INVALID_VERIFY_SWITCH - The verify-on-write switch parameter value is not correct.
.
Language=Russian
ERROR_INVALID_VERIFY_SWITCH - Параметр проверки записи данных имеет неверное значение.
.
Language=Polish
ERROR_INVALID_VERIFY_SWITCH - Wartość parametru przełącznika sprawdź-przy-zapisie jest niepoprawna.
.
Language=Romanian
ERROR_INVALID_VERIFY_SWITCH - Valoarea parametrului de verificare la scriere nu este corespunzătoare.
.

MessageId=119
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DRIVER_LEVEL
Language=English
ERROR_BAD_DRIVER_LEVEL - The system does not support the command requested.
.
Language=Russian
ERROR_BAD_DRIVER_LEVEL - Система не может обработать полученную команду.
.
Language=Polish
ERROR_BAD_DRIVER_LEVEL - System nie obsługuje żądanego polecenia.
.
Language=Romanian
ERROR_BAD_DRIVER_LEVEL - Comanda solicitată nu este acceptată.
.

MessageId=120
Severity=Success
Facility=System
SymbolicName=ERROR_CALL_NOT_IMPLEMENTED
Language=English
ERROR_CALL_NOT_IMPLEMENTED - This function is not supported on this system.
.
Language=Russian
ERROR_CALL_NOT_IMPLEMENTED - Эта функция не поддерживается для этой системы.
.
Language=Polish
ERROR_CALL_NOT_IMPLEMENTED - Ta funkcja nie jest obsługiwana w tym systemie.
.
Language=Romanian
ERROR_CALL_NOT_IMPLEMENTED - Această funcție nu este acceptată în acest sistem.
.

MessageId=121
Severity=Success
Facility=System
SymbolicName=ERROR_SEM_TIMEOUT
Language=English
ERROR_SEM_TIMEOUT - The semaphore timeout period has expired.
.
Language=Russian
ERROR_SEM_TIMEOUT - Превышен таймаут семафора.
.
Language=Polish
ERROR_SEM_TIMEOUT - Przekroczono limit czasu semafora.
.
Language=Romanian
ERROR_SEM_TIMEOUT - Perioada de valabilitate a semaforului a expirat.
.

MessageId=122
Severity=Success
Facility=System
SymbolicName=ERROR_INSUFFICIENT_BUFFER
Language=English
ERROR_INSUFFICIENT_BUFFER - The data area passed to a system call is too small.
.
Language=Russian
ERROR_INSUFFICIENT_BUFFER - Область данных, переданная по системному вызову, слишком мала.
.
Language=Polish
ERROR_INSUFFICIENT_BUFFER - Obszar danych przekazany do wywołania systemowego jest za mały.
.
Language=Romanian
ERROR_INSUFFICIENT_BUFFER - Zona de date pasată unui apelul de sistem este prea mică.
.

MessageId=123
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_NAME
Language=English
ERROR_INVALID_NAME - The filename, directory name, or volume label syntax is incorrect.
.
Language=Russian
ERROR_INVALID_NAME - Синтаксическая ошибка в имени файла, имени папки или метке тома.
.
Language=Polish
ERROR_INVALID_NAME - Nazwa pliku, nazwa katalogu lub składnia etykiety woluminu jest niepoprawna.
.
Language=Romanian
ERROR_INSUFFICIENT_BUFFER - Zona de date pasată unui apelul de sistem este prea mică.
.

MessageId=124
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LEVEL
Language=English
ERROR_INVALID_LEVEL - The system call level is not correct.
.
Language=Russian
ERROR_INVALID_LEVEL - Неверный уровень системного вызова.
.
Language=Polish
ERROR_INVALID_LEVEL - Poziom wywołania systemowego jest niepoprawny.
.
Language=Romanian
ERROR_INVALID_LEVEL - Nivelul apelului de sistem nu este corespunzător.
.

MessageId=125
Severity=Success
Facility=System
SymbolicName=ERROR_NO_VOLUME_LABEL
Language=English
ERROR_NO_VOLUME_LABEL - The disk has no volume label.
.
Language=Russian
ERROR_NO_VOLUME_LABEL - У диска отсутствует метка тома.
.
Language=Polish
ERROR_NO_VOLUME_LABEL - Dysk nie ma etykiety woluminu.
.
Language=Romanian
ERROR_NO_VOLUME_LABEL - Discul nu are etichetă de volum.
.

MessageId=126
Severity=Success
Facility=System
SymbolicName=ERROR_MOD_NOT_FOUND
Language=English
ERROR_MOD_NOT_FOUND - The specified module could not be found.
.
Language=Russian
ERROR_MOD_NOT_FOUND - Не найден указанный модуль.
.
Language=Polish
ERROR_MOD_NOT_FOUND - Nie można odnaleźć określonego modułu.
.
Language=Romanian
ERROR_MOD_NOT_FOUND - Modulul specificat nu a fost găsit.
.

MessageId=127
Severity=Success
Facility=System
SymbolicName=ERROR_PROC_NOT_FOUND
Language=English
ERROR_PROC_NOT_FOUND - The specified procedure could not be found.
.
Language=Russian
ERROR_PROC_NOT_FOUND - Не найдена указанная процедура.
.
Language=Polish
ERROR_PROC_NOT_FOUND - Nie można odnaleźć określonej procedury.
.
Language=Romanian
ERROR_PROC_NOT_FOUND - Procedura specificată nu a fost găsită.
.

MessageId=128
Severity=Success
Facility=System
SymbolicName=ERROR_WAIT_NO_CHILDREN
Language=English
ERROR_WAIT_NO_CHILDREN - There are no child processes to wait for.
.
Language=Russian
ERROR_WAIT_NO_CHILDREN - Дочерние процессы, окончания которых требуется ожидать, отсутствуют.
.
Language=Polish
ERROR_WAIT_NO_CHILDREN - Nie ma procesów podrzędnych, na które trzeba by czekać.
.
Language=Romanian
ERROR_WAIT_NO_CHILDREN - Nu a mai rămas de așteptat nici un sub-proces.
.

MessageId=129
Severity=Success
Facility=System
SymbolicName=ERROR_CHILD_NOT_COMPLETE
Language=English
ERROR_CHILD_NOT_COMPLETE - The %1 application cannot be run in Win32 mode.
.
Language=Russian
ERROR_CHILD_NOT_COMPLETE - Приложение "%1" не может быть запущено в режиме Win32.
.
Language=Polish
ERROR_CHILD_NOT_COMPLETE - Nie można uruchomić %1 w trybie Win32.
.
Language=Romanian
ERROR_CHILD_NOT_COMPLETE - Aplicația «%1» nu poate fi lansată în mod Win32.
.

MessageId=130
Severity=Success
Facility=System
SymbolicName=ERROR_DIRECT_ACCESS_HANDLE
Language=English
ERROR_DIRECT_ACCESS_HANDLE - Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O.
.
Language=Russian
ERROR_DIRECT_ACCESS_HANDLE - Попытка использовать дескриптор файла для открытия раздела диска и выполнения операции, отличающейся от ввода/вывода нижнего уровня.
.
Language=Polish
ERROR_DIRECT_ACCESS_HANDLE - Próbowano użyć dojścia do pliku do otwarcia partycji dysku dla operacji innej niż czysta dyskowa operacja We/Wy.
.
Language=Romanian
ERROR_DIRECT_ACCESS_HANDLE - Încercare de a utiliza pentru o partiție de disc un identificator de gestiune de fișiere pentru operații în afara celor de acces brut de In/Ex.
.

MessageId=131
Severity=Success
Facility=System
SymbolicName=ERROR_NEGATIVE_SEEK
Language=English
ERROR_NEGATIVE_SEEK - An attempt was made to move the file pointer before the beginning of the file.
.
Language=Russian
ERROR_NEGATIVE_SEEK - Попытка поместить указатель на файл перед началом файла.
.
Language=Polish
ERROR_NEGATIVE_SEEK - Wykonano próbę przesunięcia wskaźnika pliku przed początek pliku.
.
Language=Romanian
ERROR_NEGATIVE_SEEK - Încercare de a plasa un indicator de fișier către o valoare negativă.
.

MessageId=132
Severity=Success
Facility=System
SymbolicName=ERROR_SEEK_ON_DEVICE
Language=English
ERROR_SEEK_ON_DEVICE - The file pointer cannot be set on the specified device or file.
.
Language=Russian
ERROR_SEEK_ON_DEVICE - Указатель на файл не может быть установлен на заданное устройство или файл.
.
Language=Polish
ERROR_SEEK_ON_DEVICE - Wskaźnik plików nie może być ustawiony na określonym urządzeniu lub pliku.
.
Language=Romanian
ERROR_SEEK_ON_DEVICE - Indicatorul de fișier nu poate fi plasat pe fișierul sau dispozitivul specificat.
.

MessageId=133
Severity=Success
Facility=System
SymbolicName=ERROR_IS_JOIN_TARGET
Language=English
ERROR_IS_JOIN_TARGET - A JOIN or SUBST command cannot be used for a drive that contains previously joined drives.
.
Language=Russian
ERROR_IS_JOIN_TARGET - Команды JOIN и SUBST не могут быть использованы для дисков, содержащих уже объединенные диски.
.
Language=Polish
ERROR_IS_JOIN_TARGET - Polecenia JOIN lub SUBST nie mogą być użyte na dysku zawierającym poprzednio sprzężone dyski.
.
Language=Romanian
ERROR_IS_JOIN_TARGET - O comandă JOIN sau SUBST nu poate fi lansată pentru o unitate de stocare care deja conține asocieri de alte unități de stocare.
.

MessageId=134
Severity=Success
Facility=System
SymbolicName=ERROR_IS_JOINED
Language=English
ERROR_IS_JOINED - An attempt was made to use a JOIN or SUBST command on a drive that has already been joined.
.
Language=Russian
ERROR_IS_JOINED - Попытка использовать команду JOIN или SUBST для диска, уже включенного в набор объединенных дисков.
.
Language=Polish
ERROR_IS_JOINED - Wykonano próbę użycia polecenia JOIN lub SUBST dla dysku, który został już sprzęgnięty.
.
Language=Romanian
ERROR_IS_JOINED - Încercare de a lansa comanda JOIN sau SUBST pentru o unitate de stocare care deja a fost asociată.
.

MessageId=135
Severity=Success
Facility=System
SymbolicName=ERROR_IS_SUBSTED
Language=English
ERROR_IS_SUBSTED - An attempt was made to use a JOIN or SUBST command on a drive that has already been substituted.
.
Language=Russian
ERROR_IS_SUBSTED - Попытка использовать команду JOIN или SUBST для диска, который уже был отображен.
.
Language=Polish
ERROR_IS_SUBSTED - Wykonano próbę użycia polecenia JOIN lub SUBST na dysku, który uległ już podstawieniu.
.
Language=Romanian
ERROR_IS_SUBSTED - Încercare de a lansa comanda JOIN sau SUBST pentru o unitate de stocare care a fost deja substituită.
.

MessageId=136
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_JOINED
Language=English
ERROR_NOT_JOINED - The system tried to delete the JOIN of a drive that is not joined.
.
Language=Russian
ERROR_NOT_JOINED - Попытка снять признак объединения с диска, для которого команда JOIN не выполнялась.
.
Language=Polish
ERROR_NOT_JOINED - System próbował usunąć stan JOIN dysku, który nie jest sprzęgnięty (JOIN).
.
Language=Romanian
ERROR_NOT_JOINED - Încercare de a elimina o unitate de stocare care nu este rezultat al unei asocieri.
.

MessageId=137
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SUBSTED
Language=English
ERROR_NOT_SUBSTED - The system tried to delete the substitution of a drive that is not substituted.
.
Language=Russian
ERROR_NOT_SUBSTED - Попытка снять признак отображения с диска, для которого команда SUBST не выполнялась.
.
Language=Polish
ERROR_NOT_SUBSTED - System próbował usunąć podstawienie dysku, który nie uległ podstawieniu.
.
Language=Romanian
ERROR_NOT_SUBSTED - Încercare de a elimina o unitate de stocare care nu este un rezultat al unei substituții.
.

MessageId=138
Severity=Success
Facility=System
SymbolicName=ERROR_JOIN_TO_JOIN
Language=English
ERROR_JOIN_TO_JOIN - The system tried to join a drive to a directory on a joined drive.
.
Language=Russian
ERROR_JOIN_TO_JOIN - Попытка объединить диск с папкой на объединенном диске.
.
Language=Polish
ERROR_JOIN_TO_JOIN - System próbował sprzęgnąć dysk z katalogiem na dysku sprzęgniętym.
.
Language=Romanian
ERROR_JOIN_TO_JOIN - Încercare de a asocia o unitate de stocare într-un director al unei unități de stocare asociate.
.

MessageId=139
Severity=Success
Facility=System
SymbolicName=ERROR_SUBST_TO_SUBST
Language=English
ERROR_SUBST_TO_SUBST - The system tried to substitute a drive to a directory on a substituted drive.
.
Language=Russian
ERROR_SUBST_TO_SUBST - Попытка отобразить диск на папку, находящуюся на отображенном диске.
.
Language=Polish
ERROR_SUBST_TO_SUBST - System próbował dokonać podstawienia dysku przez katalog na dysku poddanym podstawieniu.
.
Language=Romanian
ERROR_SUBST_TO_SUBST - Încercare de substituție a unei unități de stocare într-un director al unei unități de stocare substituite.
.

MessageId=140
Severity=Success
Facility=System
SymbolicName=ERROR_JOIN_TO_SUBST
Language=English
ERROR_JOIN_TO_SUBST - The system tried to join a drive to a directory on a substituted drive.
.
Language=Russian
ERROR_JOIN_TO_SUBST - Попытка объединить диск с папкой на отображенном диске.
.
Language=Polish
ERROR_JOIN_TO_SUBST - System próbował sprzęgnąć dysk z katalogiem na dysku poddanym podstawieniu.
.
Language=Romanian
ERROR_JOIN_TO_SUBST - Încercare de asociere a unei unități de stocare la un director dintr-o unitate de stocare substituită.
.

MessageId=141
Severity=Success
Facility=System
SymbolicName=ERROR_SUBST_TO_JOIN
Language=English
ERROR_SUBST_TO_JOIN - The system tried to SUBST a drive to a directory on a joined drive.
.
Language=Russian
ERROR_SUBST_TO_JOIN - Попытка отобразить диск на папку, находящуюся на объединенном диске.
.
Language=Polish
ERROR_SUBST_TO_JOIN - System próbował dokonać podstawienia dysku przez katalog na dysku sprzęgniętym.
.
Language=Romanian
ERROR_SUBST_TO_JOIN - Încercare de substituție a unei unități de stocare la un director dintr-o unitate de stocare asociată.
.

MessageId=142
Severity=Success
Facility=System
SymbolicName=ERROR_BUSY_DRIVE
Language=English
ERROR_BUSY_DRIVE - The system cannot perform a JOIN or SUBST at this time.
.
Language=Russian
ERROR_BUSY_DRIVE - В настоящее время выполнить команду JOIN или SUBST невозможно.
.
Language=Polish
ERROR_BUSY_DRIVE - System nie może teraz wykonać polecenia JOIN ani SUBST.
.
Language=Romanian
ERROR_BUSY_DRIVE - Deocamdată nu pot fi efectuate operații de asociere sau substituție.
.

MessageId=143
Severity=Success
Facility=System
SymbolicName=ERROR_SAME_DRIVE
Language=English
ERROR_SAME_DRIVE - The system cannot join or substitute a drive to or for a directory on the same drive.
.
Language=Russian
ERROR_SAME_DRIVE - Невозможно объединить (или отобразить) диск с папкой (или на папку) этого же диска.
.
Language=Polish
ERROR_SAME_DRIVE - System nie może sprzęgnąć lub dokonać podstawienia dysku (JOIN lub SUBST) przy użyciu katalogu na tym samym dysku.
.
Language=Romanian
ERROR_SAME_DRIVE - O unitate de stocare la sau pentru un director de pe aceiași unitate de stocare nu poate fi asociată sau substituită.
.

MessageId=144
Severity=Success
Facility=System
SymbolicName=ERROR_DIR_NOT_ROOT
Language=English
ERROR_DIR_NOT_ROOT - The directory is not a subdirectory of the root directory.
.
Language=Russian
ERROR_DIR_NOT_ROOT - Эта папка не является подпапкой корневой папки.
.
Language=Polish
ERROR_DIR_NOT_ROOT - Katalog nie jest podkatalogiem katalogu głównego.
.
Language=Romanian
ERROR_DIR_NOT_ROOT - Directorul nu este subdirector al directorului rădăcină.
.

MessageId=145
Severity=Success
Facility=System
SymbolicName=ERROR_DIR_NOT_EMPTY
Language=English
ERROR_DIR_NOT_EMPTY - The directory is not empty.
.
Language=Russian
ERROR_DIR_NOT_EMPTY - Папка не пуста.
.
Language=Polish
ERROR_DIR_NOT_EMPTY - Katalog nie jest pusty.
.
Language=Romanian
ERROR_DIR_NOT_EMPTY - Directorul nu este gol.
.

MessageId=146
Severity=Success
Facility=System
SymbolicName=ERROR_IS_SUBST_PATH
Language=English
ERROR_IS_SUBST_PATH - The path specified is being used in a substitute.
.
Language=Russian
ERROR_IS_SUBST_PATH - Указанный путь используется для отображенного диска.
.
Language=Polish
ERROR_IS_SUBST_PATH - Określona ścieżka jest używana w podstawieniu.
.
Language=Romanian
ERROR_IS_SUBST_PATH - Calea specificată este deja utilizată într-o substituție.
.

MessageId=147
Severity=Success
Facility=System
SymbolicName=ERROR_IS_JOIN_PATH
Language=English
ERROR_IS_JOIN_PATH - Not enough resources are available to process this command.
.
Language=Russian
ERROR_IS_JOIN_PATH - Недостаточно ресурсов для обработки команды.
.
Language=Polish
ERROR_IS_JOIN_PATH - Za mało zasobów do przetworzenia tego polecenia.
.
Language=Romanian
ERROR_IS_JOIN_PATH - Nu există suficiente resurse disponibile pentru a executa această comandă.
.

MessageId=148
Severity=Success
Facility=System
SymbolicName=ERROR_PATH_BUSY
Language=English
ERROR_PATH_BUSY - The path specified cannot be used at this time.
.
Language=Russian
ERROR_PATH_BUSY - Указанный путь невозможно использовать сейчас.
.
Language=Polish
ERROR_PATH_BUSY - Nie można teraz użyć określonej ścieżki.
.
Language=Romanian
ERROR_PATH_BUSY - Calea specificată nu poate fi utilizată deocamdată.
.

MessageId=149
Severity=Success
Facility=System
SymbolicName=ERROR_IS_SUBST_TARGET
Language=English
ERROR_IS_SUBST_TARGET - An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute.
.
Language=Russian
ERROR_IS_SUBST_TARGET - Попытка объединить или отобразить диск, папка на котором уже используется для отображения.
.
Language=Polish
ERROR_IS_SUBST_TARGET - Wykonano próbę sprzęgnięcia (JOIN) lub podstawienia (SUBST) dysku, dla którego katalog na dysku jest katalogiem docelowym poprzedniego podstawienia.
.
Language=Romanian
ERROR_IS_SUBST_TARGET - Încercare de a asocia sau substitui o unitate de stocare care conține un director substituit.
.

MessageId=150
Severity=Success
Facility=System
SymbolicName=ERROR_SYSTEM_TRACE
Language=English
ERROR_SYSTEM_TRACE - System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed.
.
Language=Russian
ERROR_SYSTEM_TRACE - Сведения о трассировке в файле CONFIG.SYS не найдены, либо трассировка запрещена.
.
Language=Polish
ERROR_SYSTEM_TRACE - СInformacje o śledzeniu systemu nie zostały określone w pliku CONFIG.SYS lub śledzenie jest niedozwolone.
.
Language=Romanian
ERROR_SYSTEM_TRACE - În fișierul CONFIG.SYS nu sunt specificate informații de trasare pentru sistem, sau trasarea este dezactivată.
.

MessageId=151
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EVENT_COUNT
Language=English
ERROR_INVALID_EVENT_COUNT - The number of specified semaphore events for DosMuxSemWait is not correct.
.
Language=Russian
ERROR_INVALID_EVENT_COUNT - Число семафоров для DosMuxSemWait задано неверно.
.
Language=Polish
ERROR_INVALID_EVENT_COUNT - Liczba określonych zdarzeń semafora dla DosMuxSemWait jest niepoprawna.
.
Language=Romanian
ERROR_INVALID_EVENT_COUNT - Numărul evenimentelor de semafor specificate pentru DosMuxSemWait nu este corespunzător.
.

MessageId=152
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_MUXWAITERS
Language=English
ERROR_TOO_MANY_MUXWAITERS - DosMuxSemWait did not execute; too many semaphores are already set.
.
Language=Russian
ERROR_TOO_MANY_MUXWAITERS - Не выполнен вызов DosMuxSemWait. Установлено слишком много семафоров.
.
Language=Polish
ERROR_TOO_MANY_MUXWAITERS - Nie wykonano funkcji DosMuxSemWait; za dużo semaforów jest już ustawionych.
.
Language=Romanian
ERROR_TOO_MANY_MUXWAITERS - DosMuxSemWait nu a fost lansat; deja sunt prea multe semafoare active.
.

MessageId=153
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LIST_FORMAT
Language=English
ERROR_INVALID_LIST_FORMAT - The DosMuxSemWait list is not correct.
.
Language=Russian
ERROR_INVALID_LIST_FORMAT - Некорректный вызов DosMuxSemWait.
.
Language=Polish
ERROR_INVALID_LIST_FORMAT - Lista DosMuxSemWait jest niepoprawna.
.
Language=Romanian
ERROR_INVALID_LIST_FORMAT - Lista DosMuxSemWait nu este corespunzătoare.
.

MessageId=154
Severity=Success
Facility=System
SymbolicName=ERROR_LABEL_TOO_LONG
Language=English
ERROR_LABEL_TOO_LONG - The volume label you entered exceeds the label character limit of the target file system.
.
Language=Russian
ERROR_LABEL_TOO_LONG - Длина метки тома превосходит предел, установленный для файловой системы.
.
Language=Polish
ERROR_LABEL_TOO_LONG - Wprowadzona etykieta woluminu przekracza limit znaków etykiety docelowego systemu plików.
.
Language=Romanian
ERROR_LABEL_TOO_LONG - Lungimea pentru eticheta de volum depășește limita corespunzătoare etichetei pentru sistemul de fișiere destinație.
.

MessageId=155
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_TCBS
Language=English
ERROR_TOO_MANY_TCBS - Cannot create another thread.
.
Language=Russian
ERROR_TOO_MANY_TCBS - Не удается создать еще один поток команд.
.
Language=Polish
ERROR_TOO_MANY_TCBS - Nie można utworzyć innego wątku.
.
Language=Romanian
ERROR_TOO_MANY_TCBS - Un alt fir de execuție nu poate fi creat.
.

MessageId=156
Severity=Success
Facility=System
SymbolicName=ERROR_SIGNAL_REFUSED
Language=English
ERROR_SIGNAL_REFUSED - The recipient process has refused the signal.
.
Language=Russian
ERROR_SIGNAL_REFUSED - Принимающий процесс отклонил сигнал.
.
Language=Polish
ERROR_SIGNAL_REFUSED - Proces odbiorczy odrzucił sygnał.
.
Language=Romanian
ERROR_SIGNAL_REFUSED - Procesul recipient a refuzat semnalul.
.

MessageId=157
Severity=Success
Facility=System
SymbolicName=ERROR_DISCARDED
Language=English
ERROR_DISCARDED - The segment is already discarded and cannot be locked.
.
Language=Russian
ERROR_DISCARDED - Сегмент уже освобожден и не может быть заблокирован.
.
Language=Polish
ERROR_DISCARDED - Segment jest już zarzucony i nie można go zablokować.
.
Language=Romanian
ERROR_DISCARDED - Segmentul deja a fost înlăturat și nu poate fi blocat.
.

MessageId=158
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_LOCKED
Language=English
ERROR_NOT_LOCKED - The segment is already unlocked.
.
Language=Russian
ERROR_NOT_LOCKED - Блокировка с сегмента уже снята.
.
Language=Polish
ERROR_NOT_LOCKED - Segment jest już odblokowany.
.
Language=Romanian
ERROR_NOT_LOCKED - Segmentul deja este deblocat.
.

MessageId=159
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_THREADID_ADDR
Language=English
ERROR_BAD_THREADID_ADDR - The address for the thread ID is not correct.
.
Language=Russian
ERROR_BAD_THREADID_ADDR - Адрес идентификатора потока команд задан неверно.
.
Language=Polish
ERROR_BAD_THREADID_ADDR - Adres identyfikatora wątku jest niepoprawny.
.
Language=Romanian
ERROR_BAD_THREADID_ADDR - Adresa pentru ID de fir de execuție nu este corespunzător.
.

MessageId=160
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_ARGUMENTS
Language=English
ERROR_BAD_ARGUMENTS - The argument string passed to DosExecPgm is not correct.
.
Language=Russian
ERROR_BAD_ARGUMENTS - Неверны один или несколько аргументов.
.
Language=Polish
ERROR_BAD_ARGUMENTS - Co najmniej jeden argument jest niepoprawny.
.
Language=Romanian
ERROR_BAD_ARGUMENTS - Șirul de argumente pasat către DosExecPgm nu este corespunzător.
.

MessageId=161
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_PATHNAME
Language=English
ERROR_BAD_PATHNAME - The specified path is invalid.
.
Language=Russian
ERROR_BAD_PATHNAME - Указан недопустимый путь.
.
Language=Polish
ERROR_BAD_PATHNAME - Określona ścieżka jest nieprawidłowa.
.
Language=Romanian
ERROR_BAD_PATHNAME - Calea specificată nu este validă.
.

MessageId=162
Severity=Success
Facility=System
SymbolicName=ERROR_SIGNAL_PENDING
Language=English
ERROR_SIGNAL_PENDING - A signal is already pending.
.
Language=Russian
ERROR_SIGNAL_PENDING - Сигнал уже находится в состоянии обработки.
.
Language=Polish
ERROR_SIGNAL_PENDING - Sygnał jest już w stanie oczekiwania.
.
Language=Romanian
ERROR_SIGNAL_PENDING - Semnalul deja este în așteptare.
.

MessageId=164
Severity=Success
Facility=System
SymbolicName=ERROR_MAX_THRDS_REACHED
Language=English
ERROR_MAX_THRDS_REACHED - No more threads can be created in the system.
.
Language=Russian
ERROR_MAX_THRDS_REACHED - Создание дополнительных потоков команд невозможно.
.
Language=Polish
ERROR_MAX_THRDS_REACHED - W systemie nie można utworzyć dalszych wątków.
.
Language=Romanian
ERROR_MAX_THRDS_REACHED - Mai multe fire de execuție nu pot fi create.
.

MessageId=167
Severity=Success
Facility=System
SymbolicName=ERROR_LOCK_FAILED
Language=English
ERROR_LOCK_FAILED - Unable to lock a region of a file.
.
Language=Russian
ERROR_LOCK_FAILED - Не удается снять блокировку с области файла.
.
Language=Polish
ERROR_LOCK_FAILED - Nie można zablokować regionu pliku.
.
Language=Romanian
ERROR_LOCK_FAILED - O parte din fișier nu a putut fi blocată.
.

MessageId=170
Severity=Success
Facility=System
SymbolicName=ERROR_BUSY
Language=English
ERROR_BUSY - The requested resource is in use.
.
Language=Russian
ERROR_BUSY - Требуемый ресурс занят.
.
Language=Polish
ERROR_BUSY - Żądane zasoby są w użyciu.
.
Language=Romanian
ERROR_BUSY - Resursa solicitată este deja în uz.
.

MessageId=173
Severity=Success
Facility=System
SymbolicName=ERROR_CANCEL_VIOLATION
Language=English
ERROR_CANCEL_VIOLATION - A lock request was not outstanding for the supplied cancel region.
.
Language=Russian
ERROR_CANCEL_VIOLATION - Запрос на блокировку соответствует определенной области.
.
Language=Polish
ERROR_CANCEL_VIOLATION - Żądanie zablokowania nie było zaległe dla podanego regionu anulowania.
.
Language=Romanian
ERROR_CANCEL_VIOLATION - Pentru zona de anulare furnizată există o cerere de blocare neadresată.
.

MessageId=174
Severity=Success
Facility=System
SymbolicName=ERROR_ATOMIC_LOCKS_NOT_SUPPORTED
Language=English
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED - The file system does not support atomic changes to the lock type.
.
Language=Russian
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED - Файловая система не поддерживает указанные изменения типа блокировки.
.
Language=Polish
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED - System plików nie obsługuje zmian częściowych dotyczących typu blokady.
.
Language=Romanian
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED - Sistemul de fișiere nu permite blocări pentru modificări atomice.
.

MessageId=180
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SEGMENT_NUMBER
Language=English
ERROR_INVALID_SEGMENT_NUMBER - The system detected a segment number that was not correct.
.
Language=Russian
ERROR_INVALID_SEGMENT_NUMBER - Система обнаружила неверный номер сегмента.
.
Language=Polish
ERROR_INVALID_SEGMENT_NUMBER - System wykrył niepoprawny numer segmentu.
.
Language=Romanian
ERROR_INVALID_SEGMENT_NUMBER - Un număr de segment a fost identificat ca fiind necorespunzător.
.

MessageId=182
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ORDINAL
Language=English
ERROR_INVALID_ORDINAL - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_ORDINAL - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_ORDINAL - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_ORDINAL - «%1» nu poate fi executat.
.

MessageId=183
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_EXISTS
Language=English
ERROR_ALREADY_EXISTS - Cannot create a file when that file already exists.
.
Language=Russian
ERROR_ALREADY_EXISTS - Невозможно создать файл, так как он уже существует.
.
Language=Polish
ERROR_ALREADY_EXISTS - Nie można utworzyć pliku, który już istnieje.
.
Language=Romanian
ERROR_ALREADY_EXISTS - Nu poate fi creat un fișier când acesta deja există.
.

MessageId=186
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FLAG_NUMBER
Language=English
ERROR_INVALID_FLAG_NUMBER - The flag passed is not correct.
.
Language=Russian
ERROR_INVALID_FLAG_NUMBER - Передан неверный флаг.
.
Language=Polish
ERROR_INVALID_FLAG_NUMBER - Przekazana flaga jest niepoprawna.
.
Language=Romanian
ERROR_INVALID_FLAG_NUMBER - Fanionul furnizat nu este corespunzător.
.

MessageId=187
Severity=Success
Facility=System
SymbolicName=ERROR_SEM_NOT_FOUND
Language=English
ERROR_SEM_NOT_FOUND - The specified system semaphore name was not found.
.
Language=Russian
ERROR_SEM_NOT_FOUND - Не найдено указанное имя системного семафора.
.
Language=Polish
ERROR_SEM_NOT_FOUND - Nie odnaleziono określonej nazwy semafora systemowego.
.
Language=Romanian
ERROR_SEM_NOT_FOUND - Numele de semafor specificat nu a fost găsit.
.

MessageId=188
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_STARTING_CODESEG
Language=English
ERROR_INVALID_STARTING_CODESEG - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_STARTING_CODESEG - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_STARTING_CODESEG - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_STARTING_CODESEG - Sistemul de operare nu poate lansa «%1».
.

MessageId=189
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_STACKSEG
Language=English
ERROR_INVALID_STACKSEG - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_STACKSEG - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_STACKSEG - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_STACKSEG - Sistemul de operare nu poate lansa «%1».
.

MessageId=190
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MODULETYPE
Language=English
ERROR_INVALID_MODULETYPE - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_MODULETYPE - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_MODULETYPE - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_MODULETYPE - Sistemul de operare nu poate lansa «%1».
.

MessageId=191
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EXE_SIGNATURE
Language=English
ERROR_INVALID_EXE_SIGNATURE - Cannot run %1 in Win32 mode.
.
Language=Russian
ERROR_INVALID_EXE_SIGNATURE - Невозможно запустить "%1" в режиме Win32.
.
Language=Polish
ERROR_INVALID_EXE_SIGNATURE - Nie można uruchomić %1 w trybie Win32.
.
Language=Romanian
ERROR_INVALID_EXE_SIGNATURE - «%1» nu poate fi lansată în mod Win32.
.

MessageId=192
Severity=Success
Facility=System
SymbolicName=ERROR_EXE_MARKED_INVALID
Language=English
ERROR_EXE_MARKED_INVALID - The operating system cannot run %1.
.
Language=Russian
ERROR_EXE_MARKED_INVALID - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_EXE_MARKED_INVALID - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_EXE_MARKED_INVALID - Sistemul de operare nu poate lansa «%1».
.

MessageId=193
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_EXE_FORMAT
Language=English
ERROR_BAD_EXE_FORMAT - %1 is not a valid Win32 application.
.
Language=Russian
ERROR_BAD_EXE_FORMAT - "%1" не является приложением Win32.
.
Language=Polish
ERROR_BAD_EXE_FORMAT - %1 nie jest prawidłową aplikacją systemu Win32.
.
Language=Romanian
ERROR_BAD_EXE_FORMAT - «%1» nu este o aplicație Win32.
.

MessageId=194
Severity=Success
Facility=System
SymbolicName=ERROR_ITERATED_DATA_EXCEEDS_64k
Language=English
ERROR_ITERATED_DATA_EXCEEDS_64k - The operating system cannot run %1.
.
Language=Russian
ERROR_ITERATED_DATA_EXCEEDS_64k - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_ITERATED_DATA_EXCEEDS_64k - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_ITERATED_DATA_EXCEEDS_64k - Sistemul de operare nu poate lansa «%1».
.

MessageId=195
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MINALLOCSIZE
Language=English
ERROR_INVALID_MINALLOCSIZE - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_MINALLOCSIZE - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_MINALLOCSIZE - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_MINALLOCSIZE - Sistemul de operare nu poate lansa «%1».
.

MessageId=196
Severity=Success
Facility=System
SymbolicName=ERROR_DYNLINK_FROM_INVALID_RING
Language=English
ERROR_DYNLINK_FROM_INVALID_RING - The operating system cannot run this application program.
.
Language=Russian
ERROR_DYNLINK_FROM_INVALID_RING - Операционная система не может запустить это приложение.
.
Language=Polish
ERROR_DYNLINK_FROM_INVALID_RING - System operacyjny nie może uruchomić tej aplikacji programu.
.
Language=Romanian
ERROR_DYNLINK_FROM_INVALID_RING - Aplicația program nu poate fi lansată.
.

MessageId=197
Severity=Success
Facility=System
SymbolicName=ERROR_IOPL_NOT_ENABLED
Language=English
ERROR_IOPL_NOT_ENABLED - The operating system is not presently configured to run this application.
.
Language=Russian
ERROR_IOPL_NOT_ENABLED - Конфигурация операционной системы не рассчитана на запуск этого приложения.
.
Language=Polish
ERROR_IOPL_NOT_ENABLED - System operacyjny nie jest obecnie skonfigurowany do uruchomienia tej aplikacji.
.
Language=Romanian
ERROR_IOPL_NOT_ENABLED - Sistemul de operare nu este deocamdată configurat pentru a putea lansa această aplicație.
.

MessageId=198
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SEGDPL
Language=English
ERROR_INVALID_SEGDPL - The operating system cannot run %1.
.
Language=Russian
ERROR_INVALID_SEGDPL - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INVALID_SEGDPL - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INVALID_SEGDPL - Sistemul de operare nu poate lansa «%1».
.

MessageId=199
Severity=Success
Facility=System
SymbolicName=ERROR_AUTODATASEG_EXCEEDS_64k
Language=English
ERROR_AUTODATASEG_EXCEEDS_64k - The operating system cannot run this application program.
.
Language=Russian
ERROR_AUTODATASEG_EXCEEDS_64k - Операционная система не может запустить это приложение.
.
Language=Polish
ERROR_AUTODATASEG_EXCEEDS_64k - System operacyjny nie może uruchomić tej aplikacji programu.
.
Language=Romanian
ERROR_AUTODATASEG_EXCEEDS_64k - Aplicația program nu poate fi lansată.
.

MessageId=200
Severity=Success
Facility=System
SymbolicName=ERROR_RING2SEG_MUST_BE_MOVABLE
Language=English
ERROR_RING2SEG_MUST_BE_MOVABLE - The code segment cannot be greater than or equal to 64K.
.
Language=Russian
ERROR_RING2SEG_MUST_BE_MOVABLE - Сегмент кода должен быть меньше 64 КБ.
.
Language=Polish
ERROR_RING2SEG_MUST_BE_MOVABLE - Segment kodu nie może być większy niż lub równy 64 KB.
.
Language=Romanian
ERROR_RING2SEG_MUST_BE_MOVABLE - Lungimea codului de segment nu poate fi egală cu sau depăși 64 Кo.
.

MessageId=201
Severity=Success
Facility=System
SymbolicName=ERROR_RELOC_CHAIN_XEEDS_SEGLIM
Language=English
ERROR_RELOC_CHAIN_XEEDS_SEGLIM - The operating system cannot run %1.
.
Language=Russian
ERROR_RELOC_CHAIN_XEEDS_SEGLIM - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_RELOC_CHAIN_XEEDS_SEGLIM - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_RELOC_CHAIN_XEEDS_SEGLIM - Sistemul de operare nu poate lansa «%1».
.

MessageId=202
Severity=Success
Facility=System
SymbolicName=ERROR_INFLOOP_IN_RELOC_CHAIN
Language=English
ERROR_INFLOOP_IN_RELOC_CHAIN - The operating system cannot run %1.
.
Language=Russian
ERROR_INFLOOP_IN_RELOC_CHAIN - Операционная система не может выполнить "%1".
.
Language=Polish
ERROR_INFLOOP_IN_RELOC_CHAIN - System operacyjny nie może uruchomić %1.
.
Language=Romanian
ERROR_INFLOOP_IN_RELOC_CHAIN - Sistemul de operare nu poate lansa «%1».
.

MessageId=203
Severity=Success
Facility=System
SymbolicName=ERROR_ENVVAR_NOT_FOUND
Language=English
ERROR_ENVVAR_NOT_FOUND - The system could not find the environment option that was entered.
.
Language=Russian
ERROR_ENVVAR_NOT_FOUND - Системе не удается найти указанный параметр среды.
.
Language=Polish
ERROR_ENVVAR_NOT_FOUND - System nie mógł znaleźć opcji środowiska, która została wprowadzona.
.
Language=Romanian
ERROR_ENVVAR_NOT_FOUND - Opțiunea de mediu introdusă nu a fost găsită.
.

MessageId=205
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SIGNAL_SENT
Language=English
ERROR_NO_SIGNAL_SENT - No process in the command subtree has a signal handler.
.
Language=Russian
ERROR_NO_SIGNAL_SENT - Ни один из процессов в дереве команды не имеет обработчика сигналов.
.
Language=Polish
ERROR_NO_SIGNAL_SENT - Żaden proces w poddrzewie polecenia nie ma obsługi sygnałów.
.
Language=Romanian
ERROR_NO_SIGNAL_SENT - Nici un proces din subarborele de comandă nu are un identificator de gestiune pentru semnale.
.

MessageId=206
Severity=Success
Facility=System
SymbolicName=ERROR_FILENAME_EXCED_RANGE
Language=English
ERROR_FILENAME_EXCED_RANGE - The filename or extension is too long.
.
Language=Russian
ERROR_FILENAME_EXCED_RANGE - Имя файла или его расширение имеет слишком большую длину.
.
Language=Polish
ERROR_FILENAME_EXCED_RANGE - Nazwa pliku lub jej rozszerzenie są za długie.
.
Language=Romanian
ERROR_FILENAME_EXCED_RANGE - Lungimea numelui de fișier sau a extensiei sale este prea mare.
.

MessageId=207
Severity=Success
Facility=System
SymbolicName=ERROR_RING2_STACK_IN_USE
Language=English
ERROR_RING2_STACK_IN_USE - The ring 2 stack is in use.
.
Language=Russian
ERROR_RING2_STACK_IN_USE - Кольцо 2 стека занято.
.
Language=Polish
ERROR_RING2_STACK_IN_USE - Stos ring 2 jest w użyciu.
.
Language=Romanian
ERROR_RING2_STACK_IN_USE - Stiva pentru inelul 2 este în uz.
.

MessageId=208
Severity=Success
Facility=System
SymbolicName=ERROR_META_EXPANSION_TOO_LONG
Language=English
ERROR_META_EXPANSION_TOO_LONG - The global filename characters, * or ?, are entered incorrectly or too many global filename characters are specified.
.
Language=Russian
ERROR_META_EXPANSION_TOO_LONG - Подстановочные знаки * и/или ? заданы неверно или образуют неверный шаблон имени.
.
Language=Polish
ERROR_META_EXPANSION_TOO_LONG - Znaki globalne w nazwach plików, * lub ?, są niepoprawnie wprowadzone lub określono za dużo znaków globalnych.
.
Language=Romanian
ERROR_META_EXPANSION_TOO_LONG - Fie are loc o utilizare greșită a caracterelor-mască «*» sau «?», fie sunt utilizate prea multe astfel de caractere.
.

MessageId=209
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SIGNAL_NUMBER
Language=English
ERROR_INVALID_SIGNAL_NUMBER - The signal being posted is not correct.
.
Language=Russian
ERROR_INVALID_SIGNAL_NUMBER - Отправляемый сигнал неверен.
.
Language=Polish
ERROR_INVALID_SIGNAL_NUMBER - Ogłaszany sygnał jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_SIGNAL_NUMBER - Semnalul postat nu este corespunzător.
.

MessageId=210
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_1_INACTIVE
Language=English
ERROR_THREAD_1_INACTIVE - The signal handler cannot be set.
.
Language=Russian
ERROR_THREAD_1_INACTIVE - Не удается установить обработчик сигналов.
.
Language=Polish
ERROR_THREAD_1_INACTIVE - Nie można ustawić programu obsługi sygnałów.
.
Language=Romanian
ERROR_THREAD_1_INACTIVE - Identificatorul de gestiune de semnale nu poate fi activat.
.

MessageId=212
Severity=Success
Facility=System
SymbolicName=ERROR_LOCKED
Language=English
ERROR_LOCKED - The segment is locked and cannot be reallocated.
.
Language=Russian
ERROR_LOCKED - Сегмент заблокирован и не может быть перемещен.
.
Language=Polish
ERROR_LOCKED - Segment jest zablokowany i nie można przydzielić go ponownie.
.
Language=Romanian
ERROR_LOCKED - Segmentul este blocat și nu poate fi realocat.
.

MessageId=214
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_MODULES
Language=English
ERROR_TOO_MANY_MODULES - Too many dynamic-link modules are attached to this program or dynamic-link module.
.
Language=Russian
ERROR_TOO_MANY_MODULES - К этой программе или модулю присоединено слишком много динамически подключаемых модулей.
.
Language=Polish
ERROR_TOO_MANY_MODULES - Do tego programu lub modułu dołączono za dużo modułów dołączanych dynamicznie.
.
Language=Romanian
ERROR_TOO_MANY_MODULES - Către acest program sau modul dinamic au fost atașate prea multe module dinamice.
.

MessageId=215
Severity=Success
Facility=System
SymbolicName=ERROR_NESTING_NOT_ALLOWED
Language=English
ERROR_NESTING_NOT_ALLOWED - Cannot nest calls to LoadModule.
.
Language=Russian
ERROR_NESTING_NOT_ALLOWED - Вызовы LoadModule не могут быть вложены.
.
Language=Polish
ERROR_NESTING_NOT_ALLOWED - Nie można zagnieżdżać wywołań funkcji LoadModule.
.
Language=Romanian
ERROR_NESTING_NOT_ALLOWED - LoadModule nu poate conține apeluri imbricate.
.

MessageId=216
Severity=Success
Facility=System
SymbolicName=ERROR_EXE_MACHINE_TYPE_MISMATCH
Language=English
ERROR_EXE_MACHINE_TYPE_MISMATCH - The image file %1 is valid, but is for a machine type other than the current machine.
.
Language=Russian
ERROR_EXE_MACHINE_TYPE_MISMATCH - The image file %1 is valid, but is for a machine type other than the current machine.
.
Language=Polish
ERROR_EXE_MACHINE_TYPE_MISMATCH - Plik obrazu %1 jest prawidłowy, ale jest przeznaczony na komputer innego typu niż obecny.
.
Language=Romanian
ERROR_EXE_MACHINE_TYPE_MISMATCH - Fișierul imagine «%1» este valid, însă nu pentru tipul mașinii de calcul curente.
.

MessageId=217
Severity=Success
Facility=System
SymbolicName=ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY
Language=English
ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY - The image file %1 is signed, unable to modify.
.
Language=Russian
ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY - The image file %1 is signed, unable to modify.
.
Language=Polish
ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY - Plik obrazu %1 jest podpisany, nie można go zmodyfikować.
.
Language=Romanian
ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY - Fișierul imagine «%1» este semnat electronic, nu poate fi modificat.
.

MessageId=218
Severity=Success
Facility=System
SymbolicName=ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY
Language=English
ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY - The image file %1 is strong signed, unable to modify.
.
Language=Russian
ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY - The image file %1 is strong signed, unable to modify.
.
Language=Polish
ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY - Plik obrazu %1 ma silny podpis, nie można go zmodyfikować.
.
Language=Romanian
ERRO_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY - Fișierul imagine «%1» este semnat electronic puternic, nu poate fi modificat.
.

MessageId=230
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_PIPE
Language=English
ERROR_BAD_PIPE - The pipe state is invalid.
.
Language=Russian
ERROR_BAD_PIPE - The pipe state is invalid.
.
Language=Polish
ERROR_BAD_PIPE - Stan potoku jest nieprawidłowy.
.
Language=Romanian
ERROR_BAD_PIPE - Starea canalului nu este validă.
.

MessageId=231
Severity=Success
Facility=System
SymbolicName=ERROR_PIPE_BUSY
Language=English
ERROR_PIPE_BUSY - All pipe instances are busy.
.
Language=Russian
ERROR_PIPE_BUSY - All pipe instances are busy.
.
Language=Polish
ERROR_PIPE_BUSY - Wszystkie wystąpienia potoku są zajęte.
.
Language=Romanian
ERROR_PIPE_BUSY - Toate instanțele canalului sunt ocupate.
.

MessageId=232
Severity=Success
Facility=System
SymbolicName=ERROR_NO_DATA
Language=English
ERROR_NO_DATA - The pipe is being closed.
.
Language=Russian
ERROR_NO_DATA - The pipe is being closed.
.
Language=Polish
ERROR_NO_DATA - Trwa zamykanie potoku.
.
Language=Romanian
ERROR_NO_DATA - Canalul este închis.
.

MessageId=233
Severity=Success
Facility=System
SymbolicName=ERROR_PIPE_NOT_CONNECTED
Language=English
ERROR_PIPE_NOT_CONNECTED - No process is on the other end of the pipe.
.
Language=Russian
ERROR_PIPE_NOT_CONNECTED - No process is on the other end of the pipe.
.
Language=Polish
ERROR_PIPE_NOT_CONNECTED - Na drugim końcu potoku nie ma żadnego procesu.
.
Language=Romanian
ERROR_PIPE_NOT_CONNECTED - La celălalt capăt al canalului nu se află nici un proces.
.

MessageId=234
Severity=Success
Facility=System
SymbolicName=ERROR_MORE_DATA
Language=English
ERROR_MORE_DATA - More data is available.
.
Language=Russian
ERROR_MORE_DATA - More data is available.
.
Language=Polish
ERROR_MORE_DATA - Dostępnych jest więcej danych.
.
Language=Romanian
ERROR_MORE_DATA - Sunt disponibile mai multe date.
.

MessageId=240
Severity=Success
Facility=System
SymbolicName=ERROR_VC_DISCONNECTED
Language=English
ERROR_VC_DISCONNECTED - The session was canceled.
.
Language=Russian
ERROR_VC_DISCONNECTED - The session was canceled.
.
Language=Polish
ERROR_VC_DISCONNECTED - Sesja została anulowana.
.
Language=Romanian
ERROR_VC_DISCONNECTED - Sesiunea a fost anulată.
.

MessageId=254
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EA_NAME
Language=English
ERROR_INVALID_EA_NAME - The specified extended attribute name was invalid.
.
Language=Russian
ERROR_INVALID_EA_NAME - The specified extended attribute name was invalid.
.
Language=Polish
ERROR_INVALID_EA_NAME - Określona nazwa atrybutu rozszerzonego jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_EA_NAME - Numele atributului extins care a fost specificat nu este corespunzător.
.

MessageId=255
Severity=Success
Facility=System
SymbolicName=ERROR_EA_LIST_INCONSISTENT
Language=English
ERROR_EA_LIST_INCONSISTENT - The extended attributes are inconsistent.
.
Language=Russian
ERROR_EA_LIST_INCONSISTENT - The extended attributes are inconsistent.
.
Language=Polish
ERROR_EA_LIST_INCONSISTENT - Atrybuty rozszerzone są niezgodne.
.
Language=Romanian
ERROR_EA_LIST_INCONSISTENT - Atributele extinse nu sunt consistente.
.

MessageId=258
Severity=Success
Facility=System
SymbolicName=WAIT_TIMEOUT
Language=English
WAIT_TIMEOUT - The wait operation timed out.
.
Language=Russian
WAIT_TIMEOUT - The wait operation timed out.
.
Language=Polish
WAIT_TIMEOUT - Upłynął limit czasu operacji oczekiwania.
.
Language=Romanian
WAIT_TIMEOUT - Operația de așteptare a expirat.
.

MessageId=259
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_ITEMS
Language=English
ERROR_NO_MORE_ITEMS - No more data is available.
.
Language=Russian
ERROR_NO_MORE_ITEMS - No more data is available.
.
Language=Polish
ERROR_NO_MORE_ITEMS - Brak dalszych danych.
.
Language=Romanian
ERROR_NO_MORE_ITEMS - Nu sunt disponibile mai multe date.
.

MessageId=266
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_COPY
Language=English
ERROR_CANNOT_COPY - The copy functions cannot be used.
.
Language=Russian
ERROR_CANNOT_COPY - The copy functions cannot be used.
.
Language=Polish
ERROR_CANNOT_COPY - Nie można używać funkcji kopiowania.
.
Language=Romanian
ERROR_CANNOT_COPY - Funcțiile de copiere nu pot fi utilizate.
.

MessageId=267
Severity=Success
Facility=System
SymbolicName=ERROR_DIRECTORY
Language=English
ERROR_DIRECTORY - The directory name is invalid.
.
Language=Russian
ERROR_DIRECTORY - The directory name is invalid.
.
Language=Polish
ERROR_DIRECTORY - Nazwa katalogu jest nieprawidłowa.
.
Language=Romanian
ERROR_DIRECTORY - Numele directorului nu este corespunzător.
.

MessageId=275
Severity=Success
Facility=System
SymbolicName=ERROR_EAS_DIDNT_FIT
Language=English
ERROR_EAS_DIDNT_FIT - The extended attributes did not fit in the buffer.
.
Language=Russian
ERROR_EAS_DIDNT_FIT - The extended attributes did not fit in the buffer.
.
Language=Polish
ERROR_EAS_DIDNT_FIT - Atrybuty rozszerzone nie zmieściły się w buforze.
.
Language=Romanian
ERROR_EAS_DIDNT_FIT - Atributul extins nu a încăput în memorie.
.

MessageId=276
Severity=Success
Facility=System
SymbolicName=ERROR_EA_FILE_CORRUPT
Language=English
ERROR_EA_FILE_CORRUPT - The extended attribute file on the mounted file system is corrupt.
.
Language=Russian
ERROR_EA_FILE_CORRUPT - The extended attribute file on the mounted file system is corrupt.
.
Language=Polish
ERROR_EA_FILE_CORRUPT - Plik atrybutów rozszerzonych w zainstalowanym systemie plików jest uszkodzony.
.
Language=Romanian
ERROR_EA_FILE_CORRUPT - Fișierul cu tabela de atribute extinse de pe sistemul de fișiere montat este deteriorat.
.

MessageId=277
Severity=Success
Facility=System
SymbolicName=ERROR_EA_TABLE_FULL
Language=English
ERROR_EA_TABLE_FULL - The extended attribute table file is full.
.
Language=Russian
ERROR_EA_TABLE_FULL - The extended attribute table file is full.
.
Language=Polish
ERROR_EA_TABLE_FULL - Tabela atrybutów rozszerzonych jest zapełniona.
.
Language=Romanian
ERROR_EA_TABLE_FULL - Fișierul cu tabela de atribute extinse este plin.
.

MessageId=278
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EA_HANDLE
Language=English
ERROR_INVALID_EA_HANDLE - The specified extended attribute handle is invalid.
.
Language=Russian
ERROR_INVALID_EA_HANDLE - The specified extended attribute handle is invalid.
.
Language=Polish
ERROR_INVALID_EA_HANDLE - Określone dojście atrybutu rozszerzonego jest nieprawidłowe.
.
Language=Romanian
ERROR_INVALID_EA_HANDLE - Identificatorul de gestiune al atributului extins nu este valid.
.

MessageId=282
Severity=Success
Facility=System
SymbolicName=ERROR_EAS_NOT_SUPPORTED
Language=English
ERROR_EAS_NOT_SUPPORTED - The mounted file system does not support extended attributes.
.
Language=Russian
ERROR_EAS_NOT_SUPPORTED - The mounted file system does not support extended attributes.
.
Language=Polish
ERROR_EAS_NOT_SUPPORTED - Zainstalowany system plików nie obsługuje atrybutów rozszerzonych.
.
Language=Romanian
ERROR_EAS_NOT_SUPPORTED - Sistemul de fișiere atașat nu permite atribute extinse.
.

MessageId=288
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_OWNER
Language=English
ERROR_NOT_OWNER - Attempt to release mutex not owned by caller.
.
Language=Russian
ERROR_NOT_OWNER - Attempt to release mutex not owned by caller.
.
Language=Polish
ERROR_NOT_OWNER - Próbowano zwolnić mutex nie będący własnością wywołującego.
.
Language=Romanian
ERROR_NOT_OWNER - Tentativă de cedare a unui mutex în afara posesiei curente.
.

MessageId=298
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_POSTS
Language=English
ERROR_TOO_MANY_POSTS - Too many posts were made to a semaphore.
.
Language=Russian
ERROR_TOO_MANY_POSTS - Too many posts were made to a semaphore.
.
Language=Polish
ERROR_TOO_MANY_POSTS - Wykonano za dużo przesłań do semafora.
.
Language=Romanian
ERROR_TOO_MANY_POSTS - Număr de plasamente peste limită adresate unui semafor.
.

MessageId=299
Severity=Success
Facility=System
SymbolicName=ERROR_PARTIAL_COPY
Language=English
ERROR_PARTIAL_COPY - Only part of a ReadProcessMemory or WriteProcessMemory request was completed.
.
Language=Russian
ERROR_PARTIAL_COPY - Only part of a ReadProcessMemory or WriteProcessMemory request was completed.
.
Language=Polish
ERROR_PARTIAL_COPY - Ukończono tylko część żądania ReadProcessMemory lub WriteProcessMemory.
.
Language=Romanian
ERROR_PARTIAL_COPY - Cererea ReadProcessMemory sau WriteProcessMemory a fost îndeplinită doar parțial.
.

MessageId=300
Severity=Success
Facility=System
SymbolicName=ERROR_OPLOCK_NOT_GRANTED
Language=English
ERROR_OPLOCK_NOT_GRANTED - The oplock request is denied.
.
Language=Russian
ERROR_OPLOCK_NOT_GRANTED - The oplock request is denied.
.
Language=Polish
ERROR_OPLOCK_NOT_GRANTED - Odmowa żądania operacji oplock.
.
Language=Romanian
ERROR_OPLOCK_NOT_GRANTED - Cererea pentru blocare oportună (oplock) a fost respintă.
.

MessageId=301
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_OPLOCK_PROTOCOL
Language=English
ERROR_INVALID_OPLOCK_PROTOCOL - An invalid oplock acknowledgment was received by the system.
.
Language=Russian
ERROR_INVALID_OPLOCK_PROTOCOL - An invalid oplock acknowledgment was received by the system.
.
Language=Polish
ERROR_INVALID_OPLOCK_PROTOCOL - System odebrał nieprawidłowe potwierdzenie zablokowania operacji.
.
Language=Romanian
ERROR_INVALID_OPLOCK_PROTOCOL - Confirmarea primită pentru blocarea oportună (oplock) nu este validă.
.

MessageId=302
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_TOO_FRAGMENTED
Language=English
ERROR_DISK_TOO_FRAGMENTED - The volume is too fragmented to complete this operation.
.
Language=Russian
ERROR_DISK_TOO_FRAGMENTED - The volume is too fragmented to complete this operation.
.
Language=Polish
ERROR_DISK_TOO_FRAGMENTED - Wolumin jest zbyt pofragmentowany, aby ukończyć tę operację.
.
Language=Romanian
ERROR_DISK_TOO_FRAGMENTED - Volumul este prea fragmentat pentru a îndeplini această operație.
.

MessageId=303
Severity=Success
Facility=System
SymbolicName=ERROR_DELETE_PENDING
Language=English
ERROR_DELETE_PENDING - The file cannot be opened because it is in the process of being deleted.
.
Language=Russian
ERROR_DELETE_PENDING - The file cannot be opened because it is in the process of being deleted.
.
Language=Polish
ERROR_DELETE_PENDING - Nie można otworzyć pliku, ponieważ trwa proces jego usuwania.
.
Language=Romanian
ERROR_DELETE_PENDING - Fișierul nu poate fi deschis deoarece este în curs de ștergere.
.

MessageId=317
Severity=Success
Facility=System
SymbolicName=ERROR_MR_MID_NOT_FOUND
Language=English
ERROR_MR_MID_NOT_FOUND - The system cannot find message text for message number 0x%1 in the message file for %2.
.
Language=Russian
ERROR_MR_MID_NOT_FOUND - The system cannot find message text for message number 0x%1 in the message file for %2.
.
Language=Polish
ERROR_MR_MID_NOT_FOUND - System nie może znaleźć komunikatu dla numeru komunikatu 0x%1 w pliku komunikatów dla %2.
.
Language=Romanian
ERROR_MR_MID_NOT_FOUND - Textul pentru mesajul cu numărul 0x%1 din fișierul de mesaja pentru %2 nu a putut fi găsit.
.

MessageId=318
Severity=Success
Facility=System
SymbolicName=ERROR_SCOPE_NOT_FOUND
Language=English
ERROR_SCOPE_NOT_FOUND - The scope specified was not found.
.
Language=Russian
ERROR_SCOPE_NOT_FOUND - The scope specified was not found.
.
Language=Polish
ERROR_SCOPE_NOT_FOUND - Nie można odnaleźć określonego zakresu.
.
Language=Romanian
ERROR_SCOPE_NOT_FOUND - Domeniul de acțiune specificat nu a fost găsit.
.

MessageId=487
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ADDRESS
Language=English
ERROR_INVALID_ADDRESS - Attempt to access invalid address.
.
Language=Russian
ERROR_INVALID_ADDRESS - Attempt to access invalid address.
.
Language=Polish
ERROR_INVALID_ADDRESS - Próbowano uzyskać dostęp do nieprawidłowego adresu.
.
Language=Romanian
ERROR_INVALID_ADDRESS - Tentativă de acces a unei adrese nevalide.
.

MessageId=534
Severity=Success
Facility=System
SymbolicName=ERROR_ARITHMETIC_OVERFLOW
Language=English
ERROR_ARITHMETIC_OVERFLOW - Arithmetic result exceeded 32 bits.
.
Language=Russian
ERROR_ARITHMETIC_OVERFLOW - Arithmetic result exceeded 32 bits.
.
Language=Polish
ERROR_ARITHMETIC_OVERFLOW - Wynik arytmetyczny przekroczył 32 bity.
.
Language=Romanian
ERROR_ARITHMETIC_OVERFLOW - Rezultatul aritmetic depășește 32 de biți.
.

MessageId=535
Severity=Success
Facility=System
SymbolicName=ERROR_PIPE_CONNECTED
Language=English
ERROR_PIPE_CONNECTED - There is a process on other end of the pipe.
.
Language=Russian
ERROR_PIPE_CONNECTED - There is a process on other end of the pipe.
.
Language=Polish
ERROR_PIPE_CONNECTED - Na drugim końcu potoku jest proces.
.
Language=Romanian
ERROR_PIPE_CONNECTED - La celălalt capăt al conectorului (pipe) deja există un proces.
.

MessageId=536
Severity=Success
Facility=System
SymbolicName=ERROR_PIPE_LISTENING
Language=English
ERROR_PIPE_LISTENING - Waiting for a process to open the other end of the pipe.
.
Language=Russian
ERROR_PIPE_LISTENING - Waiting for a process to open the other end of the pipe.
.
Language=Polish
ERROR_PIPE_LISTENING - Oczekiwanie na otwarcie przez proces drugiego końca potoku.
.
Language=Romanian
ERROR_PIPE_LISTENING - Un proces este așteptat la capătul complementar al conectorului (pipe).
.

MessageId=537
Severity=Success
Facility=System
SymbolicName=ERROR_ACPI_ERROR
Language=English
ERROR_ACPI_ERROR - An error occurred in the ACPI subsystem.
.
Language=Russian
ERROR_ACPI_ERROR - An error occurred in the ACPI subsystem.
.
Language=Polish
ERROR_ACPI_ERROR - Wystąpił błąd w podsystemie ACPI.
.
Language=Romanian
ERROR_ACPI_ERROR - În subsistemul ACPI a apărut o eroare.
.

MessageId=538
Severity=Success
Facility=System
SymbolicName=ERROR_ABIOS_ERROR
Language=English
ERROR_ABIOS_ERROR - An error occurred in the ABIOS subsystem
.
Language=Russian
ERROR_ABIOS_ERROR - An error occurred in the ABIOS subsystem
.
Language=Polish
ERROR_ABIOS_ERROR - Wystąpił błąd w podsystemie ABIOS.
.
Language=Romanian
ERROR_ABIOS_ERROR - În subsistemul ABIOS a apărut o eroare.
.

MessageId=539
Severity=Success
Facility=System
SymbolicName=ERROR_WX86_WARNING
Language=English
ERROR_WX86_WARNING - A warning occurred in the WX86 subsystem.
.
Language=Russian
ERROR_WX86_WARNING - A warning occurred in the WX86 subsystem.
.
Language=Polish
ERROR_WX86_WARNING - Wystąpiło ostrzeżenie w podsystemie WX86.
.
Language=Romanian
ERROR_WX86_WARNING - Există un avertisment referitor la subsistemul WX86.
.

MessageId=540
Severity=Success
Facility=System
SymbolicName=ERROR_WX86_ERROR
Language=English
ERROR_WX86_ERROR - An error occurred in the WX86 subsystem.
.
Language=Russian
ERROR_WX86_ERROR - An error occurred in the WX86 subsystem.
.
Language=Polish
ERROR_WX86_ERROR - Wystąpił błąd w podsystemie WX86.
.
Language=Romanian
ERROR_WX86_ERROR - În subsistemul WX86 a apărut o eroare.
.

MessageId=541
Severity=Success
Facility=System
SymbolicName=ERROR_TIMER_NOT_CANCELED
Language=English
ERROR_TIMER_NOT_CANCELED - An attempt was made to cancel or set a timer that has an associated APC and the subject thread is not the thread that originally set the timer with an associated APC routine.
.
Language=Russian
ERROR_TIMER_NOT_CANCELED - An attempt was made to cancel or set a timer that has an associated APC and the subject thread is not the thread that originally set the timer with an associated APC routine.
.
Language=Polish
ERROR_TIMER_NOT_CANCELED - Podjęto próbę anulowania lub ustawienia czasomierza ze związaną procedurą APC, a aktualny wątek nie jest tym wątkiem, który pierwotnie ustawił czasomierz ze związaną procedurą APC.
.
Language=Romanian
ERROR_TIMER_NOT_CANCELED - A avut loc o încercare de a institui sau destitui un cronometru cu un APC asociat, însă firul de execuție nu este cel care a creat cronometrul cu APC asociat.
.

MessageId=542
Severity=Success
Facility=System
SymbolicName=ERROR_UNWIND
Language=English
ERROR_UNWIND - Unwind exception code.
.
Language=Russian
ERROR_UNWIND - Unwind exception code.
.
Language=Polish
ERROR_UNWIND - Kod wyjątku operacji unwind.
.
Language=Romanian
ERROR_UNWIND - Eșec la deducția codului de eroare.
.

MessageId=543
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_STACK
Language=English
ERROR_BAD_STACK - An invalid or unaligned stack was encountered during an unwind operation.
.
Language=Russian
ERROR_BAD_STACK - An invalid or unaligned stack was encountered during an unwind operation.
.
Language=Polish
ERROR_BAD_STACK - Podczas operacji unwind napotkano nieprawidłowy lub niewyrównany stos.
.
Language=Romanian
ERROR_BAD_STACK - Stivă nealiniată sau nevalidă în operația de deducție a unui cod de eroare.
.

MessageId=544
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_UNWIND_TARGET
Language=English
ERROR_INVALID_UNWIND_TARGET - An invalid unwind target was encountered during an unwind operation.
.
Language=Russian
ERROR_INVALID_UNWIND_TARGET - An invalid unwind target was encountered during an unwind operation.
.
Language=Polish
ERROR_INVALID_UNWIND_TARGET - Podczas operacji unwind napotkano nieprawidłowy obiekt docelowy operacji.
.
Language=Romanian
ERROR_INVALID_UNWIND_TARGET - Destinație nevalidă în operația de deducție a unui cod de eroare.
.

MessageId=545
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PORT_ATTRIBUTES
Language=English
ERROR_INVALID_PORT_ATTRIBUTES - Invalid Object Attributes specified to NtCreatePort or invalid Port Attributes specified to NtConnectPort
.
Language=Russian
ERROR_INVALID_PORT_ATTRIBUTES - Invalid Object Attributes specified to NtCreatePort or invalid Port Attributes specified to NtConnectPort
.
Language=Polish
ERROR_INVALID_PORT_ATTRIBUTES - Określono nieprawidłowe atrybuty obiektu dla NtCreatePort albo nieprawidłowe atrybuty portu dla NtConnectPort
.
Language=Romanian
ERROR_INVALID_PORT_ATTRIBUTES - Atribute nevalide de obiect sau de port specificate către NtCreatePort sau respectiv NtConnectPort.
.

MessageId=546
Severity=Success
Facility=System
SymbolicName=ERROR_PORT_MESSAGE_TOO_LONG
Language=English
ERROR_PORT_MESSAGE_TOO_LONG - Length of message passed to NtRequestPort or NtRequestWaitReplyPort was longer than the maximum message allowed by the port.
.
Language=Russian
ERROR_PORT_MESSAGE_TOO_LONG - Length of message passed to NtRequestPort or NtRequestWaitReplyPort was longer than the maximum message allowed by the port.
.
Language=Polish
ERROR_PORT_MESSAGE_TOO_LONG - Długość komunikatu przekazanego dla NtRequestPort lub NtRequestWaitReplyPort była większa niż maksimum dozwolone dla tego portu.
.
Language=Romanian
ERROR_PORT_MESSAGE_TOO_LONG - Lungimea mesajului specificat în NtRequestPort sau NtRequestWaitReplyPort depășește limita maximă permisă de port.
.

MessageId=547
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_QUOTA_LOWER
Language=English
ERROR_INVALID_QUOTA_LOWER - An attempt was made to lower a quota limit below the current usage.
.
Language=Russian
ERROR_INVALID_QUOTA_LOWER - An attempt was made to lower a quota limit below the current usage.
.
Language=Polish
ERROR_INVALID_QUOTA_LOWER - Podjęto próbę obniżenia ograniczeń zasobów poniżej aktualnego wykorzystania.
.
Language=Romanian
ERROR_INVALID_QUOTA_LOWER - A avut loc o încercare de a scădea limita cotei sub cea utilizată.
.

MessageId=548
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_ALREADY_ATTACHED
Language=English
ERROR_DEVICE_ALREADY_ATTACHED - An attempt was made to attach to a device that was already attached to another device.
.
Language=Russian
ERROR_DEVICE_ALREADY_ATTACHED - An attempt was made to attach to a device that was already attached to another device.
.
Language=Polish
ERROR_DEVICE_ALREADY_ATTACHED - Podjęto próbę dołączenia do urządzenia, które było już dołączone do innego urządzenia.
.
Language=Romanian
ERROR_DEVICE_ALREADY_ATTACHED - A avut loc o încercare de a atașa un dispozitiv deja atașat de un alt dispozitiv.
.

MessageId=549
Severity=Success
Facility=System
SymbolicName=ERROR_INSTRUCTION_MISALIGNMENT
Language=English
ERROR_INSTRUCTION_MISALIGNMENT - An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references.
.
Language=Russian
ERROR_INSTRUCTION_MISALIGNMENT - An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references.
.
Language=Polish
ERROR_INSTRUCTION_MISALIGNMENT - Podjęto próbę wykonania instrukcji pod niewyrównanym adresem, a system hosta nie obsługuje odwołań do niewyrównanych instrukcji.
.
Language=Romanian
ERROR_INSTRUCTION_MISALIGNMENT - A avut loc o încercare de a executa o instrucțiune de la o adresă nealiniată dar sistemul gazdă nu permite referințe la instrucțiuni nealiniate.
.

MessageId=550
Severity=Success
Facility=System
SymbolicName=ERROR_PROFILING_NOT_STARTED
Language=English
ERROR_PROFILING_NOT_STARTED - Profiling not started.
.
Language=Russian
ERROR_PROFILING_NOT_STARTED - Profiling not started.
.
Language=Polish
ERROR_PROFILING_NOT_STARTED - Nie rozpoczęto profilowania.
.
Language=Romanian
ERROR_PROFILING_NOT_STARTED - Profilarea nu este pornită.
.

MessageId=551
Severity=Success
Facility=System
SymbolicName=ERROR_PROFILING_NOT_STOPPED
Language=English
ERROR_PROFILING_NOT_STOPPED - Profiling not stopped.
.
Language=Russian
ERROR_PROFILING_NOT_STOPPED - Profiling not stopped.
.
Language=Polish
ERROR_PROFILING_NOT_STOPPED - Nie zatrzymano profilowania.
.
Language=Romanian
ERROR_PROFILING_NOT_STOPPED - Profiling not stopped.
.

MessageId=552
Severity=Success
Facility=System
SymbolicName=ERROR_COULD_NOT_INTERPRET
Language=English
ERROR_COULD_NOT_INTERPRET - The passed ACL did not contain the minimum required information.
.
Language=Russian
ERROR_COULD_NOT_INTERPRET - The passed ACL did not contain the minimum required information.
.
Language=Polish
ERROR_COULD_NOT_INTERPRET - Przekazane ACL nie zawierało wymaganego minimum informacji.
.
Language=Romanian
ERROR_COULD_NOT_INTERPRET - The passed ACL did not contain the minimum required information.
.

MessageId=553
Severity=Success
Facility=System
SymbolicName=ERROR_PROFILING_AT_LIMIT
Language=English
ERROR_PROFILING_AT_LIMIT - The number of active profiling objects is at the maximum and no more may be started.
.
Language=Russian
ERROR_PROFILING_AT_LIMIT - The number of active profiling objects is at the maximum and no more may be started.
.
Language=Polish
ERROR_PROFILING_AT_LIMIT - Liczba aktywnych obiektów profilowania jest maksymalna i nie można uruchomić ich więcej.
.
Language=Romanian
ERROR_PROFILING_AT_LIMIT - The number of active profiling objects is at the maximum and no more may be started.
.

MessageId=554
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_WAIT
Language=English
ERROR_CANT_WAIT - Used to indicate that an operation cannot continue without blocking for I/O.
.
Language=Russian
ERROR_CANT_WAIT - Used to indicate that an operation cannot continue without blocking for I/O.
.
Language=Polish
ERROR_CANT_WAIT - Wskazuje, że kontynuowanie operacji nie jest możliwe bez zablokowania jej dla We/Wy.
.
Language=Romanian
ERROR_CANT_WAIT - Used to indicate that an operation cannot continue without blocking for I/O.
.

MessageId=555
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_TERMINATE_SELF
Language=English
ERROR_CANT_TERMINATE_SELF - Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process.
.
Language=Russian
ERROR_CANT_TERMINATE_SELF - Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process.
.
Language=Polish
ERROR_CANT_TERMINATE_SELF - Wskazuje, że wątek próbował sam się zakończyć w domyślny sposób (tzw. NtTerminateThread z wartością NULL) i że był to ostatni wątek bieżącego procesu.
.
Language=Romanian
ERROR_CANT_TERMINATE_SELF - Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process.
.

MessageId=556
Severity=Success
Facility=System
SymbolicName=ERROR_UNEXPECTED_MM_CREATE_ERR
Language=English
ERROR_UNEXPECTED_MM_CREATE_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Russian
ERROR_UNEXPECTED_MM_CREATE_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Polish
ERROR_UNEXPECTED_MM_CREATE_ERR - Jeśli zwracany jest błąd MM, który nie jest zdefiniowany w standardowym filtrze FsRtl, to błąd jest konwertowany na jeden z poniższych błędów, który na pewno występuje w filtrze. W tym wypadku informacje ulegają utracie, ale filtr właściwie obsługuje dany wyjątek.
.
Language=Romanian
ERROR_UNEXPECTED_MM_CREATE_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.

MessageId=557
Severity=Success
Facility=System
SymbolicName=ERROR_UNEXPECTED_MM_MAP_ERROR
Language=English
ERROR_UNEXPECTED_MM_MAP_ERROR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Russian
ERROR_UNEXPECTED_MM_MAP_ERROR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Polish
ERROR_UNEXPECTED_MM_MAP_ERROR - Jeśli zwracany jest błąd MM, który nie jest zdefiniowany w standardowym filtrze FsRtl, to błąd jest konwertowany na jeden z poniższych błędów, który na pewno występuje w filtrze. W tym wypadku informacje ulegają utracie, ale filtr właściwie obsługuje dany wyjątek.
.
Language=Romanian
ERROR_UNEXPECTED_MM_MAP_ERROR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.

MessageId=558
Severity=Success
Facility=System
SymbolicName=ERROR_UNEXPECTED_MM_EXTEND_ERR
Language=English
ERROR_UNEXPECTED_MM_EXTEND_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Russian
ERROR_UNEXPECTED_MM_EXTEND_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.
Language=Polish
ERROR_UNEXPECTED_MM_EXTEND_ERR - Jeśli zwracany jest błąd MM, który nie jest zdefiniowany w standardowym filtrze FsRtl, to błąd jest konwertowany na jeden z poniższych błędów, który na pewno występuje w filtrze. W tym wypadku informacje ulegają utracie, ale filtr właściwie obsługuje dany wyjątek.
.
Language=Romanian
ERROR_UNEXPECTED_MM_EXTEND_ERR - If an MM error is returned which is not defined in the standard FsRtl filter, it is converted to one of the following errors which is guaranteed to be in the filter. In this case information is lost, however, the filter correctly handles the exception.
.

MessageId=559
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_FUNCTION_TABLE
Language=English
ERROR_BAD_FUNCTION_TABLE - A malformed function table was encountered during an unwind operation.
.
Language=Russian
ERROR_BAD_FUNCTION_TABLE - A malformed function table was encountered during an unwind operation.
.
Language=Polish
ERROR_BAD_FUNCTION_TABLE - Podczas operacji unwind napotkano wadliwie sformułowaną tabelę funkcji.
.
Language=Romanian
ERROR_BAD_FUNCTION_TABLE - A malformed function table was encountered during an unwind operation.
.

MessageId=560
Severity=Success
Facility=System
SymbolicName=ERROR_NO_GUID_TRANSLATION
Language=English
ERROR_NO_GUID_TRANSLATION - Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail.
.
Language=Russian
ERROR_NO_GUID_TRANSLATION - Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail.
.
Language=Polish
ERROR_NO_GUID_TRANSLATION - Wskazuje, że podjęto próbę przypisania zabezpieczenia dla pliku lub katalogu systemu plików. Przetłumaczenie jednego z identyfikatorów SID w deskryptorze zabezpieczeń na identyfikator GUID, który mógłby być przechowywany w systemie plików nie było możliwe. Powoduje to, że próba zabezpieczenia nie może się powieść i w konsekwencji nie może się powieść próba utworzenia pliku.
.
Language=Romanian
ERROR_NO_GUID_TRANSLATION - Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail.
.

MessageId=561
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LDT_SIZE
Language=English
ERROR_INVALID_LDT_SIZE - Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors.
.
Language=Russian
ERROR_INVALID_LDT_SIZE - Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors.
.
Language=Polish
ERROR_INVALID_LDT_SIZE - Wskazuje, że podjęto próbę powiększenia LDT przez ustawienie rozmiaru, albo że rozmiar nie odpowiadał parzystej liczbie selektorów.
.
Language=Romanian
ERROR_INVALID_LDT_SIZE - Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors.
.

MessageId=563
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LDT_OFFSET
Language=English
ERROR_INVALID_LDT_OFFSET - Indicates that the starting value for the LDT information was not an integral multiple of the selector size.
.
Language=Russian
ERROR_INVALID_LDT_OFFSET - Indicates that the starting value for the LDT information was not an integral multiple of the selector size.
.
Language=Polish
ERROR_INVALID_LDT_OFFSET - Wskazuje, że początkowa wartość dla informacji LDT nie była całkowitą wielokrotnością rozmiaru selektora.
.
Language=Romanian
ERROR_INVALID_LDT_OFFSET - Indicates that the starting value for the LDT information was not an integral multiple of the selector size.
.

MessageId=564
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LDT_DESCRIPTOR
Language=English
ERROR_INVALID_LDT_DESCRIPTOR - Indicates that the user supplied an invalid descriptor when trying to set up Ldt descriptors.
.
Language=Russian
ERROR_INVALID_LDT_DESCRIPTOR - Indicates that the user supplied an invalid descriptor when trying to set up Ldt descriptors.
.
Language=Polish
ERROR_INVALID_LDT_DESCRIPTOR - Wskazuje, że użytkownik podał nieprawidłowy deskryptor próbując ustawić deskryptory LDT.
.
Language=Romanian
ERROR_INVALID_LDT_DESCRIPTOR - Indicates that the user supplied an invalid descriptor when trying to set up Ldt descriptors.
.

MessageId=565
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_THREADS
Language=English
ERROR_TOO_MANY_THREADS - Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads.
.
Language=Russian
ERROR_TOO_MANY_THREADS - Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads.
.
Language=Polish
ERROR_TOO_MANY_THREADS - Wskazuje, że proces ma zbyt wiele wątków, aby wykonać żądaną akcję. Na przykład przypisanie podstawowego tokenu jest możliwe do wykonania tylko wtedy, gdy dany proces nie ma wątków lub ma jeden wątek.
.
Language=Romanian
ERROR_TOO_MANY_THREADS - Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads.
.

MessageId=566
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_NOT_IN_PROCESS
Language=English
ERROR_THREAD_NOT_IN_PROCESS - An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified.
.
Language=Russian
ERROR_THREAD_NOT_IN_PROCESS - An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified.
.
Language=Polish
ERROR_THREAD_NOT_IN_PROCESS - Podjęto próbę operowania na wątku w pewnym procesie, ale określony wątek nie znajduje się w określonym procesie.
.
Language=Romanian
ERROR_THREAD_NOT_IN_PROCESS - An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified.
.

MessageId=567
Severity=Success
Facility=System
SymbolicName=ERROR_PAGEFILE_QUOTA_EXCEEDED
Language=English
ERROR_PAGEFILE_QUOTA_EXCEEDED - Page file quota was exceeded.
.
Language=Russian
ERROR_PAGEFILE_QUOTA_EXCEEDED - Page file quota was exceeded.
.
Language=Polish
ERROR_PAGEFILE_QUOTA_EXCEEDED - Przekroczono ograniczenie rozmiaru pliku stronicowania.
.
Language=Romanian
ERROR_PAGEFILE_QUOTA_EXCEEDED - Page file quota was exceeded.
.

MessageId=568
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_SERVER_CONFLICT
Language=English
ERROR_LOGON_SERVER_CONFLICT - The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role.
.
Language=Russian
ERROR_LOGON_SERVER_CONFLICT - The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role.
.
Language=Polish
ERROR_LOGON_SERVER_CONFLICT - Uruchomienie tej usługi Netlogon nie było możliwe, ponieważ inna usługa Netlogon działająca w tej domenie wchodzi w konflikt z określoną funkcją.
.
Language=Romanian
ERROR_LOGON_SERVER_CONFLICT - The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role.
.

MessageId=569
Severity=Success
Facility=System
SymbolicName=ERROR_SYNCHRONIZATION_REQUIRED
Language=English
ERROR_SYNCHRONIZATION_REQUIRED - The SAM database on a Windows Server is significantly out of synchronization with the copy on the Domain Controller. A complete synchronization is required.
.
Language=Russian
ERROR_SYNCHRONIZATION_REQUIRED - The SAM database on a Windows Server is significantly out of synchronization with the copy on the Domain Controller. A complete synchronization is required.
.
Language=Polish
ERROR_SYNCHRONIZATION_REQUIRED - Baza danych SAM na serwerze Windows jest znacząco rozsynchronizowana z kopią znajdującą się na kontrolerze domeny. Wymagana jest pełna synchronizacja.
.
Language=Romanian
ERROR_SYNCHRONIZATION_REQUIRED - The SAM database on a Windows Server is significantly out of synchronization with the copy on the Domain Controller. A complete synchronization is required.
.

MessageId=570
Severity=Success
Facility=System
SymbolicName=ERROR_NET_OPEN_FAILED
Language=English
ERROR_NET_OPEN_FAILED - The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows Lan Manager Redirector to use in its internal error mapping routines.
.
Language=Russian
ERROR_NET_OPEN_FAILED - The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows Lan Manager Redirector to use in its internal error mapping routines.
.
Language=Polish
ERROR_NET_OPEN_FAILED - Wykonanie funkcji API o nazwie NtCreateFile nie powiodło się. Ten błąd nie powinien być nigdy zwracany do aplikacji, jest używany przez program Windows Lan Manager Redirector w procedurach mapowania błędów wewnętrznych.
.
Language=Romanian
ERROR_NET_OPEN_FAILED - The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows Lan Manager Redirector to use in its internal error mapping routines.
.

MessageId=571
Severity=Success
Facility=System
SymbolicName=ERROR_IO_PRIVILEGE_FAILED
Language=English
ERROR_IO_PRIVILEGE_FAILED - The I/O permissions for the process could not be changed.
.
Language=Russian
ERROR_IO_PRIVILEGE_FAILED - The I/O permissions for the process could not be changed.
.
Language=Polish
ERROR_IO_PRIVILEGE_FAILED - Nie udało się zmienić uprawnień We/Wy dla tego procesu.
.
Language=Romanian
ERROR_IO_PRIVILEGE_FAILED - The I/O permissions for the process could not be changed.
.

MessageId=572
Severity=Success
Facility=System
SymbolicName=ERROR_CONTROL_C_EXIT
Language=English
ERROR_CONTROL_C_EXIT - The application terminated as a result of a CTRL+C.
.
Language=Russian
ERROR_CONTROL_C_EXIT - The application terminated as a result of a CTRL+C.
.
Language=Polish
ERROR_CONTROL_C_EXIT - Aplikacja została zakończona w wyniku naciśnięcia klawiszy CTRL+C.
.
Language=Romanian
ERROR_CONTROL_C_EXIT - The application terminated as a result of a CTRL+C.
.

MessageId=573
Severity=Success
Facility=System
SymbolicName=ERROR_MISSING_SYSTEMFILE
Language=English
ERROR_MISSING_SYSTEMFILE - The required system file %hs is bad or missing.
.
Language=Russian
ERROR_MISSING_SYSTEMFILE - The required system file %hs is bad or missing.
.
Language=Polish
ERROR_MISSING_SYSTEMFILE - Wymagany plik systemowy %hs jest zły albo brak go.
.
Language=Romanian
ERROR_MISSING_SYSTEMFILE - The required system file %hs is bad or missing.
.

MessageId=574
Severity=Success
Facility=System
SymbolicName=ERROR_UNHANDLED_EXCEPTION
Language=English
ERROR_UNHANDLED_EXCEPTION - The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
.
Language=Russian
ERROR_UNHANDLED_EXCEPTION - The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
.
Language=Polish
ERROR_UNHANDLED_EXCEPTION - W aplikacji wystąpił wyjątek %s (0x%08lx) na pozycji 0x%08lx.
.
Language=Romanian
ERROR_UNHANDLED_EXCEPTION - The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
.

MessageId=575
Severity=Success
Facility=System
SymbolicName=ERROR_APP_INIT_FAILURE
Language=English
ERROR_APP_INIT_FAILURE - The application failed to initialize properly (0x%lx). Click on OK to terminate the application.
.
Language=Russian
ERROR_APP_INIT_FAILURE - The application failed to initialize properly (0x%lx). Click on OK to terminate the application.
.
Language=Polish
ERROR_APP_INIT_FAILURE - Aplikacja nie została właściwie uruchomiona (0x%lx). Kliknij przycisk OK, aby zakończyć aplikację.
.
Language=Romanian
ERROR_APP_INIT_FAILURE - The application failed to initialize properly (0x%lx). Click on OK to terminate the application.
.

MessageId=576
Severity=Success
Facility=System
SymbolicName=ERROR_PAGEFILE_CREATE_FAILED
Language=English
ERROR_PAGEFILE_CREATE_FAILED - The creation of the paging file %hs failed (%lx). The requested size was %ld.
.
Language=Russian
ERROR_PAGEFILE_CREATE_FAILED - The creation of the paging file %hs failed (%lx). The requested size was %ld.
.
Language=Polish
ERROR_PAGEFILE_CREATE_FAILED - Utworzenie pliku stronicowania %hs nie powiodło się (%lx). Żądanym rozmiarem było %ld.
.
Language=Romanian
ERROR_PAGEFILE_CREATE_FAILED - The creation of the paging file %hs failed (%lx). The requested size was %ld.
.

MessageId=578
Severity=Success
Facility=System
SymbolicName=ERROR_NO_PAGEFILE
Language=English
ERROR_NO_PAGEFILE - No paging file was specified in the system configuration.
.
Language=Russian
ERROR_NO_PAGEFILE - No paging file was specified in the system configuration.
.
Language=Polish
ERROR_NO_PAGEFILE - W konfiguracji systemu nie określono pliku stronicowania.
.
Language=Romanian
ERROR_NO_PAGEFILE - No paging file was specified in the system configuration.
.

MessageId=579
Severity=Success
Facility=System
SymbolicName=ERROR_ILLEGAL_FLOAT_CONTEXT
Language=English
ERROR_ILLEGAL_FLOAT_CONTEXT - A real-mode application issued a floating-point instruction and floating-point hardware is not present.
.
Language=Russian
ERROR_ILLEGAL_FLOAT_CONTEXT - A real-mode application issued a floating-point instruction and floating-point hardware is not present.
.
Language=Polish
ERROR_ILLEGAL_FLOAT_CONTEXT - Aplikacja trybu rzeczywistego wydała instrukcję zmiennoprzecinkową, tymczasem nie ma urządzenia zmiennoprzecinkowego.
.
Language=Romanian
ERROR_ILLEGAL_FLOAT_CONTEXT - A real-mode application issued a floating-point instruction and floating-point hardware is not present.
.

MessageId=580
Severity=Success
Facility=System
SymbolicName=ERROR_NO_EVENT_PAIR
Language=English
ERROR_NO_EVENT_PAIR - An event pair synchronization operation was performed using the thread specific client/server event pair object, but no event pair object was associated with the thread.
.
Language=Russian
ERROR_NO_EVENT_PAIR - An event pair synchronization operation was performed using the thread specific client/server event pair object, but no event pair object was associated with the thread.
.
Language=Polish
ERROR_NO_EVENT_PAIR - Wykonano operację synchronizacji pary zdarzeń używając właściwego dla wątku obiektu pary zdarzeń klient/serwer, ale żaden obiekt pary zdarzeń nie był związany z tym wątkiem.
.
Language=Romanian
ERROR_NO_EVENT_PAIR - An event pair synchronization operation was performed using the thread specific client/server event pair object, but no event pair object was associated with the thread.
.

MessageId=581
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_CTRLR_CONFIG_ERROR
Language=English
ERROR_DOMAIN_CTRLR_CONFIG_ERROR - A Windows Server has an incorrect configuration.
.
Language=Russian
ERROR_DOMAIN_CTRLR_CONFIG_ERROR - A Windows Server has an incorrect configuration.
.
Language=Polish
ERROR_DOMAIN_CTRLR_CONFIG_ERROR - Serwer Windows ma niepoprawną konfigurację.
.
Language=Romanian
ERROR_DOMAIN_CTRLR_CONFIG_ERROR - A Windows Server has an incorrect configuration.
.

MessageId=582
Severity=Success
Facility=System
SymbolicName=ERROR_ILLEGAL_CHARACTER
Language=English
ERROR_ILLEGAL_CHARACTER - An illegal character was encountered. For a multi-byte character set this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE.
.
Language=Russian
ERROR_ILLEGAL_CHARACTER - An illegal character was encountered. For a multi-byte character set this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE.
.
Language=Polish
ERROR_ILLEGAL_CHARACTER - Napotkano niedozwolony znak. W przypadku wielobajtowego zestawu znaków dotyczy to także wiodącego bajtu, po którym nie występuje żaden bajt pomocniczy. W przypadku zestawu znaków Unicode obejmuje to 0xFFFF i 0xFFFE.
.
Language=Romanian
ERROR_ILLEGAL_CHARACTER - An illegal character was encountered. For a multi-byte character set this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE.
.

MessageId=583
Severity=Success
Facility=System
SymbolicName=ERROR_UNDEFINED_CHARACTER
Language=English
ERROR_UNDEFINED_CHARACTER - The Unicode character is not defined in the Unicode character set installed on the system.
.
Language=Russian
ERROR_UNDEFINED_CHARACTER - The Unicode character is not defined in the Unicode character set installed on the system.
.
Language=Polish
ERROR_UNDEFINED_CHARACTER - Ten znak Unicode nie jest zdefiniowany w zestawie znaków Unicode zainstalowanym w tym systemie.
.
Language=Romanian
ERROR_UNDEFINED_CHARACTER - The Unicode character is not defined in the Unicode character set installed on the system.
.

MessageId=584
Severity=Success
Facility=System
SymbolicName=ERROR_FLOPPY_VOLUME
Language=English
ERROR_FLOPPY_VOLUME - The paging file cannot be created on a floppy diskette.
.
Language=Russian
ERROR_FLOPPY_VOLUME - The paging file cannot be created on a floppy diskette.
.
Language=Polish
ERROR_FLOPPY_VOLUME - Nie można utworzyć pliku stronicowania na dyskietce.
.
Language=Romanian
ERROR_FLOPPY_VOLUME - The paging file cannot be created on a floppy diskette.
.

MessageId=585
Severity=Success
Facility=System
SymbolicName=ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT
Language=English
ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT - The system bios failed to connect a system interrupt to the device or bus for which the device is connected.
.
Language=Russian
ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT - The system bios failed to connect a system interrupt to the device or bus for which the device is connected.
.
Language=Polish
ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT - System BIOS nie połączył przerwania systemowego z urządzeniem lub magistralą, do której urządzenie jest podłączone.
.
Language=Romanian
ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT - The system bios failed to connect a system interrupt to the device or bus for which the device is connected.
.

MessageId=586
Severity=Success
Facility=System
SymbolicName=ERROR_BACKUP_CONTROLLER
Language=English
ERROR_BACKUP_CONTROLLER - This operation is only allowed for the Primary Domain Controller of the domain.
.
Language=Russian
ERROR_BACKUP_CONTROLLER - This operation is only allowed for the Primary Domain Controller of the domain.
.
Language=Polish
ERROR_BACKUP_CONTROLLER - Ta operacja jest dozwolona tylko dla podstawowego kontrolera domeny.
.
Language=Romanian
ERROR_BACKUP_CONTROLLER - This operation is only allowed for the Primary Domain Controller of the domain.
.

MessageId=587
Severity=Success
Facility=System
SymbolicName=ERROR_MUTANT_LIMIT_EXCEEDED
Language=English
ERROR_MUTANT_LIMIT_EXCEEDED - An attempt was made to acquire a mutant such that its maximum count would have been exceeded.
.
Language=Russian
ERROR_MUTANT_LIMIT_EXCEEDED - An attempt was made to acquire a mutant such that its maximum count would have been exceeded.
.
Language=Polish
ERROR_MUTANT_LIMIT_EXCEEDED - Podjęto próbę uzyskania zmienionego obiektu w taki sposób, że zostałaby przekroczona maksymalna liczba takich obiektów.
.
Language=Romanian
ERROR_MUTANT_LIMIT_EXCEEDED - An attempt was made to acquire a mutant such that its maximum count would have been exceeded.
.

MessageId=588
Severity=Success
Facility=System
SymbolicName=ERROR_FS_DRIVER_REQUIRED
Language=English
ERROR_FS_DRIVER_REQUIRED - A volume has been accessed for which a file system driver is required that has not yet been loaded.
.
Language=Russian
ERROR_FS_DRIVER_REQUIRED - A volume has been accessed for which a file system driver is required that has not yet been loaded.
.
Language=Polish
ERROR_FS_DRIVER_REQUIRED - Uzyskano dostęp do woluminu, dla którego wymagany jest jeszcze nie załadowany sterownik systemu plików.
.
Language=Romanian
ERROR_FS_DRIVER_REQUIRED - A volume has been accessed for which a file system driver is required that has not yet been loaded.
.

MessageId=589
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_LOAD_REGISTRY_FILE
Language=English
ERROR_CANNOT_LOAD_REGISTRY_FILE - The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable.
.
Language=Russian
ERROR_CANNOT_LOAD_REGISTRY_FILE - The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable.
.
Language=Polish
ERROR_CANNOT_LOAD_REGISTRY_FILE - Nie jest możliwe załadowanie przez Rejestr gałęzi (pliku): %hs lub jego dziennika bądź drugiej kopii. Jest on uszkodzony, brak go lub jest nie do zapisania.
.
Language=Romanian
ERROR_CANNOT_LOAD_REGISTRY_FILE - The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable.
.

MessageId=590
Severity=Success
Facility=System
SymbolicName=ERROR_DEBUG_ATTACH_FAILED
Language=English
ERROR_DEBUG_ATTACH_FAILED - An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error.
.
Language=Russian
ERROR_DEBUG_ATTACH_FAILED - An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error.
.
Language=Polish
ERROR_DEBUG_ATTACH_FAILED - Niespodziewanie nie powiodło się przetwarzanie żądania procesu API DebugActiveProcess. Możesz wybrać "OK", aby zakończyć ten proces, albo "Anuluj", aby zignorować błąd.
.
Language=Romanian
ERROR_DEBUG_ATTACH_FAILED - An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error.
.

MessageId=591
Severity=Success
Facility=System
SymbolicName=ERROR_SYSTEM_PROCESS_TERMINATED
Language=English
ERROR_SYSTEM_PROCESS_TERMINATED - The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down.
.
Language=Russian
ERROR_SYSTEM_PROCESS_TERMINATED - The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down.
.
Language=Polish
ERROR_SYSTEM_PROCESS_TERMINATED - Proces systemowy %hs zakończył się niespodziewanie ze stanem 0x%08x (0x%08x 0x%08x). System zostanie zamknięty.
.
Language=Romanian
ERROR_SYSTEM_PROCESS_TERMINATED - The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down.
.

MessageId=592
Severity=Success
Facility=System
SymbolicName=ERROR_DATA_NOT_ACCEPTED
Language=English
ERROR_DATA_NOT_ACCEPTED - The TDI client could not handle the data received during an indication.
.
Language=Russian
ERROR_DATA_NOT_ACCEPTED - The TDI client could not handle the data received during an indication.
.
Language=Polish
ERROR_DATA_NOT_ACCEPTED - Obsługa danych otrzymanych przez klienta TDI podczas wskazywania nie jest możliwa.
.
Language=Romanian
ERROR_DATA_NOT_ACCEPTED - The TDI client could not handle the data received during an indication.
.

MessageId=593
Severity=Success
Facility=System
SymbolicName=ERROR_VDM_HARD_ERROR
Language=English
ERROR_VDM_HARD_ERROR - NTVDM encountered a hard error.
.
Language=Russian
ERROR_VDM_HARD_ERROR - NTVDM encountered a hard error.
.
Language=Polish
ERROR_VDM_HARD_ERROR - NTVDM napotkał poważny błąd.
.
Language=Romanian
ERROR_VDM_HARD_ERROR - NTVDM encountered a hard error.
.

MessageId=594
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVER_CANCEL_TIMEOUT
Language=English
ERROR_DRIVER_CANCEL_TIMEOUT - The driver %hs failed to complete a cancelled I/O request in the allotted time.
.
Language=Russian
ERROR_DRIVER_CANCEL_TIMEOUT - The driver %hs failed to complete a cancelled I/O request in the allotted time.
.
Language=Polish
ERROR_DRIVER_CANCEL_TIMEOUT - Sterownik %hs nie zdołał zakończyć anulowanego żądania We/Wy w przypisanym czasie.
.
Language=Romanian
ERROR_DRIVER_CANCEL_TIMEOUT - The driver %hs failed to complete a cancelled I/O request in the allotted time.
.

MessageId=595
Severity=Success
Facility=System
SymbolicName=ERROR_REPLY_MESSAGE_MISMATCH
Language=English
ERROR_REPLY_MESSAGE_MISMATCH - An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message.
.
Language=Russian
ERROR_REPLY_MESSAGE_MISMATCH - An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message.
.
Language=Polish
ERROR_REPLY_MESSAGE_MISMATCH - Próbowano odpowiedzieć na komunikat LPC, ale wątek określony przez identyfikator klienta w komunikacie nie oczekiwał na tę odpowiedź.
.
Language=Romanian
ERROR_REPLY_MESSAGE_MISMATCH - An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message.
.

MessageId=596
Severity=Success
Facility=System
SymbolicName=ERROR_LOST_WRITEBEHIND_DATA
Language=English
ERROR_LOST_WRITEBEHIND_DATA - Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere.
.
Language=Russian
ERROR_LOST_WRITEBEHIND_DATA - Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere.
.
Language=Polish
ERROR_LOST_WRITEBEHIND_DATA - System Windows nie mógł zapisać wszystkich danych dla pliku %hs. Dane zostały utracone. Powodem tego błędu mogła być awaria sprzętu komputerowego lub połączenia sieciowego. Spróbuj zapisać ten plik w innym miejscu.
.
Language=Romanian
ERROR_LOST_WRITEBEHIND_DATA - Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere.
.

MessageId=597
Severity=Success
Facility=System
SymbolicName=ERROR_CLIENT_SERVER_PARAMETERS_INVALID
Language=English
ERROR_CLIENT_SERVER_PARAMETERS_INVALID - The parameter(s) passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window.
.
Language=Russian
ERROR_CLIENT_SERVER_PARAMETERS_INVALID - The parameter(s) passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window.
.
Language=Polish
ERROR_CLIENT_SERVER_PARAMETERS_INVALID - Parametry przekazane do serwera we wspólnym oknie pamięci klient/serwer były nieprawidłowe. Zbyt wiele danych zostało umieszczonych we wspólnym oknie pamięci.
.
Language=Romanian
ERROR_CLIENT_SERVER_PARAMETERS_INVALID - The parameter(s) passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window.
.

MessageId=598
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_TINY_STREAM
Language=English
ERROR_NOT_TINY_STREAM - The stream is not a tiny stream.
.
Language=Russian
ERROR_NOT_TINY_STREAM - The stream is not a tiny stream.
.
Language=Polish
ERROR_NOT_TINY_STREAM - Ten strumień nie jest mały.
.
Language=Romanian
ERROR_NOT_TINY_STREAM - The stream is not a tiny stream.
.

MessageId=599
Severity=Success
Facility=System
SymbolicName=ERROR_STACK_OVERFLOW_READ
Language=English
ERROR_STACK_OVERFLOW_READ - The request must be handled by the stack overflow code.
.
Language=Russian
ERROR_STACK_OVERFLOW_READ - The request must be handled by the stack overflow code.
.
Language=Polish
ERROR_STACK_OVERFLOW_READ - To żądanie musi być obsługiwane przez kod przepełnienia stosu.
.
Language=Romanian
ERROR_STACK_OVERFLOW_READ - The request must be handled by the stack overflow code.
.

MessageId=600
Severity=Success
Facility=System
SymbolicName=ERROR_CONVERT_TO_LARGE
Language=English
ERROR_CONVERT_TO_LARGE - Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing onode is moved or the extent stream is converted to a large stream.
.
Language=Russian
ERROR_CONVERT_TO_LARGE - Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing onode is moved or the extent stream is converted to a large stream.
.
Language=Polish
ERROR_CONVERT_TO_LARGE - Wewnętrzne kody stanu OFS wskazują, jak jest obsługiwana operacja alokacji. Próba jest ponawiana po przeniesieniu węzła zawierającego onode, albo istniejący strumień jest konwertowany na duży potok.
.
Language=Romanian
ERROR_CONVERT_TO_LARGE - Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing onode is moved or the extent stream is converted to a large stream.
.

MessageId=601
Severity=Success
Facility=System
SymbolicName=ERROR_FOUND_OUT_OF_SCOPE
Language=English
ERROR_FOUND_OUT_OF_SCOPE - The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation.
.
Language=Russian
ERROR_FOUND_OUT_OF_SCOPE - The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation.
.
Language=Polish
ERROR_FOUND_OUT_OF_SCOPE - Próba znalezienia obiektu dała w efekcie obiekt na tym woluminie, mający odpowiedni identyfikator, ale znajdujący się poza zakresem dojścia użytego dla tej operacji.
.
Language=Romanian
ERROR_FOUND_OUT_OF_SCOPE - The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation.
.

MessageId=602
Severity=Success
Facility=System
SymbolicName=ERROR_ALLOCATE_BUCKET
Language=English
ERROR_ALLOCATE_BUCKET - The bucket array must be grown. Retry transaction after doing so.
.
Language=Russian
ERROR_ALLOCATE_BUCKET - The bucket array must be grown. Retry transaction after doing so.
.
Language=Polish
ERROR_ALLOCATE_BUCKET - Należy powiększyć tablicę typu "bucket array", a następnie spróbować ponownie wykonać transakcję.
.
Language=Romanian
ERROR_ALLOCATE_BUCKET - The bucket array must be grown. Retry transaction after doing so.
.

MessageId=603
Severity=Success
Facility=System
SymbolicName=ERROR_MARSHALL_OVERFLOW
Language=English
ERROR_MARSHALL_OVERFLOW - The user/kernel marshalling buffer has overflowed.
.
Language=Russian
ERROR_MARSHALL_OVERFLOW - The user/kernel marshalling buffer has overflowed.
.
Language=Polish
ERROR_MARSHALL_OVERFLOW - Bufor kierujący użytkownika/jądra został przepełniony.
.
Language=Romanian
ERROR_MARSHALL_OVERFLOW - The user/kernel marshalling buffer has overflowed.
.

MessageId=604
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_VARIANT
Language=English
ERROR_INVALID_VARIANT - The supplied variant structure contains invalid data.
.
Language=Russian
ERROR_INVALID_VARIANT - The supplied variant structure contains invalid data.
.
Language=Polish
ERROR_INVALID_VARIANT - Podana struktura wariantu zawiera nieprawidłowe dane.
.
Language=Romanian
ERROR_INVALID_VARIANT - The supplied variant structure contains invalid data.
.

MessageId=605
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_COMPRESSION_BUFFER
Language=English
ERROR_BAD_COMPRESSION_BUFFER - The specified buffer contains ill-formed data.
.
Language=Russian
ERROR_BAD_COMPRESSION_BUFFER - The specified buffer contains ill-formed data.
.
Language=Polish
ERROR_BAD_COMPRESSION_BUFFER - Określony bufor zawiera źle sformułowane dane.
.
Language=Romanian
ERROR_BAD_COMPRESSION_BUFFER - The specified buffer contains ill-formed data.
.

MessageId=606
Severity=Success
Facility=System
SymbolicName=ERROR_AUDIT_FAILED
Language=English
ERROR_AUDIT_FAILED - An attempt to generate a security audit failed.
.
Language=Russian
ERROR_AUDIT_FAILED - An attempt to generate a security audit failed.
.
Language=Polish
ERROR_AUDIT_FAILED - Próba wygenerowania inspekcji zabezpieczeń nie powiodła się.
.
Language=Romanian
ERROR_AUDIT_FAILED - An attempt to generate a security audit failed.
.

MessageId=607
Severity=Success
Facility=System
SymbolicName=ERROR_TIMER_RESOLUTION_NOT_SET
Language=English
ERROR_TIMER_RESOLUTION_NOT_SET - The timer resolution was not previously set by the current process.
.
Language=Russian
ERROR_TIMER_RESOLUTION_NOT_SET - The timer resolution was not previously set by the current process.
.
Language=Polish
ERROR_TIMER_RESOLUTION_NOT_SET - Rozdzielczość czasomierza nie została wcześniej ustawiona przez bieżący proces.
.
Language=Romanian
ERROR_TIMER_RESOLUTION_NOT_SET - The timer resolution was not previously set by the current process.
.

MessageId=608
Severity=Success
Facility=System
SymbolicName=ERROR_INSUFFICIENT_LOGON_INFO
Language=English
ERROR_INSUFFICIENT_LOGON_INFO - There is insufficient account information to log you on.
.
Language=Russian
ERROR_INSUFFICIENT_LOGON_INFO - There is insufficient account information to log you on.
.
Language=Polish
ERROR_INSUFFICIENT_LOGON_INFO - Nie podano informacji dotyczących konta niezbędnych do zalogowania.
.
Language=Romanian
ERROR_INSUFFICIENT_LOGON_INFO - There is insufficient account information to log you on.
.

MessageId=609
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DLL_ENTRYPOINT
Language=English
ERROR_BAD_DLL_ENTRYPOINT - The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly.
.
Language=Russian
ERROR_BAD_DLL_ENTRYPOINT - The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly.
.
Language=Polish
ERROR_BAD_DLL_ENTRYPOINT - Biblioteka dołączana dynamicznie %hs nie jest napisana poprawnie. Wskaźnik stosu pozostawiono w niespójnym stanie. Punkt wejścia powinien być zadeklarowany jako WINAPI lub STDCALL. Wybierz "TAK", aby zrezygnować z ładowania DLL. Wybierz "NIE", aby kontynuować wykonywanie DLL. Wybór "NIE" może spowodować niewłaściwe działanie aplikacji.
.
Language=Romanian
ERROR_BAD_DLL_ENTRYPOINT - The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly.
.

MessageId=610
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_SERVICE_ENTRYPOINT
Language=English
ERROR_BAD_SERVICE_ENTRYPOINT - The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly.
.
Language=Russian
ERROR_BAD_SERVICE_ENTRYPOINT - The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly.
.
Language=Polish
ERROR_BAD_SERVICE_ENTRYPOINT - Usługa %hs nie jest napisana poprawnie. Wskaźnik stosu pozostawiono w niespójnym stanie. Punkt wejścia wywołania zwrotnego usługi powinien być zadeklarowany jako WINAPI lub STDCALL. Wybierz "OK", aby kontynuować operacje usługi. Proces usługi może jednak działać niewłaściwie.
.
Language=Romanian
ERROR_BAD_SERVICE_ENTRYPOINT - The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly.
.

MessageId=611
Severity=Success
Facility=System
SymbolicName=ERROR_IP_ADDRESS_CONFLICT1
Language=English
ERROR_IP_ADDRESS_CONFLICT1 - There is an IP address conflict with another system on the network
.
Language=Russian
ERROR_IP_ADDRESS_CONFLICT1 - There is an IP address conflict with another system on the network
.
Language=Polish
ERROR_IP_ADDRESS_CONFLICT1 - Istnieje konflikt adresów IP z innym systemem w sieci.
.
Language=Romanian
ERROR_IP_ADDRESS_CONFLICT1 - There is an IP address conflict with another system on the network
.

MessageId=612
Severity=Success
Facility=System
SymbolicName=ERROR_IP_ADDRESS_CONFLICT2
Language=English
ERROR_IP_ADDRESS_CONFLICT2 - There is an IP address conflict with another system on the network
.
Language=Russian
ERROR_IP_ADDRESS_CONFLICT2 - There is an IP address conflict with another system on the network
.
Language=Polish
ERROR_IP_ADDRESS_CONFLICT2 - Istnieje konflikt adresów IP z innym systemem w sieci.
.
Language=Romanian
ERROR_IP_ADDRESS_CONFLICT2 - There is an IP address conflict with another system on the network
.

MessageId=613
Severity=Success
Facility=System
SymbolicName=ERROR_REGISTRY_QUOTA_LIMIT
Language=English
ERROR_REGISTRY_QUOTA_LIMIT - The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored.
.
Language=Russian
ERROR_REGISTRY_QUOTA_LIMIT - The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored.
.
Language=Polish
ERROR_REGISTRY_QUOTA_LIMIT - System osiągnął maksymalny rozmiar dozwolony dla części systemowej rejestru. Dodatkowe żądania przydziału miejsca będą ignorowane.
.
Language=Romanian
ERROR_REGISTRY_QUOTA_LIMIT - The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored.
.

MessageId=614
Severity=Success
Facility=System
SymbolicName=ERROR_NO_CALLBACK_ACTIVE
Language=English
ERROR_NO_CALLBACK_ACTIVE - A callback return system service cannot be executed when no callback is active.
.
Language=Russian
ERROR_NO_CALLBACK_ACTIVE - A callback return system service cannot be executed when no callback is active.
.
Language=Polish
ERROR_NO_CALLBACK_ACTIVE - Nie można wykonać usługi wywołania zwrotnego, gdy żadne wywołanie zwrotne nie jest aktywne.
.
Language=Romanian
ERROR_NO_CALLBACK_ACTIVE - A callback return system service cannot be executed when no callback is active.
.

MessageId=615
Severity=Success
Facility=System
SymbolicName=ERROR_PWD_TOO_SHORT
Language=English
ERROR_PWD_TOO_SHORT - The password provided is too short to meet the policy of your user account. Please choose a longer password.
.
Language=Russian
ERROR_PWD_TOO_SHORT - The password provided is too short to meet the policy of your user account. Please choose a longer password.
.
Language=Polish
ERROR_PWD_TOO_SHORT - Podane hasło jest zbyt krótkie, co jest niezgodne z zasadami wykorzystywania tego konta. Wybierz dłuższe hasło.
.
Language=Romanian
ERROR_PWD_TOO_SHORT - The password provided is too short to meet the policy of your user account. Please choose a longer password.
.

MessageId=616
Severity=Success
Facility=System
SymbolicName=ERROR_PWD_TOO_RECENT
Language=English
ERROR_PWD_TOO_RECENT - The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised then please contact your administrator immediately to have a new one assigned.
.
Language=Russian
ERROR_PWD_TOO_RECENT - The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised then please contact your administrator immediately to have a new one assigned.
.
Language=Polish
ERROR_PWD_TOO_RECENT - Zasady wykorzystywania tego konta użytkownika nie pozwalają na zbyt częste zmiany hasła. Ma to zapobiec zmianom hasła na wyrażenie łatwe do zapamiętania, ale i do złamania. Jeśli jednak podejrzewasz, że złamano twoje hasło, skontaktuj się niezwłocznie z administratorem, aby otrzymać nowe.
.
Language=Romanian
ERROR_PWD_TOO_RECENT - The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised then please contact your administrator immediately to have a new one assigned.
.

MessageId=617
Severity=Success
Facility=System
SymbolicName=ERROR_PWD_HISTORY_CONFLICT
Language=English
ERROR_PWD_HISTORY_CONFLICT - You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Please select a password that you have not previously used.
.
Language=Russian
ERROR_PWD_HISTORY_CONFLICT - You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Please select a password that you have not previously used.
.
Language=Polish
ERROR_PWD_HISTORY_CONFLICT - Próbowano zmienić hasło na takie, które było już używane w przeszłości. Jest to niezgodne z zasadami wykorzystywania tego konta. Wybierz inne hasło.
.
Language=Romanian
ERROR_PWD_HISTORY_CONFLICT - You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Please select a password that you have not previously used.
.

MessageId=618
Severity=Success
Facility=System
SymbolicName=ERROR_UNSUPPORTED_COMPRESSION
Language=English
ERROR_UNSUPPORTED_COMPRESSION - The specified compression format is unsupported.
.
Language=Russian
ERROR_UNSUPPORTED_COMPRESSION - The specified compression format is unsupported.
.
Language=Polish
ERROR_UNSUPPORTED_COMPRESSION - Określony format kompresji nie jest obsługiwany.
.
Language=Romanian
ERROR_UNSUPPORTED_COMPRESSION - The specified compression format is unsupported.
.

MessageId=619
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_HW_PROFILE
Language=English
ERROR_INVALID_HW_PROFILE - The specified hardware profile configuration is invalid.
.
Language=Russian
ERROR_INVALID_HW_PROFILE - The specified hardware profile configuration is invalid.
.
Language=Polish
ERROR_INVALID_HW_PROFILE - Określona konfiguracja profilu sprzętu jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_HW_PROFILE - The specified hardware profile configuration is invalid.
.

MessageId=620
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PLUGPLAY_DEVICE_PATH
Language=English
ERROR_INVALID_PLUGPLAY_DEVICE_PATH - The specified Plug and Play registry device path is invalid.
.
Language=Russian
ERROR_INVALID_PLUGPLAY_DEVICE_PATH - The specified Plug and Play registry device path is invalid.
.
Language=Polish
ERROR_INVALID_PLUGPLAY_DEVICE_PATH - Określona ścieżka Rejestru urządzenia typu „Plug and Play” jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_PLUGPLAY_DEVICE_PATH - The specified Plug and Play registry device path is invalid.
.

MessageId=621
Severity=Success
Facility=System
SymbolicName=ERROR_QUOTA_LIST_INCONSISTENT
Language=English
ERROR_QUOTA_LIST_INCONSISTENT - The specified quota list is internally inconsistent with its descriptor.
.
Language=Russian
ERROR_QUOTA_LIST_INCONSISTENT - The specified quota list is internally inconsistent with its descriptor.
.
Language=Polish
ERROR_QUOTA_LIST_INCONSISTENT - Określona lista zasobów jest wewnętrznie niezgodna ze swoim deskryptorem.
.
Language=Romanian
ERROR_QUOTA_LIST_INCONSISTENT - The specified quota list is internally inconsistent with its descriptor.
.

MessageId=622
Severity=Success
Facility=System
SymbolicName=ERROR_EVALUATION_EXPIRATION
Language=English
ERROR_EVALUATION_EXPIRATION - The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, please upgrade this installation using a licensed distribution of this product.
.
Language=Russian
ERROR_EVALUATION_EXPIRATION - The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, please upgrade this installation using a licensed distribution of this product.
.
Language=Polish
ERROR_EVALUATION_EXPIRATION - Okres tymczasowego użytkowania tej instalacji systemu Windows wygasł. System zostanie zamknięty za godzinę. Aby przywrócić dostęp do tej instalacji systemu Windows, uaktualnij instalację używając licencjonowanego produktu znajdującego się w dystrybucji.
.
Language=Romanian
ERROR_EVALUATION_EXPIRATION - The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, please upgrade this installation using a licensed distribution of this product.
.

MessageId=623
Severity=Success
Facility=System
SymbolicName=ERROR_ILLEGAL_DLL_RELOCATION
Language=English
ERROR_ILLEGAL_DLL_RELOCATION - The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL.
.
Language=Russian
ERROR_ILLEGAL_DLL_RELOCATION - The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL.
.
Language=Polish
ERROR_ILLEGAL_DLL_RELOCATION - Biblioteka systemowa DLL %hs została zrelokowana w pamięci. Aplikacja nie będzie działać prawidłowo. Powodem relokacji było to, że biblioteka DLL %hs zajmowała zakres adresów zarezerwowany dla systemowej biblioteki DLL. Należy skontaktować się z dostawcą w sprawie nowej biblioteki DLL.
.
Language=Romanian
ERROR_ILLEGAL_DLL_RELOCATION - The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL.
.

MessageId=624
Severity=Success
Facility=System
SymbolicName=ERROR_DLL_INIT_FAILED_LOGOFF
Language=English
ERROR_DLL_INIT_FAILED_LOGOFF - The application failed to initialize because the window station is shutting down.
.
Language=Russian
ERROR_DLL_INIT_FAILED_LOGOFF - The application failed to initialize because the window station is shutting down.
.
Language=Polish
ERROR_DLL_INIT_FAILED_LOGOFF - Zainicjowanie aplikacji nie udało się, gdyż stacja jest właśnie zamykana.
.
Language=Romanian
ERROR_DLL_INIT_FAILED_LOGOFF - The application failed to initialize because the window station is shutting down.
.

MessageId=625
Severity=Success
Facility=System
SymbolicName=ERROR_VALIDATE_CONTINUE
Language=English
ERROR_VALIDATE_CONTINUE - The validation process needs to continue on to the next step.
.
Language=Russian
ERROR_VALIDATE_CONTINUE - The validation process needs to continue on to the next step.
.
Language=Polish
ERROR_VALIDATE_CONTINUE - Proces sprawdzania poprawności musi być kontynuowany do następnego kroku.
.
Language=Romanian
ERROR_VALIDATE_CONTINUE - The validation process needs to continue on to the next step.
.

MessageId=626
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_MATCHES
Language=English
ERROR_NO_MORE_MATCHES - There are no more matches for the current index enumeration.
.
Language=Russian
ERROR_NO_MORE_MATCHES - There are no more matches for the current index enumeration.
.
Language=Polish
ERROR_NO_MORE_MATCHES - Nie ma więcej odpowiedników dla bieżącego wyliczania indeksu.
.
Language=Romanian
ERROR_NO_MORE_MATCHES - There are no more matches for the current index enumeration.
.

MessageId=627
Severity=Success
Facility=System
SymbolicName=ERROR_RANGE_LIST_CONFLICT
Language=English
ERROR_RANGE_LIST_CONFLICT - The range could not be added to the range list because of a conflict.
.
Language=Russian
ERROR_RANGE_LIST_CONFLICT - The range could not be added to the range list because of a conflict.
.
Language=Polish
ERROR_RANGE_LIST_CONFLICT - Z powodu konfliktu nie można dodać zakresu do listy zakresów.
.
Language=Romanian
ERROR_RANGE_LIST_CONFLICT - The range could not be added to the range list because of a conflict.
.

MessageId=628
Severity=Success
Facility=System
SymbolicName=ERROR_SERVER_SID_MISMATCH
Language=English
ERROR_SERVER_SID_MISMATCH - The server process is running under a SID different than that required by client.
.
Language=Russian
ERROR_SERVER_SID_MISMATCH - The server process is running under a SID different than that required by client.
.
Language=Polish
ERROR_SERVER_SID_MISMATCH - Proces serwera działa z innym identyfikatorem SID niż wymaga to klient.
.
Language=Romanian
ERROR_SERVER_SID_MISMATCH - The server process is running under a SID different than that required by client.
.

MessageId=629
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_ENABLE_DENY_ONLY
Language=English
ERROR_CANT_ENABLE_DENY_ONLY - A group marked use for deny only cannot be enabled.
.
Language=Russian
ERROR_CANT_ENABLE_DENY_ONLY - A group marked use for deny only cannot be enabled.
.
Language=Polish
ERROR_CANT_ENABLE_DENY_ONLY - Nie można włączyć grupy oznaczonej do użycia tylko dla odmowy.
.
Language=Romanian
ERROR_CANT_ENABLE_DENY_ONLY - A group marked use for deny only cannot be enabled.
.

MessageId=630
Severity=Success
Facility=System
SymbolicName=ERROR_FLOAT_MULTIPLE_FAULTS
Language=English
ERROR_FLOAT_MULTIPLE_FAULTS - Multiple floating point faults.
.
Language=Russian
ERROR_FLOAT_MULTIPLE_FAULTS - Multiple floating point faults.
.
Language=Polish
ERROR_FLOAT_MULTIPLE_FAULTS - Wiele błędów zmiennoprzecinkowych.
.
Language=Romanian
ERROR_FLOAT_MULTIPLE_FAULTS - Multiple floating point faults.
.

MessageId=631
Severity=Success
Facility=System
SymbolicName=ERROR_FLOAT_MULTIPLE_TRAPS
Language=English
ERROR_FLOAT_MULTIPLE_TRAPS - Multiple floating point traps.
.
Language=Russian
ERROR_FLOAT_MULTIPLE_TRAPS - Multiple floating point traps.
.
Language=Polish
ERROR_FLOAT_MULTIPLE_TRAPS - Wiele pułapek zmiennoprzecinkowych.
.
Language=Romanian
ERROR_FLOAT_MULTIPLE_TRAPS - Multiple floating point traps.
.

MessageId=632
Severity=Success
Facility=System
SymbolicName=ERROR_NOINTERFACE
Language=English
ERROR_NOINTERFACE - The requested interface is not supported.
.
Language=Russian
ERROR_NOINTERFACE - The requested interface is not supported.
.
Language=Polish
ERROR_NOINTERFACE - Żądany interfejs nie jest obsługiwany.
.
Language=Romanian
ERROR_NOINTERFACE - The requested interface is not supported.
.

MessageId=633
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVER_FAILED_SLEEP
Language=English
ERROR_DRIVER_FAILED_SLEEP - The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode.
.
Language=Russian
ERROR_DRIVER_FAILED_SLEEP - The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode.
.
Language=Polish
ERROR_DRIVER_FAILED_SLEEP - Sterownik %hs nie obsługuje trybu stanu wstrzymania. Aby system mógł się znaleźć w stanie wstrzymania należy zaktualizować sterownik.
.
Language=Romanian
ERROR_DRIVER_FAILED_SLEEP - The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode.
.

MessageId=634
Severity=Success
Facility=System
SymbolicName=ERROR_CORRUPT_SYSTEM_FILE
Language=English
ERROR_CORRUPT_SYSTEM_FILE - The system file %1 has become corrupt and has been replaced.
.
Language=Russian
ERROR_CORRUPT_SYSTEM_FILE - The system file %1 has become corrupt and has been replaced.
.
Language=Polish
ERROR_CORRUPT_SYSTEM_FILE - Plik systemowy %1 był uszkodzony i został zastąpiony.
.
Language=Romanian
ERROR_CORRUPT_SYSTEM_FILE - The system file %1 has become corrupt and has been replaced.
.

MessageId=635
Severity=Success
Facility=System
SymbolicName=ERROR_COMMITMENT_MINIMUM
Language=English
ERROR_COMMITMENT_MINIMUM - Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help.
.
Language=Russian
ERROR_COMMITMENT_MINIMUM - Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help.
.
Language=Polish
ERROR_COMMITMENT_MINIMUM - System ma za mało pamięci wirtualnej. System Windows zwiększa rozmiar pliku stronicowania pamięci wirtualnej. W czasie trwania tego procesu, może wystąpić odmowa na żądania pamięci niektórych aplikacji. Więcej informacji możesz znaleźć w Pomocy.
.
Language=Romanian
ERROR_COMMITMENT_MINIMUM - Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help.
.

MessageId=636
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_RESTART_ENUMERATION
Language=English
ERROR_PNP_RESTART_ENUMERATION - A device was removed so enumeration must be restarted.
.
Language=Russian
ERROR_PNP_RESTART_ENUMERATION - A device was removed so enumeration must be restarted.
.
Language=Polish
ERROR_PNP_RESTART_ENUMERATION - Urządzenie zostało usunięte, a więc wyliczanie musi zostać uruchomione ponownie.
.
Language=Romanian
ERROR_PNP_RESTART_ENUMERATION - A device was removed so enumeration must be restarted.
.

MessageId=637
Severity=Success
Facility=System
SymbolicName=ERROR_SYSTEM_IMAGE_BAD_SIGNATURE
Language=English
ERROR_SYSTEM_IMAGE_BAD_SIGNATURE - The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down.
.
Language=Russian
ERROR_SYSTEM_IMAGE_BAD_SIGNATURE - The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down.
.
Language=Polish
ERROR_SYSTEM_IMAGE_BAD_SIGNATURE - Obraz systemu %s nie jest poprawnie podpisany. Plik został zastąpiony plikiem podpisanym. System został zamknięty.
.
Language=Romanian
ERROR_SYSTEM_IMAGE_BAD_SIGNATURE - The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down.
.

MessageId=638
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_REBOOT_REQUIRED
Language=English
ERROR_PNP_REBOOT_REQUIRED - Device will not start without a reboot.
.
Language=Russian
ERROR_PNP_REBOOT_REQUIRED - Device will not start without a reboot.
.
Language=Polish
ERROR_PNP_REBOOT_REQUIRED - Urządzenie nie zostanie uruchomione bez ponownego rozruchu komputera.
.
Language=Romanian
ERROR_PNP_REBOOT_REQUIRED - Device will not start without a reboot.
.

MessageId=639
Severity=Success
Facility=System
SymbolicName=ERROR_INSUFFICIENT_POWER
Language=English
ERROR_INSUFFICIENT_POWER - There is not enough power to complete the requested operation.
.
Language=Russian
ERROR_INSUFFICIENT_POWER - There is not enough power to complete the requested operation.
.
Language=Polish
ERROR_INSUFFICIENT_POWER - Za mało energii, aby zakończyć żądaną operację
.
Language=Romanian
ERROR_INSUFFICIENT_POWER - There is not enough power to complete the requested operation.
.

MessageId=641
Severity=Success
Facility=System
SymbolicName=ERROR_SYSTEM_SHUTDOWN
Language=English
ERROR_SYSTEM_SHUTDOWN - The system is in the process of shutting down.
.
Language=Russian
ERROR_SYSTEM_SHUTDOWN - The system is in the process of shutting down.
.
Language=Polish
ERROR_SYSTEM_SHUTDOWN - Trwa proces zamykania systemu.
.
Language=Romanian
ERROR_SYSTEM_SHUTDOWN - The system is in the process of shutting down.
.

MessageId=642
Severity=Success
Facility=System
SymbolicName=ERROR_PORT_NOT_SET
Language=English
ERROR_PORT_NOT_SET - An attempt to remove a processes DebugPort was made, but a port was not already associated with the process.
.
Language=Russian
ERROR_PORT_NOT_SET - An attempt to remove a processes DebugPort was made, but a port was not already associated with the process.
.
Language=Polish
ERROR_PORT_NOT_SET - Podjęto próbę usunięcia portu DebugPort, ale żaden port nie był już skojarzony z danym procesem
.
Language=Romanian
ERROR_PORT_NOT_SET - An attempt to remove a processes DebugPort was made, but a port was not already associated with the process.
.

MessageId=643
Severity=Success
Facility=System
SymbolicName=ERROR_DS_VERSION_CHECK_FAILURE
Language=English
ERROR_DS_VERSION_CHECK_FAILURE - This version of Windows is not compatible with the behavior version of directory forest, domain or domain controller.
.
Language=Russian
ERROR_DS_VERSION_CHECK_FAILURE - This version of Windows is not compatible with the behavior version of directory forest, domain or domain controller.
.
Language=Polish
ERROR_DS_VERSION_CHECK_FAILURE - Ta wersja systemu Windows jest niezgodna z wersją zachowania lasu katalogów, domeny lub kontrolera domeny.
.
Language=Romanian
ERROR_DS_VERSION_CHECK_FAILURE - This version of Windows is not compatible with the behavior version of directory forest, domain or domain controller.
.

MessageId=644
Severity=Success
Facility=System
SymbolicName=ERROR_RANGE_NOT_FOUND
Language=English
ERROR_RANGE_NOT_FOUND - The specified range could not be found in the range list.
.
Language=Russian
ERROR_RANGE_NOT_FOUND - The specified range could not be found in the range list.
.
Language=Polish
ERROR_RANGE_NOT_FOUND - Na liście zakresów nie można znaleźć określonego zakresu.
.
Language=Romanian
ERROR_RANGE_NOT_FOUND - The specified range could not be found in the range list.
.

MessageId=646
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SAFE_MODE_DRIVER
Language=English
ERROR_NOT_SAFE_MODE_DRIVER - The driver was not loaded because the system is booting into safe mode.
.
Language=Russian
ERROR_NOT_SAFE_MODE_DRIVER - The driver was not loaded because the system is booting into safe mode.
.
Language=Polish
ERROR_NOT_SAFE_MODE_DRIVER - Sterownik nie został załadowany, ponieważ system jest uruchamiany w trybie awaryjnym.
.
Language=Romanian
ERROR_NOT_SAFE_MODE_DRIVER - The driver was not loaded because the system is booting into safe mode.
.

MessageId=647
Severity=Success
Facility=System
SymbolicName=ERROR_FAILED_DRIVER_ENTRY
Language=English
ERROR_FAILED_DRIVER_ENTRY - The driver was not loaded because it failed it's initialization call.
.
Language=Russian
ERROR_FAILED_DRIVER_ENTRY - The driver was not loaded because it failed it's initialization call.
.
Language=Polish
ERROR_FAILED_DRIVER_ENTRY - Sterownik nie został załadowany, ponieważ nie powiodło się wywołanie jego inicjalizacji.
.
Language=Romanian
ERROR_FAILED_DRIVER_ENTRY - The driver was not loaded because it failed it's initialization call.
.

MessageId=648
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_ENUMERATION_ERROR
Language=English
ERROR_DEVICE_ENUMERATION_ERROR - The \"%hs\" encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection.
.
Language=Russian
ERROR_DEVICE_ENUMERATION_ERROR - The \"%hs\" encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection.
.
Language=Polish
ERROR_DEVICE_ENUMERATION_ERROR - 	Sterownik "%hs" napotkał błąd, stosując zasilanie lub odczytując konfigurację urządzenia. Przyczyną może być awaria sprzętu lub złe połączenie.
.
Language=Romanian
ERROR_DEVICE_ENUMERATION_ERROR - The \"%hs\" encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection.
.

MessageId=649
Severity=Success
Facility=System
SymbolicName=ERROR_MOUNT_POINT_NOT_RESOLVED
Language=English
ERROR_MOUNT_POINT_NOT_RESOLVED - The create operation failed because the name contained at least one mount point which resolves to a volume to which the specified device object is not attached.
.
Language=Russian
ERROR_MOUNT_POINT_NOT_RESOLVED - The create operation failed because the name contained at least one mount point which resolves to a volume to which the specified device object is not attached.
.
Language=Polish
ERROR_MOUNT_POINT_NOT_RESOLVED - Operacja tworzenia nie powiodła się, ponieważ dana nazwa zawierała przynajmniej jeden punkt instalacji rozpoznawany jako wolumin, do którego określone urządzenie nie jest dołączone.
.
Language=Romanian
ERROR_MOUNT_POINT_NOT_RESOLVED - The create operation failed because the name contained at least one mount point which resolves to a volume to which the specified device object is not attached.
.

MessageId=650
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DEVICE_OBJECT_PARAMETER
Language=English
ERROR_INVALID_DEVICE_OBJECT_PARAMETER - The device object parameter is either not a valid device object or is not attached to the volume specified by the file name.
.
Language=Russian
ERROR_INVALID_DEVICE_OBJECT_PARAMETER - The device object parameter is either not a valid device object or is not attached to the volume specified by the file name.
.
Language=Polish
ERROR_INVALID_DEVICE_OBJECT_PARAMETER - Parametr obiektu urządzenia określa urządzenie, które albo nie jest prawidłowym obiektem urządzenia, albo nie jest dołączone do woluminu określonego przez nazwę pliku.
.
Language=Romanian
ERROR_INVALID_DEVICE_OBJECT_PARAMETER - The device object parameter is either not a valid device object or is not attached to the volume specified by the file name.
.

MessageId=651
Severity=Success
Facility=System
SymbolicName=ERROR_MCA_OCCURED
Language=English
ERROR_MCA_OCCURED - A Machine Check Error has occurred. Please check the system eventlog for additional information.
.
Language=Russian
ERROR_MCA_OCCURED - A Machine Check Error has occurred. Please check the system eventlog for additional information.
.
Language=Polish
ERROR_MCA_OCCURED - Wystąpił błąd sprawdzania komputera. Dodatkowe informacje można znaleźć w dzienniku zdarzeń systemowych.
.
Language=Romanian
ERROR_MCA_OCCURED - A Machine Check Error has occurred. Please check the system eventlog for additional information.
.

MessageId=652
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVER_DATABASE_ERROR
Language=English
ERROR_DRIVER_DATABASE_ERROR - There was error [%2] processing the driver database.
.
Language=Russian
ERROR_DRIVER_DATABASE_ERROR - There was error [%2] processing the driver database.
.
Language=Polish
ERROR_DRIVER_DATABASE_ERROR - Wystąpił błąd [%2] podczas przetwarzania bazy danych sterowników.
.
Language=Romanian
ERROR_DRIVER_DATABASE_ERROR - There was error [%2] processing the driver database.
.

MessageId=653
Severity=Success
Facility=System
SymbolicName=ERROR_SYSTEM_HIVE_TOO_LARGE
Language=English
ERROR_SYSTEM_HIVE_TOO_LARGE - System hive size has exceeded its limit.
.
Language=Russian
ERROR_SYSTEM_HIVE_TOO_LARGE - System hive size has exceeded its limit.
.
Language=Polish
ERROR_SYSTEM_HIVE_TOO_LARGE - Przekroczono limit rozmiaru gałęzi systemu.
.
Language=Romanian
ERROR_SYSTEM_HIVE_TOO_LARGE - System hive size has exceeded its limit.
.

MessageId=654
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVER_FAILED_PRIOR_UNLOAD
Language=English
ERROR_DRIVER_FAILED_PRIOR_UNLOAD - The driver could not be loaded because a previous version of the driver is still in memory.
.
Language=Russian
ERROR_DRIVER_FAILED_PRIOR_UNLOAD - The driver could not be loaded because a previous version of the driver is still in memory.
.
Language=Polish
ERROR_DRIVER_FAILED_PRIOR_UNLOAD - Nie można załadować sterownika, ponieważ jego poprzednia wersja nadal znajduje się w pamięci.
.
Language=Romanian
ERROR_DRIVER_FAILED_PRIOR_UNLOAD - The driver could not be loaded because a previous version of the driver is still in memory.
.

MessageId=655
Severity=Success
Facility=System
SymbolicName=ERROR_VOLSNAP_PREPARE_HIBERNATE
Language=English
ERROR_VOLSNAP_PREPARE_HIBERNATE - Please wait while the Volume Shadow Copy Service prepares volume %hs for hibernation.
.
Language=Russian
ERROR_VOLSNAP_PREPARE_HIBERNATE - Please wait while the Volume Shadow Copy Service prepares volume %hs for hibernation.
.
Language=Polish
ERROR_VOLSNAP_PREPARE_HIBERNATE - Zaczekaj, aż usługa kopii woluminu w tle przygotuje wolumin %hs do hibernacji.
.
Language=Romanian
ERROR_VOLSNAP_PREPARE_HIBERNATE - Please wait while the Volume Shadow Copy Service prepares volume %hs for hibernation.
.

MessageId=656
Severity=Success
Facility=System
SymbolicName=ERROR_HIBERNATION_FAILURE
Language=English
ERROR_HIBERNATION_FAILURE - The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted.
.
Language=Russian
ERROR_HIBERNATION_FAILURE - The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted.
.
Language=Polish
ERROR_HIBERNATION_FAILURE - System nie może wykonać hibernacji (kod błędu: %hs). Hibernacja będzie wyłączona do czasu ponownego uruchomienia systemu.
.
Language=Romanian
ERROR_HIBERNATION_FAILURE - The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted.
.

MessageId=657
Severity=Success
Facility=System
SymbolicName=ERROR_HUNG_DISPLAY_DRIVER_THREAD
Language=English
ERROR_HUNG_DISPLAY_DRIVER_THREAD - The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft.
.
Language=Russian
ERROR_HUNG_DISPLAY_DRIVER_THREAD - The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft.
.
Language=Polish
ERROR_HUNG_DISPLAY_DRIVER_THREAD - Sterownik ekranu %hs przestał normalnie pracować. Zapisz pracę i dokonaj ponownego rozruchu systemu, aby przywrócić wszystkie funkcje ekranu. Przy następnym ponownym rozruchu komputera zostanie wyświetlone okno dialogowe umożliwiające zgłoszenie tego błędu firmie Microsoft.
.
Language=Romanian
ERROR_HUNG_DISPLAY_DRIVER_THREAD - The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft.
.

MessageId=665
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_SYSTEM_LIMITATION
Language=English
ERROR_FILE_SYSTEM_LIMITATION - The requested operation could not be completed due to a file system limitation.
.
Language=Russian
ERROR_FILE_SYSTEM_LIMITATION - The requested operation could not be completed due to a file system limitation.
.
Language=Polish
ERROR_FILE_SYSTEM_LIMITATION - Nie można ukończyć żądanej operacji z powodu ograniczenia systemu plików.
.
Language=Romanian
ERROR_FILE_SYSTEM_LIMITATION - The requested operation could not be completed due to a file system limitation.
.

MessageId=668
Severity=Success
Facility=System
SymbolicName=ERROR_ASSERTION_FAILURE
Language=English
ERROR_ASSERTION_FAILURE - An assertion failure has occurred.
.
Language=Russian
ERROR_ASSERTION_FAILURE - An assertion failure has occurred.
.
Language=Polish
ERROR_ASSERTION_FAILURE - Wystąpił błąd potwierdzenia.
.
Language=Romanian
ERROR_ASSERTION_FAILURE - An assertion failure has occurred.
.

MessageId=669
Severity=Success
Facility=System
SymbolicName=ERROR_VERIFIER_STOP
Language=English
ERROR_VERIFIER_STOP - Application verifier has found an error in the current process.
.
Language=Russian
ERROR_VERIFIER_STOP - Application verifier has found an error in the current process.
.
Language=Polish
ERROR_VERIFIER_STOP - Weryfikator aplikacji napotkał błąd w bieżącym procesie.
.
Language=Romanian
ERROR_VERIFIER_STOP - Application verifier has found an error in the current process.
.

MessageId=670
Severity=Success
Facility=System
SymbolicName=ERROR_WOW_ASSERTION
Language=English
ERROR_WOW_ASSERTION - WOW Assertion Error.
.
Language=Russian
ERROR_WOW_ASSERTION - WOW Assertion Error.
.
Language=Polish
ERROR_WOW_ASSERTION - Błąd potwierdzenia WOW.
.
Language=Romanian
ERROR_WOW_ASSERTION - WOW Assertion Error.
.

MessageId=671
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_BAD_MPS_TABLE
Language=English
ERROR_PNP_BAD_MPS_TABLE - A device is missing in the system BIOS MPS table. This device will not be used. Please contact your system vendor for system BIOS update.
.
Language=Russian
ERROR_PNP_BAD_MPS_TABLE - A device is missing in the system BIOS MPS table. This device will not be used. Please contact your system vendor for system BIOS update.
.
Language=Polish
ERROR_PNP_BAD_MPS_TABLE - Brak urządzenia w tabeli MPS systemu BIOS. Urządzenie nie zostanie użyte. Skontaktuj się z producentem, aby otrzymać aktualizację systemu BIOS.
.
Language=Romanian
ERROR_PNP_BAD_MPS_TABLE - A device is missing in the system BIOS MPS table. This device will not be used. Please contact your system vendor for system BIOS update.
.

MessageId=672
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_TRANSLATION_FAILED
Language=English
ERROR_PNP_TRANSLATION_FAILED - A translator failed to translate resources.
.
Language=Russian
ERROR_PNP_TRANSLATION_FAILED - A translator failed to translate resources.
.
Language=Polish
ERROR_PNP_TRANSLATION_FAILED - Translator nie może zinterpretować zasobów.
.
Language=Romanian
ERROR_PNP_TRANSLATION_FAILED - A translator failed to translate resources.
.

MessageId=673
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_IRQ_TRANSLATION_FAILED
Language=English
ERROR_PNP_IRQ_TRANSLATION_FAILED - A IRQ translator failed to translate resources.
.
Language=Russian
ERROR_PNP_IRQ_TRANSLATION_FAILED - A IRQ translator failed to translate resources.
.
Language=Polish
ERROR_PNP_IRQ_TRANSLATION_FAILED - Translator IRQ nie może zinterpretować zasobów.
.
Language=Romanian
ERROR_PNP_IRQ_TRANSLATION_FAILED - A IRQ translator failed to translate resources.
.

MessageId=674
Severity=Success
Facility=System
SymbolicName=ERROR_PNP_INVALID_ID
Language=English
ERROR_PNP_INVALID_ID - Driver %2 returned invalid ID for a child device (%3).
.
Language=Russian
ERROR_PNP_INVALID_ID - Driver %2 returned invalid ID for a child device (%3).
.
Language=Polish
ERROR_PNP_INVALID_ID - Sterownik %2 zwrócił nieprawidłowy identyfikator urządzenia podrzędnego (%3).
.
Language=Romanian
ERROR_PNP_INVALID_ID - Driver %2 returned invalid ID for a child device (%3).
.

MessageId=675
Severity=Success
Facility=System
SymbolicName=ERROR_WAKE_SYSTEM_DEBUGGER
Language=English
ERROR_WAKE_SYSTEM_DEBUGGER - The system debugger was awakened by an interrupt.
.
Language=Russian
ERROR_WAKE_SYSTEM_DEBUGGER - The system debugger was awakened by an interrupt.
.
Language=Polish
ERROR_WAKE_SYSTEM_DEBUGGER - Przerwanie uaktywniło debuger systemu.
.
Language=Romanian
ERROR_WAKE_SYSTEM_DEBUGGER - The system debugger was awakened by an interrupt.
.

MessageId=676
Severity=Success
Facility=System
SymbolicName=ERROR_HANDLES_CLOSED
Language=English
ERROR_HANDLES_CLOSED - Handles to objects have been automatically closed as a result of the requested operation.
.
Language=Russian
ERROR_HANDLES_CLOSED - Handles to objects have been automatically closed as a result of the requested operation.
.
Language=Polish
ERROR_HANDLES_CLOSED - Dojścia do obiektów zostały automatycznie zamknięte w wyniku żądanej operacji.
.
Language=Romanian
ERROR_HANDLES_CLOSED - Handles to objects have been automatically closed as a result of the requested operation.
.

MessageId=677
Severity=Success
Facility=System
SymbolicName=ERROR_EXTRANEOUS_INFORMATION
Language=English
ERROR_EXTRANEOUS_INFORMATION - The specified access control list (ACL) contained more information than was expected.
.
Language=Russian
ERROR_EXTRANEOUS_INFORMATION - The specified access control list (ACL) contained more information than was expected.
.
Language=Polish
ERROR_EXTRANEOUS_INFORMATION - Określona lista kontroli dostępu (ACL) zawiera więcej informacji niż oczekiwano.
.
Language=Romanian
ERROR_EXTRANEOUS_INFORMATION - The specified access control list (ACL) contained more information than was expected.
.

MessageId=678
Severity=Success
Facility=System
SymbolicName=ERROR_RXACT_COMMIT_NECESSARY
Language=English
ERROR_RXACT_COMMIT_NECESSARY - This warning level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has NOT been completed, but has not been rolled back either (so it may still be committed if desired).
.
Language=Russian
ERROR_RXACT_COMMIT_NECESSARY - This warning level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has NOT been completed, but has not been rolled back either (so it may still be committed if desired).
.
Language=Polish
ERROR_RXACT_COMMIT_NECESSARY - Ten stan poziomu ostrzeżenia wskazuje, że dla danego poddrzewa Rejestru istnieje już stan transakcji, ale zlecenie transakcji zostało wcześniej przerwane. Transakcja NIE została zlecona, ale nie była też zwrócona (zatem może być z łatwością zlecona w razie potrzeby).
.
Language=Romanian
ERROR_RXACT_COMMIT_NECESSARY - This warning level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has NOT been completed, but has not been rolled back either (so it may still be committed if desired).
.

MessageId=679
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_CHECK
Language=English
ERROR_MEDIA_CHECK - The media may have changed.
.
Language=Russian
ERROR_MEDIA_CHECK - The media may have changed.
.
Language=Polish
ERROR_MEDIA_CHECK - Nośnik mógł się zmienić.
.
Language=Romanian
ERROR_MEDIA_CHECK - The media may have changed.
.

MessageId=680
Severity=Success
Facility=System
SymbolicName=ERROR_GUID_SUBSTITUTION_MADE
Language=English
ERROR_GUID_SUBSTITUTION_MADE - During the translation of a global identifier (GUID) to a Windows security ID (SID), no administratively-defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended.
.
Language=Russian
ERROR_GUID_SUBSTITUTION_MADE - During the translation of a global identifier (GUID) to a Windows security ID (SID), no administratively-defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended.
.
Language=Polish
ERROR_GUID_SUBSTITUTION_MADE - Podczas tłumaczenia globalnego identyfikatora (GUID) na identyfikator zabezpieczeń Windows NT nie znaleziono zdefiniowanego administracyjnie prefiksu GUID. Użyto zamiast tego zastępczego prefiksu, który nie wpłynie na bezpieczeństwo systemu. Może to jednak ograniczyć dostęp bardziej niż zamierzano.
.
Language=Romanian
ERROR_GUID_SUBSTITUTION_MADE - During the translation of a global identifier (GUID) to a Windows security ID (SID), no administratively-defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended.
.

MessageId=681
Severity=Success
Facility=System
SymbolicName=ERROR_STOPPED_ON_SYMLINK
Language=English
ERROR_STOPPED_ON_SYMLINK - The create operation stopped after reaching a symbolic link.
.
Language=Russian
ERROR_STOPPED_ON_SYMLINK - The create operation stopped after reaching a symbolic link.
.
Language=Polish
ERROR_STOPPED_ON_SYMLINK - Operacja tworzenia została zatrzymana po napotkaniu łącza symbolicznego.
.
Language=Romanian
ERROR_STOPPED_ON_SYMLINK - The create operation stopped after reaching a symbolic link.
.

MessageId=682
Severity=Success
Facility=System
SymbolicName=ERROR_LONGJUMP
Language=English
ERROR_LONGJUMP - A long jump has been executed.
.
Language=Russian
ERROR_LONGJUMP - A long jump has been executed.
.
Language=Polish
ERROR_LONGJUMP - Wykonano długi skok.
.
Language=Romanian
ERROR_LONGJUMP - A long jump has been executed.
.

MessageId=683
Severity=Success
Facility=System
SymbolicName=ERROR_PLUGPLAY_QUERY_VETOED
Language=English
ERROR_PLUGPLAY_QUERY_VETOED - The Plug and Play query operation was not successful.
.
Language=Russian
ERROR_PLUGPLAY_QUERY_VETOED - The Plug and Play query operation was not successful.
.
Language=Polish
ERROR_PLUGPLAY_QUERY_VETOED - Operacja zapytania Plug and Play zakończyła się niepomyślnie.
.
Language=Romanian
ERROR_PLUGPLAY_QUERY_VETOED - The Plug and Play query operation was not successful.
.

MessageId=684
Severity=Success
Facility=System
SymbolicName=ERROR_UNWIND_CONSOLIDATE
Language=English
ERROR_UNWIND_CONSOLIDATE - A frame consolidation has been executed.
.
Language=Russian
ERROR_UNWIND_CONSOLIDATE - A frame consolidation has been executed.
.
Language=Polish
ERROR_UNWIND_CONSOLIDATE - Przeprowadzono konsolidację ramek.
.
Language=Romanian
ERROR_UNWIND_CONSOLIDATE - A frame consolidation has been executed.
.

MessageId=685
Severity=Success
Facility=System
SymbolicName=ERROR_REGISTRY_HIVE_RECOVERED
Language=English
ERROR_REGISTRY_HIVE_RECOVERED - Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost.
.
Language=Russian
ERROR_REGISTRY_HIVE_RECOVERED - Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost.
.
Language=Polish
ERROR_REGISTRY_HIVE_RECOVERED - Gałąź rejestru (plik): %hs była uszkodzona i została odzyskana. Niektóre dane mogły zostać utracone.
.
Language=Romanian
ERROR_REGISTRY_HIVE_RECOVERED - Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost.
.

MessageId=686
Severity=Success
Facility=System
SymbolicName=ERROR_DLL_MIGHT_BE_INSECURE
Language=English
ERROR_DLL_MIGHT_BE_INSECURE - The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?
.
Language=Russian
ERROR_DLL_MIGHT_BE_INSECURE - The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?
.
Language=Polish
ERROR_DLL_MIGHT_BE_INSECURE - Aplikacja próbuje uruchomić kod wykonywalny z modułu %hs. Może to być niebezpieczne. Dostępna jest alternatywa, %hs. Czy aplikacja ma użyć bezpiecznego modułu %hs?
.
Language=Romanian
ERROR_DLL_MIGHT_BE_INSECURE - The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?
.

MessageId=687
Severity=Success
Facility=System
SymbolicName=ERROR_DLL_MIGHT_BE_INCOMPATIBLE
Language=English
ERROR_DLL_MIGHT_BE_INCOMPATIBLE - The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?
.
Language=Russian
ERROR_DLL_MIGHT_BE_INCOMPATIBLE - The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?
.
Language=Polish
ERROR_DLL_MIGHT_BE_INCOMPATIBLE - Aplikacja ładuje kod wykonywalny z modułu %hs. Jest to bezpieczne, ale może być niezgodne z poprzednimi wydaniami systemu operacyjnego. Dostępna jest alternatywa, %hs. Czy aplikacja ma użyć bezpiecznego modułu %hs?
.
Language=Romanian
ERROR_DLL_MIGHT_BE_INCOMPATIBLE - The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?
.

MessageId=688
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_EXCEPTION_NOT_HANDLED
Language=English
ERROR_DBG_EXCEPTION_NOT_HANDLED - Debugger did not handle the exception.
.
Language=Russian
ERROR_DBG_EXCEPTION_NOT_HANDLED - Debugger did not handle the exception.
.
Language=Polish
ERROR_DBG_EXCEPTION_NOT_HANDLED - Debuger nie obsłużył wyjątku.
.
Language=Romanian
ERROR_DBG_EXCEPTION_NOT_HANDLED - Debugger did not handle the exception.
.

MessageId=689
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_REPLY_LATER
Language=English
ERROR_DBG_REPLY_LATER - Debugger will reply later.
.
Language=Russian
ERROR_DBG_REPLY_LATER - Debugger will reply later.
.
Language=Polish
ERROR_DBG_REPLY_LATER - Debuger udzieli odpowiedź później.
.
Language=Romanian
ERROR_DBG_REPLY_LATER - Debugger will reply later.
.

MessageId=690
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE
Language=English
ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE - Debugger can not provide handle.
.
Language=Russian
ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE - Debugger can not provide handle.
.
Language=Polish
ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE - Debuger nie może udostępnić uchwytu.
.
Language=Romanian
ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE - Debugger can not provide handle.
.

MessageId=691
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_TERMINATE_THREAD
Language=English
ERROR_DBG_TERMINATE_THREAD - Debugger terminated thread.
.
Language=Russian
ERROR_DBG_TERMINATE_THREAD - Debugger terminated thread.
.
Language=Polish
ERROR_DBG_TERMINATE_THREAD - Debuger przerwał wątek.
.
Language=Romanian
ERROR_DBG_TERMINATE_THREAD - Debugger terminated thread.
.

MessageId=692
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_TERMINATE_PROCESS
Language=English
ERROR_DBG_TERMINATE_PROCESS - Debugger terminated process.
.
Language=Russian
ERROR_DBG_TERMINATE_PROCESS - Debugger terminated process.
.
Language=Polish
ERROR_DBG_TERMINATE_PROCESS - Debuger przerwał proces.
.
Language=Romanian
ERROR_DBG_TERMINATE_PROCESS - Debugger terminated process.
.

MessageId=693
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_CONTROL_C
Language=English
ERROR_DBG_CONTROL_C - Debugger got control C.
.
Language=Russian
ERROR_DBG_CONTROL_C - Debugger got control C.
.
Language=Polish
ERROR_DBG_CONTROL_C - Debuger przejął kontrolę C.
.
Language=Romanian
ERROR_DBG_CONTROL_C - Debugger got control C.
.

MessageId=694
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_PRINTEXCEPTION_C
Language=English
ERROR_DBG_PRINTEXCEPTION_C - Debugger printed exception on control C.
.
Language=Russian
ERROR_DBG_PRINTEXCEPTION_C - Debugger printed exception on control C.
.
Language=Polish
ERROR_DBG_PRINTEXCEPTION_C - Debuger wydrukował wyjątek dla kontroli C.
.
Language=Romanian
ERROR_DBG_PRINTEXCEPTION_C - Debugger printed exception on control C.
.

MessageId=695
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_RIPEXCEPTION
Language=English
ERROR_DBG_RIPEXCEPTION - Debugger received RIP exception.
.
Language=Russian
ERROR_DBG_RIPEXCEPTION - Debugger received RIP exception.
.
Language=Polish
ERROR_DBG_RIPEXCEPTION - Debuger otrzymał wyjątek RIP.
.
Language=Romanian
ERROR_DBG_RIPEXCEPTION - Debugger received RIP exception.
.

MessageId=696
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_CONTROL_BREAK
Language=English
ERROR_DBG_CONTROL_BREAK - Debugger received control break.
.
Language=Russian
ERROR_DBG_CONTROL_BREAK - Debugger received control break.
.
Language=Polish
ERROR_DBG_CONTROL_BREAK - Debuger otrzymał kombinację control break.
.
Language=Romanian
ERROR_DBG_CONTROL_BREAK - Debugger received control break.
.

MessageId=697
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_COMMAND_EXCEPTION
Language=English
ERROR_DBG_COMMAND_EXCEPTION - Debugger command communication exception.
.
Language=Russian
ERROR_DBG_COMMAND_EXCEPTION - Debugger command communication exception.
.
Language=Polish
ERROR_DBG_COMMAND_EXCEPTION - Wyjątek komunikacji polecenia debugera.
.
Language=Romanian
ERROR_DBG_COMMAND_EXCEPTION - Debugger command communication exception.
.

MessageId=698
Severity=Success
Facility=System
SymbolicName=ERROR_OBJECT_NAME_EXISTS
Language=English
ERROR_OBJECT_NAME_EXISTS - An attempt was made to create an object and the object name already existed.
.
Language=Russian
ERROR_OBJECT_NAME_EXISTS - An attempt was made to create an object and the object name already existed.
.
Language=Polish
ERROR_OBJECT_NAME_EXISTS - Podjęto próbę utworzenia obiektu, podczas gdy taka nazwa obiektu już istniała.
.
Language=Romanian
ERROR_OBJECT_NAME_EXISTS - An attempt was made to create an object and the object name already existed.
.

MessageId=699
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_WAS_SUSPENDED
Language=English
ERROR_THREAD_WAS_SUSPENDED - A thread termination occurred while the thread was suspended. The thread was resumed, and termination proceeded.
.
Language=Russian
ERROR_THREAD_WAS_SUSPENDED - A thread termination occurred while the thread was suspended. The thread was resumed, and termination proceeded.
.
Language=Polish
ERROR_THREAD_WAS_SUSPENDED - Nastąpiło zamknięcie wątku, gdy wątek ten został zawieszony. Wątek został wznowiony i wznowiono operację zamykania.
.
Language=Romanian
ERROR_THREAD_WAS_SUSPENDED - A thread termination occurred while the thread was suspended. The thread was resumed, and termination proceeded.
.

MessageId=700
Severity=Success
Facility=System
SymbolicName=ERROR_IMAGE_NOT_AT_BASE
Language=English
ERROR_IMAGE_NOT_AT_BASE - An image file could not be mapped at the address specified in the image file. Local fixups must be performed on this image.
.
Language=Russian
ERROR_IMAGE_NOT_AT_BASE - An image file could not be mapped at the address specified in the image file. Local fixups must be performed on this image.
.
Language=Polish
ERROR_IMAGE_NOT_AT_BASE - Zamapowanie obrazu pod adresem określonym w pliku obrazu nie było możliwe. Na tym obrazie trzeba wykonać lokalną naprawę.
.
Language=Romanian
ERROR_IMAGE_NOT_AT_BASE - An image file could not be mapped at the address specified in the image file. Local fixups must be performed on this image.
.

MessageId=701
Severity=Success
Facility=System
SymbolicName=ERROR_RXACT_STATE_CREATED
Language=English
ERROR_RXACT_STATE_CREATED - This informational level status indicates that a specified registry sub-tree transaction state did not yet exist and had to be created.
.
Language=Russian
ERROR_RXACT_STATE_CREATED - This informational level status indicates that a specified registry sub-tree transaction state did not yet exist and had to be created.
.
Language=Polish
ERROR_RXACT_STATE_CREATED - Ten stan poziomu informacji wskazuje, że określony stan transakcji poddrzewa Rejestru jeszcze nie istniał i musiał być utworzony.
.
Language=Romanian
ERROR_RXACT_STATE_CREATED - This informational level status indicates that a specified registry sub-tree transaction state did not yet exist and had to be created.
.

MessageId=702
Severity=Success
Facility=System
SymbolicName=ERROR_SEGMENT_NOTIFICATION
Language=English
ERROR_SEGMENT_NOTIFICATION - A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload or track symbols and breakpoints within these 16-bit segments.
.
Language=Russian
ERROR_SEGMENT_NOTIFICATION - A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload or track symbols and breakpoints within these 16-bit segments.
.
Language=Polish
ERROR_SEGMENT_NOTIFICATION - Wirtualna maszyna DOS ładuje, zwalnia lub przenosi obraz segmentu programu MS-DOS lub Win16. Tworzony jest wyjątek, dzięki czemu debuger może ładować zwalniać i śledzić symbole i punkty przerwania w tych 16-bitowych segmentach.
.
Language=Romanian
ERROR_SEGMENT_NOTIFICATION - A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload or track symbols and breakpoints within these 16-bit segments.
.

MessageId=703
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_CURRENT_DIRECTORY
Language=English
ERROR_BAD_CURRENT_DIRECTORY - The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit.
.
Language=Russian
ERROR_BAD_CURRENT_DIRECTORY - The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit.
.
Language=Polish
ERROR_BAD_CURRENT_DIRECTORY - Proces nie może przełączyć się do bieżącego katalogu startowego %hs. Wybierz OK, aby ustawić bieżący katalog na %hs, albo wybierz "Anuluj", aby zakończyć.
.
Language=Romanian
ERROR_BAD_CURRENT_DIRECTORY - The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit.
.

MessageId=704
Severity=Success
Facility=System
SymbolicName=ERROR_FT_READ_RECOVERY_FROM_BACKUP
Language=English
ERROR_FT_READ_RECOVERY_FROM_BACKUP - To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was unable to reassign the failing area of the device.
.
Language=Russian
ERROR_FT_READ_RECOVERY_FROM_BACKUP - To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was unable to reassign the failing area of the device.
.
Language=Polish
ERROR_FT_READ_RECOVERY_FROM_BACKUP - Aby wykonać żądanie odczytu, odporny na błędy system plików NT pomyślnie odczytał dane z dodatkowej kopii. Powodem było to, że wystąpiła awaria w elemencie odpornego na błędy woluminu, ale nie było możliwe ponowne przypisanie odpowiedzialnego za awarię obszaru urządzenia.
.
Language=Romanian
ERROR_FT_READ_RECOVERY_FROM_BACKUP - To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was unable to reassign the failing area of the device.
.

MessageId=705
Severity=Success
Facility=System
SymbolicName=ERROR_FT_WRITE_RECOVERY
Language=English
ERROR_FT_WRITE_RECOVERY - To satisfy a write request, the NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was not able to reassign the failing area of the device.
.
Language=Russian
ERROR_FT_WRITE_RECOVERY - To satisfy a write request, the NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was not able to reassign the failing area of the device.
.
Language=Polish
ERROR_FT_WRITE_RECOVERY - Aby wykonać żądanie zapisu odporny na błędy system plików NT pomyślnie zapisał dodatkową kopię danych. Powodem było to, że wystąpiła awaria w elemencie odpornego na błędy woluminu, ale nie było możliwe ponowne przypisanie odpowiedzialnego za awarię obszaru urządzenia.
.
Language=Romanian
ERROR_FT_WRITE_RECOVERY - To satisfy a write request, the NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but was not able to reassign the failing area of the device.
.

MessageId=706
Severity=Success
Facility=System
SymbolicName=ERROR_IMAGE_MACHINE_TYPE_MISMATCH
Language=English
ERROR_IMAGE_MACHINE_TYPE_MISMATCH - The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
.
Language=Russian
ERROR_IMAGE_MACHINE_TYPE_MISMATCH - The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
.
Language=Polish
ERROR_IMAGE_MACHINE_TYPE_MISMATCH - Plik obrazu %hs jest prawidłowy, ale jest dla innego typu komuptera niż bieżący. Wybierz OK, aby kontynuować, albo ANULUJ, aby anulować ładowanie biblioteki DLL.
.
Language=Romanian
ERROR_IMAGE_MACHINE_TYPE_MISMATCH - The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
.

MessageId=707
Severity=Success
Facility=System
SymbolicName=ERROR_RECEIVE_PARTIAL
Language=English
ERROR_RECEIVE_PARTIAL - The network transport returned partial data to its client. The remaining data will be sent later.
.
Language=Russian
ERROR_RECEIVE_PARTIAL - The network transport returned partial data to its client. The remaining data will be sent later.
.
Language=Polish
ERROR_RECEIVE_PARTIAL - Transport sieciowy zwrócił do klienta częściowe dane. Pozostałe dane zostaną wysłane później.
.
Language=Romanian
ERROR_RECEIVE_PARTIAL - The network transport returned partial data to its client. The remaining data will be sent later.
.

MessageId=708
Severity=Success
Facility=System
SymbolicName=ERROR_RECEIVE_EXPEDITED
Language=English
ERROR_RECEIVE_EXPEDITED - The network transport returned data to its client that was marked as expedited by the remote system.
.
Language=Russian
ERROR_RECEIVE_EXPEDITED - The network transport returned data to its client that was marked as expedited by the remote system.
.
Language=Polish
ERROR_RECEIVE_EXPEDITED - Transport sieciowy zwrócił do klienta dane oznaczone przez zdalny system jako przyspieszone.
.
Language=Romanian
ERROR_RECEIVE_EXPEDITED - The network transport returned data to its client that was marked as expedited by the remote system.
.

MessageId=709
Severity=Success
Facility=System
SymbolicName=ERROR_RECEIVE_PARTIAL_EXPEDITED
Language=English
ERROR_RECEIVE_PARTIAL_EXPEDITED - The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later.
.
Language=Russian
ERROR_RECEIVE_PARTIAL_EXPEDITED - The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later.
.
Language=Polish
ERROR_RECEIVE_PARTIAL_EXPEDITED - Transport sieciowy zwrócił do klienta częściowe dane, oznaczone przez zdalny system jako przyspieszone. Pozostałe dane zostaną wysłane później.
.
Language=Romanian
ERROR_RECEIVE_PARTIAL_EXPEDITED - The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later.
.

MessageId=710
Severity=Success
Facility=System
SymbolicName=ERROR_EVENT_DONE
Language=English
ERROR_EVENT_DONE - The TDI indication has completed successfully.
.
Language=Russian
ERROR_EVENT_DONE - The TDI indication has completed successfully.
.
Language=Polish
ERROR_EVENT_DONE - Wskazywanie TDI zostało ukończone pomyślnie.
.
Language=Romanian
ERROR_EVENT_DONE - The TDI indication has completed successfully.
.

MessageId=711
Severity=Success
Facility=System
SymbolicName=ERROR_EVENT_PENDING
Language=English
ERROR_EVENT_PENDING - The TDI indication has entered the pending state.
.
Language=Russian
ERROR_EVENT_PENDING - The TDI indication has entered the pending state.
.
Language=Polish
ERROR_EVENT_PENDING - Wskazywanie TDI przeszło w stan oczekiwania.
.
Language=Romanian
ERROR_EVENT_PENDING - The TDI indication has entered the pending state.
.

MessageId=712
Severity=Success
Facility=System
SymbolicName=ERROR_CHECKING_FILE_SYSTEM
Language=English
ERROR_CHECKING_FILE_SYSTEM - Checking file system on %wZ.
.
Language=Russian
ERROR_CHECKING_FILE_SYSTEM - Checking file system on %wZ.
.
Language=Polish
ERROR_CHECKING_FILE_SYSTEM - Sprawdzanie systemu plików na %wZ
.
Language=Romanian
ERROR_CHECKING_FILE_SYSTEM - Checking file system on %wZ.
.

MessageId=714
Severity=Success
Facility=System
SymbolicName=ERROR_PREDEFINED_HANDLE
Language=English
ERROR_PREDEFINED_HANDLE - The specified registry key is referenced by a predefined handle.
.
Language=Russian
ERROR_PREDEFINED_HANDLE - The specified registry key is referenced by a predefined handle.
.
Language=Polish
ERROR_PREDEFINED_HANDLE - Do określonego klucza Rejestru odwołuje się dojście uprzednio zdefiniowane.
.
Language=Romanian
ERROR_PREDEFINED_HANDLE - The specified registry key is referenced by a predefined handle.
.

MessageId=715
Severity=Success
Facility=System
SymbolicName=ERROR_WAS_UNLOCKED
Language=English
ERROR_WAS_UNLOCKED - The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process.
.
Language=Russian
ERROR_WAS_UNLOCKED - The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process.
.
Language=Polish
ERROR_WAS_UNLOCKED - Zabezpieczenie zablokowanej strony zmieniono na "Brak dostępu" i strona została odblokowana z pamięci i z procesu.
.
Language=Romanian
ERROR_WAS_UNLOCKED - The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process.
.

MessageId=717
Severity=Success
Facility=System
SymbolicName=ERROR_WAS_LOCKED
Language=English
ERROR_WAS_LOCKED - One of the pages to lock was already locked.
.
Language=Russian
ERROR_WAS_LOCKED - One of the pages to lock was already locked.
.
Language=Polish
ERROR_WAS_LOCKED - Jedna ze stron przewidzianych do zablokowania była już zablokowana.
.
Language=Romanian
ERROR_WAS_LOCKED - One of the pages to lock was already locked.
.

MessageId=720
Severity=Success
Facility=System
SymbolicName=ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE
Language=English
ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE - The image file %hs is valid, but is for a machine type other than the current machine.
.
Language=Russian
ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE - The image file %hs is valid, but is for a machine type other than the current machine.
.
Language=Polish
ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE - Plik obrazu %hs jest prawidłowy, ale jest dla innego typu komputera niż bieżący.
.
Language=Romanian
ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE - The image file %hs is valid, but is for a machine type other than the current machine.
.

MessageId=721
Severity=Success
Facility=System
SymbolicName=ERROR_NO_YIELD_PERFORMED
Language=English
ERROR_NO_YIELD_PERFORMED - A yield execution was performed and no thread was available to run.
.
Language=Russian
ERROR_NO_YIELD_PERFORMED - A yield execution was performed and no thread was available to run.
.
Language=Polish
ERROR_NO_YIELD_PERFORMED - Wykonano przekazanie wykonywania i żaden wątek nie był dostępny do uruchomienia.
.
Language=Romanian
ERROR_NO_YIELD_PERFORMED - A yield execution was performed and no thread was available to run.
.

MessageId=722
Severity=Success
Facility=System
SymbolicName=ERROR_TIMER_RESUME_IGNORED
Language=English
ERROR_TIMER_RESUME_IGNORED - The resumable flag to a timer API was ignored.
.
Language=Russian
ERROR_TIMER_RESUME_IGNORED - The resumable flag to a timer API was ignored.
.
Language=Polish
ERROR_TIMER_RESUME_IGNORED - Zignorowano wznawialną flagę czasomierza API.
.
Language=Romanian
ERROR_TIMER_RESUME_IGNORED - The resumable flag to a timer API was ignored.
.

MessageId=723
Severity=Success
Facility=System
SymbolicName=ERROR_ARBITRATION_UNHANDLED
Language=English
ERROR_ARBITRATION_UNHANDLED - The arbiter has deferred arbitration of these resources to its parent.
.
Language=Russian
ERROR_ARBITRATION_UNHANDLED - The arbiter has deferred arbitration of these resources to its parent.
.
Language=Polish
ERROR_ARBITRATION_UNHANDLED - Arbiter wstrzymał rozstrzyganie o przynależności zasobów do obiektów nadrzędnych
.
Language=Romanian
ERROR_ARBITRATION_UNHANDLED - The arbiter has deferred arbitration of these resources to its parent.
.

MessageId=724
Severity=Success
Facility=System
SymbolicName=ERROR_CARDBUS_NOT_SUPPORTED
Language=English
ERROR_CARDBUS_NOT_SUPPORTED - The device \"%hs\" has detected a CardBus card in its slot, but the firmware on this system is not configured to allow the CardBus controller to be run in CardBus mode. The operating system will currently accept only 16-bit (R2) pc-cards on this controller.
.
Language=Russian
ERROR_CARDBUS_NOT_SUPPORTED - The device \"%hs\" has detected a CardBus card in its slot, but the firmware on this system is not configured to allow the CardBus controller to be run in CardBus mode. The operating system will currently accept only 16-bit (R2) pc-cards on this controller.
.
Language=Polish
ERROR_CARDBUS_NOT_SUPPORTED - Urządzenie \"%hs"\ wykryło w gnieździe kartę CardBus, ale oprogramowanie firmware w systemie nie jest skonfigurowane w sposób zezwalający na uruchamianie kontrolera CardBus w trybie CardBus. System operacyjny będzie obecnie akceptować tylko 16 bitowe karty pc (R2) dla tego kontrolera.
.
Language=Romanian
ERROR_CARDBUS_NOT_SUPPORTED - The device \"%hs\" has detected a CardBus card in its slot, but the firmware on this system is not configured to allow the CardBus controller to be run in CardBus mode. The operating system will currently accept only 16-bit (R2) pc-cards on this controller.
.

MessageId=725
Severity=Success
Facility=System
SymbolicName=ERROR_MP_PROCESSOR_MISMATCH
Language=English
ERROR_MP_PROCESSOR_MISMATCH - The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. Should problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported.
.
Language=Russian
ERROR_MP_PROCESSOR_MISMATCH - The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. Should problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported.
.
Language=Polish
ERROR_MP_PROCESSOR_MISMATCH - Jednostki CPU w tym systemie wieloprocesorowym mają różne poziomy wersji. Aby używać wszystkich procesorów, system operacyjny ograniczy możliwości zestawu do funkcji obsługiwanych przez procesor o najmniejszych możliwościach. Jeśli wystąpią problemy, skontaktuj się z producentem jednostki CPU, aby upewnić się czy zestaw procesorów jest obsługiwany.
.
Language=Romanian
ERROR_MP_PROCESSOR_MISMATCH - The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. Should problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported.
.

MessageId=726
Severity=Success
Facility=System
SymbolicName=ERROR_HIBERNATED
Language=English
ERROR_HIBERNATED - The system was put into hibernation.
.
Language=Russian
ERROR_HIBERNATED - The system was put into hibernation.
.
Language=Polish
ERROR_HIBERNATED - System został wprowadzony w stan hibernacji.
.
Language=Romanian
ERROR_HIBERNATED - The system was put into hibernation.
.

MessageId=727
Severity=Success
Facility=System
SymbolicName=ERROR_RESUME_HIBERNATION
Language=English
ERROR_RESUME_HIBERNATION - The system was resumed from hibernation.
.
Language=Russian
ERROR_RESUME_HIBERNATION - The system was resumed from hibernation.
.
Language=Polish
ERROR_RESUME_HIBERNATION - System wyszedł ze stanu hibernacji.
.
Language=Romanian
ERROR_RESUME_HIBERNATION - The system was resumed from hibernation.
.

MessageId=728
Severity=Success
Facility=System
SymbolicName=ERROR_FIRMWARE_UPDATED
Language=English
ERROR_FIRMWARE_UPDATED - Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3].
.
Language=Russian
ERROR_FIRMWARE_UPDATED - Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3].
.
Language=Polish
ERROR_FIRMWARE_UPDATED - System Windows wykrył, że oprogramowanie układowe systemu (BIOS) zostało zaktualizowane [poprzednia data oprogramowania układowego = %2, bieżąca data oprogramowania układowego %3].
.
Language=Romanian
ERROR_FIRMWARE_UPDATED - Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3].
.

MessageId=729
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVERS_LEAKING_LOCKED_PAGES
Language=English
ERROR_DRIVERS_LEAKING_LOCKED_PAGES - A device driver is leaking locked I/O pages causing system degradation. The system has automatically enabled tracking code in order to try and catch the culprit.
.
Language=Russian
ERROR_DRIVERS_LEAKING_LOCKED_PAGES - A device driver is leaking locked I/O pages causing system degradation. The system has automatically enabled tracking code in order to try and catch the culprit.
.
Language=Polish
ERROR_DRIVERS_LEAKING_LOCKED_PAGES - W sterowniku urządzenia powstają przecieki zablokowanych stron We/Wy, które powodują degradację systemu. System włączy automatycznie kod śledzenia, aby podjąć próbę odnalezienia programu, który powoduje ten problem.
.
Language=Romanian
ERROR_DRIVERS_LEAKING_LOCKED_PAGES - A device driver is leaking locked I/O pages causing system degradation. The system has automatically enabled tracking code in order to try and catch the culprit.
.

MessageId=730
Severity=Success
Facility=System
SymbolicName=ERROR_WAKE_SYSTEM
Language=English
ERROR_WAKE_SYSTEM - The system has awoken
.
Language=Russian
ERROR_WAKE_SYSTEM - The system has awoken
.
Language=Polish
ERROR_WAKE_SYSTEM - System został obudzony.
.
Language=Romanian
ERROR_WAKE_SYSTEM - The system has awoken
.

MessageId=741
Severity=Success
Facility=System
SymbolicName=ERROR_REPARSE
Language=English
ERROR_REPARSE - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.
Language=Russian
ERROR_REPARSE - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.
Language=Polish
ERROR_REPARSE - Menedżer obiektów powinien przeprowadzić ponowną analizę składni, ponieważ nazwa pliku dała w efekcie łącze symboliczne.
.
Language=Romanian
ERROR_REPARSE - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.

MessageId=742
Severity=Success
Facility=System
SymbolicName=ERROR_OPLOCK_BREAK_IN_PROGRESS
Language=English
ERROR_OPLOCK_BREAK_IN_PROGRESS - An open/create operation completed while an oplock break is underway.
.
Language=Russian
ERROR_OPLOCK_BREAK_IN_PROGRESS - An open/create operation completed while an oplock break is underway.
.
Language=Polish
ERROR_OPLOCK_BREAK_IN_PROGRESS - Zakończono operację otwierania/tworzenia podczas trwania "oplock break".
.
Language=Romanian
ERROR_OPLOCK_BREAK_IN_PROGRESS - An open/create operation completed while an oplock break is underway.
.

MessageId=743
Severity=Success
Facility=System
SymbolicName=ERROR_VOLUME_MOUNTED
Language=English
ERROR_VOLUME_MOUNTED - A new volume has been mounted by a file system.
.
Language=Russian
ERROR_VOLUME_MOUNTED - A new volume has been mounted by a file system.
.
Language=Polish
ERROR_VOLUME_MOUNTED - Nowy wolumin został zainstalowany przez system plików.
.
Language=Romanian
ERROR_VOLUME_MOUNTED - A new volume has been mounted by a file system.
.

MessageId=744
Severity=Success
Facility=System
SymbolicName=ERROR_RXACT_COMMITTED
Language=English
ERROR_RXACT_COMMITTED - This success level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has now been completed.
.
Language=Russian
ERROR_RXACT_COMMITTED - This success level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has now been completed.
.
Language=Polish
ERROR_RXACT_COMMITTED - Ten stan poziomu sukcesu wskazuje, że dla danego poddrzewa Rejestru istnieje już stan transakcji, ale zlecenie transakcji zostało wcześniej przerwane. Teraz zlecenie zostało zakończone.
.
Language=Romanian
ERROR_RXACT_COMMITTED - This success level status indicates that the transaction state already exists for the registry sub-tree, but that a transaction commit was previously aborted. The commit has now been completed.
.

MessageId=745
Severity=Success
Facility=System
SymbolicName=ERROR_NOTIFY_CLEANUP
Language=English
ERROR_NOTIFY_CLEANUP - This indicates that a notify change request has been completed due to closing the handle which made the notify change request.
.
Language=Russian
ERROR_NOTIFY_CLEANUP - This indicates that a notify change request has been completed due to closing the handle which made the notify change request.
.
Language=Polish
ERROR_NOTIFY_CLEANUP - Wskazuje, że żądanie potwierdzenia zmiany zostało zakończone z powodu zamknięcia dojścia, które zgłosiło to żądanie.
.
Language=Romanian
ERROR_NOTIFY_CLEANUP - This indicates that a notify change request has been completed due to closing the handle which made the notify change request.
.

MessageId=746
Severity=Success
Facility=System
SymbolicName=ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED
Language=English
ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED - An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport.
.
Language=Russian
ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED - An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport.
.
Language=Polish
ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED - Podjęto próbę podłączenia do zdalnego serwera %hs przez transport podstawowy, ale próba nie powiodła się. Uzyskano połączenie przez transport pomocniczy.
.
Language=Romanian
ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED - An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport.
.

MessageId=747
Severity=Success
Facility=System
SymbolicName=ERROR_PAGE_FAULT_TRANSITION
Language=English
ERROR_PAGE_FAULT_TRANSITION - Page fault was a transition fault.
.
Language=Russian
ERROR_PAGE_FAULT_TRANSITION - Page fault was a transition fault.
.
Language=Polish
ERROR_PAGE_FAULT_TRANSITION - Błąd strony był błędem przejścia.
.
Language=Romanian
ERROR_PAGE_FAULT_TRANSITION - Page fault was a transition fault.
.

MessageId=748
Severity=Success
Facility=System
SymbolicName=ERROR_PAGE_FAULT_DEMAND_ZERO
Language=English
ERROR_PAGE_FAULT_DEMAND_ZERO - Page fault was a demand zero fault.
.
Language=Russian
ERROR_PAGE_FAULT_DEMAND_ZERO - Page fault was a demand zero fault.
.
Language=Polish
ERROR_PAGE_FAULT_DEMAND_ZERO - Błąd strony był błędem typu wymagane zero.
.
Language=Romanian
ERROR_PAGE_FAULT_DEMAND_ZERO - Page fault was a demand zero fault.
.

MessageId=749
Severity=Success
Facility=System
SymbolicName=ERROR_PAGE_FAULT_COPY_ON_WRITE
Language=English
ERROR_PAGE_FAULT_COPY_ON_WRITE - Page fault was a demand zero fault.
.
Language=Russian
ERROR_PAGE_FAULT_COPY_ON_WRITE - Page fault was a demand zero fault.
.
Language=Polish
ERROR_PAGE_FAULT_COPY_ON_WRITE - Błąd strony był błędem typu wymagane zero.
.
Language=Romanian
ERROR_PAGE_FAULT_COPY_ON_WRITE - Page fault was a demand zero fault.
.

MessageId=750
Severity=Success
Facility=System
SymbolicName=ERROR_PAGE_FAULT_GUARD_PAGE
Language=English
ERROR_PAGE_FAULT_GUARD_PAGE - Page fault was a demand zero fault.
.
Language=Russian
ERROR_PAGE_FAULT_GUARD_PAGE - Page fault was a demand zero fault.
.
Language=Polish
ERROR_PAGE_FAULT_GUARD_PAGE - Błąd strony był błędem typu wymagane zero.
.
Language=Romanian
ERROR_PAGE_FAULT_GUARD_PAGE - Page fault was a demand zero fault.
.

MessageId=751
Severity=Success
Facility=System
SymbolicName=ERROR_PAGE_FAULT_PAGING_FILE
Language=English
ERROR_PAGE_FAULT_PAGING_FILE - Page fault was satisfied by reading from a secondary storage device.
.
Language=Russian
ERROR_PAGE_FAULT_PAGING_FILE - Page fault was satisfied by reading from a secondary storage device.
.
Language=Polish
ERROR_PAGE_FAULT_PAGING_FILE - Błąd strony został naprawiony przez odczyt z zapasowego urządzenia magazynującego.
.
Language=Romanian
ERROR_PAGE_FAULT_PAGING_FILE - Page fault was satisfied by reading from a secondary storage device.
.

MessageId=752
Severity=Success
Facility=System
SymbolicName=ERROR_CACHE_PAGE_LOCKED
Language=English
ERROR_CACHE_PAGE_LOCKED - Cached page was locked during operation.
.
Language=Russian
ERROR_CACHE_PAGE_LOCKED - Cached page was locked during operation.
.
Language=Polish
ERROR_CACHE_PAGE_LOCKED - Buforowana strona została zablokowana podczas operacji.
.
Language=Romanian
ERROR_CACHE_PAGE_LOCKED - Cached page was locked during operation.
.

MessageId=753
Severity=Success
Facility=System
SymbolicName=ERROR_CRASH_DUMP
Language=English
ERROR_CRASH_DUMP - Crash dump exists in paging file.
.
Language=Russian
ERROR_CRASH_DUMP - Crash dump exists in paging file.
.
Language=Polish
ERROR_CRASH_DUMP - W pliku stronicowania istnieje zrzut awaryjny.
.
Language=Romanian
ERROR_CRASH_DUMP - Crash dump exists in paging file.
.

MessageId=754
Severity=Success
Facility=System
SymbolicName=ERROR_BUFFER_ALL_ZEROS
Language=English
ERROR_BUFFER_ALL_ZEROS - Specified buffer contains all zeros.
.
Language=Russian
ERROR_BUFFER_ALL_ZEROS - Specified buffer contains all zeros.
.
Language=Polish
ERROR_BUFFER_ALL_ZEROS - Określony bufor zawiera same zera.
.
Language=Romanian
ERROR_BUFFER_ALL_ZEROS - Specified buffer contains all zeros.
.

MessageId=755
Severity=Success
Facility=System
SymbolicName=ERROR_REPARSE_OBJECT
Language=English
ERROR_REPARSE_OBJECT - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.
Language=Russian
ERROR_REPARSE_OBJECT - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.
Language=Polish
ERROR_REPARSE_OBJECT - Menedżer obiektów powinien przeprowadzić ponowną analizę składni, ponieważ nazwa pliku dała w efekcie łącze symboliczne.
.
Language=Romanian
ERROR_REPARSE_OBJECT - A reparse should be performed by the Object Manager since the name of the file resulted in a symbolic link.
.

MessageId=756
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_REQUIREMENTS_CHANGED
Language=English
ERROR_RESOURCE_REQUIREMENTS_CHANGED - The device has succeeded a query-stop and its resource requirements have changed.
.
Language=Russian
ERROR_RESOURCE_REQUIREMENTS_CHANGED - The device has succeeded a query-stop and its resource requirements have changed.
.
Language=Polish
ERROR_RESOURCE_REQUIREMENTS_CHANGED - Urządzenie pomyślnie wykonało operację zatrzymania zapytania i wymagania dotyczące zasobów uległy zmianie.
.
Language=Romanian
ERROR_RESOURCE_REQUIREMENTS_CHANGED - The device has succeeded a query-stop and its resource requirements have changed.
.

MessageId=757
Severity=Success
Facility=System
SymbolicName=ERROR_TRANSLATION_COMPLETE
Language=English
ERROR_TRANSLATION_COMPLETE - The translator has translated these resources into the global space and no further translations should be performed.
.
Language=Russian
ERROR_TRANSLATION_COMPLETE - The translator has translated these resources into the global space and no further translations should be performed.
.
Language=Polish
ERROR_TRANSLATION_COMPLETE - Translator zinterpretował zasoby w przestrzeni globalnej i nie należy wykonywać więcej interpretacji.
.
Language=Romanian
ERROR_TRANSLATION_COMPLETE - The translator has translated these resources into the global space and no further translations should be performed.
.

MessageId=758
Severity=Success
Facility=System
SymbolicName=ERROR_NOTHING_TO_TERMINATE
Language=English
ERROR_NOTHING_TO_TERMINATE - A process being terminated has no threads to terminate.
.
Language=Russian
ERROR_NOTHING_TO_TERMINATE - A process being terminated has no threads to terminate.
.
Language=Polish
ERROR_NOTHING_TO_TERMINATE - Kończony proces nie ma wątków do zakończenia.
.
Language=Romanian
ERROR_NOTHING_TO_TERMINATE - A process being terminated has no threads to terminate.
.

MessageId=759
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_NOT_IN_JOB
Language=English
ERROR_PROCESS_NOT_IN_JOB - The specified process is not part of a job.
.
Language=Russian
ERROR_PROCESS_NOT_IN_JOB - The specified process is not part of a job.
.
Language=Polish
ERROR_PROCESS_NOT_IN_JOB - Określony proces nie jest częścią zadania.
.
Language=Romanian
ERROR_PROCESS_NOT_IN_JOB - The specified process is not part of a job.
.

MessageId=760
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_IN_JOB
Language=English
ERROR_PROCESS_IN_JOB - The specified process is part of a job.
.
Language=Russian
ERROR_PROCESS_IN_JOB - The specified process is part of a job.
.
Language=Polish
ERROR_PROCESS_IN_JOB - Określony proces jest częścią zadania.
.
Language=Romanian
ERROR_PROCESS_IN_JOB - The specified process is part of a job.
.

MessageId=761
Severity=Success
Facility=System
SymbolicName=ERROR_VOLSNAP_HIBERNATE_READY
Language=English
ERROR_VOLSNAP_HIBERNATE_READY - The system is now ready for hibernation.
.
Language=Russian
ERROR_VOLSNAP_HIBERNATE_READY - The system is now ready for hibernation.
.
Language=Polish
ERROR_VOLSNAP_HIBERNATE_READY - System jest teraz gotowy do hibernacji.
.
Language=Romanian
ERROR_VOLSNAP_HIBERNATE_READY - The system is now ready for hibernation.
.

MessageId=762
Severity=Success
Facility=System
SymbolicName=ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY
Language=English
ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY - A file system or file system filter driver has successfully completed an FsFilter operation.
.
Language=Russian
ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY - A file system or file system filter driver has successfully completed an FsFilter operation.
.
Language=Polish
ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY - System plików lub sterownik filtru systemu plików ukończył pomyślnie operację FsFilter.
.
Language=Romanian
ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY - A file system or file system filter driver has successfully completed an FsFilter operation.
.

MessageId=763
Severity=Success
Facility=System
SymbolicName=ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED
Language=English
ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED - The specified interrupt vector was already connected.
.
Language=Russian
ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED - The specified interrupt vector was already connected.
.
Language=Polish
ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED - Określony wektor przerwania był już połączony.
.
Language=Romanian
ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED - The specified interrupt vector was already connected.
.

MessageId=764
Severity=Success
Facility=System
SymbolicName=ERROR_INTERRUPT_STILL_CONNECTED
Language=English
ERROR_INTERRUPT_STILL_CONNECTED - The specified interrupt vector is still connected.
.
Language=Russian
ERROR_INTERRUPT_STILL_CONNECTED - The specified interrupt vector is still connected.
.
Language=Polish
ERROR_INTERRUPT_STILL_CONNECTED - Określony wektor przerwania jest wciąż połączony.
.
Language=Romanian
ERROR_INTERRUPT_STILL_CONNECTED - The specified interrupt vector is still connected.
.

MessageId=765
Severity=Success
Facility=System
SymbolicName=ERROR_WAIT_FOR_OPLOCK
Language=English
ERROR_WAIT_FOR_OPLOCK - An operation is blocked waiting for an oplock.
.
Language=Russian
ERROR_WAIT_FOR_OPLOCK - An operation is blocked waiting for an oplock.
.
Language=Polish
ERROR_WAIT_FOR_OPLOCK - Operacja jest zablokowana i czeka na operację oplock.
.
Language=Romanian
ERROR_WAIT_FOR_OPLOCK - An operation is blocked waiting for an oplock.
.

MessageId=766
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_EXCEPTION_HANDLED
Language=English
ERROR_DBG_EXCEPTION_HANDLED - Debugger handled exception.
.
Language=Russian
ERROR_DBG_EXCEPTION_HANDLED - Debugger handled exception.
.
Language=Polish
ERROR_DBG_EXCEPTION_HANDLED - Debuger obsłużył wyjątek
.
Language=Romanian
ERROR_DBG_EXCEPTION_HANDLED - Debugger handled exception.
.

MessageId=767
Severity=Success
Facility=System
SymbolicName=ERROR_DBG_CONTINUE
Language=English
ERROR_DBG_CONTINUE - Debugger continued
.
Language=Russian
ERROR_DBG_CONTINUE - Debugger continued
.
Language=Polish
ERROR_DBG_CONTINUE - Debuger kontynuuje pracę
.
Language=Romanian
ERROR_DBG_CONTINUE - Debugger continued
.

MessageId=768
Severity=Success
Facility=System
SymbolicName=ERROR_CALLBACK_POP_STACK
Language=English
ERROR_CALLBACK_POP_STACK - An exception occurred in a user mode callback and the kernel callback frame should be removed.
.
Language=Russian
ERROR_CALLBACK_POP_STACK - An exception occurred in a user mode callback and the kernel callback frame should be removed.
.
Language=Polish
ERROR_CALLBACK_POP_STACK - Wystąpił wyjątek w wywołaniu zwrotnym trybu użytkownika, a ramka wywołania zwrotnego jądra powinna zostać usunięta.
.
Language=Romanian
ERROR_CALLBACK_POP_STACK - An exception occurred in a user mode callback and the kernel callback frame should be removed.
.

MessageId=769
Severity=Success
Facility=System
SymbolicName=ERROR_COMPRESSION_DISABLED
Language=English
ERROR_COMPRESSION_DISABLED - Compression is disabled for this volume.
.
Language=Russian
ERROR_COMPRESSION_DISABLED - Compression is disabled for this volume.
.
Language=Polish
ERROR_COMPRESSION_DISABLED - Kompresja jest wyłączona dla tego woluminu.
.
Language=Romanian
ERROR_COMPRESSION_DISABLED - Compression is disabled for this volume.
.

MessageId=770
Severity=Success
Facility=System
SymbolicName=ERROR_CANTFETCHBACKWARDS
Language=English
ERROR_CANTFETCHBACKWARDS - The data provider cannot fetch backwards through a result set.
.
Language=Russian
ERROR_CANTFETCHBACKWARDS - The data provider cannot fetch backwards through a result set.
.
Language=Polish
ERROR_CANTFETCHBACKWARDS - Dostawca danych nie może pobierać zestawu wyników wstecz.
.
Language=Romanian
ERROR_CANTFETCHBACKWARDS - The data provider cannot fetch backwards through a result set.
.

MessageId=771
Severity=Success
Facility=System
SymbolicName=ERROR_CANTSCROLLBACKWARDS
Language=English
ERROR_CANTSCROLLBACKWARDS - The data provider cannot scroll backwards through a result set.
.
Language=Russian
ERROR_CANTSCROLLBACKWARDS - The data provider cannot scroll backwards through a result set.
.
Language=Polish
ERROR_CANTSCROLLBACKWARDS - Dostawca danych nie może przewijać zestawu wyników wstecz.
.
Language=Romanian
ERROR_CANTSCROLLBACKWARDS - The data provider cannot scroll backwards through a result set.
.

MessageId=772
Severity=Success
Facility=System
SymbolicName=ERROR_ROWSNOTRELEASED
Language=English
ERROR_ROWSNOTRELEASED - The data provider requires that previously fetched data is released before asking for more data.
.
Language=Russian
ERROR_ROWSNOTRELEASED - The data provider requires that previously fetched data is released before asking for more data.
.
Language=Polish
ERROR_ROWSNOTRELEASED - Dostawca danych wymaga zwolnienia poprzednio pobranych danych przed żądaniem kolejnych danych.
.
Language=Romanian
ERROR_ROWSNOTRELEASED - The data provider requires that previously fetched data is released before asking for more data.
.

MessageId=773
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_ACCESSOR_FLAGS
Language=English
ERROR_BAD_ACCESSOR_FLAGS - The data provider was not able to interpret the flags set for a column binding in an accessor.
.
Language=Russian
ERROR_BAD_ACCESSOR_FLAGS - The data provider was not able to interpret the flags set for a column binding in an accessor.
.
Language=Polish
ERROR_BAD_ACCESSOR_FLAGS - Dostawca danych nie może zinterpretować zestawu flag dla wiązania kolumn w metodzie dostępu.
.
Language=Romanian
ERROR_BAD_ACCESSOR_FLAGS - The data provider was not able to interpret the flags set for a column binding in an accessor.
.

MessageId=774
Severity=Success
Facility=System
SymbolicName=ERROR_ERRORS_ENCOUNTERED
Language=English
ERROR_ERRORS_ENCOUNTERED - One or more errors occurred while processing the request.
.
Language=Russian
ERROR_ERRORS_ENCOUNTERED - One or more errors occurred while processing the request.
.
Language=Polish
ERROR_ERRORS_ENCOUNTERED - Wystąpił co najmniej jeden błąd podczas przetwarzania żądania.
.
Language=Romanian
ERROR_ERRORS_ENCOUNTERED - One or more errors occurred while processing the request.
.

MessageId=775
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_CAPABLE
Language=English
ERROR_NOT_CAPABLE - The implementation is not capable of performing the request.
.
Language=Russian
ERROR_NOT_CAPABLE - The implementation is not capable of performing the request.
.
Language=Polish
ERROR_NOT_CAPABLE - Bieżąca implementacja nie może wykonać żądania.
.
Language=Romanian
ERROR_NOT_CAPABLE - The implementation is not capable of performing the request.
.

MessageId=776
Severity=Success
Facility=System
SymbolicName=ERROR_REQUEST_OUT_OF_SEQUENCE
Language=English
ERROR_REQUEST_OUT_OF_SEQUENCE - The client of a component requested an operation which is not valid given the state of the component instance.
.
Language=Russian
ERROR_REQUEST_OUT_OF_SEQUENCE - The client of a component requested an operation which is not valid given the state of the component instance.
.
Language=Polish
ERROR_REQUEST_OUT_OF_SEQUENCE - Klient składnika zażądał nieprawidłowej operacji podającej stan wystąpienia składnika.
.
Language=Romanian
ERROR_REQUEST_OUT_OF_SEQUENCE - The client of a component requested an operation which is not valid given the state of the component instance.
.

MessageId=777
Severity=Success
Facility=System
SymbolicName=ERROR_VERSION_PARSE_ERROR
Language=English
ERROR_VERSION_PARSE_ERROR - A version number could not be parsed.
.
Language=Russian
ERROR_VERSION_PARSE_ERROR - A version number could not be parsed.
.
Language=Polish
ERROR_VERSION_PARSE_ERROR - Nie można przeanalizować numeru wersji.
.
Language=Romanian
ERROR_VERSION_PARSE_ERROR - A version number could not be parsed.
.

MessageId=778
Severity=Success
Facility=System
SymbolicName=ERROR_BADSTARTPOSITION
Language=English
ERROR_BADSTARTPOSITION - The iterator's start position is invalid.
.
Language=Russian
ERROR_BADSTARTPOSITION - The iterator's start position is invalid.
.
Language=Polish
ERROR_BADSTARTPOSITION - Pozycja początkowa iteratora jest nieprawidłowa.
.
Language=Romanian
ERROR_BADSTARTPOSITION - The iterator's start position is invalid.
.

MessageId=994
Severity=Success
Facility=System
SymbolicName=ERROR_EA_ACCESS_DENIED
Language=English
ERROR_EA_ACCESS_DENIED - Access to the extended attribute was denied.
.
Language=Russian
ERROR_EA_ACCESS_DENIED - Access to the extended attribute was denied.
.
Language=Polish
ERROR_EA_ACCESS_DENIED - Dostęp do atrybutu rozszerzonego został zabroniony.
.
Language=Romanian
ERROR_EA_ACCESS_DENIED - Access to the extended attribute was denied.
.

MessageId=995
Severity=Success
Facility=System
SymbolicName=ERROR_OPERATION_ABORTED
Language=English
ERROR_OPERATION_ABORTED - The I/O operation has been aborted because of either a thread exit or an application request.
.
Language=Russian
ERROR_OPERATION_ABORTED - The I/O operation has been aborted because of either a thread exit or an application request.
.
Language=Polish
ERROR_OPERATION_ABORTED - Operacja We/Wy została przerwana z powodu zakończenia wątku lub żądania aplikacji.
.
Language=Romanian
ERROR_OPERATION_ABORTED - The I/O operation has been aborted because of either a thread exit or an application request.
.

MessageId=996
Severity=Success
Facility=System
SymbolicName=ERROR_IO_INCOMPLETE
Language=English
ERROR_IO_INCOMPLETE - Overlapped I/O event is not in a signaled state.
.
Language=Russian
ERROR_IO_INCOMPLETE - Overlapped I/O event is not in a signaled state.
.
Language=Polish
ERROR_IO_INCOMPLETE - Pokrywające się zdarzenie We/Wy nie jest w stanie sygnalizacji.
.
Language=Romanian
ERROR_IO_INCOMPLETE - Overlapped I/O event is not in a signaled state.
.

MessageId=997
Severity=Success
Facility=System
SymbolicName=ERROR_IO_PENDING
Language=English
ERROR_IO_PENDING - Overlapped I/O operation is in progress.
.
Language=Russian
ERROR_IO_PENDING - Overlapped I/O operation is in progress.
.
Language=Polish
ERROR_IO_PENDING - Pokrywająca się operacja We/Wy jest w toku.
.
Language=Romanian
ERROR_IO_PENDING - Overlapped I/O operation is in progress.
.

MessageId=998
Severity=Success
Facility=System
SymbolicName=ERROR_NOACCESS
Language=English
ERROR_NOACCESS - Invalid access to memory location.
.
Language=Russian
ERROR_NOACCESS - Invalid access to memory location.
.
Language=Polish
ERROR_NOACCESS - Nieprawidłowy dostęp do lokalizacji w pamięci.
.
Language=Romanian
ERROR_NOACCESS - Invalid access to memory location.
.

MessageId=999
Severity=Success
Facility=System
SymbolicName=ERROR_SWAPERROR
Language=English
ERROR_SWAPERROR - Error performing inpage operation.
.
Language=Russian
ERROR_SWAPERROR - Error performing inpage operation.
.
Language=Polish
ERROR_SWAPERROR - Błąd wykonania operacji inpage.
.
Language=Romanian
ERROR_SWAPERROR - Error performing inpage operation.
.

MessageId=1001
Severity=Success
Facility=System
SymbolicName=ERROR_STACK_OVERFLOW
Language=English
ERROR_STACK_OVERFLOW - Recursion too deep; the stack overflowed.
.
Language=Russian
ERROR_STACK_OVERFLOW - Recursion too deep; the stack overflowed.
.
Language=Polish
ERROR_STACK_OVERFLOW - Zbyt głęboka rekursja, stos przepełniony.
.
Language=Romanian
ERROR_STACK_OVERFLOW - Recursion too deep; the stack overflowed.
.

MessageId=1002
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MESSAGE
Language=English
ERROR_INVALID_MESSAGE - The window cannot act on the sent message.
.
Language=Russian
ERROR_INVALID_MESSAGE - The window cannot act on the sent message.
.
Language=Polish
ERROR_INVALID_MESSAGE - Okno nie może operować na wysłanym komunikacie.
.
Language=Romanian
ERROR_INVALID_MESSAGE - The window cannot act on the sent message.
.

MessageId=1003
Severity=Success
Facility=System
SymbolicName=ERROR_CAN_NOT_COMPLETE
Language=English
ERROR_CAN_NOT_COMPLETE - Cannot complete this function.
.
Language=Russian
ERROR_CAN_NOT_COMPLETE - Cannot complete this function.
.
Language=Polish
ERROR_CAN_NOT_COMPLETE - Nie można ukończyć wykonywania tej funkcji.
.
Language=Romanian
ERROR_CAN_NOT_COMPLETE - Cannot complete this function.
.

MessageId=1004
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FLAGS
Language=English
ERROR_INVALID_FLAGS - Invalid flags.
.
Language=Russian
ERROR_INVALID_FLAGS - Invalid flags.
.
Language=Polish
ERROR_INVALID_FLAGS - Nieprawidłowe flagi.
.
Language=Romanian
ERROR_INVALID_FLAGS - Invalid flags.
.

MessageId=1005
Severity=Success
Facility=System
SymbolicName=ERROR_UNRECOGNIZED_VOLUME
Language=English
ERROR_UNRECOGNIZED_VOLUME - The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupted.
.
Language=Russian
ERROR_UNRECOGNIZED_VOLUME - The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupted.
.
Language=Polish
ERROR_UNRECOGNIZED_VOLUME - Wolumin nie zawiera rozpoznawanego systemu plików. Sprawdź, czy załadowano wszystkie wymagane sterowniki systemu plików i czy wolumin nie jest uszkodzony.
.
Language=Romanian
ERROR_UNRECOGNIZED_VOLUME - The volume does not contain a recognized file system. Please make sure that all required file system drivers are loaded and that the volume is not corrupted.
.

MessageId=1006
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_INVALID
Language=English
ERROR_FILE_INVALID - The volume for a file has been externally altered so that the opened file is no longer valid.
.
Language=Russian
ERROR_FILE_INVALID - The volume for a file has been externally altered so that the opened file is no longer valid.
.
Language=Polish
ERROR_FILE_INVALID - Wolumin pliku został zewnętrznie zmieniony w taki sposób, że otwarty plik nie jest już prawidłowy.
.
Language=Romanian
ERROR_FILE_INVALID - The volume for a file has been externally altered so that the opened file is no longer valid.
.

MessageId=1007
Severity=Success
Facility=System
SymbolicName=ERROR_FULLSCREEN_MODE
Language=English
ERROR_FULLSCREEN_MODE - The requested operation cannot be performed in full-screen mode.
.
Language=Russian
ERROR_FULLSCREEN_MODE - The requested operation cannot be performed in full-screen mode.
.
Language=Polish
ERROR_FULLSCREEN_MODE - Nie można wykonać żądanej operacji w trybie pełnoekranowym.
.
Language=Romanian
ERROR_FULLSCREEN_MODE - The requested operation cannot be performed in full-screen mode.
.

MessageId=1008
Severity=Success
Facility=System
SymbolicName=ERROR_NO_TOKEN
Language=English
ERROR_NO_TOKEN - An attempt was made to reference a token that does not exist.
.
Language=Russian
ERROR_NO_TOKEN - An attempt was made to reference a token that does not exist.
.
Language=Polish
ERROR_NO_TOKEN - Wykonano próbę odwołania się do tokena, który nie istnieje.
.
Language=Romanian
ERROR_NO_TOKEN - An attempt was made to reference a token that does not exist.
.

MessageId=1009
Severity=Success
Facility=System
SymbolicName=ERROR_BADDB
Language=English
ERROR_BADDB - The configuration registry database is corrupt.
.
Language=Russian
ERROR_BADDB - The configuration registry database is corrupt.
.
Language=Polish
ERROR_BADDB - Baza danych rejestru konfiguracji jest uszkodzona.
.
Language=Romanian
ERROR_BADDB - The configuration registry database is corrupt.
.

MessageId=1010
Severity=Success
Facility=System
SymbolicName=ERROR_BADKEY
Language=English
ERROR_BADKEY - The configuration registry key is invalid.
.
Language=Russian
ERROR_BADKEY - The configuration registry key is invalid.
.
Language=Polish
ERROR_BADKEY - Klucz rejestru konfiguracji jest nieprawidłowy.
.
Language=Romanian
ERROR_BADKEY - The configuration registry key is invalid.
.

MessageId=1011
Severity=Success
Facility=System
SymbolicName=ERROR_CANTOPEN
Language=English
ERROR_CANTOPEN - The configuration registry key could not be opened.
.
Language=Russian
ERROR_CANTOPEN - The configuration registry key could not be opened.
.
Language=Polish
ERROR_CANTOPEN - Nie można otworzyć klucza rejestru konfiguracji.
.
Language=Romanian
ERROR_CANTOPEN - The configuration registry key could not be opened.
.

MessageId=1012
Severity=Success
Facility=System
SymbolicName=ERROR_CANTREAD
Language=English
ERROR_CANTREAD - The configuration registry key could not be read.
.
Language=Russian
ERROR_CANTREAD - The configuration registry key could not be read.
.
Language=Polish
ERROR_CANTREAD - Nie można odczytać klucza rejestru konfiguracji.
.
Language=Romanian
ERROR_CANTREAD - The configuration registry key could not be read.
.

MessageId=1013
Severity=Success
Facility=System
SymbolicName=ERROR_CANTWRITE
Language=English
ERROR_CANTWRITE - The configuration registry key could not be written.
.
Language=Russian
ERROR_CANTWRITE - The configuration registry key could not be written.
.
Language=Polish
ERROR_CANTWRITE - Nie można zapisać klucza rejestru konfiguracji.
.
Language=Romanian
ERROR_CANTWRITE - The configuration registry key could not be written.
.

MessageId=1014
Severity=Success
Facility=System
SymbolicName=ERROR_REGISTRY_RECOVERED
Language=English
ERROR_REGISTRY_RECOVERED - One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful.
.
Language=Russian
ERROR_REGISTRY_RECOVERED - One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful.
.
Language=Polish
ERROR_REGISTRY_RECOVERED - Jeden z plików w bazie danych rejestru musiał zostać odzyskany za pomocą dziennika lub kopii alternatywnej. Odzyskiwanie zakończyło się pomyślnie.
.
Language=Romanian
ERROR_REGISTRY_RECOVERED - One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful.
.

MessageId=1015
Severity=Success
Facility=System
SymbolicName=ERROR_REGISTRY_CORRUPT
Language=English
ERROR_REGISTRY_CORRUPT - The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system's memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.
.
Language=Russian
ERROR_REGISTRY_CORRUPT - The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system's memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.
.
Language=Polish
ERROR_REGISTRY_CORRUPT - Rejestr jest uszkodzony. Uszkodzona jest struktura jednego z plików zawierających dane Rejestru, uszkodzony jest systemowy obraz pliku w pamięci lub też nie można odzyskać pliku, ponieważ alternatywna kopia lub dziennik były nieobecne lub uszkodzone.
.
Language=Romanian
ERROR_REGISTRY_CORRUPT - The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system's memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.
.

MessageId=1016
Severity=Success
Facility=System
SymbolicName=ERROR_REGISTRY_IO_FAILED
Language=English
ERROR_REGISTRY_IO_FAILED - An I/O operation initiated by the registry failed unrecoverably. The registry could not read in, or write out, or flush, one of the files that contain the system's image of the registry.
.
Language=Russian
ERROR_REGISTRY_IO_FAILED - An I/O operation initiated by the registry failed unrecoverably. The registry could not read in, or write out, or flush, one of the files that contain the system's image of the registry.
.
Language=Polish
ERROR_REGISTRY_IO_FAILED - Operacja We/Wy zainicjowana przez rejestr nie powiodła się w sposób nieodwracalny. Rejestr nie może wczytać, wypisać lub opróżnić jednego z plików zawierających obraz rejestru systemu.
.
Language=Romanian
ERROR_REGISTRY_IO_FAILED - An I/O operation initiated by the registry failed unrecoverably. The registry could not read in, or write out, or flush, one of the files that contain the system's image of the registry.
.

MessageId=1017
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_REGISTRY_FILE
Language=English
ERROR_NOT_REGISTRY_FILE - The system has attempted to load or restore a file into the registry, but the specified file is not in a registry file format.
.
Language=Russian
ERROR_NOT_REGISTRY_FILE - The system has attempted to load or restore a file into the registry, but the specified file is not in a registry file format.
.
Language=Polish
ERROR_NOT_REGISTRY_FILE - System próbował załadować lub przywrócić plik do Rejestru, ale określony plik nie jest w formacie plików Rejestru.
.
Language=Romanian
ERROR_NOT_REGISTRY_FILE - The system has attempted to load or restore a file into the registry, but the specified file is not in a registry file format.
.

MessageId=1018
Severity=Success
Facility=System
SymbolicName=ERROR_KEY_DELETED
Language=English
ERROR_KEY_DELETED - Illegal operation attempted on a registry key that has been marked for deletion.
.
Language=Russian
ERROR_KEY_DELETED - Illegal operation attempted on a registry key that has been marked for deletion.
.
Language=Polish
ERROR_KEY_DELETED - Wykonano próbę niedozwolonej operacji na kluczu Rejestru, który został oznaczony do usunięcia.
.
Language=Romanian
ERROR_KEY_DELETED - Illegal operation attempted on a registry key that has been marked for deletion.
.

MessageId=1019
Severity=Success
Facility=System
SymbolicName=ERROR_NO_LOG_SPACE
Language=English
ERROR_NO_LOG_SPACE - System could not allocate the required space in a registry log.
.
Language=Russian
ERROR_NO_LOG_SPACE - System could not allocate the required space in a registry log.
.
Language=Polish
ERROR_NO_LOG_SPACE - System nie mógł przydzielić wymaganego miejsca w dzienniku Rejestru.
.
Language=Romanian
ERROR_NO_LOG_SPACE - System could not allocate the required space in a registry log.
.

MessageId=1020
Severity=Success
Facility=System
SymbolicName=ERROR_KEY_HAS_CHILDREN
Language=English
ERROR_KEY_HAS_CHILDREN - Cannot create a symbolic link in a registry key that already has subkeys or values.
.
Language=Russian
ERROR_KEY_HAS_CHILDREN - Cannot create a symbolic link in a registry key that already has subkeys or values.
.
Language=Polish
ERROR_KEY_HAS_CHILDREN - W Rejestrze kluczy, który ma już podklucze lub wartości, nie można utworzyć łącza symbolicznego.
.
Language=Romanian
ERROR_KEY_HAS_CHILDREN - Cannot create a symbolic link in a registry key that already has subkeys or values.
.

MessageId=1021
Severity=Success
Facility=System
SymbolicName=ERROR_CHILD_MUST_BE_VOLATILE
Language=English
ERROR_CHILD_MUST_BE_VOLATILE - Cannot create a stable subkey under a volatile parent key.
.
Language=Russian
ERROR_CHILD_MUST_BE_VOLATILE - Cannot create a stable subkey under a volatile parent key.
.
Language=Polish
ERROR_CHILD_MUST_BE_VOLATILE - Dla usuwalnego klucza nadrzędnego nie można utworzyć trwałego podklucza.
.
Language=Romanian
ERROR_CHILD_MUST_BE_VOLATILE - Cannot create a stable subkey under a volatile parent key.
.

MessageId=1022
Severity=Success
Facility=System
SymbolicName=ERROR_NOTIFY_ENUM_DIR
Language=English
ERROR_NOTIFY_ENUM_DIR - A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.
.
Language=Russian
ERROR_NOTIFY_ENUM_DIR - A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.
.
Language=Polish
ERROR_NOTIFY_ENUM_DIR - Żądanie zmiany powiadomienia jest już kończone, a informacje nie są zwracane do buforu komputera wywołującego. Wywołujący musi teraz wyliczyć pliki w celu odnalezienia zmian.
.
Language=Romanian
ERROR_NOTIFY_ENUM_DIR - A notify change request is being completed and the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.
.

MessageId=1051
Severity=Success
Facility=System
SymbolicName=ERROR_DEPENDENT_SERVICES_RUNNING
Language=English
ERROR_DEPENDENT_SERVICES_RUNNING - A stop control has been sent to a service that other running services are dependent on.
.
Language=Russian
ERROR_DEPENDENT_SERVICES_RUNNING - A stop control has been sent to a service that other running services are dependent on.
.
Language=Polish
ERROR_DEPENDENT_SERVICES_RUNNING - Sygnał kontrolny Stop został wysłany do usługi, od której są zależne inne działające usługi.
.
Language=Romanian
ERROR_DEPENDENT_SERVICES_RUNNING - A stop control has been sent to a service that other running services are dependent on.
.

MessageId=1052
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SERVICE_CONTROL
Language=English
ERROR_INVALID_SERVICE_CONTROL - The requested control is not valid for this service.
.
Language=Russian
ERROR_INVALID_SERVICE_CONTROL - The requested control is not valid for this service.
.
Language=Polish
ERROR_INVALID_SERVICE_CONTROL - Żądany sygnał sterujący jest nieprawidłowy dla tej usługi.
.
Language=Romanian
ERROR_INVALID_SERVICE_CONTROL - The requested control is not valid for this service.
.

MessageId=1053
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_REQUEST_TIMEOUT
Language=English
ERROR_SERVICE_REQUEST_TIMEOUT - The service did not respond to the start or control request in a timely fashion.
.
Language=Russian
ERROR_SERVICE_REQUEST_TIMEOUT - The service did not respond to the start or control request in a timely fashion.
.
Language=Polish
ERROR_SERVICE_REQUEST_TIMEOUT - Usługa nie odpowiada na sygnał uruchomienia lub sygnał sterujący w oczekiwanym czasie.
.
Language=Romanian
ERROR_SERVICE_REQUEST_TIMEOUT - The service did not respond to the start or control request in a timely fashion.
.

MessageId=1054
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_NO_THREAD
Language=English
ERROR_SERVICE_NO_THREAD - A thread could not be created for the service.
.
Language=Russian
ERROR_SERVICE_NO_THREAD - A thread could not be created for the service.
.
Language=Polish
ERROR_SERVICE_NO_THREAD - Nie można utworzyć wątku dla tej usługi.
.
Language=Romanian
ERROR_SERVICE_NO_THREAD - A thread could not be created for the service.
.

MessageId=1055
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_DATABASE_LOCKED
Language=English
ERROR_SERVICE_DATABASE_LOCKED - The service database is locked.
.
Language=Russian
ERROR_SERVICE_DATABASE_LOCKED - The service database is locked.
.
Language=Polish
ERROR_SERVICE_DATABASE_LOCKED - Baza danych usługi jest zablokowana.
.
Language=Romanian
ERROR_SERVICE_DATABASE_LOCKED - The service database is locked.
.

MessageId=1056
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_ALREADY_RUNNING
Language=English
ERROR_SERVICE_ALREADY_RUNNING - An instance of the service is already running.
.
Language=Russian
ERROR_SERVICE_ALREADY_RUNNING - An instance of the service is already running.
.
Language=Polish
ERROR_SERVICE_ALREADY_RUNNING - Jedno wystąpienie usługi już działa.
.
Language=Romanian
ERROR_SERVICE_ALREADY_RUNNING - An instance of the service is already running.
.

MessageId=1057
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SERVICE_ACCOUNT
Language=English
ERROR_INVALID_SERVICE_ACCOUNT - The account name is invalid or does not exist, or the password is invalid for the account name specified.
.
Language=Russian
ERROR_INVALID_SERVICE_ACCOUNT - The account name is invalid or does not exist, or the password is invalid for the account name specified.
.
Language=Polish
ERROR_INVALID_SERVICE_ACCOUNT - Nazwa konta jest nieprawidłowa lub nie istnieje albo hasło dla podanej nazwy konta jest nieprawidłowe.
.
Language=Romanian
ERROR_INVALID_SERVICE_ACCOUNT - The account name is invalid or does not exist, or the password is invalid for the account name specified.
.

MessageId=1058
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_DISABLED
Language=English
ERROR_SERVICE_DISABLED - The service cannot be started, either because it is disabled or because it has no enabled devices associated with it.
.
Language=Russian
ERROR_SERVICE_DISABLED - The service cannot be started, either because it is disabled or because it has no enabled devices associated with it.
.
Language=Polish
ERROR_SERVICE_DISABLED - Nie można uruchomić określonej usługi, ponieważ jest ona wyłączona lub ponieważ nie są włączone skojarzone z nią urządzenia.
.
Language=Romanian
ERROR_SERVICE_DISABLED - The service cannot be started, either because it is disabled or because it has no enabled devices associated with it.
.

MessageId=1059
Severity=Success
Facility=System
SymbolicName=ERROR_CIRCULAR_DEPENDENCY
Language=English
ERROR_CIRCULAR_DEPENDENCY - Circular service dependency was specified.
.
Language=Russian
ERROR_CIRCULAR_DEPENDENCY - Circular service dependency was specified.
.
Language=Polish
ERROR_CIRCULAR_DEPENDENCY - Określono cykliczną zależność usługi.
.
Language=Romanian
ERROR_CIRCULAR_DEPENDENCY - Circular service dependency was specified.
.

MessageId=1060
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_DOES_NOT_EXIST
Language=English
ERROR_SERVICE_DOES_NOT_EXIST - The specified service does not exist as an installed service.
.
Language=Russian
ERROR_SERVICE_DOES_NOT_EXIST - The specified service does not exist as an installed service.
.
Language=Polish
ERROR_SERVICE_DOES_NOT_EXIST - Określona usługa nie istnieje jako usługa zainstalowana.
.
Language=Romanian
ERROR_SERVICE_DOES_NOT_EXIST - The specified service does not exist as an installed service.
.

MessageId=1061
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_CANNOT_ACCEPT_CTRL
Language=English
ERROR_SERVICE_CANNOT_ACCEPT_CTRL - The service cannot accept control messages at this time.
.
Language=Russian
ERROR_SERVICE_CANNOT_ACCEPT_CTRL - The service cannot accept control messages at this time.
.
Language=Polish
ERROR_SERVICE_CANNOT_ACCEPT_CTRL - Usługa nie może teraz zaakceptować komunikatów sterujących.
.
Language=Romanian
ERROR_SERVICE_CANNOT_ACCEPT_CTRL - The service cannot accept control messages at this time.
.

MessageId=1062
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_NOT_ACTIVE
Language=English
ERROR_SERVICE_NOT_ACTIVE - The service has not been started.
.
Language=Russian
ERROR_SERVICE_NOT_ACTIVE - The service has not been started.
.
Language=Polish
ERROR_SERVICE_NOT_ACTIVE - Usługa nie została uruchomiona.
.
Language=Romanian
ERROR_SERVICE_NOT_ACTIVE - The service has not been started.
.

MessageId=1063
Severity=Success
Facility=System
SymbolicName=ERROR_FAILED_SERVICE_CONTROLLER_CONNECT
Language=English
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT - The service process could not connect to the service controller.
.
Language=Russian
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT - The service process could not connect to the service controller.
.
Language=Polish
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT - Proces usługi nie mógł połączyć się z kontrolerem usługi.
.
Language=Romanian
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT - The service process could not connect to the service controller.
.

MessageId=1064
Severity=Success
Facility=System
SymbolicName=ERROR_EXCEPTION_IN_SERVICE
Language=English
ERROR_EXCEPTION_IN_SERVICE - An exception occurred in the service when handling the control request.
.
Language=Russian
ERROR_EXCEPTION_IN_SERVICE - An exception occurred in the service when handling the control request.
.
Language=Polish
ERROR_EXCEPTION_IN_SERVICE - W usłudze wystąpił wyjątek podczas obsługi żądania kontroli.
.
Language=Romanian
ERROR_EXCEPTION_IN_SERVICE - An exception occurred in the service when handling the control request.
.

MessageId=1065
Severity=Success
Facility=System
SymbolicName=ERROR_DATABASE_DOES_NOT_EXIST
Language=English
ERROR_DATABASE_DOES_NOT_EXIST - The database specified does not exist.
.
Language=Russian
ERROR_DATABASE_DOES_NOT_EXIST - The database specified does not exist.
.
Language=Polish
ERROR_DATABASE_DOES_NOT_EXIST - Określona baza danych nie istnieje.
.
Language=Romanian
ERROR_DATABASE_DOES_NOT_EXIST - The database specified does not exist.
.

MessageId=1066
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_SPECIFIC_ERROR
Language=English
ERROR_SERVICE_SPECIFIC_ERROR - The service has returned a service-specific error code.
.
Language=Russian
ERROR_SERVICE_SPECIFIC_ERROR - The service has returned a service-specific error code.
.
Language=Polish
ERROR_SERVICE_SPECIFIC_ERROR - Usługa zwróciła kod błędu specyficzny dla tej usługi.
.
Language=Romanian
ERROR_SERVICE_SPECIFIC_ERROR - The service has returned a service-specific error code.
.

MessageId=1067
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_ABORTED
Language=English
ERROR_PROCESS_ABORTED - The process terminated unexpectedly.
.
Language=Russian
ERROR_PROCESS_ABORTED - The process terminated unexpectedly.
.
Language=Polish
ERROR_PROCESS_ABORTED - Proces zakończył się nieoczekiwanie.
.
Language=Romanian
ERROR_PROCESS_ABORTED - The process terminated unexpectedly.
.

MessageId=1068
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_DEPENDENCY_FAIL
Language=English
ERROR_SERVICE_DEPENDENCY_FAIL - The dependency service or group failed to start.
.
Language=Russian
ERROR_SERVICE_DEPENDENCY_FAIL - The dependency service or group failed to start.
.
Language=Polish
ERROR_SERVICE_DEPENDENCY_FAIL - Uruchomienie usługi zależności lub grupy nie powiodło się.
.
Language=Romanian
ERROR_SERVICE_DEPENDENCY_FAIL - The dependency service or group failed to start.
.

MessageId=1069
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_LOGON_FAILED
Language=English
ERROR_SERVICE_LOGON_FAILED - The service did not start due to a logon failure.
.
Language=Russian
ERROR_SERVICE_LOGON_FAILED - The service did not start due to a logon failure.
.
Language=Polish
ERROR_SERVICE_LOGON_FAILED - Usługa nie została uruchomiona z powodu nieudanego logowania.
.
Language=Romanian
ERROR_SERVICE_LOGON_FAILED - The service did not start due to a logon failure.
.

MessageId=1070
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_START_HANG
Language=English
ERROR_SERVICE_START_HANG - After starting, the service hung in a start-pending state.
.
Language=Russian
ERROR_SERVICE_START_HANG - After starting, the service hung in a start-pending state.
.
Language=Polish
ERROR_SERVICE_START_HANG - Po uruchomieniu usługa uległa zawieszeniu w stanie startowym.
.
Language=Romanian
ERROR_SERVICE_START_HANG - After starting, the service hung in a start-pending state.
.

MessageId=1071
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SERVICE_LOCK
Language=English
ERROR_INVALID_SERVICE_LOCK - The specified service database lock is invalid.
.
Language=Russian
ERROR_INVALID_SERVICE_LOCK - The specified service database lock is invalid.
.
Language=Polish
ERROR_INVALID_SERVICE_LOCK - Określona blokada bazy danych usługi jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_SERVICE_LOCK - The specified service database lock is invalid.
.

MessageId=1072
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_MARKED_FOR_DELETE
Language=English
ERROR_SERVICE_MARKED_FOR_DELETE - The specified service has been marked for deletion.
.
Language=Russian
ERROR_SERVICE_MARKED_FOR_DELETE - The specified service has been marked for deletion.
.
Language=Polish
ERROR_SERVICE_MARKED_FOR_DELETE - Określona usługa została oznaczona do usunięcia.
.
Language=Romanian
ERROR_SERVICE_MARKED_FOR_DELETE - The specified service has been marked for deletion.
.

MessageId=1073
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_EXISTS
Language=English
ERROR_SERVICE_EXISTS - The specified service already exists.
.
Language=Russian
ERROR_SERVICE_EXISTS - The specified service already exists.
.
Language=Polish
ERROR_SERVICE_EXISTS - Określona usługa już istnieje.
.
Language=Romanian
ERROR_SERVICE_EXISTS - The specified service already exists.
.

MessageId=1074
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_RUNNING_LKG
Language=English
ERROR_ALREADY_RUNNING_LKG - The system is currently running with the last-known-good configuration.
.
Language=Russian
ERROR_ALREADY_RUNNING_LKG - The system is currently running with the last-known-good configuration.
.
Language=Polish
ERROR_ALREADY_RUNNING_LKG - System działa obecnie w ostatniej znanej dobrej konfiguracji.
.
Language=Romanian
ERROR_ALREADY_RUNNING_LKG - The system is currently running with the last-known-good configuration.
.

MessageId=1075
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_DEPENDENCY_DELETED
Language=English
ERROR_SERVICE_DEPENDENCY_DELETED - The dependency service does not exist or has been marked for deletion.
.
Language=Russian
ERROR_SERVICE_DEPENDENCY_DELETED - The dependency service does not exist or has been marked for deletion.
.
Language=Polish
ERROR_SERVICE_DEPENDENCY_DELETED - Usługa zależności nie istnieje lub została oznaczona do usunięcia.
.
Language=Romanian
ERROR_SERVICE_DEPENDENCY_DELETED - The dependency service does not exist or has been marked for deletion.
.

MessageId=1076
Severity=Success
Facility=System
SymbolicName=ERROR_BOOT_ALREADY_ACCEPTED
Language=English
ERROR_BOOT_ALREADY_ACCEPTED - The current boot has already been accepted for use as the last-known-good control set.
.
Language=Russian
ERROR_BOOT_ALREADY_ACCEPTED - The current boot has already been accepted for use as the last-known-good control set.
.
Language=Polish
ERROR_BOOT_ALREADY_ACCEPTED - Bieżące uruchomienie zostało już zaakceptowane do użycia jako ostatni znany dobry zestaw sterujący.
.
Language=Romanian
ERROR_BOOT_ALREADY_ACCEPTED - The current boot has already been accepted for use as the last-known-good control set.
.

MessageId=1077
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_NEVER_STARTED
Language=English
ERROR_SERVICE_NEVER_STARTED - No attempts to start the service have been made since the last boot.
.
Language=Russian
ERROR_SERVICE_NEVER_STARTED - No attempts to start the service have been made since the last boot.
.
Language=Polish
ERROR_SERVICE_NEVER_STARTED - Od czasu ostatniego uruchomienia komputera nie podejmowano prób uruchomienia usługi.
.
Language=Romanian
ERROR_SERVICE_NEVER_STARTED - No attempts to start the service have been made since the last boot.
.

MessageId=1078
Severity=Success
Facility=System
SymbolicName=ERROR_DUPLICATE_SERVICE_NAME
Language=English
ERROR_DUPLICATE_SERVICE_NAME - The name is already in use as either a service name or a service display name.
.
Language=Russian
ERROR_DUPLICATE_SERVICE_NAME - The name is already in use as either a service name or a service display name.
.
Language=Polish
ERROR_DUPLICATE_SERVICE_NAME - Nazwa jest już w użyciu jako nazwa usługi lub wyświetlana nazwa usługi.
.
Language=Romanian
ERROR_DUPLICATE_SERVICE_NAME - The name is already in use as either a service name or a service display name.
.

MessageId=1079
Severity=Success
Facility=System
SymbolicName=ERROR_DIFFERENT_SERVICE_ACCOUNT
Language=English
ERROR_DIFFERENT_SERVICE_ACCOUNT - The account specified for this service is different from the account specified for other services running in the same process.
.
Language=Russian
ERROR_DIFFERENT_SERVICE_ACCOUNT - The account specified for this service is different from the account specified for other services running in the same process.
.
Language=Polish
ERROR_DIFFERENT_SERVICE_ACCOUNT - Konto podane dla tej usługi różni się od konta podanego dla innych usług działających w tym samym procesie.
.
Language=Romanian
ERROR_DIFFERENT_SERVICE_ACCOUNT - The account specified for this service is different from the account specified for other services running in the same process.
.

MessageId=1080
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_DETECT_DRIVER_FAILURE
Language=English
ERROR_CANNOT_DETECT_DRIVER_FAILURE - Failure actions can only be set for Win32 services, not for drivers.
.
Language=Russian
ERROR_CANNOT_DETECT_DRIVER_FAILURE - Failure actions can only be set for Win32 services, not for drivers.
.
Language=Polish
ERROR_CANNOT_DETECT_DRIVER_FAILURE - Akcje przypisane do błędów można ustawić tylko dla usług Win32, a nie dla sterowników.
.
Language=Romanian
ERROR_CANNOT_DETECT_DRIVER_FAILURE - Failure actions can only be set for Win32 services, not for drivers.
.

MessageId=1081
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_DETECT_PROCESS_ABORT
Language=English
ERROR_CANNOT_DETECT_PROCESS_ABORT - This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service's process terminates unexpectedly.
.
Language=Russian
ERROR_CANNOT_DETECT_PROCESS_ABORT - This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service's process terminates unexpectedly.
.
Language=Polish
ERROR_CANNOT_DETECT_PROCESS_ABORT - Ta usługa działa w tym samym procesie, co Menedżer sterowania usługami. Z tego powodu Menedżer sterowania usługami nie będzie mógł podjąć działań, gdy proces tej usługi niespodziewanie się zakończy.
.
Language=Romanian
ERROR_CANNOT_DETECT_PROCESS_ABORT - This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service's process terminates unexpectedly.
.

MessageId=1082
Severity=Success
Facility=System
SymbolicName=ERROR_NO_RECOVERY_PROGRAM
Language=English
ERROR_NO_RECOVERY_PROGRAM - No recovery program has been configured for this service.
.
Language=Russian
ERROR_NO_RECOVERY_PROGRAM - No recovery program has been configured for this service.
.
Language=Polish
ERROR_NO_RECOVERY_PROGRAM - Żaden program odzyskiwania nie został skonfigurowany dla tej usługi.
.
Language=Romanian
ERROR_NO_RECOVERY_PROGRAM - No recovery program has been configured for this service.
.

MessageId=1083
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_NOT_IN_EXE
Language=English
ERROR_SERVICE_NOT_IN_EXE - The executable program that this service is configured to run in does not implement the service.
.
Language=Russian
ERROR_SERVICE_NOT_IN_EXE - The executable program that this service is configured to run in does not implement the service.
.
Language=Polish
ERROR_SERVICE_NOT_IN_EXE - Program wykonywalny, w którym ta usługa (zgodnie z jej konfiguracją) ma być uruchomiona, nie implementuje usługi.
.
Language=Romanian
ERROR_SERVICE_NOT_IN_EXE - The executable program that this service is configured to run in does not implement the service.
.

MessageId=1084
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SAFEBOOT_SERVICE
Language=English
ERROR_NOT_SAFEBOOT_SERVICE - This service cannot be started in Safe Mode.
.
Language=Russian
ERROR_NOT_SAFEBOOT_SERVICE - This service cannot be started in Safe Mode.
.
Language=Polish
ERROR_NOT_SAFEBOOT_SERVICE - Tej usługi nie można uruchomić w trybie awaryjnym
.
Language=Romanian
ERROR_NOT_SAFEBOOT_SERVICE - This service cannot be started in Safe Mode.
.

MessageId=1100
Severity=Success
Facility=System
SymbolicName=ERROR_END_OF_MEDIA
Language=English
ERROR_END_OF_MEDIA - The physical end of the tape has been reached.
.
Language=Russian
ERROR_END_OF_MEDIA - The physical end of the tape has been reached.
.
Language=Polish
ERROR_END_OF_MEDIA - Osiągnięto fizyczny koniec taśmy.
.
Language=Romanian
ERROR_END_OF_MEDIA - The physical end of the tape has been reached.
.

MessageId=1101
Severity=Success
Facility=System
SymbolicName=ERROR_FILEMARK_DETECTED
Language=English
ERROR_FILEMARK_DETECTED - A tape access reached a filemark.
.
Language=Russian
ERROR_FILEMARK_DETECTED - A tape access reached a filemark.
.
Language=Polish
ERROR_FILEMARK_DETECTED - Osiągnięto znacznik pliku na taśmie.
.
Language=Romanian
ERROR_FILEMARK_DETECTED - A tape access reached a filemark.
.

MessageId=1102
Severity=Success
Facility=System
SymbolicName=ERROR_BEGINNING_OF_MEDIA
Language=English
ERROR_BEGINNING_OF_MEDIA - The beginning of the tape or a partition was encountered.
.
Language=Russian
ERROR_BEGINNING_OF_MEDIA - The beginning of the tape or a partition was encountered.
.
Language=Polish
ERROR_BEGINNING_OF_MEDIA - Napotkano początek taśmy lub partycji.
.
Language=Romanian
ERROR_BEGINNING_OF_MEDIA - The beginning of the tape or a partition was encountered.
.

MessageId=1103
Severity=Success
Facility=System
SymbolicName=ERROR_SETMARK_DETECTED
Language=English
ERROR_SETMARK_DETECTED - A tape access reached the end of a set of files.
.
Language=Russian
ERROR_SETMARK_DETECTED - A tape access reached the end of a set of files.
.
Language=Polish
ERROR_SETMARK_DETECTED - Osiągnięto koniec zestawu plików na taśmie.
.
Language=Romanian
ERROR_SETMARK_DETECTED - A tape access reached the end of a set of files.
.

MessageId=1104
Severity=Success
Facility=System
SymbolicName=ERROR_NO_DATA_DETECTED
Language=English
ERROR_NO_DATA_DETECTED - No more data is on the tape.
.
Language=Russian
ERROR_NO_DATA_DETECTED - No more data is on the tape.
.
Language=Polish
ERROR_NO_DATA_DETECTED - Na taśmie brak dalszych danych.
.
Language=Romanian
ERROR_NO_DATA_DETECTED - No more data is on the tape.
.

MessageId=1105
Severity=Success
Facility=System
SymbolicName=ERROR_PARTITION_FAILURE
Language=English
ERROR_PARTITION_FAILURE - Tape could not be partitioned.
.
Language=Russian
ERROR_PARTITION_FAILURE - Tape could not be partitioned.
.
Language=Polish
ERROR_PARTITION_FAILURE - Nie można podzielić taśmy na partycje.
.
Language=Romanian
ERROR_PARTITION_FAILURE - Tape could not be partitioned.
.

MessageId=1106
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_BLOCK_LENGTH
Language=English
ERROR_INVALID_BLOCK_LENGTH - When accessing a new tape of a multivolume partition, the current block size is incorrect.
.
Language=Russian
ERROR_INVALID_BLOCK_LENGTH - When accessing a new tape of a multivolume partition, the current block size is incorrect.
.
Language=Polish
ERROR_INVALID_BLOCK_LENGTH - W trakcie uzyskiwania dostępu do nowej taśmy w partycji o wielu woluminach, bieżący rozmiar bloku jest niepoprawny.
.
Language=Romanian
ERROR_INVALID_BLOCK_LENGTH - When accessing a new tape of a multivolume partition, the current block size is incorrect.
.

MessageId=1107
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_NOT_PARTITIONED
Language=English
ERROR_DEVICE_NOT_PARTITIONED - Tape partition information could not be found when loading a tape.
.
Language=Russian
ERROR_DEVICE_NOT_PARTITIONED - Tape partition information could not be found when loading a tape.
.
Language=Polish
ERROR_DEVICE_NOT_PARTITIONED - Podczas ładowania taśmy nie odnaleziono informacji o jej partycjach.
.
Language=Romanian
ERROR_DEVICE_NOT_PARTITIONED - Tape partition information could not be found when loading a tape.
.

MessageId=1108
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_LOCK_MEDIA
Language=English
ERROR_UNABLE_TO_LOCK_MEDIA - Unable to lock the media eject mechanism.
.
Language=Russian
ERROR_UNABLE_TO_LOCK_MEDIA - Unable to lock the media eject mechanism.
.
Language=Polish
ERROR_UNABLE_TO_LOCK_MEDIA - Nie można zablokować mechanizmu wysuwu nośnika.
.
Language=Romanian
ERROR_UNABLE_TO_LOCK_MEDIA - Unable to lock the media eject mechanism.
.

MessageId=1109
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_UNLOAD_MEDIA
Language=English
ERROR_UNABLE_TO_UNLOAD_MEDIA - Unable to unload the media.
.
Language=Russian
ERROR_UNABLE_TO_UNLOAD_MEDIA - Unable to unload the media.
.
Language=Polish
ERROR_UNABLE_TO_UNLOAD_MEDIA - Nie można usunąć nośnika z pamięci.
.
Language=Romanian
ERROR_UNABLE_TO_UNLOAD_MEDIA - Unable to unload the media.
.

MessageId=1110
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_CHANGED
Language=English
ERROR_MEDIA_CHANGED - The media in the drive may have changed.
.
Language=Russian
ERROR_MEDIA_CHANGED - The media in the drive may have changed.
.
Language=Polish
ERROR_MEDIA_CHANGED - Nośnik w stacji mógł się zmienić.
.
Language=Romanian
ERROR_MEDIA_CHANGED - The media in the drive may have changed.
.

MessageId=1111
Severity=Success
Facility=System
SymbolicName=ERROR_BUS_RESET
Language=English
ERROR_BUS_RESET - The I/O bus was reset.
.
Language=Russian
ERROR_BUS_RESET - The I/O bus was reset.
.
Language=Polish
ERROR_BUS_RESET - Magistrala We/Wy została zresetowana.
.
Language=Romanian
ERROR_BUS_RESET - The I/O bus was reset.
.

MessageId=1112
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MEDIA_IN_DRIVE
Language=English
ERROR_NO_MEDIA_IN_DRIVE - No media in drive.
.
Language=Russian
ERROR_NO_MEDIA_IN_DRIVE - No media in drive.
.
Language=Polish
ERROR_NO_MEDIA_IN_DRIVE - Brak nośnika w stacji.
.
Language=Romanian
ERROR_NO_MEDIA_IN_DRIVE - No media in drive.
.

MessageId=1113
Severity=Success
Facility=System
SymbolicName=ERROR_NO_UNICODE_TRANSLATION
Language=English
ERROR_NO_UNICODE_TRANSLATION - No mapping for the Unicode character exists in the target multi-byte code page.
.
Language=Russian
ERROR_NO_UNICODE_TRANSLATION - No mapping for the Unicode character exists in the target multi-byte code page.
.
Language=Polish
ERROR_NO_UNICODE_TRANSLATION - Brak mapowania dla tego znaku Unicode w docelowej wielobajtowej stronie kodowej.
.
Language=Romanian
ERROR_NO_UNICODE_TRANSLATION - No mapping for the Unicode character exists in the target multi-byte code page.
.

MessageId=1114
Severity=Success
Facility=System
SymbolicName=ERROR_DLL_INIT_FAILED
Language=English
ERROR_DLL_INIT_FAILED - A dynamic link library (DLL) initialization routine failed.
.
Language=Russian
ERROR_DLL_INIT_FAILED - A dynamic link library (DLL) initialization routine failed.
.
Language=Polish
ERROR_DLL_INIT_FAILED - Procedura inicjowania biblioteki dołączanej dynamicznie (DLL) nie powiodła się.
.
Language=Romanian
ERROR_DLL_INIT_FAILED - A dynamic link library (DLL) initialization routine failed.
.

MessageId=1115
Severity=Success
Facility=System
SymbolicName=ERROR_SHUTDOWN_IN_PROGRESS
Language=English
ERROR_SHUTDOWN_IN_PROGRESS - A system shutdown is in progress.
.
Language=Russian
ERROR_SHUTDOWN_IN_PROGRESS - A system shutdown is in progress.
.
Language=Polish
ERROR_SHUTDOWN_IN_PROGRESS - Trwa proces zamykania systemu.
.
Language=Romanian
ERROR_SHUTDOWN_IN_PROGRESS - A system shutdown is in progress.
.

MessageId=1116
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SHUTDOWN_IN_PROGRESS
Language=English
ERROR_NO_SHUTDOWN_IN_PROGRESS - Unable to abort the system shutdown because no shutdown was in progress.
.
Language=Russian
ERROR_NO_SHUTDOWN_IN_PROGRESS - Unable to abort the system shutdown because no shutdown was in progress.
.
Language=Polish
ERROR_NO_SHUTDOWN_IN_PROGRESS - Nie można przerwać procesu zamykania systemu, ponieważ taki proces nie jest w toku.
.
Language=Romanian
ERROR_NO_SHUTDOWN_IN_PROGRESS - Unable to abort the system shutdown because no shutdown was in progress.
.

MessageId=1117
Severity=Success
Facility=System
SymbolicName=ERROR_IO_DEVICE
Language=English
ERROR_IO_DEVICE - The request could not be performed because of an I/O device error.
.
Language=Russian
ERROR_IO_DEVICE - The request could not be performed because of an I/O device error.
.
Language=Polish
ERROR_IO_DEVICE - Nie można wykonać żądania z powodu błędu urządzenia We/Wy.
.
Language=Romanian
ERROR_IO_DEVICE - The request could not be performed because of an I/O device error.
.

MessageId=1118
Severity=Success
Facility=System
SymbolicName=ERROR_SERIAL_NO_DEVICE
Language=English
ERROR_SERIAL_NO_DEVICE - No serial device was successfully initialized. The serial driver will unload.
.
Language=Russian
ERROR_SERIAL_NO_DEVICE - No serial device was successfully initialized. The serial driver will unload.
.
Language=Polish
ERROR_SERIAL_NO_DEVICE - Żadne urządzenie szeregowe nie zostało pomyślnie zainicjowane. Sterownik szeregowy zostanie usunięty z pamięci.
.
Language=Romanian
ERROR_SERIAL_NO_DEVICE - No serial device was successfully initialized. The serial driver will unload.
.

MessageId=1119
Severity=Success
Facility=System
SymbolicName=ERROR_IRQ_BUSY
Language=English
ERROR_IRQ_BUSY - Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.
.
Language=Russian
ERROR_IRQ_BUSY - Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.
.
Language=Polish
ERROR_IRQ_BUSY - Nie można otworzyć urządzenia, które współużytkowało przerwanie (IRQ) z innymi urządzeniami. Co najmniej jedno inne urządzenie używające tego IRQ zostało już otwarte.
.
Language=Romanian
ERROR_IRQ_BUSY - Unable to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened.
.

MessageId=1120
Severity=Success
Facility=System
SymbolicName=ERROR_MORE_WRITES
Language=English
ERROR_MORE_WRITES - A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
.
Language=Russian
ERROR_MORE_WRITES - A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
.
Language=Polish
ERROR_MORE_WRITES - Operacja szeregowego We/Wy została zakończona przez inny zapis do portu szeregowego. (Licznik IOCTL_SERIAL_XOFF_COUNTER osiągnął zero.)
.
Language=Romanian
ERROR_MORE_WRITES - A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
.

MessageId=1121
Severity=Success
Facility=System
SymbolicName=ERROR_COUNTER_TIMEOUT
Language=English
ERROR_COUNTER_TIMEOUT - A serial I/O operation completed because the timeout period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)
.
Language=Russian
ERROR_COUNTER_TIMEOUT - A serial I/O operation completed because the timeout period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)
.
Language=Polish
ERROR_COUNTER_TIMEOUT - Operacja szeregowego We/Wy została zakończona z powodu przekroczenia limitu czasu. (Licznik IOCTL_SERIAL_XOFF_COUNTER nie osiągnął wartości zero.)
.
Language=Romanian
ERROR_COUNTER_TIMEOUT - A serial I/O operation completed because the timeout period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)
.

MessageId=1122
Severity=Success
Facility=System
SymbolicName=ERROR_FLOPPY_ID_MARK_NOT_FOUND
Language=English
ERROR_FLOPPY_ID_MARK_NOT_FOUND - No ID address mark was found on the floppy disk.
.
Language=Russian
ERROR_FLOPPY_ID_MARK_NOT_FOUND - No ID address mark was found on the floppy disk.
.
Language=Polish
ERROR_FLOPPY_ID_MARK_NOT_FOUND - Na dyskietce nie znaleziono znacznika adresu identyfikatora.
.
Language=Romanian
ERROR_FLOPPY_ID_MARK_NOT_FOUND - No ID address mark was found on the floppy disk.
.

MessageId=1123
Severity=Success
Facility=System
SymbolicName=ERROR_FLOPPY_WRONG_CYLINDER
Language=English
ERROR_FLOPPY_WRONG_CYLINDER - Mismatch between the floppy disk sector ID field and the floppy disk controller track address.
.
Language=Russian
ERROR_FLOPPY_WRONG_CYLINDER - Mismatch between the floppy disk sector ID field and the floppy disk controller track address.
.
Language=Polish
ERROR_FLOPPY_WRONG_CYLINDER - Niedopasowanie między polem identyfikatora sektora dyskietki i adresem ścieżki kontrolera stacji dyskietek.
.
Language=Romanian
ERROR_FLOPPY_WRONG_CYLINDER - Mismatch between the floppy disk sector ID field and the floppy disk controller track address.
.

MessageId=1124
Severity=Success
Facility=System
SymbolicName=ERROR_FLOPPY_UNKNOWN_ERROR
Language=English
ERROR_FLOPPY_UNKNOWN_ERROR - The floppy disk controller reported an error that is not recognized by the floppy disk driver.
.
Language=Russian
ERROR_FLOPPY_UNKNOWN_ERROR - The floppy disk controller reported an error that is not recognized by the floppy disk driver.
.
Language=Polish
ERROR_FLOPPY_UNKNOWN_ERROR - Kontroler stacji dyskietek zgłosił błąd, który nie został rozpoznany przez sterownik stacji dyskietek.
.
Language=Romanian
ERROR_FLOPPY_UNKNOWN_ERROR - The floppy disk controller reported an error that is not recognized by the floppy disk driver.
.

MessageId=1125
Severity=Success
Facility=System
SymbolicName=ERROR_FLOPPY_BAD_REGISTERS
Language=English
ERROR_FLOPPY_BAD_REGISTERS - The floppy disk controller returned inconsistent results in its registers.
.
Language=Russian
ERROR_FLOPPY_BAD_REGISTERS - The floppy disk controller returned inconsistent results in its registers.
.
Language=Polish
ERROR_FLOPPY_BAD_REGISTERS - Kontroler stacji dyskietek zwrócił w swych rejestrach niezgodne wyniki.
.
Language=Romanian
ERROR_FLOPPY_BAD_REGISTERS - The floppy disk controller returned inconsistent results in its registers.
.

MessageId=1126
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_RECALIBRATE_FAILED
Language=English
ERROR_DISK_RECALIBRATE_FAILED - While accessing the hard disk, a recalibrate operation failed, even after retries.
.
Language=Russian
ERROR_DISK_RECALIBRATE_FAILED - While accessing the hard disk, a recalibrate operation failed, even after retries.
.
Language=Polish
ERROR_DISK_RECALIBRATE_FAILED - Podczas uzyskiwania dostępu do dysku twardego operacja rekalibracji nie powiodła się, mimo ponawiania prób.
.
Language=Romanian
ERROR_DISK_RECALIBRATE_FAILED - While accessing the hard disk, a recalibrate operation failed, even after retries.
.

MessageId=1127
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_OPERATION_FAILED
Language=English
ERROR_DISK_OPERATION_FAILED - While accessing the hard disk, a disk operation failed even after retries.
.
Language=Russian
ERROR_DISK_OPERATION_FAILED - While accessing the hard disk, a disk operation failed even after retries.
.
Language=Polish
ERROR_DISK_OPERATION_FAILED - Podczas uzyskiwania dostępu do dysku twardego operacja dyskowa nie powiodła się, mimo ponawiania prób.
.
Language=Romanian
ERROR_DISK_OPERATION_FAILED - While accessing the hard disk, a disk operation failed even after retries.
.

MessageId=1128
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_RESET_FAILED
Language=English
ERROR_DISK_RESET_FAILED - While accessing the hard disk, a disk controller reset was needed, but even that failed.
.
Language=Russian
ERROR_DISK_RESET_FAILED - While accessing the hard disk, a disk controller reset was needed, but even that failed.
.
Language=Polish
ERROR_DISK_RESET_FAILED - Podczas uzyskiwania dostępu do dysku twardego, niezbędna była operacja resetowania kontrolera dysku; nawet to nie przyniosło oczekiwanego rezultatu.
.
Language=Romanian
ERROR_DISK_RESET_FAILED - While accessing the hard disk, a disk controller reset was needed, but even that failed.
.

MessageId=1129
Severity=Success
Facility=System
SymbolicName=ERROR_EOM_OVERFLOW
Language=English
ERROR_EOM_OVERFLOW - Physical end of tape encountered.
.
Language=Russian
ERROR_EOM_OVERFLOW - Physical end of tape encountered.
.
Language=Polish
ERROR_EOM_OVERFLOW - Napotkano fizyczny koniec taśmy.
.
Language=Romanian
ERROR_EOM_OVERFLOW - Physical end of tape encountered.
.

MessageId=1130
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_ENOUGH_SERVER_MEMORY
Language=English
ERROR_NOT_ENOUGH_SERVER_MEMORY - Not enough server storage is available to process this command.
.
Language=Russian
ERROR_NOT_ENOUGH_SERVER_MEMORY - Not enough server storage is available to process this command.
.
Language=Polish
ERROR_NOT_ENOUGH_SERVER_MEMORY - Za mało pamięci serwera do przetworzenia tego polecenia.
.
Language=Romanian
ERROR_NOT_ENOUGH_SERVER_MEMORY - Not enough server storage is available to process this command.
.

MessageId=1131
Severity=Success
Facility=System
SymbolicName=ERROR_POSSIBLE_DEADLOCK
Language=English
ERROR_POSSIBLE_DEADLOCK - A potential deadlock condition has been detected.
.
Language=Russian
ERROR_POSSIBLE_DEADLOCK - A potential deadlock condition has been detected.
.
Language=Polish
ERROR_POSSIBLE_DEADLOCK - Wykryto możliwość wystąpienia stanu zakleszczenia (deadlock).
.
Language=Romanian
ERROR_POSSIBLE_DEADLOCK - A potential deadlock condition has been detected.
.

MessageId=1132
Severity=Success
Facility=System
SymbolicName=ERROR_MAPPED_ALIGNMENT
Language=English
ERROR_MAPPED_ALIGNMENT - The base address or the file offset specified does not have the proper alignment.
.
Language=Russian
ERROR_MAPPED_ALIGNMENT - The base address or the file offset specified does not have the proper alignment.
.
Language=Polish
ERROR_MAPPED_ALIGNMENT - Adres bazowy określonego offsetu pliku nie ma odpowiedniego wyrównania.
.
Language=Romanian
ERROR_MAPPED_ALIGNMENT - The base address or the file offset specified does not have the proper alignment.
.

MessageId=1140
Severity=Success
Facility=System
SymbolicName=ERROR_SET_POWER_STATE_VETOED
Language=English
ERROR_SET_POWER_STATE_VETOED - An attempt to change the system power state was vetoed by another application or driver.
.
Language=Russian
ERROR_SET_POWER_STATE_VETOED - An attempt to change the system power state was vetoed by another application or driver.
.
Language=Polish
ERROR_SET_POWER_STATE_VETOED - Próba zmiany stanu zasilania systemu została zablokowana przez inną aplikację lub sterownik.
.
Language=Romanian
ERROR_SET_POWER_STATE_VETOED - An attempt to change the system power state was vetoed by another application or driver.
.

MessageId=1141
Severity=Success
Facility=System
SymbolicName=ERROR_SET_POWER_STATE_FAILED
Language=English
ERROR_SET_POWER_STATE_FAILED - The system BIOS failed an attempt to change the system power state.
.
Language=Russian
ERROR_SET_POWER_STATE_FAILED - The system BIOS failed an attempt to change the system power state.
.
Language=Polish
ERROR_SET_POWER_STATE_FAILED - Próba zmiany stanu zasilania systemu przez systemowy BIOS nie powiodła się.
.
Language=Romanian
ERROR_SET_POWER_STATE_FAILED - The system BIOS failed an attempt to change the system power state.
.

MessageId=1142
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_LINKS
Language=English
ERROR_TOO_MANY_LINKS - An attempt was made to create more links on a file than the file system supports.
.
Language=Russian
ERROR_TOO_MANY_LINKS - An attempt was made to create more links on a file than the file system supports.
.
Language=Polish
ERROR_TOO_MANY_LINKS - Podjęto próbę utworzenia większej liczby łączy na pliku niż obsługuje system plików.
.
Language=Romanian
ERROR_TOO_MANY_LINKS - An attempt was made to create more links on a file than the file system supports.
.

MessageId=1150
Severity=Success
Facility=System
SymbolicName=ERROR_OLD_WIN_VERSION
Language=English
ERROR_OLD_WIN_VERSION - The specified program requires a newer version of Windows.
.
Language=Russian
ERROR_OLD_WIN_VERSION - The specified program requires a newer version of Windows.
.
Language=Polish
ERROR_OLD_WIN_VERSION - Określony program wymaga nowszej wersji systemu Windows.
.
Language=Romanian
ERROR_OLD_WIN_VERSION - The specified program requires a newer version of Windows.
.

MessageId=1151
Severity=Success
Facility=System
SymbolicName=ERROR_APP_WRONG_OS
Language=English
ERROR_APP_WRONG_OS - The specified program is not a Windows or MS-DOS program.
.
Language=Russian
ERROR_APP_WRONG_OS - The specified program is not a Windows or MS-DOS program.
.
Language=Polish
ERROR_APP_WRONG_OS - Określony program nie jest programem środowiska Windows ani MS-DOS.
.
Language=Romanian
ERROR_APP_WRONG_OS - The specified program is not a Windows or MS-DOS program.
.

MessageId=1152
Severity=Success
Facility=System
SymbolicName=ERROR_SINGLE_INSTANCE_APP
Language=English
ERROR_SINGLE_INSTANCE_APP - Cannot start more than one instance of the specified program.
.
Language=Russian
ERROR_SINGLE_INSTANCE_APP - Cannot start more than one instance of the specified program.
.
Language=Polish
ERROR_SINGLE_INSTANCE_APP - Nie można uruchomić więcej niż jednego wystąpienia określonego programu.
.
Language=Romanian
ERROR_SINGLE_INSTANCE_APP - Cannot start more than one instance of the specified program.
.

MessageId=1153
Severity=Success
Facility=System
SymbolicName=ERROR_RMODE_APP
Language=English
ERROR_RMODE_APP - The specified program was written for an earlier version of Windows.
.
Language=Russian
ERROR_RMODE_APP - The specified program was written for an earlier version of Windows.
.
Language=Polish
ERROR_RMODE_APP - Określony program został napisany dla starszej wersji systemu Windows.
.
Language=Romanian
ERROR_RMODE_APP - The specified program was written for an earlier version of Windows.
.

MessageId=1154
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DLL
Language=English
ERROR_INVALID_DLL - One of the library files needed to run this application is damaged.
.
Language=Russian
ERROR_INVALID_DLL - One of the library files needed to run this application is damaged.
.
Language=Polish
ERROR_INVALID_DLL - Jeden z plików bibliotek potrzebnych do uruchomienia tej aplikacji jest uszkodzony.
.
Language=Romanian
ERROR_INVALID_DLL - One of the library files needed to run this application is damaged.
.

MessageId=1155
Severity=Success
Facility=System
SymbolicName=ERROR_NO_ASSOCIATION
Language=English
ERROR_NO_ASSOCIATION - No application is associated with the specified file for this operation.
.
Language=Russian
ERROR_NO_ASSOCIATION - No application is associated with the specified file for this operation.
.
Language=Polish
ERROR_NO_ASSOCIATION - Z określonym plikiem nie skojarzono dla tej operacji żadnej aplikacji.
.
Language=Romanian
ERROR_NO_ASSOCIATION - No application is associated with the specified file for this operation.
.

MessageId=1156
Severity=Success
Facility=System
SymbolicName=ERROR_DDE_FAIL
Language=English
ERROR_DDE_FAIL - An error occurred in sending the command to the application.
.
Language=Russian
ERROR_DDE_FAIL - Ошибка при пересылке команды приложению.
.
Language=Polish
ERROR_DDE_FAIL - W trakcie wysyłania polecenia do aplikacji wystąpił błąd.
.
Language=Romanian
ERROR_DDE_FAIL - An error occurred in sending the command to the application.
.

MessageId=1157
Severity=Success
Facility=System
SymbolicName=ERROR_DLL_NOT_FOUND
Language=English
ERROR_DLL_NOT_FOUND - One of the library files needed to run this application cannot be found.
.
Language=Russian
ERROR_DLL_NOT_FOUND - Не найден один из файлов библиотек, необходимых для выполнения данного приложения.
.
Language=Polish
ERROR_DLL_NOT_FOUND - Nie można odnaleźć jednego z plików bibliotek potrzebnych do uruchomienia tej aplikacji.
.
Language=Romanian
ERROR_DLL_NOT_FOUND - One of the library files needed to run this application cannot be found.
.

MessageId=1158
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_USER_HANDLES
Language=English
ERROR_NO_MORE_USER_HANDLES - The current process has used all of its system allowance of handles for Window Manager objects.
.
Language=Russian
ERROR_NO_MORE_USER_HANDLES - Текущий процесс использовал все системные разрешения по управлению объектами диспетчера окон.
.
Language=Polish
ERROR_NO_MORE_USER_HANDLES - Bieżący proces wykorzystał wszystkie dozwolone przez system dojścia do obiektów Window Manager.
.
Language=Romanian
ERROR_NO_MORE_USER_HANDLES - The current process has used all of its system allowance of handles for Window Manager objects.
.

MessageId=1159
Severity=Success
Facility=System
SymbolicName=ERROR_MESSAGE_SYNC_ONLY
Language=English
ERROR_MESSAGE_SYNC_ONLY - The message can be used only with synchronous operations.
.
Language=Russian
ERROR_MESSAGE_SYNC_ONLY - Сообщение может быть использовано только с операциями синхронизации.
.
Language=Polish
ERROR_MESSAGE_SYNC_ONLY - Komunikat może być użyty tylko przy operacjach synchronicznych.
.
Language=Romanian
ERROR_MESSAGE_SYNC_ONLY - The message can be used only with synchronous operations.
.

MessageId=1160
Severity=Success
Facility=System
SymbolicName=ERROR_SOURCE_ELEMENT_EMPTY
Language=English
ERROR_SOURCE_ELEMENT_EMPTY - The indicated source element has no media.
.
Language=Russian
ERROR_SOURCE_ELEMENT_EMPTY - Указанный исходный элемент не имеет носителя.
.
Language=Polish
ERROR_SOURCE_ELEMENT_EMPTY - Wskazany element źródłowy nie ma nośnika.
.
Language=Romanian
ERROR_SOURCE_ELEMENT_EMPTY - The indicated source element has no media.
.

MessageId=1161
Severity=Success
Facility=System
SymbolicName=ERROR_DESTINATION_ELEMENT_FULL
Language=English
ERROR_DESTINATION_ELEMENT_FULL - The indicated destination element already contains media.
.
Language=Russian
ERROR_DESTINATION_ELEMENT_FULL - Указанный конечный элемент уже содержит носитель.
.
Language=Polish
ERROR_DESTINATION_ELEMENT_FULL - Wskazany element docelowy już ma nośnik.
.
Language=Romanian
ERROR_DESTINATION_ELEMENT_FULL - The indicated destination element already contains media.
.

MessageId=1162
Severity=Success
Facility=System
SymbolicName=ERROR_ILLEGAL_ELEMENT_ADDRESS
Language=English
ERROR_ILLEGAL_ELEMENT_ADDRESS - The indicated element does not exist.
.
Language=Russian
ERROR_ILLEGAL_ELEMENT_ADDRESS - Указанный элемент не существует.
.
Language=Polish
ERROR_ILLEGAL_ELEMENT_ADDRESS - Wskazany element nie istnieje.
.
Language=Romanian
ERROR_ILLEGAL_ELEMENT_ADDRESS - The indicated element does not exist.
.

MessageId=1163
Severity=Success
Facility=System
SymbolicName=ERROR_MAGAZINE_NOT_PRESENT
Language=English
ERROR_MAGAZINE_NOT_PRESENT - The indicated element is part of a magazine that is not present.
.
Language=Russian
ERROR_MAGAZINE_NOT_PRESENT - Указанный элемент является частью отсутствующего журнала.
.
Language=Polish
ERROR_MAGAZINE_NOT_PRESENT - Wskazany element stanowi część magazynu, którego nie ma.
.
Language=Romanian
ERROR_MAGAZINE_NOT_PRESENT - The indicated element is part of a magazine that is not present.
.

MessageId=1164
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_REINITIALIZATION_NEEDED
Language=English
ERROR_DEVICE_REINITIALIZATION_NEEDED - The indicated device requires reinitialization due to hardware errors.
.
Language=Russian
ERROR_DEVICE_REINITIALIZATION_NEEDED - Указанный элемент требует повторной инициализации из-за аппаратных ошибок.
.
Language=Polish
ERROR_DEVICE_REINITIALIZATION_NEEDED - Wskazane urządzenie wymaga ponownego zainicjowania wskutek błędów sprzętowych.
.
Language=Romanian
ERROR_DEVICE_REINITIALIZATION_NEEDED - The indicated device requires reinitialization due to hardware errors.
.

MessageId=1165
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_REQUIRES_CLEANING
Language=English
ERROR_DEVICE_REQUIRES_CLEANING - The device has indicated that cleaning is required before further operations are attempted.
.
Language=Russian
ERROR_DEVICE_REQUIRES_CLEANING - Устройство требует проведение чистки перед его дальнейшим использованием.
.
Language=Polish
ERROR_DEVICE_REQUIRES_CLEANING - Urządzenie sygnalizuje, że przed dalszymi operacjami jest wymagane czyszczenie.
.
Language=Romanian
ERROR_DEVICE_REQUIRES_CLEANING - The device has indicated that cleaning is required before further operations are attempted.
.

MessageId=1166
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_DOOR_OPEN
Language=English
ERROR_DEVICE_DOOR_OPEN - The device has indicated that its door is open.
.
Language=Russian
ERROR_DEVICE_DOOR_OPEN - Устройство сообщает, что открыта дверца.
.
Language=Polish
ERROR_DEVICE_DOOR_OPEN - Urządzenie sygnalizuje, że jest otwarte.
.
Language=Romanian
ERROR_DEVICE_DOOR_OPEN - The device has indicated that its door is open.
.

MessageId=1167
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_NOT_CONNECTED
Language=English
ERROR_DEVICE_NOT_CONNECTED - The device is not connected.
.
Language=Russian
ERROR_DEVICE_NOT_CONNECTED - Устройство не подключено.
.
Language=Polish
ERROR_DEVICE_NOT_CONNECTED - Urządzenie nie jest podłączone.
.
Language=Romanian
ERROR_DEVICE_NOT_CONNECTED - The device is not connected.
.

MessageId=1168
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_FOUND
Language=English
ERROR_NOT_FOUND - Element not found.
.
Language=Russian
ERROR_NOT_FOUND - Элемент не найден.
.
Language=Polish
ERROR_NOT_FOUND - Nie można odnaleźć elementu.
.
Language=Romanian
ERROR_NOT_FOUND - Element not found.
.

MessageId=1169
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MATCH
Language=English
ERROR_NO_MATCH - There was no match for the specified key in the index.
.
Language=Russian
ERROR_NO_MATCH - В индексе не найдены соответствия указанному ключу.
.
Language=Polish
ERROR_NO_MATCH - W indeksie nie znaleziono pozycji odpowiadającej podanemu kluczowi.
.
Language=Romanian
ERROR_NO_MATCH - There was no match for the specified key in the index.
.

MessageId=1170
Severity=Success
Facility=System
SymbolicName=ERROR_SET_NOT_FOUND
Language=English
ERROR_SET_NOT_FOUND - The property set specified does not exist on the object.
.
Language=Russian
ERROR_SET_NOT_FOUND - Указанный набор свойств не существует для объекта.
.
Language=Polish
ERROR_SET_NOT_FOUND - Określony zestaw właściwości nie istnieje na tym obiekcie.
.
Language=Romanian
ERROR_SET_NOT_FOUND - The property set specified does not exist on the object.
.

MessageId=1171
Severity=Success
Facility=System
SymbolicName=ERROR_POINT_NOT_FOUND
Language=English
ERROR_POINT_NOT_FOUND - The point passed to GetMouseMovePointsEx is not in the buffer.
.
Language=Russian
ERROR_POINT_NOT_FOUND - Переданная в GetMouseMovePoints точка не находится в буфере.
.
Language=Polish
ERROR_POINT_NOT_FOUND - Punkt przekazany do instrukcji GetMouseMovePoints nie znajduje się w buforze.
.
Language=Romanian
ERROR_POINT_NOT_FOUND - The point passed to GetMouseMovePointsEx is not in the buffer.
.

MessageId=1172
Severity=Success
Facility=System
SymbolicName=ERROR_NO_TRACKING_SERVICE
Language=English
ERROR_NO_TRACKING_SERVICE - The tracking (workstation) service is not running.
.
Language=Russian
ERROR_NO_TRACKING_SERVICE - Служба слежения (на рабочей станции) не запущена.
.
Language=Polish
ERROR_NO_TRACKING_SERVICE - Usługa śledzenia (stacja robocza) nie jest uruchomiona.
.
Language=Romanian
ERROR_NO_TRACKING_SERVICE - The tracking (workstation) service is not running.
.

MessageId=1173
Severity=Success
Facility=System
SymbolicName=ERROR_NO_VOLUME_ID
Language=English
ERROR_NO_VOLUME_ID - The Volume ID could not be found.
.
Language=Russian
ERROR_NO_VOLUME_ID - Не удается найти идентификатор тома.
.
Language=Polish
ERROR_NO_VOLUME_ID - Nie można znaleźć identyfikatora woluminu.
.
Language=Romanian
ERROR_NO_VOLUME_ID - The Volume ID could not be found.
.

MessageId=1175
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_REMOVE_REPLACED
Language=English
ERROR_UNABLE_TO_REMOVE_REPLACED - Unable to remove the file to be replaced.
.
Language=Russian
ERROR_UNABLE_TO_REMOVE_REPLACED - Не удается удалить заменяемый файл.
.
Language=Polish
ERROR_UNABLE_TO_REMOVE_REPLACED - Nie można usunąć pliku, który ma być zastąpiony.
.
Language=Romanian
ERROR_UNABLE_TO_REMOVE_REPLACED - Unable to remove the file to be replaced.
.

MessageId=1176
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_MOVE_REPLACEMENT
Language=English
ERROR_UNABLE_TO_MOVE_REPLACEMENT - Unable to move the replacement file to the file to be replaced. The file to be replaced has retained its original name.
.
Language=Russian
ERROR_UNABLE_TO_MOVE_REPLACEMENT - Не удается заместить файл. Замещаемый файл сохранил свое первоначальное имя.
.
Language=Polish
ERROR_UNABLE_TO_MOVE_REPLACEMENT - Nie można przenieść pliku zastępującego do pliku, który ma być zamieniony. Plik, który miał ulec zamianie, zachował swoją oryginalną nazwę.
.
Language=Romanian
ERROR_UNABLE_TO_MOVE_REPLACEMENT - Unable to move the replacement file to the file to be replaced. The file to be replaced has retained its original name.
.

MessageId=1177
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_MOVE_REPLACEMENT_2
Language=English
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 - Unable to move the replacement file to the file to be replaced. The file to be replaced has been renamed using the backup name.
.
Language=Russian
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 - Не удается заместить файл. Замещаемый файл был переименован с использованием резервного имени.
.
Language=Polish
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 - Nie można przenieść pliku zastępującego do pliku, który ma być zamieniony. Nazwa pliku, który miał ulec zamianie, została zmieniona na nazwę kopii zapasowej.
.
Language=Romanian
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 - Unable to move the replacement file to the file to be replaced. The file to be replaced has been renamed using the backup name.
.

MessageId=1178
Severity=Success
Facility=System
SymbolicName=ERROR_JOURNAL_DELETE_IN_PROGRESS
Language=English
ERROR_JOURNAL_DELETE_IN_PROGRESS - The volume change journal is being deleted.
.
Language=Russian
ERROR_JOURNAL_DELETE_IN_PROGRESS - Журнал изменений тома удален.
.
Language=Polish
ERROR_JOURNAL_DELETE_IN_PROGRESS - Dziennik zmian woluminu jest usuwany.
.
Language=Romanian
ERROR_JOURNAL_DELETE_IN_PROGRESS - The volume change journal is being deleted.
.

MessageId=1179
Severity=Success
Facility=System
SymbolicName=ERROR_JOURNAL_NOT_ACTIVE
Language=English
ERROR_JOURNAL_NOT_ACTIVE - The volume change journal is not active.
.
Language=Russian
ERROR_JOURNAL_NOT_ACTIVE - Журнал изменений тома не активен.
.
Language=Polish
ERROR_JOURNAL_NOT_ACTIVE - Dziennik zmiany woluminu nie jest aktywny.
.
Language=Romanian
ERROR_JOURNAL_NOT_ACTIVE - The volume change journal is not active.
.

MessageId=1180
Severity=Success
Facility=System
SymbolicName=ERROR_POTENTIAL_FILE_FOUND
Language=English
ERROR_POTENTIAL_FILE_FOUND - A file was found, but it may not be the correct file.
.
Language=Russian
ERROR_POTENTIAL_FILE_FOUND - Файл найден, но это может быть неверный файл.
.
Language=Polish
ERROR_POTENTIAL_FILE_FOUND - Plik został znaleziony, ale może to nie być właściwy plik.
.
Language=Romanian
ERROR_POTENTIAL_FILE_FOUND - A file was found, but it may not be the correct file.
.

MessageId=1181
Severity=Success
Facility=System
SymbolicName=ERROR_JOURNAL_ENTRY_DELETED
Language=English
ERROR_JOURNAL_ENTRY_DELETED - The journal entry has been deleted from the journal.
.
Language=Russian
ERROR_JOURNAL_ENTRY_DELETED - Из журнала удалена запись.
.
Language=Polish
ERROR_JOURNAL_ENTRY_DELETED - Wpis dziennika został usunięty z dziennika.
.
Language=Romanian
ERROR_JOURNAL_ENTRY_DELETED - The journal entry has been deleted from the journal.
.

MessageId=1200
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DEVICE
Language=English
ERROR_BAD_DEVICE - The specified device name is invalid.
.
Language=Russian
ERROR_BAD_DEVICE - Указано неверное имя устройства.
.
Language=Polish
ERROR_BAD_DEVICE - Określona nazwa urządzenia jest nieprawidłowa.
.
Language=Romanian
ERROR_BAD_DEVICE - The specified device name is invalid.
.

MessageId=1201
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_UNAVAIL
Language=English
ERROR_CONNECTION_UNAVAIL - The device is not currently connected but it is a remembered connection.
.
Language=Russian
ERROR_CONNECTION_UNAVAIL - Устройство сейчас не подключено, но сведения о нем в конфигурации присутствуют.
.
Language=Polish
ERROR_CONNECTION_UNAVAIL - Urządzenie nie jest obecnie podłączone, ale istnieje jako zapamiętane połączenie.
.
Language=Romanian
ERROR_CONNECTION_UNAVAIL - The device is not currently connected but it is a remembered connection.
.

MessageId=1202
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_ALREADY_REMEMBERED
Language=English
ERROR_DEVICE_ALREADY_REMEMBERED - The local device name has a remembered connection to another network resource.
.
Language=Russian
ERROR_DEVICE_ALREADY_REMEMBERED - Локальное имя устройства уже используется для подключения к другому сетевому ресурсу.
.
Language=Polish
ERROR_DEVICE_ALREADY_REMEMBERED - Nazwa urządzenia lokalnego pamięta połączenie z innym zasobem sieciowym.
.
Language=Romanian
ERROR_DEVICE_ALREADY_REMEMBERED - The local device name has a remembered connection to another network resource.
.

MessageId=1203
Severity=Success
Facility=System
SymbolicName=ERROR_NO_NET_OR_BAD_PATH
Language=English
ERROR_NO_NET_OR_BAD_PATH - The network path was either typed incorrectly, does not exist, or the network provider is not currently available. Please try retyping the path or contact your network administrator.
.
Language=Russian
ERROR_NO_NET_OR_BAD_PATH - Сетевой путь введен неправильно, не существует, или сеть сейчас недоступна. Попробуйте ввести путь заново или обратитесь к администратору сети.
.
Language=Polish
ERROR_NO_NET_OR_BAD_PATH - Ścieżka sieciowa została wpisana niepoprawnie, nie istnieje lub dostawca sieci jest obecnie niedostępny. Spróbuj ponownie wpisać ścieżkę lub skontaktuj się z administratorem sieci.
.
Language=Romanian
ERROR_NO_NET_OR_BAD_PATH - The network path was either typed incorrectly, does not exist, or the network provider is not currently available. Please try retyping the path or contact your network administrator.
.

MessageId=1204
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_PROVIDER
Language=English
ERROR_BAD_PROVIDER - The specified network provider name is invalid.
.
Language=Russian
ERROR_BAD_PROVIDER - Имя службы доступа к сети задано неверно.
.
Language=Polish
ERROR_BAD_PROVIDER - Określona nazwa dostawcy sieciowego jest nieprawidłowa.
.
Language=Romanian
ERROR_BAD_PROVIDER - The specified network provider name is invalid.
.

MessageId=1205
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_OPEN_PROFILE
Language=English
ERROR_CANNOT_OPEN_PROFILE - Unable to open the network connection profile.
.
Language=Russian
ERROR_CANNOT_OPEN_PROFILE - Не удается открыть конфигурацию подключения к сети.
.
Language=Polish
ERROR_CANNOT_OPEN_PROFILE - Nie można otworzyć profilu połączenia sieciowego.
.
Language=Romanian
ERROR_CANNOT_OPEN_PROFILE - Unable to open the network connection profile.
.

MessageId=1206
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_PROFILE
Language=English
ERROR_BAD_PROFILE - The network connection profile is corrupted.
.
Language=Russian
ERROR_BAD_PROFILE - Конфигурация подключения к сети повреждена.
.
Language=Polish
ERROR_BAD_PROFILE - Profil połączenia sieciowego jest uszkodzony.
.
Language=Romanian
ERROR_BAD_PROFILE - The network connection profile is corrupted.
.

MessageId=1207
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_CONTAINER
Language=English
ERROR_NOT_CONTAINER - Cannot enumerate a noncontainer.
.
Language=Russian
ERROR_NOT_CONTAINER - Перечисление объектов, не являющихся контейнерами, невозможно.
.
Language=Polish
ERROR_NOT_CONTAINER - Nie można wyliczać obiektu nie będącego kontenerem.
.
Language=Romanian
ERROR_NOT_CONTAINER - Cannot enumerate a noncontainer.
.

MessageId=1208
Severity=Success
Facility=System
SymbolicName=ERROR_EXTENDED_ERROR
Language=English
ERROR_EXTENDED_ERROR - An extended error has occurred.
.
Language=Russian
ERROR_EXTENDED_ERROR - Ошибка расширенного типа.
.
Language=Polish
ERROR_EXTENDED_ERROR - Wystąpił błąd rozszerzony.
.
Language=Romanian
ERROR_EXTENDED_ERROR - An extended error has occurred.
.

MessageId=1209
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_GROUPNAME
Language=English
ERROR_INVALID_GROUPNAME - The format of the specified group name is invalid.
.
Language=Russian
ERROR_INVALID_GROUPNAME - Неверный формат имени группы.
.
Language=Polish
ERROR_INVALID_GROUPNAME - Format określonej nazwy grupy jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_GROUPNAME - The format of the specified group name is invalid.
.

MessageId=1210
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_COMPUTERNAME
Language=English
ERROR_INVALID_COMPUTERNAME - The format of the specified computer name is invalid.
.
Language=Russian
ERROR_INVALID_COMPUTERNAME - Неверный формат имени компьютера.
.
Language=Polish
ERROR_INVALID_COMPUTERNAME - Format określonej nazwy komputera jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_COMPUTERNAME - The format of the specified computer name is invalid.
.

MessageId=1211
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EVENTNAME
Language=English
ERROR_INVALID_EVENTNAME - The format of the specified event name is invalid.
.
Language=Russian
ERROR_INVALID_EVENTNAME - Неверный формат имени события.
.
Language=Polish
ERROR_INVALID_EVENTNAME - Format określonej nazwy zdarzenia jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_EVENTNAME - The format of the specified event name is invalid.
.

MessageId=1212
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DOMAINNAME
Language=English
ERROR_INVALID_DOMAINNAME - The format of the specified domain name is invalid.
.
Language=Russian
ERROR_INVALID_DOMAINNAME - Неверный формат имени домена.
.
Language=Polish
ERROR_INVALID_DOMAINNAME - Format określonej nazwy domeny jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_DOMAINNAME - The format of the specified domain name is invalid.
.

MessageId=1213
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SERVICENAME
Language=English
ERROR_INVALID_SERVICENAME - The format of the specified service name is invalid.
.
Language=Russian
ERROR_INVALID_SERVICENAME - Неверный формат имени службы.
.
Language=Polish
ERROR_INVALID_SERVICENAME - Format określonej nazwy usługi jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_SERVICENAME - The format of the specified service name is invalid.
.

MessageId=1214
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_NETNAME
Language=English
ERROR_INVALID_NETNAME - The format of the specified network name is invalid.
.
Language=Russian
ERROR_INVALID_NETNAME - Неверный формат сетевого имени.
.
Language=Polish
ERROR_INVALID_NETNAME - Format określonej nazwy sieci jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_NETNAME - The format of the specified network name is invalid.
.

MessageId=1215
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SHARENAME
Language=English
ERROR_INVALID_SHARENAME - The format of the specified share name is invalid.
.
Language=Russian
ERROR_INVALID_SHARENAME - Недопустимый формат имени общего ресурса.
.
Language=Polish
ERROR_INVALID_SHARENAME - Format określonej nazwy udziału jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_SHARENAME - The format of the specified share name is invalid.
.

MessageId=1216
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PASSWORDNAME
Language=English
ERROR_INVALID_PASSWORDNAME - The format of the specified password is invalid.
.
Language=Russian
ERROR_INVALID_PASSWORDNAME - Неверный формат пароля.
.
Language=Polish
ERROR_INVALID_PASSWORDNAME - Format określonego hasła jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_PASSWORDNAME - The format of the specified password is invalid.
.

MessageId=1217
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MESSAGENAME
Language=English
ERROR_INVALID_MESSAGENAME - The format of the specified message name is invalid.
.
Language=Russian
ERROR_INVALID_MESSAGENAME - Неверный формат имени сообщения.
.
Language=Polish
ERROR_INVALID_MESSAGENAME - Format określonej nazwy komunikatu jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_MESSAGENAME - The format of the specified message name is invalid.
.

MessageId=1218
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MESSAGEDEST
Language=English
ERROR_INVALID_MESSAGEDEST - The format of the specified message destination is invalid.
.
Language=Russian
ERROR_INVALID_MESSAGEDEST - Неверный формат задания адреса, по которому отправляется сообщение.
.
Language=Polish
ERROR_INVALID_MESSAGEDEST - Format określonego miejsca docelowego komunikatu jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_MESSAGEDEST - The format of the specified message destination is invalid.
.

MessageId=1219
Severity=Success
Facility=System
SymbolicName=ERROR_SESSION_CREDENTIAL_CONFLICT
Language=English
ERROR_SESSION_CREDENTIAL_CONFLICT - Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again.
.
Language=Russian
ERROR_SESSION_CREDENTIAL_CONFLICT - Множественное подключение к серверу или к общим ресурсам одним пользователем с использованием более одного имени пользователя не разрешено. Отключите все предыдущие подключения к серверу или общим ресурсам и повторите попытку.
.
Language=Polish
ERROR_SESSION_CREDENTIAL_CONFLICT - Wielokrotne połączenia z serwerem lub udostępnionym zasobem przez tego samego użytkownika przy użyciu więcej niż jednej nazwy użytkownika są niedozwolone. Rozłącz wszystkie poprzednie połączenia z serwerem lub udostępnionym zasobem i spróbuj ponownie.
.
Language=Romanian
ERROR_SESSION_CREDENTIAL_CONFLICT - Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again.
.

MessageId=1220
Severity=Success
Facility=System
SymbolicName=ERROR_REMOTE_SESSION_LIMIT_EXCEEDED
Language=English
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED - An attempt was made to establish a session to a network server, but there are already too many sessions established to that server.
.
Language=Russian
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED - Попытка установки сеанса связи с сервером сети, для которого достигнут предел по числу таких сеансов.
.
Language=Polish
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED - Podjęto próbę ustanowienia sesji z serwerem sieci, ale jest już ustanowionych zbyt wiele sesji z tym serwerem.
.
Language=Romanian
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED - An attempt was made to establish a session to a network server, but there are already too many sessions established to that server.
.

MessageId=1221
Severity=Success
Facility=System
SymbolicName=ERROR_DUP_DOMAINNAME
Language=English
ERROR_DUP_DOMAINNAME - The workgroup or domain name is already in use by another computer on the network.
.
Language=Russian
ERROR_DUP_DOMAINNAME - Имя рабочей группы или домена уже используется другим компьютером в сети.
.
Language=Polish
ERROR_DUP_DOMAINNAME - Nazwa domeny lub grupy roboczej jest już używana przez inny komputer w sieci.
.
Language=Romanian
ERROR_DUP_DOMAINNAME - The workgroup or domain name is already in use by another computer on the network.
.

MessageId=1222
Severity=Success
Facility=System
SymbolicName=ERROR_NO_NETWORK
Language=English
ERROR_NO_NETWORK - The network is not present or not started.
.
Language=Russian
ERROR_NO_NETWORK - Сеть отсутствует или не запущена.
.
Language=Polish
ERROR_NO_NETWORK - Brak sieci lub nie została ona uruchomiona.
.
Language=Romanian
ERROR_NO_NETWORK - The network is not present or not started.
.

MessageId=1223
Severity=Success
Facility=System
SymbolicName=ERROR_CANCELLED
Language=English
ERROR_CANCELLED - The operation was canceled by the user.
.
Language=Russian
ERROR_CANCELLED - Операция была отменена пользователем.
.
Language=Polish
ERROR_CANCELLED - Operacja została anulowana przez użytkownika.
.
Language=Romanian
ERROR_CANCELLED - The operation was canceled by the user.
.

MessageId=1224
Severity=Success
Facility=System
SymbolicName=ERROR_USER_MAPPED_FILE
Language=English
ERROR_USER_MAPPED_FILE - The requested operation cannot be performed on a file with a user-mapped section open.
.
Language=Russian
ERROR_USER_MAPPED_FILE - Запрошенную операцию нельзя выполнить для файла с открытой пользователем сопоставленной секцией.
.
Language=Polish
ERROR_USER_MAPPED_FILE - Nie można wykonać żądanej operacji na pliku z otwartą sekcją mapowania użytkownika.
.
Language=Romanian
ERROR_USER_MAPPED_FILE - The requested operation cannot be performed on a file with a user-mapped section open.
.

MessageId=1225
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_REFUSED
Language=English
ERROR_CONNECTION_REFUSED - The remote system refused the network connection.
.
Language=Russian
ERROR_CONNECTION_REFUSED - Удаленный компьютер отклонил это сетевое подключение.
.
Language=Polish
ERROR_CONNECTION_REFUSED - Komputer zdalny odrzucił połączenie sieciowe.
.
Language=Romanian
ERROR_CONNECTION_REFUSED - The remote system refused the network connection.
.

MessageId=1226
Severity=Success
Facility=System
SymbolicName=ERROR_GRACEFUL_DISCONNECT
Language=English
ERROR_GRACEFUL_DISCONNECT - The network connection was gracefully closed.
.
Language=Russian
ERROR_GRACEFUL_DISCONNECT - Сетевое подключение было закрыто.
.
Language=Polish
ERROR_GRACEFUL_DISCONNECT - Połączenie sieciowe zostało bezpiecznie zamknięte.
.
Language=Romanian
ERROR_GRACEFUL_DISCONNECT - The network connection was gracefully closed.
.

MessageId=1227
Severity=Success
Facility=System
SymbolicName=ERROR_ADDRESS_ALREADY_ASSOCIATED
Language=English
ERROR_ADDRESS_ALREADY_ASSOCIATED - The network transport endpoint already has an address associated with it.
.
Language=Russian
ERROR_ADDRESS_ALREADY_ASSOCIATED - Конечной точке сетевого транспорта уже сопоставлен адрес.
.
Language=Polish
ERROR_ADDRESS_ALREADY_ASSOCIATED - Z punktem końcowym transportu sieciowego jest już skojarzony adres.
.
Language=Romanian
ERROR_ADDRESS_ALREADY_ASSOCIATED - The network transport endpoint already has an address associated with it.
.

MessageId=1228
Severity=Success
Facility=System
SymbolicName=ERROR_ADDRESS_NOT_ASSOCIATED
Language=English
ERROR_ADDRESS_NOT_ASSOCIATED - An address has not yet been associated with the network endpoint.
.
Language=Russian
ERROR_ADDRESS_NOT_ASSOCIATED - Конечной точке сети еще не сопоставлен адрес.
.
Language=Polish
ERROR_ADDRESS_NOT_ASSOCIATED - Adres nie został jeszcze skojarzony z punktem końcowym sieci.
.
Language=Romanian
ERROR_ADDRESS_NOT_ASSOCIATED - An address has not yet been associated with the network endpoint.
.

MessageId=1229
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_INVALID
Language=English
ERROR_CONNECTION_INVALID - An operation was attempted on a nonexistent network connection.
.
Language=Russian
ERROR_CONNECTION_INVALID - Попытка выполнить операцию для несуществующего сетевого подключения.
.
Language=Polish
ERROR_CONNECTION_INVALID - Próbowano wykonać operację na nieistniejącym połączeniu sieciowym.
.
Language=Romanian
ERROR_CONNECTION_INVALID - An operation was attempted on a nonexistent network connection.
.

MessageId=1230
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_ACTIVE
Language=English
ERROR_CONNECTION_ACTIVE - An invalid operation was attempted on an active network connection.
.
Language=Russian
ERROR_CONNECTION_ACTIVE - Попытка выполнить недопустимую операцию для активного сетевого подключения.
.
Language=Polish
ERROR_CONNECTION_ACTIVE - Na aktywnym połączeniu sieciowym próbowano wykonać nieprawidłową operację.
.
Language=Romanian
ERROR_CONNECTION_ACTIVE - An invalid operation was attempted on an active network connection.
.

MessageId=1231
Severity=Success
Facility=System
SymbolicName=ERROR_NETWORK_UNREACHABLE
Language=English
ERROR_NETWORK_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.
Language=Russian
ERROR_NETWORK_UNREACHABLE - Сетевая папка недоступна. За информацией о разрешении проблем в сети обратитесь к справочной системе Windows.
.
Language=Polish
ERROR_NETWORK_UNREACHABLE - Lokalizacja sieciowa jest nieosiągalna. Informacje na temat rozwiązywania problemów z siecią można znaleźć w Pomocy systemu Windows.
.
Language=Romanian
ERROR_NETWORK_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.

MessageId=1232
Severity=Success
Facility=System
SymbolicName=ERROR_HOST_UNREACHABLE
Language=English
ERROR_HOST_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.
Language=Russian
ERROR_HOST_UNREACHABLE - Сетевая папка недоступна. За информацией о разрешении проблем в сети обратитесь к справочной системе Windows.
.
Language=Polish
ERROR_HOST_UNREACHABLE - Lokalizacja sieciowa jest nieosiągalna. Informacje na temat rozwiązywania problemów z siecią można znaleźć w Pomocy systemu Windows.
.
Language=Romanian
ERROR_HOST_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.

MessageId=1233
Severity=Success
Facility=System
SymbolicName=ERROR_PROTOCOL_UNREACHABLE
Language=English
ERROR_PROTOCOL_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.
Language=Russian
ERROR_PROTOCOL_UNREACHABLE - Сетевая папка недоступна. За информацией о разрешении проблем в сети обратитесь к справочной системе Windows.
.
Language=Polish
ERROR_PROTOCOL_UNREACHABLE - Lokalizacja sieciowa jest nieosiągalna. Informacje na temat rozwiązywania problemów z siecią można znaleźć w Pomocy systemu Windows.
.
Language=Romanian
ERROR_PROTOCOL_UNREACHABLE - The network location cannot be reached. For information about network troubleshooting, see Windows Help.
.

MessageId=1234
Severity=Success
Facility=System
SymbolicName=ERROR_PORT_UNREACHABLE
Language=English
ERROR_PORT_UNREACHABLE - No service is operating at the destination network endpoint on the remote system.
.
Language=Russian
ERROR_PORT_UNREACHABLE - На конечном звене нужной сети удаленной системы не запущена ни одна служба.
.
Language=Polish
ERROR_PORT_UNREACHABLE - W docelowym punkcie końcowym sieci systemu zdalnego nie działa żadna usługa.
.
Language=Romanian
ERROR_PORT_UNREACHABLE - No service is operating at the destination network endpoint on the remote system.
.

MessageId=1235
Severity=Success
Facility=System
SymbolicName=ERROR_REQUEST_ABORTED
Language=English
ERROR_REQUEST_ABORTED - The request was aborted.
.
Language=Russian
ERROR_REQUEST_ABORTED - Запрос был прерван.
.
Language=Polish
ERROR_REQUEST_ABORTED - Żądanie zostało przerwane.
.
Language=Romanian
ERROR_REQUEST_ABORTED - The request was aborted.
.

MessageId=1236
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_ABORTED
Language=English
ERROR_CONNECTION_ABORTED - The network connection was aborted by the local system.
.
Language=Russian
ERROR_CONNECTION_ABORTED - Подключение к сети было разорвано локальной системой.
.
Language=Polish
ERROR_CONNECTION_ABORTED - Połączenie sieciowe zostało przerwane przez system lokalny.
.
Language=Romanian
ERROR_CONNECTION_ABORTED - The network connection was aborted by the local system.
.

MessageId=1237
Severity=Success
Facility=System
SymbolicName=ERROR_RETRY
Language=English
ERROR_RETRY - The operation could not be completed. A retry should be performed.
.
Language=Russian
ERROR_RETRY - Не удалось завершить операцию.  Следует повторить ее.
.
Language=Polish
ERROR_RETRY - Operacja nie zakończyła się pomyślnie. Należy ponowić próbę.
.
Language=Romanian
ERROR_RETRY - The operation could not be completed. A retry should be performed.
.

MessageId=1238
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTION_COUNT_LIMIT
Language=English
ERROR_CONNECTION_COUNT_LIMIT - A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached.
.
Language=Russian
ERROR_CONNECTION_COUNT_LIMIT - Подключение к серверу невозможно, так как для данной учетной записи уже достигнут предел по числу одновременных подключений.
.
Language=Polish
ERROR_CONNECTION_COUNT_LIMIT - Nie można ustanowić połączenia z serwerem z powodu wyczerpania limitu jednoczesnych połączeń dla tego konta.
.
Language=Romanian
ERROR_CONNECTION_COUNT_LIMIT - A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached.
.

MessageId=1239
Severity=Success
Facility=System
SymbolicName=ERROR_LOGIN_TIME_RESTRICTION
Language=English
ERROR_LOGIN_TIME_RESTRICTION - Attempting to log in during an unauthorized time of day for this account.
.
Language=Russian
ERROR_LOGIN_TIME_RESTRICTION - Попытка входа в сеть в непредусмотренное для этой учетной записи время дня.
.
Language=Polish
ERROR_LOGIN_TIME_RESTRICTION - Próbowano zalogować się w porze dnia niedozwolonej dla tego konta.
.
Language=Romanian
ERROR_LOGIN_TIME_RESTRICTION - Attempting to log in during an unauthorized time of day for this account.
.

MessageId=1240
Severity=Success
Facility=System
SymbolicName=ERROR_LOGIN_WKSTA_RESTRICTION
Language=English
ERROR_LOGIN_WKSTA_RESTRICTION - The account is not authorized to log in from this station.
.
Language=Russian
ERROR_LOGIN_WKSTA_RESTRICTION - Данная учетная запись не может быть использована для входа в сеть с этой станции.
.
Language=Polish
ERROR_LOGIN_WKSTA_RESTRICTION - Konto nie ma uprawnień do logowania z tej stacji.
.
Language=Romanian
ERROR_LOGIN_WKSTA_RESTRICTION - The account is not authorized to log in from this station.
.

MessageId=1241
Severity=Success
Facility=System
SymbolicName=ERROR_INCORRECT_ADDRESS
Language=English
ERROR_INCORRECT_ADDRESS - The network address could not be used for the operation requested.
.
Language=Russian
ERROR_INCORRECT_ADDRESS - Не удалось использовать сетевой адрес для запрошенной операции.
.
Language=Polish
ERROR_INCORRECT_ADDRESS - Adresu sieciowego nie można użyć do żądanej operacji.
.
Language=Romanian
ERROR_INCORRECT_ADDRESS - The network address could not be used for the operation requested.
.

MessageId=1242
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_REGISTERED
Language=English
ERROR_ALREADY_REGISTERED - The service is already registered.
.
Language=Russian
ERROR_ALREADY_REGISTERED - Служба уже зарегистрирована.
.
Language=Polish
ERROR_ALREADY_REGISTERED - Usługa jest już zarejestrowana.
.
Language=Romanian
ERROR_ALREADY_REGISTERED - The service is already registered.
.

MessageId=1243
Severity=Success
Facility=System
SymbolicName=ERROR_SERVICE_NOT_FOUND
Language=English
ERROR_SERVICE_NOT_FOUND - The specified service does not exist.
.
Language=Russian
ERROR_SERVICE_NOT_FOUND - Указанная служба не существует.
.
Language=Polish
ERROR_SERVICE_NOT_FOUND - Określona usługa nie istnieje.
.
Language=Romanian
ERROR_SERVICE_NOT_FOUND - The specified service does not exist.
.

MessageId=1244
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_AUTHENTICATED
Language=English
ERROR_NOT_AUTHENTICATED - The operation being requested was not performed because the user has not been authenticated.
.
Language=Russian
ERROR_NOT_AUTHENTICATED - Запрошенная операция не была выполнена, так как пользователь не зарегистрирован.
.
Language=Polish
ERROR_NOT_AUTHENTICATED - Żądana operacja nie została wykonana, ponieważ użytkownik nie został uwierzytelniony.
.
Language=Romanian
ERROR_NOT_AUTHENTICATED - The operation being requested was not performed because the user has not been authenticated.
.

MessageId=1245
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_LOGGED_ON
Language=English
ERROR_NOT_LOGGED_ON - The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist.
.
Language=Russian
ERROR_NOT_LOGGED_ON - Запрошенная операция не была выполнена, так как пользователь не выполнил вход в сеть. Указанная служба не существует.
.
Language=Polish
ERROR_NOT_LOGGED_ON - Żądana operacja nie została wykonana, ponieważ użytkownik nie zalogował się do sieci. Określona usługa nie istnieje.
.
Language=Romanian
ERROR_NOT_LOGGED_ON - The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist.
.

MessageId=1246
Severity=Success
Facility=System
SymbolicName=ERROR_CONTINUE
Language=English
ERROR_CONTINUE - Continue with work in progress.
.
Language=Russian
ERROR_CONTINUE - Требуется продолжить выполняющуюся операцию.
.
Language=Polish
ERROR_CONTINUE - Kontynuuj wykonywaną pracę.
.
Language=Romanian
ERROR_CONTINUE - Continue with work in progress.
.

MessageId=1247
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_INITIALIZED
Language=English
ERROR_ALREADY_INITIALIZED - An attempt was made to perform an initialization operation when initialization has already been completed.
.
Language=Russian
ERROR_ALREADY_INITIALIZED - Попытка выполнить операцию инициализации, которая уже проведена.
.
Language=Polish
ERROR_ALREADY_INITIALIZED - Wykonano próbę wykonania operacji inicjalizacji po tym, gdy inicjalizacja została już wykonana.
.
Language=Romanian
ERROR_ALREADY_INITIALIZED - An attempt was made to perform an initialization operation when initialization has already been completed.
.

MessageId=1248
Severity=Success
Facility=System
SymbolicName=ERROR_NO_MORE_DEVICES
Language=English
ERROR_NO_MORE_DEVICES - No more local devices.
.
Language=Russian
ERROR_NO_MORE_DEVICES - Больше локальных устройств не найдено.
.
Language=Polish
ERROR_NO_MORE_DEVICES - Brak dalszych urządzeń lokalnych.
.
Language=Romanian
ERROR_NO_MORE_DEVICES - No more local devices.
.

MessageId=1249
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_SITE
Language=English
ERROR_NO_SUCH_SITE - The specified site does not exist.
.
Language=Russian
ERROR_NO_SUCH_SITE - Указанный сайт не существует.
.
Language=Polish
ERROR_NO_SUCH_SITE - Podana lokacja nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_SITE - The specified site does not exist.
.

MessageId=1250
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_CONTROLLER_EXISTS
Language=English
ERROR_DOMAIN_CONTROLLER_EXISTS - A domain controller with the specified name already exists.
.
Language=Russian
ERROR_DOMAIN_CONTROLLER_EXISTS - Контроллер домена с указанным именем уже существует.
.
Language=Polish
ERROR_DOMAIN_CONTROLLER_EXISTS - Kontroler domeny o podanej nazwie już istnieje.
.
Language=Romanian
ERROR_DOMAIN_CONTROLLER_EXISTS - A domain controller with the specified name already exists.
.

MessageId=1251
Severity=Success
Facility=System
SymbolicName=ERROR_ONLY_IF_CONNECTED
Language=English
ERROR_ONLY_IF_CONNECTED - This operation is supported only when you are connected to the server.
.
Language=Russian
ERROR_ONLY_IF_CONNECTED - Эта операция поддерживается только при наличии подключения к серверу.
.
Language=Polish
ERROR_ONLY_IF_CONNECTED - Ta operacja jest obsługiwana tylko wtedy, gdy jest nawiązane połączenie z serwerem.
.
Language=Romanian
ERROR_ONLY_IF_CONNECTED - This operation is supported only when you are connected to the server.
.

MessageId=1252
Severity=Success
Facility=System
SymbolicName=ERROR_OVERRIDE_NOCHANGES
Language=English
ERROR_OVERRIDE_NOCHANGES - The group policy framework should call the extension even if there are no changes.
.
Language=Russian
ERROR_OVERRIDE_NOCHANGES - Основной модуль групповой политики должен вызвать расширение даже в случае отсутствия изменений.
.
Language=Polish
ERROR_OVERRIDE_NOCHANGES - Zasady grupowe powinny wywołać rozszerzenie, nawet jeśli nie ma zmian.
.
Language=Romanian
ERROR_OVERRIDE_NOCHANGES - The group policy framework should call the extension even if there are no changes.
.

MessageId=1253
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_USER_PROFILE
Language=English
ERROR_BAD_USER_PROFILE - The specified user does not have a valid profile.
.
Language=Russian
ERROR_BAD_USER_PROFILE - Выбранный пользователь не имеет допустимого профиля.
.
Language=Polish
ERROR_BAD_USER_PROFILE - Nie ma prawidłowego profilu dla podanego użytkownika.
.
Language=Romanian
ERROR_BAD_USER_PROFILE - The specified user does not have a valid profile.
.

MessageId=1254
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SUPPORTED_ON_SBS
Language=English
ERROR_NOT_SUPPORTED_ON_SBS - This operation is not supported on a computer running Windows Server 2003 for Small Business Server.
.
Language=Russian
ERROR_NOT_SUPPORTED_ON_SBS - Эта операция не поддерживается на Windows Server 2003 for Small Business Server.
.
Language=Polish
ERROR_NOT_SUPPORTED_ON_SBS - Ta operacja nie jest obsługiwana na komputerze z uruchomionym systemem Windows Server 2003 for Small Business Server.
.
Language=Romanian
ERROR_NOT_SUPPORTED_ON_SBS - This operation is not supported on a computer running Windows Server 2003 for Small Business Server.
.

MessageId=1255
Severity=Success
Facility=System
SymbolicName=ERROR_SERVER_SHUTDOWN_IN_PROGRESS
Language=English
ERROR_SERVER_SHUTDOWN_IN_PROGRESS - The server machine is shutting down.
.
Language=Russian
ERROR_SERVER_SHUTDOWN_IN_PROGRESS - Идет завершение работы компьютера-сервера.
.
Language=Polish
ERROR_SERVER_SHUTDOWN_IN_PROGRESS - Trwa zamykanie serwera.
.
Language=Romanian
ERROR_SERVER_SHUTDOWN_IN_PROGRESS - The server machine is shutting down.
.

MessageId=1256
Severity=Success
Facility=System
SymbolicName=ERROR_HOST_DOWN
Language=English
ERROR_HOST_DOWN - The remote system is not available. For information about network troubleshooting, see Windows Help.
.
Language=Russian
ERROR_HOST_DOWN - Удаленная система недоступна. За информацией о разрешении проблем в сети, обратитесь к справочной системе Windows.
.
Language=Polish
ERROR_HOST_DOWN - System zdalny jest niedostępny. Aby uzyskać informacje dotyczące rozwiązywania problemów z siecią, zobacz Pomoc systemu Windows.
.
Language=Romanian
ERROR_HOST_DOWN - The remote system is not available. For information about network troubleshooting, see Windows Help.
.

MessageId=1257
Severity=Success
Facility=System
SymbolicName=ERROR_NON_ACCOUNT_SID
Language=English
ERROR_NON_ACCOUNT_SID - The security identifier provided is not from an account domain.
.
Language=Russian
ERROR_NON_ACCOUNT_SID - Был указан идентификатор безопасности не из того домена.
.
Language=Polish
ERROR_NON_ACCOUNT_SID - Podany identyfikator zabezpieczeń nie pochodzi z domeny konta.
.
Language=Romanian
ERROR_NON_ACCOUNT_SID - The security identifier provided is not from an account domain.
.

MessageId=1258
Severity=Success
Facility=System
SymbolicName=ERROR_NON_DOMAIN_SID
Language=English
ERROR_NON_DOMAIN_SID - The security identifier provided does not have a domain component.
.
Language=Russian
ERROR_NON_DOMAIN_SID - В указанном идентификаторе безопасности отсутствует компонент для домена.
.
Language=Polish
ERROR_NON_DOMAIN_SID - Podany identyfikator zabezpieczeń nie ma składnika określającego domenę.
.
Language=Romanian
ERROR_NON_DOMAIN_SID - The security identifier provided does not have a domain component.
.

MessageId=1259
Severity=Success
Facility=System
SymbolicName=ERROR_APPHELP_BLOCK
Language=English
ERROR_APPHELP_BLOCK - AppHelp dialog canceled thus preventing the application from starting.
.
Language=Russian
ERROR_APPHELP_BLOCK - Окно AppHelp закрыто, из-за чего приложение не было запущено.
.
Language=Polish
ERROR_APPHELP_BLOCK - Okno dialogowe pomocy aplikacji zostało anulowane i uniemożliwia to uruchomienie aplikacji.
.
Language=Romanian
ERROR_APPHELP_BLOCK - AppHelp dialog canceled thus preventing the application from starting.
.

MessageId=1260
Severity=Success
Facility=System
SymbolicName=ERROR_ACCESS_DISABLED_BY_POLICY
Language=English
ERROR_ACCESS_DISABLED_BY_POLICY - Windows cannot open this program because it has been prevented by a software restriction policy. For more information, open Event Viewer or contact your system administrator.
.
Language=Russian
ERROR_ACCESS_DISABLED_BY_POLICY - Эта программа заблокирована групповой политикой. За дополнительными сведениями обращайтесь к системному администратору.
.
Language=Polish
ERROR_ACCESS_DISABLED_BY_POLICY - Ten program jest blokowany przez zasady grupy. Aby uzyskać więcej informacji, otwórz Podgląd zdarzeń lub skontaktuj się z administratorem systemu.
.
Language=Romanian
ERROR_ACCESS_DISABLED_BY_POLICY - Windows cannot open this program because it has been prevented by a software restriction policy. For more information, open Event Viewer or contact your system administrator.
.

MessageId=1261
Severity=Success
Facility=System
SymbolicName=ERROR_REG_NAT_CONSUMPTION
Language=English
ERROR_REG_NAT_CONSUMPTION - A program attempt to use an invalid register value. Normally caused by an uninitialized register. This error is Itanium specific.
.
Language=Russian
ERROR_REG_NAT_CONSUMPTION - Попытка программы использовать неправильное значение регистра. Обычно это вызвано неинициализированным регистром.
.
Language=Polish
ERROR_REG_NAT_CONSUMPTION - Program próbuje użyć nieprawidłowej wartości rejestru. Zwykle przyczyną jest niezainicjowany rejestr. Ten błąd jest specyficzny dla procesora Itanium.
.
Language=Romanian
ERROR_REG_NAT_CONSUMPTION - A program attempt to use an invalid register value. Normally caused by an uninitialized register. This error is Itanium specific.
.

MessageId=1262
Severity=Success
Facility=System
SymbolicName=ERROR_CSCSHARE_OFFLINE
Language=English
ERROR_CSCSHARE_OFFLINE - The share is currently offline or does not exist.
.
Language=Russian
ERROR_CSCSHARE_OFFLINE - Общий ресурс недоступен или не существует.
.
Language=Polish
ERROR_CSCSHARE_OFFLINE - Udział jest aktualnie w trybie offline lub nie istnieje.
.
Language=Romanian
ERROR_CSCSHARE_OFFLINE - The share is currently offline or does not exist.
.

MessageId=1263
Severity=Success
Facility=System
SymbolicName=ERROR_PKINIT_FAILURE
Language=English
ERROR_PKINIT_FAILURE - The kerberos protocol encountered an error while validating the KDC certificate during smartcard logon.
.
Language=Russian
ERROR_PKINIT_FAILURE - Ошибка протокола Kerberos при проверке сертификата KDC во время входа в систему со смарт-картой. Дополнительные сведения см. в журнале системных событий.
.
Language=Polish
ERROR_PKINIT_FAILURE - Protokół Kerberos napotkał błąd, sprawdzając poprawność certyfikatu KDC podczas logowania karty inteligentnej. Więcej informacji można znaleźć w dzienniku zdarzeń systemu.
.
Language=Romanian
ERROR_PKINIT_FAILURE - The kerberos protocol encountered an error while validating the KDC certificate during smartcard logon.
.

MessageId=1264
Severity=Success
Facility=System
SymbolicName=ERROR_SMARTCARD_SUBSYSTEM_FAILURE
Language=English
ERROR_SMARTCARD_SUBSYSTEM_FAILURE - The kerberos protocol encountered an error while attempting to utilize the smartcard subsystem.
.
Language=Russian
ERROR_SMARTCARD_SUBSYSTEM_FAILURE - Ошибка протокола Kerberos при попытке использовать подсистему для смарт-карт.
.
Language=Polish
ERROR_SMARTCARD_SUBSYSTEM_FAILURE - Protokół Kerberos napotkał błąd podczas próby użycia podsystemu karty inteligentnej.
.
Language=Romanian
ERROR_SMARTCARD_SUBSYSTEM_FAILURE - The kerberos protocol encountered an error while attempting to utilize the smartcard subsystem.
.

MessageId=1265
Severity=Success
Facility=System
SymbolicName=ERROR_DOWNGRADE_DETECTED
Language=English
ERROR_DOWNGRADE_DETECTED - The system detected a possible attempt to compromise security. Please ensure that you can contact the server that authenticated you.
.
Language=Russian
ERROR_DOWNGRADE_DETECTED - Системе не удается установить связь с контроллером домена, чтобы обработать запрос на проверку подлинности. Попробуйте еще раз позже.
.
Language=Polish
ERROR_DOWNGRADE_DETECTED - System wykrył możliwe zagrożenie bezpieczeństwa. Upewnij się, że możesz skontaktować się z serwerem, który Cię uwierzytelnił.
.
Language=Romanian
ERROR_DOWNGRADE_DETECTED - The system detected a possible attempt to compromise security. Please ensure that you can contact the server that authenticated you.
.

MessageId=1266
Severity=Success
Facility=System
SymbolicName=SEC_E_SMARTCARD_CERT_REVOKED
Language=English
SEC_E_SMARTCARD_CERT_REVOKED - The smartcard certificate used for authentication has been revoked. Please contact your system administrator. There may be additional information in the event log.
.
Language=Russian
SEC_E_SMARTCARD_CERT_REVOKED - The smartcard certificate used for authentication has been revoked. Please contact your system administrator. There may be additional information in the event log.
.
Language=Polish
SEC_E_SMARTCARD_CERT_REVOKED - Certyfikat karty inteligentnej użyty do uwierzytelnienia został odwołany. Skontaktuj się z administratorem systemu. Dodatkowe informacje może zawierać dziennik zdarzeń.
.
Language=Romanian
SEC_E_SMARTCARD_CERT_REVOKED - The smartcard certificate used for authentication has been revoked. Please contact your system administrator. There may be additional information in the event log.
.

MessageId=1267
Severity=Success
Facility=System
SymbolicName=SEC_E_ISSUING_CA_UNTRUSTED
Language=English
SEC_E_ISSUING_CA_UNTRUSTED - An untrusted certificate authority was detected while processing the smartcard certificate used for authentication. Please contact your system administrator.
.
Language=Russian
SEC_E_ISSUING_CA_UNTRUSTED - An untrusted certificate authority was detected while processing the smartcard certificate used for authentication. Please contact your system administrator.
.
Language=Polish
SEC_E_ISSUING_CA_UNTRUSTED - Podczas przetwarzania certyfikatu karty inteligentnej używanej do uwierzytelniania został wykryty niezaufany urząd certyfikacji. Skontaktuj się z administratorem systemu.
.
Language=Romanian
SEC_E_ISSUING_CA_UNTRUSTED - An untrusted certificate authority was detected while processing the smartcard certificate used for authentication. Please contact your system administrator.
.

MessageId=1268
Severity=Success
Facility=System
SymbolicName=SEC_E_REVOCATION_OFFLINE_C
Language=English
SEC_E_REVOCATION_OFFLINE_C - The revocation status of the smartcard certificate used for authentication could not be determined. Please contact your system administrator.
.
Language=Russian
SEC_E_REVOCATION_OFFLINE_C - The revocation status of the smartcard certificate used for authentication could not be determined. Please contact your system administrator.
.
Language=Polish
SEC_E_REVOCATION_OFFLINE_C - Ustalenie stanu odwołania certyfikatu karty inteligentnej używanego do uwierzytelniania nie było możliwe. Skontaktuj się z administratorem systemu.
.
Language=Romanian
SEC_E_REVOCATION_OFFLINE_C - The revocation status of the smartcard certificate used for authentication could not be determined. Please contact your system administrator.
.

MessageId=1269
Severity=Success
Facility=System
SymbolicName=SEC_E_PKINIT_CLIENT_FAILUR
Language=English
SEC_E_PKINIT_CLIENT_FAILUR - The smartcard certificate used for authentication was not trusted. Please contact your system administrator.
.
Language=Russian
SEC_E_PKINIT_CLIENT_FAILUR - The smartcard certificate used for authentication was not trusted. Please contact your system administrator.
.
Language=Polish
SEC_E_PKINIT_CLIENT_FAILUR - Certyfikat karty inteligentnej używany do uwierzytelniania nie był zaufany. Skontaktuj się z administratorem systemu.
.
Language=Romanian
SEC_E_PKINIT_CLIENT_FAILUR - The smartcard certificate used for authentication was not trusted. Please contact your system administrator.
.

MessageId=1270
Severity=Success
Facility=System
SymbolicName=SEC_E_SMARTCARD_CERT_EXPIRED
Language=English
SEC_E_SMARTCARD_CERT_EXPIRED - The smartcard certificate used for authentication has expired. Please contact your system administrator.
.
Language=Russian
SEC_E_SMARTCARD_CERT_EXPIRED - The smartcard certificate used for authentication has expired. Please contact your system administrator.
.
Language=Polish
SEC_E_SMARTCARD_CERT_EXPIRED - Certyfikat karty inteligentnej używany do uwierzytelniania wygasł. Skontaktuj się z administratorem systemu.
.
Language=Romanian
SEC_E_SMARTCARD_CERT_EXPIRED - The smartcard certificate used for authentication has expired. Please contact your system administrator.
.

MessageId=1271
Severity=Success
Facility=System
SymbolicName=ERROR_MACHINE_LOCKED
Language=English
ERROR_MACHINE_LOCKED - The machine is locked and cannot be shut down without the force option.
.
Language=Russian
ERROR_MACHINE_LOCKED - Компьютер заблокирован и не может завершить работу без режима принудительного завершения.
.
Language=Polish
ERROR_MACHINE_LOCKED - Komputer jest zablokowany i nie można go zamknąć bez opcji wymuszenia.
.
Language=Romanian
ERROR_MACHINE_LOCKED - The machine is locked and cannot be shut down without the force option.
.

MessageId=1273
Severity=Success
Facility=System
SymbolicName=ERROR_CALLBACK_SUPPLIED_INVALID_DATA
Language=English
ERROR_CALLBACK_SUPPLIED_INVALID_DATA - An application-defined callback gave invalid data when called.
.
Language=Russian
ERROR_CALLBACK_SUPPLIED_INVALID_DATA - Определенный в приложении ответный вызов вернул неверные данные.
.
Language=Polish
ERROR_CALLBACK_SUPPLIED_INVALID_DATA - Określone przez aplikację wywołanie zwrotne dało po wywołaniu nieprawidłowe dane.
.
Language=Romanian
ERROR_CALLBACK_SUPPLIED_INVALID_DATA - An application-defined callback gave invalid data when called.
.

MessageId=1274
Severity=Success
Facility=System
SymbolicName=ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED
Language=English
ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED - The group policy framework should call the extension in the synchronous foreground policy refresh.
.
Language=Russian
ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED - Система групповой политики должна вызывать расширения в синхронном, не фоновом режиме обновления.
.
Language=Polish
ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED - Ogólna struktura zasad grupy powinna wywołać rozszerzenie podczas synchronicznego, pierwszoplanowego odświeżania zasad.
.
Language=Romanian
ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED - The group policy framework should call the extension in the synchronous foreground policy refresh.
.

MessageId=1275
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVER_BLOCKED
Language=English
ERROR_DRIVER_BLOCKED - This driver has been blocked from loading.
.
Language=Russian
ERROR_DRIVER_BLOCKED - Загрузка драйвера была заблокирована.
.
Language=Polish
ERROR_DRIVER_BLOCKED - Nastąpiło zablokowanie ładowania sterownika
.
Language=Romanian
ERROR_DRIVER_BLOCKED - This driver has been blocked from loading.
.

MessageId=1276
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_IMPORT_OF_NON_DLL
Language=English
ERROR_INVALID_IMPORT_OF_NON_DLL - A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image.
.
Language=Russian
ERROR_INVALID_IMPORT_OF_NON_DLL - Библиотека, на которую ссылается модуль, не является библиотекой динамической компоновки (DLL) или исполняемым модулем.
.
Language=Polish
ERROR_INVALID_IMPORT_OF_NON_DLL - Biblioteka dołączana dynamicznie DLL odwoływała się do modułu, który nie był ani biblioteką DLL, ani obrazem wykonywalnym procesu.
.
Language=Romanian
ERROR_INVALID_IMPORT_OF_NON_DLL - A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image.
.

MessageId=1277
Severity=Success
Facility=System
SymbolicName=ERROR_ACCESS_DISABLED_WEBBLADE
Language=English
ERROR_ACCESS_DISABLED_WEBBLADE - Windows cannot open this program since it has been disabled.
.
Language=Russian
ERROR_ACCESS_DISABLED_WEBBLADE - Windows не удается запустить эту программу, так как она отключена.
.
Language=Polish
ERROR_ACCESS_DISABLED_WEBBLADE - System Windows nie może otworzyć tego programu, ponieważ został on wyłączony.
.
Language=Romanian
ERROR_ACCESS_DISABLED_WEBBLADE - Windows cannot open this program since it has been disabled.
.

MessageId=1278
Severity=Success
Facility=System
SymbolicName=ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER
Language=English
ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER - Windows cannot open this program because the license enforcement system has been tampered with or become corrupted.
.
Language=Russian
ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER - Windows не удается открыть эту программу, так как система учета лицензий изменена или повреждена.
.
Language=Polish
ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER - System Windows nie może otworzyć tego programu, ponieważ system wymuszania licencji został zmieniony lub uszkodzony.
.
Language=Romanian
ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER - Windows cannot open this program because the license enforcement system has been tampered with or become corrupted.
.

MessageId=1279
Severity=Success
Facility=System
SymbolicName=ERROR_RECOVERY_FAILURE
Language=English
ERROR_RECOVERY_FAILURE - A transaction recovery failed.
.
Language=Russian
ERROR_RECOVERY_FAILURE - Неудача при восстановлении транзакции.
.
Language=Polish
ERROR_RECOVERY_FAILURE - Odzyskanie transakcji nie powiodło się.
.
Language=Romanian
ERROR_RECOVERY_FAILURE - A transaction recovery failed.
.

MessageId=1280
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_FIBER
Language=English
ERROR_ALREADY_FIBER - The current thread has already been converted to a fiber.
.
Language=Russian
ERROR_ALREADY_FIBER - Текущий поток уже преобразован в нить.
.
Language=Polish
ERROR_ALREADY_FIBER - Bieżący wątek został już przekonwertowany do włókna.
.
Language=Romanian
ERROR_ALREADY_FIBER - The current thread has already been converted to a fiber.
.

MessageId=1281
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_THREAD
Language=English
ERROR_ALREADY_THREAD - The current thread has already been converted from a fiber.
.
Language=Russian
ERROR_ALREADY_THREAD - Текущий поток уже преобразован из нити.
.
Language=Polish
ERROR_ALREADY_THREAD - Bieżący wątek został już przekonwertowany z włókna.
.
Language=Romanian
ERROR_ALREADY_THREAD - The current thread has already been converted from a fiber.
.

MessageId=1282
Severity=Success
Facility=System
SymbolicName=ERROR_STACK_BUFFER_OVERRUN
Language=English
ERROR_STACK_BUFFER_OVERRUN - The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application.
.
Language=Russian
ERROR_STACK_BUFFER_OVERRUN - Обнаружено переполнение стекового буфера в данном приложении. Это переполнение может позволить злоумышленнику получить управление над данным приложением.
.
Language=Polish
ERROR_STACK_BUFFER_OVERRUN - System wykrył w tej aplikacji przekroczenie buforu opartego na stosie. Przekroczenie może umożliwić złośliwemu użytkownikowi uzyskanie kontroli nad tą aplikacją.
.
Language=Romanian
ERROR_STACK_BUFFER_OVERRUN - The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application.
.

MessageId=1283
Severity=Success
Facility=System
SymbolicName=ERROR_PARAMETER_QUOTA_EXCEEDED
Language=English
ERROR_PARAMETER_QUOTA_EXCEEDED - Data present in one of the parameters is more than the function can operate on.
.
Language=Russian
ERROR_PARAMETER_QUOTA_EXCEEDED - В одном из параметров задано больше данных, чем эта функция может обработать.
.
Language=Polish
ERROR_PARAMETER_QUOTA_EXCEEDED - Ilość danych w jednym z parametrów jest większa niż ilość, którą może obsłużyć funkcja.
.
Language=Romanian
ERROR_PARAMETER_QUOTA_EXCEEDED - Data present in one of the parameters is more than the function can operate on.
.

MessageId=1284
Severity=Success
Facility=System
SymbolicName=ERROR_DEBUGGER_INACTIVE
Language=English
ERROR_DEBUGGER_INACTIVE - An attempt to do an operation on a debug object failed because the object is in the process of being deleted.
.
Language=Russian
ERROR_DEBUGGER_INACTIVE - Не удалось выполнить операцию над объектом отладки, так как он удаляется.
.
Language=Polish
ERROR_DEBUGGER_INACTIVE - Próba wykonania operacji na obiekcie debugowania nie powiodła się, ponieważ obiekt jest właśnie usuwany.
.
Language=Romanian
ERROR_DEBUGGER_INACTIVE - An attempt to do an operation on a debug object failed because the object is in the process of being deleted.
.

MessageId=1285
Severity=Success
Facility=System
SymbolicName=ERROR_DELAY_LOAD_FAILED
Language=English
ERROR_DELAY_LOAD_FAILED - An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed.
.
Language=Russian
ERROR_DELAY_LOAD_FAILED - Не удалось загрузить с задержкой библиотеку DLL или получить из нее адрес функции.
.
Language=Polish
ERROR_DELAY_LOAD_FAILED - Próba załadowania z opóźnieniem biblioteki .dll lub uzyskania adresu funkcji z biblioteki .dll załadowanej z opóźnieniem nie powiodła się.
.
Language=Romanian
ERROR_DELAY_LOAD_FAILED - An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed.
.

MessageId=1286
Severity=Success
Facility=System
SymbolicName=ERROR_VDM_DISALLOWED
Language=English
ERROR_VDM_DISALLOWED - %1 is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator.
.
Language=Russian
ERROR_VDM_DISALLOWED - "%1" является 16-битным приложением. Вы не имеете прав доступа для выполнения 16-битных приложений. Проверьте ваши права доступа с вашим системным администратором.
.
Language=Polish
ERROR_VDM_DISALLOWED - %1 jest aplikacją 16-bitową. Nie masz uprawnień do wykonywania aplikacji 16-bitowych. Skontaktuj się z administratorem, aby uzyskać informacje o uprawnieniach.
.
Language=Romanian
ERROR_VDM_DISALLOWED - %1 is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator.
.

MessageId=1287
Severity=Success
Facility=System
SymbolicName=ERROR_UNIDENTIFIED_ERROR
Language=English
ERROR_UNIDENTIFIED_ERROR - Insufficient information exists to identify the cause of failure.
.
Language=Russian
ERROR_UNIDENTIFIED_ERROR - Недостаточно сведений для установки причины сбоя.
.
Language=Polish
ERROR_UNIDENTIFIED_ERROR - Za mało informacji do zidentyfikowania przyczyny błędu.
.
Language=Romanian
ERROR_UNIDENTIFIED_ERROR - Insufficient information exists to identify the cause of failure.
.

MessageId=1288
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_BANDWIDTH_PARAMETERS
Language=English
ERROR_INVALID_BANDWIDTH_PARAMETERS - An invalid budget or period parameter was specified.
.
Language=Russian
ERROR_INVALID_BANDWIDTH_PARAMETERS - В динамическую функцию C передан неверный параметр.
.
Language=Polish
ERROR_INVALID_BANDWIDTH_PARAMETERS - An invalid budget or period parameter was specified.
.
Language=Romanian
ERROR_INVALID_BANDWIDTH_PARAMETERS - An invalid budget or period parameter was specified.
.

MessageId=1289
Severity=Success
Facility=System
SymbolicName=ERROR_AFFINITY_NOT_COMPATIBLE
Language=English
ERROR_AFFINITY_NOT_COMPATIBLE - An attempt was made to join a thread to a reserve whose affinity did not intersect the reserve affinity or an attempt was made to associate a process with a reserve whose affinity did not intersect the reserve affinity.
.
Language=Russian
ERROR_AFFINITY_NOT_COMPATIBLE - Операция выполнена за пределами допустимой длины данных файла.
.
Language=Polish
ERROR_AFFINITY_NOT_COMPATIBLE - An attempt was made to join a thread to a reserve whose affinity did not intersect the reserve affinity or an attempt was made to associate a process with a reserve whose affinity did not intersect the reserve affinity.
.
Language=Romanian
ERROR_AFFINITY_NOT_COMPATIBLE - An attempt was made to join a thread to a reserve whose affinity did not intersect the reserve affinity or an attempt was made to associate a process with a reserve whose affinity did not intersect the reserve affinity.
.

MessageId=1290
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_ALREADY_IN_RESERVE
Language=English
ERROR_THREAD_ALREADY_IN_RESERVE - An attempt was made to join a thread to a reserve which was already joined to another reserve.
.
Language=Russian
ERROR_THREAD_ALREADY_IN_RESERVE - Не удалось запустить эту службу, так как одна или несколько служб одного процесса имеют несовместимый параметр типа SID службы. Служба с ограниченным типом SID может сосуществовать в одном и том же процессе только с другими службами с ограниченным типом SID. Если тип SID для этой службы только что настроен, необходимо перезапустить хост-процесс, чтобы запустить эту службу.
.
Language=Polish
ERROR_THREAD_ALREADY_IN_RESERVE - An attempt was made to join a thread to a reserve which was already joined to another reserve.
.
Language=Romanian
ERROR_THREAD_ALREADY_IN_RESERVE - An attempt was made to join a thread to a reserve which was already joined to another reserve.
.

MessageId=1291
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_NOT_IN_RESERVE
Language=English
ERROR_THREAD_NOT_IN_RESERVE - An attempt was made to disjoin a thread from a reserve, but the thread was not joined to the reserve.
.
Language=Russian
ERROR_THREAD_NOT_IN_RESERVE - Процесс, использующий драйвер для этого устройства, прерван.
.
Language=Polish
ERROR_THREAD_NOT_IN_RESERVE - An attempt was made to disjoin a thread from a reserve, but the thread was not joined to the reserve.
.
Language=Romanian
ERROR_THREAD_NOT_IN_RESERVE - An attempt was made to disjoin a thread from a reserve, but the thread was not joined to the reserve.
.

MessageId=1292
Severity=Success
Facility=System
SymbolicName=ERROR_THREAD_PROCESS_IN_RESERVE
Language=English
ERROR_THREAD_PROCESS_IN_RESERVE - An attempt was made to disjoin a thread from a reserve whose process is associated with a reserve.
.
Language=Russian
ERROR_THREAD_PROCESS_IN_RESERVE - Операция попыталась превысить установленный предел.
.
Language=Polish
ERROR_THREAD_PROCESS_IN_RESERVE - An attempt was made to disjoin a thread from a reserve whose process is associated with a reserve.
.
Language=Romanian
ERROR_THREAD_PROCESS_IN_RESERVE - An attempt was made to disjoin a thread from a reserve whose process is associated with a reserve.
.

MessageId=1293
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_ALREADY_IN_RESERVE
Language=English
ERROR_PROCESS_ALREADY_IN_RESERVE - An attempt was made to associate a process with a reserve that was already associated with a reserve.
.
Language=Russian
ERROR_PROCESS_ALREADY_IN_RESERVE - Целевой процесс или процесс целевого потока является защищенным.
.
Language=Polish
ERROR_PROCESS_ALREADY_IN_RESERVE - An attempt was made to associate a process with a reserve that was already associated with a reserve.
.
Language=Romanian
ERROR_PROCESS_ALREADY_IN_RESERVE - An attempt was made to associate a process with a reserve that was already associated with a reserve.
.

MessageId=1294
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_NOT_IN_RESERVE
Language=English
ERROR_PROCESS_NOT_IN_RESERVE - An attempt was made to disassociate a process from a reserve, but the process did not have an associated reserve.
.
Language=Russian
ERROR_PROCESS_NOT_IN_RESERVE - Клиент уведомлений службы значительно отстает от текущего состояния служб в системе.
.
Language=Polish
ERROR_PROCESS_NOT_IN_RESERVE - An attempt was made to disassociate a process from a reserve, but the process did not have an associated reserve.
.
Language=Romanian
ERROR_PROCESS_NOT_IN_RESERVE - An attempt was made to disassociate a process from a reserve, but the process did not have an associated reserve.
.

MessageId=1295
Severity=Success
Facility=System
SymbolicName=ERROR_PROCESS_THREADS_IN_RESERVE
Language=English
ERROR_PROCESS_THREADS_IN_RESERVE - An attempt was made to associate a process with a reserve, but the process contained thread joined to a reserve.
.
Language=Russian
ERROR_PROCESS_THREADS_IN_RESERVE - Требуемая операция с файлами завершилась сбоем из-за превышения квоты на использование места на диске. Чтобы освободить место на диске, переместите файлы в другое место или удалите ненужные файлы. За дополнительными сведениями обратитесь к системному администратору.
.
Language=Polish
ERROR_PROCESS_THREADS_IN_RESERVE - An attempt was made to associate a process with a reserve, but the process contained thread joined to a reserve.
.
Language=Romanian
ERROR_PROCESS_THREADS_IN_RESERVE - An attempt was made to associate a process with a reserve, but the process contained thread joined to a reserve.
.

MessageId=1296
Severity=Success
Facility=System
SymbolicName=ERROR_AFFINITY_NOT_SET_IN_RESERVE
Language=English
ERROR_AFFINITY_NOT_SET_IN_RESERVE - An attempt was made to set the affinity of a thread or a process, but the thread or process was joined or associated with a reserve.
.
Language=Russian
ERROR_AFFINITY_NOT_SET_IN_RESERVE - Требуемая операция с файлами завершилась сбоем, так как политика хранилища блокирует этот тип файлов. За дополнительными сведениями обратитесь к системному администратору.
.
Language=Polish
ERROR_AFFINITY_NOT_SET_IN_RESERVE - An attempt was made to set the affinity of a thread or a process, but the thread or process was joined or associated with a reserve.
.
Language=Romanian
ERROR_AFFINITY_NOT_SET_IN_RESERVE - An attempt was made to set the affinity of a thread or a process, but the thread or process was joined or associated with a reserve.
.

MessageId=1297
Severity=Success
Facility=System
SymbolicName=ERROR_IMPLEMENTATION_LIMIT
Language=English
ERROR_IMPLEMENTATION_LIMIT - An operation attempted to exceed an implementation-defined limit.
.
Language=Russian
ERROR_IMPLEMENTATION_LIMIT - Права, необходимые службе для правильной работы, не существуют в конфигурации учетной записи службы.
.
Language=Polish
ERROR_IMPLEMENTATION_LIMIT - Operacja usiłowała przekroczyć ograniczenie zdefiniowane w implementacji.
.
Language=Romanian
ERROR_IMPLEMENTATION_LIMIT - An operation attempted to exceed an implementation-defined limit.
.

MessageId=1298
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CACHE_ONLY
Language=English
ERROR_DS_CACHE_ONLY - The requested object is for internal DS operations only.
.
Language=Russian
ERROR_DS_CACHE_ONLY - Поток, задействованный в данной операции, не отвечает.
.
Language=Polish
ERROR_DS_CACHE_ONLY - The requested object is for internal DS operations only.
.
Language=Romanian
ERROR_DS_CACHE_ONLY - The requested object is for internal DS operations only.
.

MessageId=1300
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_ALL_ASSIGNED
Language=English
ERROR_NOT_ALL_ASSIGNED - Not all privileges referenced are assigned to the caller.
.
Language=Russian
ERROR_NOT_ALL_ASSIGNED - Вызывающая сторона не обладает всеми необходимыми правами доступа.
.
Language=Polish
ERROR_NOT_ALL_ASSIGNED - Nie wszystkie wywoływane uprawnienia lub grupy są przypisane komputerowi wywołującemu.
.
Language=Romanian
ERROR_NOT_ALL_ASSIGNED - Not all privileges referenced are assigned to the caller.
.

MessageId=1301
Severity=Success
Facility=System
SymbolicName=ERROR_SOME_NOT_MAPPED
Language=English
ERROR_SOME_NOT_MAPPED - Some mapping between account names and security IDs was not done.
.
Language=Russian
ERROR_SOME_NOT_MAPPED - Некоторые соответствия между именами пользователей и идентификаторами безопасности не были установлены.
.
Language=Polish
ERROR_SOME_NOT_MAPPED - Nie wykonano pewnych mapowań między nazwami kont i identyfikatorami zabezpieczeń.
.
Language=Romanian
ERROR_SOME_NOT_MAPPED - Some mapping between account names and security IDs was not done.
.

MessageId=1302
Severity=Success
Facility=System
SymbolicName=ERROR_NO_QUOTAS_FOR_ACCOUNT
Language=English
ERROR_NO_QUOTAS_FOR_ACCOUNT - No system quota limits are specifically set for this account.
.
Language=Russian
ERROR_NO_QUOTAS_FOR_ACCOUNT - Системные квоты для данной учетной записи не установлены.
.
Language=Polish
ERROR_NO_QUOTAS_FOR_ACCOUNT - Dla tego konta nie ustawiono żadnych szczególnych ograniczeń przydziałów zasobów systemowych.
.
Language=Romanian
ERROR_NO_QUOTAS_FOR_ACCOUNT - No system quota limits are specifically set for this account.
.

MessageId=1303
Severity=Success
Facility=System
SymbolicName=ERROR_LOCAL_USER_SESSION_KEY
Language=English
ERROR_LOCAL_USER_SESSION_KEY - No encryption key is available. A well-known encryption key was returned.
.
Language=Russian
ERROR_LOCAL_USER_SESSION_KEY - Ключ шифрования недоступен. Возвращен общедоступный ключ.
.
Language=Polish
ERROR_LOCAL_USER_SESSION_KEY - Brak klucza szyfrowania. Został zwrócony dobrze znany klucz szyfrowania.
.
Language=Romanian
ERROR_LOCAL_USER_SESSION_KEY - No encryption key is available. A well-known encryption key was returned.
.

MessageId=1304
Severity=Success
Facility=System
SymbolicName=ERROR_NULL_LM_PASSWORD
Language=English
ERROR_NULL_LM_PASSWORD - The password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string.
.
Language=Russian
ERROR_NULL_LM_PASSWORD - Пароль слишком сложен и не может быть преобразован в пароль LAN Manager. Вместо пароля LAN Manager была возвращена пустая строка.
.
Language=Polish
ERROR_NULL_LM_PASSWORD - Hasło jest zbyt złożone, aby mogło być przekształcone na hasło programu LAN Manager. Zwrócone hasło programu LAN Manager jest ciągiem pustym (NULL).
.
Language=Romanian
ERROR_NULL_LM_PASSWORD - The password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a NULL string.
.

MessageId=1305
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_REVISION
Language=English
ERROR_UNKNOWN_REVISION - The revision level is unknown.
.
Language=Russian
ERROR_UNKNOWN_REVISION - Уровень редакции неизвестен.
.
Language=Polish
ERROR_UNKNOWN_REVISION - Poziom wydania jest nieznany.
.
Language=Romanian
ERROR_UNKNOWN_REVISION - The revision level is unknown.
.

MessageId=1306
Severity=Success
Facility=System
SymbolicName=ERROR_REVISION_MISMATCH
Language=English
ERROR_REVISION_MISMATCH - Indicates two revision levels are incompatible.
.
Language=Russian
ERROR_REVISION_MISMATCH - Два уровня редакции являются несовместимыми.
.
Language=Polish
ERROR_REVISION_MISMATCH - Wskazuje, że dwa poziomy wydania są niezgodne.
.
Language=Romanian
ERROR_REVISION_MISMATCH - Indicates two revision levels are incompatible.
.

MessageId=1307
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_OWNER
Language=English
ERROR_INVALID_OWNER - This security ID may not be assigned as the owner of this object.
.
Language=Russian
ERROR_INVALID_OWNER - Этот идентификатор безопасности не может быть назначен владельцем этого объекта.
.
Language=Polish
ERROR_INVALID_OWNER - Ten identyfikator zabezpieczeń nie może być przypisany jako właściciel tego obiektu.
.
Language=Romanian
ERROR_INVALID_OWNER - This security ID may not be assigned as the owner of this object.
.

MessageId=1308
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRIMARY_GROUP
Language=English
ERROR_INVALID_PRIMARY_GROUP - This security ID may not be assigned as the primary group of an object.
.
Language=Russian
ERROR_INVALID_PRIMARY_GROUP - Этот идентификатор безопасности не может быть назначен основной группой объекта.
.
Language=Polish
ERROR_INVALID_PRIMARY_GROUP - Ten identyfikator zabezpieczeń nie może być przypisany jako grupa podstawowa obiektu.
.
Language=Romanian
ERROR_INVALID_PRIMARY_GROUP - This security ID may not be assigned as the primary group of an object.
.

MessageId=1309
Severity=Success
Facility=System
SymbolicName=ERROR_NO_IMPERSONATION_TOKEN
Language=English
ERROR_NO_IMPERSONATION_TOKEN - An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client.
.
Language=Russian
ERROR_NO_IMPERSONATION_TOKEN - Предпринята попытка использования элемента олицетворения потоком команд, который в данное время не олицетворяет клиента.
.
Language=Polish
ERROR_NO_IMPERSONATION_TOKEN - Na tokenie personifikacji podjął próbę działania wątek, który obecnie nie personifikuje żadnego klienta.
.
Language=Romanian
ERROR_NO_IMPERSONATION_TOKEN - An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client.
.

MessageId=1310
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_DISABLE_MANDATORY
Language=English
ERROR_CANT_DISABLE_MANDATORY - The group may not be disabled.
.
Language=Russian
ERROR_CANT_DISABLE_MANDATORY - Эту группу невозможно отключить.
.
Language=Polish
ERROR_CANT_DISABLE_MANDATORY - Grupa nie może być wyłączona.
.
Language=Romanian
ERROR_CANT_DISABLE_MANDATORY - The group may not be disabled.
.

MessageId=1311
Severity=Success
Facility=System
SymbolicName=ERROR_NO_LOGON_SERVERS
Language=English
ERROR_NO_LOGON_SERVERS - There are currently no logon servers available to service the logon request.
.
Language=Russian
ERROR_NO_LOGON_SERVERS - Отсутствуют серверы, которые могли бы обработать запрос на вход в сеть.
.
Language=Polish
ERROR_NO_LOGON_SERVERS - Nie ma obecnie serwerów logowania dostępnych do obsługi żądania logowania.
.
Language=Romanian
ERROR_NO_LOGON_SERVERS - There are currently no logon servers available to service the logon request.
.

MessageId=1312
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_LOGON_SESSION
Language=English
ERROR_NO_SUCH_LOGON_SESSION - A specified logon session does not exist. It may already have been terminated.
.
Language=Russian
ERROR_NO_SUCH_LOGON_SESSION - Указанный сеанс работы не существует. Возможно, он уже  завершен.
.
Language=Polish
ERROR_NO_SUCH_LOGON_SESSION - Określona sesja logowania nie istnieje. Być może została już zakończona.
.
Language=Romanian
ERROR_NO_SUCH_LOGON_SESSION - A specified logon session does not exist. It may already have been terminated.
.

MessageId=1313
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_PRIVILEGE
Language=English
ERROR_NO_SUCH_PRIVILEGE - A specified privilege does not exist.
.
Language=Russian
ERROR_NO_SUCH_PRIVILEGE - Указанная привилегия не существует.
.
Language=Polish
ERROR_NO_SUCH_PRIVILEGE - Określone uprawnienie nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_PRIVILEGE - A specified privilege does not exist.
.

MessageId=1314
Severity=Success
Facility=System
SymbolicName=ERROR_PRIVILEGE_NOT_HELD
Language=English
ERROR_PRIVILEGE_NOT_HELD - A required privilege is not held by the client.
.
Language=Russian
ERROR_PRIVILEGE_NOT_HELD - Клиент не обладает требуемыми правами.
.
Language=Polish
ERROR_PRIVILEGE_NOT_HELD - Klient nie ma wymaganych uprawnień.
.
Language=Romanian
ERROR_PRIVILEGE_NOT_HELD - A required privilege is not held by the client.
.

MessageId=1315
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ACCOUNT_NAME
Language=English
ERROR_INVALID_ACCOUNT_NAME - The name provided is not a properly formed account name.
.
Language=Russian
ERROR_INVALID_ACCOUNT_NAME - Указанное имя не является корректным именем пользователя.
.
Language=Polish
ERROR_INVALID_ACCOUNT_NAME - Podana nazwa nie jest właściwie sformułowaną nazwą konta.
.
Language=Romanian
ERROR_INVALID_ACCOUNT_NAME - The name provided is not a properly formed account name.
.

MessageId=1316
Severity=Success
Facility=System
SymbolicName=ERROR_USER_EXISTS
Language=English
ERROR_USER_EXISTS - The specified user already exists.
.
Language=Russian
ERROR_USER_EXISTS - Указанная учетная запись уже существует.
.
Language=Polish
ERROR_USER_EXISTS - Określone konto już istnieje.
.
Language=Romanian
ERROR_USER_EXISTS - The specified user already exists.
.

MessageId=1317
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_USER
Language=English
ERROR_NO_SUCH_USER - The specified user does not exist.
.
Language=Russian
ERROR_NO_SUCH_USER - Указанная учетная запись не существует.
.
Language=Polish
ERROR_NO_SUCH_USER - Określone konto nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_USER - The specified user does not exist.
.

MessageId=1318
Severity=Success
Facility=System
SymbolicName=ERROR_GROUP_EXISTS
Language=English
ERROR_GROUP_EXISTS - The specified group already exists.
.
Language=Russian
ERROR_GROUP_EXISTS - Указанная группа уже существует.
.
Language=Polish
ERROR_GROUP_EXISTS - Określona grupa już istnieje.
.
Language=Romanian
ERROR_GROUP_EXISTS - The specified group already exists.
.

MessageId=1319
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_GROUP
Language=English
ERROR_NO_SUCH_GROUP - The specified group does not exist.
.
Language=Russian
ERROR_NO_SUCH_GROUP - Указанная группа не существует.
.
Language=Polish
ERROR_NO_SUCH_GROUP - Określona grupa nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_GROUP - The specified group does not exist.
.

MessageId=1320
Severity=Success
Facility=System
SymbolicName=ERROR_MEMBER_IN_GROUP
Language=English
ERROR_MEMBER_IN_GROUP - Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member.
.
Language=Russian
ERROR_MEMBER_IN_GROUP - Указанный пользователь уже является членом заданной группы, либо группа не может быть удалена, так как содержит как минимум одного пользователя.
.
Language=Polish
ERROR_MEMBER_IN_GROUP - Określone konto użytkownika jest już członkiem określonej grupy albo określona grupa nie może być usunięta, ponieważ zawiera członka grupy.
.
Language=Romanian
ERROR_MEMBER_IN_GROUP - Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member.
.

MessageId=1321
Severity=Success
Facility=System
SymbolicName=ERROR_MEMBER_NOT_IN_GROUP
Language=English
ERROR_MEMBER_NOT_IN_GROUP - The specified user account is not a member of the specified group account.
.
Language=Russian
ERROR_MEMBER_NOT_IN_GROUP - Указанный пользователь не является членом заданной группы.
.
Language=Polish
ERROR_MEMBER_NOT_IN_GROUP - Określone konto użytkownika nie jest członkiem określonego konta grupowego.
.
Language=Romanian
ERROR_MEMBER_NOT_IN_GROUP - The specified user account is not a member of the specified group account.
.

MessageId=1322
Severity=Success
Facility=System
SymbolicName=ERROR_LAST_ADMIN
Language=English
ERROR_LAST_ADMIN - The last remaining administration account cannot be disabled or deleted.
.
Language=Russian
ERROR_LAST_ADMIN - Эта операция запрещена, так как может привести к отключению, удалению или невозможности входа учетной записи администратора.
.
Language=Polish
ERROR_LAST_ADMIN - Ostatnie pozostałe konto administracyjne nie może zostać wyłączone ani usunięte.
.
Language=Romanian
ERROR_LAST_ADMIN - The last remaining administration account cannot be disabled or deleted.
.

MessageId=1323
Severity=Success
Facility=System
SymbolicName=ERROR_WRONG_PASSWORD
Language=English
ERROR_WRONG_PASSWORD - Unable to update the password. The value provided as the current password is incorrect.
.
Language=Russian
ERROR_WRONG_PASSWORD - Не удается обновить пароль. Текущий пароль был задан неверно.
.
Language=Polish
ERROR_WRONG_PASSWORD - Nie można zaktualizować hasła. Wartość podana jako bieżące hasło jest niepoprawna.
.
Language=Romanian
ERROR_WRONG_PASSWORD - Unable to update the password. The value provided as the current password is incorrect.
.

MessageId=1324
Severity=Success
Facility=System
SymbolicName=ERROR_ILL_FORMED_PASSWORD
Language=English
ERROR_ILL_FORMED_PASSWORD - Unable to update the password. The value provided for the new password contains values that are not allowed in passwords.
.
Language=Russian
ERROR_ILL_FORMED_PASSWORD - Не удается обновить пароль. Новый пароль содержит недопустимые символы.
.
Language=Polish
ERROR_ILL_FORMED_PASSWORD - Nie można zaktualizować hasła. Wartość podana jako nowe hasło zawiera wartości niedozwolone w hasłach.
.
Language=Romanian
ERROR_ILL_FORMED_PASSWORD - Unable to update the password. The value provided for the new password contains values that are not allowed in passwords.
.

MessageId=1325
Severity=Success
Facility=System
SymbolicName=ERROR_PASSWORD_RESTRICTION
Language=English
ERROR_PASSWORD_RESTRICTION - Unable to update the password. The value provided for the new password does not meet the length, complexity, or history requirement of the domain.
.
Language=Russian
ERROR_PASSWORD_RESTRICTION - Не удается обновить пароль. Введенный пароль не обеспечивает требований домена к длине пароля, его сложности или истории обновления.
.
Language=Polish
ERROR_PASSWORD_RESTRICTION - Nie można zaktualizować hasła. Podana wartość nowego hasła nie spełnia wymagań domeny dotyczących długości, złożoności lub historii hasła.
.
Language=Romanian
ERROR_PASSWORD_RESTRICTION - Unable to update the password. The value provided for the new password does not meet the length, complexity, or history requirement of the domain.
.

MessageId=1326
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_FAILURE
Language=English
ERROR_LOGON_FAILURE - Logon failure: unknown user name or bad password.
.
Language=Russian
ERROR_LOGON_FAILURE - Неверное имя пользователя или пароль.
.
Language=Polish
ERROR_LOGON_FAILURE - Błąd logowania: nieznana nazwa użytkownika lub nieprawidłowe hasło.
.
Language=Romanian
ERROR_LOGON_FAILURE - Logon failure: unknown user name or bad password.
.

MessageId=1327
Severity=Success
Facility=System
SymbolicName=ERROR_ACCOUNT_RESTRICTION
Language=English
ERROR_ACCOUNT_RESTRICTION - Logon failure: user account restriction. Possible reasons are blank passwords not allowed, logon hour restrictions, or a policy restriction has been enforced.
.
Language=Russian
ERROR_ACCOUNT_RESTRICTION - Вход этого пользователя в систему не выполнен из-за ограничений учетной записи. Например: пустые пароли не разрешены, ограничено число входов или включено ограничение политики.
.
Language=Polish
ERROR_ACCOUNT_RESTRICTION - Błąd logowania: Ograniczenie konta użytkownika. Do możliwych przyczyn należą: niedozwolone puste hasła, ograniczenia godzin logowania lub wymuszanie ograniczenia zasad.
.
Language=Romanian
ERROR_ACCOUNT_RESTRICTION - Logon failure: user account restriction. Possible reasons are blank passwords not allowed, logon hour restrictions, or a policy restriction has been enforced.
.

MessageId=1328
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LOGON_HOURS
Language=English
ERROR_INVALID_LOGON_HOURS - Logon failure: account logon time restriction violation.
.
Language=Russian
ERROR_INVALID_LOGON_HOURS - Вы не можете войти в систему сейчас из-за ограничений вашей учетной записи.
.
Language=Polish
ERROR_INVALID_LOGON_HOURS - Błąd logowania: przekroczenie ograniczenia czasu logowania.
.
Language=Romanian
ERROR_INVALID_LOGON_HOURS - Logon failure: account logon time restriction violation.
.

MessageId=1329
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_WORKSTATION
Language=English
ERROR_INVALID_WORKSTATION - Logon failure: user not allowed to log on to this computer.
.
Language=Russian
ERROR_INVALID_WORKSTATION - Этому пользователю не разрешен вход в систему на этом компьютере.
.
Language=Polish
ERROR_INVALID_WORKSTATION - Błąd logowania: użytkownik nie ma zezwolenia na logowanie się w tym komputerze.
.
Language=Romanian
ERROR_INVALID_WORKSTATION - Logon failure: user not allowed to log on to this computer.
.

MessageId=1330
Severity=Success
Facility=System
SymbolicName=ERROR_PASSWORD_EXPIRED
Language=English
ERROR_PASSWORD_EXPIRED - Logon failure: the specified account password has expired.
.
Language=Russian
ERROR_PASSWORD_EXPIRED - Срок действия пароля для этой учетной записи истек.
.
Language=Polish
ERROR_PASSWORD_EXPIRED - Błąd logowania: określone hasło konta wygasło.
.
Language=Romanian
ERROR_PASSWORD_EXPIRED - Logon failure: the specified account password has expired.
.

MessageId=1331
Severity=Success
Facility=System
SymbolicName=ERROR_ACCOUNT_DISABLED
Language=English
ERROR_ACCOUNT_DISABLED - Logon failure: account currently disabled.
.
Language=Russian
ERROR_ACCOUNT_DISABLED - Вход этого пользователя в систему невозможен, так как эта учетная запись сейчас отключена.
.
Language=Polish
ERROR_ACCOUNT_DISABLED - Błąd logowania: konto jest obecnie wyłączone.
.
Language=Romanian
ERROR_ACCOUNT_DISABLED - Logon failure: account currently disabled.
.

MessageId=1332
Severity=Success
Facility=System
SymbolicName=ERROR_NONE_MAPPED
Language=English
ERROR_NONE_MAPPED - No mapping between account names and security IDs was done.
.
Language=Russian
ERROR_NONE_MAPPED - Сопоставление между именами пользователей и идентификаторами безопасности не было произведено.
.
Language=Polish
ERROR_NONE_MAPPED - Nie zostało wykonane mapowanie między nazwami kont a identyfikatorami zabezpieczeń.
.
Language=Romanian
ERROR_NONE_MAPPED - No mapping between account names and security IDs was done.
.

MessageId=1333
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_LUIDS_REQUESTED
Language=English
ERROR_TOO_MANY_LUIDS_REQUESTED - Too many local user identifiers (LUIDs) were requested at one time.
.
Language=Russian
ERROR_TOO_MANY_LUIDS_REQUESTED - Одновременно запрошено слишком много локальных кодов пользователей.
.
Language=Polish
ERROR_TOO_MANY_LUIDS_REQUESTED - Wystąpiło za dużo równoczesnych żądań identyfikatorów użytkowników lokalnych (LUID).
.
Language=Romanian
ERROR_TOO_MANY_LUIDS_REQUESTED - Too many local user identifiers (LUIDs) were requested at one time.
.

MessageId=1334
Severity=Success
Facility=System
SymbolicName=ERROR_LUIDS_EXHAUSTED
Language=English
ERROR_LUIDS_EXHAUSTED - No more local user identifiers (LUIDs) are available.
.
Language=Russian
ERROR_LUIDS_EXHAUSTED - Дополнительные локальные коды пользователей недоступны.
.
Language=Polish
ERROR_LUIDS_EXHAUSTED - Brak dostępnych identyfikatorów użytkowników lokalnych (LUID).
.
Language=Romanian
ERROR_LUIDS_EXHAUSTED - No more local user identifiers (LUIDs) are available.
.

MessageId=1335
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SUB_AUTHORITY
Language=English
ERROR_INVALID_SUB_AUTHORITY - The subauthority part of a security ID is invalid for this particular use.
.
Language=Russian
ERROR_INVALID_SUB_AUTHORITY - Часть "subauthority" идентификатора безопасности недействительна для этого конкретного использования.
.
Language=Polish
ERROR_INVALID_SUB_AUTHORITY - Podrzędna część identyfikatora zabezpieczeń jest nieprawidłowa dla tego szczególnego zastosowania.
.
Language=Romanian
ERROR_INVALID_SUB_AUTHORITY - The subauthority part of a security ID is invalid for this particular use.
.

MessageId=1336
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ACL
Language=English
ERROR_INVALID_ACL - The access control list (ACL) structure is invalid.
.
Language=Russian
ERROR_INVALID_ACL - Список управления доступом (ACL) имеет неверную структуру.
.
Language=Polish
ERROR_INVALID_ACL - Struktura listy kontroli dostępu (ACL) jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_ACL - The access control list (ACL) structure is invalid.
.

MessageId=1337
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SID
Language=English
ERROR_INVALID_SID - The security ID structure is invalid.
.
Language=Russian
ERROR_INVALID_SID - Идентификатор безопасности имеет неверную структуру.
.
Language=Polish
ERROR_INVALID_SID - Struktura identyfikatora zabezpieczenia jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_SID - The security ID structure is invalid.
.

MessageId=1338
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SECURITY_DESCR
Language=English
ERROR_INVALID_SECURITY_DESCR - The security descriptor structure is invalid.
.
Language=Russian
ERROR_INVALID_SECURITY_DESCR - Дескриптор защиты данных имеет неверную структуру.
.
Language=Polish
ERROR_INVALID_SECURITY_DESCR - Struktura deskryptora zabezpieczeń jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_SECURITY_DESCR - The security descriptor structure is invalid.
.

MessageId=1340
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_INHERITANCE_ACL
Language=English
ERROR_BAD_INHERITANCE_ACL - The inherited access control list (ACL) or access control entry (ACE) could not be built.
.
Language=Russian
ERROR_BAD_INHERITANCE_ACL - Не удается построить список управления доступом (ACL) или элемент этого списка (ACE).
.
Language=Polish
ERROR_BAD_INHERITANCE_ACL - Nie można zbudować dziedziczonej listy kontroli dostępu (ACL) lub wpisu kontroli dostępu (ACE).
.
Language=Romanian
ERROR_BAD_INHERITANCE_ACL - The inherited access control list (ACL) or access control entry (ACE) could not be built.
.

MessageId=1341
Severity=Success
Facility=System
SymbolicName=ERROR_SERVER_DISABLED
Language=English
ERROR_SERVER_DISABLED - The server is currently disabled.
.
Language=Russian
ERROR_SERVER_DISABLED - Сервер в настоящее время отключен.
.
Language=Polish
ERROR_SERVER_DISABLED - Serwer jest obecnie wyłączony.
.
Language=Romanian
ERROR_SERVER_DISABLED - The server is currently disabled.
.

MessageId=1342
Severity=Success
Facility=System
SymbolicName=ERROR_SERVER_NOT_DISABLED
Language=English
ERROR_SERVER_NOT_DISABLED - The server is currently enabled.
.
Language=Russian
ERROR_SERVER_NOT_DISABLED - Сервер в настоящее время включен.
.
Language=Polish
ERROR_SERVER_NOT_DISABLED - Serwer jest obecnie włączony.
.
Language=Romanian
ERROR_SERVER_NOT_DISABLED - The server is currently enabled.
.

MessageId=1343
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ID_AUTHORITY
Language=English
ERROR_INVALID_ID_AUTHORITY - The value provided was an invalid value for an identifier authority.
.
Language=Russian
ERROR_INVALID_ID_AUTHORITY - Указано недопустимое значение для защитного кода.
.
Language=Polish
ERROR_INVALID_ID_AUTHORITY - Podana wartość była nieprawidłowa dla urzędu identyfikatora.
.
Language=Romanian
ERROR_INVALID_ID_AUTHORITY - The value provided was an invalid value for an identifier authority.
.

MessageId=1344
Severity=Success
Facility=System
SymbolicName=ERROR_ALLOTTED_SPACE_EXCEEDED
Language=English
ERROR_ALLOTTED_SPACE_EXCEEDED - No more memory is available for security information updates.
.
Language=Russian
ERROR_ALLOTTED_SPACE_EXCEEDED - Недостаточно памяти для обновления сведений, относящихся к защите данных.
.
Language=Polish
ERROR_ALLOTTED_SPACE_EXCEEDED - Za mało pamięci do aktualizacji informacji o zabezpieczeniach.
.
Language=Romanian
ERROR_ALLOTTED_SPACE_EXCEEDED - No more memory is available for security information updates.
.

MessageId=1345
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_GROUP_ATTRIBUTES
Language=English
ERROR_INVALID_GROUP_ATTRIBUTES - The specified attributes are invalid, or incompatible with the attributes for the group as a whole.
.
Language=Russian
ERROR_INVALID_GROUP_ATTRIBUTES - Указанные атрибуты неверны или несовместимы с атрибутами группы в целом.
.
Language=Polish
ERROR_INVALID_GROUP_ATTRIBUTES - Określone atrybuty są nieprawidłowe lub niezgodne z atrybutami całości grupy.
.
Language=Romanian
ERROR_INVALID_GROUP_ATTRIBUTES - The specified attributes are invalid, or incompatible with the attributes for the group as a whole.
.

MessageId=1346
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_IMPERSONATION_LEVEL
Language=English
ERROR_BAD_IMPERSONATION_LEVEL - Either a required impersonation level was not provided, or the provided impersonation level is invalid.
.
Language=Russian
ERROR_BAD_IMPERSONATION_LEVEL - Требуемый уровень олицетворения не обеспечен, или обеспеченный уровень неверен.
.
Language=Polish
ERROR_BAD_IMPERSONATION_LEVEL - Nie został podany poziom personifikacji albo podany poziom jest nieprawidłowy.
.
Language=Romanian
ERROR_BAD_IMPERSONATION_LEVEL - Either a required impersonation level was not provided, or the provided impersonation level is invalid.
.

MessageId=1347
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_OPEN_ANONYMOUS
Language=English
ERROR_CANT_OPEN_ANONYMOUS - Cannot open an anonymous level security token.
.
Language=Russian
ERROR_CANT_OPEN_ANONYMOUS - Не удается открыть токен безопасности анонимного уровня.
.
Language=Polish
ERROR_CANT_OPEN_ANONYMOUS - Nie można otworzyć tokenu o anonimowym poziomie zabezpieczenia.
.
Language=Romanian
ERROR_CANT_OPEN_ANONYMOUS - Cannot open an anonymous level security token.
.

MessageId=1348
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_VALIDATION_CLASS
Language=English
ERROR_BAD_VALIDATION_CLASS - The validation information class requested was invalid.
.
Language=Russian
ERROR_BAD_VALIDATION_CLASS - Запрошен неправильный класс сведений для проверки.
.
Language=Polish
ERROR_BAD_VALIDATION_CLASS - Żądana klasa informacji sprawdzania poprawności była nieprawidłowa.
.
Language=Romanian
ERROR_BAD_VALIDATION_CLASS - The validation information class requested was invalid.
.

MessageId=1349
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_TOKEN_TYPE
Language=English
ERROR_BAD_TOKEN_TYPE - The type of the token is inappropriate for its attempted use.
.
Language=Russian
ERROR_BAD_TOKEN_TYPE - Тип токена не соответствует выполняемой операции.
.
Language=Polish
ERROR_BAD_TOKEN_TYPE - Typ tokena jest nieodpowiedni dla podjętej próby jego użycia.
.
Language=Romanian
ERROR_BAD_TOKEN_TYPE - The type of the token is inappropriate for its attempted use.
.

MessageId=1350
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SECURITY_ON_OBJECT
Language=English
ERROR_NO_SECURITY_ON_OBJECT - Unable to perform a security operation on an object that has no associated security.
.
Language=Russian
ERROR_NO_SECURITY_ON_OBJECT - Операция, связанная с защитой данных, не может быть выполнена для незащищенного объекта.
.
Language=Polish
ERROR_NO_SECURITY_ON_OBJECT - Nie można wykonać operacji zabezpieczenia na obiekcie, z którym nie ma skojarzonego zabezpieczenia.
.
Language=Romanian
ERROR_NO_SECURITY_ON_OBJECT - Unable to perform a security operation on an object that has no associated security.
.

MessageId=1351
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_ACCESS_DOMAIN_INFO
Language=English
ERROR_CANT_ACCESS_DOMAIN_INFO - Configuration information could not be read from the domain controller, either because the machine is unavailable, or access has been denied.
.
Language=Russian
ERROR_CANT_ACCESS_DOMAIN_INFO - Не удалось получить данные о конфигурации от контроллера домена. Либо он отключен, либо к нему нет доступа.
.
Language=Polish
ERROR_CANT_ACCESS_DOMAIN_INFO - Nie można odczytać informacji o konfiguracji z kontrolera domeny, ponieważ urządzenie jest niedostępne lub dostęp jest zabroniony.
.
Language=Romanian
ERROR_CANT_ACCESS_DOMAIN_INFO - Configuration information could not be read from the domain controller, either because the machine is unavailable, or access has been denied.
.

MessageId=1352
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SERVER_STATE
Language=English
ERROR_INVALID_SERVER_STATE - The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation.
.
Language=Russian
ERROR_INVALID_SERVER_STATE - Диспетчер защиты (SAM) или локальный сервер (LSA) не смог выполнить требуемую операцию.
.
Language=Polish
ERROR_INVALID_SERVER_STATE - Menedżer kont zabezpieczeń (SAM) lub lokalny serwer urzędu zabezpieczeń (LSA) był w niewłaściwym stanie do wykonania operacji zabezpieczania.
.
Language=Romanian
ERROR_INVALID_SERVER_STATE - The security account manager (SAM) or local security authority (LSA) server was in the wrong state to perform the security operation.
.

MessageId=1353
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DOMAIN_STATE
Language=English
ERROR_INVALID_DOMAIN_STATE - The domain was in the wrong state to perform the security operation.
.
Language=Russian
ERROR_INVALID_DOMAIN_STATE - Состояние домена не позволило выполнить нужную операцию.
.
Language=Polish
ERROR_INVALID_DOMAIN_STATE - Domena była w niewłaściwym stanie do wykonania operacji zabezpieczania.
.
Language=Romanian
ERROR_INVALID_DOMAIN_STATE - The domain was in the wrong state to perform the security operation.
.

MessageId=1354
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DOMAIN_ROLE
Language=English
ERROR_INVALID_DOMAIN_ROLE - This operation is only allowed for the Primary Domain Controller of the domain.
.
Language=Russian
ERROR_INVALID_DOMAIN_ROLE - Операция разрешена только для основного контроллера домена.
.
Language=Polish
ERROR_INVALID_DOMAIN_ROLE - Ta operacja jest dozwolona tylko dla podstawowego kontrolera domeny.
.
Language=Romanian
ERROR_INVALID_DOMAIN_ROLE - This operation is only allowed for the Primary Domain Controller of the domain.
.

MessageId=1355
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_DOMAIN
Language=English
ERROR_NO_SUCH_DOMAIN - The specified domain either does not exist or could not be contacted.
.
Language=Russian
ERROR_NO_SUCH_DOMAIN - Указанный домен не существует или к нему невозможно подключиться.
.
Language=Polish
ERROR_NO_SUCH_DOMAIN - Określona domena nie istnieje lub nie można się z nią skontaktować.
.
Language=Romanian
ERROR_NO_SUCH_DOMAIN - The specified domain either does not exist or could not be contacted.
.

MessageId=1356
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_EXISTS
Language=English
ERROR_DOMAIN_EXISTS - The specified domain already exists.
.
Language=Russian
ERROR_DOMAIN_EXISTS - Указанный домен уже существует.
.
Language=Polish
ERROR_DOMAIN_EXISTS - Określona domena już istnieje.
.
Language=Romanian
ERROR_DOMAIN_EXISTS - The specified domain already exists.
.

MessageId=1357
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_LIMIT_EXCEEDED
Language=English
ERROR_DOMAIN_LIMIT_EXCEEDED - An attempt was made to exceed the limit on the number of domains per server.
.
Language=Russian
ERROR_DOMAIN_LIMIT_EXCEEDED - Была сделана попытка превысить предел на число доменов, обслуживаемых одним сервером.
.
Language=Polish
ERROR_DOMAIN_LIMIT_EXCEEDED - Podjęto próbę przekroczenia limitu liczby domen na serwer.
.
Language=Romanian
ERROR_DOMAIN_LIMIT_EXCEEDED - An attempt was made to exceed the limit on the number of domains per server.
.

MessageId=1358
Severity=Success
Facility=System
SymbolicName=ERROR_INTERNAL_DB_CORRUPTION
Language=English
ERROR_INTERNAL_DB_CORRUPTION - Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk.
.
Language=Russian
ERROR_INTERNAL_DB_CORRUPTION - Не удается завершить требуемую операцию из-за сбоев в данных на диске или неустранимой ошибки носителя.
.
Language=Polish
ERROR_INTERNAL_DB_CORRUPTION - Nie można wykonać żądanej operacji, ponieważ wystąpiła katastrofalna awaria nośnika lub uszkodzenie struktury danych na dysku.
.
Language=Romanian
ERROR_INTERNAL_DB_CORRUPTION - Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk.
.

MessageId=1359
Severity=Success
Facility=System
SymbolicName=ERROR_INTERNAL_ERROR
Language=English
ERROR_INTERNAL_ERROR - An internal error occurred.
.
Language=Russian
ERROR_INTERNAL_ERROR - Внутренняя ошибка.
.
Language=Polish
ERROR_INTERNAL_ERROR - Wystąpił błąd wewnętrzny.
.
Language=Romanian
ERROR_INTERNAL_ERROR - An internal error occurred.
.

MessageId=1360
Severity=Success
Facility=System
SymbolicName=ERROR_GENERIC_NOT_MAPPED
Language=English
ERROR_GENERIC_NOT_MAPPED - Generic access types were contained in an access mask which should already be mapped to nongeneric types.
.
Language=Russian
ERROR_GENERIC_NOT_MAPPED - Универсальные типы доступа содержатся в маске доступа, которая должна была уже быть связана с нестандартными типами.
.
Language=Polish
ERROR_GENERIC_NOT_MAPPED - Rodzajowe typy dostępu były zawarte w masce dostępu, która powinna być już zamapowana na typy nierodzajowe.
.
Language=Romanian
ERROR_GENERIC_NOT_MAPPED - Generic access types were contained in an access mask which should already be mapped to nongeneric types.
.

MessageId=1361
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DESCRIPTOR_FORMAT
Language=English
ERROR_BAD_DESCRIPTOR_FORMAT - A security descriptor is not in the right format (absolute or self-relative).
.
Language=Russian
ERROR_BAD_DESCRIPTOR_FORMAT - Дескриптор защиты имеет неверный формат.
.
Language=Polish
ERROR_BAD_DESCRIPTOR_FORMAT - Deskryptor zabezpieczeń nie ma prawidłowego formatu (bezwzględnego lub autorelacyjnego).
.
Language=Romanian
ERROR_BAD_DESCRIPTOR_FORMAT - A security descriptor is not in the right format (absolute or self-relative).
.

MessageId=1362
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_LOGON_PROCESS
Language=English
ERROR_NOT_LOGON_PROCESS - The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process.
.
Language=Russian
ERROR_NOT_LOGON_PROCESS - Выполнение запрошенной операции разрешено только для процессов входа в систему. Вызывающий процесс не зарегистрирован как процесс входа в систему.
.
Language=Polish
ERROR_NOT_LOGON_PROCESS - Żądana akcja jest ograniczona do używania wyłącznie przez procesy logowania. Proces wywołujący nie jest zarejestrowany jako proces logowania.
.
Language=Romanian
ERROR_NOT_LOGON_PROCESS - The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process.
.

MessageId=1363
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_SESSION_EXISTS
Language=English
ERROR_LOGON_SESSION_EXISTS - Cannot start a new logon session with an ID that is already in use.
.
Language=Russian
ERROR_LOGON_SESSION_EXISTS - Запуск нового сеанса работы с уже использующимся кодом невозможен.
.
Language=Polish
ERROR_LOGON_SESSION_EXISTS - Nie można uruchomić nowej sesji logowania z identyfikatorem, który jest już w użyciu.
.
Language=Romanian
ERROR_LOGON_SESSION_EXISTS - Cannot start a new logon session with an ID that is already in use.
.

MessageId=1364
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_PACKAGE
Language=English
ERROR_NO_SUCH_PACKAGE - A specified authentication package is unknown.
.
Language=Russian
ERROR_NO_SUCH_PACKAGE - Пакет проверки подлинности не опознан.
.
Language=Polish
ERROR_NO_SUCH_PACKAGE - Określony pakiet uwierzytelniania jest nieznany.
.
Language=Romanian
ERROR_NO_SUCH_PACKAGE - A specified authentication package is unknown.
.

MessageId=1365
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_LOGON_SESSION_STATE
Language=English
ERROR_BAD_LOGON_SESSION_STATE - The logon session is not in a state that is consistent with the requested operation.
.
Language=Russian
ERROR_BAD_LOGON_SESSION_STATE - Текущее состояние сеанса входа в систему не подходит для запрошенной операции.
.
Language=Polish
ERROR_BAD_LOGON_SESSION_STATE - Sesja logowania jest w stanie niezgodnym z żądaną operacją.
.
Language=Romanian
ERROR_BAD_LOGON_SESSION_STATE - The logon session is not in a state that is consistent with the requested operation.
.

MessageId=1366
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_SESSION_COLLISION
Language=English
ERROR_LOGON_SESSION_COLLISION - The logon session ID is already in use.
.
Language=Russian
ERROR_LOGON_SESSION_COLLISION - Код сеанса входа в систему уже используется.
.
Language=Polish
ERROR_LOGON_SESSION_COLLISION - Identyfikator sesji logowania jest już w użyciu.
.
Language=Romanian
ERROR_LOGON_SESSION_COLLISION - The logon session ID is already in use.
.

MessageId=1367
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LOGON_TYPE
Language=English
ERROR_INVALID_LOGON_TYPE - A logon request contained an invalid logon type value.
.
Language=Russian
ERROR_INVALID_LOGON_TYPE - Режим входа в систему задан неверно.
.
Language=Polish
ERROR_INVALID_LOGON_TYPE - Żądanie logowania zawierało nieprawidłowy typ wartości logowania.
.
Language=Romanian
ERROR_INVALID_LOGON_TYPE - A logon request contained an invalid logon type value.
.

MessageId=1368
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_IMPERSONATE
Language=English
ERROR_CANNOT_IMPERSONATE - Unable to impersonate using a named pipe until data has been read from that pipe.
.
Language=Russian
ERROR_CANNOT_IMPERSONATE - Невозможно обеспечить олицетворение через именованный канал до тех пор, пока данные не считаны из этого канала.
.
Language=Polish
ERROR_CANNOT_IMPERSONATE - Dopóki dane są odczytywane z nazwanego potoku, nie można przeprowadzić personifikacji przy jego użyciu.
.
Language=Romanian
ERROR_CANNOT_IMPERSONATE - Unable to impersonate using a named pipe until data has been read from that pipe.
.

MessageId=1369
Severity=Success
Facility=System
SymbolicName=ERROR_RXACT_INVALID_STATE
Language=English
ERROR_RXACT_INVALID_STATE - The transaction state of a registry subtree is incompatible with the requested operation.
.
Language=Russian
ERROR_RXACT_INVALID_STATE - Операция несовместима с состоянием транзакции для ветви реестра.
.
Language=Polish
ERROR_RXACT_INVALID_STATE - Stan transakcji poddrzewa rejestru jest niezgodny z żądaną operacją.
.
Language=Romanian
ERROR_RXACT_INVALID_STATE - The transaction state of a registry subtree is incompatible with the requested operation.
.

MessageId=1370
Severity=Success
Facility=System
SymbolicName=ERROR_RXACT_COMMIT_FAILURE
Language=English
ERROR_RXACT_COMMIT_FAILURE - An internal security database corruption has been encountered.
.
Language=Russian
ERROR_RXACT_COMMIT_FAILURE - База данных защиты повреждена.
.
Language=Polish
ERROR_RXACT_COMMIT_FAILURE - Wystąpiło uszkodzenie wewnętrznej bazy danych zabezpieczeń.
.
Language=Romanian
ERROR_RXACT_COMMIT_FAILURE - An internal security database corruption has been encountered.
.

MessageId=1371
Severity=Success
Facility=System
SymbolicName=ERROR_SPECIAL_ACCOUNT
Language=English
ERROR_SPECIAL_ACCOUNT - Cannot perform this operation on built-in accounts.
.
Language=Russian
ERROR_SPECIAL_ACCOUNT - Операция не предназначена для встроенных учетных записей.
.
Language=Polish
ERROR_SPECIAL_ACCOUNT - Nie można wykonać tej operacji na kontach wbudowanych.
.
Language=Romanian
ERROR_SPECIAL_ACCOUNT - Cannot perform this operation on built-in accounts.
.

MessageId=1372
Severity=Success
Facility=System
SymbolicName=ERROR_SPECIAL_GROUP
Language=English
ERROR_SPECIAL_GROUP - Cannot perform this operation on this built-in special group.
.
Language=Russian
ERROR_SPECIAL_GROUP - Операция не предназначена для встроенной специальной группы.
.
Language=Polish
ERROR_SPECIAL_GROUP - Nie można wykonać tej operacji na tej wbudowanej grupie specjalnej.
.
Language=Romanian
ERROR_SPECIAL_GROUP - Cannot perform this operation on this built-in special group.
.

MessageId=1373
Severity=Success
Facility=System
SymbolicName=ERROR_SPECIAL_USER
Language=English
ERROR_SPECIAL_USER - Cannot perform this operation on this built-in special user.
.
Language=Russian
ERROR_SPECIAL_USER - Операция не предназначена для встроенного специального пользователя.
.
Language=Polish
ERROR_SPECIAL_USER - Nie można wykonać tej operacji na tym wbudowanym użytkowniku specjalnym.
.
Language=Romanian
ERROR_SPECIAL_USER - Cannot perform this operation on this built-in special user.
.

MessageId=1374
Severity=Success
Facility=System
SymbolicName=ERROR_MEMBERS_PRIMARY_GROUP
Language=English
ERROR_MEMBERS_PRIMARY_GROUP - The user cannot be removed from a group because the group is currently the user's primary group.
.
Language=Russian
ERROR_MEMBERS_PRIMARY_GROUP - Невозможно удалить пользователя из группы, так как она является для него основной.
.
Language=Polish
ERROR_MEMBERS_PRIMARY_GROUP - Nie można usunąć użytkownika z grupy, ponieważ grupa jest obecnie podstawową grupą użytkownika.
.
Language=Romanian
ERROR_MEMBERS_PRIMARY_GROUP - The user cannot be removed from a group because the group is currently the user's primary group.
.

MessageId=1375
Severity=Success
Facility=System
SymbolicName=ERROR_TOKEN_ALREADY_IN_USE
Language=English
ERROR_TOKEN_ALREADY_IN_USE - The token is already in use as a primary token.
.
Language=Russian
ERROR_TOKEN_ALREADY_IN_USE - Токен уже используется в качестве основного токена.
.
Language=Polish
ERROR_TOKEN_ALREADY_IN_USE - Token jest już w użyciu jako token podstawowy.
.
Language=Romanian
ERROR_TOKEN_ALREADY_IN_USE - The token is already in use as a primary token.
.

MessageId=1376
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_ALIAS
Language=English
ERROR_NO_SUCH_ALIAS - The specified local group does not exist.
.
Language=Russian
ERROR_NO_SUCH_ALIAS - Указанная локальная группа не существует.
.
Language=Polish
ERROR_NO_SUCH_ALIAS - Określona grupa lokalna nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_ALIAS - The specified local group does not exist.
.

MessageId=1377
Severity=Success
Facility=System
SymbolicName=ERROR_MEMBER_NOT_IN_ALIAS
Language=English
ERROR_MEMBER_NOT_IN_ALIAS - The specified account name is not a member of the local group.
.
Language=Russian
ERROR_MEMBER_NOT_IN_ALIAS - Указанная учетная запись не входит в эту группу.
.
Language=Polish
ERROR_MEMBER_NOT_IN_ALIAS - Określona nazwa konta nie jest członkiem grupy.
.
Language=Romanian
ERROR_MEMBER_NOT_IN_ALIAS - The specified account name is not a member of the local group.
.

MessageId=1378
Severity=Success
Facility=System
SymbolicName=ERROR_MEMBER_IN_ALIAS
Language=English
ERROR_MEMBER_IN_ALIAS - The specified account name is already a member of the local group.
.
Language=Russian
ERROR_MEMBER_IN_ALIAS - Указанная учетная запись уже входит в эту группу.
.
Language=Polish
ERROR_MEMBER_IN_ALIAS - Określona nazwa konta jest już członkiem grupy.
.
Language=Romanian
ERROR_MEMBER_IN_ALIAS - The specified account name is already a member of the local group.
.

MessageId=1379
Severity=Success
Facility=System
SymbolicName=ERROR_ALIAS_EXISTS
Language=English
ERROR_ALIAS_EXISTS - The specified local group already exists.
.
Language=Russian
ERROR_ALIAS_EXISTS - Указанная локальная группа уже существует.
.
Language=Polish
ERROR_ALIAS_EXISTS - Określona grupa lokalna już istnieje.
.
Language=Romanian
ERROR_ALIAS_EXISTS - The specified local group already exists.
.

MessageId=1380
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_NOT_GRANTED
Language=English
ERROR_LOGON_NOT_GRANTED - Logon failure: the user has not been granted the requested logon type at this computer.
.
Language=Russian
ERROR_LOGON_NOT_GRANTED - Вход в систему не произведен: выбранный режим входа для данного пользователя на этом компьютере не предусмотрен.
.
Language=Polish
ERROR_LOGON_NOT_GRANTED - Błąd logowania: użytkownikowi nie przyznano żądanego typu logowania na tym komputerze.
.
Language=Romanian
ERROR_LOGON_NOT_GRANTED - Logon failure: the user has not been granted the requested logon type at this computer.
.

MessageId=1381
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_SECRETS
Language=English
ERROR_TOO_MANY_SECRETS - The maximum number of secrets that may be stored in a single system has been exceeded.
.
Language=Russian
ERROR_TOO_MANY_SECRETS - Достигнут предел по количеству защищенных данных/ресурсов для одной системы.
.
Language=Polish
ERROR_TOO_MANY_SECRETS - Przekroczono maksymalną liczbę haseł, które mogą być przechowywane w pojedynczym systemie.
.
Language=Romanian
ERROR_TOO_MANY_SECRETS - The maximum number of secrets that may be stored in a single system has been exceeded.
.

MessageId=1382
Severity=Success
Facility=System
SymbolicName=ERROR_SECRET_TOO_LONG
Language=English
ERROR_SECRET_TOO_LONG - The length of a secret exceeds the maximum length allowed.
.
Language=Russian
ERROR_SECRET_TOO_LONG - Длина защищенных данных превышает максимально возможную.
.
Language=Polish
ERROR_SECRET_TOO_LONG - Długość hasła przekracza maksymalną dopuszczalną wartość.
.
Language=Romanian
ERROR_SECRET_TOO_LONG - The length of a secret exceeds the maximum length allowed.
.

MessageId=1383
Severity=Success
Facility=System
SymbolicName=ERROR_INTERNAL_DB_ERROR
Language=English
ERROR_INTERNAL_DB_ERROR - The local security authority database contains an internal inconsistency.
.
Language=Russian
ERROR_INTERNAL_DB_ERROR - Локальная база данных защиты содержит внутренние несоответствия.
.
Language=Polish
ERROR_INTERNAL_DB_ERROR - Baza danych urzędu zabezpieczeń lokalnych zawiera wewnętrzną niezgodność.
.
Language=Romanian
ERROR_INTERNAL_DB_ERROR - The local security authority database contains an internal inconsistency.
.

MessageId=1384
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_CONTEXT_IDS
Language=English
ERROR_TOO_MANY_CONTEXT_IDS - During a logon attempt, the user's security context accumulated too many security IDs.
.
Language=Russian
ERROR_TOO_MANY_CONTEXT_IDS - При попытке входа в систему контекст безопасности пользователя накопил слишком много идентификаторов безопасности.
.
Language=Polish
ERROR_TOO_MANY_CONTEXT_IDS - Podczas próby logowania kontekst zabezpieczeń użytkownika zakumulował za dużo identyfikatorów zabezpieczeń.
.
Language=Romanian
ERROR_TOO_MANY_CONTEXT_IDS - During a logon attempt, the user's security context accumulated too many security IDs.
.

MessageId=1385
Severity=Success
Facility=System
SymbolicName=ERROR_LOGON_TYPE_NOT_GRANTED
Language=English
ERROR_LOGON_TYPE_NOT_GRANTED - Logon failure: the user has not been granted the requested logon type at this computer.
.
Language=Russian
ERROR_LOGON_TYPE_NOT_GRANTED - Вход в систему не произведен: выбранный режим входа для данного пользователя на этом компьютере не предусмотрен.
.
Language=Polish
ERROR_LOGON_TYPE_NOT_GRANTED - Błąd logowania: użytkownikowi nie przyznano żądanego typu logowania na tym komputerze.
.
Language=Romanian
ERROR_LOGON_TYPE_NOT_GRANTED - Logon failure: the user has not been granted the requested logon type at this computer.
.

MessageId=1386
Severity=Success
Facility=System
SymbolicName=ERROR_NT_CROSS_ENCRYPTION_REQUIRED
Language=English
ERROR_NT_CROSS_ENCRYPTION_REQUIRED - A cross-encrypted password is necessary to change a user password.
.
Language=Russian
ERROR_NT_CROSS_ENCRYPTION_REQUIRED - Для смены пароля необходим зашифрованный пароль.
.
Language=Polish
ERROR_NT_CROSS_ENCRYPTION_REQUIRED - Do zmiany hasła użytkownika konieczne jest hasło zaszyfrowane krzyżowo.
.
Language=Romanian
ERROR_NT_CROSS_ENCRYPTION_REQUIRED - A cross-encrypted password is necessary to change a user password.
.

MessageId=1387
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUCH_MEMBER
Language=English
ERROR_NO_SUCH_MEMBER - A new member could not be added to or removed from the local group because the member does not exist.
.
Language=Russian
ERROR_NO_SUCH_MEMBER - Не удалось добавить или удалить члена локальной группы, так как он не существует.
.
Language=Polish
ERROR_NO_SUCH_MEMBER - Nie można dodać nowego członka grupy do grupy lokalnej ani usunąć go z niej, ponieważ ten członek grupy nie istnieje.
.
Language=Romanian
ERROR_NO_SUCH_MEMBER - A new member could not be added to or removed from the local group because the member does not exist.
.

MessageId=1388
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MEMBER
Language=English
ERROR_INVALID_MEMBER - A new member could not be added to a local group because the member has the wrong account type.
.
Language=Russian
ERROR_INVALID_MEMBER - Добавление нового члена в локальную группу невозможно, так как он имеет неправильный тип учетной записи.
.
Language=Polish
ERROR_INVALID_MEMBER - Nie można dodać nowego członka grupy do grupy lokalnej, ponieważ ten członek grupy ma zły typ konta.
.
Language=Romanian
ERROR_INVALID_MEMBER - A new member could not be added to a local group because the member has the wrong account type.
.

MessageId=1389
Severity=Success
Facility=System
SymbolicName=ERROR_TOO_MANY_SIDS
Language=English
ERROR_TOO_MANY_SIDS - Too many security IDs have been specified.
.
Language=Russian
ERROR_TOO_MANY_SIDS - Задано слишком много идентификаторов безопасности.
.
Language=Polish
ERROR_TOO_MANY_SIDS - Określono za dużo identyfikatorów zabezpieczeń.
.
Language=Romanian
ERROR_TOO_MANY_SIDS - Too many security IDs have been specified.
.

MessageId=1390
Severity=Success
Facility=System
SymbolicName=ERROR_LM_CROSS_ENCRYPTION_REQUIRED
Language=English
ERROR_LM_CROSS_ENCRYPTION_REQUIRED - A cross-encrypted password is necessary to change this user password.
.
Language=Russian
ERROR_LM_CROSS_ENCRYPTION_REQUIRED - Для смены пароля необходим зашифрованный пароль.
.
Language=Polish
ERROR_LM_CROSS_ENCRYPTION_REQUIRED - Do zmiany tego hasła użytkownika konieczne jest hasło zaszyfrowane krzyżowo.
.
Language=Romanian
ERROR_LM_CROSS_ENCRYPTION_REQUIRED - A cross-encrypted password is necessary to change this user password.
.

MessageId=1391
Severity=Success
Facility=System
SymbolicName=ERROR_NO_INHERITANCE
Language=English
ERROR_NO_INHERITANCE - Indicates an ACL contains no inheritable components.
.
Language=Russian
ERROR_NO_INHERITANCE - Список управления доступом (ACL) не содержит наследуемых компонентов.
.
Language=Polish
ERROR_NO_INHERITANCE - Wskazuje, że ACL nie zawiera składników dziedzicznych.
.
Language=Romanian
ERROR_NO_INHERITANCE - Indicates an ACL contains no inheritable components.
.

MessageId=1392
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_CORRUPT
Language=English
ERROR_FILE_CORRUPT - The file or directory is corrupted and unreadable.
.
Language=Russian
ERROR_FILE_CORRUPT - Файл или папка повреждены. Чтение невозможно.
.
Language=Polish
ERROR_FILE_CORRUPT - Plik lub katalog jest uszkodzony i nieczytelny.
.
Language=Romanian
ERROR_FILE_CORRUPT - The file or directory is corrupted and unreadable.
.

MessageId=1393
Severity=Success
Facility=System
SymbolicName=ERROR_DISK_CORRUPT
Language=English
ERROR_DISK_CORRUPT - The disk structure is corrupted and unreadable.
.
Language=Russian
ERROR_DISK_CORRUPT - Структура диска повреждена. Чтение невозможно.
.
Language=Polish
ERROR_DISK_CORRUPT - Struktura dysku jest uszkodzona i nieczytelna.
.
Language=Romanian
ERROR_DISK_CORRUPT - The disk structure is corrupted and unreadable.
.

MessageId=1394
Severity=Success
Facility=System
SymbolicName=ERROR_NO_USER_SESSION_KEY
Language=English
ERROR_NO_USER_SESSION_KEY - There is no user session key for the specified logon session.
.
Language=Russian
ERROR_NO_USER_SESSION_KEY - Для заданного сеанса входа в систему отсутствует раздел сеанса пользователя.
.
Language=Polish
ERROR_NO_USER_SESSION_KEY - Brak klucza sesji użytkownika dla określonej sesji logowania.
.
Language=Romanian
ERROR_NO_USER_SESSION_KEY - There is no user session key for the specified logon session.
.

MessageId=1395
Severity=Success
Facility=System
SymbolicName=ERROR_LICENSE_QUOTA_EXCEEDED
Language=English
ERROR_LICENSE_QUOTA_EXCEEDED - The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept.
.
Language=Russian
ERROR_LICENSE_QUOTA_EXCEEDED - Для вызываемой службы действует лицензия на определенное число подключений. В настоящее время создание дополнительных подключений к службе невозможно, так как уже существует максимально допустимое число подключений.
.
Language=Polish
ERROR_LICENSE_QUOTA_EXCEEDED - Usługa, do której próbujesz uzyskać dostęp, ma licencję tylko na określoną liczbę połączeń. Nie można obecnie połączyć się z tą usługą, gdyż istnieje już tyle połączeń, ile usługa może zaakceptować.
.
Language=Romanian
ERROR_LICENSE_QUOTA_EXCEEDED - The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because there are already as many connections as the service can accept.
.

MessageId=1396
Severity=Success
Facility=System
SymbolicName=ERROR_WRONG_TARGET_NAME
Language=English
ERROR_WRONG_TARGET_NAME - Logon Failure: The target account name is incorrect.
.
Language=Russian
ERROR_WRONG_TARGET_NAME - Конечная учетная запись указана неверно.
.
Language=Polish
ERROR_WRONG_TARGET_NAME - Błąd logowania: niepoprawna nazwa docelowego konta.
.
Language=Romanian
ERROR_WRONG_TARGET_NAME - Logon Failure: The target account name is incorrect.
.

MessageId=1397
Severity=Success
Facility=System
SymbolicName=ERROR_MUTUAL_AUTH_FAILED
Language=English
ERROR_MUTUAL_AUTH_FAILED - Mutual Authentication failed. The server's password is out of date at the domain controller.
.
Language=Russian
ERROR_MUTUAL_AUTH_FAILED - Ошибка взаимной проверки подлинности. Пароль сервера на контроллере домена устарел.
.
Language=Polish
ERROR_MUTUAL_AUTH_FAILED - Wzajemne uwierzytelnienie nie powiodło się. Hasło serwera w kontrolerze domeny jest nieaktualne.
.
Language=Romanian
ERROR_MUTUAL_AUTH_FAILED - Mutual Authentication failed. The server's password is out of date at the domain controller.
.

MessageId=1398
Severity=Success
Facility=System
SymbolicName=ERROR_TIME_SKEW
Language=English
ERROR_TIME_SKEW - There is a time and/or date difference between the client and server.
.
Language=Russian
ERROR_TIME_SKEW - Существует разница настройки времени и/или даты между клиентом и сервером.
.
Language=Polish
ERROR_TIME_SKEW - Występuje różnica czasu i/lub daty między klientem i serwerem.
.
Language=Romanian
ERROR_TIME_SKEW - There is a time and/or date difference between the client and server.
.

MessageId=1399
Severity=Success
Facility=System
SymbolicName=ERROR_CURRENT_DOMAIN_NOT_ALLOWED
Language=English
ERROR_CURRENT_DOMAIN_NOT_ALLOWED - This operation cannot be performed on the current domain.
.
Language=Russian
ERROR_CURRENT_DOMAIN_NOT_ALLOWED - Эта операция не может быть выполнена над текущим доменом.
.
Language=Polish
ERROR_CURRENT_DOMAIN_NOT_ALLOWED - Tej operacji nie można wykonać na bieżącej domenie.
.
Language=Romanian
ERROR_CURRENT_DOMAIN_NOT_ALLOWED - This operation cannot be performed on the current domain.
.

MessageId=1400
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_WINDOW_HANDLE
Language=English
ERROR_INVALID_WINDOW_HANDLE - Invalid window handle.
.
Language=Russian
ERROR_INVALID_WINDOW_HANDLE - Недопустимый дескриптор окна.
.
Language=Polish
ERROR_INVALID_WINDOW_HANDLE - Nieprawidłowe dojście okna.
.
Language=Romanian
ERROR_INVALID_WINDOW_HANDLE - Invalid window handle.
.

MessageId=1401
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MENU_HANDLE
Language=English
ERROR_INVALID_MENU_HANDLE - Invalid menu handle.
.
Language=Russian
ERROR_INVALID_MENU_HANDLE - Неверный дескриптор меню.
.
Language=Polish
ERROR_INVALID_MENU_HANDLE - Nieprawidłowe dojście menu.
.
Language=Romanian
ERROR_INVALID_MENU_HANDLE - Invalid menu handle.
.

MessageId=1402
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_CURSOR_HANDLE
Language=English
ERROR_INVALID_CURSOR_HANDLE - Invalid cursor handle.
.
Language=Russian
ERROR_INVALID_CURSOR_HANDLE - Неверный дескриптор указателя.
.
Language=Polish
ERROR_INVALID_CURSOR_HANDLE - Nieprawidłowe dojście kursora.
.
Language=Romanian
ERROR_INVALID_CURSOR_HANDLE - Invalid cursor handle.
.

MessageId=1403
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ACCEL_HANDLE
Language=English
ERROR_INVALID_ACCEL_HANDLE - Invalid accelerator table handle.
.
Language=Russian
ERROR_INVALID_ACCEL_HANDLE - Неверный дескриптор таблицы сочетаний клавиш.
.
Language=Polish
ERROR_INVALID_ACCEL_HANDLE - Nieprawidłowe dojście tabeli przyspieszacza.
.
Language=Romanian
ERROR_INVALID_ACCEL_HANDLE - Invalid accelerator table handle.
.

MessageId=1404
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_HOOK_HANDLE
Language=English
ERROR_INVALID_HOOK_HANDLE - Invalid hook handle.
.
Language=Russian
ERROR_INVALID_HOOK_HANDLE - Неверный дескриптор обработчика.
.
Language=Polish
ERROR_INVALID_HOOK_HANDLE - Nieprawidłowe dojście haka.
.
Language=Romanian
ERROR_INVALID_HOOK_HANDLE - Invalid hook handle.
.

MessageId=1405
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DWP_HANDLE
Language=English
ERROR_INVALID_DWP_HANDLE - Invalid handle to a multiple-window position structure.
.
Language=Russian
ERROR_INVALID_DWP_HANDLE - Неверный дескриптор многооконной структуры.
.
Language=Polish
ERROR_INVALID_DWP_HANDLE - Nieprawidłowe dojście do struktury wielooknowej.
.
Language=Romanian
ERROR_INVALID_DWP_HANDLE - Invalid handle to a multiple-window position structure.
.

MessageId=1406
Severity=Success
Facility=System
SymbolicName=ERROR_TLW_WITH_WSCHILD
Language=English
ERROR_TLW_WITH_WSCHILD - Cannot create a top-level child window.
.
Language=Russian
ERROR_TLW_WITH_WSCHILD - Не удается создать дочернее окно верхнего уровня.
.
Language=Polish
ERROR_TLW_WITH_WSCHILD - Nie można utworzyć okna podrzędnego najwyższego poziomu.
.
Language=Romanian
ERROR_TLW_WITH_WSCHILD - Cannot create a top-level child window.
.

MessageId=1407
Severity=Success
Facility=System
SymbolicName=ERROR_CANNOT_FIND_WND_CLASS
Language=English
ERROR_CANNOT_FIND_WND_CLASS - Cannot find window class.
.
Language=Russian
ERROR_CANNOT_FIND_WND_CLASS - Не удается найти класс окна.
.
Language=Polish
ERROR_CANNOT_FIND_WND_CLASS - Nie można odnaleźć klasy okna.
.
Language=Romanian
ERROR_CANNOT_FIND_WND_CLASS - Cannot find window class.
.

MessageId=1408
Severity=Success
Facility=System
SymbolicName=ERROR_WINDOW_OF_OTHER_THREAD
Language=English
ERROR_WINDOW_OF_OTHER_THREAD - Invalid window; it belongs to other thread.
.
Language=Russian
ERROR_WINDOW_OF_OTHER_THREAD - Окно принадлежит другому потоку команд.
.
Language=Polish
ERROR_WINDOW_OF_OTHER_THREAD - Nieprawidłowe okno, należy ono do innego wątku.
.
Language=Romanian
ERROR_WINDOW_OF_OTHER_THREAD - Invalid window; it belongs to other thread.
.

MessageId=1409
Severity=Success
Facility=System
SymbolicName=ERROR_HOTKEY_ALREADY_REGISTERED
Language=English
ERROR_HOTKEY_ALREADY_REGISTERED - Hot key is already registered.
.
Language=Russian
ERROR_HOTKEY_ALREADY_REGISTERED - Назначенная клавиша уже зарегистрирована.
.
Language=Polish
ERROR_HOTKEY_ALREADY_REGISTERED - Klawisz dostępu jest już zarejestrowany.
.
Language=Romanian
ERROR_HOTKEY_ALREADY_REGISTERED - Hot key is already registered.
.

MessageId=1410
Severity=Success
Facility=System
SymbolicName=ERROR_CLASS_ALREADY_EXISTS
Language=English
ERROR_CLASS_ALREADY_EXISTS - Class already exists.
.
Language=Russian
ERROR_CLASS_ALREADY_EXISTS - Класс уже существует.
.
Language=Polish
ERROR_CLASS_ALREADY_EXISTS - Klasa już istnieje.
.
Language=Romanian
ERROR_CLASS_ALREADY_EXISTS - Class already exists.
.

MessageId=1411
Severity=Success
Facility=System
SymbolicName=ERROR_CLASS_DOES_NOT_EXIST
Language=English
ERROR_CLASS_DOES_NOT_EXIST - Class does not exist.
.
Language=Russian
ERROR_CLASS_DOES_NOT_EXIST - Класс не существует.
.
Language=Polish
ERROR_CLASS_DOES_NOT_EXIST - Klasa nie istnieje.
.
Language=Romanian
ERROR_CLASS_DOES_NOT_EXIST - Class does not exist.
.

MessageId=1412
Severity=Success
Facility=System
SymbolicName=ERROR_CLASS_HAS_WINDOWS
Language=English
ERROR_CLASS_HAS_WINDOWS - Class still has open windows.
.
Language=Russian
ERROR_CLASS_HAS_WINDOWS - Class still has open windows.
.
Language=Polish
ERROR_CLASS_HAS_WINDOWS - Klasa ma wciąż otwarte okna.
.
Language=Romanian
ERROR_CLASS_HAS_WINDOWS - Class still has open windows.
.

MessageId=1413
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_INDEX
Language=English
ERROR_INVALID_INDEX - Invalid index.
.
Language=Russian
ERROR_INVALID_INDEX - Invalid index.
.
Language=Polish
ERROR_INVALID_INDEX - Nieprawidłowy indeks.
.
Language=Romanian
ERROR_INVALID_INDEX - Invalid index.
.

MessageId=1414
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ICON_HANDLE
Language=English
ERROR_INVALID_ICON_HANDLE - Invalid icon handle.
.
Language=Russian
ERROR_INVALID_ICON_HANDLE - Invalid icon handle.
.
Language=Polish
ERROR_INVALID_ICON_HANDLE - Nieprawidłowe dojście ikony.
.
Language=Romanian
ERROR_INVALID_ICON_HANDLE - Invalid icon handle.
.

MessageId=1415
Severity=Success
Facility=System
SymbolicName=ERROR_PRIVATE_DIALOG_INDEX
Language=English
ERROR_PRIVATE_DIALOG_INDEX - Using private DIALOG window words.
.
Language=Russian
ERROR_PRIVATE_DIALOG_INDEX - Using private DIALOG window words.
.
Language=Polish
ERROR_PRIVATE_DIALOG_INDEX - Używane są słowa prywatnego okna DIALOG.
.
Language=Romanian
ERROR_PRIVATE_DIALOG_INDEX - Using private DIALOG window words.
.

MessageId=1416
Severity=Success
Facility=System
SymbolicName=ERROR_LISTBOX_ID_NOT_FOUND
Language=English
ERROR_LISTBOX_ID_NOT_FOUND - The list box identifier was not found.
.
Language=Russian
ERROR_LISTBOX_ID_NOT_FOUND - The list box identifier was not found.
.
Language=Polish
ERROR_LISTBOX_ID_NOT_FOUND - Nie znaleziono identyfikatora pola listy.
.
Language=Romanian
ERROR_LISTBOX_ID_NOT_FOUND - The list box identifier was not found.
.

MessageId=1417
Severity=Success
Facility=System
SymbolicName=ERROR_NO_WILDCARD_CHARACTERS
Language=English
ERROR_NO_WILDCARD_CHARACTERS - No wildcards were found.
.
Language=Russian
ERROR_NO_WILDCARD_CHARACTERS - No wildcards were found.
.
Language=Polish
ERROR_NO_WILDCARD_CHARACTERS - Nie znaleziono symboli wieloznacznych.
.
Language=Romanian
ERROR_NO_WILDCARD_CHARACTERS - No wildcards were found.
.

MessageId=1418
Severity=Success
Facility=System
SymbolicName=ERROR_CLIPBOARD_NOT_OPEN
Language=English
ERROR_CLIPBOARD_NOT_OPEN - Thread does not have a clipboard open.
.
Language=Russian
ERROR_CLIPBOARD_NOT_OPEN - Thread does not have a clipboard open.
.
Language=Polish
ERROR_CLIPBOARD_NOT_OPEN - Wątek nie ma otwartego Schowka.
.
Language=Romanian
ERROR_CLIPBOARD_NOT_OPEN - Thread does not have a clipboard open.
.

MessageId=1419
Severity=Success
Facility=System
SymbolicName=ERROR_HOTKEY_NOT_REGISTERED
Language=English
ERROR_HOTKEY_NOT_REGISTERED - Hot key is not registered.
.
Language=Russian
ERROR_HOTKEY_NOT_REGISTERED - Hot key is not registered.
.
Language=Polish
ERROR_HOTKEY_NOT_REGISTERED - Klawisz dostępu nie jest zarejestrowany.
.
Language=Romanian
ERROR_HOTKEY_NOT_REGISTERED - Hot key is not registered.
.

MessageId=1420
Severity=Success
Facility=System
SymbolicName=ERROR_WINDOW_NOT_DIALOG
Language=English
ERROR_WINDOW_NOT_DIALOG - The window is not a valid dialog window.
.
Language=Russian
ERROR_WINDOW_NOT_DIALOG - The window is not a valid dialog window.
.
Language=Polish
ERROR_WINDOW_NOT_DIALOG - Okno nie jest prawidłowym oknem dialogowym.
.
Language=Romanian
ERROR_WINDOW_NOT_DIALOG - The window is not a valid dialog window.
.

MessageId=1421
Severity=Success
Facility=System
SymbolicName=ERROR_CONTROL_ID_NOT_FOUND
Language=English
ERROR_CONTROL_ID_NOT_FOUND - Control ID not found.
.
Language=Russian
ERROR_CONTROL_ID_NOT_FOUND - Control ID not found.
.
Language=Polish
ERROR_CONTROL_ID_NOT_FOUND - Nie można odnaleźć identyfikatora formantu.
.
Language=Romanian
ERROR_CONTROL_ID_NOT_FOUND - Control ID not found.
.

MessageId=1422
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_COMBOBOX_MESSAGE
Language=English
ERROR_INVALID_COMBOBOX_MESSAGE - Invalid message for a combo box because it does not have an edit control.
.
Language=Russian
ERROR_INVALID_COMBOBOX_MESSAGE - Invalid message for a combo box because it does not have an edit control.
.
Language=Polish
ERROR_INVALID_COMBOBOX_MESSAGE - Nieprawidłowy komunikat dla pola kombi, ponieważ nie ma ono formantu edycyjnego.
.
Language=Romanian
ERROR_INVALID_COMBOBOX_MESSAGE - Invalid message for a combo box because it does not have an edit control.
.

MessageId=1423
Severity=Success
Facility=System
SymbolicName=ERROR_WINDOW_NOT_COMBOBOX
Language=English
ERROR_WINDOW_NOT_COMBOBOX - The window is not a combo box.
.
Language=Russian
ERROR_WINDOW_NOT_COMBOBOX - The window is not a combo box.
.
Language=Polish
ERROR_WINDOW_NOT_COMBOBOX - Okno nie jest polem kombi.
.
Language=Romanian
ERROR_WINDOW_NOT_COMBOBOX - The window is not a combo box.
.

MessageId=1424
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_EDIT_HEIGHT
Language=English
ERROR_INVALID_EDIT_HEIGHT - Height must be less than 256.
.
Language=Russian
ERROR_INVALID_EDIT_HEIGHT - Height must be less than 256.
.
Language=Polish
ERROR_INVALID_EDIT_HEIGHT - Wysokość musi być mniejsza niż 256.
.
Language=Romanian
ERROR_INVALID_EDIT_HEIGHT - Height must be less than 256.
.

MessageId=1425
Severity=Success
Facility=System
SymbolicName=ERROR_DC_NOT_FOUND
Language=English
ERROR_DC_NOT_FOUND - Invalid device context (DC) handle.
.
Language=Russian
ERROR_DC_NOT_FOUND - Invalid device context (DC) handle.
.
Language=Polish
ERROR_DC_NOT_FOUND - Nieprawidłowe dojście kontekstu urządzenia (DC).
.
Language=Romanian
ERROR_DC_NOT_FOUND - Invalid device context (DC) handle.
.

MessageId=1426
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_HOOK_FILTER
Language=English
ERROR_INVALID_HOOK_FILTER - Invalid hook procedure type.
.
Language=Russian
ERROR_INVALID_HOOK_FILTER - Invalid hook procedure type.
.
Language=Polish
ERROR_INVALID_HOOK_FILTER - Nieprawidłowy typ procedury haka.
.
Language=Romanian
ERROR_INVALID_HOOK_FILTER - Invalid hook procedure type.
.

MessageId=1427
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FILTER_PROC
Language=English
ERROR_INVALID_FILTER_PROC - Invalid hook procedure.
.
Language=Russian
ERROR_INVALID_FILTER_PROC - Invalid hook procedure.
.
Language=Polish
ERROR_INVALID_FILTER_PROC - Nieprawidłowa procedura haka.
.
Language=Romanian
ERROR_INVALID_FILTER_PROC - Invalid hook procedure.
.

MessageId=1428
Severity=Success
Facility=System
SymbolicName=ERROR_HOOK_NEEDS_HMOD
Language=English
ERROR_HOOK_NEEDS_HMOD - Cannot set nonlocal hook without a module handle.
.
Language=Russian
ERROR_HOOK_NEEDS_HMOD - Cannot set nonlocal hook without a module handle.
.
Language=Polish
ERROR_HOOK_NEEDS_HMOD - Nie można ustawić haka nielokalnego bez dojścia modułu.
.
Language=Romanian
ERROR_HOOK_NEEDS_HMOD - Cannot set nonlocal hook without a module handle.
.

MessageId=1429
Severity=Success
Facility=System
SymbolicName=ERROR_GLOBAL_ONLY_HOOK
Language=English
ERROR_GLOBAL_ONLY_HOOK - This hook procedure can only be set globally.
.
Language=Russian
ERROR_GLOBAL_ONLY_HOOK - This hook procedure can only be set globally.
.
Language=Polish
ERROR_GLOBAL_ONLY_HOOK - Ta procedura haka może być ustawiona tylko globalnie.
.
Language=Romanian
ERROR_GLOBAL_ONLY_HOOK - This hook procedure can only be set globally.
.

MessageId=1430
Severity=Success
Facility=System
SymbolicName=ERROR_JOURNAL_HOOK_SET
Language=English
ERROR_JOURNAL_HOOK_SET - The journal hook procedure is already installed.
.
Language=Russian
ERROR_JOURNAL_HOOK_SET - The journal hook procedure is already installed.
.
Language=Polish
ERROR_JOURNAL_HOOK_SET - Procedura haka dziennika jest już zainstalowana.
.
Language=Romanian
ERROR_JOURNAL_HOOK_SET - The journal hook procedure is already installed.
.

MessageId=1431
Severity=Success
Facility=System
SymbolicName=ERROR_HOOK_NOT_INSTALLED
Language=English
ERROR_HOOK_NOT_INSTALLED - The hook procedure is not installed.
.
Language=Russian
ERROR_HOOK_NOT_INSTALLED - The hook procedure is not installed.
.
Language=Polish
ERROR_HOOK_NOT_INSTALLED - Procedura haka nie jest zainstalowana.
.
Language=Romanian
ERROR_HOOK_NOT_INSTALLED - The hook procedure is not installed.
.

MessageId=1432
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LB_MESSAGE
Language=English
ERROR_INVALID_LB_MESSAGE - Invalid message for single-selection list box.
.
Language=Russian
ERROR_INVALID_LB_MESSAGE - Invalid message for single-selection list box.
.
Language=Polish
ERROR_INVALID_LB_MESSAGE - Nieprawidłowy komunikat dla pola listy z pojedynczym wyborem.
.
Language=Romanian
ERROR_INVALID_LB_MESSAGE - Invalid message for single-selection list box.
.

MessageId=1433
Severity=Success
Facility=System
SymbolicName=ERROR_SETCOUNT_ON_BAD_LB
Language=English
ERROR_SETCOUNT_ON_BAD_LB - LB_SETCOUNT sent to non-lazy list box.
.
Language=Russian
ERROR_SETCOUNT_ON_BAD_LB - LB_SETCOUNT sent to non-lazy list box.
.
Language=Polish
ERROR_SETCOUNT_ON_BAD_LB - Polecenie LB_SETCOUNT przesłane do pola listy non-lazy.
.
Language=Romanian
ERROR_SETCOUNT_ON_BAD_LB - LB_SETCOUNT sent to non-lazy list box.
.

MessageId=1434
Severity=Success
Facility=System
SymbolicName=ERROR_LB_WITHOUT_TABSTOPS
Language=English
ERROR_LB_WITHOUT_TABSTOPS - This list box does not support tab stops.
.
Language=Russian
ERROR_LB_WITHOUT_TABSTOPS - This list box does not support tab stops.
.
Language=Polish
ERROR_LB_WITHOUT_TABSTOPS - To pole listy nie obsługuje tabulatorów.
.
Language=Romanian
ERROR_LB_WITHOUT_TABSTOPS - This list box does not support tab stops.
.

MessageId=1435
Severity=Success
Facility=System
SymbolicName=ERROR_DESTROY_OBJECT_OF_OTHER_THREAD
Language=English
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD - Cannot destroy object created by another thread.
.
Language=Russian
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD - Cannot destroy object created by another thread.
.
Language=Polish
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD - Nie można zniszczyć obiektu utworzonego przez inny wątek.
.
Language=Romanian
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD - Cannot destroy object created by another thread.
.

MessageId=1436
Severity=Success
Facility=System
SymbolicName=ERROR_CHILD_WINDOW_MENU
Language=English
ERROR_CHILD_WINDOW_MENU - Child windows cannot have menus.
.
Language=Russian
ERROR_CHILD_WINDOW_MENU - Child windows cannot have menus.
.
Language=Polish
ERROR_CHILD_WINDOW_MENU - Okna podrzędne nie mogą mieć menu.
.
Language=Romanian
ERROR_CHILD_WINDOW_MENU - Child windows cannot have menus.
.

MessageId=1437
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SYSTEM_MENU
Language=English
ERROR_NO_SYSTEM_MENU - The window does not have a system menu.
.
Language=Russian
ERROR_NO_SYSTEM_MENU - The window does not have a system menu.
.
Language=Polish
ERROR_NO_SYSTEM_MENU - Okno nie ma menu systemowego.
.
Language=Romanian
ERROR_NO_SYSTEM_MENU - The window does not have a system menu.
.

MessageId=1438
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MSGBOX_STYLE
Language=English
ERROR_INVALID_MSGBOX_STYLE - Invalid message box style.
.
Language=Russian
ERROR_INVALID_MSGBOX_STYLE - Invalid message box style.
.
Language=Polish
ERROR_INVALID_MSGBOX_STYLE - Nieprawidłowy styl okna komunikatu.
.
Language=Romanian
ERROR_INVALID_MSGBOX_STYLE - Invalid message box style.
.

MessageId=1439
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SPI_VALUE
Language=English
ERROR_INVALID_SPI_VALUE - Invalid system-wide (SPI_*) parameter.
.
Language=Russian
ERROR_INVALID_SPI_VALUE - Invalid system-wide (SPI_*) parameter.
.
Language=Polish
ERROR_INVALID_SPI_VALUE - Nieprawidłowy parametr systemowy (SPI_*).
.
Language=Romanian
ERROR_INVALID_SPI_VALUE - Invalid system-wide (SPI_*) parameter.
.

MessageId=1440
Severity=Success
Facility=System
SymbolicName=ERROR_SCREEN_ALREADY_LOCKED
Language=English
ERROR_SCREEN_ALREADY_LOCKED - Screen already locked.
.
Language=Russian
ERROR_SCREEN_ALREADY_LOCKED - Screen already locked.
.
Language=Polish
ERROR_SCREEN_ALREADY_LOCKED - Ekran jest już zablokowany.
.
Language=Romanian
ERROR_SCREEN_ALREADY_LOCKED - Screen already locked.
.

MessageId=1441
Severity=Success
Facility=System
SymbolicName=ERROR_HWNDS_HAVE_DIFF_PARENT
Language=English
ERROR_HWNDS_HAVE_DIFF_PARENT - All handles to windows in a multiple-window position structure must have the same parent.
.
Language=Russian
ERROR_HWNDS_HAVE_DIFF_PARENT - All handles to windows in a multiple-window position structure must have the same parent.
.
Language=Polish
ERROR_HWNDS_HAVE_DIFF_PARENT - Wszystkie dojścia okien w strukturze o wielu pozycjach okien muszą mieć to samo okno nadrzędne.
.
Language=Romanian
ERROR_HWNDS_HAVE_DIFF_PARENT - All handles to windows in a multiple-window position structure must have the same parent.
.

MessageId=1442
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_CHILD_WINDOW
Language=English
ERROR_NOT_CHILD_WINDOW - The window is not a child window.
.
Language=Russian
ERROR_NOT_CHILD_WINDOW - The window is not a child window.
.
Language=Polish
ERROR_NOT_CHILD_WINDOW - Okno nie jest oknem podrzędnym.
.
Language=Romanian
ERROR_NOT_CHILD_WINDOW - The window is not a child window.
.

MessageId=1443
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_GW_COMMAND
Language=English
ERROR_INVALID_GW_COMMAND - Invalid GW_* command.
.
Language=Russian
ERROR_INVALID_GW_COMMAND - Invalid GW_* command.
.
Language=Polish
ERROR_INVALID_GW_COMMAND - Nieprawidłowe polecenie GW_* .
.
Language=Romanian
ERROR_INVALID_GW_COMMAND - Invalid GW_* command.
.

MessageId=1444
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_THREAD_ID
Language=English
ERROR_INVALID_THREAD_ID - Invalid thread identifier.
.
Language=Russian
ERROR_INVALID_THREAD_ID - Invalid thread identifier.
.
Language=Polish
ERROR_INVALID_THREAD_ID - Nieprawidłowy identyfikator wątku.
.
Language=Romanian
ERROR_INVALID_THREAD_ID - Invalid thread identifier.
.

MessageId=1445
Severity=Success
Facility=System
SymbolicName=ERROR_NON_MDICHILD_WINDOW
Language=English
ERROR_NON_MDICHILD_WINDOW - Cannot process a message from a window that is not a multiple document interface (MDI) window.
.
Language=Russian
ERROR_NON_MDICHILD_WINDOW - Cannot process a message from a window that is not a multiple document interface (MDI) window.
.
Language=Polish
ERROR_NON_MDICHILD_WINDOW - Nie można przetworzyć komunikatu z okna, które nie jest oknem interfejsu dokumentu wielokrotnego (MDI).
.
Language=Romanian
ERROR_NON_MDICHILD_WINDOW - Cannot process a message from a window that is not a multiple document interface (MDI) window.
.

MessageId=1446
Severity=Success
Facility=System
SymbolicName=ERROR_POPUP_ALREADY_ACTIVE
Language=English
ERROR_POPUP_ALREADY_ACTIVE - Popup menu already active.
.
Language=Russian
ERROR_POPUP_ALREADY_ACTIVE - Popup menu already active.
.
Language=Polish
ERROR_POPUP_ALREADY_ACTIVE - Menu podręczne jest już aktywne.
.
Language=Romanian
ERROR_POPUP_ALREADY_ACTIVE - Popup menu already active.
.

MessageId=1447
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SCROLLBARS
Language=English
ERROR_NO_SCROLLBARS - The window does not have scroll bars.
.
Language=Russian
ERROR_NO_SCROLLBARS - The window does not have scroll bars.
.
Language=Polish
ERROR_NO_SCROLLBARS - Okno nie ma pasków przewijania.
.
Language=Romanian
ERROR_NO_SCROLLBARS - The window does not have scroll bars.
.

MessageId=1448
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SCROLLBAR_RANGE
Language=English
ERROR_INVALID_SCROLLBAR_RANGE - Scroll bar range cannot be greater than MAXLONG.
.
Language=Russian
ERROR_INVALID_SCROLLBAR_RANGE - Scroll bar range cannot be greater than MAXLONG.
.
Language=Polish
ERROR_INVALID_SCROLLBAR_RANGE - Zakres paska przewijania nie może być większy niż wartość MAXLONG.
.
Language=Romanian
ERROR_INVALID_SCROLLBAR_RANGE - Scroll bar range cannot be greater than MAXLONG.
.

MessageId=1449
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SHOWWIN_COMMAND
Language=English
ERROR_INVALID_SHOWWIN_COMMAND - Cannot show or remove the window in the way specified.
.
Language=Russian
ERROR_INVALID_SHOWWIN_COMMAND - Cannot show or remove the window in the way specified.
.
Language=Polish
ERROR_INVALID_SHOWWIN_COMMAND - Nie można wyświetić ani usunąć okna określoną metodą.
.
Language=Romanian
ERROR_INVALID_SHOWWIN_COMMAND - Cannot show or remove the window in the way specified.
.

MessageId=1450
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SYSTEM_RESOURCES
Language=English
ERROR_NO_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Russian
ERROR_NO_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Polish
ERROR_NO_SYSTEM_RESOURCES - Zasoby systemowe nie wystarczają do ukończenia żądanej usługi.
.
Language=Romanian
ERROR_NO_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.

MessageId=1451
Severity=Success
Facility=System
SymbolicName=ERROR_NONPAGED_SYSTEM_RESOURCES
Language=English
ERROR_NONPAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Russian
ERROR_NONPAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Polish
ERROR_NONPAGED_SYSTEM_RESOURCES - Zasoby systemowe nie wystarczają do ukończenia żądanej usługi.
.
Language=Romanian
ERROR_NONPAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.

MessageId=1452
Severity=Success
Facility=System
SymbolicName=ERROR_PAGED_SYSTEM_RESOURCES
Language=English
ERROR_PAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Russian
ERROR_PAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.
Language=Polish
ERROR_PAGED_SYSTEM_RESOURCES - Zasoby systemowe nie wystarczają do ukończenia żądanej usługi.
.
Language=Romanian
ERROR_PAGED_SYSTEM_RESOURCES - Insufficient system resources exist to complete the requested service.
.

MessageId=1453
Severity=Success
Facility=System
SymbolicName=ERROR_WORKING_SET_QUOTA
Language=English
ERROR_WORKING_SET_QUOTA - Insufficient quota to complete the requested service.
.
Language=Russian
ERROR_WORKING_SET_QUOTA - Insufficient quota to complete the requested service.
.
Language=Polish
ERROR_WORKING_SET_QUOTA - Przydział jest niewystarczający do ukończenia żądanej usługi.
.
Language=Romanian
ERROR_WORKING_SET_QUOTA - Insufficient quota to complete the requested service.
.

MessageId=1454
Severity=Success
Facility=System
SymbolicName=ERROR_PAGEFILE_QUOTA
Language=English
ERROR_PAGEFILE_QUOTA - Insufficient quota to complete the requested service.
.
Language=Russian
ERROR_PAGEFILE_QUOTA - Insufficient quota to complete the requested service.
.
Language=Polish
ERROR_PAGEFILE_QUOTA - Przydział jest niewystarczający do ukończenia żądanej usługi.
.
Language=Romanian
ERROR_PAGEFILE_QUOTA - Insufficient quota to complete the requested service.
.

MessageId=1455
Severity=Success
Facility=System
SymbolicName=ERROR_COMMITMENT_LIMIT
Language=English
ERROR_COMMITMENT_LIMIT - The paging file is too small for this operation to complete.
.
Language=Russian
ERROR_COMMITMENT_LIMIT - The paging file is too small for this operation to complete.
.
Language=Polish
ERROR_COMMITMENT_LIMIT - Plik stronicowania jest za mały do ukończenia tej operacji.
.
Language=Romanian
ERROR_COMMITMENT_LIMIT - The paging file is too small for this operation to complete.
.

MessageId=1456
Severity=Success
Facility=System
SymbolicName=ERROR_MENU_ITEM_NOT_FOUND
Language=English
ERROR_MENU_ITEM_NOT_FOUND - A menu item was not found.
.
Language=Russian
ERROR_MENU_ITEM_NOT_FOUND - A menu item was not found.
.
Language=Polish
ERROR_MENU_ITEM_NOT_FOUND - Nie odnaleziono elementu menu.
.
Language=Romanian
ERROR_MENU_ITEM_NOT_FOUND - A menu item was not found.
.

MessageId=1457
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_KEYBOARD_HANDLE
Language=English
ERROR_INVALID_KEYBOARD_HANDLE - Invalid keyboard layout handle.
.
Language=Russian
ERROR_INVALID_KEYBOARD_HANDLE - Invalid keyboard layout handle.
.
Language=Polish
ERROR_INVALID_KEYBOARD_HANDLE - Nieprawidłowe dojście układu klawiatury.
.
Language=Romanian
ERROR_INVALID_KEYBOARD_HANDLE - Invalid keyboard layout handle.
.

MessageId=1458
Severity=Success
Facility=System
SymbolicName=ERROR_HOOK_TYPE_NOT_ALLOWED
Language=English
ERROR_HOOK_TYPE_NOT_ALLOWED - Hook type not allowed.
.
Language=Russian
ERROR_HOOK_TYPE_NOT_ALLOWED - Hook type not allowed.
.
Language=Polish
ERROR_HOOK_TYPE_NOT_ALLOWED - Niedozwolony typ haka.
.
Language=Romanian
ERROR_HOOK_TYPE_NOT_ALLOWED - Hook type not allowed.
.

MessageId=1459
Severity=Success
Facility=System
SymbolicName=ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION
Language=English
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION - This operation requires an interactive window station.
.
Language=Russian
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION - This operation requires an interactive window station.
.
Language=Polish
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION - Ta operacja wymaga interakcyjnej stacji z systemem Windows.
.
Language=Romanian
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION - This operation requires an interactive window station.
.

MessageId=1460
Severity=Success
Facility=System
SymbolicName=ERROR_TIMEOUT
Language=English
ERROR_TIMEOUT - This operation returned because the timeout period expired.
.
Language=Russian
ERROR_TIMEOUT - This operation returned because the timeout period expired.
.
Language=Polish
ERROR_TIMEOUT - Operacja została zwrócona, ponieważ przekroczono limit czasu.
.
Language=Romanian
ERROR_TIMEOUT - This operation returned because the timeout period expired.
.

MessageId=1461
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MONITOR_HANDLE
Language=English
ERROR_INVALID_MONITOR_HANDLE - Invalid monitor handle.
.
Language=Russian
ERROR_INVALID_MONITOR_HANDLE - Invalid monitor handle.
.
Language=Polish
ERROR_INVALID_MONITOR_HANDLE - Nieprawidłowe dojście do monitora.
.
Language=Romanian
ERROR_INVALID_MONITOR_HANDLE - Invalid monitor handle.
.

MessageId=1500
Severity=Success
Facility=System
SymbolicName=ERROR_EVENTLOG_FILE_CORRUPT
Language=English
ERROR_EVENTLOG_FILE_CORRUPT - The event log file is corrupted.
.
Language=Russian
ERROR_EVENTLOG_FILE_CORRUPT - The event log file is corrupted.
.
Language=Polish
ERROR_EVENTLOG_FILE_CORRUPT - Plik dziennika zdarzeń jest uszkodzony.
.
Language=Romanian
ERROR_EVENTLOG_FILE_CORRUPT - The event log file is corrupted.
.

MessageId=1501
Severity=Success
Facility=System
SymbolicName=ERROR_EVENTLOG_CANT_START
Language=English
ERROR_EVENTLOG_CANT_START - No event log file could be opened, so the event logging service did not start.
.
Language=Russian
ERROR_EVENTLOG_CANT_START - No event log file could be opened, so the event logging service did not start.
.
Language=Polish
ERROR_EVENTLOG_CANT_START - Nie można uruchomić usługi rejestrowania zdarzeń, ponieważ nie można otworzyć pliku dziennika zdarzeń.
.
Language=Romanian
ERROR_EVENTLOG_CANT_START - No event log file could be opened, so the event logging service did not start.
.

MessageId=1502
Severity=Success
Facility=System
SymbolicName=ERROR_LOG_FILE_FULL
Language=English
ERROR_LOG_FILE_FULL - The event log file is full.
.
Language=Russian
ERROR_LOG_FILE_FULL - The event log file is full.
.
Language=Polish
ERROR_LOG_FILE_FULL - Plik dziennika zdarzeń jest zapełniony.
.
Language=Romanian
ERROR_LOG_FILE_FULL - The event log file is full.
.

MessageId=1503
Severity=Success
Facility=System
SymbolicName=ERROR_EVENTLOG_FILE_CHANGED
Language=English
ERROR_EVENTLOG_FILE_CHANGED - The event log file has changed between read operations.
.
Language=Russian
ERROR_EVENTLOG_FILE_CHANGED - The event log file has changed between read operations.
.
Language=Polish
ERROR_EVENTLOG_FILE_CHANGED - Plik dziennika zdarzeń zmienił się między operacjami odczytu.
.
Language=Romanian
ERROR_EVENTLOG_FILE_CHANGED - The event log file has changed between read operations.
.

MessageId=1601
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_SERVICE_FAILURE
Language=English
ERROR_INSTALL_SERVICE_FAILURE - The Windows Installer service could not be accessed. This can occur if you are running Windows in safe mode, or if the Windows Installer is not correctly installed. Contact your support personnel for assistance.
.
Language=Russian
ERROR_INSTALL_SERVICE_FAILURE - The Windows Installer service could not be accessed. This can occur if you are running Windows in safe mode, or if the Windows Installer is not correctly installed. Contact your support personnel for assistance.
.
Language=Polish
ERROR_INSTALL_SERVICE_FAILURE - Nie można uzyskać dostępu do usługi Instalator Windows. Może mieć to miejsce, jeśli system Windows jest uruchomiony w trybie awaryjnym lub Instalator Windows jest niepoprawnie zainstalowany. Skontaktuj się z pomocą techniczną, aby uzyskać pomoc.
.
Language=Romanian
ERROR_INSTALL_SERVICE_FAILURE - The Windows Installer service could not be accessed. This can occur if you are running Windows in safe mode, or if the Windows Installer is not correctly installed. Contact your support personnel for assistance.
.

MessageId=1602
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_USEREXIT
Language=English
ERROR_INSTALL_USEREXIT - User cancelled installation.
.
Language=Russian
ERROR_INSTALL_USEREXIT - User cancelled installation.
.
Language=Polish
ERROR_INSTALL_USEREXIT - Użytkownik anulował instalację.
.
Language=Romanian
ERROR_INSTALL_USEREXIT - User cancelled installation.
.

MessageId=1603
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_FAILURE
Language=English
ERROR_INSTALL_FAILURE - Fatal error during installation.
.
Language=Russian
ERROR_INSTALL_FAILURE - Fatal error during installation.
.
Language=Polish
ERROR_INSTALL_FAILURE - Błąd krytyczny podczas instalacji.
.
Language=Romanian
ERROR_INSTALL_FAILURE - Fatal error during installation.
.

MessageId=1604
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_SUSPEND
Language=English
ERROR_INSTALL_SUSPEND - Installation suspended, incomplete.
.
Language=Russian
ERROR_INSTALL_SUSPEND - Installation suspended, incomplete.
.
Language=Polish
ERROR_INSTALL_SUSPEND - Instalacja wstrzymana, nieukończona.
.
Language=Romanian
ERROR_INSTALL_SUSPEND - Installation suspended, incomplete.
.

MessageId=1605
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PRODUCT
Language=English
ERROR_UNKNOWN_PRODUCT - This action is only valid for products that are currently installed.
.
Language=Russian
ERROR_UNKNOWN_PRODUCT - This action is only valid for products that are currently installed.
.
Language=Polish
ERROR_UNKNOWN_PRODUCT - Akcja ta jest prawidłowa tylko w odniesieniu do produktów, które są obecnie zainstalowane.
.
Language=Romanian
ERROR_UNKNOWN_PRODUCT - This action is only valid for products that are currently installed.
.

MessageId=1606
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_FEATURE
Language=English
ERROR_UNKNOWN_FEATURE - Feature ID not registered.
.
Language=Russian
ERROR_UNKNOWN_FEATURE - Feature ID not registered.
.
Language=Polish
ERROR_UNKNOWN_FEATURE - Niezarejestrowany identyfikator cechy.
.
Language=Romanian
ERROR_UNKNOWN_FEATURE - Feature ID not registered.
.

MessageId=1607
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_COMPONENT
Language=English
ERROR_UNKNOWN_COMPONENT - Component ID not registered.
.
Language=Russian
ERROR_UNKNOWN_COMPONENT - Component ID not registered.
.
Language=Polish
ERROR_UNKNOWN_COMPONENT - Niezarejestrowany identyfikator składnika.
.
Language=Romanian
ERROR_UNKNOWN_COMPONENT - Component ID not registered.
.

MessageId=1608
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PROPERTY
Language=English
ERROR_UNKNOWN_PROPERTY - Unknown property.
.
Language=Russian
ERROR_UNKNOWN_PROPERTY - Unknown property.
.
Language=Polish
ERROR_UNKNOWN_PROPERTY - Nieznana właściwość.
.
Language=Romanian
ERROR_UNKNOWN_PROPERTY - Unknown property.
.

MessageId=1609
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_HANDLE_STATE
Language=English
ERROR_INVALID_HANDLE_STATE - Handle is in an invalid state.
.
Language=Russian
ERROR_INVALID_HANDLE_STATE - Handle is in an invalid state.
.
Language=Polish
ERROR_INVALID_HANDLE_STATE - Nieprawidłowy stan dojścia.
.
Language=Romanian
ERROR_INVALID_HANDLE_STATE - Handle is in an invalid state.
.

MessageId=1610
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_CONFIGURATION
Language=English
ERROR_BAD_CONFIGURATION - The configuration data for this product is corrupt. Contact your support personnel.
.
Language=Russian
ERROR_BAD_CONFIGURATION - The configuration data for this product is corrupt. Contact your support personnel.
.
Language=Polish
ERROR_BAD_CONFIGURATION - Dane konfiguracyjne tego produktu są uszkodzone. Skontaktuj się z działem Pomocy technicznej.
.
Language=Romanian
ERROR_BAD_CONFIGURATION - The configuration data for this product is corrupt. Contact your support personnel.
.

MessageId=1611
Severity=Success
Facility=System
SymbolicName=ERROR_INDEX_ABSENT
Language=English
ERROR_INDEX_ABSENT - Component qualifier not present.
.
Language=Russian
ERROR_INDEX_ABSENT - Component qualifier not present.
.
Language=Polish
ERROR_INDEX_ABSENT - Brak kwalifikatora składnika.
.
Language=Romanian
ERROR_INDEX_ABSENT - Component qualifier not present.
.

MessageId=1612
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_SOURCE_ABSENT
Language=English
ERROR_INSTALL_SOURCE_ABSENT - The installation source for this product is not available. Verify that the source exists and that you can access it.
.
Language=Russian
ERROR_INSTALL_SOURCE_ABSENT - The installation source for this product is not available. Verify that the source exists and that you can access it.
.
Language=Polish
ERROR_INSTALL_SOURCE_ABSENT - Źródło instalacji dla tego produktu nie jest dostępne. Sprawdź, czy źródło istnieje i czy możesz uzyskać do niego dostęp.
.
Language=Romanian
ERROR_INSTALL_SOURCE_ABSENT - The installation source for this product is not available. Verify that the source exists and that you can access it.
.

MessageId=1613
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_PACKAGE_VERSION
Language=English
ERROR_INSTALL_PACKAGE_VERSION - This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.
Language=Russian
ERROR_INSTALL_PACKAGE_VERSION - This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.
Language=Polish
ERROR_INSTALL_PACKAGE_VERSION - Usługa Instalator Windows nie może zainstalować tego pakietu instalacyjnego. Musisz zainstalować dodatek Windows Service Pack, zawierający nowszą wersję usługi Instalator Windows.
.
Language=Romanian
ERROR_INSTALL_PACKAGE_VERSION - This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.

MessageId=1614
Severity=Success
Facility=System
SymbolicName=ERROR_PRODUCT_UNINSTALLED
Language=English
ERROR_PRODUCT_UNINSTALLED - Product is uninstalled.
.
Language=Russian
ERROR_PRODUCT_UNINSTALLED - Product is uninstalled.
.
Language=Polish
ERROR_PRODUCT_UNINSTALLED - Produkt jest odinstalowany.
.
Language=Romanian
ERROR_PRODUCT_UNINSTALLED - Product is uninstalled.
.

MessageId=1615
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_QUERY_SYNTAX
Language=English
ERROR_BAD_QUERY_SYNTAX - SQL query syntax invalid or unsupported.
.
Language=Russian
ERROR_BAD_QUERY_SYNTAX - SQL query syntax invalid or unsupported.
.
Language=Polish
ERROR_BAD_QUERY_SYNTAX - Nieprawidłowa lub nieobsługiwana składnia zapytania SQL.
.
Language=Romanian
ERROR_BAD_QUERY_SYNTAX - SQL query syntax invalid or unsupported.
.

MessageId=1616
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FIELD
Language=English
ERROR_INVALID_FIELD - Record field does not exist.
.
Language=Russian
ERROR_INVALID_FIELD - Record field does not exist.
.
Language=Polish
ERROR_INVALID_FIELD - Pole rekordu nie istnieje.
.
Language=Romanian
ERROR_INVALID_FIELD - Record field does not exist.
.

MessageId=1617
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_REMOVED
Language=English
ERROR_DEVICE_REMOVED - The device has been removed.
.
Language=Russian
ERROR_DEVICE_REMOVED - The device has been removed.
.
Language=Polish
ERROR_DEVICE_REMOVED - Urządzenie zostało usunięte.
.
Language=Romanian
ERROR_DEVICE_REMOVED - The device has been removed.
.

MessageId=1618
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_ALREADY_RUNNING
Language=English
ERROR_INSTALL_ALREADY_RUNNING - Another installation is already in progress. Complete that installation before proceeding with this install.
.
Language=Russian
ERROR_INSTALL_ALREADY_RUNNING - Another installation is already in progress. Complete that installation before proceeding with this install.
.
Language=Polish
ERROR_INSTALL_ALREADY_RUNNING - Trwa inna instalacja. Ukończ ją, zanim zaczniesz kontynuować bieżącą.
.
Language=Romanian
ERROR_INSTALL_ALREADY_RUNNING - Another installation is already in progress. Complete that installation before proceeding with this install.
.

MessageId=1619
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_PACKAGE_OPEN_FAILED
Language=English
ERROR_INSTALL_PACKAGE_OPEN_FAILED - This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package.
.
Language=Russian
ERROR_INSTALL_PACKAGE_OPEN_FAILED - This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package.
.
Language=Polish
ERROR_INSTALL_PACKAGE_OPEN_FAILED - Nie można otworzyć tego pakietu instalacyjnego. Sprawdź, czy ten pakiet istnieje i czy masz do niego dostęp, albo skontaktuj się z dostawcą aplikacji w celu sprawdzenia, czy jest to prawidłowy pakiet Instalatora Windows.
.
Language=Romanian
ERROR_INSTALL_PACKAGE_OPEN_FAILED - This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package.
.

MessageId=1620
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_PACKAGE_INVALID
Language=English
ERROR_INSTALL_PACKAGE_INVALID - This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package.
.
Language=Russian
ERROR_INSTALL_PACKAGE_INVALID - This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package.
.
Language=Polish
ERROR_INSTALL_PACKAGE_INVALID - Nie można otworzyć tego pakietu instalacyjnego. Skontaktuj się z dostawcą aplikacji w celu sprawdzenia, czy jest to prawidłowy pakiet poprawek Instalatora Windows.
.
Language=Romanian
ERROR_INSTALL_PACKAGE_INVALID - This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package.
.

MessageId=1621
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_UI_FAILURE
Language=English
ERROR_INSTALL_UI_FAILURE - There was an error starting the Windows Installer service user interface. Contact your support personnel.
.
Language=Russian
ERROR_INSTALL_UI_FAILURE - There was an error starting the Windows Installer service user interface. Contact your support personnel.
.
Language=Polish
ERROR_INSTALL_UI_FAILURE - Podczas uruchamiania interfejsu użytkownika usługi Instalator Windows wystąpił błąd. Skontaktuj się z personelem technicznym.
.
Language=Romanian
ERROR_INSTALL_UI_FAILURE - There was an error starting the Windows Installer service user interface. Contact your support personnel.
.

MessageId=1622
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_LOG_FAILURE
Language=English
ERROR_INSTALL_LOG_FAILURE - Error opening installation log file. Verify that the specified log file location exists and that you can write to it.
.
Language=Russian
ERROR_INSTALL_LOG_FAILURE - Error opening installation log file. Verify that the specified log file location exists and that you can write to it.
.
Language=Polish
ERROR_INSTALL_LOG_FAILURE - Błąd podczas otwierania pliku dziennika instalacji. Sprawdź, czy istnieje określona lokalizacja pliku dziennika i czy można w niej zapisywać.
.
Language=Romanian
ERROR_INSTALL_LOG_FAILURE - Error opening installation log file. Verify that the specified log file location exists and that you can write to it.
.

MessageId=1623
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_LANGUAGE_UNSUPPORTED
Language=English
ERROR_INSTALL_LANGUAGE_UNSUPPORTED - The language of this installation package is not supported by your system.
.
Language=Russian
ERROR_INSTALL_LANGUAGE_UNSUPPORTED - The language of this installation package is not supported by your system.
.
Language=Polish
ERROR_INSTALL_LANGUAGE_UNSUPPORTED - Język stosowany w tym pakiecie instalacyjnym nie jest obsługiwany przez system.
.
Language=Romanian
ERROR_INSTALL_LANGUAGE_UNSUPPORTED - The language of this installation package is not supported by your system.
.

MessageId=1624
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_TRANSFORM_FAILURE
Language=English
ERROR_INSTALL_TRANSFORM_FAILURE - Error applying transforms. Verify that the specified transform paths are valid.
.
Language=Russian
ERROR_INSTALL_TRANSFORM_FAILURE - Error applying transforms. Verify that the specified transform paths are valid.
.
Language=Polish
ERROR_INSTALL_TRANSFORM_FAILURE - Błąd podczas przeprowadzania transformacji. Sprawdź, czy podane ścieżki transformacji są prawidłowe.
.
Language=Romanian
ERROR_INSTALL_TRANSFORM_FAILURE - Error applying transforms. Verify that the specified transform paths are valid.
.

MessageId=1625
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_PACKAGE_REJECTED
Language=English
ERROR_INSTALL_PACKAGE_REJECTED - This installation is forbidden by system policy. Contact your system administrator.
.
Language=Russian
ERROR_INSTALL_PACKAGE_REJECTED - This installation is forbidden by system policy. Contact your system administrator.
.
Language=Polish
ERROR_INSTALL_PACKAGE_REJECTED - Ta instalacja jest zabroniona przez zasady systemowe. Skontaktuj się z administratorem systemu.
.
Language=Romanian
ERROR_INSTALL_PACKAGE_REJECTED - This installation is forbidden by system policy. Contact your system administrator.
.

MessageId=1626
Severity=Success
Facility=System
SymbolicName=ERROR_FUNCTION_NOT_CALLED
Language=English
ERROR_FUNCTION_NOT_CALLED - Function could not be executed.
.
Language=Russian
ERROR_FUNCTION_NOT_CALLED - Function could not be executed.
.
Language=Polish
ERROR_FUNCTION_NOT_CALLED - Nie można wykonać funkcji.
.
Language=Romanian
ERROR_FUNCTION_NOT_CALLED - Function could not be executed.
.

MessageId=1627
Severity=Success
Facility=System
SymbolicName=ERROR_FUNCTION_FAILED
Language=English
ERROR_FUNCTION_FAILED - Function failed during execution.
.
Language=Russian
ERROR_FUNCTION_FAILED - Function failed during execution.
.
Language=Polish
ERROR_FUNCTION_FAILED - Niepowodzenie funkcji podczas jej wykonywania.
.
Language=Romanian
ERROR_FUNCTION_FAILED - Function failed during execution.
.

MessageId=1628
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_TABLE
Language=English
ERROR_INVALID_TABLE - Invalid or unknown table specified.
.
Language=Russian
ERROR_INVALID_TABLE - Invalid or unknown table specified.
.
Language=Polish
ERROR_INVALID_TABLE - Podano nieprawidłową lub nieznaną tabelę.
.
Language=Romanian
ERROR_INVALID_TABLE - Invalid or unknown table specified.
.

MessageId=1629
Severity=Success
Facility=System
SymbolicName=ERROR_DATATYPE_MISMATCH
Language=English
ERROR_DATATYPE_MISMATCH - Data supplied is of wrong type.
.
Language=Russian
ERROR_DATATYPE_MISMATCH - Data supplied is of wrong type.
.
Language=Polish
ERROR_DATATYPE_MISMATCH - Dostarczono dane nieprawidłowego typu.
.
Language=Romanian
ERROR_DATATYPE_MISMATCH - Data supplied is of wrong type.
.

MessageId=1630
Severity=Success
Facility=System
SymbolicName=ERROR_UNSUPPORTED_TYPE
Language=English
ERROR_UNSUPPORTED_TYPE - Data of this type is not supported.
.
Language=Russian
ERROR_UNSUPPORTED_TYPE - Data of this type is not supported.
.
Language=Polish
ERROR_UNSUPPORTED_TYPE - Dane tego typu nie są obsługiwane.
.
Language=Romanian
ERROR_UNSUPPORTED_TYPE - Data of this type is not supported.
.

MessageId=1631
Severity=Success
Facility=System
SymbolicName=ERROR_CREATE_FAILED
Language=English
ERROR_CREATE_FAILED - The Windows Installer service failed to start. Contact your support personnel.
.
Language=Russian
ERROR_CREATE_FAILED - The Windows Installer service failed to start. Contact your support personnel.
.
Language=Polish
ERROR_CREATE_FAILED - Nie można uruchomić usługi Instalator Windows. Skontaktuj się z działem Pomocy technicznej.
.
Language=Romanian
ERROR_CREATE_FAILED - The Windows Installer service failed to start. Contact your support personnel.
.

MessageId=1632
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_TEMP_UNWRITABLE
Language=English
ERROR_INSTALL_TEMP_UNWRITABLE - The Temp folder is on a drive that is full or inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder.
.
Language=Russian
ERROR_INSTALL_TEMP_UNWRITABLE - The Temp folder is on a drive that is full or inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder.
.
Language=Polish
ERROR_INSTALL_TEMP_UNWRITABLE - Folder Temp znajduje się na dysku, który jest albo zapełniony, albo niedostępny. Zwolnij miejsce na dysku lub zweryfikuj, że masz uprawnienia do zapisu w folderze Temp.
.
Language=Romanian
ERROR_INSTALL_TEMP_UNWRITABLE - The Temp folder is on a drive that is full or inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder.
.

MessageId=1633
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_PLATFORM_UNSUPPORTED
Language=English
ERROR_INSTALL_PLATFORM_UNSUPPORTED - This installation package is not supported by this processor type. Contact your product vendor.
.
Language=Russian
ERROR_INSTALL_PLATFORM_UNSUPPORTED - This installation package is not supported by this processor type. Contact your product vendor.
.
Language=Polish
ERROR_INSTALL_PLATFORM_UNSUPPORTED - Ten pakiet instalacyjny nie jest obsługiwany przez ten typ procesora. Skontaktuj się z dostawcą produktu.
.
Language=Romanian
ERROR_INSTALL_PLATFORM_UNSUPPORTED - This installation package is not supported by this processor type. Contact your product vendor.
.

MessageId=1634
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_NOTUSED
Language=English
ERROR_INSTALL_NOTUSED - Component not used on this computer.
.
Language=Russian
ERROR_INSTALL_NOTUSED - Component not used on this computer.
.
Language=Polish
ERROR_INSTALL_NOTUSED - Składnik nieużywany w tym komputerze.
.
Language=Romanian
ERROR_INSTALL_NOTUSED - Component not used on this computer.
.

MessageId=1635
Severity=Success
Facility=System
SymbolicName=ERROR_PATCH_PACKAGE_OPEN_FAILED
Language=English
ERROR_PATCH_PACKAGE_OPEN_FAILED - This patch package could not be opened. Verify that the patch package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer patch package.
.
Language=Russian
ERROR_PATCH_PACKAGE_OPEN_FAILED - This patch package could not be opened. Verify that the patch package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer patch package.
.
Language=Polish
ERROR_PATCH_PACKAGE_OPEN_FAILED - Nie można otworzyć tego pakietu aktualizacji. Sprawdź, czy ten pakiet istnieje i czy masz do niego dostęp, albo skontaktuj się z dostawcą aplikacji w celu sprawdzenia, czy jest to prawidłowy pakiet aktualizacji Instalatora Windows.
.
Language=Romanian
ERROR_PATCH_PACKAGE_OPEN_FAILED - This patch package could not be opened. Verify that the patch package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer patch package.
.

MessageId=1636
Severity=Success
Facility=System
SymbolicName=ERROR_PATCH_PACKAGE_INVALID
Language=English
ERROR_PATCH_PACKAGE_INVALID - This patch package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer patch package.
.
Language=Russian
ERROR_PATCH_PACKAGE_INVALID - This patch package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer patch package.
.
Language=Polish
ERROR_PATCH_PACKAGE_INVALID - Nie można otworzyć tego pakietu aktualizacji. Skontaktuj się z dostawcą aplikacji w celu sprawdzenia, czy jest to prawidłowy pakiet aktualizacji Instalatora Windows.
.
Language=Romanian
ERROR_PATCH_PACKAGE_INVALID - This patch package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer patch package.
.

MessageId=1637
Severity=Success
Facility=System
SymbolicName=ERROR_PATCH_PACKAGE_UNSUPPORTED
Language=English
ERROR_PATCH_PACKAGE_UNSUPPORTED - This patch package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.
Language=Russian
ERROR_PATCH_PACKAGE_UNSUPPORTED - This patch package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.
Language=Polish
ERROR_PATCH_PACKAGE_UNSUPPORTED - Usługa Instalator Windows nie może przetworzyć tego pakietu aktualizacji. Musisz zainstalować dodatek Windows Service Pack, zawierający nowszą wersję usługi Instalator Windows.
.
Language=Romanian
ERROR_PATCH_PACKAGE_UNSUPPORTED - This patch package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service.
.

MessageId=1638
Severity=Success
Facility=System
SymbolicName=ERROR_PRODUCT_VERSION
Language=English
ERROR_PRODUCT_VERSION - Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs on the Control Panel.
.
Language=Russian
ERROR_PRODUCT_VERSION - Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs on the Control Panel.
.
Language=Polish
ERROR_PRODUCT_VERSION - Inna wersja tego produktu jest już zainstalowana na tym komputerze. Nie można kontynuować instalowania tej wersji. Aby skonfigurować lub usunąć istniejącą wersję tego produktu, użyj aplikacji Dodaj/Usuń Programy z Panelu sterowania.
.
Language=Romanian
ERROR_PRODUCT_VERSION - Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs on the Control Panel.
.

MessageId=1639
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_COMMAND_LINE
Language=English
ERROR_INVALID_COMMAND_LINE - Invalid command line argument. Consult the Windows Installer SDK for detailed command line help.
.
Language=Russian
ERROR_INVALID_COMMAND_LINE - Invalid command line argument. Consult the Windows Installer SDK for detailed command line help.
.
Language=Polish
ERROR_INVALID_COMMAND_LINE - Nieprawidłowy argument wiersza polecenia. Szczegółowe informacje na temat wiersza polecenia można znaleźć w pakiecie SDK Instalatora Windows.
.
Language=Romanian
ERROR_INVALID_COMMAND_LINE - Invalid command line argument. Consult the Windows Installer SDK for detailed command line help.
.

MessageId=1640
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_REMOTE_DISALLOWED
Language=English
ERROR_INSTALL_REMOTE_DISALLOWED - Only administrators have permission to add, remove, or configure server software during a Terminal Services remote session. If you want to install or configure software on the server, contact your network administrator.
.
Language=Russian
ERROR_INSTALL_REMOTE_DISALLOWED - Only administrators have permission to add, remove, or configure server software during a Terminal Services remote session. If you want to install or configure software on the server, contact your network administrator.
.
Language=Polish
ERROR_INSTALL_REMOTE_DISALLOWED - Tylko administratorzy są uprawnieni do dodawania, usuwania lub konfigurowania oprogramowania serwera podczas zdalnych sesji usług Terminala. Jeśli chcesz zainstalować lub skonfigurować jakieś oprogramowanie na serwerze, musisz skontaktować się z administratorem sieci.
.
Language=Romanian
ERROR_INSTALL_REMOTE_DISALLOWED - Only administrators have permission to add, remove, or configure server software during a Terminal Services remote session. If you want to install or configure software on the server, contact your network administrator.
.

MessageId=1641
Severity=Success
Facility=System
SymbolicName=ERROR_SUCCESS_REBOOT_INITIATED
Language=English
ERROR_SUCCESS_REBOOT_INITIATED - The requested operation completed successfully. The system will be restarted so the changes can take effect.
.
Language=Russian
ERROR_SUCCESS_REBOOT_INITIATED - The requested operation completed successfully. The system will be restarted so the changes can take effect.
.
Language=Polish
ERROR_SUCCESS_REBOOT_INITIATED - Żądana operacja została pomyślnie ukończona. Aby zmiany zostały wprowadzone, nastąpi ponowne uruchomienie systemu.
.
Language=Romanian
ERROR_SUCCESS_REBOOT_INITIATED - The requested operation completed successfully. The system will be restarted so the changes can take effect.
.

MessageId=1642
Severity=Success
Facility=System
SymbolicName=ERROR_PATCH_TARGET_NOT_FOUND
Language=English
ERROR_PATCH_TARGET_NOT_FOUND - The upgrade patch cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade patch may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade patch.
.
Language=Russian
ERROR_PATCH_TARGET_NOT_FOUND - The upgrade patch cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade patch may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade patch.
.
Language=Polish
ERROR_PATCH_TARGET_NOT_FOUND - Uaktualnienia nie można zainstalować przez usługę Instalator Windows, ponieważ nie ma programu do uaktualnienia albo uaktualnienie jest przeznaczone do innej wersji tego programu. Sprawdź, czy program, który ma być uaktualniony, znajduje się na dysku i czy masz prawidłowe uaktualnienie.
.
Language=Romanian
ERROR_PATCH_TARGET_NOT_FOUND - The upgrade patch cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade patch may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade patch.
.

MessageId=1643
Severity=Success
Facility=System
SymbolicName=ERROR_PATCH_PACKAGE_REJECTED
Language=English
ERROR_PATCH_PACKAGE_REJECTED - The patch package is not permitted by software restriction policy.
.
Language=Russian
ERROR_PATCH_PACKAGE_REJECTED - The patch package is not permitted by software restriction policy.
.
Language=Polish
ERROR_PATCH_PACKAGE_REJECTED - Zasady ograniczeń oprogramowania nie zezwalają na dany pakiet aktualizacji.
.
Language=Romanian
ERROR_PATCH_PACKAGE_REJECTED - The patch package is not permitted by software restriction policy.
.

MessageId=1644
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_TRANSFORM_REJECTED
Language=English
ERROR_INSTALL_TRANSFORM_REJECTED - One or more customizations are not permitted by software restriction policy.
.
Language=Russian
ERROR_INSTALL_TRANSFORM_REJECTED - One or more customizations are not permitted by software restriction policy.
.
Language=Polish
ERROR_INSTALL_TRANSFORM_REJECTED - Zasady ograniczeń oprogramowania nie zezwalają na jedno lub kilka z dostosowań.
.
Language=Romanian
ERROR_INSTALL_TRANSFORM_REJECTED - One or more customizations are not permitted by software restriction policy.
.

MessageId=1645
Severity=Success
Facility=System
SymbolicName=ERROR_INSTALL_REMOTE_PROHIBITED
Language=English
ERROR_INSTALL_REMOTE_PROHIBITED - The Windows Installer does not permit installation from a Remote Desktop Connection.
.
Language=Russian
ERROR_INSTALL_REMOTE_PROHIBITED - The Windows Installer does not permit installation from a Remote Desktop Connection.
.
Language=Polish
ERROR_INSTALL_REMOTE_PROHIBITED - Instalator Windows nie zezwala na instalację przy użyciu podłączania pulpitu zdalnego.
.
Language=Romanian
ERROR_INSTALL_REMOTE_PROHIBITED - The Windows Installer does not permit installation from a Remote Desktop Connection.
.

MessageId=1700
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_STRING_BINDING
Language=English
RPC_S_INVALID_STRING_BINDING - The string binding is invalid.
.
Language=Russian
RPC_S_INVALID_STRING_BINDING - The string binding is invalid.
.
Language=Polish
RPC_S_INVALID_STRING_BINDING - Powiązanie ciągu jest nieprawidłowe.
.
Language=Romanian
RPC_S_INVALID_STRING_BINDING - The string binding is invalid.
.

MessageId=1701
Severity=Success
Facility=System
SymbolicName=RPC_S_WRONG_KIND_OF_BINDING
Language=English
RPC_S_WRONG_KIND_OF_BINDING - The binding handle is not the correct type.
.
Language=Russian
RPC_S_WRONG_KIND_OF_BINDING - The binding handle is not the correct type.
.
Language=Polish
RPC_S_WRONG_KIND_OF_BINDING - Dojście powiązania nie jest poprawnego typu.
.
Language=Romanian
RPC_S_WRONG_KIND_OF_BINDING - The binding handle is not the correct type.
.

MessageId=1702
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_BINDING
Language=English
RPC_S_INVALID_BINDING - The binding handle is invalid.
.
Language=Russian
RPC_S_INVALID_BINDING - The binding handle is invalid.
.
Language=Polish
RPC_S_INVALID_BINDING - Dojście powiązania jest nieprawidłowe.
.
Language=Romanian
RPC_S_INVALID_BINDING - The binding handle is invalid.
.

MessageId=1703
Severity=Success
Facility=System
SymbolicName=RPC_S_PROTSEQ_NOT_SUPPORTED
Language=English
RPC_S_PROTSEQ_NOT_SUPPORTED - The RPC protocol sequence is not supported.
.
Language=Russian
RPC_S_PROTSEQ_NOT_SUPPORTED - The RPC protocol sequence is not supported.
.
Language=Polish
RPC_S_PROTSEQ_NOT_SUPPORTED - Sekwencja protokołu RPC nie jest obsługiwana.
.
Language=Romanian
RPC_S_PROTSEQ_NOT_SUPPORTED - The RPC protocol sequence is not supported.
.

MessageId=1704
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_RPC_PROTSEQ
Language=English
RPC_S_INVALID_RPC_PROTSEQ - The RPC protocol sequence is invalid.
.
Language=Russian
RPC_S_INVALID_RPC_PROTSEQ - The RPC protocol sequence is invalid.
.
Language=Polish
RPC_S_INVALID_RPC_PROTSEQ - Sekwencja protokołu RPC jest nieprawidłowa.
.
Language=Romanian
RPC_S_INVALID_RPC_PROTSEQ - The RPC protocol sequence is invalid.
.

MessageId=1705
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_STRING_UUID
Language=English
RPC_S_INVALID_STRING_UUID - The string universal unique identifier (UUID) is invalid.
.
Language=Russian
RPC_S_INVALID_STRING_UUID - The string universal unique identifier (UUID) is invalid.
.
Language=Polish
RPC_S_INVALID_STRING_UUID - Uniwersalny, unikatowy identyfikator ciągu (UUID) jest nieprawidłowy.
.
Language=Romanian
RPC_S_INVALID_STRING_UUID - The string universal unique identifier (UUID) is invalid.
.

MessageId=1706
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_ENDPOINT_FORMAT
Language=English
RPC_S_INVALID_ENDPOINT_FORMAT - The endpoint format is invalid.
.
Language=Russian
RPC_S_INVALID_ENDPOINT_FORMAT - The endpoint format is invalid.
.
Language=Polish
RPC_S_INVALID_ENDPOINT_FORMAT - Format punktu końcowego jest nieprawidłowy.
.
Language=Romanian
RPC_S_INVALID_ENDPOINT_FORMAT - The endpoint format is invalid.
.

MessageId=1707
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_NET_ADDR
Language=English
RPC_S_INVALID_NET_ADDR - The network address is invalid.
.
Language=Russian
RPC_S_INVALID_NET_ADDR - The network address is invalid.
.
Language=Polish
RPC_S_INVALID_NET_ADDR - Adres sieciowy jest nieprawidłowy.
.
Language=Romanian
RPC_S_INVALID_NET_ADDR - The network address is invalid.
.

MessageId=1708
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_ENDPOINT_FOUND
Language=English
RPC_S_NO_ENDPOINT_FOUND - No endpoint was found.
.
Language=Russian
RPC_S_NO_ENDPOINT_FOUND - No endpoint was found.
.
Language=Polish
RPC_S_NO_ENDPOINT_FOUND - Nie odnaleziono punktu końcowego.
.
Language=Romanian
RPC_S_NO_ENDPOINT_FOUND - No endpoint was found.
.

MessageId=1709
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_TIMEOUT
Language=English
RPC_S_INVALID_TIMEOUT - The timeout value is invalid.
.
Language=Russian
RPC_S_INVALID_TIMEOUT - The timeout value is invalid.
.
Language=Polish
RPC_S_INVALID_TIMEOUT - Wartość limitu czasu jest nieprawidłowa.
.
Language=Romanian
RPC_S_INVALID_TIMEOUT - The timeout value is invalid.
.

MessageId=1710
Severity=Success
Facility=System
SymbolicName=RPC_S_OBJECT_NOT_FOUND
Language=English
RPC_S_OBJECT_NOT_FOUND - The object universal unique identifier (UUID) was not found.
.
Language=Russian
RPC_S_OBJECT_NOT_FOUND - The object universal unique identifier (UUID) was not found.
.
Language=Polish
RPC_S_OBJECT_NOT_FOUND - Uniwersalny, unikatowy identyfikator obiektu (UUID) nie został znaleziony.
.
Language=Romanian
RPC_S_OBJECT_NOT_FOUND - The object universal unique identifier (UUID) was not found.
.

MessageId=1711
Severity=Success
Facility=System
SymbolicName=RPC_S_ALREADY_REGISTERED
Language=English
RPC_S_ALREADY_REGISTERED - The object universal unique identifier (UUID) has already been registered.
.
Language=Russian
RPC_S_ALREADY_REGISTERED - The object universal unique identifier (UUID) has already been registered.
.
Language=Polish
RPC_S_ALREADY_REGISTERED - Uniwersalny, unikatowy identyfikator obiektu (UUID) został już zarejestrowany.
.
Language=Romanian
RPC_S_ALREADY_REGISTERED - The object universal unique identifier (UUID) has already been registered.
.

MessageId=1712
Severity=Success
Facility=System
SymbolicName=RPC_S_TYPE_ALREADY_REGISTERED
Language=English
RPC_S_TYPE_ALREADY_REGISTERED - The type universal unique identifier (UUID) has already been registered.
.
Language=Russian
RPC_S_TYPE_ALREADY_REGISTERED - The type universal unique identifier (UUID) has already been registered.
.
Language=Polish
RPC_S_TYPE_ALREADY_REGISTERED - Uniwersalny, unikatowy identyfikator typu (UUID) został już zarejestrowany.
.
Language=Romanian
RPC_S_TYPE_ALREADY_REGISTERED - The type universal unique identifier (UUID) has already been registered.
.

MessageId=1713
Severity=Success
Facility=System
SymbolicName=RPC_S_ALREADY_LISTENING
Language=English
RPC_S_ALREADY_LISTENING - The RPC server is already listening.
.
Language=Russian
RPC_S_ALREADY_LISTENING - The RPC server is already listening.
.
Language=Polish
RPC_S_ALREADY_LISTENING - Serwer RPC już nasłuchuje.
.
Language=Romanian
RPC_S_ALREADY_LISTENING - The RPC server is already listening.
.

MessageId=1714
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_PROTSEQS_REGISTERED
Language=English
RPC_S_NO_PROTSEQS_REGISTERED - No protocol sequences have been registered.
.
Language=Russian
RPC_S_NO_PROTSEQS_REGISTERED - No protocol sequences have been registered.
.
Language=Polish
RPC_S_NO_PROTSEQS_REGISTERED - Żadna sekwencja protokołu nie została zarejestrowana.
.
Language=Romanian
RPC_S_NO_PROTSEQS_REGISTERED - No protocol sequences have been registered.
.

MessageId=1715
Severity=Success
Facility=System
SymbolicName=RPC_S_NOT_LISTENING
Language=English
RPC_S_NOT_LISTENING - The RPC server is not listening.
.
Language=Russian
RPC_S_NOT_LISTENING - The RPC server is not listening.
.
Language=Polish
RPC_S_NOT_LISTENING - Serwer RPC nie nasłuchuje.
.
Language=Romanian
RPC_S_NOT_LISTENING - The RPC server is not listening.
.

MessageId=1716
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_MGR_TYPE
Language=English
RPC_S_UNKNOWN_MGR_TYPE - The manager type is unknown.
.
Language=Russian
RPC_S_UNKNOWN_MGR_TYPE - The manager type is unknown.
.
Language=Polish
RPC_S_UNKNOWN_MGR_TYPE - Typ menedżera jest nieznany.
.
Language=Romanian
RPC_S_UNKNOWN_MGR_TYPE - The manager type is unknown.
.

MessageId=1717
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_IF
Language=English
RPC_S_UNKNOWN_IF - The interface is unknown.
.
Language=Russian
RPC_S_UNKNOWN_IF - The interface is unknown.
.
Language=Polish
RPC_S_UNKNOWN_IF - Interfejs jest nieznany.
.
Language=Romanian
RPC_S_UNKNOWN_IF - The interface is unknown.
.

MessageId=1718
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_BINDINGS
Language=English
RPC_S_NO_BINDINGS - There are no bindings.
.
Language=Russian
RPC_S_NO_BINDINGS - There are no bindings.
.
Language=Polish
RPC_S_NO_BINDINGS - Nie ma powiązań.
.
Language=Romanian
RPC_S_NO_BINDINGS - There are no bindings.
.

MessageId=1719
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_PROTSEQS
Language=English
RPC_S_NO_PROTSEQS - There are no protocol sequences.
.
Language=Russian
RPC_S_NO_PROTSEQS - There are no protocol sequences.
.
Language=Polish
RPC_S_NO_PROTSEQS - Nie ma sekwencji protokołów.
.
Language=Romanian
RPC_S_NO_PROTSEQS - There are no protocol sequences.
.

MessageId=1720
Severity=Success
Facility=System
SymbolicName=RPC_S_CANT_CREATE_ENDPOINT
Language=English
RPC_S_CANT_CREATE_ENDPOINT - The endpoint cannot be created.
.
Language=Russian
RPC_S_CANT_CREATE_ENDPOINT - The endpoint cannot be created.
.
Language=Polish
RPC_S_CANT_CREATE_ENDPOINT - Nie można utworzyć punktu końcowego.
.
Language=Romanian
RPC_S_CANT_CREATE_ENDPOINT - The endpoint cannot be created.
.

MessageId=1721
Severity=Success
Facility=System
SymbolicName=RPC_S_OUT_OF_RESOURCES
Language=English
RPC_S_OUT_OF_RESOURCES - Not enough resources are available to complete this operation.
.
Language=Russian
RPC_S_OUT_OF_RESOURCES - Not enough resources are available to complete this operation.
.
Language=Polish
RPC_S_OUT_OF_RESOURCES - Za mało dostępnych zasobów do ukończenia tej operacji.
.
Language=Romanian
RPC_S_OUT_OF_RESOURCES - Not enough resources are available to complete this operation.
.

MessageId=1722
Severity=Success
Facility=System
SymbolicName=RPC_S_SERVER_UNAVAILABLE
Language=English
RPC_S_SERVER_UNAVAILABLE - The RPC server is unavailable.
.
Language=Russian
RPC_S_SERVER_UNAVAILABLE - The RPC server is unavailable.
.
Language=Polish
RPC_S_SERVER_UNAVAILABLE - Serwer RPC jest niedostępny.
.
Language=Romanian
RPC_S_SERVER_UNAVAILABLE - The RPC server is unavailable.
.

MessageId=1723
Severity=Success
Facility=System
SymbolicName=RPC_S_SERVER_TOO_BUSY
Language=English
RPC_S_SERVER_TOO_BUSY - The RPC server is too busy to complete this operation.
.
Language=Russian
RPC_S_SERVER_TOO_BUSY - The RPC server is too busy to complete this operation.
.
Language=Polish
RPC_S_SERVER_TOO_BUSY - Serwer RPC jest zbyt zajęty, aby ukończyć tę operację.
.
Language=Romanian
RPC_S_SERVER_TOO_BUSY - The RPC server is too busy to complete this operation.
.

MessageId=1724
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_NETWORK_OPTIONS
Language=English
RPC_S_INVALID_NETWORK_OPTIONS - The network options are invalid.
.
Language=Russian
RPC_S_INVALID_NETWORK_OPTIONS - The network options are invalid.
.
Language=Polish
RPC_S_INVALID_NETWORK_OPTIONS - Opcje sieciowe są nieprawidłowe.
.
Language=Romanian
RPC_S_INVALID_NETWORK_OPTIONS - The network options are invalid.
.

MessageId=1725
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_CALL_ACTIVE
Language=English
RPC_S_NO_CALL_ACTIVE - There are no remote procedure calls active on this thread.
.
Language=Russian
RPC_S_NO_CALL_ACTIVE - There are no remote procedure calls active on this thread.
.
Language=Polish
RPC_S_NO_CALL_ACTIVE - W tym wątku nie ma aktywnego żadnego zdalnego wywołania procedury.
.
Language=Romanian
RPC_S_NO_CALL_ACTIVE - There are no remote procedure calls active on this thread.
.

MessageId=1726
Severity=Success
Facility=System
SymbolicName=RPC_S_CALL_FAILED
Language=English
RPC_S_CALL_FAILED - The remote procedure call failed.
.
Language=Russian
RPC_S_CALL_FAILED - The remote procedure call failed.
.
Language=Polish
RPC_S_CALL_FAILED - Zdalne wywołanie procedury nie powiodło się.
.
Language=Romanian
RPC_S_CALL_FAILED - The remote procedure call failed.
.

MessageId=1727
Severity=Success
Facility=System
SymbolicName=RPC_S_CALL_FAILED_DNE
Language=English
RPC_S_CALL_FAILED_DNE - The remote procedure call failed and did not execute.
.
Language=Russian
RPC_S_CALL_FAILED_DNE - The remote procedure call failed and did not execute.
.
Language=Polish
RPC_S_CALL_FAILED_DNE - Zdalne wywołanie procedury nie powiodło się i nie zostało wykonane.
.
Language=Romanian
RPC_S_CALL_FAILED_DNE - The remote procedure call failed and did not execute.
.

MessageId=1728
Severity=Success
Facility=System
SymbolicName=RPC_S_PROTOCOL_ERROR
Language=English
RPC_S_PROTOCOL_ERROR - A remote procedure call (RPC) protocol error occurred.
.
Language=Russian
RPC_S_PROTOCOL_ERROR - A remote procedure call (RPC) protocol error occurred.
.
Language=Polish
RPC_S_PROTOCOL_ERROR - Wystąpił błąd protokołu zdalnego wywołania procedury (RPC).
.
Language=Romanian
RPC_S_PROTOCOL_ERROR - A remote procedure call (RPC) protocol error occurred.
.

MessageId=1730
Severity=Success
Facility=System
SymbolicName=RPC_S_UNSUPPORTED_TRANS_SYN
Language=English
RPC_S_UNSUPPORTED_TRANS_SYN - The transfer syntax is not supported by the RPC server.
.
Language=Russian
RPC_S_UNSUPPORTED_TRANS_SYN - The transfer syntax is not supported by the RPC server.
.
Language=Polish
RPC_S_UNSUPPORTED_TRANS_SYN - Składnia transferu nie jest obsługiwana przez serwer RPC.
.
Language=Romanian
RPC_S_UNSUPPORTED_TRANS_SYN - The transfer syntax is not supported by the RPC server.
.

MessageId=1732
Severity=Success
Facility=System
SymbolicName=RPC_S_UNSUPPORTED_TYPE
Language=English
RPC_S_UNSUPPORTED_TYPE - The universal unique identifier (UUID) type is not supported.
.
Language=Russian
RPC_S_UNSUPPORTED_TYPE - The universal unique identifier (UUID) type is not supported.
.
Language=Polish
RPC_S_UNSUPPORTED_TYPE - Typ uniwersalnego, unikatowego identyfikatora (UUID) nie jest obsługiwany.
.
Language=Romanian
RPC_S_UNSUPPORTED_TYPE - The universal unique identifier (UUID) type is not supported.
.

MessageId=1733
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_TAG
Language=English
RPC_S_INVALID_TAG - The tag is invalid.
.
Language=Russian
RPC_S_INVALID_TAG - The tag is invalid.
.
Language=Polish
RPC_S_INVALID_TAG - Tag jest nieprawidłowy.
.
Language=Romanian
RPC_S_INVALID_TAG - The tag is invalid.
.

MessageId=1734
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_BOUND
Language=English
RPC_S_INVALID_BOUND - The array bounds are invalid.
.
Language=Russian
RPC_S_INVALID_BOUND - The array bounds are invalid.
.
Language=Polish
RPC_S_INVALID_BOUND - Granice tablicy są nieprawidłowe.
.
Language=Romanian
RPC_S_INVALID_BOUND - The array bounds are invalid.
.

MessageId=1735
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_ENTRY_NAME
Language=English
RPC_S_NO_ENTRY_NAME - The binding does not contain an entry name.
.
Language=Russian
RPC_S_NO_ENTRY_NAME - The binding does not contain an entry name.
.
Language=Polish
RPC_S_NO_ENTRY_NAME - Powiązanie nie zawiera nazwy wpisu.
.
Language=Romanian
RPC_S_NO_ENTRY_NAME - The binding does not contain an entry name.
.

MessageId=1736
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_NAME_SYNTAX
Language=English
RPC_S_INVALID_NAME_SYNTAX - The name syntax is invalid.
.
Language=Russian
RPC_S_INVALID_NAME_SYNTAX - The name syntax is invalid.
.
Language=Polish
RPC_S_INVALID_NAME_SYNTAX - Składnia nazwy jest nieprawidłowa.
.
Language=Romanian
RPC_S_INVALID_NAME_SYNTAX - The name syntax is invalid.
.

MessageId=1737
Severity=Success
Facility=System
SymbolicName=RPC_S_UNSUPPORTED_NAME_SYNTAX
Language=English
RPC_S_UNSUPPORTED_NAME_SYNTAX - The name syntax is not supported.
.
Language=Russian
RPC_S_UNSUPPORTED_NAME_SYNTAX - The name syntax is not supported.
.
Language=Polish
RPC_S_UNSUPPORTED_NAME_SYNTAX - Składnia nazwy nie jest obsługiwana.
.
Language=Romanian
RPC_S_UNSUPPORTED_NAME_SYNTAX - The name syntax is not supported.
.

MessageId=1739
Severity=Success
Facility=System
SymbolicName=RPC_S_UUID_NO_ADDRESS
Language=English
RPC_S_UUID_NO_ADDRESS - No network address is available to use to construct a universal unique identifier (UUID).
.
Language=Russian
RPC_S_UUID_NO_ADDRESS - No network address is available to use to construct a universal unique identifier (UUID).
.
Language=Polish
RPC_S_UUID_NO_ADDRESS - Brak dostępnych adresów sieciowych do utworzenia uniwersalnego unikatowego identyfikatora (UUID).
.
Language=Romanian
RPC_S_UUID_NO_ADDRESS - No network address is available to use to construct a universal unique identifier (UUID).
.

MessageId=1740
Severity=Success
Facility=System
SymbolicName=RPC_S_DUPLICATE_ENDPOINT
Language=English
RPC_S_DUPLICATE_ENDPOINT - The endpoint is a duplicate.
.
Language=Russian
RPC_S_DUPLICATE_ENDPOINT - The endpoint is a duplicate.
.
Language=Polish
RPC_S_DUPLICATE_ENDPOINT - Punkt końcowy jest duplikatem.
.
Language=Romanian
RPC_S_DUPLICATE_ENDPOINT - The endpoint is a duplicate.
.

MessageId=1741
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_AUTHN_TYPE
Language=English
RPC_S_UNKNOWN_AUTHN_TYPE - The authentication type is unknown.
.
Language=Russian
RPC_S_UNKNOWN_AUTHN_TYPE - The authentication type is unknown.
.
Language=Polish
RPC_S_UNKNOWN_AUTHN_TYPE - Typ uwierzytelniania jest nieznany.
.
Language=Romanian
RPC_S_UNKNOWN_AUTHN_TYPE - The authentication type is unknown.
.

MessageId=1742
Severity=Success
Facility=System
SymbolicName=RPC_S_MAX_CALLS_TOO_SMALL
Language=English
RPC_S_MAX_CALLS_TOO_SMALL - The maximum number of calls is too small.
.
Language=Russian
RPC_S_MAX_CALLS_TOO_SMALL - The maximum number of calls is too small.
.
Language=Polish
RPC_S_MAX_CALLS_TOO_SMALL - Maksymalna liczba wywołań jest za mała.
.
Language=Romanian
RPC_S_MAX_CALLS_TOO_SMALL - The maximum number of calls is too small.
.

MessageId=1743
Severity=Success
Facility=System
SymbolicName=RPC_S_STRING_TOO_LONG
Language=English
RPC_S_STRING_TOO_LONG - The string is too long.
.
Language=Russian
RPC_S_STRING_TOO_LONG - The string is too long.
.
Language=Polish
RPC_S_STRING_TOO_LONG - Ciąg jest za długi.
.
Language=Romanian
RPC_S_STRING_TOO_LONG - The string is too long.
.

MessageId=1744
Severity=Success
Facility=System
SymbolicName=RPC_S_PROTSEQ_NOT_FOUND
Language=English
RPC_S_PROTSEQ_NOT_FOUND - The RPC protocol sequence was not found.
.
Language=Russian
RPC_S_PROTSEQ_NOT_FOUND - The RPC protocol sequence was not found.
.
Language=Polish
RPC_S_PROTSEQ_NOT_FOUND - Nie odnaleziono sekwencji protokołu RPC.
.
Language=Romanian
RPC_S_PROTSEQ_NOT_FOUND - The RPC protocol sequence was not found.
.

MessageId=1745
Severity=Success
Facility=System
SymbolicName=RPC_S_PROCNUM_OUT_OF_RANGE
Language=English
RPC_S_PROCNUM_OUT_OF_RANGE - The procedure number is out of range.
.
Language=Russian
RPC_S_PROCNUM_OUT_OF_RANGE - The procedure number is out of range.
.
Language=Polish
RPC_S_PROCNUM_OUT_OF_RANGE - Numer procedury jest spoza zakresu.
.
Language=Romanian
RPC_S_PROCNUM_OUT_OF_RANGE - The procedure number is out of range.
.

MessageId=1746
Severity=Success
Facility=System
SymbolicName=RPC_S_BINDING_HAS_NO_AUTH
Language=English
RPC_S_BINDING_HAS_NO_AUTH - The binding does not contain any authentication information.
.
Language=Russian
RPC_S_BINDING_HAS_NO_AUTH - The binding does not contain any authentication information.
.
Language=Polish
RPC_S_BINDING_HAS_NO_AUTH - Powiązanie nie zawiera żadnych informacji o uwierzytelnianiu.
.
Language=Romanian
RPC_S_BINDING_HAS_NO_AUTH - The binding does not contain any authentication information.
.

MessageId=1747
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_AUTHN_SERVICE
Language=English
RPC_S_UNKNOWN_AUTHN_SERVICE - The authentication service is unknown.
.
Language=Russian
RPC_S_UNKNOWN_AUTHN_SERVICE - The authentication service is unknown.
.
Language=Polish
RPC_S_UNKNOWN_AUTHN_SERVICE - Usługa uwierzytelniania jest nieznana.
.
Language=Romanian
RPC_S_UNKNOWN_AUTHN_SERVICE - The authentication service is unknown.
.

MessageId=1748
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_AUTHN_LEVEL
Language=English
RPC_S_UNKNOWN_AUTHN_LEVEL - The authentication level is unknown.
.
Language=Russian
RPC_S_UNKNOWN_AUTHN_LEVEL - The authentication level is unknown.
.
Language=Polish
RPC_S_UNKNOWN_AUTHN_LEVEL - Poziom uwierzytelniania jest nieznany.
.
Language=Romanian
RPC_S_UNKNOWN_AUTHN_LEVEL - The authentication level is unknown.
.

MessageId=1749
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_AUTH_IDENTITY
Language=English
RPC_S_INVALID_AUTH_IDENTITY - The security context is invalid.
.
Language=Russian
RPC_S_INVALID_AUTH_IDENTITY - The security context is invalid.
.
Language=Polish
RPC_S_INVALID_AUTH_IDENTITY - Kontekst zabezpieczeń jest nieprawidłowy.
.
Language=Romanian
RPC_S_INVALID_AUTH_IDENTITY - The security context is invalid.
.

MessageId=1750
Severity=Success
Facility=System
SymbolicName=RPC_S_UNKNOWN_AUTHZ_SERVICE
Language=English
RPC_S_UNKNOWN_AUTHZ_SERVICE - The authorization service is unknown.
.
Language=Russian
RPC_S_UNKNOWN_AUTHZ_SERVICE - The authorization service is unknown.
.
Language=Polish
RPC_S_UNKNOWN_AUTHZ_SERVICE - Usługa autoryzowania jest nieznana.
.
Language=Romanian
RPC_S_UNKNOWN_AUTHZ_SERVICE - The authorization service is unknown.
.

MessageId=1751
Severity=Success
Facility=System
SymbolicName=EPT_S_INVALID_ENTRY
Language=English
EPT_S_INVALID_ENTRY - The entry is invalid.
.
Language=Russian
EPT_S_INVALID_ENTRY - The entry is invalid.
.
Language=Polish
EPT_S_INVALID_ENTRY - Wpis jest nieprawidłowy.
.
Language=Romanian
EPT_S_INVALID_ENTRY - The entry is invalid.
.

MessageId=1752
Severity=Success
Facility=System
SymbolicName=EPT_S_CANT_PERFORM_OP
Language=English
EPT_S_CANT_PERFORM_OP - The server endpoint cannot perform the operation.
.
Language=Russian
EPT_S_CANT_PERFORM_OP - The server endpoint cannot perform the operation.
.
Language=Polish
EPT_S_CANT_PERFORM_OP - Punkt końcowy serwera nie może wykonać operacji.
.
Language=Romanian
EPT_S_CANT_PERFORM_OP - The server endpoint cannot perform the operation.
.

MessageId=1753
Severity=Success
Facility=System
SymbolicName=EPT_S_NOT_REGISTERED
Language=English
EPT_S_NOT_REGISTERED - There are no more endpoints available from the endpoint mapper.
.
Language=Russian
EPT_S_NOT_REGISTERED - There are no more endpoints available from the endpoint mapper.
.
Language=Polish
EPT_S_NOT_REGISTERED - Nie ma więcej dostępnych punktów końcowych z programu mapowania punktów końcowych.
.
Language=Romanian
EPT_S_NOT_REGISTERED - There are no more endpoints available from the endpoint mapper.
.

MessageId=1754
Severity=Success
Facility=System
SymbolicName=RPC_S_NOTHING_TO_EXPORT
Language=English
RPC_S_NOTHING_TO_EXPORT - No interfaces have been exported.
.
Language=Russian
RPC_S_NOTHING_TO_EXPORT - No interfaces have been exported.
.
Language=Polish
RPC_S_NOTHING_TO_EXPORT - Żaden interfejs nie został wyeksportowany.
.
Language=Romanian
RPC_S_NOTHING_TO_EXPORT - No interfaces have been exported.
.

MessageId=1755
Severity=Success
Facility=System
SymbolicName=RPC_S_INCOMPLETE_NAME
Language=English
RPC_S_INCOMPLETE_NAME - The entry name is incomplete.
.
Language=Russian
RPC_S_INCOMPLETE_NAME - The entry name is incomplete.
.
Language=Polish
RPC_S_INCOMPLETE_NAME - Nazwa wpisu jest niekompletna.
.
Language=Romanian
RPC_S_INCOMPLETE_NAME - The entry name is incomplete.
.

MessageId=1756
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_VERS_OPTION
Language=English
RPC_S_INVALID_VERS_OPTION - The version option is invalid.
.
Language=Russian
RPC_S_INVALID_VERS_OPTION - The version option is invalid.
.
Language=Polish
RPC_S_INVALID_VERS_OPTION - Opcja wersji jest nieprawidłowa.
.
Language=Romanian
RPC_S_INVALID_VERS_OPTION - The version option is invalid.
.

MessageId=1757
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_MORE_MEMBERS
Language=English
RPC_S_NO_MORE_MEMBERS - There are no more members.
.
Language=Russian
RPC_S_NO_MORE_MEMBERS - There are no more members.
.
Language=Polish
RPC_S_NO_MORE_MEMBERS - Nie ma więcej członków grupy.
.
Language=Romanian
RPC_S_NO_MORE_MEMBERS - There are no more members.
.

MessageId=1758
Severity=Success
Facility=System
SymbolicName=RPC_S_NOT_ALL_OBJS_UNEXPORTED
Language=English
RPC_S_NOT_ALL_OBJS_UNEXPORTED - There is nothing to unexport.
.
Language=Russian
RPC_S_NOT_ALL_OBJS_UNEXPORTED - There is nothing to unexport.
.
Language=Polish
RPC_S_NOT_ALL_OBJS_UNEXPORTED - Nie ma nic, na czym można by wykonać cofnięcie eksportowania.
.
Language=Romanian
RPC_S_NOT_ALL_OBJS_UNEXPORTED - There is nothing to unexport.
.

MessageId=1759
Severity=Success
Facility=System
SymbolicName=RPC_S_INTERFACE_NOT_FOUND
Language=English
RPC_S_INTERFACE_NOT_FOUND - The interface was not found.
.
Language=Russian
RPC_S_INTERFACE_NOT_FOUND - The interface was not found.
.
Language=Polish
RPC_S_INTERFACE_NOT_FOUND - Nie odnaleziono interfejsu.
.
Language=Romanian
RPC_S_INTERFACE_NOT_FOUND - The interface was not found.
.

MessageId=1760
Severity=Success
Facility=System
SymbolicName=RPC_S_ENTRY_ALREADY_EXISTS
Language=English
RPC_S_ENTRY_ALREADY_EXISTS - The entry already exists.
.
Language=Russian
RPC_S_ENTRY_ALREADY_EXISTS - The entry already exists.
.
Language=Polish
RPC_S_ENTRY_ALREADY_EXISTS - Wpis już istnieje.
.
Language=Romanian
RPC_S_ENTRY_ALREADY_EXISTS - The entry already exists.
.

MessageId=1761
Severity=Success
Facility=System
SymbolicName=RPC_S_ENTRY_NOT_FOUND
Language=English
RPC_S_ENTRY_NOT_FOUND - The entry is not found.
.
Language=Russian
RPC_S_ENTRY_NOT_FOUND - The entry is not found.
.
Language=Polish
RPC_S_ENTRY_NOT_FOUND - Nie można odnaleźć wpisu.
.
Language=Romanian
RPC_S_ENTRY_NOT_FOUND - The entry is not found.
.

MessageId=1762
Severity=Success
Facility=System
SymbolicName=RPC_S_NAME_SERVICE_UNAVAILABLE
Language=English
RPC_S_NAME_SERVICE_UNAVAILABLE - The name service is unavailable.
.
Language=Russian
RPC_S_NAME_SERVICE_UNAVAILABLE - The name service is unavailable.
.
Language=Polish
RPC_S_NAME_SERVICE_UNAVAILABLE - Usługa nazw jest niedostępna.
.
Language=Romanian
RPC_S_NAME_SERVICE_UNAVAILABLE - The name service is unavailable.
.

MessageId=1763
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_NAF_ID
Language=English
RPC_S_INVALID_NAF_ID - The network address family is invalid.
.
Language=Russian
RPC_S_INVALID_NAF_ID - The network address family is invalid.
.
Language=Polish
RPC_S_INVALID_NAF_ID - Rodzina adresów sieciowych jest nieprawidłowa.
.
Language=Romanian
RPC_S_INVALID_NAF_ID - The network address family is invalid.
.

MessageId=1764
Severity=Success
Facility=System
SymbolicName=RPC_S_CANNOT_SUPPORT
Language=English
RPC_S_CANNOT_SUPPORT - The requested operation is not supported.
.
Language=Russian
RPC_S_CANNOT_SUPPORT - The requested operation is not supported.
.
Language=Polish
RPC_S_CANNOT_SUPPORT - Żądana operacja nie jest obsługiwana.
.
Language=Romanian
RPC_S_CANNOT_SUPPORT - The requested operation is not supported.
.

MessageId=1765
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_CONTEXT_AVAILABLE
Language=English
RPC_S_NO_CONTEXT_AVAILABLE - No security context is available to allow impersonation.
.
Language=Russian
RPC_S_NO_CONTEXT_AVAILABLE - No security context is available to allow impersonation.
.
Language=Polish
RPC_S_NO_CONTEXT_AVAILABLE - Nie jest dostępny kontekst zabezpieczeń umożliwiający personifikację.
.
Language=Romanian
RPC_S_NO_CONTEXT_AVAILABLE - No security context is available to allow impersonation.
.

MessageId=1766
Severity=Success
Facility=System
SymbolicName=RPC_S_INTERNAL_ERROR
Language=English
RPC_S_INTERNAL_ERROR - An internal error occurred in a remote procedure call (RPC).
.
Language=Russian
RPC_S_INTERNAL_ERROR - An internal error occurred in a remote procedure call (RPC).
.
Language=Polish
RPC_S_INTERNAL_ERROR - Wystąpił błąd wewnętrzny w zdalnym wywołaniu procedury (RPC).
.
Language=Romanian
RPC_S_INTERNAL_ERROR - An internal error occurred in a remote procedure call (RPC).
.

MessageId=1767
Severity=Success
Facility=System
SymbolicName=RPC_S_ZERO_DIVIDE
Language=English
RPC_S_ZERO_DIVIDE - The RPC server attempted an integer division by zero.
.
Language=Russian
RPC_S_ZERO_DIVIDE - The RPC server attempted an integer division by zero.
.
Language=Polish
RPC_S_ZERO_DIVIDE - Serwer RPC próbował wykonać dzielenie liczby całkowitej przez zero.
.
Language=Romanian
RPC_S_ZERO_DIVIDE - The RPC server attempted an integer division by zero.
.

MessageId=1768
Severity=Success
Facility=System
SymbolicName=RPC_S_ADDRESS_ERROR
Language=English
RPC_S_ADDRESS_ERROR - An addressing error occurred in the RPC server.
.
Language=Russian
RPC_S_ADDRESS_ERROR - An addressing error occurred in the RPC server.
.
Language=Polish
RPC_S_ADDRESS_ERROR - Wystąpił błąd adresowania na serwerze RPC.
.
Language=Romanian
RPC_S_ADDRESS_ERROR - An addressing error occurred in the RPC server.
.

MessageId=1769
Severity=Success
Facility=System
SymbolicName=RPC_S_FP_DIV_ZERO
Language=English
RPC_S_FP_DIV_ZERO - A floating-point operation at the RPC server caused a division by zero.
.
Language=Russian
RPC_S_FP_DIV_ZERO - A floating-point operation at the RPC server caused a division by zero.
.
Language=Polish
RPC_S_FP_DIV_ZERO - Operacja zmiennoprzecinkowa serwera RPC spowodowała dzielenie przez zero.
.
Language=Romanian
RPC_S_FP_DIV_ZERO - A floating-point operation at the RPC server caused a division by zero.
.

MessageId=1770
Severity=Success
Facility=System
SymbolicName=RPC_S_FP_UNDERFLOW
Language=English
RPC_S_FP_UNDERFLOW - A floating-point underflow occurred at the RPC server.
.
Language=Russian
RPC_S_FP_UNDERFLOW - A floating-point underflow occurred at the RPC server.
.
Language=Polish
RPC_S_FP_UNDERFLOW - Na serwerze RPC wystąpił niedomiar zmiennoprzecinkowy.
.
Language=Romanian
RPC_S_FP_UNDERFLOW - A floating-point underflow occurred at the RPC server.
.

MessageId=1771
Severity=Success
Facility=System
SymbolicName=RPC_S_FP_OVERFLOW
Language=English
RPC_S_FP_OVERFLOW - A floating-point overflow occurred at the RPC server.
.
Language=Russian
RPC_S_FP_OVERFLOW - A floating-point overflow occurred at the RPC server.
.
Language=Polish
RPC_S_FP_OVERFLOW - Na serwerze RPC wystąpił nadmiar zmiennoprzecinkowy.
.
Language=Romanian
RPC_S_FP_OVERFLOW - A floating-point overflow occurred at the RPC server.
.

MessageId=1772
Severity=Success
Facility=System
SymbolicName=RPC_X_NO_MORE_ENTRIES
Language=English
RPC_X_NO_MORE_ENTRIES - The list of RPC servers available for the binding of auto handles has been exhausted.
.
Language=Russian
RPC_X_NO_MORE_ENTRIES - The list of RPC servers available for the binding of auto handles has been exhausted.
.
Language=Polish
RPC_X_NO_MORE_ENTRIES - Lista serwerów RPC dostępnych do powiązania autodojść została wyczerpana.
.
Language=Romanian
RPC_X_NO_MORE_ENTRIES - The list of RPC servers available for the binding of auto handles has been exhausted.
.

MessageId=1773
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_CHAR_TRANS_OPEN_FAIL
Language=English
RPC_X_SS_CHAR_TRANS_OPEN_FAIL - Unable to open the character translation table file.
.
Language=Russian
RPC_X_SS_CHAR_TRANS_OPEN_FAIL - Unable to open the character translation table file.
.
Language=Polish
RPC_X_SS_CHAR_TRANS_OPEN_FAIL - Nie można otworzyć pliku tabeli translacji znaków.
.
Language=Romanian
RPC_X_SS_CHAR_TRANS_OPEN_FAIL - Unable to open the character translation table file.
.

MessageId=1774
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_CHAR_TRANS_SHORT_FILE
Language=English
RPC_X_SS_CHAR_TRANS_SHORT_FILE - The file containing the character translation table has fewer than 512 bytes.
.
Language=Russian
RPC_X_SS_CHAR_TRANS_SHORT_FILE - The file containing the character translation table has fewer than 512 bytes.
.
Language=Polish
RPC_X_SS_CHAR_TRANS_SHORT_FILE - Plik zawierający tabelę translacji znaków ma mniej niż 512 bajtów.
.
Language=Romanian
RPC_X_SS_CHAR_TRANS_SHORT_FILE - The file containing the character translation table has fewer than 512 bytes.
.

MessageId=1775
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_IN_NULL_CONTEXT
Language=English
RPC_X_SS_IN_NULL_CONTEXT - A null context handle was passed from the client to the host during a remote procedure call.
.
Language=Russian
RPC_X_SS_IN_NULL_CONTEXT - A null context handle was passed from the client to the host during a remote procedure call.
.
Language=Polish
RPC_X_SS_IN_NULL_CONTEXT - Dojście z zerowym kontekstem (null context handle) zostało przekazane od klienta do hosta w czasie zdalnego wywołania procedury.
.
Language=Romanian
RPC_X_SS_IN_NULL_CONTEXT - A null context handle was passed from the client to the host during a remote procedure call.
.

MessageId=1777
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_CONTEXT_DAMAGED
Language=English
RPC_X_SS_CONTEXT_DAMAGED - The context handle changed during a remote procedure call.
.
Language=Russian
RPC_X_SS_CONTEXT_DAMAGED - The context handle changed during a remote procedure call.
.
Language=Polish
RPC_X_SS_CONTEXT_DAMAGED - Dojście kontekstu zmieniło się podczas zdalnego wywołania procedury.
.
Language=Romanian
RPC_X_SS_CONTEXT_DAMAGED - The context handle changed during a remote procedure call.
.

MessageId=1778
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_HANDLES_MISMATCH
Language=English
RPC_X_SS_HANDLES_MISMATCH - The binding handles passed to a remote procedure call do not match.
.
Language=Russian
RPC_X_SS_HANDLES_MISMATCH - The binding handles passed to a remote procedure call do not match.
.
Language=Polish
RPC_X_SS_HANDLES_MISMATCH - Dojścia powiązania przekazane do zdalnego wywołania procedury nie pasują do siebie.
.
Language=Romanian
RPC_X_SS_HANDLES_MISMATCH - The binding handles passed to a remote procedure call do not match.
.

MessageId=1779
Severity=Success
Facility=System
SymbolicName=RPC_X_SS_CANNOT_GET_CALL_HANDLE
Language=English
RPC_X_SS_CANNOT_GET_CALL_HANDLE - The stub is unable to get the remote procedure call handle.
.
Language=Russian
RPC_X_SS_CANNOT_GET_CALL_HANDLE - The stub is unable to get the remote procedure call handle.
.
Language=Polish
RPC_X_SS_CANNOT_GET_CALL_HANDLE - Procedura wejścia nie może uzyskać dojścia do zdalnego wywołania procedury.
.
Language=Romanian
RPC_X_SS_CANNOT_GET_CALL_HANDLE - The stub is unable to get the remote procedure call handle.
.

MessageId=1780
Severity=Success
Facility=System
SymbolicName=RPC_X_NULL_REF_POINTER
Language=English
RPC_X_NULL_REF_POINTER - A null reference pointer was passed to the stub.
.
Language=Russian
RPC_X_NULL_REF_POINTER - A null reference pointer was passed to the stub.
.
Language=Polish
RPC_X_NULL_REF_POINTER - Do procedury wejścia został przekazany wskaźnik odwołania zerowego.
.
Language=Romanian
RPC_X_NULL_REF_POINTER - A null reference pointer was passed to the stub.
.

MessageId=1781
Severity=Success
Facility=System
SymbolicName=RPC_X_ENUM_VALUE_OUT_OF_RANGE
Language=English
RPC_X_ENUM_VALUE_OUT_OF_RANGE - The enumeration value is out of range.
.
Language=Russian
RPC_X_ENUM_VALUE_OUT_OF_RANGE - The enumeration value is out of range.
.
Language=Polish
RPC_X_ENUM_VALUE_OUT_OF_RANGE - Wartość wyliczenia jest spoza zakresu.
.
Language=Romanian
RPC_X_ENUM_VALUE_OUT_OF_RANGE - The enumeration value is out of range.
.

MessageId=1782
Severity=Success
Facility=System
SymbolicName=RPC_X_BYTE_COUNT_TOO_SMALL
Language=English
RPC_X_BYTE_COUNT_TOO_SMALL - The byte count is too small.
.
Language=Russian
RPC_X_BYTE_COUNT_TOO_SMALL - The byte count is too small.
.
Language=Polish
RPC_X_BYTE_COUNT_TOO_SMALL - Liczba bajtów jest za mała.
.
Language=Romanian
RPC_X_BYTE_COUNT_TOO_SMALL - The byte count is too small.
.

MessageId=1783
Severity=Success
Facility=System
SymbolicName=RPC_X_BAD_STUB_DATA
Language=English
RPC_X_BAD_STUB_DATA - The stub received bad data.
.
Language=Russian
RPC_X_BAD_STUB_DATA - The stub received bad data.
.
Language=Polish
RPC_X_BAD_STUB_DATA - Procedura wejścia odebrała złe dane.
.
Language=Romanian
RPC_X_BAD_STUB_DATA - The stub received bad data.
.

MessageId=1784
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_USER_BUFFER
Language=English
ERROR_INVALID_USER_BUFFER - The supplied user buffer is not valid for the requested operation.
.
Language=Russian
ERROR_INVALID_USER_BUFFER - The supplied user buffer is not valid for the requested operation.
.
Language=Polish
ERROR_INVALID_USER_BUFFER - Podany bufor użytkownika jest nieodpowiedni dla żądanej operacji.
.
Language=Romanian
ERROR_INVALID_USER_BUFFER - The supplied user buffer is not valid for the requested operation.
.

MessageId=1785
Severity=Success
Facility=System
SymbolicName=ERROR_UNRECOGNIZED_MEDIA
Language=English
ERROR_UNRECOGNIZED_MEDIA - The disk media is not recognized. It may not be formatted.
.
Language=Russian
ERROR_UNRECOGNIZED_MEDIA - The disk media is not recognized. It may not be formatted.
.
Language=Polish
ERROR_UNRECOGNIZED_MEDIA - Nie rozpoznany nośnik dysku. Może być nie sformatowany.
.
Language=Romanian
ERROR_UNRECOGNIZED_MEDIA - The disk media is not recognized. It may not be formatted.
.

MessageId=1786
Severity=Success
Facility=System
SymbolicName=ERROR_NO_TRUST_LSA_SECRET
Language=English
ERROR_NO_TRUST_LSA_SECRET - The workstation does not have a trust secret.
.
Language=Russian
ERROR_NO_TRUST_LSA_SECRET - The workstation does not have a trust secret.
.
Language=Polish
ERROR_NO_TRUST_LSA_SECRET - Stacja robocza nie ma hasła zaufania.
.
Language=Romanian
ERROR_NO_TRUST_LSA_SECRET - The workstation does not have a trust secret.
.

MessageId=1787
Severity=Success
Facility=System
SymbolicName=ERROR_NO_TRUST_SAM_ACCOUNT
Language=English
ERROR_NO_TRUST_SAM_ACCOUNT - The security database on the server does not have a computer account for this workstation trust relationship.
.
Language=Russian
ERROR_NO_TRUST_SAM_ACCOUNT - The security database on the server does not have a computer account for this workstation trust relationship.
.
Language=Polish
ERROR_NO_TRUST_SAM_ACCOUNT - Baza danych zabezpieczeń na serwerze nie ma konta komputera dla relacji zaufania tej stacji roboczej.
.
Language=Romanian
ERROR_NO_TRUST_SAM_ACCOUNT - The security database on the server does not have a computer account for this workstation trust relationship.
.

MessageId=1788
Severity=Success
Facility=System
SymbolicName=ERROR_TRUSTED_DOMAIN_FAILURE
Language=English
ERROR_TRUSTED_DOMAIN_FAILURE - The trust relationship between the primary domain and the trusted domain failed.
.
Language=Russian
ERROR_TRUSTED_DOMAIN_FAILURE - The trust relationship between the primary domain and the trusted domain failed.
.
Language=Polish
ERROR_TRUSTED_DOMAIN_FAILURE - Relacje zaufania między domeną podstawową a domeną zaufaną nie powiodły się.
.
Language=Romanian
ERROR_TRUSTED_DOMAIN_FAILURE - The trust relationship between the primary domain and the trusted domain failed.
.

MessageId=1789
Severity=Success
Facility=System
SymbolicName=ERROR_TRUSTED_RELATIONSHIP_FAILURE
Language=English
ERROR_TRUSTED_RELATIONSHIP_FAILURE - The trust relationship between this workstation and the primary domain failed.
.
Language=Russian
ERROR_TRUSTED_RELATIONSHIP_FAILURE - The trust relationship between this workstation and the primary domain failed.
.
Language=Polish
ERROR_TRUSTED_RELATIONSHIP_FAILURE - Relacje zaufania między tą stacją roboczą a domeną podstawową nie powiodły się.
.
Language=Romanian
ERROR_TRUSTED_RELATIONSHIP_FAILURE - The trust relationship between this workstation and the primary domain failed.
.

MessageId=1790
Severity=Success
Facility=System
SymbolicName=ERROR_TRUST_FAILURE
Language=English
ERROR_TRUST_FAILURE - The network logon failed.
.
Language=Russian
ERROR_TRUST_FAILURE - The network logon failed.
.
Language=Polish
ERROR_TRUST_FAILURE - Logowanie w sieci nie powiodło się.
.
Language=Romanian
ERROR_TRUST_FAILURE - The network logon failed.
.

MessageId=1791
Severity=Success
Facility=System
SymbolicName=RPC_S_CALL_IN_PROGRESS
Language=English
RPC_S_CALL_IN_PROGRESS - A remote procedure call is already in progress for this thread.
.
Language=Russian
RPC_S_CALL_IN_PROGRESS - A remote procedure call is already in progress for this thread.
.
Language=Polish
RPC_S_CALL_IN_PROGRESS - Zdalne wywołanie procedury jest już w toku dla tego wątku.
.
Language=Romanian
RPC_S_CALL_IN_PROGRESS - A remote procedure call is already in progress for this thread.
.

MessageId=1792
Severity=Success
Facility=System
SymbolicName=ERROR_NETLOGON_NOT_STARTED
Language=English
ERROR_NETLOGON_NOT_STARTED - An attempt was made to logon, but the network logon service was not started.
.
Language=Russian
ERROR_NETLOGON_NOT_STARTED - An attempt was made to logon, but the network logon service was not started.
.
Language=Polish
ERROR_NETLOGON_NOT_STARTED - Podjęto próbę zalogowania, ale sieciowa usługa logowania nie została uruchomiona.
.
Language=Romanian
ERROR_NETLOGON_NOT_STARTED - An attempt was made to logon, but the network logon service was not started.
.

MessageId=1793
Severity=Success
Facility=System
SymbolicName=ERROR_ACCOUNT_EXPIRED
Language=English
ERROR_ACCOUNT_EXPIRED - The user's account has expired.
.
Language=Russian
ERROR_ACCOUNT_EXPIRED - The user's account has expired.
.
Language=Polish
ERROR_ACCOUNT_EXPIRED - Konto użytkownika wygasło.
.
Language=Romanian
ERROR_ACCOUNT_EXPIRED - The user's account has expired.
.

MessageId=1794
Severity=Success
Facility=System
SymbolicName=ERROR_REDIRECTOR_HAS_OPEN_HANDLES
Language=English
ERROR_REDIRECTOR_HAS_OPEN_HANDLES - The redirector is in use and cannot be unloaded.
.
Language=Russian
ERROR_REDIRECTOR_HAS_OPEN_HANDLES - The redirector is in use and cannot be unloaded.
.
Language=Polish
ERROR_REDIRECTOR_HAS_OPEN_HANDLES - Readresator jest w użyciu i nie można usunąć go z pamięci.
.
Language=Romanian
ERROR_REDIRECTOR_HAS_OPEN_HANDLES - The redirector is in use and cannot be unloaded.
.

MessageId=1795
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_DRIVER_ALREADY_INSTALLED
Language=English
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED - The specified printer driver is already installed.
.
Language=Russian
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED - The specified printer driver is already installed.
.
Language=Polish
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED - Określony sterownik drukarki jest już zainstalowany.
.
Language=Romanian
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED - The specified printer driver is already installed.
.

MessageId=1796
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PORT
Language=English
ERROR_UNKNOWN_PORT - The specified port is unknown.
.
Language=Russian
ERROR_UNKNOWN_PORT - The specified port is unknown.
.
Language=Polish
ERROR_UNKNOWN_PORT - Określony port jest nieznany.
.
Language=Romanian
ERROR_UNKNOWN_PORT - The specified port is unknown.
.

MessageId=1797
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PRINTER_DRIVER
Language=English
ERROR_UNKNOWN_PRINTER_DRIVER - The printer driver is unknown.
.
Language=Russian
ERROR_UNKNOWN_PRINTER_DRIVER - The printer driver is unknown.
.
Language=Polish
ERROR_UNKNOWN_PRINTER_DRIVER - Sterownik drukarki jest nieznany.
.
Language=Romanian
ERROR_UNKNOWN_PRINTER_DRIVER - The printer driver is unknown.
.

MessageId=1798
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PRINTPROCESSOR
Language=English
ERROR_UNKNOWN_PRINTPROCESSOR - The print processor is unknown.
.
Language=Russian
ERROR_UNKNOWN_PRINTPROCESSOR - The print processor is unknown.
.
Language=Polish
ERROR_UNKNOWN_PRINTPROCESSOR - Procesor wydruku jest nieznany.
.
Language=Romanian
ERROR_UNKNOWN_PRINTPROCESSOR - The print processor is unknown.
.

MessageId=1799
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_SEPARATOR_FILE
Language=English
ERROR_INVALID_SEPARATOR_FILE - The specified separator file is invalid.
.
Language=Russian
ERROR_INVALID_SEPARATOR_FILE - The specified separator file is invalid.
.
Language=Polish
ERROR_INVALID_SEPARATOR_FILE - Określony plik separatora jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_SEPARATOR_FILE - The specified separator file is invalid.
.

MessageId=1800
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRIORITY
Language=English
ERROR_INVALID_PRIORITY - The specified priority is invalid.
.
Language=Russian
ERROR_INVALID_PRIORITY - The specified priority is invalid.
.
Language=Polish
ERROR_INVALID_PRIORITY - Określony priorytet jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_PRIORITY - The specified priority is invalid.
.

MessageId=1801
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRINTER_NAME
Language=English
ERROR_INVALID_PRINTER_NAME - The printer name is invalid.
.
Language=Russian
ERROR_INVALID_PRINTER_NAME - The printer name is invalid.
.
Language=Polish
ERROR_INVALID_PRINTER_NAME - Nazwa drukarki jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_PRINTER_NAME - The printer name is invalid.
.

MessageId=1802
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_ALREADY_EXISTS
Language=English
ERROR_PRINTER_ALREADY_EXISTS - The printer already exists.
.
Language=Russian
ERROR_PRINTER_ALREADY_EXISTS - The printer already exists.
.
Language=Polish
ERROR_PRINTER_ALREADY_EXISTS - Drukarka już istnieje.
.
Language=Romanian
ERROR_PRINTER_ALREADY_EXISTS - The printer already exists.
.

MessageId=1803
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRINTER_COMMAND
Language=English
ERROR_INVALID_PRINTER_COMMAND - The printer command is invalid.
.
Language=Russian
ERROR_INVALID_PRINTER_COMMAND - The printer command is invalid.
.
Language=Polish
ERROR_INVALID_PRINTER_COMMAND - Polecenie drukarki jest nieprawidłowe.
.
Language=Romanian
ERROR_INVALID_PRINTER_COMMAND - The printer command is invalid.
.

MessageId=1804
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DATATYPE
Language=English
ERROR_INVALID_DATATYPE - The specified datatype is invalid.
.
Language=Russian
ERROR_INVALID_DATATYPE - The specified datatype is invalid.
.
Language=Polish
ERROR_INVALID_DATATYPE - Określony typ danych jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_DATATYPE - The specified datatype is invalid.
.

MessageId=1805
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_ENVIRONMENT
Language=English
ERROR_INVALID_ENVIRONMENT - The environment specified is invalid.
.
Language=Russian
ERROR_INVALID_ENVIRONMENT - The environment specified is invalid.
.
Language=Polish
ERROR_INVALID_ENVIRONMENT - Określone środowisko jest nieprawidłowe.
.
Language=Romanian
ERROR_INVALID_ENVIRONMENT - The environment specified is invalid.
.

MessageId=1806
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_MORE_BINDINGS
Language=English
RPC_S_NO_MORE_BINDINGS - There are no more bindings.
.
Language=Russian
RPC_S_NO_MORE_BINDINGS - There are no more bindings.
.
Language=Polish
RPC_S_NO_MORE_BINDINGS - Nie ma więcej powiązań.
.
Language=Romanian
RPC_S_NO_MORE_BINDINGS - There are no more bindings.
.

MessageId=1807
Severity=Success
Facility=System
SymbolicName=ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT
Language=English
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT - The account used is an interdomain trust account. Use your global user account or local user account to access this server.
.
Language=Russian
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT - The account used is an interdomain trust account. Use your global user account or local user account to access this server.
.
Language=Polish
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT - Użyte konto jest międzydomenowym kontem zaufania. Aby uzyskać dostęp do tego serwera, użyj globalnego lub lokalnego konta użytkownika.
.
Language=Romanian
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT - The account used is an interdomain trust account. Use your global user account or local user account to access this server.
.

MessageId=1808
Severity=Success
Facility=System
SymbolicName=ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT
Language=English
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT - The account used is a computer account. Use your global user account or local user account to access this server.
.
Language=Russian
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT - The account used is a computer account. Use your global user account or local user account to access this server.
.
Language=Polish
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT - Użyte konto jest kontem komputera. Aby uzyskać dostęp do tego serwera, użyj globalnego lub lokalnego konta użytkownika.
.
Language=Romanian
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT - The account used is a computer account. Use your global user account or local user account to access this server.
.

MessageId=1809
Severity=Success
Facility=System
SymbolicName=ERROR_NOLOGON_SERVER_TRUST_ACCOUNT
Language=English
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT - The account used is a server trust account. Use your global user account or local user account to access this server.
.
Language=Russian
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT - The account used is a server trust account. Use your global user account or local user account to access this server.
.
Language=Polish
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT - Użyte konto jest kontem zaufania serwera. Aby uzyskać dostęp do tego serwera, użyj globalnego lub lokalnego konta użytkownika.
.
Language=Romanian
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT - The account used is a server trust account. Use your global user account or local user account to access this server.
.

MessageId=1810
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_TRUST_INCONSISTENT
Language=English
ERROR_DOMAIN_TRUST_INCONSISTENT - The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain.
.
Language=Russian
ERROR_DOMAIN_TRUST_INCONSISTENT - The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain.
.
Language=Polish
ERROR_DOMAIN_TRUST_INCONSISTENT - Nazwa lub identyfikator zabezpieczeń (SID) określonej domeny jest niezgodny z informacją zaufania dla tej domeny.
.
Language=Romanian
ERROR_DOMAIN_TRUST_INCONSISTENT - The name or security ID (SID) of the domain specified is inconsistent with the trust information for that domain.
.

MessageId=1811
Severity=Success
Facility=System
SymbolicName=ERROR_SERVER_HAS_OPEN_HANDLES
Language=English
ERROR_SERVER_HAS_OPEN_HANDLES - The server is in use and cannot be unloaded.
.
Language=Russian
ERROR_SERVER_HAS_OPEN_HANDLES - The server is in use and cannot be unloaded.
.
Language=Polish
ERROR_SERVER_HAS_OPEN_HANDLES - Serwer jest w użyciu i nie można usunąć go z pamięci.
.
Language=Romanian
ERROR_SERVER_HAS_OPEN_HANDLES - The server is in use and cannot be unloaded.
.

MessageId=1812
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_DATA_NOT_FOUND
Language=English
ERROR_RESOURCE_DATA_NOT_FOUND - The specified image file did not contain a resource section.
.
Language=Russian
ERROR_RESOURCE_DATA_NOT_FOUND - The specified image file did not contain a resource section.
.
Language=Polish
ERROR_RESOURCE_DATA_NOT_FOUND - Określony plik obrazu nie zawierał sekcji zasobów.
.
Language=Romanian
ERROR_RESOURCE_DATA_NOT_FOUND - The specified image file did not contain a resource section.
.

MessageId=1813
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_TYPE_NOT_FOUND
Language=English
ERROR_RESOURCE_TYPE_NOT_FOUND - The specified resource type cannot be found in the image file.
.
Language=Russian
ERROR_RESOURCE_TYPE_NOT_FOUND - The specified resource type cannot be found in the image file.
.
Language=Polish
ERROR_RESOURCE_TYPE_NOT_FOUND - Nie można znaleźć określonego typu zasobu w pliku obrazu.
.
Language=Romanian
ERROR_RESOURCE_TYPE_NOT_FOUND - The specified resource type cannot be found in the image file.
.

MessageId=1814
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_NAME_NOT_FOUND
Language=English
ERROR_RESOURCE_NAME_NOT_FOUND - The specified resource name cannot be found in the image file.
.
Language=Russian
ERROR_RESOURCE_NAME_NOT_FOUND - The specified resource name cannot be found in the image file.
.
Language=Polish
ERROR_RESOURCE_NAME_NOT_FOUND - Nie można znaleźć określonej nazwy zasobu w pliku obrazu.
.
Language=Romanian
ERROR_RESOURCE_NAME_NOT_FOUND - The specified resource name cannot be found in the image file.
.

MessageId=1815
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_LANG_NOT_FOUND
Language=English
ERROR_RESOURCE_LANG_NOT_FOUND - The specified resource language ID cannot be found in the image file.
.
Language=Russian
ERROR_RESOURCE_LANG_NOT_FOUND - The specified resource language ID cannot be found in the image file.
.
Language=Polish
ERROR_RESOURCE_LANG_NOT_FOUND - Nie można odnaleźć identyfikatora języka zasobu w pliku obrazu.
.
Language=Romanian
ERROR_RESOURCE_LANG_NOT_FOUND - The specified resource language ID cannot be found in the image file.
.

MessageId=1816
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_ENOUGH_QUOTA
Language=English
ERROR_NOT_ENOUGH_QUOTA - Not enough quota is available to process this command.
.
Language=Russian
ERROR_NOT_ENOUGH_QUOTA - Not enough quota is available to process this command.
.
Language=Polish
ERROR_NOT_ENOUGH_QUOTA - Za mały przydział do przetworzenia tego polecenia.
.
Language=Romanian
ERROR_NOT_ENOUGH_QUOTA - Not enough quota is available to process this command.
.

MessageId=1817
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_INTERFACES
Language=English
RPC_S_NO_INTERFACES - No interfaces have been registered.
.
Language=Russian
RPC_S_NO_INTERFACES - No interfaces have been registered.
.
Language=Polish
RPC_S_NO_INTERFACES - Żaden interfejs nie został zarejestrowany.
.
Language=Romanian
RPC_S_NO_INTERFACES - No interfaces have been registered.
.

MessageId=1818
Severity=Success
Facility=System
SymbolicName=RPC_S_CALL_CANCELLED
Language=English
RPC_S_CALL_CANCELLED - The remote procedure call was cancelled.
.
Language=Russian
RPC_S_CALL_CANCELLED - The remote procedure call was cancelled.
.
Language=Polish
RPC_S_CALL_CANCELLED - Zdalne wywołanie procedury zostało anulowane.
.
Language=Romanian
RPC_S_CALL_CANCELLED - The remote procedure call was cancelled.
.

MessageId=1819
Severity=Success
Facility=System
SymbolicName=RPC_S_BINDING_INCOMPLETE
Language=English
RPC_S_BINDING_INCOMPLETE - The binding handle does not contain all required information.
.
Language=Russian
RPC_S_BINDING_INCOMPLETE - The binding handle does not contain all required information.
.
Language=Polish
RPC_S_BINDING_INCOMPLETE - Dojście powiązania nie zawiera wszystkich wymaganych informacji.
.
Language=Romanian
RPC_S_BINDING_INCOMPLETE - The binding handle does not contain all required information.
.

MessageId=1820
Severity=Success
Facility=System
SymbolicName=RPC_S_COMM_FAILURE
Language=English
RPC_S_COMM_FAILURE - A communications failure occurred during a remote procedure call.
.
Language=Russian
RPC_S_COMM_FAILURE - A communications failure occurred during a remote procedure call.
.
Language=Polish
RPC_S_COMM_FAILURE - Podczas zdalnego wywoływania procedury wystąpił błąd komunikacji.
.
Language=Romanian
RPC_S_COMM_FAILURE - A communications failure occurred during a remote procedure call.
.

MessageId=1821
Severity=Success
Facility=System
SymbolicName=RPC_S_UNSUPPORTED_AUTHN_LEVEL
Language=English
RPC_S_UNSUPPORTED_AUTHN_LEVEL - The requested authentication level is not supported.
.
Language=Russian
RPC_S_UNSUPPORTED_AUTHN_LEVEL - The requested authentication level is not supported.
.
Language=Polish
RPC_S_UNSUPPORTED_AUTHN_LEVEL - Żądany poziom uwierzytelniania nie jest obsługiwany.
.
Language=Romanian
RPC_S_UNSUPPORTED_AUTHN_LEVEL - The requested authentication level is not supported.
.

MessageId=1822
Severity=Success
Facility=System
SymbolicName=RPC_S_NO_PRINC_NAME
Language=English
RPC_S_NO_PRINC_NAME - No principal name registered.
.
Language=Russian
RPC_S_NO_PRINC_NAME - No principal name registered.
.
Language=Polish
RPC_S_NO_PRINC_NAME - Nie zarejestrowano nazwy głównej.
.
Language=Romanian
RPC_S_NO_PRINC_NAME - No principal name registered.
.

MessageId=1823
Severity=Success
Facility=System
SymbolicName=RPC_S_NOT_RPC_ERROR
Language=English
RPC_S_NOT_RPC_ERROR - The error specified is not a valid Windows RPC error code.
.
Language=Russian
RPC_S_NOT_RPC_ERROR - The error specified is not a valid Windows RPC error code.
.
Language=Polish
RPC_S_NOT_RPC_ERROR - Określony błąd nie jest prawidłowym kodem błędu protokołu zdalnego wywołania procedury (RPC).
.
Language=Romanian
RPC_S_NOT_RPC_ERROR - The error specified is not a valid Windows RPC error code.
.

MessageId=1824
Severity=Success
Facility=System
SymbolicName=RPC_S_UUID_LOCAL_ONLY
Language=English
RPC_S_UUID_LOCAL_ONLY - A UUID that is valid only on this computer has been allocated.
.
Language=Russian
RPC_S_UUID_LOCAL_ONLY - A UUID that is valid only on this computer has been allocated.
.
Language=Polish
RPC_S_UUID_LOCAL_ONLY - Przydzielono identyfikator UUID, który jest prawidłowy tylko na tym komputerze.
.
Language=Romanian
RPC_S_UUID_LOCAL_ONLY - A UUID that is valid only on this computer has been allocated.
.

MessageId=1825
Severity=Success
Facility=System
SymbolicName=RPC_S_SEC_PKG_ERROR
Language=English
RPC_S_SEC_PKG_ERROR - A security package specific error occurred.
.
Language=Russian
RPC_S_SEC_PKG_ERROR - A security package specific error occurred.
.
Language=Polish
RPC_S_SEC_PKG_ERROR - Wystąpił błąd specyficzny dla pakietu zabezpieczeń.
.
Language=Romanian
RPC_S_SEC_PKG_ERROR - A security package specific error occurred.
.

MessageId=1826
Severity=Success
Facility=System
SymbolicName=RPC_S_NOT_CANCELLED
Language=English
RPC_S_NOT_CANCELLED - Thread is not canceled.
.
Language=Russian
RPC_S_NOT_CANCELLED - Thread is not canceled.
.
Language=Polish
RPC_S_NOT_CANCELLED - Wątek nie został anulowany.
.
Language=Romanian
RPC_S_NOT_CANCELLED - Thread is not canceled.
.

MessageId=1827
Severity=Success
Facility=System
SymbolicName=RPC_X_INVALID_ES_ACTION
Language=English
RPC_X_INVALID_ES_ACTION - Invalid operation on the encoding/decoding handle.
.
Language=Russian
RPC_X_INVALID_ES_ACTION - Invalid operation on the encoding/decoding handle.
.
Language=Polish
RPC_X_INVALID_ES_ACTION - Nieprawidłowa operacja na dojściu kodowania/dekodowania.
.
Language=Romanian
RPC_X_INVALID_ES_ACTION - Invalid operation on the encoding/decoding handle.
.

MessageId=1828
Severity=Success
Facility=System
SymbolicName=RPC_X_WRONG_ES_VERSION
Language=English
RPC_X_WRONG_ES_VERSION - Incompatible version of the serializing package.
.
Language=Russian
RPC_X_WRONG_ES_VERSION - Incompatible version of the serializing package.
.
Language=Polish
RPC_X_WRONG_ES_VERSION - Niezgodna wersja pakietu szeregującego.
.
Language=Romanian
RPC_X_WRONG_ES_VERSION - Incompatible version of the serializing package.
.

MessageId=1829
Severity=Success
Facility=System
SymbolicName=RPC_X_WRONG_STUB_VERSION
Language=English
RPC_X_WRONG_STUB_VERSION - Incompatible version of the RPC stub.
.
Language=Russian
RPC_X_WRONG_STUB_VERSION - Incompatible version of the RPC stub.
.
Language=Polish
RPC_X_WRONG_STUB_VERSION - Niezgodna wersja procedury wejścia RPC.
.
Language=Romanian
RPC_X_WRONG_STUB_VERSION - Incompatible version of the RPC stub.
.

MessageId=1830
Severity=Success
Facility=System
SymbolicName=RPC_X_INVALID_PIPE_OBJECT
Language=English
RPC_X_INVALID_PIPE_OBJECT - The RPC pipe object is invalid or corrupted.
.
Language=Russian
RPC_X_INVALID_PIPE_OBJECT - The RPC pipe object is invalid or corrupted.
.
Language=Polish
RPC_X_INVALID_PIPE_OBJECT - Obiekt potoku RPC jest nieprawidłowy lub uszkodzony.
.
Language=Romanian
RPC_X_INVALID_PIPE_OBJECT - The RPC pipe object is invalid or corrupted.
.

MessageId=1831
Severity=Success
Facility=System
SymbolicName=RPC_X_WRONG_PIPE_ORDER
Language=English
RPC_X_WRONG_PIPE_ORDER - An invalid operation was attempted on an RPC pipe object.
.
Language=Russian
RPC_X_WRONG_PIPE_ORDER - An invalid operation was attempted on an RPC pipe object.
.
Language=Polish
RPC_X_WRONG_PIPE_ORDER - Ta operacja nie jest prawidłowa dla danego obiektu potoku RPC.
.
Language=Romanian
RPC_X_WRONG_PIPE_ORDER - An invalid operation was attempted on an RPC pipe object.
.

MessageId=1832
Severity=Success
Facility=System
SymbolicName=RPC_X_WRONG_PIPE_VERSION
Language=English
RPC_X_WRONG_PIPE_VERSION - Unsupported RPC pipe version.
.
Language=Russian
RPC_X_WRONG_PIPE_VERSION - Unsupported RPC pipe version.
.
Language=Polish
RPC_X_WRONG_PIPE_VERSION - Ta wersja potoku RPC nie jest obsługiwana.
.
Language=Romanian
RPC_X_WRONG_PIPE_VERSION - Unsupported RPC pipe version.
.

MessageId=1898
Severity=Success
Facility=System
SymbolicName=RPC_S_GROUP_MEMBER_NOT_FOUND
Language=English
RPC_S_GROUP_MEMBER_NOT_FOUND - The group member was not found.
.
Language=Russian
RPC_S_GROUP_MEMBER_NOT_FOUND - The group member was not found.
.
Language=Polish
RPC_S_GROUP_MEMBER_NOT_FOUND - Nie odnaleziono członka grupy.
.
Language=Romanian
RPC_S_GROUP_MEMBER_NOT_FOUND - The group member was not found.
.

MessageId=1899
Severity=Success
Facility=System
SymbolicName=EPT_S_CANT_CREATE
Language=English
EPT_S_CANT_CREATE - The endpoint mapper database entry could not be created.
.
Language=Russian
EPT_S_CANT_CREATE - The endpoint mapper database entry could not be created.
.
Language=Polish
EPT_S_CANT_CREATE - Nie można utworzyć bazy danych mapowania punktu końcowego.
.
Language=Romanian
EPT_S_CANT_CREATE - The endpoint mapper database entry could not be created.
.

MessageId=1900
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_OBJECT
Language=English
RPC_S_INVALID_OBJECT - The object universal unique identifier (UUID) is the nil UUID.
.
Language=Russian
RPC_S_INVALID_OBJECT - The object universal unique identifier (UUID) is the nil UUID.
.
Language=Polish
RPC_S_INVALID_OBJECT - Uniwersalny, unikatowy identyfikator obiektu (UUID) jest zerowym identyfikatorem UUID.
.
Language=Romanian
RPC_S_INVALID_OBJECT - The object universal unique identifier (UUID) is the nil UUID.
.

MessageId=1901
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_TIME
Language=English
ERROR_INVALID_TIME - The specified time is invalid.
.
Language=Russian
ERROR_INVALID_TIME - The specified time is invalid.
.
Language=Polish
ERROR_INVALID_TIME - Określony czas jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_TIME - The specified time is invalid.
.

MessageId=1902
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FORM_NAME
Language=English
ERROR_INVALID_FORM_NAME - The specified form name is invalid.
.
Language=Russian
ERROR_INVALID_FORM_NAME - The specified form name is invalid.
.
Language=Polish
ERROR_INVALID_FORM_NAME - Określona nazwa formularza jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_FORM_NAME - The specified form name is invalid.
.

MessageId=1903
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_FORM_SIZE
Language=English
ERROR_INVALID_FORM_SIZE - The specified form size is invalid.
.
Language=Russian
ERROR_INVALID_FORM_SIZE - The specified form size is invalid.
.
Language=Polish
ERROR_INVALID_FORM_SIZE - Określony rozmiar formularza jest nieprawidłowy
.
Language=Romanian
ERROR_INVALID_FORM_SIZE - The specified form size is invalid.
.

MessageId=1904
Severity=Success
Facility=System
SymbolicName=ERROR_ALREADY_WAITING
Language=English
ERROR_ALREADY_WAITING - The specified printer handle is already being waited on
.
Language=Russian
ERROR_ALREADY_WAITING - The specified printer handle is already being waited on
.
Language=Polish
ERROR_ALREADY_WAITING - Określone dojście drukarki jest już obsługiwane.
.
Language=Romanian
ERROR_ALREADY_WAITING - The specified printer handle is already being waited on
.

MessageId=1905
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_DELETED
Language=English
ERROR_PRINTER_DELETED - The specified printer has been deleted.
.
Language=Russian
ERROR_PRINTER_DELETED - The specified printer has been deleted.
.
Language=Polish
ERROR_PRINTER_DELETED - Określona drukarka została usunięta.
.
Language=Romanian
ERROR_PRINTER_DELETED - The specified printer has been deleted.
.

MessageId=1906
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRINTER_STATE
Language=English
ERROR_INVALID_PRINTER_STATE - The state of the printer is invalid.
.
Language=Russian
ERROR_INVALID_PRINTER_STATE - The state of the printer is invalid.
.
Language=Polish
ERROR_INVALID_PRINTER_STATE - Stan drukarki jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_PRINTER_STATE - The state of the printer is invalid.
.

MessageId=1907
Severity=Success
Facility=System
SymbolicName=ERROR_PASSWORD_MUST_CHANGE
Language=English
ERROR_PASSWORD_MUST_CHANGE - The user's password must be changed before logging on the first time.
.
Language=Russian
ERROR_PASSWORD_MUST_CHANGE - The user's password must be changed before logging on the first time.
.
Language=Polish
ERROR_PASSWORD_MUST_CHANGE - Hasło użytkownika musi zostać zmienione przed pierwszym zalogowaniem.
.
Language=Romanian
ERROR_PASSWORD_MUST_CHANGE - The user's password must be changed before logging on the first time.
.

MessageId=1908
Severity=Success
Facility=System
SymbolicName=ERROR_DOMAIN_CONTROLLER_NOT_FOUND
Language=English
ERROR_DOMAIN_CONTROLLER_NOT_FOUND - Could not find the domain controller for this domain.
.
Language=Russian
ERROR_DOMAIN_CONTROLLER_NOT_FOUND - Could not find the domain controller for this domain.
.
Language=Polish
ERROR_DOMAIN_CONTROLLER_NOT_FOUND - Nie można odnaleźć kontrolera tej domeny.
.
Language=Romanian
ERROR_DOMAIN_CONTROLLER_NOT_FOUND - Could not find the domain controller for this domain.
.

MessageId=1909
Severity=Success
Facility=System
SymbolicName=ERROR_ACCOUNT_LOCKED_OUT
Language=English
ERROR_ACCOUNT_LOCKED_OUT - The referenced account is currently locked out and may not be used to log on.
.
Language=Russian
ERROR_ACCOUNT_LOCKED_OUT - The referenced account is currently locked out and may not be used to log on.
.
Language=Polish
ERROR_ACCOUNT_LOCKED_OUT - Wywoływane konto jest obecnie zablokowane i nie można logować się za jego pomocą.
.
Language=Romanian
ERROR_ACCOUNT_LOCKED_OUT - The referenced account is currently locked out and may not be used to log on.
.

MessageId=1910
Severity=Success
Facility=System
SymbolicName=OR_INVALID_OXID
Language=English
OR_INVALID_OXID - The object exporter specified was not found.
.
Language=Russian
OR_INVALID_OXID - The object exporter specified was not found.
.
Language=Polish
OR_INVALID_OXID - Określony eksporter obiektu nie został odnaleziony.
.
Language=Romanian
OR_INVALID_OXID - The object exporter specified was not found.
.

MessageId=1911
Severity=Success
Facility=System
SymbolicName=OR_INVALID_OID
Language=English
OR_INVALID_OID - The object specified was not found.
.
Language=Russian
OR_INVALID_OID - The object specified was not found.
.
Language=Polish
OR_INVALID_OID - Określony obiekt nie został odnaleziony.
.
Language=Romanian
OR_INVALID_OID - The object specified was not found.
.

MessageId=1912
Severity=Success
Facility=System
SymbolicName=OR_INVALID_SET
Language=English
OR_INVALID_SET - The object resolver set specified was not found.
.
Language=Russian
OR_INVALID_SET - The object resolver set specified was not found.
.
Language=Polish
OR_INVALID_SET - Określony zestaw programu rozpoznawania nazw obiektów nie został odnaleziony.
.
Language=Romanian
OR_INVALID_SET - The object resolver set specified was not found.
.

MessageId=1913
Severity=Success
Facility=System
SymbolicName=RPC_S_SEND_INCOMPLETE
Language=English
RPC_S_SEND_INCOMPLETE - Some data remains to be sent in the request buffer.
.
Language=Russian
RPC_S_SEND_INCOMPLETE - Some data remains to be sent in the request buffer.
.
Language=Polish
RPC_S_SEND_INCOMPLETE - Pewne dane pozostają w buforze żądania, oczekując na wysłanie.
.
Language=Romanian
RPC_S_SEND_INCOMPLETE - Some data remains to be sent in the request buffer.
.

MessageId=1914
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_ASYNC_HANDLE
Language=English
RPC_S_INVALID_ASYNC_HANDLE - Invalid asynchronous remote procedure call handle.
.
Language=Russian
RPC_S_INVALID_ASYNC_HANDLE - Invalid asynchronous remote procedure call handle.
.
Language=Polish
RPC_S_INVALID_ASYNC_HANDLE - Nieprawidłowe dojście do asynchronicznego zdalnego wywołania procedury.
.
Language=Romanian
RPC_S_INVALID_ASYNC_HANDLE - Invalid asynchronous remote procedure call handle.
.

MessageId=1915
Severity=Success
Facility=System
SymbolicName=RPC_S_INVALID_ASYNC_CALL
Language=English
RPC_S_INVALID_ASYNC_CALL - Invalid asynchronous RPC call handle for this operation.
.
Language=Russian
RPC_S_INVALID_ASYNC_CALL - Invalid asynchronous RPC call handle for this operation.
.
Language=Polish
RPC_S_INVALID_ASYNC_CALL - Nieprawidłowe dojście do asynchronicznego zdalnego wywołania procedury (RPC) dla tej operacji.
.
Language=Romanian
RPC_S_INVALID_ASYNC_CALL - Invalid asynchronous RPC call handle for this operation.
.

MessageId=1916
Severity=Success
Facility=System
SymbolicName=RPC_X_PIPE_CLOSED
Language=English
RPC_X_PIPE_CLOSED - The RPC pipe object has already been closed.
.
Language=Russian
RPC_X_PIPE_CLOSED - The RPC pipe object has already been closed.
.
Language=Polish
RPC_X_PIPE_CLOSED - Obiekt potoku RPC został już zamknięty.
.
Language=Romanian
RPC_X_PIPE_CLOSED - The RPC pipe object has already been closed.
.

MessageId=1917
Severity=Success
Facility=System
SymbolicName=RPC_X_PIPE_DISCIPLINE_ERROR
Language=English
RPC_X_PIPE_DISCIPLINE_ERROR - The RPC call completed before all pipes were processed.
.
Language=Russian
RPC_X_PIPE_DISCIPLINE_ERROR - The RPC call completed before all pipes were processed.
.
Language=Polish
RPC_X_PIPE_DISCIPLINE_ERROR - Wywołanie RPC zostało ukończone przed przetworzeniem wszystkich potoków.
.
Language=Romanian
RPC_X_PIPE_DISCIPLINE_ERROR - The RPC call completed before all pipes were processed.
.

MessageId=1918
Severity=Success
Facility=System
SymbolicName=RPC_X_PIPE_EMPTY
Language=English
RPC_X_PIPE_EMPTY - No more data is available from the RPC pipe.
.
Language=Russian
RPC_X_PIPE_EMPTY - No more data is available from the RPC pipe.
.
Language=Polish
RPC_X_PIPE_EMPTY - Nie ma więcej dostępnych danych z potoku RPC.
.
Language=Romanian
RPC_X_PIPE_EMPTY - No more data is available from the RPC pipe.
.

MessageId=1919
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SITENAME
Language=English
ERROR_NO_SITENAME - No site name is available for this machine.
.
Language=Russian
ERROR_NO_SITENAME - No site name is available for this machine.
.
Language=Polish
ERROR_NO_SITENAME - Żadna nazwa serwisu nie jest dostępna dla tego komputera.
.
Language=Romanian
ERROR_NO_SITENAME - No site name is available for this machine.
.

MessageId=1920
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_ACCESS_FILE
Language=English
ERROR_CANT_ACCESS_FILE - The file cannot be accessed by the system.
.
Language=Russian
ERROR_CANT_ACCESS_FILE - The file cannot be accessed by the system.
.
Language=Polish
ERROR_CANT_ACCESS_FILE - System nie może uzyskać dostępu do pliku.
.
Language=Romanian
ERROR_CANT_ACCESS_FILE - The file cannot be accessed by the system.
.

MessageId=1921
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_RESOLVE_FILENAME
Language=English
ERROR_CANT_RESOLVE_FILENAME - The name of the file cannot be resolved by the system.
.
Language=Russian
ERROR_CANT_RESOLVE_FILENAME - The name of the file cannot be resolved by the system.
.
Language=Polish
ERROR_CANT_RESOLVE_FILENAME - System nie może rozpoznać nazwy pliku.
.
Language=Romanian
ERROR_CANT_RESOLVE_FILENAME - The name of the file cannot be resolved by the system.
.

MessageId=1922
Severity=Success
Facility=System
SymbolicName=RPC_S_ENTRY_TYPE_MISMATCH
Language=English
RPC_S_ENTRY_TYPE_MISMATCH - The entry is not of the expected type.
.
Language=Russian
RPC_S_ENTRY_TYPE_MISMATCH - The entry is not of the expected type.
.
Language=Polish
RPC_S_ENTRY_TYPE_MISMATCH - Wpis nie jest oczekiwanego typu.
.
Language=Romanian
RPC_S_ENTRY_TYPE_MISMATCH - The entry is not of the expected type.
.

MessageId=1923
Severity=Success
Facility=System
SymbolicName=RPC_S_NOT_ALL_OBJS_EXPORTED
Language=English
RPC_S_NOT_ALL_OBJS_EXPORTED - Not all object UUIDs could be exported to the specified entry.
.
Language=Russian
RPC_S_NOT_ALL_OBJS_EXPORTED - Not all object UUIDs could be exported to the specified entry.
.
Language=Polish
RPC_S_NOT_ALL_OBJS_EXPORTED - Nie można wyeksportować niektórych identyfikatorów UUID obiektu do podanego wpisu.
.
Language=Romanian
RPC_S_NOT_ALL_OBJS_EXPORTED - Not all object UUIDs could be exported to the specified entry.
.

MessageId=1924
Severity=Success
Facility=System
SymbolicName=RPC_S_INTERFACE_NOT_EXPORTED
Language=English
RPC_S_INTERFACE_NOT_EXPORTED - Interface could not be exported to the specified entry.
.
Language=Russian
RPC_S_INTERFACE_NOT_EXPORTED - Interface could not be exported to the specified entry.
.
Language=Polish
RPC_S_INTERFACE_NOT_EXPORTED - Nie można wyeksportować interfejsu do podanego wpisu..
.
Language=Romanian
RPC_S_INTERFACE_NOT_EXPORTED - Interface could not be exported to the specified entry.
.

MessageId=1925
Severity=Success
Facility=System
SymbolicName=RPC_S_PROFILE_NOT_ADDED
Language=English
RPC_S_PROFILE_NOT_ADDED - The specified profile entry could not be added.
.
Language=Russian
RPC_S_PROFILE_NOT_ADDED - The specified profile entry could not be added.
.
Language=Polish
RPC_S_PROFILE_NOT_ADDED - Nie można dodać podanego wpisu profilu.
.
Language=Romanian
RPC_S_PROFILE_NOT_ADDED - The specified profile entry could not be added.
.

MessageId=1926
Severity=Success
Facility=System
SymbolicName=RPC_S_PRF_ELT_NOT_ADDED
Language=English
RPC_S_PRF_ELT_NOT_ADDED - The specified profile element could not be added.
.
Language=Russian
RPC_S_PRF_ELT_NOT_ADDED - The specified profile element could not be added.
.
Language=Polish
RPC_S_PRF_ELT_NOT_ADDED - Nie można dodać podanego elementu profilu.
.
Language=Romanian
RPC_S_PRF_ELT_NOT_ADDED - The specified profile element could not be added.
.

MessageId=1927
Severity=Success
Facility=System
SymbolicName=RPC_S_PRF_ELT_NOT_REMOVED
Language=English
RPC_S_PRF_ELT_NOT_REMOVED - The specified profile element could not be removed.
.
Language=Russian
RPC_S_PRF_ELT_NOT_REMOVED - The specified profile element could not be removed.
.
Language=Polish
RPC_S_PRF_ELT_NOT_REMOVED - Nie można usunąć podanego elementu profilu.
.
Language=Romanian
RPC_S_PRF_ELT_NOT_REMOVED - The specified profile element could not be removed.
.

MessageId=1928
Severity=Success
Facility=System
SymbolicName=RPC_S_GRP_ELT_NOT_ADDED
Language=English
RPC_S_GRP_ELT_NOT_ADDED - The group element could not be added.
.
Language=Russian
RPC_S_GRP_ELT_NOT_ADDED - The group element could not be added.
.
Language=Polish
RPC_S_GRP_ELT_NOT_ADDED - Nie można dodać elementu grupy.
.
Language=Romanian
RPC_S_GRP_ELT_NOT_ADDED - The group element could not be added.
.

MessageId=1929
Severity=Success
Facility=System
SymbolicName=RPC_S_GRP_ELT_NOT_REMOVED
Language=English
RPC_S_GRP_ELT_NOT_REMOVED - The group element could not be removed.
.
Language=Russian
RPC_S_GRP_ELT_NOT_REMOVED - The group element could not be removed.
.
Language=Polish
RPC_S_GRP_ELT_NOT_REMOVED - Nie można usunąć elementu grupy.
.
Language=Romanian
RPC_S_GRP_ELT_NOT_REMOVED - The group element could not be removed.
.

MessageId=1930
Severity=Success
Facility=System
SymbolicName=ERROR_KM_DRIVER_BLOCKED
Language=English
ERROR_KM_DRIVER_BLOCKED - The printer driver is not compatible with a policy enabled on your computer that blocks NT 4.0 drivers.
.
Language=Russian
ERROR_KM_DRIVER_BLOCKED - The printer driver is not compatible with a policy enabled on your computer that blocks NT 4.0 drivers.
.
Language=Polish
ERROR_KM_DRIVER_BLOCKED - Sterownik drukarki jest niezgodny z włączonymi na danym komputerze zasadami, które blokują sterowniki systemu NT 4.0.
.
Language=Romanian
ERROR_KM_DRIVER_BLOCKED - The printer driver is not compatible with a policy enabled on your computer that blocks NT 4.0 drivers.
.

MessageId=1931
Severity=Success
Facility=System
SymbolicName=ERROR_CONTEXT_EXPIRED
Language=English
ERROR_CONTEXT_EXPIRED - The context has expired and can no longer be used.
.
Language=Russian
ERROR_CONTEXT_EXPIRED - The context has expired and can no longer be used.
.
Language=Polish
ERROR_CONTEXT_EXPIRED - Kontekst wygasł i nie może być już dłużej używany.
.
Language=Romanian
ERROR_CONTEXT_EXPIRED - The context has expired and can no longer be used.
.

MessageId=1932
Severity=Success
Facility=System
SymbolicName=ERROR_PER_USER_TRUST_QUOTA_EXCEEDED
Language=English
ERROR_PER_USER_TRUST_QUOTA_EXCEEDED - The current user's delegated trust creation quota has been exceeded.
.
Language=Russian
ERROR_PER_USER_TRUST_QUOTA_EXCEEDED - The current user's delegated trust creation quota has been exceeded.
.
Language=Polish
ERROR_PER_USER_TRUST_QUOTA_EXCEEDED - Delegowany przydział tworzenia zaufania bieżącego użytkownika został przekroczony.
.
Language=Romanian
ERROR_PER_USER_TRUST_QUOTA_EXCEEDED - The current user's delegated trust creation quota has been exceeded.
.

MessageId=1933
Severity=Success
Facility=System
SymbolicName=ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED
Language=English
ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED - The total delegated trust creation quota has been exceeded.
.
Language=Russian
ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED - The total delegated trust creation quota has been exceeded.
.
Language=Polish
ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED - Całkowity delegowany przydział tworzenia zaufania został przekroczony.
.
Language=Romanian
ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED - The total delegated trust creation quota has been exceeded.
.

MessageId=1934
Severity=Success
Facility=System
SymbolicName=ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED
Language=English
ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED - The current user's delegated trust deletion quota has been exceeded.
.
Language=Russian
ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED - The current user's delegated trust deletion quota has been exceeded.
.
Language=Polish
ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED - Delegowany przydział usuwania zaufania bieżącego użytkownika został przekroczony.
.
Language=Romanian
ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED - The current user's delegated trust deletion quota has been exceeded.
.

MessageId=2000
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PIXEL_FORMAT
Language=English
ERROR_INVALID_PIXEL_FORMAT - The pixel format is invalid.
.
Language=Russian
ERROR_INVALID_PIXEL_FORMAT - The pixel format is invalid.
.
Language=Polish
ERROR_INVALID_PIXEL_FORMAT - Format piksela jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_PIXEL_FORMAT - The pixel format is invalid.
.

MessageId=2001
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_DRIVER
Language=English
ERROR_BAD_DRIVER - The specified driver is invalid.
.
Language=Russian
ERROR_BAD_DRIVER - The specified driver is invalid.
.
Language=Polish
ERROR_BAD_DRIVER - Określony sterownik jest nieprawidłowy.
.
Language=Romanian
ERROR_BAD_DRIVER - The specified driver is invalid.
.

MessageId=2002
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_WINDOW_STYLE
Language=English
ERROR_INVALID_WINDOW_STYLE - The window style or class attribute is invalid for this operation.
.
Language=Russian
ERROR_INVALID_WINDOW_STYLE - The window style or class attribute is invalid for this operation.
.
Language=Polish
ERROR_INVALID_WINDOW_STYLE - Styl okna lub atrybut klasy jest nieodpowiedni dla tej operacji.
.
Language=Romanian
ERROR_INVALID_WINDOW_STYLE - The window style or class attribute is invalid for this operation.
.

MessageId=2003
Severity=Success
Facility=System
SymbolicName=ERROR_METAFILE_NOT_SUPPORTED
Language=English
ERROR_METAFILE_NOT_SUPPORTED - The requested metafile operation is not supported.
.
Language=Russian
ERROR_METAFILE_NOT_SUPPORTED - The requested metafile operation is not supported.
.
Language=Polish
ERROR_METAFILE_NOT_SUPPORTED - Żądana operacja metapliku nie jest obsługiwana.
.
Language=Romanian
ERROR_METAFILE_NOT_SUPPORTED - The requested metafile operation is not supported.
.

MessageId=2004
Severity=Success
Facility=System
SymbolicName=ERROR_TRANSFORM_NOT_SUPPORTED
Language=English
ERROR_TRANSFORM_NOT_SUPPORTED - The requested transformation operation is not supported.
.
Language=Russian
ERROR_TRANSFORM_NOT_SUPPORTED - The requested transformation operation is not supported.
.
Language=Polish
ERROR_TRANSFORM_NOT_SUPPORTED - Żądana operacja transformacji nie jest obsługiwana.
.
Language=Romanian
ERROR_TRANSFORM_NOT_SUPPORTED - The requested transformation operation is not supported.
.

MessageId=2005
Severity=Success
Facility=System
SymbolicName=ERROR_CLIPPING_NOT_SUPPORTED
Language=English
ERROR_CLIPPING_NOT_SUPPORTED - The requested clipping operation is not supported.
.
Language=Russian
ERROR_CLIPPING_NOT_SUPPORTED - The requested clipping operation is not supported.
.
Language=Polish
ERROR_CLIPPING_NOT_SUPPORTED - Żądana operacja clipping nie jest obsługiwana.
.
Language=Romanian
ERROR_CLIPPING_NOT_SUPPORTED - The requested clipping operation is not supported.
.

MessageId=2010
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_CMM
Language=English
ERROR_INVALID_CMM - The specified color management module is invalid.
.
Language=Russian
ERROR_INVALID_CMM - The specified color management module is invalid.
.
Language=Polish
ERROR_INVALID_CMM - Podany moduł zarządzania kolorami jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_CMM - The specified color management module is invalid.
.

MessageId=2011
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PROFILE
Language=English
ERROR_INVALID_PROFILE - The specified color profile is invalid.
.
Language=Russian
ERROR_INVALID_PROFILE - The specified color profile is invalid.
.
Language=Polish
ERROR_INVALID_PROFILE - Podany profil kolorów jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_PROFILE - The specified color profile is invalid.
.

MessageId=2012
Severity=Success
Facility=System
SymbolicName=ERROR_TAG_NOT_FOUND
Language=English
ERROR_TAG_NOT_FOUND - The specified tag was not found.
.
Language=Russian
ERROR_TAG_NOT_FOUND - The specified tag was not found.
.
Language=Polish
ERROR_TAG_NOT_FOUND - Nie znaleziono podanej etykiety.
.
Language=Romanian
ERROR_TAG_NOT_FOUND - The specified tag was not found.
.

MessageId=2013
Severity=Success
Facility=System
SymbolicName=ERROR_TAG_NOT_PRESENT
Language=English
ERROR_TAG_NOT_PRESENT - A required tag is not present.
.
Language=Russian
ERROR_TAG_NOT_PRESENT - A required tag is not present.
.
Language=Polish
ERROR_TAG_NOT_PRESENT - Brakuje wymaganej etykiety.
.
Language=Romanian
ERROR_TAG_NOT_PRESENT - A required tag is not present.
.

MessageId=2014
Severity=Success
Facility=System
SymbolicName=ERROR_DUPLICATE_TAG
Language=English
ERROR_DUPLICATE_TAG - The specified tag is already present.
.
Language=Russian
ERROR_DUPLICATE_TAG - The specified tag is already present.
.
Language=Polish
ERROR_DUPLICATE_TAG - Podana etykieta już istnieje.
.
Language=Romanian
ERROR_DUPLICATE_TAG - The specified tag is already present.
.

MessageId=2015
Severity=Success
Facility=System
SymbolicName=ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE
Language=English
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE - The specified color profile is not associated with any device.
.
Language=Russian
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE - The specified color profile is not associated with any device.
.
Language=Polish
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE - Podany profil kolorów nie jest skojarzony z żadnym urządzeniem.
.
Language=Romanian
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE - The specified color profile is not associated with any device.
.

MessageId=2016
Severity=Success
Facility=System
SymbolicName=ERROR_PROFILE_NOT_FOUND
Language=English
ERROR_PROFILE_NOT_FOUND - The specified color profile was not found.
.
Language=Russian
ERROR_PROFILE_NOT_FOUND - The specified color profile was not found.
.
Language=Polish
ERROR_PROFILE_NOT_FOUND - Nie znaleziono podanego profilu kolorów.
.
Language=Romanian
ERROR_PROFILE_NOT_FOUND - The specified color profile was not found.
.

MessageId=2017
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_COLORSPACE
Language=English
ERROR_INVALID_COLORSPACE - The specified color space is invalid.
.
Language=Russian
ERROR_INVALID_COLORSPACE - The specified color space is invalid.
.
Language=Polish
ERROR_INVALID_COLORSPACE - Podana przestrzeń kolorów jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_COLORSPACE - The specified color space is invalid.
.

MessageId=2018
Severity=Success
Facility=System
SymbolicName=ERROR_ICM_NOT_ENABLED
Language=English
ERROR_ICM_NOT_ENABLED - Image Color Management is not enabled.
.
Language=Russian
ERROR_ICM_NOT_ENABLED - Image Color Management is not enabled.
.
Language=Polish
ERROR_ICM_NOT_ENABLED - Zarządzanie kolorami obrazu nie jest włączone.
.
Language=Romanian
ERROR_ICM_NOT_ENABLED - Image Color Management is not enabled.
.

MessageId=2019
Severity=Success
Facility=System
SymbolicName=ERROR_DELETING_ICM_XFORM
Language=English
ERROR_DELETING_ICM_XFORM - There was an error while deleting the color transform.
.
Language=Russian
ERROR_DELETING_ICM_XFORM - There was an error while deleting the color transform.
.
Language=Polish
ERROR_DELETING_ICM_XFORM - Podczas usuwania transformacji koloru wystąpił błąd.
.
Language=Romanian
ERROR_DELETING_ICM_XFORM - There was an error while deleting the color transform.
.

MessageId=2020
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_TRANSFORM
Language=English
ERROR_INVALID_TRANSFORM - The specified color transform is invalid.
.
Language=Russian
ERROR_INVALID_TRANSFORM - The specified color transform is invalid.
.
Language=Polish
ERROR_INVALID_TRANSFORM - Podana transformacja kolorów jest nieprawidłowa.
.
Language=Romanian
ERROR_INVALID_TRANSFORM - The specified color transform is invalid.
.

MessageId=2021
Severity=Success
Facility=System
SymbolicName=ERROR_COLORSPACE_MISMATCH
Language=English
ERROR_COLORSPACE_MISMATCH - The specified transform does not match the bitmap's color space.
.
Language=Russian
ERROR_COLORSPACE_MISMATCH - The specified transform does not match the bitmap's color space.
.
Language=Polish
ERROR_COLORSPACE_MISMATCH - Podana transformacja nie jest zgodna z przestrzenią kolorów mapy bitowej.
.
Language=Romanian
ERROR_COLORSPACE_MISMATCH - The specified transform does not match the bitmap's color space.
.

MessageId=2022
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_COLORINDEX
Language=English
ERROR_INVALID_COLORINDEX - The specified named color index is not present in the profile.
.
Language=Russian
ERROR_INVALID_COLORINDEX - The specified named color index is not present in the profile.
.
Language=Polish
ERROR_INVALID_COLORINDEX - Podany indeks nazwanych kolorów nie występuje w profilu.
.
Language=Romanian
ERROR_INVALID_COLORINDEX - The specified named color index is not present in the profile.
.

MessageId=2108
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTED_OTHER_PASSWORD
Language=English
ERROR_CONNECTED_OTHER_PASSWORD - The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified.
.
Language=Russian
ERROR_CONNECTED_OTHER_PASSWORD - The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified.
.
Language=Polish
ERROR_CONNECTED_OTHER_PASSWORD - Połączenie sieciowe zostało nawiązane, ale użytkownik był wezwany do podania hasła innego niż pierwotnie podane.
.
Language=Romanian
ERROR_CONNECTED_OTHER_PASSWORD - The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified.
.

MessageId=2109
Severity=Success
Facility=System
SymbolicName=ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT
Language=English
ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT - The network connection was made successfully using default credentials.
.
Language=Russian
ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT - The network connection was made successfully using default credentials.
.
Language=Polish
ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT - Ustanowienie połączenia przy użyciu poświadczeń domyślnych powiodło się.
.
Language=Romanian
ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT - The network connection was made successfully using default credentials.
.

MessageId=2202
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_USERNAME
Language=English
ERROR_BAD_USERNAME - The specified username is invalid.
.
Language=Russian
ERROR_BAD_USERNAME - The specified username is invalid.
.
Language=Polish
ERROR_BAD_USERNAME - Określona nazwa użytkownika jest nieprawidłowa.
.
Language=Romanian
ERROR_BAD_USERNAME - The specified username is invalid.
.

MessageId=2250
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_CONNECTED
Language=English
ERROR_NOT_CONNECTED - This network connection does not exist.
.
Language=Russian
ERROR_NOT_CONNECTED - This network connection does not exist.
.
Language=Polish
ERROR_NOT_CONNECTED - To połączenie sieciowe nie istnieje.
.
Language=Romanian
ERROR_NOT_CONNECTED - This network connection does not exist.
.

MessageId=2401
Severity=Success
Facility=System
SymbolicName=ERROR_OPEN_FILES
Language=English
ERROR_OPEN_FILES - This network connection has files open or requests pending.
.
Language=Russian
ERROR_OPEN_FILES - This network connection has files open or requests pending.
.
Language=Polish
ERROR_OPEN_FILES - To połączenie sieciowe ma otwarte pliki lub aktywne żądania.
.
Language=Romanian
ERROR_OPEN_FILES - This network connection has files open or requests pending.
.

MessageId=2402
Severity=Success
Facility=System
SymbolicName=ERROR_ACTIVE_CONNECTIONS
Language=English
ERROR_ACTIVE_CONNECTIONS - Active connections still exist.
.
Language=Russian
ERROR_ACTIVE_CONNECTIONS - Active connections still exist.
.
Language=Polish
ERROR_ACTIVE_CONNECTIONS - Nadal istnieją aktywne połączenia.
.
Language=Romanian
ERROR_ACTIVE_CONNECTIONS - Active connections still exist.
.

MessageId=2404
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_IN_USE
Language=English
ERROR_DEVICE_IN_USE - The device is in use by an active process and cannot be disconnected.
.
Language=Russian
ERROR_DEVICE_IN_USE - The device is in use by an active process and cannot be disconnected.
.
Language=Polish
ERROR_DEVICE_IN_USE - Urządzenie jest używane przez aktywny proces i nie można go odłączyć.
.
Language=Romanian
ERROR_DEVICE_IN_USE - The device is in use by an active process and cannot be disconnected.
.

MessageId=3000
Severity=Success
Facility=System
SymbolicName=ERROR_UNKNOWN_PRINT_MONITOR
Language=English
ERROR_UNKNOWN_PRINT_MONITOR - The specified print monitor is unknown.
.
Language=Russian
ERROR_UNKNOWN_PRINT_MONITOR - The specified print monitor is unknown.
.
Language=Polish
ERROR_UNKNOWN_PRINT_MONITOR - Określony monitor wydruku jest nieznany.
.
Language=Romanian
ERROR_UNKNOWN_PRINT_MONITOR - The specified print monitor is unknown.
.

MessageId=3001
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_DRIVER_IN_USE
Language=English
ERROR_PRINTER_DRIVER_IN_USE - The specified printer driver is currently in use.
.
Language=Russian
ERROR_PRINTER_DRIVER_IN_USE - The specified printer driver is currently in use.
.
Language=Polish
ERROR_PRINTER_DRIVER_IN_USE - Określony sterownik drukarki jest obecnie w użyciu.
.
Language=Romanian
ERROR_PRINTER_DRIVER_IN_USE - The specified printer driver is currently in use.
.

MessageId=3002
Severity=Success
Facility=System
SymbolicName=ERROR_SPOOL_FILE_NOT_FOUND
Language=English
ERROR_SPOOL_FILE_NOT_FOUND - The spool file was not found.
.
Language=Russian
ERROR_SPOOL_FILE_NOT_FOUND - The spool file was not found.
.
Language=Polish
ERROR_SPOOL_FILE_NOT_FOUND - Nie znaleziono pliku buforowania.
.
Language=Romanian
ERROR_SPOOL_FILE_NOT_FOUND - The spool file was not found.
.

MessageId=3003
Severity=Success
Facility=System
SymbolicName=ERROR_SPL_NO_STARTDOC
Language=English
ERROR_SPL_NO_STARTDOC - A StartDocPrinter call was not issued.
.
Language=Russian
ERROR_SPL_NO_STARTDOC - A StartDocPrinter call was not issued.
.
Language=Polish
ERROR_SPL_NO_STARTDOC - Wywołanie StartDocPrinter nie zostało wysłane.
.
Language=Romanian
ERROR_SPL_NO_STARTDOC - A StartDocPrinter call was not issued.
.

MessageId=3004
Severity=Success
Facility=System
SymbolicName=ERROR_SPL_NO_ADDJOB
Language=English
ERROR_SPL_NO_ADDJOB - An AddJob call was not issued.
.
Language=Russian
ERROR_SPL_NO_ADDJOB - An AddJob call was not issued.
.
Language=Polish
ERROR_SPL_NO_ADDJOB - Wywołanie AddJob nie zostało wysłane.
.
Language=Romanian
ERROR_SPL_NO_ADDJOB - An AddJob call was not issued.
.

MessageId=3005
Severity=Success
Facility=System
SymbolicName=ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED
Language=English
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED - The specified print processor has already been installed.
.
Language=Russian
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED - The specified print processor has already been installed.
.
Language=Polish
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED - Określony procesor wydruku jest już zainstalowany.
.
Language=Romanian
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED - The specified print processor has already been installed.
.

MessageId=3006
Severity=Success
Facility=System
SymbolicName=ERROR_PRINT_MONITOR_ALREADY_INSTALLED
Language=English
ERROR_PRINT_MONITOR_ALREADY_INSTALLED - The specified print monitor has already been installed.
.
Language=Russian
ERROR_PRINT_MONITOR_ALREADY_INSTALLED - The specified print monitor has already been installed.
.
Language=Polish
ERROR_PRINT_MONITOR_ALREADY_INSTALLED - Określony monitor wydruku jest już zainstalowany.
.
Language=Romanian
ERROR_PRINT_MONITOR_ALREADY_INSTALLED - The specified print monitor has already been installed.
.

MessageId=3007
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_PRINT_MONITOR
Language=English
ERROR_INVALID_PRINT_MONITOR - The specified print monitor does not have the required functions.
.
Language=Russian
ERROR_INVALID_PRINT_MONITOR - The specified print monitor does not have the required functions.
.
Language=Polish
ERROR_INVALID_PRINT_MONITOR - Określony monitor wydruku nie ma wymaganych funkcji.
.
Language=Romanian
ERROR_INVALID_PRINT_MONITOR - The specified print monitor does not have the required functions.
.

MessageId=3008
Severity=Success
Facility=System
SymbolicName=ERROR_PRINT_MONITOR_IN_USE
Language=English
ERROR_PRINT_MONITOR_IN_USE - The specified print monitor is currently in use.
.
Language=Russian
ERROR_PRINT_MONITOR_IN_USE - The specified print monitor is currently in use.
.
Language=Polish
ERROR_PRINT_MONITOR_IN_USE - Określony monitor wydruku jest już w użyciu.
.
Language=Romanian
ERROR_PRINT_MONITOR_IN_USE - The specified print monitor is currently in use.
.

MessageId=3009
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_HAS_JOBS_QUEUED
Language=English
ERROR_PRINTER_HAS_JOBS_QUEUED - The requested operation is not allowed when there are jobs queued to the printer.
.
Language=Russian
ERROR_PRINTER_HAS_JOBS_QUEUED - The requested operation is not allowed when there are jobs queued to the printer.
.
Language=Polish
ERROR_PRINTER_HAS_JOBS_QUEUED - Żądana operacja nie jest dopuszczalna, gdy w kolejce drukarki znajdują się zadania.
.
Language=Romanian
ERROR_PRINTER_HAS_JOBS_QUEUED - The requested operation is not allowed when there are jobs queued to the printer.
.

MessageId=3010
Severity=Success
Facility=System
SymbolicName=ERROR_SUCCESS_REBOOT_REQUIRED
Language=English
ERROR_SUCCESS_REBOOT_REQUIRED - The requested operation is successful. Changes will not be effective until the system is rebooted.
.
Language=Russian
ERROR_SUCCESS_REBOOT_REQUIRED - The requested operation is successful. Changes will not be effective until the system is rebooted.
.
Language=Polish
ERROR_SUCCESS_REBOOT_REQUIRED - Żądana operacja powiodła się. Zmiany nie odniosą skutku aż do ponownego uruchomienia systemu.
.
Language=Romanian
ERROR_SUCCESS_REBOOT_REQUIRED - The requested operation is successful. Changes will not be effective until the system is rebooted.
.

MessageId=3011
Severity=Success
Facility=System
SymbolicName=ERROR_SUCCESS_RESTART_REQUIRED
Language=English
ERROR_SUCCESS_RESTART_REQUIRED - The requested operation is successful. Changes will not be effective until the service is restarted.
.
Language=Russian
ERROR_SUCCESS_RESTART_REQUIRED - The requested operation is successful. Changes will not be effective until the service is restarted.
.
Language=Polish
ERROR_SUCCESS_RESTART_REQUIRED - Żądana operacja powiodła się. Zmiany nie odniosą skutku aż do ponownego uruchomienia usługi.
.
Language=Romanian
ERROR_SUCCESS_RESTART_REQUIRED - The requested operation is successful. Changes will not be effective until the service is restarted.
.

MessageId=3012
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_NOT_FOUND
Language=English
ERROR_PRINTER_NOT_FOUND - No printers were found.
.
Language=Russian
ERROR_PRINTER_NOT_FOUND - No printers were found.
.
Language=Polish
ERROR_PRINTER_NOT_FOUND - Nie znaleziono żadnych drukarek.
.
Language=Romanian
ERROR_PRINTER_NOT_FOUND - No printers were found.
.

MessageId=3013
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_DRIVER_WARNED
Language=English
ERROR_PRINTER_DRIVER_WARNED - The printer driver is known to be unreliable.
.
Language=Russian
ERROR_PRINTER_DRIVER_WARNED - The printer driver is known to be unreliable.
.
Language=Polish
ERROR_PRINTER_DRIVER_WARNED - Sterownik drukarki jest znany jako zawodny.
.
Language=Romanian
ERROR_PRINTER_DRIVER_WARNED - The printer driver is known to be unreliable.
.

MessageId=3014
Severity=Success
Facility=System
SymbolicName=ERROR_PRINTER_DRIVER_BLOCKED
Language=English
ERROR_PRINTER_DRIVER_BLOCKED - The printer driver is known to harm the system.
.
Language=Russian
ERROR_PRINTER_DRIVER_BLOCKED - The printer driver is known to harm the system.
.
Language=Polish
ERROR_PRINTER_DRIVER_BLOCKED - Sterownik drukarki jest znany jako szkodliwy dla systemu.
.
Language=Romanian
ERROR_PRINTER_DRIVER_BLOCKED - The printer driver is known to harm the system.
.

MessageId=3100
Severity=Success
Facility=System
SymbolicName=ERROR_XML_UNDEFINED_ENTITY
Language=English
ERROR_XML_UNDEFINED_ENTITY - The XML contains an entity reference to an undefined entity.
.
Language=Russian
ERROR_XML_UNDEFINED_ENTITY - The XML contains an entity reference to an undefined entity.
.
Language=Polish
ERROR_XML_UNDEFINED_ENTITY - Kod XML zawiera odwołanie do niezdefiniowanej encji.
.
Language=Romanian
ERROR_XML_UNDEFINED_ENTITY - The XML contains an entity reference to an undefined entity.
.

MessageId=3101
Severity=Success
Facility=System
SymbolicName=ERROR_XML_MALFORMED_ENTITY
Language=English
ERROR_XML_MALFORMED_ENTITY - The XML contains a malformed entity reference.
.
Language=Russian
ERROR_XML_MALFORMED_ENTITY - The XML contains a malformed entity reference.
.
Language=Polish
ERROR_XML_MALFORMED_ENTITY - Kod XML zawiera nieprawidłowe odwołanie do encji.
.
Language=Romanian
ERROR_XML_MALFORMED_ENTITY - The XML contains a malformed entity reference.
.

MessageId=3102
Severity=Success
Facility=System
SymbolicName=ERROR_XML_CHAR_NOT_IN_RANGE
Language=English
ERROR_XML_CHAR_NOT_IN_RANGE - The XML contains a character which is not permitted in XML.
.
Language=Russian
ERROR_XML_CHAR_NOT_IN_RANGE - The XML contains a character which is not permitted in XML.
.
Language=Polish
ERROR_XML_CHAR_NOT_IN_RANGE - Kod XML zawiera znak, który nie jest dozwolony w języku w XML.
.
Language=Romanian
ERROR_XML_CHAR_NOT_IN_RANGE - The XML contains a character which is not permitted in XML.
.

MessageId=3200
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY
Language=English
ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY - The manifest contained a duplicate definition for external proxy stub %1 at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY - The manifest contained a duplicate definition for external proxy stub %1 at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY - Manifest zawiera zduplikowaną definicję dla zewnętrznej procedury wejścia obiektu proxy %1 w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_EXTERNAL_PROXY - The manifest contained a duplicate definition for external proxy stub %1 at (%1:%2,%3)
.

MessageId=3201
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE
Language=English
ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE - The manifest already contains a reference to %4 - a second reference was found at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE - The manifest already contains a reference to %4 - a second reference was found at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE - Manifest zawiera już odwołanie do %4 - drugie odwołanie odnaleziono w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_ASSEMBLY_REFERENCE - The manifest already contains a reference to %4 - a second reference was found at (%1:%2,%3)
.

MessageId=3202
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE
Language=English
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE - The assembly reference at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE - The assembly reference at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE - Nieprawidłowe odwołanie do zestawu w (%1:%2,%3).
.
Language=Romanian
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_REFERENCE - The assembly reference at (%1:%2,%3) is invalid.
.

MessageId=3203
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION
Language=English
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION - The assembly definition at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION - The assembly definition at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION - Nieprawidłowa definicja zestawu w (%1:%2,%3).
.
Language=Romanian
ERROR_PCM_COMPILER_INVALID_ASSEMBLY_DEFINITION - The assembly definition at (%1:%2,%3) is invalid.
.

MessageId=3204
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS
Language=English
ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS - The manifest already contained the window class %4, found a second declaration at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS - The manifest already contained the window class %4, found a second declaration at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS - Manifest zawiera już klasę okna %4, drugą deklarację odnaleziono w (%1:%2,%3).
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_WINDOW_CLASS - The manifest already contained the window class %4, found a second declaration at (%1:%2,%3)
.

MessageId=3205
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_PROGID
Language=English
ERROR_PCM_COMPILER_DUPLICATE_PROGID - The manifest already declared the progId %4, found a second declaration at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_PROGID - The manifest already declared the progId %4, found a second declaration at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_PROGID - Manifest już zadeklarował identyfikator progId %4, drugą deklarację odnaleziono w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_PROGID - The manifest already declared the progId %4, found a second declaration at (%1:%2,%3)
.

MessageId=3206
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT
Language=English
ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT - Only one noInherit tag may be present in a manifest, found a second tag at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT - Only one noInherit tag may be present in a manifest, found a second tag at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT - W manifeście może występować tylko jeden tag noInherit, drugi tag odnaleziono w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_NOINHERIT - Only one noInherit tag may be present in a manifest, found a second tag at (%1:%2,%3)
.

MessageId=3207
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE
Language=English
ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE - Only one noInheritable tag may be present in a manifest, found a second tag at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE - Only one noInheritable tag may be present in a manifest, found a second tag at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE - W manifeście może występować tylko jeden tag noInheritable, drugi tag odnaleziono w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_NOINHERITABLE - Only one noInheritable tag may be present in a manifest, found a second tag at (%1:%2,%3)
.

MessageId=3208
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS
Language=English
ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS - The manifest contained a duplicate declaration of COM class %4 at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS - The manifest contained a duplicate declaration of COM class %4 at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS - Manifest zawiera zduplikowaną deklarację klasy COM %4 w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_COM_CLASS - The manifest contained a duplicate declaration of COM class %4 at (%1:%2,%3)
.

MessageId=3209
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME
Language=English
ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME - The manifest already declared the file %4, a second definition was found at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME - The manifest already declared the file %4, a second definition was found at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME - Manifest już zadeklarował plik %4, drugą definicję odnaleziono w (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_FILE_NAME - The manifest already declared the file %4, a second definition was found at (%1:%2,%3)
.

MessageId=3210
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE
Language=English
ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE - CLR surrogate %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE - CLR surrogate %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE - CLR surrogate %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_CLR_SURROGATE - CLR surrogate %1 was already defined, second definition at (%1:%2,%3) is invalid.
.

MessageId=3211
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY
Language=English
ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY - Type library %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY - Type library %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY - Type library %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_TYPE_LIBRARY - Type library %1 was already defined, second definition at (%1:%2,%3) is invalid.
.

MessageId=3212
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB
Language=English
ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB - Proxy stub definition %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB - Proxy stub definition %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB - Proxy stub definition %1 was already defined, second definition at (%1:%2,%3) is invalid.
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_PROXY_STUB - Proxy stub definition %1 was already defined, second definition at (%1:%2,%3) is invalid.
.

MessageId=3213
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME
Language=English
ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME - Category friendly name %4 was already used, second definition was found at (%1:%2,%3) is invalid.
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME - Category friendly name %4 was already used, second definition was found at (%1:%2,%3) is invalid.
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME - Category friendly name %4 was already used, second definition was found at (%1:%2,%3) is invalid.
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_CATEGORY_NAME - Category friendly name %4 was already used, second definition was found at (%1:%2,%3) is invalid.
.

MessageId=3214
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND
Language=English
ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND - Only one top-level assemblyIdentity tag may be present in a manifest. A second tag with identity %4 was found at (%1:%2,%3)
.
Language=Russian
ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND - Only one top-level assemblyIdentity tag may be present in a manifest. A second tag with identity %4 was found at (%1:%2,%3)
.
Language=Polish
ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND - Only one top-level assemblyIdentity tag may be present in a manifest. A second tag with identity %4 was found at (%1:%2,%3)
.
Language=Romanian
ERROR_PCM_COMPILER_DUPLICATE_TOP_LEVEL_IDENTITY_FOUND - Only one top-level assemblyIdentity tag may be present in a manifest. A second tag with identity %4 was found at (%1:%2,%3)
.

MessageId=3215
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT
Language=English
ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT - The root element for a manifest found at (%1:%2,%3) was not expected or was of the wrong version.
.
Language=Russian
ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT - The root element for a manifest found at (%1:%2,%3) was not expected or was of the wrong version.
.
Language=Polish
ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT - The root element for a manifest found at (%1:%2,%3) was not expected or was of the wrong version.
.
Language=Romanian
ERROR_PCM_COMPILER_UNKNOWN_ROOT_ELEMENT - The root element for a manifest found at (%1:%2,%3) was not expected or was of the wrong version.
.

MessageId=3216
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_INVALID_ELEMENT
Language=English
ERROR_PCM_COMPILER_INVALID_ELEMENT - The element found at (%1:%2,%3) was not expected according to the manifest schema.
.
Language=Russian
ERROR_PCM_COMPILER_INVALID_ELEMENT - The element found at (%1:%2,%3) was not expected according to the manifest schema.
.
Language=Polish
ERROR_PCM_COMPILER_INVALID_ELEMENT - The element found at (%1:%2,%3) was not expected according to the manifest schema.
.
Language=Romanian
ERROR_PCM_COMPILER_INVALID_ELEMENT - The element found at (%1:%2,%3) was not expected according to the manifest schema.
.

MessageId=3217
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE
Language=English
ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE - The element found at (%1:%2,%3) was missing the required attribute '%4'. See the manifest schema for more information
.
Language=Russian
ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE - The element found at (%1:%2,%3) was missing the required attribute '%4'. See the manifest schema for more information
.
Language=Polish
ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE - The element found at (%1:%2,%3) was missing the required attribute '%4'. See the manifest schema for more information
.
Language=Romanian
ERROR_PCM_COMPILER_MISSING_REQUIRED_ATTRIBUTE - The element found at (%1:%2,%3) was missing the required attribute '%4'. See the manifest schema for more information
.

MessageId=3218
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE
Language=English
ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE - The attribute value %4 at (%1:%2,%3) was invalid according to the schema.
.
Language=Russian
ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE - The attribute value %4 at (%1:%2,%3) was invalid according to the schema.
.
Language=Polish
ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE - The attribute value %4 at (%1:%2,%3) was invalid according to the schema.
.
Language=Romanian
ERROR_PCM_COMPILER_INVALID_ATTRIBUTE_VALUE - The attribute value %4 at (%1:%2,%3) was invalid according to the schema.
.

MessageId=3219
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_COMPILER_UNEXPECTED_PCDATA
Language=English
ERROR_PCM_COMPILER_UNEXPECTED_PCDATA - PCDATA or CDATA found at (%1:%2,%3) in the source document was not expected in the parent element %4.
.
Language=Russian
ERROR_PCM_COMPILER_UNEXPECTED_PCDATA - PCDATA or CDATA found at (%1:%2,%3) in the source document was not expected in the parent element %4.
.
Language=Polish
ERROR_PCM_COMPILER_UNEXPECTED_PCDATA - PCDATA or CDATA found at (%1:%2,%3) in the source document was not expected in the parent element %4.
.
Language=Romanian
ERROR_PCM_COMPILER_UNEXPECTED_PCDATA - PCDATA or CDATA found at (%1:%2,%3) in the source document was not expected in the parent element %4.
.

MessageId=3220
Severity=Success
Facility=System
SymbolicName=ERROR_PCM_DUPLICATE_STRING_TABLE_ENT
Language=English
ERROR_PCM_DUPLICATE_STRING_TABLE_ENT - The string table entry with culture %4, name %5, and value '%6' at (%1:%2,%3) duplicated a previous entry.
.
Language=Russian
ERROR_PCM_DUPLICATE_STRING_TABLE_ENT - The string table entry with culture %4, name %5, and value '%6' at (%1:%2,%3) duplicated a previous entry.
.
Language=Polish
ERROR_PCM_DUPLICATE_STRING_TABLE_ENT - The string table entry with culture %4, name %5, and value '%6' at (%1:%2,%3) duplicated a previous entry.
.
Language=Romanian
ERROR_PCM_DUPLICATE_STRING_TABLE_ENT - The string table entry with culture %4, name %5, and value '%6' at (%1:%2,%3) duplicated a previous entry.
.

MessageId=4000
Severity=Success
Facility=System
SymbolicName=ERROR_WINS_INTERNAL
Language=English
ERROR_WINS_INTERNAL - WINS encountered an error while processing the command.
.
Language=Russian
ERROR_WINS_INTERNAL - WINS encountered an error while processing the command.
.
Language=Polish
ERROR_WINS_INTERNAL - WINS napotkał na błąd podczas przetwarzania polecenia.
.
Language=Romanian
ERROR_WINS_INTERNAL - WINS encountered an error while processing the command.
.

MessageId=4001
Severity=Success
Facility=System
SymbolicName=ERROR_CAN_NOT_DEL_LOCAL_WINS
Language=English
ERROR_CAN_NOT_DEL_LOCAL_WINS - The local WINS cannot be deleted.
.
Language=Russian
ERROR_CAN_NOT_DEL_LOCAL_WINS - The local WINS cannot be deleted.
.
Language=Polish
ERROR_CAN_NOT_DEL_LOCAL_WINS - Lokalny WINS nie może być usunięty.
.
Language=Romanian
ERROR_CAN_NOT_DEL_LOCAL_WINS - The local WINS cannot be deleted.
.

MessageId=4002
Severity=Success
Facility=System
SymbolicName=ERROR_STATIC_INIT
Language=English
ERROR_STATIC_INIT - The importation from the file failed.
.
Language=Russian
ERROR_STATIC_INIT - The importation from the file failed.
.
Language=Polish
ERROR_STATIC_INIT - Importowanie z pliku nie powiodło się.
.
Language=Romanian
ERROR_STATIC_INIT - The importation from the file failed.
.

MessageId=4003
Severity=Success
Facility=System
SymbolicName=ERROR_INC_BACKUP
Language=English
ERROR_INC_BACKUP - The backup failed. Was a full backup done before?
.
Language=Russian
ERROR_INC_BACKUP - The backup failed. Was a full backup done before?
.
Language=Polish
ERROR_INC_BACKUP - Wykonanie kopii zapasowej nie powiodło się. Czy wcześniej wykonywano pełną kopię zapasową?
.
Language=Romanian
ERROR_INC_BACKUP - The backup failed. Was a full backup done before?
.

MessageId=4004
Severity=Success
Facility=System
SymbolicName=ERROR_FULL_BACKUP
Language=English
ERROR_FULL_BACKUP - The backup failed. Check the directory to which you are backing the database.
.
Language=Russian
ERROR_FULL_BACKUP - The backup failed. Check the directory to which you are backing the database.
.
Language=Polish
ERROR_FULL_BACKUP - Wykonanie kopii zapasowej nie powiodło się. Sprawdź katalog, do którego jest wykonywana kopia zapasowa bazy danych.
.
Language=Romanian
ERROR_FULL_BACKUP - The backup failed. Check the directory to which you are backing the database.
.

MessageId=4005
Severity=Success
Facility=System
SymbolicName=ERROR_REC_NON_EXISTENT
Language=English
ERROR_REC_NON_EXISTENT - The name does not exist in the WINS database.
.
Language=Russian
ERROR_REC_NON_EXISTENT - The name does not exist in the WINS database.
.
Language=Polish
ERROR_REC_NON_EXISTENT - Nazwa nie istnieje w bazie danych WINS.
.
Language=Romanian
ERROR_REC_NON_EXISTENT - The name does not exist in the WINS database.
.

MessageId=4006
Severity=Success
Facility=System
SymbolicName=ERROR_RPL_NOT_ALLOWED
Language=English
ERROR_RPL_NOT_ALLOWED - Replication with a nonconfigured partner is not allowed.
.
Language=Russian
ERROR_RPL_NOT_ALLOWED - Replication with a nonconfigured partner is not allowed.
.
Language=Polish
ERROR_RPL_NOT_ALLOWED - Replikowanie z nie skonfigurowanym partnerem jest niedozwolone.
.
Language=Romanian
ERROR_RPL_NOT_ALLOWED - Replication with a nonconfigured partner is not allowed.
.

MessageId=4100
Severity=Success
Facility=System
SymbolicName=ERROR_DHCP_ADDRESS_CONFLICT
Language=English
ERROR_DHCP_ADDRESS_CONFLICT - The DHCP client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address.
.
Language=Russian
ERROR_DHCP_ADDRESS_CONFLICT - The DHCP client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address.
.
Language=Polish
ERROR_DHCP_ADDRESS_CONFLICT - Klient DHCP otrzymał adres IP, który jest już używany w sieci. Lokalny interfejs zostanie wyłączony do chwili, gdy klient otrzyma nowy adres.
.
Language=Romanian
ERROR_DHCP_ADDRESS_CONFLICT - The DHCP client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address.
.

MessageId=4200
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_GUID_NOT_FOUND
Language=English
ERROR_WMI_GUID_NOT_FOUND - The GUID passed was not recognized as valid by a WMI data provider.
.
Language=Russian
ERROR_WMI_GUID_NOT_FOUND - The GUID passed was not recognized as valid by a WMI data provider.
.
Language=Polish
ERROR_WMI_GUID_NOT_FOUND - Przekazany identyfikator GUID nie został uznany przez dostawcę danych WMI za prawidłowy.
.
Language=Romanian
ERROR_WMI_GUID_NOT_FOUND - The GUID passed was not recognized as valid by a WMI data provider.
.

MessageId=4201
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_INSTANCE_NOT_FOUND
Language=English
ERROR_WMI_INSTANCE_NOT_FOUND - The instance name passed was not recognized as valid by a WMI data provider.
.
Language=Russian
ERROR_WMI_INSTANCE_NOT_FOUND - The instance name passed was not recognized as valid by a WMI data provider.
.
Language=Polish
ERROR_WMI_INSTANCE_NOT_FOUND - Przekazana nazwa wystąpienia nie została uznana przez dostawcę danych WMI za prawidłową.
.
Language=Romanian
ERROR_WMI_INSTANCE_NOT_FOUND - The instance name passed was not recognized as valid by a WMI data provider.
.

MessageId=4202
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_ITEMID_NOT_FOUND
Language=English
ERROR_WMI_ITEMID_NOT_FOUND - The data item ID passed was not recognized as valid by a WMI data provider.
.
Language=Russian
ERROR_WMI_ITEMID_NOT_FOUND - The data item ID passed was not recognized as valid by a WMI data provider.
.
Language=Polish
ERROR_WMI_ITEMID_NOT_FOUND - Przekazany identyfikator elementu danych nie został uznany przez dostawcę danych WMI za prawidłowy.
.
Language=Romanian
ERROR_WMI_ITEMID_NOT_FOUND - The data item ID passed was not recognized as valid by a WMI data provider.
.

MessageId=4203
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_TRY_AGAIN
Language=English
ERROR_WMI_TRY_AGAIN - The WMI request could not be completed and should be retried.
.
Language=Russian
ERROR_WMI_TRY_AGAIN - The WMI request could not be completed and should be retried.
.
Language=Polish
ERROR_WMI_TRY_AGAIN - Nie można ukończyć żądania WMI; należy je powtórzyć.
.
Language=Romanian
ERROR_WMI_TRY_AGAIN - The WMI request could not be completed and should be retried.
.

MessageId=4204
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_DP_NOT_FOUND
Language=English
ERROR_WMI_DP_NOT_FOUND - The WMI data provider could not be located.
.
Language=Russian
ERROR_WMI_DP_NOT_FOUND - The WMI data provider could not be located.
.
Language=Polish
ERROR_WMI_DP_NOT_FOUND - Nie można zlokalizować dostawcy danych WMI.
.
Language=Romanian
ERROR_WMI_DP_NOT_FOUND - The WMI data provider could not be located.
.

MessageId=4205
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_UNRESOLVED_INSTANCE_REF
Language=English
ERROR_WMI_UNRESOLVED_INSTANCE_REF - The WMI data provider references an instance set that has not been registered.
.
Language=Russian
ERROR_WMI_UNRESOLVED_INSTANCE_REF - The WMI data provider references an instance set that has not been registered.
.
Language=Polish
ERROR_WMI_UNRESOLVED_INSTANCE_REF - Dostawca danych WMI odwołuje się do zestawu wystąpień, który nie został zarejestrowany.
.
Language=Romanian
ERROR_WMI_UNRESOLVED_INSTANCE_REF - The WMI data provider references an instance set that has not been registered.
.

MessageId=4206
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_ALREADY_ENABLED
Language=English
ERROR_WMI_ALREADY_ENABLED - The WMI data block or event notification has already been enabled.
.
Language=Russian
ERROR_WMI_ALREADY_ENABLED - The WMI data block or event notification has already been enabled.
.
Language=Polish
ERROR_WMI_ALREADY_ENABLED - Blok danych WMI lub powiadamianie o zdarzeniach WMI jest już włączone.
.
Language=Romanian
ERROR_WMI_ALREADY_ENABLED - The WMI data block or event notification has already been enabled.
.

MessageId=4207
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_GUID_DISCONNECTED
Language=English
ERROR_WMI_GUID_DISCONNECTED - The WMI data block is no longer available.
.
Language=Russian
ERROR_WMI_GUID_DISCONNECTED - The WMI data block is no longer available.
.
Language=Polish
ERROR_WMI_GUID_DISCONNECTED - Blok danych WMI nie jest już dostępny.
.
Language=Romanian
ERROR_WMI_GUID_DISCONNECTED - The WMI data block is no longer available.
.

MessageId=4208
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_SERVER_UNAVAILABLE
Language=English
ERROR_WMI_SERVER_UNAVAILABLE - The WMI data service is not available.
.
Language=Russian
ERROR_WMI_SERVER_UNAVAILABLE - The WMI data service is not available.
.
Language=Polish
ERROR_WMI_SERVER_UNAVAILABLE - Usługa danych WMI nie jest dostępna.
.
Language=Romanian
ERROR_WMI_SERVER_UNAVAILABLE - The WMI data service is not available.
.

MessageId=4209
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_DP_FAILED
Language=English
ERROR_WMI_DP_FAILED - The WMI data provider failed to carry out the request.
.
Language=Russian
ERROR_WMI_DP_FAILED - The WMI data provider failed to carry out the request.
.
Language=Polish
ERROR_WMI_DP_FAILED - Dostawca danych WMI nie może spełnić żądania.
.
Language=Romanian
ERROR_WMI_DP_FAILED - The WMI data provider failed to carry out the request.
.

MessageId=4210
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_INVALID_MOF
Language=English
ERROR_WMI_INVALID_MOF - The WMI MOF information is not valid.
.
Language=Russian
ERROR_WMI_INVALID_MOF - The WMI MOF information is not valid.
.
Language=Polish
ERROR_WMI_INVALID_MOF - Informacje WMI MOF są nieprawidłowe.
.
Language=Romanian
ERROR_WMI_INVALID_MOF - The WMI MOF information is not valid.
.

MessageId=4211
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_INVALID_REGINFO
Language=English
ERROR_WMI_INVALID_REGINFO - The WMI registration information is not valid.
.
Language=Russian
ERROR_WMI_INVALID_REGINFO - The WMI registration information is not valid.
.
Language=Polish
ERROR_WMI_INVALID_REGINFO - Informacje rejestracyjne WMI są nieprawidłowe.
.
Language=Romanian
ERROR_WMI_INVALID_REGINFO - The WMI registration information is not valid.
.

MessageId=4212
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_ALREADY_DISABLED
Language=English
ERROR_WMI_ALREADY_DISABLED - The WMI data block or event notification has already been disabled.
.
Language=Russian
ERROR_WMI_ALREADY_DISABLED - The WMI data block or event notification has already been disabled.
.
Language=Polish
ERROR_WMI_ALREADY_DISABLED - Blok danych WMI lub powiadamianie o zdarzeniach WMI jest już wyłączone.
.
Language=Romanian
ERROR_WMI_ALREADY_DISABLED - The WMI data block or event notification has already been disabled.
.

MessageId=4213
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_READ_ONLY
Language=English
ERROR_WMI_READ_ONLY - The WMI data item or data block is read only.
.
Language=Russian
ERROR_WMI_READ_ONLY - The WMI data item or data block is read only.
.
Language=Polish
ERROR_WMI_READ_ONLY - Element danych WMI lub blok danych są tylko do odczytu.
.
Language=Romanian
ERROR_WMI_READ_ONLY - The WMI data item or data block is read only.
.

MessageId=4214
Severity=Success
Facility=System
SymbolicName=ERROR_WMI_SET_FAILURE
Language=English
ERROR_WMI_SET_FAILURE - The WMI data item or data block could not be changed.
.
Language=Russian
ERROR_WMI_SET_FAILURE - The WMI data item or data block could not be changed.
.
Language=Polish
ERROR_WMI_SET_FAILURE - Nie można zmienić elementu danych WMI lub bloku danych.
.
Language=Romanian
ERROR_WMI_SET_FAILURE - The WMI data item or data block could not be changed.
.

MessageId=4300
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MEDIA
Language=English
ERROR_INVALID_MEDIA - The media identifier does not represent a valid medium.
.
Language=Russian
ERROR_INVALID_MEDIA - The media identifier does not represent a valid medium.
.
Language=Polish
ERROR_INVALID_MEDIA - Identyfikator nośnika nie reprezentuje prawidłowej oczyszczarki.
.
Language=Romanian
ERROR_INVALID_MEDIA - The media identifier does not represent a valid medium.
.

MessageId=4301
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_LIBRARY
Language=English
ERROR_INVALID_LIBRARY - The library identifier does not represent a valid library.
.
Language=Russian
ERROR_INVALID_LIBRARY - The library identifier does not represent a valid library.
.
Language=Polish
ERROR_INVALID_LIBRARY - Identyfikator biblioteki nie reprezentuje prawidłowej biblioteki.
.
Language=Romanian
ERROR_INVALID_LIBRARY - The library identifier does not represent a valid library.
.

MessageId=4302
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_MEDIA_POOL
Language=English
ERROR_INVALID_MEDIA_POOL - The media pool identifier does not represent a valid media pool.
.
Language=Russian
ERROR_INVALID_MEDIA_POOL - The media pool identifier does not represent a valid media pool.
.
Language=Polish
ERROR_INVALID_MEDIA_POOL - Identyfikator zestawu nośników nie reprezentuje prawidłowej puli nośników.
.
Language=Romanian
ERROR_INVALID_MEDIA_POOL - The media pool identifier does not represent a valid media pool.
.

MessageId=4303
Severity=Success
Facility=System
SymbolicName=ERROR_DRIVE_MEDIA_MISMATCH
Language=English
ERROR_DRIVE_MEDIA_MISMATCH - The drive and medium are not compatible or exist in different libraries.
.
Language=Russian
ERROR_DRIVE_MEDIA_MISMATCH - The drive and medium are not compatible or exist in different libraries.
.
Language=Polish
ERROR_DRIVE_MEDIA_MISMATCH - Stacja i nośnik nie są zgodne lub znajdują się w innych bibliotekach.
.
Language=Romanian
ERROR_DRIVE_MEDIA_MISMATCH - The drive and medium are not compatible or exist in different libraries.
.

MessageId=4304
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_OFFLINE
Language=English
ERROR_MEDIA_OFFLINE - The medium currently exists in an offline library and must be online to perform this operation.
.
Language=Russian
ERROR_MEDIA_OFFLINE - The medium currently exists in an offline library and must be online to perform this operation.
.
Language=Polish
ERROR_MEDIA_OFFLINE - Nośnik znajduje się obecnie w bibliotece będącej w trybie offline. Aby ta operacja została wykonana, ta biblioteka musi być w trybie online.
.
Language=Romanian
ERROR_MEDIA_OFFLINE - The medium currently exists in an offline library and must be online to perform this operation.
.

MessageId=4305
Severity=Success
Facility=System
SymbolicName=ERROR_LIBRARY_OFFLINE
Language=English
ERROR_LIBRARY_OFFLINE - The operation cannot be performed on an offline library.
.
Language=Russian
ERROR_LIBRARY_OFFLINE - The operation cannot be performed on an offline library.
.
Language=Polish
ERROR_LIBRARY_OFFLINE - Nie można wykonać operacji na bibliotece będącej w trybie offline.
.
Language=Romanian
ERROR_LIBRARY_OFFLINE - The operation cannot be performed on an offline library.
.

MessageId=4306
Severity=Success
Facility=System
SymbolicName=ERROR_EMPTY
Language=English
ERROR_EMPTY - The library, drive, or media pool is empty.
.
Language=Russian
ERROR_EMPTY - The library, drive, or media pool is empty.
.
Language=Polish
ERROR_EMPTY - Biblioteka, stacja dysków lub pula nośników są puste.
.
Language=Romanian
ERROR_EMPTY - The library, drive, or media pool is empty.
.

MessageId=4307
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_EMPTY
Language=English
ERROR_NOT_EMPTY - The library, drive, or media pool must be empty to perform this operation.
.
Language=Russian
ERROR_NOT_EMPTY - The library, drive, or media pool must be empty to perform this operation.
.
Language=Polish
ERROR_NOT_EMPTY - Biblioteka, stacja dysków lub pula nośników muszą być puste, aby można było wykonać tę operację.
.
Language=Romanian
ERROR_NOT_EMPTY - The library, drive, or media pool must be empty to perform this operation.
.

MessageId=4308
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_UNAVAILABLE
Language=English
ERROR_MEDIA_UNAVAILABLE - No media is currently available in this media pool or library.
.
Language=Russian
ERROR_MEDIA_UNAVAILABLE - No media is currently available in this media pool or library.
.
Language=Polish
ERROR_MEDIA_UNAVAILABLE - Żaden nośnik nie jest obecnie dostępny w tej puli nośników lub w bibliotece.
.
Language=Romanian
ERROR_MEDIA_UNAVAILABLE - No media is currently available in this media pool or library.
.

MessageId=4309
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_DISABLED
Language=English
ERROR_RESOURCE_DISABLED - A resource required for this operation is disabled.
.
Language=Russian
ERROR_RESOURCE_DISABLED - A resource required for this operation is disabled.
.
Language=Polish
ERROR_RESOURCE_DISABLED - Zasób wymagany dla tej operacji jest wyłączony.
.
Language=Romanian
ERROR_RESOURCE_DISABLED - A resource required for this operation is disabled.
.

MessageId=4310
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_CLEANER
Language=English
ERROR_INVALID_CLEANER - The media identifier does not represent a valid cleaner.
.
Language=Russian
ERROR_INVALID_CLEANER - The media identifier does not represent a valid cleaner.
.
Language=Polish
ERROR_INVALID_CLEANER - Identyfikator nośnika nie reprezentuje prawidłowego nośnika czyszczącego.
.
Language=Romanian
ERROR_INVALID_CLEANER - The media identifier does not represent a valid cleaner.
.

MessageId=4311
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_CLEAN
Language=English
ERROR_UNABLE_TO_CLEAN - The drive cannot be cleaned or does not support cleaning.
.
Language=Russian
ERROR_UNABLE_TO_CLEAN - The drive cannot be cleaned or does not support cleaning.
.
Language=Polish
ERROR_UNABLE_TO_CLEAN - Nie można oczyścić stacji lub nie obsługuje ona funkcji czyszczenia.
.
Language=Romanian
ERROR_UNABLE_TO_CLEAN - The drive cannot be cleaned or does not support cleaning.
.

MessageId=4312
Severity=Success
Facility=System
SymbolicName=ERROR_OBJECT_NOT_FOUND
Language=English
ERROR_OBJECT_NOT_FOUND - The object identifier does not represent a valid object.
.
Language=Russian
ERROR_OBJECT_NOT_FOUND - The object identifier does not represent a valid object.
.
Language=Polish
ERROR_OBJECT_NOT_FOUND - Identyfikator obiektu nie reprezentuje prawidłowego obiektu.
.
Language=Romanian
ERROR_OBJECT_NOT_FOUND - The object identifier does not represent a valid object.
.

MessageId=4313
Severity=Success
Facility=System
SymbolicName=ERROR_DATABASE_FAILURE
Language=English
ERROR_DATABASE_FAILURE - Unable to read from or write to the database.
.
Language=Russian
ERROR_DATABASE_FAILURE - Unable to read from or write to the database.
.
Language=Polish
ERROR_DATABASE_FAILURE - Nie można odczytać z bazy danych lub do niej zapisać.
.
Language=Romanian
ERROR_DATABASE_FAILURE - Unable to read from or write to the database.
.

MessageId=4314
Severity=Success
Facility=System
SymbolicName=ERROR_DATABASE_FULL
Language=English
ERROR_DATABASE_FULL - The database is full.
.
Language=Russian
ERROR_DATABASE_FULL - The database is full.
.
Language=Polish
ERROR_DATABASE_FULL - Baza danych jest zapełniona.
.
Language=Romanian
ERROR_DATABASE_FULL - The database is full.
.

MessageId=4315
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_INCOMPATIBLE
Language=English
ERROR_MEDIA_INCOMPATIBLE - The medium is not compatible with the device or media pool.
.
Language=Russian
ERROR_MEDIA_INCOMPATIBLE - The medium is not compatible with the device or media pool.
.
Language=Polish
ERROR_MEDIA_INCOMPATIBLE - Nośnik nie jest zgodny z urządzeniem lub pulą nośników.
.
Language=Romanian
ERROR_MEDIA_INCOMPATIBLE - The medium is not compatible with the device or media pool.
.

MessageId=4316
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_NOT_PRESENT
Language=English
ERROR_RESOURCE_NOT_PRESENT - The resource required for this operation does not exist.
.
Language=Russian
ERROR_RESOURCE_NOT_PRESENT - The resource required for this operation does not exist.
.
Language=Polish
ERROR_RESOURCE_NOT_PRESENT - Wymagany dla tej operacji zasób nie istnieje.
.
Language=Romanian
ERROR_RESOURCE_NOT_PRESENT - The resource required for this operation does not exist.
.

MessageId=4317
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_OPERATION
Language=English
ERROR_INVALID_OPERATION - The operation identifier is not valid.
.
Language=Russian
ERROR_INVALID_OPERATION - The operation identifier is not valid.
.
Language=Polish
ERROR_INVALID_OPERATION - Identyfikator operacji jest nieprawidłowy.
.
Language=Romanian
ERROR_INVALID_OPERATION - The operation identifier is not valid.
.

MessageId=4318
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIA_NOT_AVAILABLE
Language=English
ERROR_MEDIA_NOT_AVAILABLE - The media is not mounted or ready for use.
.
Language=Russian
ERROR_MEDIA_NOT_AVAILABLE - The media is not mounted or ready for use.
.
Language=Polish
ERROR_MEDIA_NOT_AVAILABLE - Nośnik nie jest zainstalowany lub nie jest gotowy do użycia.
.
Language=Romanian
ERROR_MEDIA_NOT_AVAILABLE - The media is not mounted or ready for use.
.

MessageId=4319
Severity=Success
Facility=System
SymbolicName=ERROR_DEVICE_NOT_AVAILABLE
Language=English
ERROR_DEVICE_NOT_AVAILABLE - The device is not ready for use.
.
Language=Russian
ERROR_DEVICE_NOT_AVAILABLE - The device is not ready for use.
.
Language=Polish
ERROR_DEVICE_NOT_AVAILABLE - Urządzenie nie jest gotowe do użycia.
.
Language=Romanian
ERROR_DEVICE_NOT_AVAILABLE - The device is not ready for use.
.

MessageId=4320
Severity=Success
Facility=System
SymbolicName=ERROR_REQUEST_REFUSED
Language=English
ERROR_REQUEST_REFUSED - The operator or administrator has refused the request.
.
Language=Russian
ERROR_REQUEST_REFUSED - The operator or administrator has refused the request.
.
Language=Polish
ERROR_REQUEST_REFUSED - Operator lub administrator odrzucił żądanie.
.
Language=Romanian
ERROR_REQUEST_REFUSED - The operator or administrator has refused the request.
.

MessageId=4321
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_DRIVE_OBJECT
Language=English
ERROR_INVALID_DRIVE_OBJECT - The drive identifier does not represent a valid drive.
.
Language=Russian
ERROR_INVALID_DRIVE_OBJECT - The drive identifier does not represent a valid drive.
.
Language=Polish
ERROR_INVALID_DRIVE_OBJECT - Identyfikator stacji nie reprezentuje prawidłowej stacji.
.
Language=Romanian
ERROR_INVALID_DRIVE_OBJECT - The drive identifier does not represent a valid drive.
.

MessageId=4322
Severity=Success
Facility=System
SymbolicName=ERROR_LIBRARY_FULL
Language=English
ERROR_LIBRARY_FULL - Library is full. No slot is available for use.
.
Language=Russian
ERROR_LIBRARY_FULL - Library is full. No slot is available for use.
.
Language=Polish
ERROR_LIBRARY_FULL - Biblioteka jest zapełniona. Nie ma żadnego wolnego gniazda do użycia.
.
Language=Romanian
ERROR_LIBRARY_FULL - Library is full. No slot is available for use.
.

MessageId=4323
Severity=Success
Facility=System
SymbolicName=ERROR_MEDIUM_NOT_ACCESSIBLE
Language=English
ERROR_MEDIUM_NOT_ACCESSIBLE - The transport cannot access the medium.
.
Language=Russian
ERROR_MEDIUM_NOT_ACCESSIBLE - The transport cannot access the medium.
.
Language=Polish
ERROR_MEDIUM_NOT_ACCESSIBLE - Transport nie może uzyskać dostępu do nośnika.
.
Language=Romanian
ERROR_MEDIUM_NOT_ACCESSIBLE - The transport cannot access the medium.
.

MessageId=4324
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_LOAD_MEDIUM
Language=English
ERROR_UNABLE_TO_LOAD_MEDIUM - Unable to load the medium into the drive.
.
Language=Russian
ERROR_UNABLE_TO_LOAD_MEDIUM - Unable to load the medium into the drive.
.
Language=Polish
ERROR_UNABLE_TO_LOAD_MEDIUM - Nie można włożyć nośnika do stacji.
.
Language=Romanian
ERROR_UNABLE_TO_LOAD_MEDIUM - Unable to load the medium into the drive.
.

MessageId=4325
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_INVENTORY_DRIVE
Language=English
ERROR_UNABLE_TO_INVENTORY_DRIVE - Unable to retrieve status about the drive.
.
Language=Russian
ERROR_UNABLE_TO_INVENTORY_DRIVE - Unable to retrieve status about the drive.
.
Language=Polish
ERROR_UNABLE_TO_INVENTORY_DRIVE - Nie można pobrać danych o stanie stacji.
.
Language=Romanian
ERROR_UNABLE_TO_INVENTORY_DRIVE - Unable to retrieve status about the drive.
.

MessageId=4326
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_INVENTORY_SLOT
Language=English
ERROR_UNABLE_TO_INVENTORY_SLOT - Unable to retrieve status about the slot.
.
Language=Russian
ERROR_UNABLE_TO_INVENTORY_SLOT - Unable to retrieve status about the slot.
.
Language=Polish
ERROR_UNABLE_TO_INVENTORY_SLOT - Nie można pobrać danych o stanie gniazda.
.
Language=Romanian
ERROR_UNABLE_TO_INVENTORY_SLOT - Unable to retrieve status about the slot.
.

MessageId=4327
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_INVENTORY_TRANSPORT
Language=English
ERROR_UNABLE_TO_INVENTORY_TRANSPORT - Unable to retrieve status about the transport.
.
Language=Russian
ERROR_UNABLE_TO_INVENTORY_TRANSPORT - Unable to retrieve status about the transport.
.
Language=Polish
ERROR_UNABLE_TO_INVENTORY_TRANSPORT - Nie można pobrać danych o stanie transportu.
.
Language=Romanian
ERROR_UNABLE_TO_INVENTORY_TRANSPORT - Unable to retrieve status about the transport.
.

MessageId=4328
Severity=Success
Facility=System
SymbolicName=ERROR_TRANSPORT_FULL
Language=English
ERROR_TRANSPORT_FULL - Cannot use the transport because it is already in use.
.
Language=Russian
ERROR_TRANSPORT_FULL - Cannot use the transport because it is already in use.
.
Language=Polish
ERROR_TRANSPORT_FULL - Nie można użyć transportu, ponieważ jest już używany.
.
Language=Romanian
ERROR_TRANSPORT_FULL - Cannot use the transport because it is already in use.
.

MessageId=4329
Severity=Success
Facility=System
SymbolicName=ERROR_CONTROLLING_IEPORT
Language=English
ERROR_CONTROLLING_IEPORT - Unable to open or close the inject/eject port.
.
Language=Russian
ERROR_CONTROLLING_IEPORT - Unable to open or close the inject/eject port.
.
Language=Polish
ERROR_CONTROLLING_IEPORT - Nie można otworzyć lub zamknąć portu wsuwania/wysuwania.
.
Language=Romanian
ERROR_CONTROLLING_IEPORT - Unable to open or close the inject/eject port.
.

MessageId=4330
Severity=Success
Facility=System
SymbolicName=ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA
Language=English
ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA - Unable to eject the media because it is in a drive.
.
Language=Russian
ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA - Unable to eject the media because it is in a drive.
.
Language=Polish
ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA - Nie można wsunąć nośnika, ponieważ jest w stacji.
.
Language=Romanian
ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA - Unable to eject the media because it is in a drive.
.

MessageId=4331
Severity=Success
Facility=System
SymbolicName=ERROR_CLEANER_SLOT_SET
Language=English
ERROR_CLEANER_SLOT_SET - A cleaner slot is already reserved.
.
Language=Russian
ERROR_CLEANER_SLOT_SET - A cleaner slot is already reserved.
.
Language=Polish
ERROR_CLEANER_SLOT_SET - Gniazdo oczyszczarki jest już zarezerwowane.
.
Language=Romanian
ERROR_CLEANER_SLOT_SET - A cleaner slot is already reserved.
.

MessageId=4332
Severity=Success
Facility=System
SymbolicName=ERROR_CLEANER_SLOT_NOT_SET
Language=English
ERROR_CLEANER_SLOT_NOT_SET - A cleaner slot is not reserved.
.
Language=Russian
ERROR_CLEANER_SLOT_NOT_SET - A cleaner slot is not reserved.
.
Language=Polish
ERROR_CLEANER_SLOT_NOT_SET - Gniazdo oczyszczarki nie jest zarezerwowane.
.
Language=Romanian
ERROR_CLEANER_SLOT_NOT_SET - A cleaner slot is not reserved.
.

MessageId=4333
Severity=Success
Facility=System
SymbolicName=ERROR_CLEANER_CARTRIDGE_SPENT
Language=English
ERROR_CLEANER_CARTRIDGE_SPENT - The cleaner cartridge has performed the maximum number of drive cleanings.
.
Language=Russian
ERROR_CLEANER_CARTRIDGE_SPENT - The cleaner cartridge has performed the maximum number of drive cleanings.
.
Language=Polish
ERROR_CLEANER_CARTRIDGE_SPENT - Kaseta czyszcząca wykonała maksymalną liczbę operacji czyszczenia.
.
Language=Romanian
ERROR_CLEANER_CARTRIDGE_SPENT - The cleaner cartridge has performed the maximum number of drive cleanings.
.

MessageId=4334
Severity=Success
Facility=System
SymbolicName=ERROR_UNEXPECTED_OMID
Language=English
ERROR_UNEXPECTED_OMID - Unexpected on-medium identifier.
.
Language=Russian
ERROR_UNEXPECTED_OMID - Unexpected on-medium identifier.
.
Language=Polish
ERROR_UNEXPECTED_OMID - Nieoczekiwany identyfikator nośnika.
.
Language=Romanian
ERROR_UNEXPECTED_OMID - Unexpected on-medium identifier.
.

MessageId=4335
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_DELETE_LAST_ITEM
Language=English
ERROR_CANT_DELETE_LAST_ITEM - The last remaining item in this group or resource cannot be deleted.
.
Language=Russian
ERROR_CANT_DELETE_LAST_ITEM - The last remaining item in this group or resource cannot be deleted.
.
Language=Polish
ERROR_CANT_DELETE_LAST_ITEM - Nie można usunąć ostatniego pozostałego elementu z tej grupy lub nie można usunąć ostatniego pozostałego zasobu.
.
Language=Romanian
ERROR_CANT_DELETE_LAST_ITEM - The last remaining item in this group or resource cannot be deleted.
.

MessageId=4336
Severity=Success
Facility=System
SymbolicName=ERROR_MESSAGE_EXCEEDS_MAX_SIZE
Language=English
ERROR_MESSAGE_EXCEEDS_MAX_SIZE - The message provided exceeds the maximum size allowed for this parameter.
.
Language=Russian
ERROR_MESSAGE_EXCEEDS_MAX_SIZE - The message provided exceeds the maximum size allowed for this parameter.
.
Language=Polish
ERROR_MESSAGE_EXCEEDS_MAX_SIZE - Dostarczony komunikat przekracza maksymalny rozmiar dozwolony dla tego parametru.
.
Language=Romanian
ERROR_MESSAGE_EXCEEDS_MAX_SIZE - The message provided exceeds the maximum size allowed for this parameter.
.

MessageId=4337
Severity=Success
Facility=System
SymbolicName=ERROR_VOLUME_CONTAINS_SYS_FILES
Language=English
ERROR_VOLUME_CONTAINS_SYS_FILES - The volume contains system or paging files.
.
Language=Russian
ERROR_VOLUME_CONTAINS_SYS_FILES - The volume contains system or paging files.
.
Language=Polish
ERROR_VOLUME_CONTAINS_SYS_FILES - Wolumin zawiera pliki systemowe lub pliki stronicowania.
.
Language=Romanian
ERROR_VOLUME_CONTAINS_SYS_FILES - The volume contains system or paging files.
.

MessageId=4338
Severity=Success
Facility=System
SymbolicName=ERROR_INDIGENOUS_TYPE
Language=English
ERROR_INDIGENOUS_TYPE - The media type cannot be removed from this library since at least one drive in the library reports it can support this media type.
.
Language=Russian
ERROR_INDIGENOUS_TYPE - The media type cannot be removed from this library since at least one drive in the library reports it can support this media type.
.
Language=Polish
ERROR_INDIGENOUS_TYPE - Nie można usunąć tego typu nośnika z tej biblioteki, ponieważ co najmniej jedna stacja z tej biblioteki sygnalizuje, że obsługuje ten typ nośnika.
.
Language=Romanian
ERROR_INDIGENOUS_TYPE - The media type cannot be removed from this library since at least one drive in the library reports it can support this media type.
.

MessageId=4339
Severity=Success
Facility=System
SymbolicName=ERROR_NO_SUPPORTING_DRIVES
Language=English
ERROR_NO_SUPPORTING_DRIVES - This offline media cannot be mounted on this system since no enabled drives are present which can be used.
.
Language=Russian
ERROR_NO_SUPPORTING_DRIVES - This offline media cannot be mounted on this system since no enabled drives are present which can be used.
.
Language=Polish
ERROR_NO_SUPPORTING_DRIVES - Nośnik pracujący w trybie offline nie może być zainstalowany w tym systemie, ponieważ nie są włączone żadne stacje, których można by użyć.
.
Language=Romanian
ERROR_NO_SUPPORTING_DRIVES - This offline media cannot be mounted on this system since no enabled drives are present which can be used.
.

MessageId=4340
Severity=Success
Facility=System
SymbolicName=ERROR_CLEANER_CARTRIDGE_INSTALLED
Language=English
ERROR_CLEANER_CARTRIDGE_INSTALLED - A cleaner cartridge is present in the tape library.
.
Language=Russian
ERROR_CLEANER_CARTRIDGE_INSTALLED - A cleaner cartridge is present in the tape library.
.
Language=Polish
ERROR_CLEANER_CARTRIDGE_INSTALLED - Kaseta czyszcząca znajduje się w bibliotece taśm.
.
Language=Romanian
ERROR_CLEANER_CARTRIDGE_INSTALLED - A cleaner cartridge is present in the tape library.
.

MessageId=4350
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_OFFLINE
Language=English
ERROR_FILE_OFFLINE - The remote storage service was not able to recall the file.
.
Language=Russian
ERROR_FILE_OFFLINE - The remote storage service was not able to recall the file.
.
Language=Polish
ERROR_FILE_OFFLINE - The remote storage service was not able to recall the file.
.
Language=Romanian
ERROR_FILE_OFFLINE - The remote storage service was not able to recall the file.
.

MessageId=4351
Severity=Success
Facility=System
SymbolicName=ERROR_REMOTE_STORAGE_NOT_ACTIVE
Language=English
ERROR_REMOTE_STORAGE_NOT_ACTIVE - The remote storage service is not operational at this time.
.
Language=Russian
ERROR_REMOTE_STORAGE_NOT_ACTIVE - The remote storage service is not operational at this time.
.
Language=Polish
ERROR_REMOTE_STORAGE_NOT_ACTIVE - Usługa Magazyn zdalny teraz nie działa.
.
Language=Romanian
ERROR_REMOTE_STORAGE_NOT_ACTIVE - The remote storage service is not operational at this time.
.

MessageId=4352
Severity=Success
Facility=System
SymbolicName=ERROR_REMOTE_STORAGE_MEDIA_ERROR
Language=English
ERROR_REMOTE_STORAGE_MEDIA_ERROR - The remote storage service encountered a media error.
.
Language=Russian
ERROR_REMOTE_STORAGE_MEDIA_ERROR - The remote storage service encountered a media error.
.
Language=Polish
ERROR_REMOTE_STORAGE_MEDIA_ERROR - Usługa Magazyn zdalny napotkała błąd nośnika.
.
Language=Romanian
ERROR_REMOTE_STORAGE_MEDIA_ERROR - The remote storage service encountered a media error.
.

MessageId=4390
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_A_REPARSE_POINT
Language=English
ERROR_NOT_A_REPARSE_POINT - The file or directory is not a reparse point.
.
Language=Russian
ERROR_NOT_A_REPARSE_POINT - The file or directory is not a reparse point.
.
Language=Polish
ERROR_NOT_A_REPARSE_POINT - Plik lub katalog nie jest punktem ponownej analizy.
.
Language=Romanian
ERROR_NOT_A_REPARSE_POINT - The file or directory is not a reparse point.
.

MessageId=4391
Severity=Success
Facility=System
SymbolicName=ERROR_REPARSE_ATTRIBUTE_CONFLICT
Language=English
ERROR_REPARSE_ATTRIBUTE_CONFLICT - The reparse point attribute cannot be set because it conflicts with an existing attribute.
.
Language=Russian
ERROR_REPARSE_ATTRIBUTE_CONFLICT - The reparse point attribute cannot be set because it conflicts with an existing attribute.
.
Language=Polish
ERROR_REPARSE_ATTRIBUTE_CONFLICT - Nie można ustawić atrybutu punktu ponownej analizy, ponieważ wchodzi w konflikt z istniejącym atrybutem.
.
Language=Romanian
ERROR_REPARSE_ATTRIBUTE_CONFLICT - The reparse point attribute cannot be set because it conflicts with an existing attribute.
.

MessageId=4392
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_REPARSE_DATA
Language=English
ERROR_INVALID_REPARSE_DATA - The data present in the reparse point buffer is invalid.
.
Language=Russian
ERROR_INVALID_REPARSE_DATA - The data present in the reparse point buffer is invalid.
.
Language=Polish
ERROR_INVALID_REPARSE_DATA - Dane występujące w buforze punktu ponownej analizy są nieprawidłowe.
.
Language=Romanian
ERROR_INVALID_REPARSE_DATA - The data present in the reparse point buffer is invalid.
.

MessageId=4393
Severity=Success
Facility=System
SymbolicName=ERROR_REPARSE_TAG_INVALID
Language=English
ERROR_REPARSE_TAG_INVALID - The tag present in the reparse point buffer is invalid.
.
Language=Russian
ERROR_REPARSE_TAG_INVALID - The tag present in the reparse point buffer is invalid.
.
Language=Polish
ERROR_REPARSE_TAG_INVALID - Etykieta występująca w buforze punktu ponownej analizy jest nieprawidłowa.
.
Language=Romanian
ERROR_REPARSE_TAG_INVALID - The tag present in the reparse point buffer is invalid.
.

MessageId=4394
Severity=Success
Facility=System
SymbolicName=ERROR_REPARSE_TAG_MISMATCH
Language=English
ERROR_REPARSE_TAG_MISMATCH - There is a mismatch between the tag specified in the request and the tag present in the reparse point.
.
Language=Russian
ERROR_REPARSE_TAG_MISMATCH - There is a mismatch between the tag specified in the request and the tag present in the reparse point.
.
Language=Polish
ERROR_REPARSE_TAG_MISMATCH - Istnieje niezgodność między etykietą podaną w żądaniu, a etykietą występującą w punkcie ponownej analizy.
.
Language=Romanian
ERROR_REPARSE_TAG_MISMATCH - There is a mismatch between the tag specified in the request and the tag present in the reparse point.
.

MessageId=4500
Severity=Success
Facility=System
SymbolicName=ERROR_VOLUME_NOT_SIS_ENABLED
Language=English
ERROR_VOLUME_NOT_SIS_ENABLED - Single Instance Storage is not available on this volume.
.
Language=Russian
ERROR_VOLUME_NOT_SIS_ENABLED - Single Instance Storage is not available on this volume.
.
Language=Polish
ERROR_VOLUME_NOT_SIS_ENABLED - Wolumin ten nie może być woluminem typu SIS (Single Instance Storage).
.
Language=Romanian
ERROR_VOLUME_NOT_SIS_ENABLED - Single Instance Storage is not available on this volume.
.

MessageId=5001
Severity=Success
Facility=System
SymbolicName=ERROR_DEPENDENT_RESOURCE_EXISTS
Language=English
ERROR_DEPENDENT_RESOURCE_EXISTS - The cluster resource cannot be moved to another group because other resources are dependent on it.
.
Language=Russian
ERROR_DEPENDENT_RESOURCE_EXISTS - The cluster resource cannot be moved to another group because other resources are dependent on it.
.
Language=Polish
ERROR_DEPENDENT_RESOURCE_EXISTS - The cluster resource cannot be moved to another group because other resources are dependent on it.
.
Language=Romanian
ERROR_DEPENDENT_RESOURCE_EXISTS - The cluster resource cannot be moved to another group because other resources are dependent on it.
.

MessageId=5002
Severity=Success
Facility=System
SymbolicName=ERROR_DEPENDENCY_NOT_FOUND
Language=English
ERROR_DEPENDENCY_NOT_FOUND - The cluster resource dependency cannot be found.
.
Language=Russian
ERROR_DEPENDENCY_NOT_FOUND - The cluster resource dependency cannot be found.
.
Language=Polish
ERROR_DEPENDENCY_NOT_FOUND - Nie można znaleźć zależności zasobów klastra.
.
Language=Romanian
ERROR_DEPENDENCY_NOT_FOUND - The cluster resource dependency cannot be found.
.

MessageId=5003
Severity=Success
Facility=System
SymbolicName=ERROR_DEPENDENCY_ALREADY_EXISTS
Language=English
ERROR_DEPENDENCY_ALREADY_EXISTS - The cluster resource cannot be made dependent on the specified resource because it is already dependent.
.
Language=Russian
ERROR_DEPENDENCY_ALREADY_EXISTS - The cluster resource cannot be made dependent on the specified resource because it is already dependent.
.
Language=Polish
ERROR_DEPENDENCY_ALREADY_EXISTS - Nie można uczynić zasobu klastra zależnym od podanego zasobu, ponieważ jest on już zależny.
.
Language=Romanian
ERROR_DEPENDENCY_ALREADY_EXISTS - The cluster resource cannot be made dependent on the specified resource because it is already dependent.
.

MessageId=5004
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_NOT_ONLINE
Language=English
ERROR_RESOURCE_NOT_ONLINE - The cluster resource is not online.
.
Language=Russian
ERROR_RESOURCE_NOT_ONLINE - The cluster resource is not online.
.
Language=Polish
ERROR_RESOURCE_NOT_ONLINE - Zasób klastra nie jest w trybie online.
.
Language=Romanian
ERROR_RESOURCE_NOT_ONLINE - The cluster resource is not online.
.

MessageId=5005
Severity=Success
Facility=System
SymbolicName=ERROR_HOST_NODE_NOT_AVAILABLE
Language=English
ERROR_HOST_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.
Language=Russian
ERROR_HOST_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.
Language=Polish
ERROR_HOST_NODE_NOT_AVAILABLE - Węzeł klastra nie jest dostępny dla tej operacji.
.
Language=Romanian
ERROR_HOST_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.

MessageId=5006
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_NOT_AVAILABLE
Language=English
ERROR_RESOURCE_NOT_AVAILABLE - The cluster resource is not available.
.
Language=Russian
ERROR_RESOURCE_NOT_AVAILABLE - The cluster resource is not available.
.
Language=Polish
ERROR_RESOURCE_NOT_AVAILABLE - Zasób klastra nie jest dostępny.
.
Language=Romanian
ERROR_RESOURCE_NOT_AVAILABLE - The cluster resource is not available.
.

MessageId=5007
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_NOT_FOUND
Language=English
ERROR_RESOURCE_NOT_FOUND - The cluster resource could not be found.
.
Language=Russian
ERROR_RESOURCE_NOT_FOUND - The cluster resource could not be found.
.
Language=Polish
ERROR_RESOURCE_NOT_FOUND - Nie można znaleźć zasobu klastra.
.
Language=Romanian
ERROR_RESOURCE_NOT_FOUND - The cluster resource could not be found.
.

MessageId=5008
Severity=Success
Facility=System
SymbolicName=ERROR_SHUTDOWN_CLUSTER
Language=English
ERROR_SHUTDOWN_CLUSTER - The cluster is being shut down.
.
Language=Russian
ERROR_SHUTDOWN_CLUSTER - The cluster is being shut down.
.
Language=Polish
ERROR_SHUTDOWN_CLUSTER - Trwa zamykanie klastra.
.
Language=Romanian
ERROR_SHUTDOWN_CLUSTER - The cluster is being shut down.
.

MessageId=5009
Severity=Success
Facility=System
SymbolicName=ERROR_CANT_EVICT_ACTIVE_NODE
Language=English
ERROR_CANT_EVICT_ACTIVE_NODE - A cluster node cannot be evicted from the cluster unless the node is down.
.
Language=Russian
ERROR_CANT_EVICT_ACTIVE_NODE - A cluster node cannot be evicted from the cluster unless the node is down.
.
Language=Polish
ERROR_CANT_EVICT_ACTIVE_NODE - Węzła klastra nie można wykluczyć z klastra, chyba że węzeł nie działa.
.
Language=Romanian
ERROR_CANT_EVICT_ACTIVE_NODE - A cluster node cannot be evicted from the cluster unless the node is down.
.

MessageId=5010
Severity=Success
Facility=System
SymbolicName=ERROR_OBJECT_ALREADY_EXISTS
Language=English
ERROR_OBJECT_ALREADY_EXISTS - The object already exists.
.
Language=Russian
ERROR_OBJECT_ALREADY_EXISTS - The object already exists.
.
Language=Polish
ERROR_OBJECT_ALREADY_EXISTS - Obiekt już istnieje.
.
Language=Romanian
ERROR_OBJECT_ALREADY_EXISTS - The object already exists.
.

MessageId=5011
Severity=Success
Facility=System
SymbolicName=ERROR_OBJECT_IN_LIST
Language=English
ERROR_OBJECT_IN_LIST - The object is already in the list.
.
Language=Russian
ERROR_OBJECT_IN_LIST - The object is already in the list.
.
Language=Polish
ERROR_OBJECT_IN_LIST - Obiekt już występuje na liście.
.
Language=Romanian
ERROR_OBJECT_IN_LIST - The object is already in the list.
.

MessageId=5012
Severity=Success
Facility=System
SymbolicName=ERROR_GROUP_NOT_AVAILABLE
Language=English
ERROR_GROUP_NOT_AVAILABLE - The cluster group is not available for any new requests.
.
Language=Russian
ERROR_GROUP_NOT_AVAILABLE - The cluster group is not available for any new requests.
.
Language=Polish
ERROR_GROUP_NOT_AVAILABLE - Grupa klastrów nie jest dostępna dla żadnych nowych żądań.
.
Language=Romanian
ERROR_GROUP_NOT_AVAILABLE - The cluster group is not available for any new requests.
.

MessageId=5013
Severity=Success
Facility=System
SymbolicName=ERROR_GROUP_NOT_FOUND
Language=English
ERROR_GROUP_NOT_FOUND - The cluster group could not be found.
.
Language=Russian
ERROR_GROUP_NOT_FOUND - The cluster group could not be found.
.
Language=Polish
ERROR_GROUP_NOT_FOUND - Nie można znaleźć grupy klastrów.
.
Language=Romanian
ERROR_GROUP_NOT_FOUND - The cluster group could not be found.
.

MessageId=5014
Severity=Success
Facility=System
SymbolicName=ERROR_GROUP_NOT_ONLINE
Language=English
ERROR_GROUP_NOT_ONLINE - The operation could not be completed because the cluster group is not online.
.
Language=Russian
ERROR_GROUP_NOT_ONLINE - The operation could not be completed because the cluster group is not online.
.
Language=Polish
ERROR_GROUP_NOT_ONLINE - Nie można ukończyć operacji, ponieważ grupa klastrów nie pracuje w trybie online.
.
Language=Romanian
ERROR_GROUP_NOT_ONLINE - The operation could not be completed because the cluster group is not online.
.

MessageId=5015
Severity=Success
Facility=System
SymbolicName=ERROR_HOST_NODE_NOT_RESOURCE_OWNER
Language=English
ERROR_HOST_NODE_NOT_RESOURCE_OWNER - The cluster node is not the owner of the resource.
.
Language=Russian
ERROR_HOST_NODE_NOT_RESOURCE_OWNER - The cluster node is not the owner of the resource.
.
Language=Polish
ERROR_HOST_NODE_NOT_RESOURCE_OWNER - Określony węzeł klastra nie jest właścicielem zasobu.
.
Language=Romanian
ERROR_HOST_NODE_NOT_RESOURCE_OWNER - The cluster node is not the owner of the resource.
.

MessageId=5016
Severity=Success
Facility=System
SymbolicName=ERROR_HOST_NODE_NOT_GROUP_OWNER
Language=English
ERROR_HOST_NODE_NOT_GROUP_OWNER - The cluster node is not the owner of the group.
.
Language=Russian
ERROR_HOST_NODE_NOT_GROUP_OWNER - The cluster node is not the owner of the group.
.
Language=Polish
ERROR_HOST_NODE_NOT_GROUP_OWNER - Określony węzeł klastra nie jest właścicielem zasobu.
.
Language=Romanian
ERROR_HOST_NODE_NOT_GROUP_OWNER - The cluster node is not the owner of the group.
.

MessageId=5017
Severity=Success
Facility=System
SymbolicName=ERROR_RESMON_CREATE_FAILED
Language=English
ERROR_RESMON_CREATE_FAILED - The cluster resource could not be created in the specified resource monitor.
.
Language=Russian
ERROR_RESMON_CREATE_FAILED - The cluster resource could not be created in the specified resource monitor.
.
Language=Polish
ERROR_RESMON_CREATE_FAILED - Nie można utworzyć zasobu klastra za pomocą podanego monitora zasobów.
.
Language=Romanian
ERROR_RESMON_CREATE_FAILED - The cluster resource could not be created in the specified resource monitor.
.

MessageId=5018
Severity=Success
Facility=System
SymbolicName=ERROR_RESMON_ONLINE_FAILED
Language=English
ERROR_RESMON_ONLINE_FAILED - The cluster resource could not be brought online by the resource monitor.
.
Language=Russian
ERROR_RESMON_ONLINE_FAILED - The cluster resource could not be brought online by the resource monitor.
.
Language=Polish
ERROR_RESMON_ONLINE_FAILED - Nie można przełączyć zasobu klastra do trybu online za pomocą monitora zasobów.
.
Language=Romanian
ERROR_RESMON_ONLINE_FAILED - The cluster resource could not be brought online by the resource monitor.
.

MessageId=5019
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_ONLINE
Language=English
ERROR_RESOURCE_ONLINE - The operation could not be completed because the cluster resource is online.
.
Language=Russian
ERROR_RESOURCE_ONLINE - The operation could not be completed because the cluster resource is online.
.
Language=Polish
ERROR_RESOURCE_ONLINE - Nie można ukończyć operacji, ponieważ zasób klastra jest w trybie online.
.
Language=Romanian
ERROR_RESOURCE_ONLINE - The operation could not be completed because the cluster resource is online.
.

MessageId=5020
Severity=Success
Facility=System
SymbolicName=ERROR_QUORUM_RESOURCE
Language=English
ERROR_QUORUM_RESOURCE - The cluster resource could not be deleted or brought offline because it is the quorum resource.
.
Language=Russian
ERROR_QUORUM_RESOURCE - The cluster resource could not be deleted or brought offline because it is the quorum resource.
.
Language=Polish
ERROR_QUORUM_RESOURCE - Nie można usunąć zasobu klastra ani przełączyć go do trybu offline, ponieważ jest to zasób kworum.
.
Language=Romanian
ERROR_QUORUM_RESOURCE - The cluster resource could not be deleted or brought offline because it is the quorum resource.
.

MessageId=5021
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_QUORUM_CAPABLE
Language=English
ERROR_NOT_QUORUM_CAPABLE - The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.
.
Language=Russian
ERROR_NOT_QUORUM_CAPABLE - The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.
.
Language=Polish
ERROR_NOT_QUORUM_CAPABLE - Klaster nie może uczynić podanego zasobu zasobem kworum, ponieważ nie ma on możliwości bycia nim.
.
Language=Romanian
ERROR_NOT_QUORUM_CAPABLE - The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.
.

MessageId=5022
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_SHUTTING_DOWN
Language=English
ERROR_CLUSTER_SHUTTING_DOWN - The cluster software is shutting down.
.
Language=Russian
ERROR_CLUSTER_SHUTTING_DOWN - The cluster software is shutting down.
.
Language=Polish
ERROR_CLUSTER_SHUTTING_DOWN - Trwa zamykanie oprogramowania klastra.
.
Language=Romanian
ERROR_CLUSTER_SHUTTING_DOWN - The cluster software is shutting down.
.

MessageId=5023
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_STATE
Language=English
ERROR_INVALID_STATE - The group or resource is not in the correct state to perform the requested operation.
.
Language=Russian
ERROR_INVALID_STATE - The group or resource is not in the correct state to perform the requested operation.
.
Language=Polish
ERROR_INVALID_STATE - Grupa lub zasób nie jest w odpowiednim stanie, aby można było wykonać żądaną operację.
.
Language=Romanian
ERROR_INVALID_STATE - The group or resource is not in the correct state to perform the requested operation.
.

MessageId=5024
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_PROPERTIES_STORED
Language=English
ERROR_RESOURCE_PROPERTIES_STORED - The properties were stored but not all changes will take effect until the next time the resource is brought online.
.
Language=Russian
ERROR_RESOURCE_PROPERTIES_STORED - The properties were stored but not all changes will take effect until the next time the resource is brought online.
.
Language=Polish
ERROR_RESOURCE_PROPERTIES_STORED - Właściwości zostały zapisane, lecz niektóre zmiany zostaną wprowadzone dopiero wtedy, gdy zasób zostanie ponownie przełączony do trybu online.
.
Language=Romanian
ERROR_RESOURCE_PROPERTIES_STORED - The properties were stored but not all changes will take effect until the next time the resource is brought online.
.

MessageId=5025
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_QUORUM_CLASS
Language=English
ERROR_NOT_QUORUM_CLASS - The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.
.
Language=Russian
ERROR_NOT_QUORUM_CLASS - The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.
.
Language=Polish
ERROR_NOT_QUORUM_CLASS - Klaster nie może uczynić podanego zasobu zasobem kworum, ponieważ nie należy on do współdzielonej klasy magazynów.
.
Language=Romanian
ERROR_NOT_QUORUM_CLASS - The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.
.

MessageId=5026
Severity=Success
Facility=System
SymbolicName=ERROR_CORE_RESOURCE
Language=English
ERROR_CORE_RESOURCE - The cluster resource could not be deleted since it is a core resource.
.
Language=Russian
ERROR_CORE_RESOURCE - The cluster resource could not be deleted since it is a core resource.
.
Language=Polish
ERROR_CORE_RESOURCE - Nie można usunąć zasobu klastra, ponieważ jest to zasób główny.
.
Language=Romanian
ERROR_CORE_RESOURCE - The cluster resource could not be deleted since it is a core resource.
.

MessageId=5027
Severity=Success
Facility=System
SymbolicName=ERROR_QUORUM_RESOURCE_ONLINE_FAILED
Language=English
ERROR_QUORUM_RESOURCE_ONLINE_FAILED - The quorum resource failed to come online.
.
Language=Russian
ERROR_QUORUM_RESOURCE_ONLINE_FAILED - The quorum resource failed to come online.
.
Language=Polish
ERROR_QUORUM_RESOURCE_ONLINE_FAILED - Nie udało się przełączyć zasobu kworum do trybu online.
.
Language=Romanian
ERROR_QUORUM_RESOURCE_ONLINE_FAILED - The quorum resource failed to come online.
.

MessageId=5028
Severity=Success
Facility=System
SymbolicName=ERROR_QUORUMLOG_OPEN_FAILED
Language=English
ERROR_QUORUMLOG_OPEN_FAILED - The quorum log could not be created or mounted successfully.
.
Language=Russian
ERROR_QUORUMLOG_OPEN_FAILED - The quorum log could not be created or mounted successfully.
.
Language=Polish
ERROR_QUORUMLOG_OPEN_FAILED - Nie można utworzyć lub pomyślnie zainstalować dziennika kworum.
.
Language=Romanian
ERROR_QUORUMLOG_OPEN_FAILED - The quorum log could not be created or mounted successfully.
.

MessageId=5029
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTERLOG_CORRUPT
Language=English
ERROR_CLUSTERLOG_CORRUPT - The cluster log is corrupt.
.
Language=Russian
ERROR_CLUSTERLOG_CORRUPT - The cluster log is corrupt.
.
Language=Polish
ERROR_CLUSTERLOG_CORRUPT - Dziennik klastrów jest uszkodzony.
.
Language=Romanian
ERROR_CLUSTERLOG_CORRUPT - The cluster log is corrupt.
.

MessageId=5030
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE
Language=English
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE - The record could not be written to the cluster log since it exceeds the maximum size.
.
Language=Russian
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE - The record could not be written to the cluster log since it exceeds the maximum size.
.
Language=Polish
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE - Nie można zapisać rekordu do dziennika klastrów, ponieważ wielkość rekordu przekracza maksymalny rozmiar.
.
Language=Romanian
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE - The record could not be written to the cluster log since it exceeds the maximum size.
.

MessageId=5031
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE
Language=English
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE - The cluster log exceeds its maximum size.
.
Language=Russian
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE - The cluster log exceeds its maximum size.
.
Language=Polish
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE - Dziennik klastrów przekracza maksymalny rozmiar.
.
Language=Romanian
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE - The cluster log exceeds its maximum size.
.

MessageId=5032
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND
Language=English
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND - No checkpoint record was found in the cluster log.
.
Language=Russian
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND - No checkpoint record was found in the cluster log.
.
Language=Polish
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND - W dzienniku klastrów nie znaleziono żadnego rekordu punktu kontrolnego.
.
Language=Romanian
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND - No checkpoint record was found in the cluster log.
.

MessageId=5033
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE
Language=English
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE - The minimum required disk space needed for logging is not available.
.
Language=Russian
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE - The minimum required disk space needed for logging is not available.
.
Language=Polish
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE - Nie jest dostępna minimalna ilość miejsca wymagana do rejestrowania w dzienniku.
.
Language=Romanian
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE - The minimum required disk space needed for logging is not available.
.

MessageId=5034
Severity=Success
Facility=System
SymbolicName=ERROR_QUORUM_OWNER_ALIVE
Language=English
ERROR_QUORUM_OWNER_ALIVE - The cluster node failed to take control of the quorum resource because the resource is owned by another active node.
.
Language=Russian
ERROR_QUORUM_OWNER_ALIVE - The cluster node failed to take control of the quorum resource because the resource is owned by another active node.
.
Language=Polish
ERROR_QUORUM_OWNER_ALIVE - Węzeł klastra nie może przejąć kontroli nad zasobem kworum, ponieważ zasób ten jest posiadany przez inny aktywny węzeł.
.
Language=Romanian
ERROR_QUORUM_OWNER_ALIVE - The cluster node failed to take control of the quorum resource because the resource is owned by another active node.
.

MessageId=5035
Severity=Success
Facility=System
SymbolicName=ERROR_NETWORK_NOT_AVAILABLE
Language=English
ERROR_NETWORK_NOT_AVAILABLE - A cluster network is not available for this operation.
.
Language=Russian
ERROR_NETWORK_NOT_AVAILABLE - A cluster network is not available for this operation.
.
Language=Polish
ERROR_NETWORK_NOT_AVAILABLE - Sieć klastrów nie jest dostępna dla tej operacji.
.
Language=Romanian
ERROR_NETWORK_NOT_AVAILABLE - A cluster network is not available for this operation.
.

MessageId=5036
Severity=Success
Facility=System
SymbolicName=ERROR_NODE_NOT_AVAILABLE
Language=English
ERROR_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.
Language=Russian
ERROR_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.
Language=Polish
ERROR_NODE_NOT_AVAILABLE - Węzeł klastra nie jest dostępny dla tej operacji.
.
Language=Romanian
ERROR_NODE_NOT_AVAILABLE - A cluster node is not available for this operation.
.

MessageId=5037
Severity=Success
Facility=System
SymbolicName=ERROR_ALL_NODES_NOT_AVAILABLE
Language=English
ERROR_ALL_NODES_NOT_AVAILABLE - All cluster nodes must be running to perform this operation.
.
Language=Russian
ERROR_ALL_NODES_NOT_AVAILABLE - All cluster nodes must be running to perform this operation.
.
Language=Polish
ERROR_ALL_NODES_NOT_AVAILABLE - Aby można było wykonać tę operację, muszą być uruchomione wszystkie węzły klastra.
.
Language=Romanian
ERROR_ALL_NODES_NOT_AVAILABLE - All cluster nodes must be running to perform this operation.
.

MessageId=5038
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_FAILED
Language=English
ERROR_RESOURCE_FAILED - A cluster resource failed.
.
Language=Russian
ERROR_RESOURCE_FAILED - A cluster resource failed.
.
Language=Polish
ERROR_RESOURCE_FAILED - Błąd zasobu klastra.
.
Language=Romanian
ERROR_RESOURCE_FAILED - A cluster resource failed.
.

MessageId=5039
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INVALID_NODE
Language=English
ERROR_CLUSTER_INVALID_NODE - The cluster node is not valid.
.
Language=Russian
ERROR_CLUSTER_INVALID_NODE - The cluster node is not valid.
.
Language=Polish
ERROR_CLUSTER_INVALID_NODE - Węzeł klastra jest nieprawidłowy.
.
Language=Romanian
ERROR_CLUSTER_INVALID_NODE - The cluster node is not valid.
.

MessageId=5040
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_EXISTS
Language=English
ERROR_CLUSTER_NODE_EXISTS - The cluster node already exists.
.
Language=Russian
ERROR_CLUSTER_NODE_EXISTS - The cluster node already exists.
.
Language=Polish
ERROR_CLUSTER_NODE_EXISTS - Węzeł klastra już istnieje.
.
Language=Romanian
ERROR_CLUSTER_NODE_EXISTS - The cluster node already exists.
.

MessageId=5041
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_JOIN_IN_PROGRESS
Language=English
ERROR_CLUSTER_JOIN_IN_PROGRESS - A node is in the process of joining the cluster.
.
Language=Russian
ERROR_CLUSTER_JOIN_IN_PROGRESS - A node is in the process of joining the cluster.
.
Language=Polish
ERROR_CLUSTER_JOIN_IN_PROGRESS - Trwa proces przyłączania węzła do klastra.
.
Language=Romanian
ERROR_CLUSTER_JOIN_IN_PROGRESS - A node is in the process of joining the cluster.
.

MessageId=5042
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_NOT_FOUND
Language=English
ERROR_CLUSTER_NODE_NOT_FOUND - The cluster node was not found.
.
Language=Russian
ERROR_CLUSTER_NODE_NOT_FOUND - The cluster node was not found.
.
Language=Polish
ERROR_CLUSTER_NODE_NOT_FOUND - Nie znaleziono węzła klastra.
.
Language=Romanian
ERROR_CLUSTER_NODE_NOT_FOUND - The cluster node was not found.
.

MessageId=5043
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND
Language=English
ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND - The cluster local node information was not found.
.
Language=Russian
ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND - The cluster local node information was not found.
.
Language=Polish
ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND - Nie znaleziono informacji o lokalnym węźle klastra.
.
Language=Romanian
ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND - The cluster local node information was not found.
.

MessageId=5044
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_EXISTS
Language=English
ERROR_CLUSTER_NETWORK_EXISTS - The cluster network already exists.
.
Language=Russian
ERROR_CLUSTER_NETWORK_EXISTS - The cluster network already exists.
.
Language=Polish
ERROR_CLUSTER_NETWORK_EXISTS - Sieć klastrów już istnieje.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_EXISTS - The cluster network already exists.
.

MessageId=5045
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_NOT_FOUND
Language=English
ERROR_CLUSTER_NETWORK_NOT_FOUND - The cluster network was not found.
.
Language=Russian
ERROR_CLUSTER_NETWORK_NOT_FOUND - The cluster network was not found.
.
Language=Polish
ERROR_CLUSTER_NETWORK_NOT_FOUND - Nie znaleziono sieci klastrów.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_NOT_FOUND - The cluster network was not found.
.

MessageId=5046
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETINTERFACE_EXISTS
Language=English
ERROR_CLUSTER_NETINTERFACE_EXISTS - The cluster network interface already exists.
.
Language=Russian
ERROR_CLUSTER_NETINTERFACE_EXISTS - The cluster network interface already exists.
.
Language=Polish
ERROR_CLUSTER_NETINTERFACE_EXISTS - Interfejs sieci klastrów już istnieje.
.
Language=Romanian
ERROR_CLUSTER_NETINTERFACE_EXISTS - The cluster network interface already exists.
.

MessageId=5047
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETINTERFACE_NOT_FOUND
Language=English
ERROR_CLUSTER_NETINTERFACE_NOT_FOUND - The cluster network interface was not found.
.
Language=Russian
ERROR_CLUSTER_NETINTERFACE_NOT_FOUND - The cluster network interface was not found.
.
Language=Polish
ERROR_CLUSTER_NETINTERFACE_NOT_FOUND - Nie znaleziono interfejsu sieci klastrów.
.
Language=Romanian
ERROR_CLUSTER_NETINTERFACE_NOT_FOUND - The cluster network interface was not found.
.

MessageId=5048
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INVALID_REQUEST
Language=English
ERROR_CLUSTER_INVALID_REQUEST - The cluster request is not valid for this object.
.
Language=Russian
ERROR_CLUSTER_INVALID_REQUEST - The cluster request is not valid for this object.
.
Language=Polish
ERROR_CLUSTER_INVALID_REQUEST - Żądanie klastra jest nieprawidłowe w odniesieniu do tego obiektu.
.
Language=Romanian
ERROR_CLUSTER_INVALID_REQUEST - The cluster request is not valid for this object.
.

MessageId=5049
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INVALID_NETWORK_PROVIDER
Language=English
ERROR_CLUSTER_INVALID_NETWORK_PROVIDER - The cluster network provider is not valid.
.
Language=Russian
ERROR_CLUSTER_INVALID_NETWORK_PROVIDER - The cluster network provider is not valid.
.
Language=Polish
ERROR_CLUSTER_INVALID_NETWORK_PROVIDER - Dostawca sieci klastrów jest nieprawidłowy.
.
Language=Romanian
ERROR_CLUSTER_INVALID_NETWORK_PROVIDER - The cluster network provider is not valid.
.

MessageId=5050
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_DOWN
Language=English
ERROR_CLUSTER_NODE_DOWN - The cluster node is down.
.
Language=Russian
ERROR_CLUSTER_NODE_DOWN - The cluster node is down.
.
Language=Polish
ERROR_CLUSTER_NODE_DOWN - Węzeł klastra nie działa.
.
Language=Romanian
ERROR_CLUSTER_NODE_DOWN - The cluster node is down.
.

MessageId=5051
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_UNREACHABLE
Language=English
ERROR_CLUSTER_NODE_UNREACHABLE - The cluster node is not reachable.
.
Language=Russian
ERROR_CLUSTER_NODE_UNREACHABLE - The cluster node is not reachable.
.
Language=Polish
ERROR_CLUSTER_NODE_UNREACHABLE - Węzeł klastra jest nieosiągalny.
.
Language=Romanian
ERROR_CLUSTER_NODE_UNREACHABLE - The cluster node is not reachable.
.

MessageId=5052
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_NOT_MEMBER
Language=English
ERROR_CLUSTER_NODE_NOT_MEMBER - The cluster node is not a member of the cluster.
.
Language=Russian
ERROR_CLUSTER_NODE_NOT_MEMBER - The cluster node is not a member of the cluster.
.
Language=Polish
ERROR_CLUSTER_NODE_NOT_MEMBER - Węzeł klastra nie należy do klastra.
.
Language=Romanian
ERROR_CLUSTER_NODE_NOT_MEMBER - The cluster node is not a member of the cluster.
.

MessageId=5053
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS
Language=English
ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS - A cluster join operation is not in progress.
.
Language=Russian
ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS - A cluster join operation is not in progress.
.
Language=Polish
ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS - Operacja dołączania klastra nie jest realizowana.
.
Language=Romanian
ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS - A cluster join operation is not in progress.
.

MessageId=5054
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INVALID_NETWORK
Language=English
ERROR_CLUSTER_INVALID_NETWORK - The cluster network is not valid.
.
Language=Russian
ERROR_CLUSTER_INVALID_NETWORK - The cluster network is not valid.
.
Language=Polish
ERROR_CLUSTER_INVALID_NETWORK - Sieć klastrów jest nieprawidłowa.
.
Language=Romanian
ERROR_CLUSTER_INVALID_NETWORK - The cluster network is not valid.
.

MessageId=5056
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_UP
Language=English
ERROR_CLUSTER_NODE_UP - The cluster node is up.
.
Language=Russian
ERROR_CLUSTER_NODE_UP - The cluster node is up.
.
Language=Polish
ERROR_CLUSTER_NODE_UP - Węzeł klastra działa.
.
Language=Romanian
ERROR_CLUSTER_NODE_UP - The cluster node is up.
.

MessageId=5057
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_IPADDR_IN_USE
Language=English
ERROR_CLUSTER_IPADDR_IN_USE - The cluster IP address is already in use.
.
Language=Russian
ERROR_CLUSTER_IPADDR_IN_USE - The cluster IP address is already in use.
.
Language=Polish
ERROR_CLUSTER_IPADDR_IN_USE - Adres IP klastra jest już używany.
.
Language=Romanian
ERROR_CLUSTER_IPADDR_IN_USE - The cluster IP address is already in use.
.

MessageId=5058
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_NOT_PAUSED
Language=English
ERROR_CLUSTER_NODE_NOT_PAUSED - The cluster node is not paused.
.
Language=Russian
ERROR_CLUSTER_NODE_NOT_PAUSED - The cluster node is not paused.
.
Language=Polish
ERROR_CLUSTER_NODE_NOT_PAUSED - Węzeł klastra nie jest wstrzymany.
.
Language=Romanian
ERROR_CLUSTER_NODE_NOT_PAUSED - The cluster node is not paused.
.

MessageId=5059
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NO_SECURITY_CONTEXT
Language=English
ERROR_CLUSTER_NO_SECURITY_CONTEXT - No cluster security context is available.
.
Language=Russian
ERROR_CLUSTER_NO_SECURITY_CONTEXT - No cluster security context is available.
.
Language=Polish
ERROR_CLUSTER_NO_SECURITY_CONTEXT - Nie jest dostępny żaden kontekst zabezpieczenia klastra.
.
Language=Romanian
ERROR_CLUSTER_NO_SECURITY_CONTEXT - No cluster security context is available.
.

MessageId=5060
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_NOT_INTERNAL
Language=English
ERROR_CLUSTER_NETWORK_NOT_INTERNAL - The cluster network is not configured for internal cluster communication.
.
Language=Russian
ERROR_CLUSTER_NETWORK_NOT_INTERNAL - The cluster network is not configured for internal cluster communication.
.
Language=Polish
ERROR_CLUSTER_NETWORK_NOT_INTERNAL - Sieć klastrów nie jest skonfigurowana tak, aby zapewniała wewnętrzną komunikację w klastrach.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_NOT_INTERNAL - The cluster network is not configured for internal cluster communication.
.

MessageId=5061
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_ALREADY_UP
Language=English
ERROR_CLUSTER_NODE_ALREADY_UP - The cluster node is already up.
.
Language=Russian
ERROR_CLUSTER_NODE_ALREADY_UP - The cluster node is already up.
.
Language=Polish
ERROR_CLUSTER_NODE_ALREADY_UP - Węzeł klastra już działa.
.
Language=Romanian
ERROR_CLUSTER_NODE_ALREADY_UP - The cluster node is already up.
.

MessageId=5062
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_ALREADY_DOWN
Language=English
ERROR_CLUSTER_NODE_ALREADY_DOWN - The cluster node is already down.
.
Language=Russian
ERROR_CLUSTER_NODE_ALREADY_DOWN - The cluster node is already down.
.
Language=Polish
ERROR_CLUSTER_NODE_ALREADY_DOWN - Węzeł klastra już nie działa.
.
Language=Romanian
ERROR_CLUSTER_NODE_ALREADY_DOWN - The cluster node is already down.
.

MessageId=5063
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_ALREADY_ONLINE
Language=English
ERROR_CLUSTER_NETWORK_ALREADY_ONLINE - The cluster network is already online.
.
Language=Russian
ERROR_CLUSTER_NETWORK_ALREADY_ONLINE - The cluster network is already online.
.
Language=Polish
ERROR_CLUSTER_NETWORK_ALREADY_ONLINE - Sieć klastrów już jest w trybie online.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_ALREADY_ONLINE - The cluster network is already online.
.

MessageId=5064
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE
Language=English
ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE - The cluster network is already offline.
.
Language=Russian
ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE - The cluster network is already offline.
.
Language=Polish
ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE - Sieć klastrów już jest w trybie offline.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE - The cluster network is already offline.
.

MessageId=5065
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_ALREADY_MEMBER
Language=English
ERROR_CLUSTER_NODE_ALREADY_MEMBER - The cluster node is already a member of the cluster.
.
Language=Russian
ERROR_CLUSTER_NODE_ALREADY_MEMBER - The cluster node is already a member of the cluster.
.
Language=Polish
ERROR_CLUSTER_NODE_ALREADY_MEMBER - Węzeł klastra już należy do klastra.
.
Language=Romanian
ERROR_CLUSTER_NODE_ALREADY_MEMBER - The cluster node is already a member of the cluster.
.

MessageId=5066
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_LAST_INTERNAL_NETWORK
Language=English
ERROR_CLUSTER_LAST_INTERNAL_NETWORK - The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network.
.
Language=Russian
ERROR_CLUSTER_LAST_INTERNAL_NETWORK - The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network.
.
Language=Polish
ERROR_CLUSTER_LAST_INTERNAL_NETWORK - Sieć klastrów jest jedyną siecią skonfigurowaną tak, aby zapewniała wewnętrzną komunikację między dwoma (lub więcej) aktywnymi węzłami klastra. Nie można wyłączyć funkcji wewnętrznego komunikowania się w ramach klastra.
.
Language=Romanian
ERROR_CLUSTER_LAST_INTERNAL_NETWORK - The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network.
.

MessageId=5067
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS
Language=English
ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS - One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network.
.
Language=Russian
ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS - One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network.
.
Language=Polish
ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS - Co najmniej jeden z zasobów klastra świadczy usługi klientom poprzez sieć. Nie można usunąć z sieci możliwości dostępu dla klientów.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS - One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network.
.

MessageId=5068
Severity=Success
Facility=System
SymbolicName=ERROR_INVALID_OPERATION_ON_QUORUM
Language=English
ERROR_INVALID_OPERATION_ON_QUORUM - This operation cannot be performed on the cluster resource as it the quorum resource. You may not bring the quorum resource offline or modify its possible owners list.
.
Language=Russian
ERROR_INVALID_OPERATION_ON_QUORUM - This operation cannot be performed on the cluster resource as it the quorum resource. You may not bring the quorum resource offline or modify its possible owners list.
.
Language=Polish
ERROR_INVALID_OPERATION_ON_QUORUM - Tej operacji nie można wykonać na zasobie klastra, ponieważ jest to zasób kworum. Nie można przełączyć zasobu kworum do trybu offline ani modyfikować listy jego właścicieli (jeśli istnieje).
.
Language=Romanian
ERROR_INVALID_OPERATION_ON_QUORUM - This operation cannot be performed on the cluster resource as it the quorum resource. You may not bring the quorum resource offline or modify its possible owners list.
.

MessageId=5069
Severity=Success
Facility=System
SymbolicName=ERROR_DEPENDENCY_NOT_ALLOWED
Language=English
ERROR_DEPENDENCY_NOT_ALLOWED - The cluster quorum resource is not allowed to have any dependencies.
.
Language=Russian
ERROR_DEPENDENCY_NOT_ALLOWED - The cluster quorum resource is not allowed to have any dependencies.
.
Language=Polish
ERROR_DEPENDENCY_NOT_ALLOWED - Zasób klastra kworum nie może mieć żadnych zależności.
.
Language=Romanian
ERROR_DEPENDENCY_NOT_ALLOWED - The cluster quorum resource is not allowed to have any dependencies.
.

MessageId=5070
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_PAUSED
Language=English
ERROR_CLUSTER_NODE_PAUSED - The cluster node is paused.
.
Language=Russian
ERROR_CLUSTER_NODE_PAUSED - The cluster node is paused.
.
Language=Polish
ERROR_CLUSTER_NODE_PAUSED - Węzeł klastra jest wstrzymany.
.
Language=Romanian
ERROR_CLUSTER_NODE_PAUSED - The cluster node is paused.
.

MessageId=5071
Severity=Success
Facility=System
SymbolicName=ERROR_NODE_CANT_HOST_RESOURCE
Language=English
ERROR_NODE_CANT_HOST_RESOURCE - The cluster resource cannot be brought online. The owner node cannot run this resource.
.
Language=Russian
ERROR_NODE_CANT_HOST_RESOURCE - The cluster resource cannot be brought online. The owner node cannot run this resource.
.
Language=Polish
ERROR_NODE_CANT_HOST_RESOURCE - Nie można przełączyć zasobu klastra do trybu online. Węzeł-właściciel nie może uruchomić tego zasobu.
.
Language=Romanian
ERROR_NODE_CANT_HOST_RESOURCE - The cluster resource cannot be brought online. The owner node cannot run this resource.
.

MessageId=5072
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_NOT_READY
Language=English
ERROR_CLUSTER_NODE_NOT_READY - The cluster node is not ready to perform the requested operation.
.
Language=Russian
ERROR_CLUSTER_NODE_NOT_READY - The cluster node is not ready to perform the requested operation.
.
Language=Polish
ERROR_CLUSTER_NODE_NOT_READY - Węzeł klastra nie jest gotowy wykonać żądaną operację.
.
Language=Romanian
ERROR_CLUSTER_NODE_NOT_READY - The cluster node is not ready to perform the requested operation.
.

MessageId=5073
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_SHUTTING_DOWN
Language=English
ERROR_CLUSTER_NODE_SHUTTING_DOWN - The cluster node is shutting down.
.
Language=Russian
ERROR_CLUSTER_NODE_SHUTTING_DOWN - The cluster node is shutting down.
.
Language=Polish
ERROR_CLUSTER_NODE_SHUTTING_DOWN - Węzeł klastra jest zamykany.
.
Language=Romanian
ERROR_CLUSTER_NODE_SHUTTING_DOWN - The cluster node is shutting down.
.

MessageId=5074
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_JOIN_ABORTED
Language=English
ERROR_CLUSTER_JOIN_ABORTED - The cluster join operation was aborted.
.
Language=Russian
ERROR_CLUSTER_JOIN_ABORTED - The cluster join operation was aborted.
.
Language=Polish
ERROR_CLUSTER_JOIN_ABORTED - Operacja łączenia klastra została przerwana.
.
Language=Romanian
ERROR_CLUSTER_JOIN_ABORTED - The cluster join operation was aborted.
.

MessageId=5075
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INCOMPATIBLE_VERSIONS
Language=English
ERROR_CLUSTER_INCOMPATIBLE_VERSIONS - The cluster join operation failed due to incompatible software versions between the joining node and its sponsor.
.
Language=Russian
ERROR_CLUSTER_INCOMPATIBLE_VERSIONS - The cluster join operation failed due to incompatible software versions between the joining node and its sponsor.
.
Language=Polish
ERROR_CLUSTER_INCOMPATIBLE_VERSIONS - Operacja przyłączenia do klastra nie powiodła się z powodu niezgodności wersji oprogramowania dołączanego węzła i jego sponsora.
.
Language=Romanian
ERROR_CLUSTER_INCOMPATIBLE_VERSIONS - The cluster join operation failed due to incompatible software versions between the joining node and its sponsor.
.

MessageId=5076
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED
Language=English
ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED - This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor.
.
Language=Russian
ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED - This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor.
.
Language=Polish
ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED - Nie można utworzyć tego zasobu, ponieważ klaster osiągnął limit liczby zasobów, które może monitorować.
.
Language=Romanian
ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED - This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor.
.

MessageId=5077
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED
Language=English
ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED - The system configuration changed during the cluster join or form operation. The join or form operation was aborted.
.
Language=Russian
ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED - The system configuration changed during the cluster join or form operation. The join or form operation was aborted.
.
Language=Polish
ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED - Konfiguracja systemu zmieniła się podczas wykonywania operacji łączenia lub formowania klastrów. Operacja łączenia lub formowania klastrów została przerwana.
.
Language=Romanian
ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED - The system configuration changed during the cluster join or form operation. The join or form operation was aborted.
.

MessageId=5078
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND
Language=English
ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND - The specified resource type was not found.
.
Language=Russian
ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND - The specified resource type was not found.
.
Language=Polish
ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND - Nie znaleziono podanego typu zasobu.
.
Language=Romanian
ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND - The specified resource type was not found.
.

MessageId=5079
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED
Language=English
ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED - The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node.
.
Language=Russian
ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED - The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node.
.
Language=Polish
ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED - Podany węzeł nie obsługuje zasobów tego typu. Może być to spowodowane niezgodnością wersji lub nieobecnością biblioteki DLL zasobów w tym węźle.
.
Language=Romanian
ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED - The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node.
.

MessageId=5080
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_RESNAME_NOT_FOUND
Language=English
ERROR_CLUSTER_RESNAME_NOT_FOUND - The specified resource name is supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL.
.
Language=Russian
ERROR_CLUSTER_RESNAME_NOT_FOUND - The specified resource name is supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL.
.
Language=Polish
ERROR_CLUSTER_RESNAME_NOT_FOUND - Podana nazwa zasobu nie jest obsługiwana przez tę bibliotekę DLL. Może to być spowodowane złą (lub zmienioną) nazwą dostarczoną do biblioteki DLL zasobów.
.
Language=Romanian
ERROR_CLUSTER_RESNAME_NOT_FOUND - The specified resource name is supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL.
.

MessageId=5081
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED
Language=English
ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED - No authentication package could be registered with the RPC server.
.
Language=Russian
ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED - No authentication package could be registered with the RPC server.
.
Language=Polish
ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED - Na serwerze RPC nie można zarejestrować żadnego pakietu uwierzytelnień.
.
Language=Romanian
ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED - No authentication package could be registered with the RPC server.
.

MessageId=5082
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST
Language=English
ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST - You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group.
.
Language=Russian
ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST - You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group.
.
Language=Polish
ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST - Nie można przełączyć grupy do trybu online, ponieważ właściciel grupy nie występuje na liście preferowanych przez grupę. Aby zmienić węzeł będący właścicielem grupy, przenieś grupę.
.
Language=Romanian
ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST - You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group.
.

MessageId=5083
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_DATABASE_SEQMISMATCH
Language=English
ERROR_CLUSTER_DATABASE_SEQMISMATCH - The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join.
.
Language=Russian
ERROR_CLUSTER_DATABASE_SEQMISMATCH - The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join.
.
Language=Polish
ERROR_CLUSTER_DATABASE_SEQMISMATCH - Operacja łączenia nie powiodła się, ponieważ numer sekwencyjny bazy danych klastra zmienił się lub jest niezgodny z węzłem blokującym. Może się to zdarzyć podczas operacji łączenia, jeżeli w jej trakcie ulegnie zmianie baza danych klastra.
.
Language=Romanian
ERROR_CLUSTER_DATABASE_SEQMISMATCH - The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join.
.

MessageId=5084
Severity=Success
Facility=System
SymbolicName=ERROR_RESMON_INVALID_STATE
Language=English
ERROR_RESMON_INVALID_STATE - The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state.
.
Language=Russian
ERROR_RESMON_INVALID_STATE - The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state.
.
Language=Polish
ERROR_RESMON_INVALID_STATE - Monitorów zasobów nie pozwoli na wykonanie błędnej operacji, gdy zasób jest w swoim bieżącym stanie. Może się to zdarzyć, jeśli zasób jest w stanie oczekiwania.
.
Language=Romanian
ERROR_RESMON_INVALID_STATE - The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state.
.

MessageId=5085
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_GUM_NOT_LOCKER
Language=English
ERROR_CLUSTER_GUM_NOT_LOCKER - A non locker code got a request to reserve the lock for making global updates.
.
Language=Russian
ERROR_CLUSTER_GUM_NOT_LOCKER - A non locker code got a request to reserve the lock for making global updates.
.
Language=Polish
ERROR_CLUSTER_GUM_NOT_LOCKER - Kod nieblokujący odebrał żądanie zarezerwowania tej blokady w celu przeprowadzenia globalnej aktualizacji.
.
Language=Romanian
ERROR_CLUSTER_GUM_NOT_LOCKER - A non locker code got a request to reserve the lock for making global updates.
.

MessageId=5086
Severity=Success
Facility=System
SymbolicName=ERROR_QUORUM_DISK_NOT_FOUND
Language=English
ERROR_QUORUM_DISK_NOT_FOUND - The quorum disk could not be located by the cluster service.
.
Language=Russian
ERROR_QUORUM_DISK_NOT_FOUND - The quorum disk could not be located by the cluster service.
.
Language=Polish
ERROR_QUORUM_DISK_NOT_FOUND - Usługa klastrowania nie może zlokalizować dysku kworum.
.
Language=Romanian
ERROR_QUORUM_DISK_NOT_FOUND - The quorum disk could not be located by the cluster service.
.

MessageId=5087
Severity=Success
Facility=System
SymbolicName=ERROR_DATABASE_BACKUP_CORRUPT
Language=English
ERROR_DATABASE_BACKUP_CORRUPT - The backup up cluster database is possibly corrupt.
.
Language=Russian
ERROR_DATABASE_BACKUP_CORRUPT - The backup up cluster database is possibly corrupt.
.
Language=Polish
ERROR_DATABASE_BACKUP_CORRUPT - Kopia zapasowa bazy danych klastra prawdopodobnie jest uszkodzona.
.
Language=Romanian
ERROR_DATABASE_BACKUP_CORRUPT - The backup up cluster database is possibly corrupt.
.

MessageId=5088
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT
Language=English
ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT - A DFS root already exists in this cluster node.
.
Language=Russian
ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT - A DFS root already exists in this cluster node.
.
Language=Polish
ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT - W tym węźle klastra już występuje system DFS.
.
Language=Romanian
ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT - A DFS root already exists in this cluster node.
.

MessageId=5089
Severity=Success
Facility=System
SymbolicName=ERROR_RESOURCE_PROPERTY_UNCHANGEABLE
Language=English
ERROR_RESOURCE_PROPERTY_UNCHANGEABLE - An attempt to modify a resource property failed because it conflicts with another existing property.
.
Language=Russian
ERROR_RESOURCE_PROPERTY_UNCHANGEABLE - An attempt to modify a resource property failed because it conflicts with another existing property.
.
Language=Polish
ERROR_RESOURCE_PROPERTY_UNCHANGEABLE - Nie można zmodyfikować właściwości zasobu, ponieważ nowa właściwość wchodzi w konflikt z inną istniejącą właściwością.
.
Language=Romanian
ERROR_RESOURCE_PROPERTY_UNCHANGEABLE - An attempt to modify a resource property failed because it conflicts with another existing property.
.

MessageId=5890
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE
Language=English
ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE - An operation was attempted that is incompatible with the current membership state of the node.
.
Language=Russian
ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE - An operation was attempted that is incompatible with the current membership state of the node.
.
Language=Polish
ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE - Próbowano wykonać operację, która jest niezgodna z bieżącym stanem członkostwa węzła.
.
Language=Romanian
ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE - An operation was attempted that is incompatible with the current membership state of the node.
.

MessageId=5891
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_QUORUMLOG_NOT_FOUND
Language=English
ERROR_CLUSTER_QUORUMLOG_NOT_FOUND - The quorum resource does not contain the quorum log.
.
Language=Russian
ERROR_CLUSTER_QUORUMLOG_NOT_FOUND - The quorum resource does not contain the quorum log.
.
Language=Polish
ERROR_CLUSTER_QUORUMLOG_NOT_FOUND - Zasób kworum nie zawiera dziennika kworum.
.
Language=Romanian
ERROR_CLUSTER_QUORUMLOG_NOT_FOUND - The quorum resource does not contain the quorum log.
.

MessageId=5892
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_MEMBERSHIP_HALT
Language=English
ERROR_CLUSTER_MEMBERSHIP_HALT - The membership engine requested shutdown of the cluster service on this node.
.
Language=Russian
ERROR_CLUSTER_MEMBERSHIP_HALT - The membership engine requested shutdown of the cluster service on this node.
.
Language=Polish
ERROR_CLUSTER_MEMBERSHIP_HALT - Aparat członkostwa zażądał zamknięcia usługi klastrowania na tym węźle.
.
Language=Romanian
ERROR_CLUSTER_MEMBERSHIP_HALT - The membership engine requested shutdown of the cluster service on this node.
.

MessageId=5893
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_INSTANCE_ID_MISMATCH
Language=English
ERROR_CLUSTER_INSTANCE_ID_MISMATCH - The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node.
.
Language=Russian
ERROR_CLUSTER_INSTANCE_ID_MISMATCH - The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node.
.
Language=Polish
ERROR_CLUSTER_INSTANCE_ID_MISMATCH - Operacja dołączania nie powiodła się, ponieważ identyfikator wystąpienia klastra węzła dołączającego nie pasuje do identyfikatora wystąpienia klastra węzła sponsorującego.
.
Language=Romanian
ERROR_CLUSTER_INSTANCE_ID_MISMATCH - The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node.
.

MessageId=5894
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP
Language=English
ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP - A matching network for the specified IP address could not be found. Please also specify a subnet mask and a cluster network.
.
Language=Russian
ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP - A matching network for the specified IP address could not be found. Please also specify a subnet mask and a cluster network.
.
Language=Polish
ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP - A matching network for the specified IP address could not be found. Please also specify a subnet mask and a cluster network.
.
Language=Romanian
ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP - A matching network for the specified IP address could not be found. Please also specify a subnet mask and a cluster network.
.

MessageId=5895
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH
Language=English
ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH - The actual data type of the property did not match the expected data type of the property.
.
Language=Russian
ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH - The actual data type of the property did not match the expected data type of the property.
.
Language=Polish
ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH - Rzeczywisty typ danych właściwości nie odpowiada oczekiwanemu typowi danych właściwości.
.
Language=Romanian
ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH - The actual data type of the property did not match the expected data type of the property.
.

MessageId=5896
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP
Language=English
ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP - The cluster node was evicted from the cluster successfully, but the node was not cleaned up. Extended status information explaining why the node was not cleaned up is available.
.
Language=Russian
ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP - The cluster node was evicted from the cluster successfully, but the node was not cleaned up. Extended status information explaining why the node was not cleaned up is available.
.
Language=Polish
ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP - The cluster node was evicted from the cluster successfully, but the node was not cleaned up. Extended status information explaining why the node was not cleaned up is available.
.
Language=Romanian
ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP - The cluster node was evicted from the cluster successfully, but the node was not cleaned up. Extended status information explaining why the node was not cleaned up is available.
.

MessageId=5897
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_PARAMETER_MISMATCH
Language=English
ERROR_CLUSTER_PARAMETER_MISMATCH - Two or more parameter values specified for a resource's properties are in conflict.
.
Language=Russian
ERROR_CLUSTER_PARAMETER_MISMATCH - Two or more parameter values specified for a resource's properties are in conflict.
.
Language=Polish
ERROR_CLUSTER_PARAMETER_MISMATCH - Dwie lub więcej wartości parametrów, określonych dla właściwości zasobu, kolidują ze sobą.
.
Language=Romanian
ERROR_CLUSTER_PARAMETER_MISMATCH - Two or more parameter values specified for a resource's properties are in conflict.
.

MessageId=5898
Severity=Success
Facility=System
SymbolicName=ERROR_NODE_CANNOT_BE_CLUSTERED
Language=English
ERROR_NODE_CANNOT_BE_CLUSTERED - This computer cannot be made a member of a cluster.
.
Language=Russian
ERROR_NODE_CANNOT_BE_CLUSTERED - This computer cannot be made a member of a cluster.
.
Language=Polish
ERROR_NODE_CANNOT_BE_CLUSTERED - Ten komputer nie może być członkiem klastra.
.
Language=Romanian
ERROR_NODE_CANNOT_BE_CLUSTERED - This computer cannot be made a member of a cluster.
.

MessageId=5899
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_WRONG_OS_VERSION
Language=English
ERROR_CLUSTER_WRONG_OS_VERSION - This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed.
.
Language=Russian
ERROR_CLUSTER_WRONG_OS_VERSION - This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed.
.
Language=Polish
ERROR_CLUSTER_WRONG_OS_VERSION - Ten komputer nie może być członkiem klastra, ponieważ nie ma na nim zainstalowanej właściwej wersji systemu Windows.
.
Language=Romanian
ERROR_CLUSTER_WRONG_OS_VERSION - This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed.
.

MessageId=5900
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME
Language=English
ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME - A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster.
.
Language=Russian
ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME - A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster.
.
Language=Polish
ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME - Nie można utworzyć klastra o określonej nazwie, ponieważ ta nazwa klastra jest już używana. Określ inną nazwę dla klastra.
.
Language=Romanian
ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME - A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster.
.

MessageId=5901
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSCFG_ALREADY_COMMITTED
Language=English
ERROR_CLUSCFG_ALREADY_COMMITTED - The cluster configuration action has already been committed.
.
Language=Russian
ERROR_CLUSCFG_ALREADY_COMMITTED - The cluster configuration action has already been committed.
.
Language=Polish
ERROR_CLUSCFG_ALREADY_COMMITTED - Akcja konfiguracji klastra została już wykonana.
.
Language=Romanian
ERROR_CLUSCFG_ALREADY_COMMITTED - The cluster configuration action has already been committed.
.

MessageId=5902
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSCFG_ROLLBACK_FAILED
Language=English
ERROR_CLUSCFG_ROLLBACK_FAILED - The cluster configuration action could not be rolled back.
.
Language=Russian
ERROR_CLUSCFG_ROLLBACK_FAILED - The cluster configuration action could not be rolled back.
.
Language=Polish
ERROR_CLUSCFG_ROLLBACK_FAILED - Nie można wycofać akcji konfiguracji klastra.
.
Language=Romanian
ERROR_CLUSCFG_ROLLBACK_FAILED - The cluster configuration action could not be rolled back.
.

MessageId=5903
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT
Language=English
ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT - The drive letter assigned to a system disk on one node conflicted with the driver letter assigned to a disk on another node.
.
Language=Russian
ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT - The drive letter assigned to a system disk on one node conflicted with the driver letter assigned to a disk on another node.
.
Language=Polish
ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT - Litera dysku przypisana do dysku systemowego w jednym z węzłów jest w konflikcie z literą dysku przypisaną do dysku w innym węźle.
.
Language=Romanian
ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT - The drive letter assigned to a system disk on one node conflicted with the driver letter assigned to a disk on another node.
.

MessageId=5904
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_OLD_VERSION
Language=English
ERROR_CLUSTER_OLD_VERSION - One or more nodes in the cluster are running a version of Windows that does not support this operation.
.
Language=Russian
ERROR_CLUSTER_OLD_VERSION - One or more nodes in the cluster are running a version of Windows that does not support this operation.
.
Language=Polish
ERROR_CLUSTER_OLD_VERSION - Jeden lub kilka węzłów w klastrze korzysta z wersji systemu Windows, która nie obsługuje tej operacji.
.
Language=Romanian
ERROR_CLUSTER_OLD_VERSION - One or more nodes in the cluster are running a version of Windows that does not support this operation.
.

MessageId=5905
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME
Language=English
ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME - The name of the corresponding computer account doesn't match the Network Name for this resource.
.
Language=Russian
ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME - The name of the corresponding computer account doesn't match the Network Name for this resource.
.
Language=Polish
ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME - Nazwa odpowiedniego konta komputera nie pasuje do nazwy sieciowej tego zasobu.
.
Language=Romanian
ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME - The name of the corresponding computer account doesn't match the Network Name for this resource.
.

MessageId=5906
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_NO_NET_ADAPTERS
Language=English
ERROR_CLUSTER_NO_NET_ADAPTERS - No network adapters are available.
.
Language=Russian
ERROR_CLUSTER_NO_NET_ADAPTERS - No network adapters are available.
.
Language=Polish
ERROR_CLUSTER_NO_NET_ADAPTERS - Nie są dostępne żadne karty sieciowe.
.
Language=Romanian
ERROR_CLUSTER_NO_NET_ADAPTERS - No network adapters are available.
.

MessageId=5907
Severity=Success
Facility=System
SymbolicName=ERROR_CLUSTER_POISONED
Language=English
ERROR_CLUSTER_POISONED - The cluster node has been poisoned.
.
Language=Russian
ERROR_CLUSTER_POISONED - The cluster node has been poisoned.
.
Language=Polish
ERROR_CLUSTER_POISONED - Węzeł klastra uległ awarii.
.
Language=Romanian
ERROR_CLUSTER_POISONED - The cluster node has been poisoned.
.

MessageId=6000
Severity=Success
Facility=System
SymbolicName=ERROR_ENCRYPTION_FAILED
Language=English
ERROR_ENCRYPTION_FAILED - The specified file could not be encrypted.
.
Language=Russian
ERROR_ENCRYPTION_FAILED - The specified file could not be encrypted.
.
Language=Polish
ERROR_ENCRYPTION_FAILED - Nie można zaszyfrować podanego pliku.
.
Language=Romanian
ERROR_ENCRYPTION_FAILED - The specified file could not be encrypted.
.

MessageId=6001
Severity=Success
Facility=System
SymbolicName=ERROR_DECRYPTION_FAILED
Language=English
ERROR_DECRYPTION_FAILED - The specified file could not be decrypted.
.
Language=Russian
ERROR_DECRYPTION_FAILED - The specified file could not be decrypted.
.
Language=Polish
ERROR_DECRYPTION_FAILED - Nie można odszyfrować podanego pliku.
.
Language=Romanian
ERROR_DECRYPTION_FAILED - The specified file could not be decrypted.
.

MessageId=6002
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_ENCRYPTED
Language=English
ERROR_FILE_ENCRYPTED - The specified file is encrypted and the user does not have the ability to decrypt it.
.
Language=Russian
ERROR_FILE_ENCRYPTED - The specified file is encrypted and the user does not have the ability to decrypt it.
.
Language=Polish
ERROR_FILE_ENCRYPTED - Określony plik jest zaszyfrowany i użytkownik nie ma możliwości odszyfrowania go.
.
Language=Romanian
ERROR_FILE_ENCRYPTED - The specified file is encrypted and the user does not have the ability to decrypt it.
.

MessageId=6003
Severity=Success
Facility=System
SymbolicName=ERROR_NO_RECOVERY_POLICY
Language=English
ERROR_NO_RECOVERY_POLICY - There is no valid encryption recovery policy configured for this system.
.
Language=Russian
ERROR_NO_RECOVERY_POLICY - There is no valid encryption recovery policy configured for this system.
.
Language=Polish
ERROR_NO_RECOVERY_POLICY - Brak skonfigurowanych prawidłowych zasad odzyskiwania szyfrowania dla tego systemu.
.
Language=Romanian
ERROR_NO_RECOVERY_POLICY - There is no valid encryption recovery policy configured for this system.
.

MessageId=6004
Severity=Success
Facility=System
SymbolicName=ERROR_NO_EFS
Language=English
ERROR_NO_EFS - The required encryption driver is not loaded for this system.
.
Language=Russian
ERROR_NO_EFS - The required encryption driver is not loaded for this system.
.
Language=Polish
ERROR_NO_EFS - Wymagany sterownik szyfrowania nie jest załadowany w systemie.
.
Language=Romanian
ERROR_NO_EFS - The required encryption driver is not loaded for this system.
.

MessageId=6005
Severity=Success
Facility=System
SymbolicName=ERROR_WRONG_EFS
Language=English
ERROR_WRONG_EFS - The file was encrypted with a different encryption driver than is currently loaded.
.
Language=Russian
ERROR_WRONG_EFS - The file was encrypted with a different encryption driver than is currently loaded.
.
Language=Polish
ERROR_WRONG_EFS - Plik został zaszyfrowany za pomocą sterownika szyfrowania innego niż obecnie załadowany.
.
Language=Romanian
ERROR_WRONG_EFS - The file was encrypted with a different encryption driver than is currently loaded.
.

MessageId=6006
Severity=Success
Facility=System
SymbolicName=ERROR_NO_USER_KEYS
Language=English
ERROR_NO_USER_KEYS - There are no EFS keys defined for the user.
.
Language=Russian
ERROR_NO_USER_KEYS - There are no EFS keys defined for the user.
.
Language=Polish
ERROR_NO_USER_KEYS - Brak zdefiniowanych kluczy EFS dla użytkownika.
.
Language=Romanian
ERROR_NO_USER_KEYS - There are no EFS keys defined for the user.
.

MessageId=6007
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_NOT_ENCRYPTED
Language=English
ERROR_FILE_NOT_ENCRYPTED - The specified file is not encrypted.
.
Language=Russian
ERROR_FILE_NOT_ENCRYPTED - The specified file is not encrypted.
.
Language=Polish
ERROR_FILE_NOT_ENCRYPTED - Określony plik nie jest zaszyfrowany.
.
Language=Romanian
ERROR_FILE_NOT_ENCRYPTED - The specified file is not encrypted.
.

MessageId=6008
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_EXPORT_FORMAT
Language=English
ERROR_NOT_EXPORT_FORMAT - The specified file is not in the defined EFS export format.
.
Language=Russian
ERROR_NOT_EXPORT_FORMAT - The specified file is not in the defined EFS export format.
.
Language=Polish
ERROR_NOT_EXPORT_FORMAT - Określony plik nie występuje w zdefiniowanym formacie eksportu EFS.
.
Language=Romanian
ERROR_NOT_EXPORT_FORMAT - The specified file is not in the defined EFS export format.
.

MessageId=6009
Severity=Success
Facility=System
SymbolicName=ERROR_FILE_READ_ONLY
Language=English
ERROR_FILE_READ_ONLY - The specified file is read only.
.
Language=Russian
ERROR_FILE_READ_ONLY - The specified file is read only.
.
Language=Polish
ERROR_FILE_READ_ONLY - Podany plik jest tylko do odczytu.
.
Language=Romanian
ERROR_FILE_READ_ONLY - The specified file is read only.
.

MessageId=6010
Severity=Success
Facility=System
SymbolicName=ERROR_DIR_EFS_DISALLOWED
Language=English
ERROR_DIR_EFS_DISALLOWED - The directory has been disabled for encryption.
.
Language=Russian
ERROR_DIR_EFS_DISALLOWED - The directory has been disabled for encryption.
.
Language=Polish
ERROR_DIR_EFS_DISALLOWED - Katalog został wyłączony z szyfrowania.
.
Language=Romanian
ERROR_DIR_EFS_DISALLOWED - The directory has been disabled for encryption.
.

MessageId=6011
Severity=Success
Facility=System
SymbolicName=ERROR_EFS_SERVER_NOT_TRUSTED
Language=English
ERROR_EFS_SERVER_NOT_TRUSTED - The server is not trusted for remote encryption operation.
.
Language=Russian
ERROR_EFS_SERVER_NOT_TRUSTED - The server is not trusted for remote encryption operation.
.
Language=Polish
ERROR_EFS_SERVER_NOT_TRUSTED - Serwer nie jest zaufany dla zdalnej operacji szyfrowania.
.
Language=Romanian
ERROR_EFS_SERVER_NOT_TRUSTED - The server is not trusted for remote encryption operation.
.

MessageId=6012
Severity=Success
Facility=System
SymbolicName=ERROR_BAD_RECOVERY_POLICY
Language=English
ERROR_BAD_RECOVERY_POLICY - Recovery policy configured for this system contains invalid recovery certificate.
.
Language=Russian
ERROR_BAD_RECOVERY_POLICY - Recovery policy configured for this system contains invalid recovery certificate.
.
Language=Polish
ERROR_BAD_RECOVERY_POLICY - Zasady odzyskiwania skonfigurowane dla tego systemu zawierają nieprawidłowy certyfikat odzyskiwania.
.
Language=Romanian
ERROR_BAD_RECOVERY_POLICY - Recovery policy configured for this system contains invalid recovery certificate.
.

MessageId=6013
Severity=Success
Facility=System
SymbolicName=ERROR_EFS_ALG_BLOB_TOO_BIG
Language=English
ERROR_EFS_ALG_BLOB_TOO_BIG - The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file.
.
Language=Russian
ERROR_EFS_ALG_BLOB_TOO_BIG - The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file.
.
Language=Polish
ERROR_EFS_ALG_BLOB_TOO_BIG - Algorytm szyfrowania użyty dla pliku źródłowego wymaga większego buforu klucza niż określony dla pliku docelowego.
.
Language=Romanian
ERROR_EFS_ALG_BLOB_TOO_BIG - The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file.
.

MessageId=6014
Severity=Success
Facility=System
SymbolicName=ERROR_VOLUME_NOT_SUPPORT_EFS
Language=English
ERROR_VOLUME_NOT_SUPPORT_EFS - The disk partition does not support file encryption.
.
Language=Russian
ERROR_VOLUME_NOT_SUPPORT_EFS - The disk partition does not support file encryption.
.
Language=Polish
ERROR_VOLUME_NOT_SUPPORT_EFS - Dana partycja dysku nie obsługuje szyfrowania plików.
.
Language=Romanian
ERROR_VOLUME_NOT_SUPPORT_EFS - The disk partition does not support file encryption.
.

MessageId=6015
Severity=Success
Facility=System
SymbolicName=ERROR_EFS_DISABLED
Language=English
ERROR_EFS_DISABLED - This machine is disabled for file encryption.
.
Language=Russian
ERROR_EFS_DISABLED - This machine is disabled for file encryption.
.
Language=Polish
ERROR_EFS_DISABLED - Dla tego komputera szyfrowanie plików jest wyłączone.
.
Language=Romanian
ERROR_EFS_DISABLED - This machine is disabled for file encryption.
.

MessageId=6016
Severity=Success
Facility=System
SymbolicName=ERROR_EFS_VERSION_NOT_SUPPORT
Language=English
ERROR_EFS_VERSION_NOT_SUPPORT - A newer system is required to decrypt this encrypted file.
.
Language=Russian
ERROR_EFS_VERSION_NOT_SUPPORT - A newer system is required to decrypt this encrypted file.
.
Language=Polish
ERROR_EFS_VERSION_NOT_SUPPORT - Do odszyfrowania tego pliku zaszyfrowanego potrzebny jest nowszy system.
.
Language=Romanian
ERROR_EFS_VERSION_NOT_SUPPORT - A newer system is required to decrypt this encrypted file.
.

MessageId=6118
Severity=Success
Facility=System
SymbolicName=ERROR_NO_BROWSER_SERVERS_FOUND
Language=English
ERROR_NO_BROWSER_SERVERS_FOUND - The list of servers for this workgroup is not currently available.
.
Language=Russian
ERROR_NO_BROWSER_SERVERS_FOUND - The list of servers for this workgroup is not currently available.
.
Language=Polish
ERROR_NO_BROWSER_SERVERS_FOUND - Lista serwerów dla tej grupy roboczej jest obecnie niedostępna.
.
Language=Romanian
ERROR_NO_BROWSER_SERVERS_FOUND - The list of servers for this workgroup is not currently available.
.

MessageId=6200
Severity=Success
Facility=System
SymbolicName=SCHED_E_SERVICE_NOT_LOCALSYSTEM
Language=English
SCHED_E_SERVICE_NOT_LOCALSYSTEM - The Task Scheduler service must be configured to run in the System account to function properly. Individual tasks may be configured to run in other accounts.
.
Language=Russian
SCHED_E_SERVICE_NOT_LOCALSYSTEM - The Task Scheduler service must be configured to run in the System account to function properly. Individual tasks may be configured to run in other accounts.
.
Language=Polish
SCHED_E_SERVICE_NOT_LOCALSYSTEM - Usługa harmonogramu zadań musi być skonfiguorawana do uruchomienia w systemie konta, aby funkcjonować poprawnie. Indywidualne zadania mogą być skierowane do uruchamiania w innych kontach.
.
Language=Romanian
SCHED_E_SERVICE_NOT_LOCALSYSTEM - The Task Scheduler service must be configured to run in the System account to function properly. Individual tasks may be configured to run in other accounts.
.

MessageId=7001
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATION_NAME_INVALID
Language=English
ERROR_CTX_WINSTATION_NAME_INVALID - The specified session name is invalid.
.
Language=Russian
ERROR_CTX_WINSTATION_NAME_INVALID - The specified session name is invalid.
.
Language=Polish
ERROR_CTX_WINSTATION_NAME_INVALID - Podana nazwa sesji jest nieprawidłowa.
.
Language=Romanian
ERROR_CTX_WINSTATION_NAME_INVALID - The specified session name is invalid.
.

MessageId=7002
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_INVALID_PD
Language=English
ERROR_CTX_INVALID_PD - The specified protocol driver is invalid.
.
Language=Russian
ERROR_CTX_INVALID_PD - The specified protocol driver is invalid.
.
Language=Polish
ERROR_CTX_INVALID_PD - Podany sterownik protokołu jest nieprawidłowy.
.
Language=Romanian
ERROR_CTX_INVALID_PD - The specified protocol driver is invalid.
.

MessageId=7003
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_PD_NOT_FOUND
Language=English
ERROR_CTX_PD_NOT_FOUND - The specified protocol driver was not found in the system path.
.
Language=Russian
ERROR_CTX_PD_NOT_FOUND - The specified protocol driver was not found in the system path.
.
Language=Polish
ERROR_CTX_PD_NOT_FOUND - Podany sterownik protokołu nie został znaleziony w ścieżce systemu.
.
Language=Romanian
ERROR_CTX_PD_NOT_FOUND - The specified protocol driver was not found in the system path.
.

MessageId=7004
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WD_NOT_FOUND
Language=English
ERROR_CTX_WD_NOT_FOUND - The specified terminal connection driver was not found in the system path.
.
Language=Russian
ERROR_CTX_WD_NOT_FOUND - The specified terminal connection driver was not found in the system path.
.
Language=Polish
ERROR_CTX_WD_NOT_FOUND - Podany sterownik połączenia terminali nie został znaleziony w ścieżce systemu.
.
Language=Romanian
ERROR_CTX_WD_NOT_FOUND - The specified terminal connection driver was not found in the system path.
.

MessageId=7005
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY
Language=English
ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY - A registry key for event logging could not be created for this session.
.
Language=Russian
ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY - A registry key for event logging could not be created for this session.
.
Language=Polish
ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY - Dla tej sesji nie można utworzyć klucza Rejestru obejmującego rejestrowanie w dzienniku zdarzeń.
.
Language=Romanian
ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY - A registry key for event logging could not be created for this session.
.

MessageId=7006
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SERVICE_NAME_COLLISION
Language=English
ERROR_CTX_SERVICE_NAME_COLLISION - A service with the same name already exists on the system.
.
Language=Russian
ERROR_CTX_SERVICE_NAME_COLLISION - A service with the same name already exists on the system.
.
Language=Polish
ERROR_CTX_SERVICE_NAME_COLLISION - Usługa o tej samej nazwie już istnieje w systemie.
.
Language=Romanian
ERROR_CTX_SERVICE_NAME_COLLISION - A service with the same name already exists on the system.
.

MessageId=7007
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CLOSE_PENDING
Language=English
ERROR_CTX_CLOSE_PENDING - A close operation is pending on the session.
.
Language=Russian
ERROR_CTX_CLOSE_PENDING - A close operation is pending on the session.
.
Language=Polish
ERROR_CTX_CLOSE_PENDING - Operacja zamykania czeka na wykonanie (w tej sesji).
.
Language=Romanian
ERROR_CTX_CLOSE_PENDING - A close operation is pending on the session.
.

MessageId=7008
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_NO_OUTBUF
Language=English
ERROR_CTX_NO_OUTBUF - There are no free output buffers available.
.
Language=Russian
ERROR_CTX_NO_OUTBUF - There are no free output buffers available.
.
Language=Polish
ERROR_CTX_NO_OUTBUF - Brak dostępnych wolnych buforów wyjściowych.
.
Language=Romanian
ERROR_CTX_NO_OUTBUF - There are no free output buffers available.
.

MessageId=7009
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_INF_NOT_FOUND
Language=English
ERROR_CTX_MODEM_INF_NOT_FOUND - The MODEM.INF file was not found.
.
Language=Russian
ERROR_CTX_MODEM_INF_NOT_FOUND - The MODEM.INF file was not found.
.
Language=Polish
ERROR_CTX_MODEM_INF_NOT_FOUND - Nie znaleziono pliku MODEM.INF.
.
Language=Romanian
ERROR_CTX_MODEM_INF_NOT_FOUND - The MODEM.INF file was not found.
.

MessageId=7010
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_INVALID_MODEMNAME
Language=English
ERROR_CTX_INVALID_MODEMNAME - The modem name was not found in MODEM.INF.
.
Language=Russian
ERROR_CTX_INVALID_MODEMNAME - The modem name was not found in MODEM.INF.
.
Language=Polish
ERROR_CTX_INVALID_MODEMNAME - Nazwa modemu nie została znaleziona w pliku MODEM.INF.
.
Language=Romanian
ERROR_CTX_INVALID_MODEMNAME - The modem name was not found in MODEM.INF.
.

MessageId=7011
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_ERROR
Language=English
ERROR_CTX_MODEM_RESPONSE_ERROR - The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_ERROR - The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_ERROR - Modem nie akceptuje wysłanego do niego polecenia. Upewnij się, czy nazwa skonfigurowanego modemu jest zgodna z nazwą dołączonego modemu.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_ERROR - The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem.
.

MessageId=7012
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_TIMEOUT
Language=English
ERROR_CTX_MODEM_RESPONSE_TIMEOUT - The modem did not respond to the command sent to it. Verify that the modem is properly cabled and powered on.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_TIMEOUT - The modem did not respond to the command sent to it. Verify that the modem is properly cabled and powered on.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_TIMEOUT - Modem nie odpowiada na wysłane do niego polecenie. Upewnij się, czy modem jest właściwie połączony i czy jest zasilany.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_TIMEOUT - The modem did not respond to the command sent to it. Verify that the modem is properly cabled and powered on.
.

MessageId=7013
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_NO_CARRIER
Language=English
ERROR_CTX_MODEM_RESPONSE_NO_CARRIER - Carrier detect has failed or carrier has been dropped due to disconnect.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_NO_CARRIER - Carrier detect has failed or carrier has been dropped due to disconnect.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_NO_CARRIER - Nie można wykryć nośnej lub nośna została utracona z powodu rozłączenia.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_NO_CARRIER - Carrier detect has failed or carrier has been dropped due to disconnect.
.

MessageId=7014
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE
Language=English
ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE - Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE - Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE - W wymaganym czasie nie wykryto sygnału wybierania. Sprawdź, czy kabel telefoniczny jest poprawnie podłączony i czy nie jest uszkodzony.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE - Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional.
.

MessageId=7015
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_BUSY
Language=English
ERROR_CTX_MODEM_RESPONSE_BUSY - Busy signal detected at remote site on callback.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_BUSY - Busy signal detected at remote site on callback.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_BUSY - Podczas oddzwaniania, w lokacji zdalnej wykryto sygnał zajętości.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_BUSY - Busy signal detected at remote site on callback.
.

MessageId=7016
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_MODEM_RESPONSE_VOICE
Language=English
ERROR_CTX_MODEM_RESPONSE_VOICE - Voice detected at remote site on callback.
.
Language=Russian
ERROR_CTX_MODEM_RESPONSE_VOICE - Voice detected at remote site on callback.
.
Language=Polish
ERROR_CTX_MODEM_RESPONSE_VOICE - Podczas oddzwaniania, w lokacji zdalnej wykryto głos.
.
Language=Romanian
ERROR_CTX_MODEM_RESPONSE_VOICE - Voice detected at remote site on callback.
.

MessageId=7017
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_TD_ERROR
Language=English
ERROR_CTX_TD_ERROR - Transport driver error
.
Language=Russian
ERROR_CTX_TD_ERROR - Transport driver error
.
Language=Polish
ERROR_CTX_TD_ERROR - Błąd sterownika transportu.
.
Language=Romanian
ERROR_CTX_TD_ERROR - Transport driver error
.

MessageId=7022
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATION_NOT_FOUND
Language=English
ERROR_CTX_WINSTATION_NOT_FOUND - The specified session cannot be found.
.
Language=Russian
ERROR_CTX_WINSTATION_NOT_FOUND - The specified session cannot be found.
.
Language=Polish
ERROR_CTX_WINSTATION_NOT_FOUND - Nie można odnaleźć określonej sesji.
.
Language=Romanian
ERROR_CTX_WINSTATION_NOT_FOUND - The specified session cannot be found.
.

MessageId=7023
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATION_ALREADY_EXISTS
Language=English
ERROR_CTX_WINSTATION_ALREADY_EXISTS - The specified session name is already in use.
.
Language=Russian
ERROR_CTX_WINSTATION_ALREADY_EXISTS - The specified session name is already in use.
.
Language=Polish
ERROR_CTX_WINSTATION_ALREADY_EXISTS - Określona nazwa sesji jest już używana.
.
Language=Romanian
ERROR_CTX_WINSTATION_ALREADY_EXISTS - The specified session name is already in use.
.

MessageId=7024
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATION_BUSY
Language=English
ERROR_CTX_WINSTATION_BUSY - The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation.
.
Language=Russian
ERROR_CTX_WINSTATION_BUSY - The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation.
.
Language=Polish
ERROR_CTX_WINSTATION_BUSY - Nie można ukończyć żądanej operacji, ponieważ połączenie Terminala jest zajęte przetwarzaniem operacji łączenia, rozłączania, resetowania lub usuwania.
.
Language=Romanian
ERROR_CTX_WINSTATION_BUSY - The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation.
.

MessageId=7025
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_BAD_VIDEO_MODE
Language=English
ERROR_CTX_BAD_VIDEO_MODE - An attempt has been made to connect to a session whose video mode is not supported by the current client.
.
Language=Russian
ERROR_CTX_BAD_VIDEO_MODE - An attempt has been made to connect to a session whose video mode is not supported by the current client.
.
Language=Polish
ERROR_CTX_BAD_VIDEO_MODE - Podjęto próbę połączenia z sesją, której tryb wideo nie jest obsługiwany przez bieżącego klienta.
.
Language=Romanian
ERROR_CTX_BAD_VIDEO_MODE - An attempt has been made to connect to a session whose video mode is not supported by the current client.
.

MessageId=7035
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_GRAPHICS_INVALID
Language=English
ERROR_CTX_GRAPHICS_INVALID - The application attempted to enable DOS graphics mode. DOS graphics mode is not supported.
.
Language=Russian
ERROR_CTX_GRAPHICS_INVALID - The application attempted to enable DOS graphics mode. DOS graphics mode is not supported.
.
Language=Polish
ERROR_CTX_GRAPHICS_INVALID - Aplikacja próbowała włączyć tryb graficzny DOS. Tryb graficzny DOS nie jest obsługiwany.
.
Language=Romanian
ERROR_CTX_GRAPHICS_INVALID - The application attempted to enable DOS graphics mode. DOS graphics mode is not supported.
.

MessageId=7037
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_LOGON_DISABLED
Language=English
ERROR_CTX_LOGON_DISABLED - Your interactive logon privilege has been disabled. Please contact your administrator.
.
Language=Russian
ERROR_CTX_LOGON_DISABLED - Your interactive logon privilege has been disabled. Please contact your administrator.
.
Language=Polish
ERROR_CTX_LOGON_DISABLED - Twoje uprawnienie do logowania interakcyjnego zostało wyłączone. Skontaktuj się z administratorem systemu.
.
Language=Romanian
ERROR_CTX_LOGON_DISABLED - Your interactive logon privilege has been disabled. Please contact your administrator.
.

MessageId=7038
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_NOT_CONSOLE
Language=English
ERROR_CTX_NOT_CONSOLE - The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access.
.
Language=Russian
ERROR_CTX_NOT_CONSOLE - The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access.
.
Language=Polish
ERROR_CTX_NOT_CONSOLE - Żądana operacja może być wykonana jedynie za pomocą konsoli systemu. Jest to spowodowane najczęściej tym, że sterownik lub biblioteka DLL wymaga bezpośredniego dostępu do konsoli.
.
Language=Romanian
ERROR_CTX_NOT_CONSOLE - The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access.
.

MessageId=7040
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CLIENT_QUERY_TIMEOUT
Language=English
ERROR_CTX_CLIENT_QUERY_TIMEOUT - The client failed to respond to the server connect message.
.
Language=Russian
ERROR_CTX_CLIENT_QUERY_TIMEOUT - The client failed to respond to the server connect message.
.
Language=Polish
ERROR_CTX_CLIENT_QUERY_TIMEOUT - Klient nie odpowiada na komunikat połączenia wysłany przez serwer.
.
Language=Romanian
ERROR_CTX_CLIENT_QUERY_TIMEOUT - The client failed to respond to the server connect message.
.

MessageId=7041
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CONSOLE_DISCONNECT
Language=English
ERROR_CTX_CONSOLE_DISCONNECT - Disconnecting the console session is not supported.
.
Language=Russian
ERROR_CTX_CONSOLE_DISCONNECT - Disconnecting the console session is not supported.
.
Language=Polish
ERROR_CTX_CONSOLE_DISCONNECT - Odłączanie sesji konsoli nie jest obsługiwane.
.
Language=Romanian
ERROR_CTX_CONSOLE_DISCONNECT - Disconnecting the console session is not supported.
.

MessageId=7042
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CONSOLE_CONNECT
Language=English
ERROR_CTX_CONSOLE_CONNECT - Reconnecting a disconnected session to the console is not supported.
.
Language=Russian
ERROR_CTX_CONSOLE_CONNECT - Reconnecting a disconnected session to the console is not supported.
.
Language=Polish
ERROR_CTX_CONSOLE_CONNECT - Ponowne podłączanie odłączonej sesji do konsoli nie jest obsługiwane.
.
Language=Romanian
ERROR_CTX_CONSOLE_CONNECT - Reconnecting a disconnected session to the console is not supported.
.

MessageId=7044
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SHADOW_DENIED
Language=English
ERROR_CTX_SHADOW_DENIED - The request to control another session remotely was denied.
.
Language=Russian
ERROR_CTX_SHADOW_DENIED - The request to control another session remotely was denied.
.
Language=Polish
ERROR_CTX_SHADOW_DENIED - Żądanie kontrolowania zdalnego jeszcze jednej sesji zostało odrzucone.
.
Language=Romanian
ERROR_CTX_SHADOW_DENIED - The request to control another session remotely was denied.
.

MessageId=7045
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATION_ACCESS_DENIED
Language=English
ERROR_CTX_WINSTATION_ACCESS_DENIED - The requested session access is denied.
.
Language=Russian
ERROR_CTX_WINSTATION_ACCESS_DENIED - The requested session access is denied.
.
Language=Polish
ERROR_CTX_WINSTATION_ACCESS_DENIED - Odmowa dostępu do żądanej sesji.
.
Language=Romanian
ERROR_CTX_WINSTATION_ACCESS_DENIED - The requested session access is denied.
.

MessageId=7049
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_INVALID_WD
Language=English
ERROR_CTX_INVALID_WD - The specified terminal connection driver is invalid.
.
Language=Russian
ERROR_CTX_INVALID_WD - The specified terminal connection driver is invalid.
.
Language=Polish
ERROR_CTX_INVALID_WD - Podany sterownik połączenia terminali jest nieprawidłowy.
.
Language=Romanian
ERROR_CTX_INVALID_WD - The specified terminal connection driver is invalid.
.

MessageId=7050
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SHADOW_INVALID
Language=English
ERROR_CTX_SHADOW_INVALID - The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on.
.
Language=Russian
ERROR_CTX_SHADOW_INVALID - The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on.
.
Language=Polish
ERROR_CTX_SHADOW_INVALID - Żądana sesja nie może być kontrolowana zdalnie. Może się to zdarzyć, ponieważ sesja jest odłączona lub użytkownik nie jest zalogowany.
.
Language=Romanian
ERROR_CTX_SHADOW_INVALID - The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on.
.

MessageId=7051
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SHADOW_DISABLED
Language=English
ERROR_CTX_SHADOW_DISABLED - The requested session is not configured to allow remote control.
.
Language=Russian
ERROR_CTX_SHADOW_DISABLED - The requested session is not configured to allow remote control.
.
Language=Polish
ERROR_CTX_SHADOW_DISABLED - Żądana sesja nie jest skonfigurowana tak, aby umożliwiać kontrolę zdalną.
.
Language=Romanian
ERROR_CTX_SHADOW_DISABLED - The requested session is not configured to allow remote control.
.

MessageId=7052
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CLIENT_LICENSE_IN_USE
Language=English
ERROR_CTX_CLIENT_LICENSE_IN_USE - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number is currently being used by another user. Please call your system administrator to obtain a unique license number.
.
Language=Russian
ERROR_CTX_CLIENT_LICENSE_IN_USE - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number is currently being used by another user. Please call your system administrator to obtain a unique license number.
.
Language=Polish
ERROR_CTX_CLIENT_LICENSE_IN_USE - Żądanie połączenia z tym serwerem terminali zostało odrzucone. Numer licencji Twojego klienta serwera terminali jest obecnie używany przez innego użytkownika. Skontaktuj się z administratorem systemu, aby uzyskać unikatowy numer licencji.
.
Language=Romanian
ERROR_CTX_CLIENT_LICENSE_IN_USE - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number is currently being used by another user. Please call your system administrator to obtain a unique license number.
.

MessageId=7053
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CLIENT_LICENSE_NOT_SET
Language=English
ERROR_CTX_CLIENT_LICENSE_NOT_SET - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number has not been entered for this copy of the Terminal Server client. Please contact your system administrator.
.
Language=Russian
ERROR_CTX_CLIENT_LICENSE_NOT_SET - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number has not been entered for this copy of the Terminal Server client. Please contact your system administrator.
.
Language=Polish
ERROR_CTX_CLIENT_LICENSE_NOT_SET - Żądanie połączenia z tym serwerem terminali zostało odrzucone. Numer licencji klienta serwera terminali nie został wprowadzony dla tej kopii klienta serwera terminali. Skontaktuj się z administratorem systemu.
.
Language=Romanian
ERROR_CTX_CLIENT_LICENSE_NOT_SET - Your request to connect to this Terminal Server has been rejected. Your Terminal Server client license number has not been entered for this copy of the Terminal Server client. Please contact your system administrator.
.

MessageId=7054
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_LICENSE_NOT_AVAILABLE
Language=English
ERROR_CTX_LICENSE_NOT_AVAILABLE - The system has reached its licensed logon limit. Please try again later.
.
Language=Russian
ERROR_CTX_LICENSE_NOT_AVAILABLE - The system has reached its licensed logon limit. Please try again later.
.
Language=Polish
ERROR_CTX_LICENSE_NOT_AVAILABLE - System osiągnął ograniczony licencją limit logowania. Spróbuj ponownie później.
.
Language=Romanian
ERROR_CTX_LICENSE_NOT_AVAILABLE - The system has reached its licensed logon limit. Please try again later.
.

MessageId=7055
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_LICENSE_CLIENT_INVALID
Language=English
ERROR_CTX_LICENSE_CLIENT_INVALID - The client you are using is not licensed to use this system. Your logon request is denied.
.
Language=Russian
ERROR_CTX_LICENSE_CLIENT_INVALID - The client you are using is not licensed to use this system. Your logon request is denied.
.
Language=Polish
ERROR_CTX_LICENSE_CLIENT_INVALID - Klient, którego używasz, nie ma licencji na używanie systemu. Żądanie zalogowania zostało odrzucone.
.
Language=Romanian
ERROR_CTX_LICENSE_CLIENT_INVALID - The client you are using is not licensed to use this system. Your logon request is denied.
.

MessageId=7056
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_LICENSE_EXPIRED
Language=English
ERROR_CTX_LICENSE_EXPIRED - The system license has expired. Your logon request is denied.
.
Language=Russian
ERROR_CTX_LICENSE_EXPIRED - The system license has expired. Your logon request is denied.
.
Language=Polish
ERROR_CTX_LICENSE_EXPIRED - Licencja na używanie systemu wygasła. Żądanie zalogowania zostało odrzucone.
.
Language=Romanian
ERROR_CTX_LICENSE_EXPIRED - The system license has expired. Your logon request is denied.
.

MessageId=7057
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SHADOW_NOT_RUNNING
Language=English
ERROR_CTX_SHADOW_NOT_RUNNING - Remote control could not be terminated because the specified session is not currently being remotely controlled.
.
Language=Russian
ERROR_CTX_SHADOW_NOT_RUNNING - Remote control could not be terminated because the specified session is not currently being remotely controlled.
.
Language=Polish
ERROR_CTX_SHADOW_NOT_RUNNING - Nie można przerwać zdalnego sterowania, ponieważ określona sesja nie jest sterowana zdalnie.
.
Language=Romanian
ERROR_CTX_SHADOW_NOT_RUNNING - Remote control could not be terminated because the specified session is not currently being remotely controlled.
.

MessageId=7058
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE
Language=English
ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE - The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported.
.
Language=Russian
ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE - The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported.
.
Language=Polish
ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE - Zdalne sterowanie konsolą zostało przerwane z powodu zmiany trybu wyświetlania. Zmiana trybu wyświetlania w trakcie sesji zdalnego sterowania jest nieobsługiwana.
.
Language=Romanian
ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE - The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported.
.

MessageId=7059
Severity=Success
Facility=System
SymbolicName=ERROR_ACTIVATION_COUNT_EXCEEDED
Language=English
ERROR_ACTIVATION_COUNT_EXCEEDED - Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared.
.
Language=Russian
ERROR_ACTIVATION_COUNT_EXCEEDED - Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared.
.
Language=Polish
ERROR_ACTIVATION_COUNT_EXCEEDED - Aktywacja została zresetowana maksymalną liczbę razy na tę instalację. Czasomierz aktywacji nie zostanie wyczyszczony.
.
Language=Romanian
ERROR_ACTIVATION_COUNT_EXCEEDED - Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared.
.

MessageId=7060
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_WINSTATIONS_DISABLED
Language=English
ERROR_CTX_WINSTATIONS_DISABLED - Remote logins are currently disabled.
.
Language=Russian
ERROR_CTX_WINSTATIONS_DISABLED - Remote logins are currently disabled.
.
Language=Polish
ERROR_CTX_WINSTATIONS_DISABLED - Logowania zdalne są w tej chwili wyłączone.
.
Language=Romanian
ERROR_CTX_WINSTATIONS_DISABLED - Remote logins are currently disabled.
.

MessageId=7061
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED
Language=English
ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED - You do not have the proper encryption level to access this Session.
.
Language=Russian
ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED - You do not have the proper encryption level to access this Session.
.
Language=Polish
ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED - Nie masz odpowiedniego poziomu szyfrowania, aby uzyskać dostęp do tej sesji.
.
Language=Romanian
ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED - You do not have the proper encryption level to access this Session.
.

MessageId=7062
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_SESSION_IN_USE
Language=English
ERROR_CTX_SESSION_IN_USE - The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer.
.
Language=Russian
ERROR_CTX_SESSION_IN_USE - The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer.
.
Language=Polish
ERROR_CTX_SESSION_IN_USE - Użytkownik %s\\%s jest aktualnie zalogowany na tym komputerze. Tylko bieżący użytkownik lub administrator mogą zalogować się na tym komputerze.
.
Language=Romanian
ERROR_CTX_SESSION_IN_USE - The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer.
.

MessageId=7063
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_NO_FORCE_LOGOFF
Language=English
ERROR_CTX_NO_FORCE_LOGOFF - The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off.
.
Language=Russian
ERROR_CTX_NO_FORCE_LOGOFF - The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off.
.
Language=Polish
ERROR_CTX_NO_FORCE_LOGOFF - Użytkownik %s\\%s jest już zalogowany do konsoli tego komputera. Nie masz uprawnienia do logowania w tym czasie. Aby rozwiązać ten problem, skontaktuj się z użytkownikiem %s\\%s i poproś o wylogowanie.
.
Language=Romanian
ERROR_CTX_NO_FORCE_LOGOFF - The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off.
.

MessageId=7064
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_ACCOUNT_RESTRICTION
Language=English
ERROR_CTX_ACCOUNT_RESTRICTION - Unable to log you on because of an account restriction.
.
Language=Russian
ERROR_CTX_ACCOUNT_RESTRICTION - Unable to log you on because of an account restriction.
.
Language=Polish
ERROR_CTX_ACCOUNT_RESTRICTION - Nie możesz się zalogować z powodu ograniczeń konta.
.
Language=Romanian
ERROR_CTX_ACCOUNT_RESTRICTION - Unable to log you on because of an account restriction.
.

MessageId=7065
Severity=Success
Facility=System
SymbolicName=ERROR_RDP_PROTOCOL_ERROR
Language=English
ERROR_RDP_PROTOCOL_ERROR - The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client.
.
Language=Russian
ERROR_RDP_PROTOCOL_ERROR - The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client.
.
Language=Polish
ERROR_RDP_PROTOCOL_ERROR - Składnik protokołu RDP %2 wykrył błąd w strumieniu protokołu i rozłączył klienta.
.
Language=Romanian
ERROR_RDP_PROTOCOL_ERROR - The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client.
.

MessageId=7066
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CDM_CONNECT
Language=English
ERROR_CTX_CDM_CONNECT - The Client Drive Mapping Service Has Connected on Terminal Connection.
.
Language=Russian
ERROR_CTX_CDM_CONNECT - The Client Drive Mapping Service Has Connected on Terminal Connection.
.
Language=Polish
ERROR_CTX_CDM_CONNECT - Usługa klienta mapowania dysków została połączona prze użyciu połączenia Terminal.
.
Language=Romanian
ERROR_CTX_CDM_CONNECT - The Client Drive Mapping Service Has Connected on Terminal Connection.
.

MessageId=7067
Severity=Success
Facility=System
SymbolicName=ERROR_CTX_CDM_DISCONNECT
Language=English
ERROR_CTX_CDM_DISCONNECT - The Client Drive Mapping Service Has Disconnected on Terminal Connection.
.
Language=Russian
ERROR_CTX_CDM_DISCONNECT - The Client Drive Mapping Service Has Disconnected on Terminal Connection.
.
Language=Polish
ERROR_CTX_CDM_DISCONNECT - Usługa klienta mapowania dysków została rozłączona prze użyciu połączenia Terminal.
.
Language=Romanian
ERROR_CTX_CDM_DISCONNECT - The Client Drive Mapping Service Has Disconnected on Terminal Connection.
.

MessageId=8001
Severity=Success
Facility=System
SymbolicName=FRS_ERR_INVALID_API_SEQUENCE
Language=English
FRS_ERR_INVALID_API_SEQUENCE - The file replication service API was called incorrectly.
.
Language=Russian
FRS_ERR_INVALID_API_SEQUENCE - The file replication service API was called incorrectly.
.
Language=Polish
FRS_ERR_INVALID_API_SEQUENCE - Interfejs API usługi replikacji plików został niepoprawnie wywołany.
.
Language=Romanian
FRS_ERR_INVALID_API_SEQUENCE - The file replication service API was called incorrectly.
.

MessageId=8002
Severity=Success
Facility=System
SymbolicName=FRS_ERR_STARTING_SERVICE
Language=English
FRS_ERR_STARTING_SERVICE - The file replication service cannot be started.
.
Language=Russian
FRS_ERR_STARTING_SERVICE - The file replication service cannot be started.
.
Language=Polish
FRS_ERR_STARTING_SERVICE - Nie można uruchomić usługi replikacji plików.
.
Language=Romanian
FRS_ERR_STARTING_SERVICE - The file replication service cannot be started.
.

MessageId=8003
Severity=Success
Facility=System
SymbolicName=FRS_ERR_STOPPING_SERVICE
Language=English
FRS_ERR_STOPPING_SERVICE - The file replication service cannot be stopped.
.
Language=Russian
FRS_ERR_STOPPING_SERVICE - The file replication service cannot be stopped.
.
Language=Polish
FRS_ERR_STOPPING_SERVICE - Nie można zatrzymać usługi replikacji plików.
.
Language=Romanian
FRS_ERR_STOPPING_SERVICE - The file replication service cannot be stopped.
.

MessageId=8004
Severity=Success
Facility=System
SymbolicName=FRS_ERR_INTERNAL_API
Language=English
FRS_ERR_INTERNAL_API - The file replication service API terminated the request. The event log may have more information.
.
Language=Russian
FRS_ERR_INTERNAL_API - The file replication service API terminated the request. The event log may have more information.
.
Language=Polish
FRS_ERR_INTERNAL_API - Interfejs API usługi replikacji plików przerwał żądanie. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_INTERNAL_API - The file replication service API terminated the request. The event log may have more information.
.

MessageId=8005
Severity=Success
Facility=System
SymbolicName=FRS_ERR_INTERNAL
Language=English
FRS_ERR_INTERNAL - The file replication service terminated the request. The event log may have more information.
.
Language=Russian
FRS_ERR_INTERNAL - The file replication service terminated the request. The event log may have more information.
.
Language=Polish
FRS_ERR_INTERNAL - Usługa replikacji plików przerwała żądanie. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_INTERNAL - The file replication service terminated the request. The event log may have more information.
.

MessageId=8006
Severity=Success
Facility=System
SymbolicName=FRS_ERR_SERVICE_COMM
Language=English
FRS_ERR_SERVICE_COMM - The file replication service cannot be contacted. The event log may have more information.
.
Language=Russian
FRS_ERR_SERVICE_COMM - The file replication service cannot be contacted. The event log may have more information.
.
Language=Polish
FRS_ERR_SERVICE_COMM - Nie można skontaktować się z usługą replikacji plików. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_SERVICE_COMM - The file replication service cannot be contacted. The event log may have more information.
.

MessageId=8007
Severity=Success
Facility=System
SymbolicName=FRS_ERR_INSUFFICIENT_PRIV
Language=English
FRS_ERR_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information.
.
Language=Russian
FRS_ERR_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information.
.
Language=Polish
FRS_ERR_INSUFFICIENT_PRIV - Usługa replikacji plików nie może spełnić żądania, ponieważ użytkownik ma niewystarczające uprawnienia. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information.
.

MessageId=8008
Severity=Success
Facility=System
SymbolicName=FRS_ERR_AUTHENTICATION
Language=English
FRS_ERR_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information.
.
Language=Russian
FRS_ERR_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information.
.
Language=Polish
FRS_ERR_AUTHENTICATION - Usługa replikacji plików nie może spełnić żądania, ponieważ uwierzytelniony serwer RPC nie jest dostępny. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information.
.

MessageId=8009
Severity=Success
Facility=System
SymbolicName=FRS_ERR_PARENT_INSUFFICIENT_PRIV
Language=English
FRS_ERR_PARENT_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information.
.
Language=Russian
FRS_ERR_PARENT_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information.
.
Language=Polish
FRS_ERR_PARENT_INSUFFICIENT_PRIV - Usługa replikacji plików nie może spełnić żądania, ponieważ użytkownik ma niewystarczające uprawnienia w odniesieniu do kontrolera domeny. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_PARENT_INSUFFICIENT_PRIV - The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information.
.

MessageId=8010
Severity=Success
Facility=System
SymbolicName=FRS_ERR_PARENT_AUTHENTICATION
Language=English
FRS_ERR_PARENT_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information.
.
Language=Russian
FRS_ERR_PARENT_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information.
.
Language=Polish
FRS_ERR_PARENT_AUTHENTICATION - Usługa replikacji plików nie może spełnić żądania, ponieważ uwierzytelniony serwer RPC nie jest dostępny w kontrolerze domeny. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_PARENT_AUTHENTICATION - The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information.
.

MessageId=8011
Severity=Success
Facility=System
SymbolicName=FRS_ERR_CHILD_TO_PARENT_COMM
Language=English
FRS_ERR_CHILD_TO_PARENT_COMM - The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information.
.
Language=Russian
FRS_ERR_CHILD_TO_PARENT_COMM - The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information.
.
Language=Polish
FRS_ERR_CHILD_TO_PARENT_COMM - Usługa replikacji plików nie może skomunikować się z usługą replikacji w kontrolerze domeny. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_CHILD_TO_PARENT_COMM - The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information.
.

MessageId=8012
Severity=Success
Facility=System
SymbolicName=FRS_ERR_PARENT_TO_CHILD_COMM
Language=English
FRS_ERR_PARENT_TO_CHILD_COMM - The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information.
.
Language=Russian
FRS_ERR_PARENT_TO_CHILD_COMM - The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information.
.
Language=Polish
FRS_ERR_PARENT_TO_CHILD_COMM - Usługa replikacji plików w kontrolerze domeny nie może skomunikować się z usługą replikacji plików na tym komputerze. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_PARENT_TO_CHILD_COMM - The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information.
.

MessageId=8013
Severity=Success
Facility=System
SymbolicName=FRS_ERR_SYSVOL_POPULATE
Language=English
FRS_ERR_SYSVOL_POPULATE - The file replication service cannot populate the system volume because of an internal error. The event log may have more information.
.
Language=Russian
FRS_ERR_SYSVOL_POPULATE - The file replication service cannot populate the system volume because of an internal error. The event log may have more information.
.
Language=Polish
FRS_ERR_SYSVOL_POPULATE - Usługa replikacji plików nie może wypełnić woluminu systemowego, ponieważ wystąpił wewnętrzny błąd. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_SYSVOL_POPULATE - The file replication service cannot populate the system volume because of an internal error. The event log may have more information.
.

MessageId=8014
Severity=Success
Facility=System
SymbolicName=FRS_ERR_SYSVOL_POPULATE_TIMEOUT
Language=English
FRS_ERR_SYSVOL_POPULATE_TIMEOUT - The file replication service cannot populate the system volume because of an internal timeout. The event log may have more information.
.
Language=Russian
FRS_ERR_SYSVOL_POPULATE_TIMEOUT - The file replication service cannot populate the system volume because of an internal timeout. The event log may have more information.
.
Language=Polish
FRS_ERR_SYSVOL_POPULATE_TIMEOUT - Usługa replikacji plików nie może wypełnić woluminu systemowego, ponieważ upłynął wewnętrzny limit czasu. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_SYSVOL_POPULATE_TIMEOUT - The file replication service cannot populate the system volume because of an internal timeout. The event log may have more information.
.

MessageId=8015
Severity=Success
Facility=System
SymbolicName=FRS_ERR_SYSVOL_IS_BUSY
Language=English
FRS_ERR_SYSVOL_IS_BUSY - The file replication service cannot process the request. The system volume is busy with a previous request.
.
Language=Russian
FRS_ERR_SYSVOL_IS_BUSY - The file replication service cannot process the request. The system volume is busy with a previous request.
.
Language=Polish
FRS_ERR_SYSVOL_IS_BUSY - Usługa replikacji plików nie może przetworzyć żądania. Wolumin systemowy jest zajęty poprzednim żądaniem.
.
Language=Romanian
FRS_ERR_SYSVOL_IS_BUSY - The file replication service cannot process the request. The system volume is busy with a previous request.
.

MessageId=8016
Severity=Success
Facility=System
SymbolicName=FRS_ERR_SYSVOL_DEMOTE
Language=English
FRS_ERR_SYSVOL_DEMOTE - The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information.
.
Language=Russian
FRS_ERR_SYSVOL_DEMOTE - The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information.
.
Language=Polish
FRS_ERR_SYSVOL_DEMOTE - Usługa replikacji plików nie może zatrzymać replikacji woluminu systemowego, ponieważ wystąpił błąd wewnętrzny. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
FRS_ERR_SYSVOL_DEMOTE - The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information.
.

MessageId=8017
Severity=Success
Facility=System
SymbolicName=FRS_ERR_INVALID_SERVICE_PARAMETER
Language=English
FRS_ERR_INVALID_SERVICE_PARAMETER - The file replication service detected an invalid parameter.
.
Language=Russian
FRS_ERR_INVALID_SERVICE_PARAMETER - The file replication service detected an invalid parameter.
.
Language=Polish
FRS_ERR_INVALID_SERVICE_PARAMETER - Usługa replikacji plików wykryła nieprawidłowy parametr.
.
Language=Romanian
FRS_ERR_INVALID_SERVICE_PARAMETER - The file replication service detected an invalid parameter.
.

MessageId=8200
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_INSTALLED
Language=English
ERROR_DS_NOT_INSTALLED - An error occurred while installing the directory service. For more information, see the event log.
.
Language=Russian
ERROR_DS_NOT_INSTALLED - An error occurred while installing the directory service. For more information, see the event log.
.
Language=Polish
ERROR_DS_NOT_INSTALLED - Podczas instalowania usługi katalogowej wystąpił błąd. Więcej informacji można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
ERROR_DS_NOT_INSTALLED - An error occurred while installing the directory service. For more information, see the event log.
.

MessageId=8201
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY
Language=English
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY - The directory service evaluated group memberships locally.
.
Language=Russian
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY - The directory service evaluated group memberships locally.
.
Language=Polish
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY - Usługa katalogowa oceniła lokalnie członkostwo w grupach.
.
Language=Romanian
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY - The directory service evaluated group memberships locally.
.

MessageId=8202
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_ATTRIBUTE_OR_VALUE
Language=English
ERROR_DS_NO_ATTRIBUTE_OR_VALUE - The specified directory service attribute or value does not exist.
.
Language=Russian
ERROR_DS_NO_ATTRIBUTE_OR_VALUE - The specified directory service attribute or value does not exist.
.
Language=Polish
ERROR_DS_NO_ATTRIBUTE_OR_VALUE - Określony atrybut lub wartość usługi katalogowej nie istnieje.
.
Language=Romanian
ERROR_DS_NO_ATTRIBUTE_OR_VALUE - The specified directory service attribute or value does not exist.
.

MessageId=8203
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_ATTRIBUTE_SYNTAX
Language=English
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX - The attribute syntax specified to the directory service is invalid.
.
Language=Russian
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX - The attribute syntax specified to the directory service is invalid.
.
Language=Polish
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX - Składnia atrybutu podana dla usługi katalogowej jest nieprawidłowa.
.
Language=Romanian
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX - The attribute syntax specified to the directory service is invalid.
.

MessageId=8204
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED
Language=English
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED - The attribute type specified to the directory service is not defined.
.
Language=Russian
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED - The attribute type specified to the directory service is not defined.
.
Language=Polish
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED - Typ atrybutu podany dla usługi katalogowej nie jest zdefiniowany.
.
Language=Romanian
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED - The attribute type specified to the directory service is not defined.
.

MessageId=8205
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS
Language=English
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS - The specified directory service attribute or value already exists.
.
Language=Russian
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS - The specified directory service attribute or value already exists.
.
Language=Polish
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS - Określony atrybut lub wartość usługi katalogowej już istnieje.
.
Language=Romanian
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS - The specified directory service attribute or value already exists.
.

MessageId=8206
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BUSY
Language=English
ERROR_DS_BUSY - The directory service is busy.
.
Language=Russian
ERROR_DS_BUSY - The directory service is busy.
.
Language=Polish
ERROR_DS_BUSY - Usługa katalogowa jest zajęta.
.
Language=Romanian
ERROR_DS_BUSY - The directory service is busy.
.

MessageId=8207
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNAVAILABLE
Language=English
ERROR_DS_UNAVAILABLE - The directory service is unavailable.
.
Language=Russian
ERROR_DS_UNAVAILABLE - The directory service is unavailable.
.
Language=Polish
ERROR_DS_UNAVAILABLE - Usługa katalogowa jest niedostępna.
.
Language=Romanian
ERROR_DS_UNAVAILABLE - The directory service is unavailable.
.

MessageId=8208
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_RIDS_ALLOCATED
Language=English
ERROR_DS_NO_RIDS_ALLOCATED - The directory service was unable to allocate a relative identifier.
.
Language=Russian
ERROR_DS_NO_RIDS_ALLOCATED - The directory service was unable to allocate a relative identifier.
.
Language=Polish
ERROR_DS_NO_RIDS_ALLOCATED - Usługa katalogowa nie może przydzielić identyfikatora względnego.
.
Language=Romanian
ERROR_DS_NO_RIDS_ALLOCATED - The directory service was unable to allocate a relative identifier.
.

MessageId=8209
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_MORE_RIDS
Language=English
ERROR_DS_NO_MORE_RIDS - The directory service has exhausted the pool of relative identifiers.
.
Language=Russian
ERROR_DS_NO_MORE_RIDS - The directory service has exhausted the pool of relative identifiers.
.
Language=Polish
ERROR_DS_NO_MORE_RIDS - Usługa katalogowa wyczerpała pulę identyfikatorów względnych.
.
Language=Romanian
ERROR_DS_NO_MORE_RIDS - The directory service has exhausted the pool of relative identifiers.
.

MessageId=8210
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INCORRECT_ROLE_OWNER
Language=English
ERROR_DS_INCORRECT_ROLE_OWNER - The requested operation could not be performed because the directory service is not the master for that type of operation.
.
Language=Russian
ERROR_DS_INCORRECT_ROLE_OWNER - The requested operation could not be performed because the directory service is not the master for that type of operation.
.
Language=Polish
ERROR_DS_INCORRECT_ROLE_OWNER - Nie można wykonać żądanej operacji, ponieważ usługa katalogowa nie jest usługą wzorcową dla tego typu operacji.
.
Language=Romanian
ERROR_DS_INCORRECT_ROLE_OWNER - The requested operation could not be performed because the directory service is not the master for that type of operation.
.

MessageId=8211
Severity=Success
Facility=System
SymbolicName=ERROR_DS_RIDMGR_INIT_ERROR
Language=English
ERROR_DS_RIDMGR_INIT_ERROR - The directory service was unable to initialize the subsystem that allocates relative identifiers.
.
Language=Russian
ERROR_DS_RIDMGR_INIT_ERROR - The directory service was unable to initialize the subsystem that allocates relative identifiers.
.
Language=Polish
ERROR_DS_RIDMGR_INIT_ERROR - Usługa katalogowa nie może zainicjować podsystemu przydzielającego identyfikatory względne.
.
Language=Romanian
ERROR_DS_RIDMGR_INIT_ERROR - The directory service was unable to initialize the subsystem that allocates relative identifiers.
.

MessageId=8212
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_CLASS_VIOLATION
Language=English
ERROR_DS_OBJ_CLASS_VIOLATION - The requested operation did not satisfy one or more constraints associated with the class of the object.
.
Language=Russian
ERROR_DS_OBJ_CLASS_VIOLATION - The requested operation did not satisfy one or more constraints associated with the class of the object.
.
Language=Polish
ERROR_DS_OBJ_CLASS_VIOLATION - Żądana operacja nie spełnia jednego lub więcej warunków ograniczających skojarzonych z klasą obiektu.
.
Language=Romanian
ERROR_DS_OBJ_CLASS_VIOLATION - The requested operation did not satisfy one or more constraints associated with the class of the object.
.

MessageId=8213
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ON_NON_LEAF
Language=English
ERROR_DS_CANT_ON_NON_LEAF - The directory service can perform the requested operation only on a leaf object.
.
Language=Russian
ERROR_DS_CANT_ON_NON_LEAF - The directory service can perform the requested operation only on a leaf object.
.
Language=Polish
ERROR_DS_CANT_ON_NON_LEAF - Usługa katalogowa może przeprowadzić żądaną operację tylko na obiekcie typu liść.
.
Language=Romanian
ERROR_DS_CANT_ON_NON_LEAF - The directory service can perform the requested operation only on a leaf object.
.

MessageId=8214
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ON_RDN
Language=English
ERROR_DS_CANT_ON_RDN - The directory service cannot perform the requested operation on the RDN attribute of an object.
.
Language=Russian
ERROR_DS_CANT_ON_RDN - The directory service cannot perform the requested operation on the RDN attribute of an object.
.
Language=Polish
ERROR_DS_CANT_ON_RDN - Usługa katalogowa nie może przeprowadzić żądanej operacji na atrybucie RDN obiektu.
.
Language=Romanian
ERROR_DS_CANT_ON_RDN - The directory service cannot perform the requested operation on the RDN attribute of an object.
.

MessageId=8215
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOD_OBJ_CLASS
Language=English
ERROR_DS_CANT_MOD_OBJ_CLASS - The directory service detected an attempt to modify the object class of an object.
.
Language=Russian
ERROR_DS_CANT_MOD_OBJ_CLASS - The directory service detected an attempt to modify the object class of an object.
.
Language=Polish
ERROR_DS_CANT_MOD_OBJ_CLASS - Usługa katalogowa wykryła próbę modyfikacji klasy obiektu.
.
Language=Romanian
ERROR_DS_CANT_MOD_OBJ_CLASS - The directory service detected an attempt to modify the object class of an object.
.

MessageId=8216
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CROSS_DOM_MOVE_ERROR
Language=English
ERROR_DS_CROSS_DOM_MOVE_ERROR - The requested cross-domain move operation could not be performed.
.
Language=Russian
ERROR_DS_CROSS_DOM_MOVE_ERROR - The requested cross-domain move operation could not be performed.
.
Language=Polish
ERROR_DS_CROSS_DOM_MOVE_ERROR - Nie można wykonać żądanej operacji przeniesienia poza domenę.
.
Language=Romanian
ERROR_DS_CROSS_DOM_MOVE_ERROR - The requested cross-domain move operation could not be performed.
.

MessageId=8217
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GC_NOT_AVAILABLE
Language=English
ERROR_DS_GC_NOT_AVAILABLE - Unable to contact the global catalog server.
.
Language=Russian
ERROR_DS_GC_NOT_AVAILABLE - Unable to contact the global catalog server.
.
Language=Polish
ERROR_DS_GC_NOT_AVAILABLE - Nie można skontaktować się z serwerem wykazu globalnego.
.
Language=Romanian
ERROR_DS_GC_NOT_AVAILABLE - Unable to contact the global catalog server.
.

MessageId=8218
Severity=Success
Facility=System
SymbolicName=ERROR_SHARED_POLICY
Language=English
ERROR_SHARED_POLICY - The policy object is shared and can only be modified at the root.
.
Language=Russian
ERROR_SHARED_POLICY - The policy object is shared and can only be modified at the root.
.
Language=Polish
ERROR_SHARED_POLICY - Obiekt zasad jest udostępniany i może być tylko modyfikowany na poziomie głównym.
.
Language=Romanian
ERROR_SHARED_POLICY - The policy object is shared and can only be modified at the root.
.

MessageId=8219
Severity=Success
Facility=System
SymbolicName=ERROR_POLICY_OBJECT_NOT_FOUND
Language=English
ERROR_POLICY_OBJECT_NOT_FOUND - The policy object does not exist.
.
Language=Russian
ERROR_POLICY_OBJECT_NOT_FOUND - The policy object does not exist.
.
Language=Polish
ERROR_POLICY_OBJECT_NOT_FOUND - Obiekt zasad nie istnieje.
.
Language=Romanian
ERROR_POLICY_OBJECT_NOT_FOUND - The policy object does not exist.
.

MessageId=8220
Severity=Success
Facility=System
SymbolicName=ERROR_POLICY_ONLY_IN_DS
Language=English
ERROR_POLICY_ONLY_IN_DS - The requested policy information is only in the directory service.
.
Language=Russian
ERROR_POLICY_ONLY_IN_DS - The requested policy information is only in the directory service.
.
Language=Polish
ERROR_POLICY_ONLY_IN_DS - Żądane informacje o zasadach występują tylko w usłudze katalogowej.
.
Language=Romanian
ERROR_POLICY_ONLY_IN_DS - The requested policy information is only in the directory service.
.

MessageId=8221
Severity=Success
Facility=System
SymbolicName=ERROR_PROMOTION_ACTIVE
Language=English
ERROR_PROMOTION_ACTIVE - A domain controller promotion is currently active.
.
Language=Russian
ERROR_PROMOTION_ACTIVE - A domain controller promotion is currently active.
.
Language=Polish
ERROR_PROMOTION_ACTIVE - Proces promocji kontrolera domeny jest obecnie aktywny.
.
Language=Romanian
ERROR_PROMOTION_ACTIVE - A domain controller promotion is currently active.
.

MessageId=8222
Severity=Success
Facility=System
SymbolicName=ERROR_NO_PROMOTION_ACTIVE
Language=English
ERROR_NO_PROMOTION_ACTIVE - A domain controller promotion is not currently active
.
Language=Russian
ERROR_NO_PROMOTION_ACTIVE - A domain controller promotion is not currently active
.
Language=Polish
ERROR_NO_PROMOTION_ACTIVE - Proces promocji kontrolera domeny nie jest obecnie aktywny.
.
Language=Romanian
ERROR_NO_PROMOTION_ACTIVE - A domain controller promotion is not currently active
.

MessageId=8224
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OPERATIONS_ERROR
Language=English
ERROR_DS_OPERATIONS_ERROR - An operations error occurred.
.
Language=Russian
ERROR_DS_OPERATIONS_ERROR - An operations error occurred.
.
Language=Polish
ERROR_DS_OPERATIONS_ERROR - Wystąpił błąd operacji.
.
Language=Romanian
ERROR_DS_OPERATIONS_ERROR - An operations error occurred.
.

MessageId=8225
Severity=Success
Facility=System
SymbolicName=ERROR_DS_PROTOCOL_ERROR
Language=English
ERROR_DS_PROTOCOL_ERROR - A protocol error occurred.
.
Language=Russian
ERROR_DS_PROTOCOL_ERROR - A protocol error occurred.
.
Language=Polish
ERROR_DS_PROTOCOL_ERROR - Wystąpił błąd protokołu.
.
Language=Romanian
ERROR_DS_PROTOCOL_ERROR - A protocol error occurred.
.

MessageId=8226
Severity=Success
Facility=System
SymbolicName=ERROR_DS_TIMELIMIT_EXCEEDED
Language=English
ERROR_DS_TIMELIMIT_EXCEEDED - The time limit for this request was exceeded.
.
Language=Russian
ERROR_DS_TIMELIMIT_EXCEEDED - The time limit for this request was exceeded.
.
Language=Polish
ERROR_DS_TIMELIMIT_EXCEEDED - Limit czasu dla tego żądania został przekroczony.
.
Language=Romanian
ERROR_DS_TIMELIMIT_EXCEEDED - The time limit for this request was exceeded.
.

MessageId=8227
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SIZELIMIT_EXCEEDED
Language=English
ERROR_DS_SIZELIMIT_EXCEEDED - The size limit for this request was exceeded.
.
Language=Russian
ERROR_DS_SIZELIMIT_EXCEEDED - The size limit for this request was exceeded.
.
Language=Polish
ERROR_DS_SIZELIMIT_EXCEEDED - Limit rozmiaru dla tego żądania został przekroczony.
.
Language=Romanian
ERROR_DS_SIZELIMIT_EXCEEDED - The size limit for this request was exceeded.
.

MessageId=8228
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ADMIN_LIMIT_EXCEEDED
Language=English
ERROR_DS_ADMIN_LIMIT_EXCEEDED - The administrative limit for this request was exceeded.
.
Language=Russian
ERROR_DS_ADMIN_LIMIT_EXCEEDED - The administrative limit for this request was exceeded.
.
Language=Polish
ERROR_DS_ADMIN_LIMIT_EXCEEDED - Limit administracyjny dla tego żądania został przekroczony.
.
Language=Romanian
ERROR_DS_ADMIN_LIMIT_EXCEEDED - The administrative limit for this request was exceeded.
.

MessageId=8229
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COMPARE_FALSE
Language=English
ERROR_DS_COMPARE_FALSE - The compare response was false.
.
Language=Russian
ERROR_DS_COMPARE_FALSE - The compare response was false.
.
Language=Polish
ERROR_DS_COMPARE_FALSE - Wynik porównania: fałsz.
.
Language=Romanian
ERROR_DS_COMPARE_FALSE - The compare response was false.
.

MessageId=8230
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COMPARE_TRUE
Language=English
ERROR_DS_COMPARE_TRUE - The compare response was true.
.
Language=Russian
ERROR_DS_COMPARE_TRUE - The compare response was true.
.
Language=Polish
ERROR_DS_COMPARE_TRUE - Wynik porównania: prawda.
.
Language=Romanian
ERROR_DS_COMPARE_TRUE - The compare response was true.
.

MessageId=8231
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AUTH_METHOD_NOT_SUPPORTED
Language=English
ERROR_DS_AUTH_METHOD_NOT_SUPPORTED - The requested authentication method is not supported by the server.
.
Language=Russian
ERROR_DS_AUTH_METHOD_NOT_SUPPORTED - The requested authentication method is not supported by the server.
.
Language=Polish
ERROR_DS_AUTH_METHOD_NOT_SUPPORTED - Żądana metoda uwierzytelniania nie jest obsługiwana przez serwer.
.
Language=Romanian
ERROR_DS_AUTH_METHOD_NOT_SUPPORTED - The requested authentication method is not supported by the server.
.

MessageId=8232
Severity=Success
Facility=System
SymbolicName=ERROR_DS_STRONG_AUTH_REQUIRED
Language=English
ERROR_DS_STRONG_AUTH_REQUIRED - A more secure authentication method is required for this server.
.
Language=Russian
ERROR_DS_STRONG_AUTH_REQUIRED - A more secure authentication method is required for this server.
.
Language=Polish
ERROR_DS_STRONG_AUTH_REQUIRED - Dla tego serwera jest wymagana bardziej bezpieczna metoda uwierzytelniania.
.
Language=Romanian
ERROR_DS_STRONG_AUTH_REQUIRED - A more secure authentication method is required for this server.
.

MessageId=8233
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INAPPROPRIATE_AUTH
Language=English
ERROR_DS_INAPPROPRIATE_AUTH - Inappropriate authentication.
.
Language=Russian
ERROR_DS_INAPPROPRIATE_AUTH - Inappropriate authentication.
.
Language=Polish
ERROR_DS_INAPPROPRIATE_AUTH - Nieodpowiednie uwierzytelnienia.
.
Language=Romanian
ERROR_DS_INAPPROPRIATE_AUTH - Inappropriate authentication.
.

MessageId=8234
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AUTH_UNKNOWN
Language=English
ERROR_DS_AUTH_UNKNOWN - The authentication mechanism is unknown.
.
Language=Russian
ERROR_DS_AUTH_UNKNOWN - The authentication mechanism is unknown.
.
Language=Polish
ERROR_DS_AUTH_UNKNOWN - Mechanizm uwierzytelniania jest nieznany.
.
Language=Romanian
ERROR_DS_AUTH_UNKNOWN - The authentication mechanism is unknown.
.

MessageId=8235
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REFERRAL
Language=English
ERROR_DS_REFERRAL - A referral was returned from the server.
.
Language=Russian
ERROR_DS_REFERRAL - A referral was returned from the server.
.
Language=Polish
ERROR_DS_REFERRAL - Odniesienie zostało zwrócone z serwera.
.
Language=Romanian
ERROR_DS_REFERRAL - A referral was returned from the server.
.

MessageId=8236
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNAVAILABLE_CRIT_EXTENSION
Language=English
ERROR_DS_UNAVAILABLE_CRIT_EXTENSION - The server does not support the requested critical extension.
.
Language=Russian
ERROR_DS_UNAVAILABLE_CRIT_EXTENSION - The server does not support the requested critical extension.
.
Language=Polish
ERROR_DS_UNAVAILABLE_CRIT_EXTENSION - Serwer nie obsługuje żądanego rozszerzenia krytycznego.
.
Language=Romanian
ERROR_DS_UNAVAILABLE_CRIT_EXTENSION - The server does not support the requested critical extension.
.

MessageId=8237
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CONFIDENTIALITY_REQUIRED
Language=English
ERROR_DS_CONFIDENTIALITY_REQUIRED - This request requires a secure connection.
.
Language=Russian
ERROR_DS_CONFIDENTIALITY_REQUIRED - This request requires a secure connection.
.
Language=Polish
ERROR_DS_CONFIDENTIALITY_REQUIRED - To żądanie wymaga bezpiecznego połączenia.
.
Language=Romanian
ERROR_DS_CONFIDENTIALITY_REQUIRED - This request requires a secure connection.
.

MessageId=8238
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INAPPROPRIATE_MATCHING
Language=English
ERROR_DS_INAPPROPRIATE_MATCHING - Inappropriate matching.
.
Language=Russian
ERROR_DS_INAPPROPRIATE_MATCHING - Inappropriate matching.
.
Language=Polish
ERROR_DS_INAPPROPRIATE_MATCHING - Nieodpowiednie dopasowanie.
.
Language=Romanian
ERROR_DS_INAPPROPRIATE_MATCHING - Inappropriate matching.
.

MessageId=8239
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CONSTRAINT_VIOLATION
Language=English
ERROR_DS_CONSTRAINT_VIOLATION - A constraint violation occurred.
.
Language=Russian
ERROR_DS_CONSTRAINT_VIOLATION - A constraint violation occurred.
.
Language=Polish
ERROR_DS_CONSTRAINT_VIOLATION - Wystąpiło naruszenie więzów.
.
Language=Romanian
ERROR_DS_CONSTRAINT_VIOLATION - A constraint violation occurred.
.

MessageId=8240
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_SUCH_OBJECT
Language=English
ERROR_DS_NO_SUCH_OBJECT - There is no such object on the server.
.
Language=Russian
ERROR_DS_NO_SUCH_OBJECT - There is no such object on the server.
.
Language=Polish
ERROR_DS_NO_SUCH_OBJECT - Nie ma takiego obiektu na serwerze.
.
Language=Romanian
ERROR_DS_NO_SUCH_OBJECT - There is no such object on the server.
.

MessageId=8241
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ALIAS_PROBLEM
Language=English
ERROR_DS_ALIAS_PROBLEM - There is an alias problem.
.
Language=Russian
ERROR_DS_ALIAS_PROBLEM - There is an alias problem.
.
Language=Polish
ERROR_DS_ALIAS_PROBLEM - Problem z aliasem.
.
Language=Romanian
ERROR_DS_ALIAS_PROBLEM - There is an alias problem.
.

MessageId=8242
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_DN_SYNTAX
Language=English
ERROR_DS_INVALID_DN_SYNTAX - An invalid dn syntax has been specified.
.
Language=Russian
ERROR_DS_INVALID_DN_SYNTAX - An invalid dn syntax has been specified.
.
Language=Polish
ERROR_DS_INVALID_DN_SYNTAX - Użyto niepoprawnej składni nazwy domeny.
.
Language=Romanian
ERROR_DS_INVALID_DN_SYNTAX - An invalid dn syntax has been specified.
.

MessageId=8243
Severity=Success
Facility=System
SymbolicName=ERROR_DS_IS_LEAF
Language=English
ERROR_DS_IS_LEAF - The object is a leaf object.
.
Language=Russian
ERROR_DS_IS_LEAF - The object is a leaf object.
.
Language=Polish
ERROR_DS_IS_LEAF - Obiekt jest obiektem typu liść.
.
Language=Romanian
ERROR_DS_IS_LEAF - The object is a leaf object.
.

MessageId=8244
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ALIAS_DEREF_PROBLEM
Language=English
ERROR_DS_ALIAS_DEREF_PROBLEM - There is an alias dereferencing problem.
.
Language=Russian
ERROR_DS_ALIAS_DEREF_PROBLEM - There is an alias dereferencing problem.
.
Language=Polish
ERROR_DS_ALIAS_DEREF_PROBLEM - Występuje problem z usunięciem odwołania do aliasu.
.
Language=Romanian
ERROR_DS_ALIAS_DEREF_PROBLEM - There is an alias dereferencing problem.
.

MessageId=8245
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNWILLING_TO_PERFORM
Language=English
ERROR_DS_UNWILLING_TO_PERFORM - The server is unwilling to process the request.
.
Language=Russian
ERROR_DS_UNWILLING_TO_PERFORM - The server is unwilling to process the request.
.
Language=Polish
ERROR_DS_UNWILLING_TO_PERFORM - Serwer odmawia przetwarzania żądania.
.
Language=Romanian
ERROR_DS_UNWILLING_TO_PERFORM - The server is unwilling to process the request.
.

MessageId=8246
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOOP_DETECT
Language=English
ERROR_DS_LOOP_DETECT - A loop has been detected.
.
Language=Russian
ERROR_DS_LOOP_DETECT - A loop has been detected.
.
Language=Polish
ERROR_DS_LOOP_DETECT - Została wykryta pętla.
.
Language=Romanian
ERROR_DS_LOOP_DETECT - A loop has been detected.
.

MessageId=8247
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAMING_VIOLATION
Language=English
ERROR_DS_NAMING_VIOLATION - There is a naming violation.
.
Language=Russian
ERROR_DS_NAMING_VIOLATION - There is a naming violation.
.
Language=Polish
ERROR_DS_NAMING_VIOLATION - Naruszenie zasad nazewnictwa.
.
Language=Romanian
ERROR_DS_NAMING_VIOLATION - There is a naming violation.
.

MessageId=8248
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJECT_RESULTS_TOO_LARGE
Language=English
ERROR_DS_OBJECT_RESULTS_TOO_LARGE - The result set is too large.
.
Language=Russian
ERROR_DS_OBJECT_RESULTS_TOO_LARGE - The result set is too large.
.
Language=Polish
ERROR_DS_OBJECT_RESULTS_TOO_LARGE - Zestaw wynikowy jest zbyt duży.
.
Language=Romanian
ERROR_DS_OBJECT_RESULTS_TOO_LARGE - The result set is too large.
.

MessageId=8249
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AFFECTS_MULTIPLE_DSAS
Language=English
ERROR_DS_AFFECTS_MULTIPLE_DSAS - The operation affects multiple DSAs
.
Language=Russian
ERROR_DS_AFFECTS_MULTIPLE_DSAS - The operation affects multiple DSAs
.
Language=Polish
ERROR_DS_AFFECTS_MULTIPLE_DSAS - Operacja wpływa na wielu agentów DSA.
.
Language=Romanian
ERROR_DS_AFFECTS_MULTIPLE_DSAS - The operation affects multiple DSAs
.

MessageId=8250
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SERVER_DOWN
Language=English
ERROR_DS_SERVER_DOWN - The server is not operational.
.
Language=Russian
ERROR_DS_SERVER_DOWN - The server is not operational.
.
Language=Polish
ERROR_DS_SERVER_DOWN - Serwer nie działa.
.
Language=Romanian
ERROR_DS_SERVER_DOWN - The server is not operational.
.

MessageId=8251
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOCAL_ERROR
Language=English
ERROR_DS_LOCAL_ERROR - A local error has occurred.
.
Language=Russian
ERROR_DS_LOCAL_ERROR - A local error has occurred.
.
Language=Polish
ERROR_DS_LOCAL_ERROR - Wstąpił błąd lokalny.
.
Language=Romanian
ERROR_DS_LOCAL_ERROR - A local error has occurred.
.

MessageId=8252
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ENCODING_ERROR
Language=English
ERROR_DS_ENCODING_ERROR - An encoding error has occurred.
.
Language=Russian
ERROR_DS_ENCODING_ERROR - An encoding error has occurred.
.
Language=Polish
ERROR_DS_ENCODING_ERROR - Wystąpił błąd kodowania.
.
Language=Romanian
ERROR_DS_ENCODING_ERROR - An encoding error has occurred.
.

MessageId=8253
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DECODING_ERROR
Language=English
ERROR_DS_DECODING_ERROR - A decoding error has occurred.
.
Language=Russian
ERROR_DS_DECODING_ERROR - A decoding error has occurred.
.
Language=Polish
ERROR_DS_DECODING_ERROR - Wystąpił błąd dekodowania.
.
Language=Romanian
ERROR_DS_DECODING_ERROR - A decoding error has occurred.
.

MessageId=8254
Severity=Success
Facility=System
SymbolicName=ERROR_DS_FILTER_UNKNOWN
Language=English
ERROR_DS_FILTER_UNKNOWN - The search filter cannot be recognized.
.
Language=Russian
ERROR_DS_FILTER_UNKNOWN - The search filter cannot be recognized.
.
Language=Polish
ERROR_DS_FILTER_UNKNOWN - Nieznany filtr wyszukiwania.
.
Language=Romanian
ERROR_DS_FILTER_UNKNOWN - The search filter cannot be recognized.
.

MessageId=8255
Severity=Success
Facility=System
SymbolicName=ERROR_DS_PARAM_ERROR
Language=English
ERROR_DS_PARAM_ERROR - One or more parameters are illegal.
.
Language=Russian
ERROR_DS_PARAM_ERROR - One or more parameters are illegal.
.
Language=Polish
ERROR_DS_PARAM_ERROR - Co najmniej jeden z parametrów jest niedozwolony.
.
Language=Romanian
ERROR_DS_PARAM_ERROR - One or more parameters are illegal.
.

MessageId=8256
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_SUPPORTED
Language=English
ERROR_DS_NOT_SUPPORTED - The specified method is not supported.
.
Language=Russian
ERROR_DS_NOT_SUPPORTED - The specified method is not supported.
.
Language=Polish
ERROR_DS_NOT_SUPPORTED - Podana metoda nie jest obsługiwana.
.
Language=Romanian
ERROR_DS_NOT_SUPPORTED - The specified method is not supported.
.

MessageId=8257
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_RESULTS_RETURNED
Language=English
ERROR_DS_NO_RESULTS_RETURNED - No results were returned.
.
Language=Russian
ERROR_DS_NO_RESULTS_RETURNED - No results were returned.
.
Language=Polish
ERROR_DS_NO_RESULTS_RETURNED - Nie zwrócono żadnych wyników.
.
Language=Romanian
ERROR_DS_NO_RESULTS_RETURNED - No results were returned.
.

MessageId=8258
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CONTROL_NOT_FOUND
Language=English
ERROR_DS_CONTROL_NOT_FOUND - The specified control is not supported by the server.
.
Language=Russian
ERROR_DS_CONTROL_NOT_FOUND - The specified control is not supported by the server.
.
Language=Polish
ERROR_DS_CONTROL_NOT_FOUND - Podany formant nie jest obsługiwany przez serwer.
.
Language=Romanian
ERROR_DS_CONTROL_NOT_FOUND - The specified control is not supported by the server.
.

MessageId=8259
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CLIENT_LOOP
Language=English
ERROR_DS_CLIENT_LOOP - A referral loop was detected by the client.
.
Language=Russian
ERROR_DS_CLIENT_LOOP - A referral loop was detected by the client.
.
Language=Polish
ERROR_DS_CLIENT_LOOP - Klient wykrył pętlę odniesień.
.
Language=Romanian
ERROR_DS_CLIENT_LOOP - A referral loop was detected by the client.
.

MessageId=8260
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REFERRAL_LIMIT_EXCEEDED
Language=English
ERROR_DS_REFERRAL_LIMIT_EXCEEDED - The preset referral limit was exceeded.
.
Language=Russian
ERROR_DS_REFERRAL_LIMIT_EXCEEDED - The preset referral limit was exceeded.
.
Language=Polish
ERROR_DS_REFERRAL_LIMIT_EXCEEDED - Ustalony wstępnie limit odniesień został przekroczony.
.
Language=Romanian
ERROR_DS_REFERRAL_LIMIT_EXCEEDED - The preset referral limit was exceeded.
.

MessageId=8261
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SORT_CONTROL_MISSING
Language=English
ERROR_DS_SORT_CONTROL_MISSING - The search requires a SORT control.
.
Language=Russian
ERROR_DS_SORT_CONTROL_MISSING - The search requires a SORT control.
.
Language=Polish
ERROR_DS_SORT_CONTROL_MISSING - Wyszukiwanie wymaga elementu sterującego SORT.
.
Language=Romanian
ERROR_DS_SORT_CONTROL_MISSING - The search requires a SORT control.
.

MessageId=8262
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OFFSET_RANGE_ERROR
Language=English
ERROR_DS_OFFSET_RANGE_ERROR - The search results exceed the offset range specified.
.
Language=Russian
ERROR_DS_OFFSET_RANGE_ERROR - The search results exceed the offset range specified.
.
Language=Polish
ERROR_DS_OFFSET_RANGE_ERROR - Wyniki wyszukiwania przekraczają określony zakres przesunięcia.
.
Language=Romanian
ERROR_DS_OFFSET_RANGE_ERROR - The search results exceed the offset range specified.
.

MessageId=8301
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ROOT_MUST_BE_NC
Language=English
ERROR_DS_ROOT_MUST_BE_NC - The root object must be the head of a naming context. The root object cannot have an instantiated parent.
.
Language=Russian
ERROR_DS_ROOT_MUST_BE_NC - The root object must be the head of a naming context. The root object cannot have an instantiated parent.
.
Language=Polish
ERROR_DS_ROOT_MUST_BE_NC - Obiekt główny musi być na początku kontekstu nazewnictwa. Rodzicem obiektu głównego nie może być wystąpienie obiektu.
.
Language=Romanian
ERROR_DS_ROOT_MUST_BE_NC - The root object must be the head of a naming context. The root object cannot have an instantiated parent.
.

MessageId=8302
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ADD_REPLICA_INHIBITED
Language=English
ERROR_DS_ADD_REPLICA_INHIBITED - The add replica operation cannot be performed. The naming context must be writeable in order to create the replica.
.
Language=Russian
ERROR_DS_ADD_REPLICA_INHIBITED - The add replica operation cannot be performed. The naming context must be writeable in order to create the replica.
.
Language=Polish
ERROR_DS_ADD_REPLICA_INHIBITED - Nie można wykonać operacji dodania repliki. Kontekst nazewnictwa musi mieć możliwość zapisu, Aby można było utworzyć replikę, musi istnieć możliwość zapisywania w kontekście nazewnictwa.
.
Language=Romanian
ERROR_DS_ADD_REPLICA_INHIBITED - The add replica operation cannot be performed. The naming context must be writeable in order to create the replica.
.

MessageId=8303
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_NOT_DEF_IN_SCHEMA
Language=English
ERROR_DS_ATT_NOT_DEF_IN_SCHEMA - A reference to an attribute that is not defined in the schema occurred.
.
Language=Russian
ERROR_DS_ATT_NOT_DEF_IN_SCHEMA - A reference to an attribute that is not defined in the schema occurred.
.
Language=Polish
ERROR_DS_ATT_NOT_DEF_IN_SCHEMA - Wystąpiło odwołanie do atrybutu, który nie jest zdefiniowany w schemacie.
.
Language=Romanian
ERROR_DS_ATT_NOT_DEF_IN_SCHEMA - A reference to an attribute that is not defined in the schema occurred.
.

MessageId=8304
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MAX_OBJ_SIZE_EXCEEDED
Language=English
ERROR_DS_MAX_OBJ_SIZE_EXCEEDED - The maximum size of an object has been exceeded.
.
Language=Russian
ERROR_DS_MAX_OBJ_SIZE_EXCEEDED - The maximum size of an object has been exceeded.
.
Language=Polish
ERROR_DS_MAX_OBJ_SIZE_EXCEEDED - Został przekroczony maksymalny rozmiar obiektu.
.
Language=Romanian
ERROR_DS_MAX_OBJ_SIZE_EXCEEDED - The maximum size of an object has been exceeded.
.

MessageId=8305
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_STRING_NAME_EXISTS
Language=English
ERROR_DS_OBJ_STRING_NAME_EXISTS - An attempt was made to add an object to the directory with a name that is already in use.
.
Language=Russian
ERROR_DS_OBJ_STRING_NAME_EXISTS - An attempt was made to add an object to the directory with a name that is already in use.
.
Language=Polish
ERROR_DS_OBJ_STRING_NAME_EXISTS - Została podjęta próba dodania do katalogu obiektu o już istniejącej nazwie.
.
Language=Romanian
ERROR_DS_OBJ_STRING_NAME_EXISTS - An attempt was made to add an object to the directory with a name that is already in use.
.

MessageId=8306
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA
Language=English
ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA - An attempt was made to add an object of a class that does not have an RDN defined in the schema.
.
Language=Russian
ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA - An attempt was made to add an object of a class that does not have an RDN defined in the schema.
.
Language=Polish
ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA - Została podjęta próba dodania obiektu klasy, która w schemacie nie ma zdefiniowanej nazwy RDN.
.
Language=Romanian
ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA - An attempt was made to add an object of a class that does not have an RDN defined in the schema.
.

MessageId=8307
Severity=Success
Facility=System
SymbolicName=ERROR_DS_RDN_DOESNT_MATCH_SCHEMA
Language=English
ERROR_DS_RDN_DOESNT_MATCH_SCHEMA - An attempt was made to add an object using an RDN that is not the RDN defined in the schema.
.
Language=Russian
ERROR_DS_RDN_DOESNT_MATCH_SCHEMA - An attempt was made to add an object using an RDN that is not the RDN defined in the schema.
.
Language=Polish
ERROR_DS_RDN_DOESNT_MATCH_SCHEMA - Została podjęta próba dodania obiektu za pomocą nazwy RDN, która nie jest nazwą RDN zdefiniowaną w schemacie.
.
Language=Romanian
ERROR_DS_RDN_DOESNT_MATCH_SCHEMA - An attempt was made to add an object using an RDN that is not the RDN defined in the schema.
.

MessageId=8308
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_REQUESTED_ATTS_FOUND
Language=English
ERROR_DS_NO_REQUESTED_ATTS_FOUND - None of the requested attributes were found on the objects.
.
Language=Russian
ERROR_DS_NO_REQUESTED_ATTS_FOUND - None of the requested attributes were found on the objects.
.
Language=Polish
ERROR_DS_NO_REQUESTED_ATTS_FOUND - Nie znaleziono w obiektach żadnych z wymaganych atrybutów.
.
Language=Romanian
ERROR_DS_NO_REQUESTED_ATTS_FOUND - None of the requested attributes were found on the objects.
.

MessageId=8309
Severity=Success
Facility=System
SymbolicName=ERROR_DS_USER_BUFFER_TO_SMALL
Language=English
ERROR_DS_USER_BUFFER_TO_SMALL - The user buffer is too small.
.
Language=Russian
ERROR_DS_USER_BUFFER_TO_SMALL - The user buffer is too small.
.
Language=Polish
ERROR_DS_USER_BUFFER_TO_SMALL - Bufor użytkownika jest za mały.
.
Language=Romanian
ERROR_DS_USER_BUFFER_TO_SMALL - The user buffer is too small.
.

MessageId=8310
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_IS_NOT_ON_OBJ
Language=English
ERROR_DS_ATT_IS_NOT_ON_OBJ - The attribute specified in the operation is not present on the object.
.
Language=Russian
ERROR_DS_ATT_IS_NOT_ON_OBJ - The attribute specified in the operation is not present on the object.
.
Language=Polish
ERROR_DS_ATT_IS_NOT_ON_OBJ - Atrybut podany w operacji nie występuje w obiekcie.
.
Language=Romanian
ERROR_DS_ATT_IS_NOT_ON_OBJ - The attribute specified in the operation is not present on the object.
.

MessageId=8311
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ILLEGAL_MOD_OPERATION
Language=English
ERROR_DS_ILLEGAL_MOD_OPERATION - Illegal modify operation. Some aspect of the modification is not permitted.
.
Language=Russian
ERROR_DS_ILLEGAL_MOD_OPERATION - Illegal modify operation. Some aspect of the modification is not permitted.
.
Language=Polish
ERROR_DS_ILLEGAL_MOD_OPERATION - Niedozwolona operacja modyfikowania. Niektóre aspekty modyfikacji nie są dozwolone.
.
Language=Romanian
ERROR_DS_ILLEGAL_MOD_OPERATION - Illegal modify operation. Some aspect of the modification is not permitted.
.

MessageId=8312
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_TOO_LARGE
Language=English
ERROR_DS_OBJ_TOO_LARGE - The specified object is too large.
.
Language=Russian
ERROR_DS_OBJ_TOO_LARGE - The specified object is too large.
.
Language=Polish
ERROR_DS_OBJ_TOO_LARGE - Podany obiekt jest zbyt duży.
.
Language=Romanian
ERROR_DS_OBJ_TOO_LARGE - The specified object is too large.
.

MessageId=8313
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BAD_INSTANCE_TYPE
Language=English
ERROR_DS_BAD_INSTANCE_TYPE - The specified instance type is not valid.
.
Language=Russian
ERROR_DS_BAD_INSTANCE_TYPE - The specified instance type is not valid.
.
Language=Polish
ERROR_DS_BAD_INSTANCE_TYPE - Podany typ wystąpienia jest nieprawidłowy.
.
Language=Romanian
ERROR_DS_BAD_INSTANCE_TYPE - The specified instance type is not valid.
.

MessageId=8314
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MASTERDSA_REQUIRED
Language=English
ERROR_DS_MASTERDSA_REQUIRED - The operation must be performed at a master DSA.
.
Language=Russian
ERROR_DS_MASTERDSA_REQUIRED - The operation must be performed at a master DSA.
.
Language=Polish
ERROR_DS_MASTERDSA_REQUIRED - Operacja musi być dokonana na głównym serwerze DSA.
.
Language=Romanian
ERROR_DS_MASTERDSA_REQUIRED - The operation must be performed at a master DSA.
.

MessageId=8315
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJECT_CLASS_REQUIRED
Language=English
ERROR_DS_OBJECT_CLASS_REQUIRED - The object class attribute must be specified.
.
Language=Russian
ERROR_DS_OBJECT_CLASS_REQUIRED - The object class attribute must be specified.
.
Language=Polish
ERROR_DS_OBJECT_CLASS_REQUIRED - Musi być podany atrybut klasy obiektu.
.
Language=Romanian
ERROR_DS_OBJECT_CLASS_REQUIRED - The object class attribute must be specified.
.

MessageId=8316
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MISSING_REQUIRED_ATT
Language=English
ERROR_DS_MISSING_REQUIRED_ATT - A required attribute is missing.
.
Language=Russian
ERROR_DS_MISSING_REQUIRED_ATT - A required attribute is missing.
.
Language=Polish
ERROR_DS_MISSING_REQUIRED_ATT - Brak wymaganego atrybutu.
.
Language=Romanian
ERROR_DS_MISSING_REQUIRED_ATT - A required attribute is missing.
.

MessageId=8317
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_NOT_DEF_FOR_CLASS
Language=English
ERROR_DS_ATT_NOT_DEF_FOR_CLASS - An attempt was made to modify an object to include an attribute that is not legal for its class
.
Language=Russian
ERROR_DS_ATT_NOT_DEF_FOR_CLASS - An attempt was made to modify an object to include an attribute that is not legal for its class
.
Language=Polish
ERROR_DS_ATT_NOT_DEF_FOR_CLASS - Nastąpiła próba modyfikacji obiektu w celu dołączenia atrybutu, który nie jest dozwolony dla klasy obiektu.
.
Language=Romanian
ERROR_DS_ATT_NOT_DEF_FOR_CLASS - An attempt was made to modify an object to include an attribute that is not legal for its class
.

MessageId=8318
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_ALREADY_EXISTS
Language=English
ERROR_DS_ATT_ALREADY_EXISTS - The specified attribute is already present on the object.
.
Language=Russian
ERROR_DS_ATT_ALREADY_EXISTS - The specified attribute is already present on the object.
.
Language=Polish
ERROR_DS_ATT_ALREADY_EXISTS - Podany atrybut już występuje w obiekcie.
.
Language=Romanian
ERROR_DS_ATT_ALREADY_EXISTS - The specified attribute is already present on the object.
.

MessageId=8320
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ADD_ATT_VALUES
Language=English
ERROR_DS_CANT_ADD_ATT_VALUES - The specified attribute is not present, or has no values.
.
Language=Russian
ERROR_DS_CANT_ADD_ATT_VALUES - The specified attribute is not present, or has no values.
.
Language=Polish
ERROR_DS_CANT_ADD_ATT_VALUES - Podany atrybut jest nieobecny lub nie ma nadanej wartości.
.
Language=Romanian
ERROR_DS_CANT_ADD_ATT_VALUES - The specified attribute is not present, or has no values.
.

MessageId=8321
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SINGLE_VALUE_CONSTRAINT
Language=English
ERROR_DS_SINGLE_VALUE_CONSTRAINT - Multiple values were specified for an attribute that can have only one value.
.
Language=Russian
ERROR_DS_SINGLE_VALUE_CONSTRAINT - Multiple values were specified for an attribute that can have only one value.
.
Language=Polish
ERROR_DS_SINGLE_VALUE_CONSTRAINT - Dla atrybutu, który może mieć tylko jedną wartość, zostały podane wielokrotne wartości.
.
Language=Romanian
ERROR_DS_SINGLE_VALUE_CONSTRAINT - Multiple values were specified for an attribute that can have only one value.
.

MessageId=8322
Severity=Success
Facility=System
SymbolicName=ERROR_DS_RANGE_CONSTRAINT
Language=English
ERROR_DS_RANGE_CONSTRAINT - A value for the attribute was not in the acceptable range of values.
.
Language=Russian
ERROR_DS_RANGE_CONSTRAINT - A value for the attribute was not in the acceptable range of values.
.
Language=Polish
ERROR_DS_RANGE_CONSTRAINT - Wartość atrybutu nie mieści się w przedziale dozwolonych wartości.
.
Language=Romanian
ERROR_DS_RANGE_CONSTRAINT - A value for the attribute was not in the acceptable range of values.
.

MessageId=8323
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_VAL_ALREADY_EXISTS
Language=English
ERROR_DS_ATT_VAL_ALREADY_EXISTS - The specified value already exists.
.
Language=Russian
ERROR_DS_ATT_VAL_ALREADY_EXISTS - The specified value already exists.
.
Language=Polish
ERROR_DS_ATT_VAL_ALREADY_EXISTS - Podana wartość już istnieje.
.
Language=Romanian
ERROR_DS_ATT_VAL_ALREADY_EXISTS - The specified value already exists.
.

MessageId=8324
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_REM_MISSING_ATT
Language=English
ERROR_DS_CANT_REM_MISSING_ATT - The attribute cannot be removed because it is not present on the object.
.
Language=Russian
ERROR_DS_CANT_REM_MISSING_ATT - The attribute cannot be removed because it is not present on the object.
.
Language=Polish
ERROR_DS_CANT_REM_MISSING_ATT - Nie można usunąć atrybutu, ponieważ nie występuje on w obiekcie.
.
Language=Romanian
ERROR_DS_CANT_REM_MISSING_ATT - The attribute cannot be removed because it is not present on the object.
.

MessageId=8325
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_REM_MISSING_ATT_VAL
Language=English
ERROR_DS_CANT_REM_MISSING_ATT_VAL - The attribute value cannot be removed because it is not present on the object.
.
Language=Russian
ERROR_DS_CANT_REM_MISSING_ATT_VAL - The attribute value cannot be removed because it is not present on the object.
.
Language=Polish
ERROR_DS_CANT_REM_MISSING_ATT_VAL - Nie można usunąć wartości atrybutu, ponieważ nie występuje ona w obiekcie.
.
Language=Romanian
ERROR_DS_CANT_REM_MISSING_ATT_VAL - The attribute value cannot be removed because it is not present on the object.
.

MessageId=8326
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ROOT_CANT_BE_SUBREF
Language=English
ERROR_DS_ROOT_CANT_BE_SUBREF - The specified root object cannot be a subref.
.
Language=Russian
ERROR_DS_ROOT_CANT_BE_SUBREF - The specified root object cannot be a subref.
.
Language=Polish
ERROR_DS_ROOT_CANT_BE_SUBREF - Podany obiekt główny nie może być odniesieniem podrzędnym.
.
Language=Romanian
ERROR_DS_ROOT_CANT_BE_SUBREF - The specified root object cannot be a subref.
.

MessageId=8327
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_CHAINING
Language=English
ERROR_DS_NO_CHAINING - Chaining is not permitted.
.
Language=Russian
ERROR_DS_NO_CHAINING - Chaining is not permitted.
.
Language=Polish
ERROR_DS_NO_CHAINING - Tworzenie łańcucha nie jest dozwolone.
.
Language=Romanian
ERROR_DS_NO_CHAINING - Chaining is not permitted.
.

MessageId=8328
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_CHAINED_EVAL
Language=English
ERROR_DS_NO_CHAINED_EVAL - Chained evaluation is not permitted.
.
Language=Russian
ERROR_DS_NO_CHAINED_EVAL - Chained evaluation is not permitted.
.
Language=Polish
ERROR_DS_NO_CHAINED_EVAL - Ocena łańcuchowa nie jest dozwolona.
.
Language=Romanian
ERROR_DS_NO_CHAINED_EVAL - Chained evaluation is not permitted.
.

MessageId=8329
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_PARENT_OBJECT
Language=English
ERROR_DS_NO_PARENT_OBJECT - The operation could not be performed because the object's parent is either uninstantiated or deleted.
.
Language=Russian
ERROR_DS_NO_PARENT_OBJECT - The operation could not be performed because the object's parent is either uninstantiated or deleted.
.
Language=Polish
ERROR_DS_NO_PARENT_OBJECT - Operacja nie może być wykonana, ponieważ usunięto albo wystąpienie rodzica obiektu, albo samego rodzica.
.
Language=Romanian
ERROR_DS_NO_PARENT_OBJECT - The operation could not be performed because the object's parent is either uninstantiated or deleted.
.

MessageId=8330
Severity=Success
Facility=System
SymbolicName=ERROR_DS_PARENT_IS_AN_ALIAS
Language=English
ERROR_DS_PARENT_IS_AN_ALIAS - Having a parent that is an alias is not permitted. Aliases are leaf objects.
.
Language=Russian
ERROR_DS_PARENT_IS_AN_ALIAS - Having a parent that is an alias is not permitted. Aliases are leaf objects.
.
Language=Polish
ERROR_DS_PARENT_IS_AN_ALIAS - Posiadanie rodzica, który jest aliasem jest niedozwolone. Aliasy są obiektami typu liść.
.
Language=Romanian
ERROR_DS_PARENT_IS_AN_ALIAS - Having a parent that is an alias is not permitted. Aliases are leaf objects.
.

MessageId=8331
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MIX_MASTER_AND_REPS
Language=English
ERROR_DS_CANT_MIX_MASTER_AND_REPS - The object and parent must be of the same type, either both masters or both replicas.
.
Language=Russian
ERROR_DS_CANT_MIX_MASTER_AND_REPS - The object and parent must be of the same type, either both masters or both replicas.
.
Language=Polish
ERROR_DS_CANT_MIX_MASTER_AND_REPS - Obiekt i rodzic muszą być tego samego typu - muszą być albo obiektami głównymi, albo replikami.
.
Language=Romanian
ERROR_DS_CANT_MIX_MASTER_AND_REPS - The object and parent must be of the same type, either both masters or both replicas.
.

MessageId=8332
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CHILDREN_EXIST
Language=English
ERROR_DS_CHILDREN_EXIST - The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object.
.
Language=Russian
ERROR_DS_CHILDREN_EXIST - The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object.
.
Language=Polish
ERROR_DS_CHILDREN_EXIST - Operacja nie może być wykonana, ponieważ istnieje obiekt podrzędny. Ta operacja może jedynie być wykonana na obiekcie typu liść.
.
Language=Romanian
ERROR_DS_CHILDREN_EXIST - The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object.
.

MessageId=8333
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_NOT_FOUND
Language=English
ERROR_DS_OBJ_NOT_FOUND - Directory object not found.
.
Language=Russian
ERROR_DS_OBJ_NOT_FOUND - Directory object not found.
.
Language=Polish
ERROR_DS_OBJ_NOT_FOUND - Nie znaleziono obiektu katalogu.
.
Language=Romanian
ERROR_DS_OBJ_NOT_FOUND - Directory object not found.
.

MessageId=8334
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ALIASED_OBJ_MISSING
Language=English
ERROR_DS_ALIASED_OBJ_MISSING - The aliased object is missing.
.
Language=Russian
ERROR_DS_ALIASED_OBJ_MISSING - The aliased object is missing.
.
Language=Polish
ERROR_DS_ALIASED_OBJ_MISSING - Brakuje obiektu, dla którego utworzono alias.
.
Language=Romanian
ERROR_DS_ALIASED_OBJ_MISSING - The aliased object is missing.
.

MessageId=8335
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BAD_NAME_SYNTAX
Language=English
ERROR_DS_BAD_NAME_SYNTAX - The object name has bad syntax.
.
Language=Russian
ERROR_DS_BAD_NAME_SYNTAX - The object name has bad syntax.
.
Language=Polish
ERROR_DS_BAD_NAME_SYNTAX - Nazwa obiektu ma złą składnię.
.
Language=Romanian
ERROR_DS_BAD_NAME_SYNTAX - The object name has bad syntax.
.

MessageId=8336
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ALIAS_POINTS_TO_ALIAS
Language=English
ERROR_DS_ALIAS_POINTS_TO_ALIAS - It is not permitted for an alias to refer to another alias.
.
Language=Russian
ERROR_DS_ALIAS_POINTS_TO_ALIAS - It is not permitted for an alias to refer to another alias.
.
Language=Polish
ERROR_DS_ALIAS_POINTS_TO_ALIAS - Odwoływanie się aliasu do innego aliasu jest niedozwolone.
.
Language=Romanian
ERROR_DS_ALIAS_POINTS_TO_ALIAS - It is not permitted for an alias to refer to another alias.
.

MessageId=8337
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DEREF_ALIAS
Language=English
ERROR_DS_CANT_DEREF_ALIAS - The alias cannot be dereferenced.
.
Language=Russian
ERROR_DS_CANT_DEREF_ALIAS - The alias cannot be dereferenced.
.
Language=Polish
ERROR_DS_CANT_DEREF_ALIAS - Nie można usunąć odwołania do aliasu.
.
Language=Romanian
ERROR_DS_CANT_DEREF_ALIAS - The alias cannot be dereferenced.
.

MessageId=8338
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OUT_OF_SCOPE
Language=English
ERROR_DS_OUT_OF_SCOPE - The operation is out of scope.
.
Language=Russian
ERROR_DS_OUT_OF_SCOPE - The operation is out of scope.
.
Language=Polish
ERROR_DS_OUT_OF_SCOPE - Operacja wykracza poza zakres.
.
Language=Romanian
ERROR_DS_OUT_OF_SCOPE - The operation is out of scope.
.

MessageId=8339
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJECT_BEING_REMOVED
Language=English
ERROR_DS_OBJECT_BEING_REMOVED - The operation cannot continue because the object is in the process of being removed.
.
Language=Russian
ERROR_DS_OBJECT_BEING_REMOVED - The operation cannot continue because the object is in the process of being removed.
.
Language=Polish
ERROR_DS_OBJECT_BEING_REMOVED - Nie można kontynuować operacji, ponieważ trwa proces usuwania danego obiektu.
.
Language=Romanian
ERROR_DS_OBJECT_BEING_REMOVED - The operation cannot continue because the object is in the process of being removed.
.

MessageId=8340
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DELETE_DSA_OBJ
Language=English
ERROR_DS_CANT_DELETE_DSA_OBJ - The DSA object cannot be deleted.
.
Language=Russian
ERROR_DS_CANT_DELETE_DSA_OBJ - The DSA object cannot be deleted.
.
Language=Polish
ERROR_DS_CANT_DELETE_DSA_OBJ - Nie można usunąć obiektu DSA.
.
Language=Romanian
ERROR_DS_CANT_DELETE_DSA_OBJ - The DSA object cannot be deleted.
.

MessageId=8341
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GENERIC_ERROR
Language=English
ERROR_DS_GENERIC_ERROR - A directory service error has occurred.
.
Language=Russian
ERROR_DS_GENERIC_ERROR - A directory service error has occurred.
.
Language=Polish
ERROR_DS_GENERIC_ERROR - Wystąpił błąd usługi katalogowej.
.
Language=Romanian
ERROR_DS_GENERIC_ERROR - A directory service error has occurred.
.

MessageId=8342
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DSA_MUST_BE_INT_MASTER
Language=English
ERROR_DS_DSA_MUST_BE_INT_MASTER - The operation can only be performed on an internal master DSA object.
.
Language=Russian
ERROR_DS_DSA_MUST_BE_INT_MASTER - The operation can only be performed on an internal master DSA object.
.
Language=Polish
ERROR_DS_DSA_MUST_BE_INT_MASTER - Operacja może być dokonana jedynie na wewnętrznym głównym obiekcie DSA.
.
Language=Romanian
ERROR_DS_DSA_MUST_BE_INT_MASTER - The operation can only be performed on an internal master DSA object.
.

MessageId=8343
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CLASS_NOT_DSA
Language=English
ERROR_DS_CLASS_NOT_DSA - The object must be of class DSA.
.
Language=Russian
ERROR_DS_CLASS_NOT_DSA - The object must be of class DSA.
.
Language=Polish
ERROR_DS_CLASS_NOT_DSA - Obiekt musi być klasy DSA.
.
Language=Romanian
ERROR_DS_CLASS_NOT_DSA - The object must be of class DSA.
.

MessageId=8344
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INSUFF_ACCESS_RIGHTS
Language=English
ERROR_DS_INSUFF_ACCESS_RIGHTS - Insufficient access rights to perform the operation.
.
Language=Russian
ERROR_DS_INSUFF_ACCESS_RIGHTS - Insufficient access rights to perform the operation.
.
Language=Polish
ERROR_DS_INSUFF_ACCESS_RIGHTS - Niewystarczające prawa dostępu, aby wykonać tę operację.
.
Language=Romanian
ERROR_DS_INSUFF_ACCESS_RIGHTS - Insufficient access rights to perform the operation.
.

MessageId=8345
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ILLEGAL_SUPERIOR
Language=English
ERROR_DS_ILLEGAL_SUPERIOR - The object cannot be added because the parent is not on the list of possible superiors.
.
Language=Russian
ERROR_DS_ILLEGAL_SUPERIOR - The object cannot be added because the parent is not on the list of possible superiors.
.
Language=Polish
ERROR_DS_ILLEGAL_SUPERIOR - Nie można dodać obiektu, ponieważ rodzic nie występuje na liście możliwych obiektów nadrzędnych.
.
Language=Romanian
ERROR_DS_ILLEGAL_SUPERIOR - The object cannot be added because the parent is not on the list of possible superiors.
.

MessageId=8346
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATTRIBUTE_OWNED_BY_SAM
Language=English
ERROR_DS_ATTRIBUTE_OWNED_BY_SAM - Access to the attribute is not permitted because the attribute is owned by the Security Accounts Manager (SAM).
.
Language=Russian
ERROR_DS_ATTRIBUTE_OWNED_BY_SAM - Access to the attribute is not permitted because the attribute is owned by the Security Accounts Manager (SAM).
.
Language=Polish
ERROR_DS_ATTRIBUTE_OWNED_BY_SAM - Dostęp do atrybutu nie jest dozwolony, ponieważ atrybut jest posiadany przez Menedżera kont zabezpieczeń (SAM).
.
Language=Romanian
ERROR_DS_ATTRIBUTE_OWNED_BY_SAM - Access to the attribute is not permitted because the attribute is owned by the Security Accounts Manager (SAM).
.

MessageId=8347
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_TOO_MANY_PARTS
Language=English
ERROR_DS_NAME_TOO_MANY_PARTS - The name has too many parts.
.
Language=Russian
ERROR_DS_NAME_TOO_MANY_PARTS - The name has too many parts.
.
Language=Polish
ERROR_DS_NAME_TOO_MANY_PARTS - Nazwa składa się ze zbyt wielu części.
.
Language=Romanian
ERROR_DS_NAME_TOO_MANY_PARTS - The name has too many parts.
.

MessageId=8348
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_TOO_LONG
Language=English
ERROR_DS_NAME_TOO_LONG - The name is too long.
.
Language=Russian
ERROR_DS_NAME_TOO_LONG - The name is too long.
.
Language=Polish
ERROR_DS_NAME_TOO_LONG - Nazwa jest zbyt długa.
.
Language=Romanian
ERROR_DS_NAME_TOO_LONG - The name is too long.
.

MessageId=8349
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_VALUE_TOO_LONG
Language=English
ERROR_DS_NAME_VALUE_TOO_LONG - The name value is too long.
.
Language=Russian
ERROR_DS_NAME_VALUE_TOO_LONG - The name value is too long.
.
Language=Polish
ERROR_DS_NAME_VALUE_TOO_LONG - Wartość nazwy jest zbyt długa.
.
Language=Romanian
ERROR_DS_NAME_VALUE_TOO_LONG - The name value is too long.
.

MessageId=8350
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_UNPARSEABLE
Language=English
ERROR_DS_NAME_UNPARSEABLE - The directory service encountered an error parsing a name.
.
Language=Russian
ERROR_DS_NAME_UNPARSEABLE - The directory service encountered an error parsing a name.
.
Language=Polish
ERROR_DS_NAME_UNPARSEABLE - Usługa katalogowa napotkała błąd podczas analizy nazwy.
.
Language=Romanian
ERROR_DS_NAME_UNPARSEABLE - The directory service encountered an error parsing a name.
.

MessageId=8351
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_TYPE_UNKNOWN
Language=English
ERROR_DS_NAME_TYPE_UNKNOWN - The directory service cannot get the attribute type for a name.
.
Language=Russian
ERROR_DS_NAME_TYPE_UNKNOWN - The directory service cannot get the attribute type for a name.
.
Language=Polish
ERROR_DS_NAME_TYPE_UNKNOWN - Usługa katalogowa nie może uzyskać typu atrybutu dla nazwy.
.
Language=Romanian
ERROR_DS_NAME_TYPE_UNKNOWN - The directory service cannot get the attribute type for a name.
.

MessageId=8352
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_AN_OBJECT
Language=English
ERROR_DS_NOT_AN_OBJECT - The name does not identify an object; the name identifies a phantom.
.
Language=Russian
ERROR_DS_NOT_AN_OBJECT - The name does not identify an object; the name identifies a phantom.
.
Language=Polish
ERROR_DS_NOT_AN_OBJECT - Nazwa nie określa obiektu; nazwa określa fantom.
.
Language=Romanian
ERROR_DS_NOT_AN_OBJECT - The name does not identify an object; the name identifies a phantom.
.

MessageId=8353
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SEC_DESC_TOO_SHORT
Language=English
ERROR_DS_SEC_DESC_TOO_SHORT - The security descriptor is too short.
.
Language=Russian
ERROR_DS_SEC_DESC_TOO_SHORT - The security descriptor is too short.
.
Language=Polish
ERROR_DS_SEC_DESC_TOO_SHORT - Deskryptor zabezpieczenia jest za krótki.
.
Language=Romanian
ERROR_DS_SEC_DESC_TOO_SHORT - The security descriptor is too short.
.

MessageId=8354
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SEC_DESC_INVALID
Language=English
ERROR_DS_SEC_DESC_INVALID - The security descriptor is invalid.
.
Language=Russian
ERROR_DS_SEC_DESC_INVALID - The security descriptor is invalid.
.
Language=Polish
ERROR_DS_SEC_DESC_INVALID - Deskryptor zabezpieczenia jest nieprawidłowy.
.
Language=Romanian
ERROR_DS_SEC_DESC_INVALID - The security descriptor is invalid.
.

MessageId=8355
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_DELETED_NAME
Language=English
ERROR_DS_NO_DELETED_NAME - Failed to create name for deleted object.
.
Language=Russian
ERROR_DS_NO_DELETED_NAME - Failed to create name for deleted object.
.
Language=Polish
ERROR_DS_NO_DELETED_NAME - Nie można utworzyć nazwy dla usuniętego obiektu.
.
Language=Romanian
ERROR_DS_NO_DELETED_NAME - Failed to create name for deleted object.
.

MessageId=8356
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SUBREF_MUST_HAVE_PARENT
Language=English
ERROR_DS_SUBREF_MUST_HAVE_PARENT - The parent of a new subref must exist.
.
Language=Russian
ERROR_DS_SUBREF_MUST_HAVE_PARENT - The parent of a new subref must exist.
.
Language=Polish
ERROR_DS_SUBREF_MUST_HAVE_PARENT - Musi istnieć rodzic nowego odwołania podrzędnego.
.
Language=Romanian
ERROR_DS_SUBREF_MUST_HAVE_PARENT - The parent of a new subref must exist.
.

MessageId=8357
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NCNAME_MUST_BE_NC
Language=English
ERROR_DS_NCNAME_MUST_BE_NC - The object must be a naming context.
.
Language=Russian
ERROR_DS_NCNAME_MUST_BE_NC - The object must be a naming context.
.
Language=Polish
ERROR_DS_NCNAME_MUST_BE_NC - Obiekt musi być kontekstem nazewnictwa.
.
Language=Romanian
ERROR_DS_NCNAME_MUST_BE_NC - The object must be a naming context.
.

MessageId=8358
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ADD_SYSTEM_ONLY
Language=English
ERROR_DS_CANT_ADD_SYSTEM_ONLY - It is not permitted to add an attribute which is owned by the system.
.
Language=Russian
ERROR_DS_CANT_ADD_SYSTEM_ONLY - It is not permitted to add an attribute which is owned by the system.
.
Language=Polish
ERROR_DS_CANT_ADD_SYSTEM_ONLY - Nie jest dozwolone dodawanie atrybutu, który jest w posiadaniu systemu.
.
Language=Romanian
ERROR_DS_CANT_ADD_SYSTEM_ONLY - It is not permitted to add an attribute which is owned by the system.
.

MessageId=8359
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CLASS_MUST_BE_CONCRETE
Language=English
ERROR_DS_CLASS_MUST_BE_CONCRETE - The class of the object must be structural; you cannot instantiate an abstract class.
.
Language=Russian
ERROR_DS_CLASS_MUST_BE_CONCRETE - The class of the object must be structural; you cannot instantiate an abstract class.
.
Language=Polish
ERROR_DS_CLASS_MUST_BE_CONCRETE - Klasa obiektu musi być strukturalna; nie możesz utworzyć wystąpienia klasy abstrakcyjnej.
.
Language=Romanian
ERROR_DS_CLASS_MUST_BE_CONCRETE - The class of the object must be structural; you cannot instantiate an abstract class.
.

MessageId=8360
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_DMD
Language=English
ERROR_DS_INVALID_DMD - The schema object could not be found.
.
Language=Russian
ERROR_DS_INVALID_DMD - The schema object could not be found.
.
Language=Polish
ERROR_DS_INVALID_DMD - Nie znaleziono obiekt schematu.
.
Language=Romanian
ERROR_DS_INVALID_DMD - The schema object could not be found.
.

MessageId=8361
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_GUID_EXISTS
Language=English
ERROR_DS_OBJ_GUID_EXISTS - A local object with this GUID (dead or alive) already exists.
.
Language=Russian
ERROR_DS_OBJ_GUID_EXISTS - A local object with this GUID (dead or alive) already exists.
.
Language=Polish
ERROR_DS_OBJ_GUID_EXISTS - Już istnieje obiekt lokalny o tym identyfikatorze GUID (aktywny lub nieaktywny).
.
Language=Romanian
ERROR_DS_OBJ_GUID_EXISTS - A local object with this GUID (dead or alive) already exists.
.

MessageId=8362
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_ON_BACKLINK
Language=English
ERROR_DS_NOT_ON_BACKLINK - The operation cannot be performed on a back link.
.
Language=Russian
ERROR_DS_NOT_ON_BACKLINK - The operation cannot be performed on a back link.
.
Language=Polish
ERROR_DS_NOT_ON_BACKLINK - Operacja nie może być wykonana na odsyłaczu wstecznym.
.
Language=Romanian
ERROR_DS_NOT_ON_BACKLINK - The operation cannot be performed on a back link.
.

MessageId=8363
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_CROSSREF_FOR_NC
Language=English
ERROR_DS_NO_CROSSREF_FOR_NC - The cross reference for the specified naming context could not be found.
.
Language=Russian
ERROR_DS_NO_CROSSREF_FOR_NC - The cross reference for the specified naming context could not be found.
.
Language=Polish
ERROR_DS_NO_CROSSREF_FOR_NC - Nie znaleziono odwołania do podanego kontekstu nazewnictwa.
.
Language=Romanian
ERROR_DS_NO_CROSSREF_FOR_NC - The cross reference for the specified naming context could not be found.
.

MessageId=8364
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SHUTTING_DOWN
Language=English
ERROR_DS_SHUTTING_DOWN - The operation could not be performed because the directory service is shutting down.
.
Language=Russian
ERROR_DS_SHUTTING_DOWN - The operation could not be performed because the directory service is shutting down.
.
Language=Polish
ERROR_DS_SHUTTING_DOWN - Operacja nie może być wykonana ponieważ usługa katalogowa jest zamykana.
.
Language=Romanian
ERROR_DS_SHUTTING_DOWN - The operation could not be performed because the directory service is shutting down.
.

MessageId=8365
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNKNOWN_OPERATION
Language=English
ERROR_DS_UNKNOWN_OPERATION - The directory service request is invalid.
.
Language=Russian
ERROR_DS_UNKNOWN_OPERATION - The directory service request is invalid.
.
Language=Polish
ERROR_DS_UNKNOWN_OPERATION - Żądanie usługi katalogowej jest nieprawidłowe.
.
Language=Romanian
ERROR_DS_UNKNOWN_OPERATION - The directory service request is invalid.
.

MessageId=8366
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_ROLE_OWNER
Language=English
ERROR_DS_INVALID_ROLE_OWNER - The role owner attribute could not be read.
.
Language=Russian
ERROR_DS_INVALID_ROLE_OWNER - The role owner attribute could not be read.
.
Language=Polish
ERROR_DS_INVALID_ROLE_OWNER - Nie można odczytać atrybutu właściciela roli.
.
Language=Romanian
ERROR_DS_INVALID_ROLE_OWNER - The role owner attribute could not be read.
.

MessageId=8367
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COULDNT_CONTACT_FSMO
Language=English
ERROR_DS_COULDNT_CONTACT_FSMO - The requested FSMO operation failed. The current FSMO holder could not be reached.
.
Language=Russian
ERROR_DS_COULDNT_CONTACT_FSMO - The requested FSMO operation failed. The current FSMO holder could not be reached.
.
Language=Polish
ERROR_DS_COULDNT_CONTACT_FSMO - Żądana operacja FSMO nie powiodła się. Nie można połączyć się z bieżącym posiadaczem FSMO.
.
Language=Romanian
ERROR_DS_COULDNT_CONTACT_FSMO - The requested FSMO operation failed. The current FSMO holder could not be reached.
.

MessageId=8368
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CROSS_NC_DN_RENAME
Language=English
ERROR_DS_CROSS_NC_DN_RENAME - Modification of a DN across a naming context is not permitted.
.
Language=Russian
ERROR_DS_CROSS_NC_DN_RENAME - Modification of a DN across a naming context is not permitted.
.
Language=Polish
ERROR_DS_CROSS_NC_DN_RENAME - Modyfikowanie nazwy domen poza kontekstem nazewnictwa jest niedozwolone.
.
Language=Romanian
ERROR_DS_CROSS_NC_DN_RENAME - Modification of a DN across a naming context is not permitted.
.

MessageId=8369
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOD_SYSTEM_ONLY
Language=English
ERROR_DS_CANT_MOD_SYSTEM_ONLY - The attribute cannot be modified because it is owned by the system.
.
Language=Russian
ERROR_DS_CANT_MOD_SYSTEM_ONLY - The attribute cannot be modified because it is owned by the system.
.
Language=Polish
ERROR_DS_CANT_MOD_SYSTEM_ONLY - Atrybut nie może być modyfikowany, ponieważ jest w posiadaniu systemu.
.
Language=Romanian
ERROR_DS_CANT_MOD_SYSTEM_ONLY - The attribute cannot be modified because it is owned by the system.
.

MessageId=8370
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REPLICATOR_ONLY
Language=English
ERROR_DS_REPLICATOR_ONLY - Only the replicator can perform this function.
.
Language=Russian
ERROR_DS_REPLICATOR_ONLY - Only the replicator can perform this function.
.
Language=Polish
ERROR_DS_REPLICATOR_ONLY - Tylko replikator może wykonać tę funkcję.
.
Language=Romanian
ERROR_DS_REPLICATOR_ONLY - Only the replicator can perform this function.
.

MessageId=8371
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_CLASS_NOT_DEFINED
Language=English
ERROR_DS_OBJ_CLASS_NOT_DEFINED - The specified class is not defined.
.
Language=Russian
ERROR_DS_OBJ_CLASS_NOT_DEFINED - The specified class is not defined.
.
Language=Polish
ERROR_DS_OBJ_CLASS_NOT_DEFINED - Podana klasa nie jest zdefiniowana.
.
Language=Romanian
ERROR_DS_OBJ_CLASS_NOT_DEFINED - The specified class is not defined.
.

MessageId=8372
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OBJ_CLASS_NOT_SUBCLASS
Language=English
ERROR_DS_OBJ_CLASS_NOT_SUBCLASS - The specified class is not a subclass.
.
Language=Russian
ERROR_DS_OBJ_CLASS_NOT_SUBCLASS - The specified class is not a subclass.
.
Language=Polish
ERROR_DS_OBJ_CLASS_NOT_SUBCLASS - Podana klasa nie jest podklasą.
.
Language=Romanian
ERROR_DS_OBJ_CLASS_NOT_SUBCLASS - The specified class is not a subclass.
.

MessageId=8373
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_REFERENCE_INVALID
Language=English
ERROR_DS_NAME_REFERENCE_INVALID - The name reference is invalid.
.
Language=Russian
ERROR_DS_NAME_REFERENCE_INVALID - The name reference is invalid.
.
Language=Polish
ERROR_DS_NAME_REFERENCE_INVALID - Nazwa odwołania jest nieprawidłowa.
.
Language=Romanian
ERROR_DS_NAME_REFERENCE_INVALID - The name reference is invalid.
.

MessageId=8374
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CROSS_REF_EXISTS
Language=English
ERROR_DS_CROSS_REF_EXISTS - A cross reference already exists.
.
Language=Russian
ERROR_DS_CROSS_REF_EXISTS - A cross reference already exists.
.
Language=Polish
ERROR_DS_CROSS_REF_EXISTS - Odwołanie już istnieje.
.
Language=Romanian
ERROR_DS_CROSS_REF_EXISTS - A cross reference already exists.
.

MessageId=8375
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DEL_MASTER_CROSSREF
Language=English
ERROR_DS_CANT_DEL_MASTER_CROSSREF - It is not permitted to delete a master cross reference.
.
Language=Russian
ERROR_DS_CANT_DEL_MASTER_CROSSREF - It is not permitted to delete a master cross reference.
.
Language=Polish
ERROR_DS_CANT_DEL_MASTER_CROSSREF - Usuwanie głównego odwołania jest niedozwolone.
.
Language=Romanian
ERROR_DS_CANT_DEL_MASTER_CROSSREF - It is not permitted to delete a master cross reference.
.

MessageId=8376
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD
Language=English
ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD - Subtree notifications are only supported on NC heads.
.
Language=Russian
ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD - Subtree notifications are only supported on NC heads.
.
Language=Polish
ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD - Powiadomienia poddrzewa są dostarczane tylko do węzłów NC.
.
Language=Romanian
ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD - Subtree notifications are only supported on NC heads.
.

MessageId=8377
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX
Language=English
ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX - Notification filter is too complex.
.
Language=Russian
ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX - Notification filter is too complex.
.
Language=Polish
ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX - Filtr powiadamiania jest zbyt skomplikowany.
.
Language=Romanian
ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX - Notification filter is too complex.
.

MessageId=8378
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_RDN
Language=English
ERROR_DS_DUP_RDN - Schema update failed: duplicate RDN.
.
Language=Russian
ERROR_DS_DUP_RDN - Schema update failed: duplicate RDN.
.
Language=Polish
ERROR_DS_DUP_RDN - Nie można zaktualizować schematu: zduplikowana nazwa RDN.
.
Language=Romanian
ERROR_DS_DUP_RDN - Schema update failed: duplicate RDN.
.

MessageId=8379
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_OID
Language=English
ERROR_DS_DUP_OID - Schema update failed: duplicate OID
.
Language=Russian
ERROR_DS_DUP_OID - Schema update failed: duplicate OID
.
Language=Polish
ERROR_DS_DUP_OID - Nie można zaktualizować schematu: zduplikowany identyfikator OID.
.
Language=Romanian
ERROR_DS_DUP_OID - Schema update failed: duplicate OID
.

MessageId=8380
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_MAPI_ID
Language=English
ERROR_DS_DUP_MAPI_ID - Schema update failed: duplicate MAPI identifier.
.
Language=Russian
ERROR_DS_DUP_MAPI_ID - Schema update failed: duplicate MAPI identifier.
.
Language=Polish
ERROR_DS_DUP_MAPI_ID - Nie można zaktualizować schematu: zduplikowany identyfikator MAPI.
.
Language=Romanian
ERROR_DS_DUP_MAPI_ID - Schema update failed: duplicate MAPI identifier.
.

MessageId=8381
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_SCHEMA_ID_GUID
Language=English
ERROR_DS_DUP_SCHEMA_ID_GUID - Schema update failed: duplicate schema-id GUID.
.
Language=Russian
ERROR_DS_DUP_SCHEMA_ID_GUID - Schema update failed: duplicate schema-id GUID.
.
Language=Polish
ERROR_DS_DUP_SCHEMA_ID_GUID - Nie można zaktualizować schematu: zduplikowany identyfikator schematu GUID.
.
Language=Romanian
ERROR_DS_DUP_SCHEMA_ID_GUID - Schema update failed: duplicate schema-id GUID.
.

MessageId=8382
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_LDAP_DISPLAY_NAME
Language=English
ERROR_DS_DUP_LDAP_DISPLAY_NAME - Schema update failed: duplicate LDAP display name.
.
Language=Russian
ERROR_DS_DUP_LDAP_DISPLAY_NAME - Schema update failed: duplicate LDAP display name.
.
Language=Polish
ERROR_DS_DUP_LDAP_DISPLAY_NAME - Nie można zaktualizować schematu: zduplikowana wyświetlana nazwa LDAP.
.
Language=Romanian
ERROR_DS_DUP_LDAP_DISPLAY_NAME - Schema update failed: duplicate LDAP display name.
.

MessageId=8383
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SEMANTIC_ATT_TEST
Language=English
ERROR_DS_SEMANTIC_ATT_TEST - Schema update failed: range-lower less than range upper
.
Language=Russian
ERROR_DS_SEMANTIC_ATT_TEST - Schema update failed: range-lower less than range upper
.
Language=Polish
ERROR_DS_SEMANTIC_ATT_TEST - Nie można zaktualizować schematu: zakres niższy mniejszy niż zakres górny.
.
Language=Romanian
ERROR_DS_SEMANTIC_ATT_TEST - Schema update failed: range-lower less than range upper
.

MessageId=8384
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SYNTAX_MISMATCH
Language=English
ERROR_DS_SYNTAX_MISMATCH - Schema update failed: syntax mismatch
.
Language=Russian
ERROR_DS_SYNTAX_MISMATCH - Schema update failed: syntax mismatch
.
Language=Polish
ERROR_DS_SYNTAX_MISMATCH - Nie można zaktualizować schematu: niezgodność składni.
.
Language=Romanian
ERROR_DS_SYNTAX_MISMATCH - Schema update failed: syntax mismatch
.

MessageId=8385
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_MUST_HAVE
Language=English
ERROR_DS_EXISTS_IN_MUST_HAVE - Schema deletion failed: attribute is used in must-contain
.
Language=Russian
ERROR_DS_EXISTS_IN_MUST_HAVE - Schema deletion failed: attribute is used in must-contain
.
Language=Polish
ERROR_DS_EXISTS_IN_MUST_HAVE - Nie można zaktualizować schematu: atrybut jest używany w aspekcie „musi zawierać”.
.
Language=Romanian
ERROR_DS_EXISTS_IN_MUST_HAVE - Schema deletion failed: attribute is used in must-contain
.

MessageId=8386
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_MAY_HAVE
Language=English
ERROR_DS_EXISTS_IN_MAY_HAVE - Schema deletion failed: attribute is used in may-contain
.
Language=Russian
ERROR_DS_EXISTS_IN_MAY_HAVE - Schema deletion failed: attribute is used in may-contain
.
Language=Polish
ERROR_DS_EXISTS_IN_MAY_HAVE - Nie można zaktualizować schematu: atrybut jest używany w aspekcie „może zawierać”.
.
Language=Romanian
ERROR_DS_EXISTS_IN_MAY_HAVE - Schema deletion failed: attribute is used in may-contain
.

MessageId=8387
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NONEXISTENT_MAY_HAVE
Language=English
ERROR_DS_NONEXISTENT_MAY_HAVE - Schema update failed: attribute in may-contain does not exist
.
Language=Russian
ERROR_DS_NONEXISTENT_MAY_HAVE - Schema update failed: attribute in may-contain does not exist
.
Language=Polish
ERROR_DS_NONEXISTENT_MAY_HAVE - Nie można zaktualizować schematu: nie istnieje atrybut w aspekcie „może zawierać”.
.
Language=Romanian
ERROR_DS_NONEXISTENT_MAY_HAVE - Schema update failed: attribute in may-contain does not exist
.

MessageId=8388
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NONEXISTENT_MUST_HAVE
Language=English
ERROR_DS_NONEXISTENT_MUST_HAVE - Schema update failed: attribute in must-contain does not exist
.
Language=Russian
ERROR_DS_NONEXISTENT_MUST_HAVE - Schema update failed: attribute in must-contain does not exist
.
Language=Polish
ERROR_DS_NONEXISTENT_MUST_HAVE - Nie można zaktualizować schematu: nie istnieje atrybut w aspekcie „musi zawierać”.
.
Language=Romanian
ERROR_DS_NONEXISTENT_MUST_HAVE - Schema update failed: attribute in must-contain does not exist
.

MessageId=8389
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AUX_CLS_TEST_FAIL
Language=English
ERROR_DS_AUX_CLS_TEST_FAIL - Schema update failed: class in aux-class list does not exist or is not an auxiliary class
.
Language=Russian
ERROR_DS_AUX_CLS_TEST_FAIL - Schema update failed: class in aux-class list does not exist or is not an auxiliary class
.
Language=Polish
ERROR_DS_AUX_CLS_TEST_FAIL - Nie można zaktualizować schematu: klasa z listy klas pomocniczych nie istnieje lub nie jest klasą pomocniczą.
.
Language=Romanian
ERROR_DS_AUX_CLS_TEST_FAIL - Schema update failed: class in aux-class list does not exist or is not an auxiliary class
.

MessageId=8390
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NONEXISTENT_POSS_SUP
Language=English
ERROR_DS_NONEXISTENT_POSS_SUP - Schema update failed: class in poss-superiors does not exist
.
Language=Russian
ERROR_DS_NONEXISTENT_POSS_SUP - Schema update failed: class in poss-superiors does not exist
.
Language=Polish
ERROR_DS_NONEXISTENT_POSS_SUP - Nie można zaktualizować schematu: klasa z listy klas zwierzchnich nie istnieje.
.
Language=Romanian
ERROR_DS_NONEXISTENT_POSS_SUP - Schema update failed: class in poss-superiors does not exist
.

MessageId=8391
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SUB_CLS_TEST_FAIL
Language=English
ERROR_DS_SUB_CLS_TEST_FAIL - Schema update failed: class in subclassof list does not exist or does not satisfy hierarchy rules
.
Language=Russian
ERROR_DS_SUB_CLS_TEST_FAIL - Schema update failed: class in subclassof list does not exist or does not satisfy hierarchy rules
.
Language=Polish
ERROR_DS_SUB_CLS_TEST_FAIL - Nie można zaktualizować schematu: klasa z listy podklas nie istnieje lub nie spełnia reguł hierarchii.
.
Language=Romanian
ERROR_DS_SUB_CLS_TEST_FAIL - Schema update failed: class in subclassof list does not exist or does not satisfy hierarchy rules
.

MessageId=8392
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BAD_RDN_ATT_ID_SYNTAX
Language=English
ERROR_DS_BAD_RDN_ATT_ID_SYNTAX - Schema update failed: Rdn-Att-Id has wrong syntax
.
Language=Russian
ERROR_DS_BAD_RDN_ATT_ID_SYNTAX - Schema update failed: Rdn-Att-Id has wrong syntax
.
Language=Polish
ERROR_DS_BAD_RDN_ATT_ID_SYNTAX - Nie można zaktualizować schematu: nieprawidłowa składnia Rdn-Att-Id.
.
Language=Romanian
ERROR_DS_BAD_RDN_ATT_ID_SYNTAX - Schema update failed: Rdn-Att-Id has wrong syntax
.

MessageId=8393
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_AUX_CLS
Language=English
ERROR_DS_EXISTS_IN_AUX_CLS - Schema deletion failed: class is used as auxiliary class
.
Language=Russian
ERROR_DS_EXISTS_IN_AUX_CLS - Schema deletion failed: class is used as auxiliary class
.
Language=Polish
ERROR_DS_EXISTS_IN_AUX_CLS - Nie można usunąć schematu: klasa jest używana jako klasa pomocnicza.
.
Language=Romanian
ERROR_DS_EXISTS_IN_AUX_CLS - Schema deletion failed: class is used as auxiliary class
.

MessageId=8394
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_SUB_CLS
Language=English
ERROR_DS_EXISTS_IN_SUB_CLS - Schema deletion failed: class is used as sub class
.
Language=Russian
ERROR_DS_EXISTS_IN_SUB_CLS - Schema deletion failed: class is used as sub class
.
Language=Polish
ERROR_DS_EXISTS_IN_SUB_CLS - Nie można usunąć schematu: klasa jest używana jako podklasa.
.
Language=Romanian
ERROR_DS_EXISTS_IN_SUB_CLS - Schema deletion failed: class is used as sub class
.

MessageId=8395
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_POSS_SUP
Language=English
ERROR_DS_EXISTS_IN_POSS_SUP - Schema deletion failed: class is used as poss superior
.
Language=Russian
ERROR_DS_EXISTS_IN_POSS_SUP - Schema deletion failed: class is used as poss superior
.
Language=Polish
ERROR_DS_EXISTS_IN_POSS_SUP - Nie można usunąć schematu: klasa jest używana jako zwierzchnia.
.
Language=Romanian
ERROR_DS_EXISTS_IN_POSS_SUP - Schema deletion failed: class is used as poss superior
.

MessageId=8396
Severity=Success
Facility=System
SymbolicName=ERROR_DS_RECALCSCHEMA_FAILED
Language=English
ERROR_DS_RECALCSCHEMA_FAILED - Schema update failed in recalculating validation cache.
.
Language=Russian
ERROR_DS_RECALCSCHEMA_FAILED - Schema update failed in recalculating validation cache.
.
Language=Polish
ERROR_DS_RECALCSCHEMA_FAILED - Nie można zaktualizować schematu: błąd w przetwarzaniu pamięci podręcznej procesu sprawdzania poprawności.
.
Language=Romanian
ERROR_DS_RECALCSCHEMA_FAILED - Schema update failed in recalculating validation cache.
.

MessageId=8397
Severity=Success
Facility=System
SymbolicName=ERROR_DS_TREE_DELETE_NOT_FINISHED
Language=English
ERROR_DS_TREE_DELETE_NOT_FINISHED - The tree deletion is not finished.
.
Language=Russian
ERROR_DS_TREE_DELETE_NOT_FINISHED - The tree deletion is not finished.
.
Language=Polish
ERROR_DS_TREE_DELETE_NOT_FINISHED - Usuwanie drzewa nie zostało zakończone.
.
Language=Romanian
ERROR_DS_TREE_DELETE_NOT_FINISHED - The tree deletion is not finished.
.

MessageId=8398
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DELETE
Language=English
ERROR_DS_CANT_DELETE - The requested delete operation could not be performed.
.
Language=Russian
ERROR_DS_CANT_DELETE - The requested delete operation could not be performed.
.
Language=Polish
ERROR_DS_CANT_DELETE - Nie można wykonać żądanej operacji usuwania.
.
Language=Romanian
ERROR_DS_CANT_DELETE - The requested delete operation could not be performed.
.

MessageId=8399
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_SCHEMA_REQ_ID
Language=English
ERROR_DS_ATT_SCHEMA_REQ_ID - Cannot read the governs class identifier for the schema record.
.
Language=Russian
ERROR_DS_ATT_SCHEMA_REQ_ID - Cannot read the governs class identifier for the schema record.
.
Language=Polish
ERROR_DS_ATT_SCHEMA_REQ_ID - Nie można odczytać identyfikatora klasy rządzącej dla rekordu schematu.
.
Language=Romanian
ERROR_DS_ATT_SCHEMA_REQ_ID - Cannot read the governs class identifier for the schema record.
.

MessageId=8400
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BAD_ATT_SCHEMA_SYNTAX
Language=English
ERROR_DS_BAD_ATT_SCHEMA_SYNTAX - The attribute schema has bad syntax.
.
Language=Russian
ERROR_DS_BAD_ATT_SCHEMA_SYNTAX - The attribute schema has bad syntax.
.
Language=Polish
ERROR_DS_BAD_ATT_SCHEMA_SYNTAX - Schemat atrybutu ma złą składnię.
.
Language=Romanian
ERROR_DS_BAD_ATT_SCHEMA_SYNTAX - The attribute schema has bad syntax.
.

MessageId=8401
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_CACHE_ATT
Language=English
ERROR_DS_CANT_CACHE_ATT - The attribute could not be cached.
.
Language=Russian
ERROR_DS_CANT_CACHE_ATT - The attribute could not be cached.
.
Language=Polish
ERROR_DS_CANT_CACHE_ATT - Nie można umieścić atrybutu w pamięci podręcznej.
.
Language=Romanian
ERROR_DS_CANT_CACHE_ATT - The attribute could not be cached.
.

MessageId=8402
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_CACHE_CLASS
Language=English
ERROR_DS_CANT_CACHE_CLASS - The class could not be cached.
.
Language=Russian
ERROR_DS_CANT_CACHE_CLASS - The class could not be cached.
.
Language=Polish
ERROR_DS_CANT_CACHE_CLASS - Nie można umieścić klasy w pamięci podręcznej.
.
Language=Romanian
ERROR_DS_CANT_CACHE_CLASS - The class could not be cached.
.

MessageId=8403
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_REMOVE_ATT_CACHE
Language=English
ERROR_DS_CANT_REMOVE_ATT_CACHE - The attribute could not be removed from the cache.
.
Language=Russian
ERROR_DS_CANT_REMOVE_ATT_CACHE - The attribute could not be removed from the cache.
.
Language=Polish
ERROR_DS_CANT_REMOVE_ATT_CACHE - Nie można usunąć atrybutu z pamięci podręcznej.
.
Language=Romanian
ERROR_DS_CANT_REMOVE_ATT_CACHE - The attribute could not be removed from the cache.
.

MessageId=8404
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_REMOVE_CLASS_CACHE
Language=English
ERROR_DS_CANT_REMOVE_CLASS_CACHE - The class could not be removed from the cache.
.
Language=Russian
ERROR_DS_CANT_REMOVE_CLASS_CACHE - The class could not be removed from the cache.
.
Language=Polish
ERROR_DS_CANT_REMOVE_CLASS_CACHE - Nie można usunąć klasy z pamięci podręcznej.
.
Language=Romanian
ERROR_DS_CANT_REMOVE_CLASS_CACHE - The class could not be removed from the cache.
.

MessageId=8405
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_RETRIEVE_DN
Language=English
ERROR_DS_CANT_RETRIEVE_DN - The distinguished name attribute could not be read.
.
Language=Russian
ERROR_DS_CANT_RETRIEVE_DN - The distinguished name attribute could not be read.
.
Language=Polish
ERROR_DS_CANT_RETRIEVE_DN - Nie można odczytać atrybutu nazwy wyróżniającej.
.
Language=Romanian
ERROR_DS_CANT_RETRIEVE_DN - The distinguished name attribute could not be read.
.

MessageId=8406
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MISSING_SUPREF
Language=English
ERROR_DS_MISSING_SUPREF - No superior reference has been configured for the directory service. The directory service is therefore unable to issue referrals to objects outside this forest.
.
Language=Russian
ERROR_DS_MISSING_SUPREF - No superior reference has been configured for the directory service. The directory service is therefore unable to issue referrals to objects outside this forest.
.
Language=Polish
ERROR_DS_MISSING_SUPREF - Nie skonfigurowano nadrzędnego odwołania usługi katalogowej. Z tego powodu usługa katalogowa nie może przydzielić odwołań obiektom poza tym lasem.
.
Language=Romanian
ERROR_DS_MISSING_SUPREF - No superior reference has been configured for the directory service. The directory service is therefore unable to issue referrals to objects outside this forest.
.

MessageId=8407
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_RETRIEVE_INSTANCE
Language=English
ERROR_DS_CANT_RETRIEVE_INSTANCE - The instance type attribute could not be retrieved.
.
Language=Russian
ERROR_DS_CANT_RETRIEVE_INSTANCE - The instance type attribute could not be retrieved.
.
Language=Polish
ERROR_DS_CANT_RETRIEVE_INSTANCE - Nie można pobrać atrybutu typu wystąpienia.
.
Language=Romanian
ERROR_DS_CANT_RETRIEVE_INSTANCE - The instance type attribute could not be retrieved.
.

MessageId=8408
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CODE_INCONSISTENCY
Language=English
ERROR_DS_CODE_INCONSISTENCY - An internal error has occurred.
.
Language=Russian
ERROR_DS_CODE_INCONSISTENCY - An internal error has occurred.
.
Language=Polish
ERROR_DS_CODE_INCONSISTENCY - Wystąpił błąd wewnętrzny.
.
Language=Romanian
ERROR_DS_CODE_INCONSISTENCY - An internal error has occurred.
.

MessageId=8409
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DATABASE_ERROR
Language=English
ERROR_DS_DATABASE_ERROR - A database error has occurred.
.
Language=Russian
ERROR_DS_DATABASE_ERROR - A database error has occurred.
.
Language=Polish
ERROR_DS_DATABASE_ERROR - Wystąpił błąd bazy danych.
.
Language=Romanian
ERROR_DS_DATABASE_ERROR - A database error has occurred.
.

MessageId=8410
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GOVERNSID_MISSING
Language=English
ERROR_DS_GOVERNSID_MISSING - The attribute GOVERNSID is missing.
.
Language=Russian
ERROR_DS_GOVERNSID_MISSING - The attribute GOVERNSID is missing.
.
Language=Polish
ERROR_DS_GOVERNSID_MISSING - Brakuje atrybutu GOVERNSID.
.
Language=Romanian
ERROR_DS_GOVERNSID_MISSING - The attribute GOVERNSID is missing.
.

MessageId=8411
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MISSING_EXPECTED_ATT
Language=English
ERROR_DS_MISSING_EXPECTED_ATT - An expected attribute is missing.
.
Language=Russian
ERROR_DS_MISSING_EXPECTED_ATT - An expected attribute is missing.
.
Language=Polish
ERROR_DS_MISSING_EXPECTED_ATT - Brakuje oczekiwanego atrybutu.
.
Language=Romanian
ERROR_DS_MISSING_EXPECTED_ATT - An expected attribute is missing.
.

MessageId=8412
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NCNAME_MISSING_CR_REF
Language=English
ERROR_DS_NCNAME_MISSING_CR_REF - The specified naming context is missing a cross reference.
.
Language=Russian
ERROR_DS_NCNAME_MISSING_CR_REF - The specified naming context is missing a cross reference.
.
Language=Polish
ERROR_DS_NCNAME_MISSING_CR_REF - W podanym kontekście nazewnictwa brakuje odwołania.
.
Language=Romanian
ERROR_DS_NCNAME_MISSING_CR_REF - The specified naming context is missing a cross reference.
.

MessageId=8413
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SECURITY_CHECKING_ERROR
Language=English
ERROR_DS_SECURITY_CHECKING_ERROR - A security checking error has occurred.
.
Language=Russian
ERROR_DS_SECURITY_CHECKING_ERROR - A security checking error has occurred.
.
Language=Polish
ERROR_DS_SECURITY_CHECKING_ERROR - Podczas sprawdzania zabezpieczeń wystąpił błąd.
.
Language=Romanian
ERROR_DS_SECURITY_CHECKING_ERROR - A security checking error has occurred.
.

MessageId=8414
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SCHEMA_NOT_LOADED
Language=English
ERROR_DS_SCHEMA_NOT_LOADED - The schema is not loaded.
.
Language=Russian
ERROR_DS_SCHEMA_NOT_LOADED - The schema is not loaded.
.
Language=Polish
ERROR_DS_SCHEMA_NOT_LOADED - Schemat nie został załadowany.
.
Language=Romanian
ERROR_DS_SCHEMA_NOT_LOADED - The schema is not loaded.
.

MessageId=8415
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SCHEMA_ALLOC_FAILED
Language=English
ERROR_DS_SCHEMA_ALLOC_FAILED - Schema allocation failed. Please check if the machine is running low on memory.
.
Language=Russian
ERROR_DS_SCHEMA_ALLOC_FAILED - Schema allocation failed. Please check if the machine is running low on memory.
.
Language=Polish
ERROR_DS_SCHEMA_ALLOC_FAILED - Nie można przydzielić pamięci dla schematu. Sprawdź, czy w komputerze nie brakuje pamięci.
.
Language=Romanian
ERROR_DS_SCHEMA_ALLOC_FAILED - Schema allocation failed. Please check if the machine is running low on memory.
.

MessageId=8416
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ATT_SCHEMA_REQ_SYNTAX
Language=English
ERROR_DS_ATT_SCHEMA_REQ_SYNTAX - Failed to obtain the required syntax for the attribute schema.
.
Language=Russian
ERROR_DS_ATT_SCHEMA_REQ_SYNTAX - Failed to obtain the required syntax for the attribute schema.
.
Language=Polish
ERROR_DS_ATT_SCHEMA_REQ_SYNTAX - Nie można uzyskać wymaganej składni schematu atrybutów.
.
Language=Romanian
ERROR_DS_ATT_SCHEMA_REQ_SYNTAX - Failed to obtain the required syntax for the attribute schema.
.

MessageId=8417
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GCVERIFY_ERROR
Language=English
ERROR_DS_GCVERIFY_ERROR - The global catalog verification failed. The global catalog is not available or does not support the operation. Some part of the directory is currently not available.
.
Language=Russian
ERROR_DS_GCVERIFY_ERROR - The global catalog verification failed. The global catalog is not available or does not support the operation. Some part of the directory is currently not available.
.
Language=Polish
ERROR_DS_GCVERIFY_ERROR - Nie można zweryfikować wykazu globalnego. Wykaz globalny nie jest dostępny lub nie obsługuje operacji. Część katalogu nie jest obecnie dostępna.
.
Language=Romanian
ERROR_DS_GCVERIFY_ERROR - The global catalog verification failed. The global catalog is not available or does not support the operation. Some part of the directory is currently not available.
.

MessageId=8418
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SCHEMA_MISMATCH
Language=English
ERROR_DS_DRA_SCHEMA_MISMATCH - The replication operation failed because of a schema mismatch between the servers involved.
.
Language=Russian
ERROR_DS_DRA_SCHEMA_MISMATCH - The replication operation failed because of a schema mismatch between the servers involved.
.
Language=Polish
ERROR_DS_DRA_SCHEMA_MISMATCH - Nie można wykonać replikacji, ponieważ występuje niezgodność schematów pomiędzy serwerami biorącymi udział w operacji.
.
Language=Romanian
ERROR_DS_DRA_SCHEMA_MISMATCH - The replication operation failed because of a schema mismatch between the servers involved.
.

MessageId=8419
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_FIND_DSA_OBJ
Language=English
ERROR_DS_CANT_FIND_DSA_OBJ - The DSA object could not be found.
.
Language=Russian
ERROR_DS_CANT_FIND_DSA_OBJ - The DSA object could not be found.
.
Language=Polish
ERROR_DS_CANT_FIND_DSA_OBJ - Nie można znaleźć obiektu DSA.
.
Language=Romanian
ERROR_DS_CANT_FIND_DSA_OBJ - The DSA object could not be found.
.

MessageId=8420
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_FIND_EXPECTED_NC
Language=English
ERROR_DS_CANT_FIND_EXPECTED_NC - The naming context could not be found.
.
Language=Russian
ERROR_DS_CANT_FIND_EXPECTED_NC - The naming context could not be found.
.
Language=Polish
ERROR_DS_CANT_FIND_EXPECTED_NC - Nie można znaleźć kontekstu nazewnictwa.
.
Language=Romanian
ERROR_DS_CANT_FIND_EXPECTED_NC - The naming context could not be found.
.

MessageId=8421
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_FIND_NC_IN_CACHE
Language=English
ERROR_DS_CANT_FIND_NC_IN_CACHE - The naming context could not be found in the cache.
.
Language=Russian
ERROR_DS_CANT_FIND_NC_IN_CACHE - The naming context could not be found in the cache.
.
Language=Polish
ERROR_DS_CANT_FIND_NC_IN_CACHE - Nie można znaleźć kontekstu nazewnictwa w pamięci podręcznej.
.
Language=Romanian
ERROR_DS_CANT_FIND_NC_IN_CACHE - The naming context could not be found in the cache.
.

MessageId=8422
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_RETRIEVE_CHILD
Language=English
ERROR_DS_CANT_RETRIEVE_CHILD - The child object could not be retrieved.
.
Language=Russian
ERROR_DS_CANT_RETRIEVE_CHILD - The child object could not be retrieved.
.
Language=Polish
ERROR_DS_CANT_RETRIEVE_CHILD - Nie można pobrać obiektu podrzędnego.
.
Language=Romanian
ERROR_DS_CANT_RETRIEVE_CHILD - The child object could not be retrieved.
.

MessageId=8423
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SECURITY_ILLEGAL_MODIFY
Language=English
ERROR_DS_SECURITY_ILLEGAL_MODIFY - The modification was not permitted for security reasons.
.
Language=Russian
ERROR_DS_SECURITY_ILLEGAL_MODIFY - The modification was not permitted for security reasons.
.
Language=Polish
ERROR_DS_SECURITY_ILLEGAL_MODIFY - Modyfikacja nie została dozwolona z powodów bezpieczeństwa.
.
Language=Romanian
ERROR_DS_SECURITY_ILLEGAL_MODIFY - The modification was not permitted for security reasons.
.

MessageId=8424
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_REPLACE_HIDDEN_REC
Language=English
ERROR_DS_CANT_REPLACE_HIDDEN_REC - The operation cannot replace the hidden record.
.
Language=Russian
ERROR_DS_CANT_REPLACE_HIDDEN_REC - The operation cannot replace the hidden record.
.
Language=Polish
ERROR_DS_CANT_REPLACE_HIDDEN_REC - Operacja nie może zamienić ukrytego rekordu.
.
Language=Romanian
ERROR_DS_CANT_REPLACE_HIDDEN_REC - The operation cannot replace the hidden record.
.

MessageId=8425
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BAD_HIERARCHY_FILE
Language=English
ERROR_DS_BAD_HIERARCHY_FILE - The hierarchy file is invalid.
.
Language=Russian
ERROR_DS_BAD_HIERARCHY_FILE - The hierarchy file is invalid.
.
Language=Polish
ERROR_DS_BAD_HIERARCHY_FILE - Plik hierarchii jest nieprawidłowy.
.
Language=Romanian
ERROR_DS_BAD_HIERARCHY_FILE - The hierarchy file is invalid.
.

MessageId=8426
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED
Language=English
ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED - The attempt to build the hierarchy table failed.
.
Language=Russian
ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED - The attempt to build the hierarchy table failed.
.
Language=Polish
ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED - Nie można utworzyć tablicy hierarchii.
.
Language=Romanian
ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED - The attempt to build the hierarchy table failed.
.

MessageId=8427
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CONFIG_PARAM_MISSING
Language=English
ERROR_DS_CONFIG_PARAM_MISSING - The directory configuration parameter is missing from the registry.
.
Language=Russian
ERROR_DS_CONFIG_PARAM_MISSING - The directory configuration parameter is missing from the registry.
.
Language=Polish
ERROR_DS_CONFIG_PARAM_MISSING - W Rejestrze brakuje parametru konfiguracji katalogu.
.
Language=Romanian
ERROR_DS_CONFIG_PARAM_MISSING - The directory configuration parameter is missing from the registry.
.

MessageId=8428
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COUNTING_AB_INDICES_FAILED
Language=English
ERROR_DS_COUNTING_AB_INDICES_FAILED - The attempt to count the address book indices failed.
.
Language=Russian
ERROR_DS_COUNTING_AB_INDICES_FAILED - The attempt to count the address book indices failed.
.
Language=Polish
ERROR_DS_COUNTING_AB_INDICES_FAILED - Nie można policzyć indeksów książki adresowej.
.
Language=Romanian
ERROR_DS_COUNTING_AB_INDICES_FAILED - The attempt to count the address book indices failed.
.

MessageId=8429
Severity=Success
Facility=System
SymbolicName=ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED
Language=English
ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED - The allocation of the hierarchy table failed.
.
Language=Russian
ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED - The allocation of the hierarchy table failed.
.
Language=Polish
ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED - Nie można przydzielić pamięci dla tabeli hierarchii.
.
Language=Romanian
ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED - The allocation of the hierarchy table failed.
.

MessageId=8430
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INTERNAL_FAILURE
Language=English
ERROR_DS_INTERNAL_FAILURE - The directory service encountered an internal failure.
.
Language=Russian
ERROR_DS_INTERNAL_FAILURE - The directory service encountered an internal failure.
.
Language=Polish
ERROR_DS_INTERNAL_FAILURE - Usługa katalogowa napotkała błąd wewnętrzny.
.
Language=Romanian
ERROR_DS_INTERNAL_FAILURE - The directory service encountered an internal failure.
.

MessageId=8431
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNKNOWN_ERROR
Language=English
ERROR_DS_UNKNOWN_ERROR - The directory service encountered an unknown failure.
.
Language=Russian
ERROR_DS_UNKNOWN_ERROR - The directory service encountered an unknown failure.
.
Language=Polish
ERROR_DS_UNKNOWN_ERROR - Usługa katalogowa napotkała nieznany błąd.
.
Language=Romanian
ERROR_DS_UNKNOWN_ERROR - The directory service encountered an unknown failure.
.

MessageId=8432
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ROOT_REQUIRES_CLASS_TOP
Language=English
ERROR_DS_ROOT_REQUIRES_CLASS_TOP - A root object requires a class of 'top'.
.
Language=Russian
ERROR_DS_ROOT_REQUIRES_CLASS_TOP - A root object requires a class of 'top'.
.
Language=Polish
ERROR_DS_ROOT_REQUIRES_CLASS_TOP - Obiekt główny wymaga klasy „top”.
.
Language=Romanian
ERROR_DS_ROOT_REQUIRES_CLASS_TOP - A root object requires a class of 'top'.
.

MessageId=8433
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REFUSING_FSMO_ROLES
Language=English
ERROR_DS_REFUSING_FSMO_ROLES - This directory server is shutting down, and cannot take ownership of new floating single-master operation roles.
.
Language=Russian
ERROR_DS_REFUSING_FSMO_ROLES - This directory server is shutting down, and cannot take ownership of new floating single-master operation roles.
.
Language=Polish
ERROR_DS_REFUSING_FSMO_ROLES - Serwer katalogu jest zamykany i nie może przejąć w posiadanie nowych zmiennych prostych operacji głównych (FSMO).
.
Language=Romanian
ERROR_DS_REFUSING_FSMO_ROLES - This directory server is shutting down, and cannot take ownership of new floating single-master operation roles.
.

MessageId=8434
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MISSING_FSMO_SETTINGS
Language=English
ERROR_DS_MISSING_FSMO_SETTINGS - The directory service is missing mandatory configuration information, and is unable to determine the ownership of floating single-master operation roles.
.
Language=Russian
ERROR_DS_MISSING_FSMO_SETTINGS - The directory service is missing mandatory configuration information, and is unable to determine the ownership of floating single-master operation roles.
.
Language=Polish
ERROR_DS_MISSING_FSMO_SETTINGS - Usłudze katalogowej brakuje koniecznych informacji o konfiguracji - nie można określić posiadaczy zmiennych prostych operacji głównych (FSMO).
.
Language=Romanian
ERROR_DS_MISSING_FSMO_SETTINGS - The directory service is missing mandatory configuration information, and is unable to determine the ownership of floating single-master operation roles.
.

MessageId=8435
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNABLE_TO_SURRENDER_ROLES
Language=English
ERROR_DS_UNABLE_TO_SURRENDER_ROLES - The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers.
.
Language=Russian
ERROR_DS_UNABLE_TO_SURRENDER_ROLES - The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers.
.
Language=Polish
ERROR_DS_UNABLE_TO_SURRENDER_ROLES - Usługa katalogowa nie może przetransferować do innych serwerów praw własności do zmiennych prostych operacji głównych (FSMO).
.
Language=Romanian
ERROR_DS_UNABLE_TO_SURRENDER_ROLES - The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers.
.

MessageId=8436
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_GENERIC
Language=English
ERROR_DS_DRA_GENERIC - The replication operation failed.
.
Language=Russian
ERROR_DS_DRA_GENERIC - The replication operation failed.
.
Language=Polish
ERROR_DS_DRA_GENERIC - Operacja replikacji nie powiodła się.
.
Language=Romanian
ERROR_DS_DRA_GENERIC - The replication operation failed.
.

MessageId=8437
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_INVALID_PARAMETER
Language=English
ERROR_DS_DRA_INVALID_PARAMETER - An invalid parameter was specified for this replication operation.
.
Language=Russian
ERROR_DS_DRA_INVALID_PARAMETER - An invalid parameter was specified for this replication operation.
.
Language=Polish
ERROR_DS_DRA_INVALID_PARAMETER - Podano nieprawidłowy parametr dla tej operacji replikacji.
.
Language=Romanian
ERROR_DS_DRA_INVALID_PARAMETER - An invalid parameter was specified for this replication operation.
.

MessageId=8438
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_BUSY
Language=English
ERROR_DS_DRA_BUSY - The directory service is too busy to complete the replication operation at this time.
.
Language=Russian
ERROR_DS_DRA_BUSY - The directory service is too busy to complete the replication operation at this time.
.
Language=Polish
ERROR_DS_DRA_BUSY - Usługa katalogowa jest zbyt zajęta, aby dokończyć teraz operację replikacji.
.
Language=Romanian
ERROR_DS_DRA_BUSY - The directory service is too busy to complete the replication operation at this time.
.

MessageId=8439
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_BAD_DN
Language=English
ERROR_DS_DRA_BAD_DN - The distinguished name specified for this replication operation is invalid.
.
Language=Russian
ERROR_DS_DRA_BAD_DN - The distinguished name specified for this replication operation is invalid.
.
Language=Polish
ERROR_DS_DRA_BAD_DN - Nazwa wyróżniająca, podana dla tej operacji replikacji, jest nieprawidłowa.
.
Language=Romanian
ERROR_DS_DRA_BAD_DN - The distinguished name specified for this replication operation is invalid.
.

MessageId=8440
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_BAD_NC
Language=English
ERROR_DS_DRA_BAD_NC - The naming context specified for this replication operation is invalid.
.
Language=Russian
ERROR_DS_DRA_BAD_NC - The naming context specified for this replication operation is invalid.
.
Language=Polish
ERROR_DS_DRA_BAD_NC - Kontekst nazewnictwa, podany dla tej operacji replikacji, jest nieprawidłowy.
.
Language=Romanian
ERROR_DS_DRA_BAD_NC - The naming context specified for this replication operation is invalid.
.

MessageId=8441
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_DN_EXISTS
Language=English
ERROR_DS_DRA_DN_EXISTS - The distinguished name specified for this replication operation already exists.
.
Language=Russian
ERROR_DS_DRA_DN_EXISTS - The distinguished name specified for this replication operation already exists.
.
Language=Polish
ERROR_DS_DRA_DN_EXISTS - Nazwa wyróżniająca, podana dla tej operacji replikacji, już istnieje.
.
Language=Romanian
ERROR_DS_DRA_DN_EXISTS - The distinguished name specified for this replication operation already exists.
.

MessageId=8442
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_INTERNAL_ERROR
Language=English
ERROR_DS_DRA_INTERNAL_ERROR - The replication system encountered an internal error.
.
Language=Russian
ERROR_DS_DRA_INTERNAL_ERROR - The replication system encountered an internal error.
.
Language=Polish
ERROR_DS_DRA_INTERNAL_ERROR - System replikacji napotkał błąd wewnętrzny.
.
Language=Romanian
ERROR_DS_DRA_INTERNAL_ERROR - The replication system encountered an internal error.
.

MessageId=8443
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_INCONSISTENT_DIT
Language=English
ERROR_DS_DRA_INCONSISTENT_DIT - The replication operation encountered a database inconsistency.
.
Language=Russian
ERROR_DS_DRA_INCONSISTENT_DIT - The replication operation encountered a database inconsistency.
.
Language=Polish
ERROR_DS_DRA_INCONSISTENT_DIT - Podczas operacji replikacji wykryto niespójność bazy danych.
.
Language=Romanian
ERROR_DS_DRA_INCONSISTENT_DIT - The replication operation encountered a database inconsistency.
.

MessageId=8444
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_CONNECTION_FAILED
Language=English
ERROR_DS_DRA_CONNECTION_FAILED - The server specified for this replication operation could not be contacted.
.
Language=Russian
ERROR_DS_DRA_CONNECTION_FAILED - The server specified for this replication operation could not be contacted.
.
Language=Polish
ERROR_DS_DRA_CONNECTION_FAILED - Nie można skontaktować się z serwerem podanym dla tej operacji replikacji.
.
Language=Romanian
ERROR_DS_DRA_CONNECTION_FAILED - The server specified for this replication operation could not be contacted.
.

MessageId=8445
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_BAD_INSTANCE_TYPE
Language=English
ERROR_DS_DRA_BAD_INSTANCE_TYPE - The replication operation encountered an object with an invalid instance type.
.
Language=Russian
ERROR_DS_DRA_BAD_INSTANCE_TYPE - The replication operation encountered an object with an invalid instance type.
.
Language=Polish
ERROR_DS_DRA_BAD_INSTANCE_TYPE - Operacja replikacji napotkała obiekt z nieprawidłowym typem wystąpienia.
.
Language=Romanian
ERROR_DS_DRA_BAD_INSTANCE_TYPE - The replication operation encountered an object with an invalid instance type.
.

MessageId=8446
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_OUT_OF_MEM
Language=English
ERROR_DS_DRA_OUT_OF_MEM - The replication operation failed to allocate memory.
.
Language=Russian
ERROR_DS_DRA_OUT_OF_MEM - The replication operation failed to allocate memory.
.
Language=Polish
ERROR_DS_DRA_OUT_OF_MEM - Nie można przydzielić pamięci dla operacji replikacji.
.
Language=Romanian
ERROR_DS_DRA_OUT_OF_MEM - The replication operation failed to allocate memory.
.

MessageId=8447
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_MAIL_PROBLEM
Language=English
ERROR_DS_DRA_MAIL_PROBLEM - The replication operation encountered an error with the mail system.
.
Language=Russian
ERROR_DS_DRA_MAIL_PROBLEM - The replication operation encountered an error with the mail system.
.
Language=Polish
ERROR_DS_DRA_MAIL_PROBLEM - Operacja replikacji napotkała błąd systemu poczty.
.
Language=Romanian
ERROR_DS_DRA_MAIL_PROBLEM - The replication operation encountered an error with the mail system.
.

MessageId=8448
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_REF_ALREADY_EXISTS
Language=English
ERROR_DS_DRA_REF_ALREADY_EXISTS - The replication reference information for the target server already exists.
.
Language=Russian
ERROR_DS_DRA_REF_ALREADY_EXISTS - The replication reference information for the target server already exists.
.
Language=Polish
ERROR_DS_DRA_REF_ALREADY_EXISTS - Informacja dla serwera docelowego o odniesieniu replikacji już istnieje.
.
Language=Romanian
ERROR_DS_DRA_REF_ALREADY_EXISTS - The replication reference information for the target server already exists.
.

MessageId=8449
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_REF_NOT_FOUND
Language=English
ERROR_DS_DRA_REF_NOT_FOUND - The replication reference information for the target server does not exist.
.
Language=Russian
ERROR_DS_DRA_REF_NOT_FOUND - The replication reference information for the target server does not exist.
.
Language=Polish
ERROR_DS_DRA_REF_NOT_FOUND - Informacja dla serwera docelowego o odniesieniu replikacji nie istnieje.
.
Language=Romanian
ERROR_DS_DRA_REF_NOT_FOUND - The replication reference information for the target server does not exist.
.

MessageId=8450
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_OBJ_IS_REP_SOURCE
Language=English
ERROR_DS_DRA_OBJ_IS_REP_SOURCE - The naming context cannot be removed because it is replicated to another server.
.
Language=Russian
ERROR_DS_DRA_OBJ_IS_REP_SOURCE - The naming context cannot be removed because it is replicated to another server.
.
Language=Polish
ERROR_DS_DRA_OBJ_IS_REP_SOURCE - Kontekst nazewnictwa nie może być usunięty, ponieważ jest replikowany do innego serwera.
.
Language=Romanian
ERROR_DS_DRA_OBJ_IS_REP_SOURCE - The naming context cannot be removed because it is replicated to another server.
.

MessageId=8451
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_DB_ERROR
Language=English
ERROR_DS_DRA_DB_ERROR - The replication operation encountered a database error.
.
Language=Russian
ERROR_DS_DRA_DB_ERROR - The replication operation encountered a database error.
.
Language=Polish
ERROR_DS_DRA_DB_ERROR - Operacja replikacji napotkała błąd bazy danych.
.
Language=Romanian
ERROR_DS_DRA_DB_ERROR - The replication operation encountered a database error.
.

MessageId=8452
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_NO_REPLICA
Language=English
ERROR_DS_DRA_NO_REPLICA - The naming context is in the process of being removed or is not replicated from the specified server.
.
Language=Russian
ERROR_DS_DRA_NO_REPLICA - The naming context is in the process of being removed or is not replicated from the specified server.
.
Language=Polish
ERROR_DS_DRA_NO_REPLICA - Kontekst nazewnictwa jest właśnie usuwany lub nie jest replikowany z podanego serwera.
.
Language=Romanian
ERROR_DS_DRA_NO_REPLICA - The naming context is in the process of being removed or is not replicated from the specified server.
.

MessageId=8453
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_ACCESS_DENIED
Language=English
ERROR_DS_DRA_ACCESS_DENIED - Replication access was denied.
.
Language=Russian
ERROR_DS_DRA_ACCESS_DENIED - Replication access was denied.
.
Language=Polish
ERROR_DS_DRA_ACCESS_DENIED - Odmówiono dostępu dla replikacji.
.
Language=Romanian
ERROR_DS_DRA_ACCESS_DENIED - Replication access was denied.
.

MessageId=8454
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_NOT_SUPPORTED
Language=English
ERROR_DS_DRA_NOT_SUPPORTED - The requested operation is not supported by this version of the directory service.
.
Language=Russian
ERROR_DS_DRA_NOT_SUPPORTED - The requested operation is not supported by this version of the directory service.
.
Language=Polish
ERROR_DS_DRA_NOT_SUPPORTED - Żądana operacja nie jest obsługiwana przez tą wersję usługi katalogowej.
.
Language=Romanian
ERROR_DS_DRA_NOT_SUPPORTED - The requested operation is not supported by this version of the directory service.
.

MessageId=8455
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_RPC_CANCELLED
Language=English
ERROR_DS_DRA_RPC_CANCELLED - The replication remote procedure call was cancelled.
.
Language=Russian
ERROR_DS_DRA_RPC_CANCELLED - The replication remote procedure call was cancelled.
.
Language=Polish
ERROR_DS_DRA_RPC_CANCELLED - Zdalne wywołanie procedury replikacji zostało anulowane.
.
Language=Romanian
ERROR_DS_DRA_RPC_CANCELLED - The replication remote procedure call was cancelled.
.

MessageId=8456
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SOURCE_DISABLED
Language=English
ERROR_DS_DRA_SOURCE_DISABLED - The source server is currently rejecting replication requests.
.
Language=Russian
ERROR_DS_DRA_SOURCE_DISABLED - The source server is currently rejecting replication requests.
.
Language=Polish
ERROR_DS_DRA_SOURCE_DISABLED - Serwer źródłowy obecnie odrzuca żądania replikacji.
.
Language=Romanian
ERROR_DS_DRA_SOURCE_DISABLED - The source server is currently rejecting replication requests.
.

MessageId=8457
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SINK_DISABLED
Language=English
ERROR_DS_DRA_SINK_DISABLED - The destination server is currently rejecting replication requests.
.
Language=Russian
ERROR_DS_DRA_SINK_DISABLED - The destination server is currently rejecting replication requests.
.
Language=Polish
ERROR_DS_DRA_SINK_DISABLED - Serwer docelowy obecnie odrzuca żądania replikacji.
.
Language=Romanian
ERROR_DS_DRA_SINK_DISABLED - The destination server is currently rejecting replication requests.
.

MessageId=8458
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_NAME_COLLISION
Language=English
ERROR_DS_DRA_NAME_COLLISION - The replication operation failed due to a collision of object names.
.
Language=Russian
ERROR_DS_DRA_NAME_COLLISION - The replication operation failed due to a collision of object names.
.
Language=Polish
ERROR_DS_DRA_NAME_COLLISION - Nie można wykonać operacji replikacji z powodu konfliktu nazw obiektów.
.
Language=Romanian
ERROR_DS_DRA_NAME_COLLISION - The replication operation failed due to a collision of object names.
.

MessageId=8459
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SOURCE_REINSTALLED
Language=English
ERROR_DS_DRA_SOURCE_REINSTALLED - The replication source has been reinstalled.
.
Language=Russian
ERROR_DS_DRA_SOURCE_REINSTALLED - The replication source has been reinstalled.
.
Language=Polish
ERROR_DS_DRA_SOURCE_REINSTALLED - Źródło replikacji zostało ponownie zainstalowane.
.
Language=Romanian
ERROR_DS_DRA_SOURCE_REINSTALLED - The replication source has been reinstalled.
.

MessageId=8460
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_MISSING_PARENT
Language=English
ERROR_DS_DRA_MISSING_PARENT - The replication operation failed because a required parent object is missing.
.
Language=Russian
ERROR_DS_DRA_MISSING_PARENT - The replication operation failed because a required parent object is missing.
.
Language=Polish
ERROR_DS_DRA_MISSING_PARENT - Nie można wykonać operacji replikacji, ponieważ brakuje obiektu nadrzędnego.
.
Language=Romanian
ERROR_DS_DRA_MISSING_PARENT - The replication operation failed because a required parent object is missing.
.

MessageId=8461
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_PREEMPTED
Language=English
ERROR_DS_DRA_PREEMPTED - The replication operation was preempted.
.
Language=Russian
ERROR_DS_DRA_PREEMPTED - The replication operation was preempted.
.
Language=Polish
ERROR_DS_DRA_PREEMPTED - Operacja replikacji została udaremniona.
.
Language=Romanian
ERROR_DS_DRA_PREEMPTED - The replication operation was preempted.
.

MessageId=8462
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_ABANDON_SYNC
Language=English
ERROR_DS_DRA_ABANDON_SYNC - The replication synchronization attempt was abandoned because of a lack of updates.
.
Language=Russian
ERROR_DS_DRA_ABANDON_SYNC - The replication synchronization attempt was abandoned because of a lack of updates.
.
Language=Polish
ERROR_DS_DRA_ABANDON_SYNC - Próba synchronizacji replikacji została zaniechana z powodu braku aktualizacji.
.
Language=Romanian
ERROR_DS_DRA_ABANDON_SYNC - The replication synchronization attempt was abandoned because of a lack of updates.
.

MessageId=8463
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SHUTDOWN
Language=English
ERROR_DS_DRA_SHUTDOWN - The replication operation was terminated because the system is shutting down.
.
Language=Russian
ERROR_DS_DRA_SHUTDOWN - The replication operation was terminated because the system is shutting down.
.
Language=Polish
ERROR_DS_DRA_SHUTDOWN - Operacja replikacji została przerwana, ponieważ system jest zamykany.
.
Language=Romanian
ERROR_DS_DRA_SHUTDOWN - The replication operation was terminated because the system is shutting down.
.

MessageId=8464
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET
Language=English
ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET - Synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of the source partial attribute set.
.
Language=Russian
ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET - Synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of the source partial attribute set.
.
Language=Polish
ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET - Próba synchronizacji nie powiodła się, ponieważ docelowy kontroler domeny oczekuje na synchronizację nowych atrybutów częściowych ze źródła. Ta sytuacja jest normalna, jeśli bieżąca zmiana schematu zmodyfikowała zbiór częściowy atrybutów. Zbiór częściowy atrybutów docelowych nie jest podzbiorem zbioru częściowego atrybutów źródłowych.
.
Language=Romanian
ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET - Synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of the source partial attribute set.
.

MessageId=8465
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA
Language=English
ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA - The replication synchronization attempt failed because a master replica attempted to sync from a partial replica.
.
Language=Russian
ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA - The replication synchronization attempt failed because a master replica attempted to sync from a partial replica.
.
Language=Polish
ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA - Próba synchronizacji replikacji nie powiodła się, ponieważ główna replika próbowała zsynchronizować się z repliką częściową.
.
Language=Romanian
ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA - The replication synchronization attempt failed because a master replica attempted to sync from a partial replica.
.

MessageId=8466
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_EXTN_CONNECTION_FAILED
Language=English
ERROR_DS_DRA_EXTN_CONNECTION_FAILED - The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation.
.
Language=Russian
ERROR_DS_DRA_EXTN_CONNECTION_FAILED - The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation.
.
Language=Polish
ERROR_DS_DRA_EXTN_CONNECTION_FAILED - Skontaktowano się z serwerem podanym dla tej operacji replikacji, ale serwer ten nie zdołał się połączyć z dodatkowym serwerem potrzebnym do ukończenia operacji.
.
Language=Romanian
ERROR_DS_DRA_EXTN_CONNECTION_FAILED - The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation.
.

MessageId=8467
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INSTALL_SCHEMA_MISMATCH
Language=English
ERROR_DS_INSTALL_SCHEMA_MISMATCH - The version of the Active Directory schema of the source forest is not compatible with the version of Active Directory on this computer.
.
Language=Russian
ERROR_DS_INSTALL_SCHEMA_MISMATCH - The version of the Active Directory schema of the source forest is not compatible with the version of Active Directory on this computer.
.
Language=Polish
ERROR_DS_INSTALL_SCHEMA_MISMATCH - Wersja schematu usługi katalogowej lasu źródłowego jest niezgodna z wersją usługi katalogowej na tym komputerze.
.
Language=Romanian
ERROR_DS_INSTALL_SCHEMA_MISMATCH - The version of the Active Directory schema of the source forest is not compatible with the version of Active Directory on this computer.
.

MessageId=8468
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_LINK_ID
Language=English
ERROR_DS_DUP_LINK_ID - Schema update failed: An attribute with the same link identifier already exists.
.
Language=Russian
ERROR_DS_DUP_LINK_ID - Schema update failed: An attribute with the same link identifier already exists.
.
Language=Polish
ERROR_DS_DUP_LINK_ID - Nie można zaktualizować schematu: atrybut z tym samym identyfikatorem łącza już istnieje.
.
Language=Romanian
ERROR_DS_DUP_LINK_ID - Schema update failed: An attribute with the same link identifier already exists.
.

MessageId=8469
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_RESOLVING
Language=English
ERROR_DS_NAME_ERROR_RESOLVING - Name translation: Generic processing error.
.
Language=Russian
ERROR_DS_NAME_ERROR_RESOLVING - Name translation: Generic processing error.
.
Language=Polish
ERROR_DS_NAME_ERROR_RESOLVING - Tłumaczenie nazw: ogólny błąd przetwarzania.
.
Language=Romanian
ERROR_DS_NAME_ERROR_RESOLVING - Name translation: Generic processing error.
.

MessageId=8470
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_NOT_FOUND
Language=English
ERROR_DS_NAME_ERROR_NOT_FOUND - Name translation: Could not find the name or insufficient right to see name.
.
Language=Russian
ERROR_DS_NAME_ERROR_NOT_FOUND - Name translation: Could not find the name or insufficient right to see name.
.
Language=Polish
ERROR_DS_NAME_ERROR_NOT_FOUND - Tłumaczenie nazw: nie można znaleźć nazwy lub brak wystarczających uprawnień, aby ją zobaczyć.
.
Language=Romanian
ERROR_DS_NAME_ERROR_NOT_FOUND - Name translation: Could not find the name or insufficient right to see name.
.

MessageId=8471
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_NOT_UNIQUE
Language=English
ERROR_DS_NAME_ERROR_NOT_UNIQUE - Name translation: Input name mapped to more than one output name.
.
Language=Russian
ERROR_DS_NAME_ERROR_NOT_UNIQUE - Name translation: Input name mapped to more than one output name.
.
Language=Polish
ERROR_DS_NAME_ERROR_NOT_UNIQUE - Tłumaczenie nazw: nazwa wejściowa mapowana na więcej niż jedną nazwę wynikową.
.
Language=Romanian
ERROR_DS_NAME_ERROR_NOT_UNIQUE - Name translation: Input name mapped to more than one output name.
.

MessageId=8472
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_NO_MAPPING
Language=English
ERROR_DS_NAME_ERROR_NO_MAPPING - Name translation: Input name found, but not the associated output format.
.
Language=Russian
ERROR_DS_NAME_ERROR_NO_MAPPING - Name translation: Input name found, but not the associated output format.
.
Language=Polish
ERROR_DS_NAME_ERROR_NO_MAPPING - Tłumaczenie nazw: znaleziono nazwę wejściową, lecz nie znaleziono skojarzonego formatu nazwy wynikowej.
.
Language=Romanian
ERROR_DS_NAME_ERROR_NO_MAPPING - Name translation: Input name found, but not the associated output format.
.

MessageId=8473
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_DOMAIN_ONLY
Language=English
ERROR_DS_NAME_ERROR_DOMAIN_ONLY - Name translation: Unable to resolve completely, only the domain was found.
.
Language=Russian
ERROR_DS_NAME_ERROR_DOMAIN_ONLY - Name translation: Unable to resolve completely, only the domain was found.
.
Language=Polish
ERROR_DS_NAME_ERROR_DOMAIN_ONLY - Tłumaczenie nazw: nie można w pełni rozpoznać - znaleziono tylko domenę.
.
Language=Romanian
ERROR_DS_NAME_ERROR_DOMAIN_ONLY - Name translation: Unable to resolve completely, only the domain was found.
.

MessageId=8474
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING
Language=English
ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING - Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire.
.
Language=Russian
ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING - Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire.
.
Language=Polish
ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING - Tłumaczenie nazw: nie można przeprowadzić czysto syntaktycznego odwzorowania u klienta nie mając połączenia z siecią.
.
Language=Romanian
ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING - Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire.
.

MessageId=8475
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CONSTRUCTED_ATT_MOD
Language=English
ERROR_DS_CONSTRUCTED_ATT_MOD - Modification of a constructed attribute is not allowed.
.
Language=Russian
ERROR_DS_CONSTRUCTED_ATT_MOD - Modification of a constructed attribute is not allowed.
.
Language=Polish
ERROR_DS_CONSTRUCTED_ATT_MOD - Modyfikowanie złożonego atrybutu jest niedozwolone.
.
Language=Romanian
ERROR_DS_CONSTRUCTED_ATT_MOD - Modification of a constructed attribute is not allowed.
.

MessageId=8476
Severity=Success
Facility=System
SymbolicName=ERROR_DS_WRONG_OM_OBJ_CLASS
Language=English
ERROR_DS_WRONG_OM_OBJ_CLASS - The OM-Object-Class specified is incorrect for an attribute with the specified syntax.
.
Language=Russian
ERROR_DS_WRONG_OM_OBJ_CLASS - The OM-Object-Class specified is incorrect for an attribute with the specified syntax.
.
Language=Polish
ERROR_DS_WRONG_OM_OBJ_CLASS - Podany ciąg OM-Obiekt-Klasa jest niepoprawny dla atrybutu o podanej składni.
.
Language=Romanian
ERROR_DS_WRONG_OM_OBJ_CLASS - The OM-Object-Class specified is incorrect for an attribute with the specified syntax.
.

MessageId=8477
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_REPL_PENDING
Language=English
ERROR_DS_DRA_REPL_PENDING - The replication request has been posted; waiting for reply.
.
Language=Russian
ERROR_DS_DRA_REPL_PENDING - The replication request has been posted; waiting for reply.
.
Language=Polish
ERROR_DS_DRA_REPL_PENDING - Żądanie replikacji zostało wysłane; oczekiwanie na odpowiedź.
.
Language=Romanian
ERROR_DS_DRA_REPL_PENDING - The replication request has been posted; waiting for reply.
.

MessageId=8478
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DS_REQUIRED
Language=English
ERROR_DS_DS_REQUIRED - The requested operation requires a directory service, and none was available.
.
Language=Russian
ERROR_DS_DS_REQUIRED - The requested operation requires a directory service, and none was available.
.
Language=Polish
ERROR_DS_DS_REQUIRED - Żądana operacja wymaga usługi katalogowej, ale żadna usługa katalogowa nie jest dostępna.
.
Language=Romanian
ERROR_DS_DS_REQUIRED - The requested operation requires a directory service, and none was available.
.

MessageId=8479
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_LDAP_DISPLAY_NAME
Language=English
ERROR_DS_INVALID_LDAP_DISPLAY_NAME - The LDAP display name of the class or attribute contains non-ASCII characters.
.
Language=Russian
ERROR_DS_INVALID_LDAP_DISPLAY_NAME - The LDAP display name of the class or attribute contains non-ASCII characters.
.
Language=Polish
ERROR_DS_INVALID_LDAP_DISPLAY_NAME - Wyświetlana nazwa LDAP danej klasy lub atrybutu zawiera znaki inne niż ASCII.
.
Language=Romanian
ERROR_DS_INVALID_LDAP_DISPLAY_NAME - The LDAP display name of the class or attribute contains non-ASCII characters.
.

MessageId=8480
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NON_BASE_SEARCH
Language=English
ERROR_DS_NON_BASE_SEARCH - The requested search operation is only supported for base searches.
.
Language=Russian
ERROR_DS_NON_BASE_SEARCH - The requested search operation is only supported for base searches.
.
Language=Polish
ERROR_DS_NON_BASE_SEARCH - Żądana operacja wyszukiwania jest obsługiwana tylko dla przeszukiwań bazowych.
.
Language=Romanian
ERROR_DS_NON_BASE_SEARCH - The requested search operation is only supported for base searches.
.

MessageId=8481
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_RETRIEVE_ATTS
Language=English
ERROR_DS_CANT_RETRIEVE_ATTS - The search failed to retrieve attributes from the database.
.
Language=Russian
ERROR_DS_CANT_RETRIEVE_ATTS - The search failed to retrieve attributes from the database.
.
Language=Polish
ERROR_DS_CANT_RETRIEVE_ATTS - Operacja wyszukiwania nie może pobrać atrybutów z bazy danych.
.
Language=Romanian
ERROR_DS_CANT_RETRIEVE_ATTS - The search failed to retrieve attributes from the database.
.

MessageId=8482
Severity=Success
Facility=System
SymbolicName=ERROR_DS_BACKLINK_WITHOUT_LINK
Language=English
ERROR_DS_BACKLINK_WITHOUT_LINK - The schema update operation tried to add a backward link attribute that has no corresponding forward link.
.
Language=Russian
ERROR_DS_BACKLINK_WITHOUT_LINK - The schema update operation tried to add a backward link attribute that has no corresponding forward link.
.
Language=Polish
ERROR_DS_BACKLINK_WITHOUT_LINK - Operacja zaktualizowania schematu próbowała dodać atrybut odsyłacza wstecznego, któremu nie towarzyszy odsyłacz do przodu.
.
Language=Romanian
ERROR_DS_BACKLINK_WITHOUT_LINK - The schema update operation tried to add a backward link attribute that has no corresponding forward link.
.

MessageId=8483
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EPOCH_MISMATCH
Language=English
ERROR_DS_EPOCH_MISMATCH - Source and destination of a cross domain move do not agree on the object's epoch number. Either source or destination does not have the latest version of the object.
.
Language=Russian
ERROR_DS_EPOCH_MISMATCH - Source and destination of a cross domain move do not agree on the object's epoch number. Either source or destination does not have the latest version of the object.
.
Language=Polish
ERROR_DS_EPOCH_MISMATCH - Źródło i miejsce docelowe operacji przenoszenia poza domenę nie mogą uzgodnić numeru epoki obiektu. Albo źródło, albo miejsce docelowe nie ma najnowszej wersji obiektu.
.
Language=Romanian
ERROR_DS_EPOCH_MISMATCH - Source and destination of a cross domain move do not agree on the object's epoch number. Either source or destination does not have the latest version of the object.
.

MessageId=8484
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_NAME_MISMATCH
Language=English
ERROR_DS_SRC_NAME_MISMATCH - Source and destination of a cross domain move do not agree on the object's current name. Either source or destination does not have the latest version of the object.
.
Language=Russian
ERROR_DS_SRC_NAME_MISMATCH - Source and destination of a cross domain move do not agree on the object's current name. Either source or destination does not have the latest version of the object.
.
Language=Polish
ERROR_DS_SRC_NAME_MISMATCH - Źródło i miejsce docelowe operacji przenoszenia poza domenę nie mogą uzgodnić aktualnej nazwy obiektu. Albo źródło, albo miejsce docelowe nie ma najnowszej wersji obiektu.
.
Language=Romanian
ERROR_DS_SRC_NAME_MISMATCH - Source and destination of a cross domain move do not agree on the object's current name. Either source or destination does not have the latest version of the object.
.

MessageId=8485
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_AND_DST_NC_IDENTICAL
Language=English
ERROR_DS_SRC_AND_DST_NC_IDENTICAL - Source and destination of a cross domain move operation are identical. Caller should use local move operation instead of cross domain move operation.
.
Language=Russian
ERROR_DS_SRC_AND_DST_NC_IDENTICAL - Source and destination of a cross domain move operation are identical. Caller should use local move operation instead of cross domain move operation.
.
Language=Polish
ERROR_DS_SRC_AND_DST_NC_IDENTICAL - Źródło i miejsce docelowe operacji przenoszenia poza domenę są identyczne. Wywołujący powinien użyć operacji przenoszenia lokalnego zamiast operacji przenoszenia poza domenę.
.
Language=Romanian
ERROR_DS_SRC_AND_DST_NC_IDENTICAL - Source and destination of a cross domain move operation are identical. Caller should use local move operation instead of cross domain move operation.
.

MessageId=8486
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DST_NC_MISMATCH
Language=English
ERROR_DS_DST_NC_MISMATCH - Source and destination for a cross domain move are not in agreement on the naming contexts in the forest. Either source or destination does not have the latest version of the Partitions container.
.
Language=Russian
ERROR_DS_DST_NC_MISMATCH - Source and destination for a cross domain move are not in agreement on the naming contexts in the forest. Either source or destination does not have the latest version of the Partitions container.
.
Language=Polish
ERROR_DS_DST_NC_MISMATCH - Źródło i miejsce docelowe operacji przenoszenia poza domenę nie mogą uzgodnić kontekstów nazewnictwa w lesie. Albo źródło, albo miejsce docelowe nie ma najnowszej wersji kontenera partycji.
.
Language=Romanian
ERROR_DS_DST_NC_MISMATCH - Source and destination for a cross domain move are not in agreement on the naming contexts in the forest. Either source or destination does not have the latest version of the Partitions container.
.

MessageId=8487
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC
Language=English
ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC - Destination of a cross domain move is not authoritative for the destination naming context.
.
Language=Russian
ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC - Destination of a cross domain move is not authoritative for the destination naming context.
.
Language=Polish
ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC - Miejsce docelowe operacji przenoszenia poza domenę nie jest autorytatywne dla docelowego kontekstu nazewnictwa.
.
Language=Romanian
ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC - Destination of a cross domain move is not authoritative for the destination naming context.
.

MessageId=8488
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_GUID_MISMATCH
Language=English
ERROR_DS_SRC_GUID_MISMATCH - Source and destination of a cross domain move do not agree on the identity of the source object. Either source or destination does not have the latest version of the source object.
.
Language=Russian
ERROR_DS_SRC_GUID_MISMATCH - Source and destination of a cross domain move do not agree on the identity of the source object. Either source or destination does not have the latest version of the source object.
.
Language=Polish
ERROR_DS_SRC_GUID_MISMATCH - Źródło i miejsce docelowe operacji przenoszenia poza domenę nie mogą uzgodnić tożsamości obiektu źródłowego. Albo źródło, albo miejsce docelowe nie ma najnowszej wersji obiektu źródłowego.
.
Language=Romanian
ERROR_DS_SRC_GUID_MISMATCH - Source and destination of a cross domain move do not agree on the identity of the source object. Either source or destination does not have the latest version of the source object.
.

MessageId=8489
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOVE_DELETED_OBJECT
Language=English
ERROR_DS_CANT_MOVE_DELETED_OBJECT - Object being moved across domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object.
.
Language=Russian
ERROR_DS_CANT_MOVE_DELETED_OBJECT - Object being moved across domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object.
.
Language=Polish
ERROR_DS_CANT_MOVE_DELETED_OBJECT - Obiekt przenoszony poza domenę jest zaznaczony do usunięcia przez serwer docelowy. Serwer źródłowy nie ma najnowszej wersji obiektu źródłowego.
.
Language=Romanian
ERROR_DS_CANT_MOVE_DELETED_OBJECT - Object being moved across domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object.
.

MessageId=8490
Severity=Success
Facility=System
SymbolicName=ERROR_DS_PDC_OPERATION_IN_PROGRESS
Language=English
ERROR_DS_PDC_OPERATION_IN_PROGRESS - Another operation, which requires exclusive access to the PDC PSMO, is already in progress.
.
Language=Russian
ERROR_DS_PDC_OPERATION_IN_PROGRESS - Another operation, which requires exclusive access to the PDC PSMO, is already in progress.
.
Language=Polish
ERROR_DS_PDC_OPERATION_IN_PROGRESS - Inna operacja, która wymaga wyłącznego dostępu do PSMO PDC jest już wykonywana.
.
Language=Romanian
ERROR_DS_PDC_OPERATION_IN_PROGRESS - Another operation, which requires exclusive access to the PDC PSMO, is already in progress.
.

MessageId=8491
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD
Language=English
ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD - A cross domain move operation failed such that the two versions of the moved object exist - one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state.
.
Language=Russian
ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD - A cross domain move operation failed such that the two versions of the moved object exist - one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state.
.
Language=Polish
ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD - Operacja przenoszenia poza domenę nie powiodła się, ponieważ istnieją już dwie takie wersje przenoszonych obiektów - po jednym w domenie źródłowej i docelowej. Obiekt docelowy musi być usunięty, aby został przywrócony spójny stan systemu.
.
Language=Romanian
ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD - A cross domain move operation failed such that the two versions of the moved object exist - one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state.
.

MessageId=8492
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION
Language=English
ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION - This object may not be moved across domain boundaries either because cross domain moves for this class are disallowed, or the object has some special characteristics, e.g.: trust account or restricted RID, which prevent its move.
.
Language=Russian
ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION - This object may not be moved across domain boundaries either because cross domain moves for this class are disallowed, or the object has some special characteristics, e.g.: trust account or restricted RID, which prevent its move.
.
Language=Polish
ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION - Nie można przenieść tego obiektu poza granice domeny, ponieważ przenoszenie poza domenę nie jest dozwolone dla tej klasy albo obiekt ma pewne specjalne właściwości, takie jak konto zaufania czy ograniczony RID, uniemożliwiające przeniesienie.
.
Language=Romanian
ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION - This object may not be moved across domain boundaries either because cross domain moves for this class are disallowed, or the object has some special characteristics, e.g.: trust account or restricted RID, which prevent its move.
.

MessageId=8493
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS
Language=English
ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS - Can't move objects with memberships across domain boundaries as once moved, this would violate the membership conditions of the account group. Remove the object from any account group memberships and retry.
.
Language=Russian
ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS - Can't move objects with memberships across domain boundaries as once moved, this would violate the membership conditions of the account group. Remove the object from any account group memberships and retry.
.
Language=Polish
ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS - Nie można przenieść obiektów wraz z członkostwem poza granice domeny, ponieważ naruszyłoby to warunki członkostwa grupy kont. Anuluj członkostwo obiektu we wszystkich grupach kont, po czym ponów próbę.
.
Language=Romanian
ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS - Can't move objects with memberships across domain boundaries as once moved, this would violate the membership conditions of the account group. Remove the object from any account group memberships and retry.
.

MessageId=8494
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NC_MUST_HAVE_NC_PARENT
Language=English
ERROR_DS_NC_MUST_HAVE_NC_PARENT - A naming context head must be the immediate child of another naming context head, not of an interior node.
.
Language=Russian
ERROR_DS_NC_MUST_HAVE_NC_PARENT - A naming context head must be the immediate child of another naming context head, not of an interior node.
.
Language=Polish
ERROR_DS_NC_MUST_HAVE_NC_PARENT - Początek kontekstu nazewnictwa musi być bezpośrednim potomkiem innego początku kontekstu nazewnictwa, a nie potomkiem wewnętrznego węzła.
.
Language=Romanian
ERROR_DS_NC_MUST_HAVE_NC_PARENT - A naming context head must be the immediate child of another naming context head, not of an interior node.
.

MessageId=8495
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE
Language=English
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE - The directory cannot validate the proposed naming context name because it does not hold a replica of the naming context above the proposed naming context. Please ensure that the domain naming master role is held by a server that is configured as a global catalog server, and that the server is up to date with its replication partners. (Applies only to Windows 2000 Domain Naming masters)
.
Language=Russian
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE - The directory cannot validate the proposed naming context name because it does not hold a replica of the naming context above the proposed naming context. Please ensure that the domain naming master role is held by a server that is configured as a global catalog server, and that the server is up to date with its replication partners. (Applies only to Windows 2000 Domain Naming masters)
.
Language=Polish
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE - Katalog nie może sprawdzać poprawności nazwy z proponowanego kontekstu nazewnictwa, ponieważ nie zawiera repliki kontekstu nazewnictwa ponad proponowanym kontekstem nazewnictwa. Upewnij się, że rola wzorca operacji nazw domen jest pełniona przez serwer, który jest skonfigurowany jako serwer wykazu globalnego, i serwer ten jest zaktualizowany względem jego partnerów replikacji. (Ma zastosowanie tylko dla wzorców nazw domen systemu Windows 2000)
.
Language=Romanian
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE - The directory cannot validate the proposed naming context name because it does not hold a replica of the naming context above the proposed naming context. Please ensure that the domain naming master role is held by a server that is configured as a global catalog server, and that the server is up to date with its replication partners. (Applies only to Windows 2000 Domain Naming masters)
.

MessageId=8496
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DST_DOMAIN_NOT_NATIVE
Language=English
ERROR_DS_DST_DOMAIN_NOT_NATIVE - Destination domain must be in native mode.
.
Language=Russian
ERROR_DS_DST_DOMAIN_NOT_NATIVE - Destination domain must be in native mode.
.
Language=Polish
ERROR_DS_DST_DOMAIN_NOT_NATIVE - Domena docelowa musi być w trybie macierzystym.
.
Language=Romanian
ERROR_DS_DST_DOMAIN_NOT_NATIVE - Destination domain must be in native mode.
.

MessageId=8497
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER
Language=English
ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER - The operation cannot be performed because the server does not have an infrastructure container in the domain of interest.
.
Language=Russian
ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER - The operation cannot be performed because the server does not have an infrastructure container in the domain of interest.
.
Language=Polish
ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER - Nie można wykonać operacji, ponieważ serwer nie ma kontenera infrastruktury w domenie zainteresowań.
.
Language=Romanian
ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER - The operation cannot be performed because the server does not have an infrastructure container in the domain of interest.
.

MessageId=8498
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOVE_ACCOUNT_GROUP
Language=English
ERROR_DS_CANT_MOVE_ACCOUNT_GROUP - Cross-domain move of non-empty account groups is not allowed.
.
Language=Russian
ERROR_DS_CANT_MOVE_ACCOUNT_GROUP - Cross-domain move of non-empty account groups is not allowed.
.
Language=Polish
ERROR_DS_CANT_MOVE_ACCOUNT_GROUP - Przenoszenie niepustych grup kont poza granice domeny nie jest dozwolone.
.
Language=Romanian
ERROR_DS_CANT_MOVE_ACCOUNT_GROUP - Cross-domain move of non-empty account groups is not allowed.
.

MessageId=8499
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOVE_RESOURCE_GROUP
Language=English
ERROR_DS_CANT_MOVE_RESOURCE_GROUP - Cross-domain move of non-empty resource groups is not allowed.
.
Language=Russian
ERROR_DS_CANT_MOVE_RESOURCE_GROUP - Cross-domain move of non-empty resource groups is not allowed.
.
Language=Polish
ERROR_DS_CANT_MOVE_RESOURCE_GROUP - Przenoszenie niepustych grup zasobów poza granice domeny nie jest dozwolone.
.
Language=Romanian
ERROR_DS_CANT_MOVE_RESOURCE_GROUP - Cross-domain move of non-empty resource groups is not allowed.
.

MessageId=8500
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_SEARCH_FLAG
Language=English
ERROR_DS_INVALID_SEARCH_FLAG - The search flags for the attribute are invalid. The ANR bit is valid only on attributes of Unicode or Teletex strings.
.
Language=Russian
ERROR_DS_INVALID_SEARCH_FLAG - The search flags for the attribute are invalid. The ANR bit is valid only on attributes of Unicode or Teletex strings.
.
Language=Polish
ERROR_DS_INVALID_SEARCH_FLAG - Flagi wyszukiwania dla atrybutów są nieprawidłowe. Bit ANR jest ważny tylko dla atrybutów Unicode lub łańcuchów Teletekstu.
.
Language=Romanian
ERROR_DS_INVALID_SEARCH_FLAG - The search flags for the attribute are invalid. The ANR bit is valid only on attributes of Unicode or Teletex strings.
.

MessageId=8501
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_TREE_DELETE_ABOVE_NC
Language=English
ERROR_DS_NO_TREE_DELETE_ABOVE_NC - Tree deletions starting at an object which has an NC head as a descendant are not allowed.
.
Language=Russian
ERROR_DS_NO_TREE_DELETE_ABOVE_NC - Tree deletions starting at an object which has an NC head as a descendant are not allowed.
.
Language=Polish
ERROR_DS_NO_TREE_DELETE_ABOVE_NC - Usuwanie drzewa poczynając od obiektu-potomka będącego węzłem NC nie jest dozwolone.
.
Language=Romanian
ERROR_DS_NO_TREE_DELETE_ABOVE_NC - Tree deletions starting at an object which has an NC head as a descendant are not allowed.
.

MessageId=8502
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE
Language=English
ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE - The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use.
.
Language=Russian
ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE - The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use.
.
Language=Polish
ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE - Usługa katalogowa, przygotowując operację drzewa, nie mogła zablokować drzewa, ponieważ było ono wówczas używane.
.
Language=Romanian
ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE - The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use.
.

MessageId=8503
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE
Language=English
ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE - The directory service failed to identify the list of objects to delete while attempting a tree deletion.
.
Language=Russian
ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE - The directory service failed to identify the list of objects to delete while attempting a tree deletion.
.
Language=Polish
ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE - Usłudze katalogowej nie udało się zidentyfikować listy obiektów do usunięcia podczas próby usuwania drzewa.
.
Language=Romanian
ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE - The directory service failed to identify the list of objects to delete while attempting a tree deletion.
.

MessageId=8504
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SAM_INIT_FAILURE
Language=English
ERROR_DS_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Directory Services Restore Mode. Check the event log for detailed information.
.
Language=Russian
ERROR_DS_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Directory Services Restore Mode. Check the event log for detailed information.
.
Language=Polish
ERROR_DS_SAM_INIT_FAILURE - Nie można zainicjować Menedżera kont zabezpieczeń z powodu następującego błędu: %1.
Stan błędu: 0x%2. Zamknij system i uruchom go w trybie odtwarzania usługi katalogowej. Szczegółowe informacje można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
ERROR_DS_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Directory Services Restore Mode. Check the event log for detailed information.
.

MessageId=8505
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SENSITIVE_GROUP_VIOLATION
Language=English
ERROR_DS_SENSITIVE_GROUP_VIOLATION - Only an administrator can modify the membership list of an administrative group.
.
Language=Russian
ERROR_DS_SENSITIVE_GROUP_VIOLATION - Only an administrator can modify the membership list of an administrative group.
.
Language=Polish
ERROR_DS_SENSITIVE_GROUP_VIOLATION - Tylko administrator może modyfikować listę członków grupy administrującej.
.
Language=Romanian
ERROR_DS_SENSITIVE_GROUP_VIOLATION - Only an administrator can modify the membership list of an administrative group.
.

MessageId=8506
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOD_PRIMARYGROUPID
Language=English
ERROR_DS_CANT_MOD_PRIMARYGROUPID - Cannot change the primary group ID of a domain controller account.
.
Language=Russian
ERROR_DS_CANT_MOD_PRIMARYGROUPID - Cannot change the primary group ID of a domain controller account.
.
Language=Polish
ERROR_DS_CANT_MOD_PRIMARYGROUPID - Nie można zmienić identyfikatora grupy podstawowej konta kontrolera domeny.
.
Language=Romanian
ERROR_DS_CANT_MOD_PRIMARYGROUPID - Cannot change the primary group ID of a domain controller account.
.

MessageId=8507
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD
Language=English
ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD - An attempt is made to modify the base schema.
.
Language=Russian
ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD - An attempt is made to modify the base schema.
.
Language=Polish
ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD - Została podjęta próba zmodyfikowania schematu podstawowego.
.
Language=Romanian
ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD - An attempt is made to modify the base schema.
.

MessageId=8508
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NONSAFE_SCHEMA_CHANGE
Language=English
ERROR_DS_NONSAFE_SCHEMA_CHANGE - Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed.
.
Language=Russian
ERROR_DS_NONSAFE_SCHEMA_CHANGE - Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed.
.
Language=Polish
ERROR_DS_NONSAFE_SCHEMA_CHANGE - Nie jest dozwolone: dodawanie do istniejącej klasy nowego obowiązkowego atrybutu, usuwanie obowiązkowego atrybutu z istniejącej klasy lub dodawanie opcjonalnego atrybutu do specjalnej klasy Top, który nie jest atrybutem odsyłacza wstecznego (bezpośrednio lub wskutek dziedziczenia, na przykład przez dodanie lub usunięcie klasy pomocniczej).
.
Language=Romanian
ERROR_DS_NONSAFE_SCHEMA_CHANGE - Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed.
.

MessageId=8509
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SCHEMA_UPDATE_DISALLOWED
Language=English
ERROR_DS_SCHEMA_UPDATE_DISALLOWED - Schema update is not allowed on this DC because the DC is not the schema FSMO Role Owner.
.
Language=Russian
ERROR_DS_SCHEMA_UPDATE_DISALLOWED - Schema update is not allowed on this DC because the DC is not the schema FSMO Role Owner.
.
Language=Polish
ERROR_DS_SCHEMA_UPDATE_DISALLOWED - Nie można zaktualizować schematu w bieżącym kontrolerze domeny, ponieważ kontroler domeny nie jest właścicielem schematu ról FSMO.
.
Language=Romanian
ERROR_DS_SCHEMA_UPDATE_DISALLOWED - Schema update is not allowed on this DC because the DC is not the schema FSMO Role Owner.
.

MessageId=8510
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_CREATE_UNDER_SCHEMA
Language=English
ERROR_DS_CANT_CREATE_UNDER_SCHEMA - An object of this class cannot be created under the schema container. You can only create attribute-schema and class-schema objects under the schema container.
.
Language=Russian
ERROR_DS_CANT_CREATE_UNDER_SCHEMA - An object of this class cannot be created under the schema container. You can only create attribute-schema and class-schema objects under the schema container.
.
Language=Polish
ERROR_DS_CANT_CREATE_UNDER_SCHEMA - Obiektu tej klasy nie można utworzyć w kontenerze schematów. W kontenerze schematów możesz utworzyć tylko obiekty typu schemat atrybutów i schemat klas.
.
Language=Romanian
ERROR_DS_CANT_CREATE_UNDER_SCHEMA - An object of this class cannot be created under the schema container. You can only create attribute-schema and class-schema objects under the schema container.
.

MessageId=8511
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INSTALL_NO_SRC_SCH_VERSION
Language=English
ERROR_DS_INSTALL_NO_SRC_SCH_VERSION - The replica/child install failed to get the objectVersion attribute on the schema container on the source DC. Either the attribute is missing on the schema container or the credentials supplied do not have permission to read it.
.
Language=Russian
ERROR_DS_INSTALL_NO_SRC_SCH_VERSION - The replica/child install failed to get the objectVersion attribute on the schema container on the source DC. Either the attribute is missing on the schema container or the credentials supplied do not have permission to read it.
.
Language=Polish
ERROR_DS_INSTALL_NO_SRC_SCH_VERSION - Instalacja repliki/obiektu potomnego nie mogła pobrać atrybutu wersji obiektu z kontenera schematów ze źródłowego kontrolera domeny. Albo brakuje atrybutu w kontenerze schematów, albo dostarczone poświadczenia nie nadają uprawnień odczytu.
.
Language=Romanian
ERROR_DS_INSTALL_NO_SRC_SCH_VERSION - The replica/child install failed to get the objectVersion attribute on the schema container on the source DC. Either the attribute is missing on the schema container or the credentials supplied do not have permission to read it.
.

MessageId=8512
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE
Language=English
ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE - The replica/child install failed to read the objectVersion attribute in the SCHEMA section of the file schema.ini in the system32 directory.
.
Language=Russian
ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE - The replica/child install failed to read the objectVersion attribute in the SCHEMA section of the file schema.ini in the system32 directory.
.
Language=Polish
ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE - Instalacja repliki/obiektu potomnego nie mogła odczytać atrybutu wersji obiektu z sekcji SCHEMA pliku schema.ini znajdującego się w katalogu system32.
.
Language=Romanian
ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE - The replica/child install failed to read the objectVersion attribute in the SCHEMA section of the file schema.ini in the system32 directory.
.

MessageId=8513
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_GROUP_TYPE
Language=English
ERROR_DS_INVALID_GROUP_TYPE - The specified group type is invalid.
.
Language=Russian
ERROR_DS_INVALID_GROUP_TYPE - The specified group type is invalid.
.
Language=Polish
ERROR_DS_INVALID_GROUP_TYPE - Określony typ grupy jest nieprawidłowy.
.
Language=Romanian
ERROR_DS_INVALID_GROUP_TYPE - The specified group type is invalid.
.

MessageId=8514
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN
Language=English
ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN - Cannot nest global groups in a mixed domain if the group is security-enabled.
.
Language=Russian
ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN - Cannot nest global groups in a mixed domain if the group is security-enabled.
.
Language=Polish
ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN - Nie można zagnieździć grup globalnych w domenie mieszanej, jeżeli zabezpieczenie grup jest włączone.
.
Language=Romanian
ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN - Cannot nest global groups in a mixed domain if the group is security-enabled.
.

MessageId=8515
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN
Language=English
ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN - Cannot nest local groups in a mixed domain if the group is security-enabled.
.
Language=Russian
ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN - Cannot nest local groups in a mixed domain if the group is security-enabled.
.
Language=Polish
ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN - Nie można zagnieździć grup lokalnych w domenie mieszanej, jeżeli zabezpieczenie grup jest włączone.
.
Language=Romanian
ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN - Cannot nest local groups in a mixed domain if the group is security-enabled.
.

MessageId=8516
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER
Language=English
ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER - A global group cannot have a local group as a member.
.
Language=Russian
ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER - A global group cannot have a local group as a member.
.
Language=Polish
ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER - Grupa lokalna nie może być członkiem grupy globalnej.
.
Language=Romanian
ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER - A global group cannot have a local group as a member.
.

MessageId=8517
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER
Language=English
ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER - A global group cannot have a universal group as a member.
.
Language=Russian
ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER - A global group cannot have a universal group as a member.
.
Language=Polish
ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER - Grupa uniwersalna nie może być członkiem grupy globalnej.
.
Language=Romanian
ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER - A global group cannot have a universal group as a member.
.

MessageId=8518
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER
Language=English
ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER - A universal group cannot have a local group as a member.
.
Language=Russian
ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER - A universal group cannot have a local group as a member.
.
Language=Polish
ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER - Grupa globalna nie może być członkiem grupy uniwersalnej.
.
Language=Romanian
ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER - A universal group cannot have a local group as a member.
.

MessageId=8519
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER
Language=English
ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER - A global group cannot have a cross-domain member.
.
Language=Russian
ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER - A global group cannot have a cross-domain member.
.
Language=Polish
ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER - Członek grupy globalnej nie może pochodzić z innej domeny.
.
Language=Romanian
ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER - A global group cannot have a cross-domain member.
.

MessageId=8520
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER
Language=English
ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER - A local group cannot have another cross-domain local group as a member.
.
Language=Russian
ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER - A local group cannot have another cross-domain local group as a member.
.
Language=Polish
ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER - Członkiem grupy globalnej nie może być grupa lokalna z innej domeny.
.
Language=Romanian
ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER - A local group cannot have another cross-domain local group as a member.
.

MessageId=8521
Severity=Success
Facility=System
SymbolicName=ERROR_DS_HAVE_PRIMARY_MEMBERS
Language=English
ERROR_DS_HAVE_PRIMARY_MEMBERS - A group with primary members cannot change to a security-disabled group.
.
Language=Russian
ERROR_DS_HAVE_PRIMARY_MEMBERS - A group with primary members cannot change to a security-disabled group.
.
Language=Polish
ERROR_DS_HAVE_PRIMARY_MEMBERS - Grupa z członkami głównymi nie może zostać zmieniona w grupę z wyłączonymi zabezpieczeniami.
.
Language=Romanian
ERROR_DS_HAVE_PRIMARY_MEMBERS - A group with primary members cannot change to a security-disabled group.
.

MessageId=8522
Severity=Success
Facility=System
SymbolicName=ERROR_DS_STRING_SD_CONVERSION_FAILED
Language=English
ERROR_DS_STRING_SD_CONVERSION_FAILED - The schema cache load failed to convert the string default SD on a class-schema object.
.
Language=Russian
ERROR_DS_STRING_SD_CONVERSION_FAILED - The schema cache load failed to convert the string default SD on a class-schema object.
.
Language=Polish
ERROR_DS_STRING_SD_CONVERSION_FAILED - Podczas ładowania schematu z pamięci podręcznej nie udało się przekształcić domyślnego SD na obiekt schematu klasy.
.
Language=Romanian
ERROR_DS_STRING_SD_CONVERSION_FAILED - The schema cache load failed to convert the string default SD on a class-schema object.
.

MessageId=8523
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAMING_MASTER_GC
Language=English
ERROR_DS_NAMING_MASTER_GC - Only DSAs configured to be Global Catalog servers should be allowed to hold the Domain Naming Master FSMO role. (Applies only to Windows 2000 servers)
.
Language=Russian
ERROR_DS_NAMING_MASTER_GC - Only DSAs configured to be Global Catalog servers should be allowed to hold the Domain Naming Master FSMO role. (Applies only to Windows 2000 servers)
.
Language=Polish
ERROR_DS_NAMING_MASTER_GC - Tylko serwery DSA skonfigurowane jako serwery wykazu globalnego mogą pełnić rolę wzorca operacji FSMO nazw domen. (Ma zastosowanie tylko dla serwerów systemu Windows 2000)
.
Language=Romanian
ERROR_DS_NAMING_MASTER_GC - Only DSAs configured to be Global Catalog servers should be allowed to hold the Domain Naming Master FSMO role. (Applies only to Windows 2000 servers)
.

MessageId=8524
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOOKUP_FAILURE
Language=English
ERROR_DS_LOOKUP_FAILURE - The DSA operation is unable to proceed because of a DNS lookup failure.
.
Language=Russian
ERROR_DS_LOOKUP_FAILURE - The DSA operation is unable to proceed because of a DNS lookup failure.
.
Language=Polish
ERROR_DS_LOOKUP_FAILURE - Operacja DSA nie może być kontynuowana wskutek błędu wyszukiwania DNS.
.
Language=Romanian
ERROR_DS_LOOKUP_FAILURE - The DSA operation is unable to proceed because of a DNS lookup failure.
.

MessageId=8525
Severity=Success
Facility=System
SymbolicName=ERROR_DS_COULDNT_UPDATE_SPNS
Language=English
ERROR_DS_COULDNT_UPDATE_SPNS - While processing a change to the DNS Host Name for an object, the Service Principal Name values could not be kept in sync.
.
Language=Russian
ERROR_DS_COULDNT_UPDATE_SPNS - While processing a change to the DNS Host Name for an object, the Service Principal Name values could not be kept in sync.
.
Language=Polish
ERROR_DS_COULDNT_UPDATE_SPNS - Podczas przetwarzania zmian nazwy hosta DNS dla danego obiektu, wartości głównej nazwy usługi (SPN) nie zostały zsynchronizowane.
.
Language=Romanian
ERROR_DS_COULDNT_UPDATE_SPNS - While processing a change to the DNS Host Name for an object, the Service Principal Name values could not be kept in sync.
.

MessageId=8526
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_RETRIEVE_SD
Language=English
ERROR_DS_CANT_RETRIEVE_SD - The Security Descriptor attribute could not be read.
.
Language=Russian
ERROR_DS_CANT_RETRIEVE_SD - The Security Descriptor attribute could not be read.
.
Language=Polish
ERROR_DS_CANT_RETRIEVE_SD - Nie można odczytać atrybutu deskryptora zabezpieczeń.
.
Language=Romanian
ERROR_DS_CANT_RETRIEVE_SD - The Security Descriptor attribute could not be read.
.

MessageId=8527
Severity=Success
Facility=System
SymbolicName=ERROR_DS_KEY_NOT_UNIQUE
Language=English
ERROR_DS_KEY_NOT_UNIQUE - The object requested was not found, but an object with that key was found.
.
Language=Russian
ERROR_DS_KEY_NOT_UNIQUE - The object requested was not found, but an object with that key was found.
.
Language=Polish
ERROR_DS_KEY_NOT_UNIQUE - Żądany obiekt nie został znaleziony, ale znaleziono obiekt z tym kluczem.
.
Language=Romanian
ERROR_DS_KEY_NOT_UNIQUE - The object requested was not found, but an object with that key was found.
.

MessageId=8528
Severity=Success
Facility=System
SymbolicName=ERROR_DS_WRONG_LINKED_ATT_SYNTAX
Language=English
ERROR_DS_WRONG_LINKED_ATT_SYNTAX - The syntax of the linked attributed being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1.
.
Language=Russian
ERROR_DS_WRONG_LINKED_ATT_SYNTAX - The syntax of the linked attributed being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1.
.
Language=Polish
ERROR_DS_WRONG_LINKED_ATT_SYNTAX - Składnia dodawanego atrybutu łącza jest niepoprawna. Odsyłacze do przodu mogą mieć składnię tylko 2.5.5.1, 2.5.5.7 i 2.5.5.14, a odsyłacze wsteczne mogą mieć składnię tylko 2.5.5.1.
.
Language=Romanian
ERROR_DS_WRONG_LINKED_ATT_SYNTAX - The syntax of the linked attributed being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1.
.

MessageId=8529
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD
Language=English
ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD - Security Account Manager needs to get the boot password.
.
Language=Russian
ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD - Security Account Manager needs to get the boot password.
.
Language=Polish
ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD - Menedżer kont zabezpieczeń musi uzyskać hasło rozruchowe.
.
Language=Romanian
ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD - Security Account Manager needs to get the boot password.
.

MessageId=8530
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY
Language=English
ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY - Security Account Manager needs to get the boot key from floppy disk.
.
Language=Russian
ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY - Security Account Manager needs to get the boot key from floppy disk.
.
Language=Polish
ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY - Menedżer kont zabezpieczeń musi uzyskać klucz rozruchowy z dyskietki.
.
Language=Romanian
ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY - Security Account Manager needs to get the boot key from floppy disk.
.

MessageId=8531
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_START
Language=English
ERROR_DS_CANT_START - Directory Service cannot start.
.
Language=Russian
ERROR_DS_CANT_START - Directory Service cannot start.
.
Language=Polish
ERROR_DS_CANT_START - Nie można uruchomić usługi katalogowej.
.
Language=Romanian
ERROR_DS_CANT_START - Directory Service cannot start.
.

MessageId=8532
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INIT_FAILURE
Language=English
ERROR_DS_INIT_FAILURE - Directory Services could not start.
.
Language=Russian
ERROR_DS_INIT_FAILURE - Directory Services could not start.
.
Language=Polish
ERROR_DS_INIT_FAILURE - Nie można uruchomić usług katalogowych.
.
Language=Romanian
ERROR_DS_INIT_FAILURE - Directory Services could not start.
.

MessageId=8533
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION
Language=English
ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION - The connection between client and server requires packet privacy or better.
.
Language=Russian
ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION - The connection between client and server requires packet privacy or better.
.
Language=Polish
ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION - Połączenie między klientem i serwerem wymaga zabezpieczeń zapewniających co najmniej prywatność pakietów.
.
Language=Romanian
ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION - The connection between client and server requires packet privacy or better.
.

MessageId=8534
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SOURCE_DOMAIN_IN_FOREST
Language=English
ERROR_DS_SOURCE_DOMAIN_IN_FOREST - The source domain may not be in the same forest as destination.
.
Language=Russian
ERROR_DS_SOURCE_DOMAIN_IN_FOREST - The source domain may not be in the same forest as destination.
.
Language=Polish
ERROR_DS_SOURCE_DOMAIN_IN_FOREST - Domena źródłowa nie może występować w tym samym lesie co docelowa.
.
Language=Romanian
ERROR_DS_SOURCE_DOMAIN_IN_FOREST - The source domain may not be in the same forest as destination.
.

MessageId=8535
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST
Language=English
ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST - The destination domain must be in the forest.
.
Language=Russian
ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST - The destination domain must be in the forest.
.
Language=Polish
ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST - Domena docelowa musi występować w lesie.
.
Language=Romanian
ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST - The destination domain must be in the forest.
.

MessageId=8536
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED
Language=English
ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED - The operation requires that destination domain auditing be enabled.
.
Language=Russian
ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED - The operation requires that destination domain auditing be enabled.
.
Language=Polish
ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED - Operacja wymaga włączenia inspekcji domeny docelowej.
.
Language=Romanian
ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED - The operation requires that destination domain auditing be enabled.
.

MessageId=8537
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN
Language=English
ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN - The operation couldn't locate a DC for the source domain.
.
Language=Russian
ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN - The operation couldn't locate a DC for the source domain.
.
Language=Polish
ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN - Operacja nie może zlokalizować kontrolera domeny dla domeny źródłowej.
.
Language=Romanian
ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN - The operation couldn't locate a DC for the source domain.
.

MessageId=8538
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER
Language=English
ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER - The source object must be a group or user.
.
Language=Russian
ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER - The source object must be a group or user.
.
Language=Polish
ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER - Obiekt źródłowy musi być grupą lub użytkownikiem.
.
Language=Romanian
ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER - The source object must be a group or user.
.

MessageId=8539
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_SID_EXISTS_IN_FOREST
Language=English
ERROR_DS_SRC_SID_EXISTS_IN_FOREST - The source object's SID already exists in destination forest.
.
Language=Russian
ERROR_DS_SRC_SID_EXISTS_IN_FOREST - The source object's SID already exists in destination forest.
.
Language=Polish
ERROR_DS_SRC_SID_EXISTS_IN_FOREST - Identyfikator SID obiektu źródłowego już istnieje w lesie docelowym.
.
Language=Romanian
ERROR_DS_SRC_SID_EXISTS_IN_FOREST - The source object's SID already exists in destination forest.
.

MessageId=8540
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH
Language=English
ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH - The source and destination object must be of the same type.
.
Language=Russian
ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH - The source and destination object must be of the same type.
.
Language=Polish
ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH - Obiekty źródłowy i docelowy muszą być tego samego typu.
.
Language=Romanian
ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH - The source and destination object must be of the same type.
.

MessageId=8541
Severity=Success
Facility=System
SymbolicName=ERROR_SAM_INIT_FAILURE
Language=English
ERROR_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information.
.
Language=Russian
ERROR_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information.
.
Language=Polish
ERROR_SAM_INIT_FAILURE - Nie można zainicjować Menedżera kont zabezpieczeń z powodu następującego błędu: %1.
Stan błędu: 0x%2. Kliknij przycisk OK, aby zamknąć system i uruchomić go w trybie awaryjnym. Szczegółowe informacje można znaleźć w dzienniku zdarzeń.
.
Language=Romanian
ERROR_SAM_INIT_FAILURE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information.
.

MessageId=8542
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SCHEMA_INFO_SHIP
Language=English
ERROR_DS_DRA_SCHEMA_INFO_SHIP - Schema information could not be included in the replication request.
.
Language=Russian
ERROR_DS_DRA_SCHEMA_INFO_SHIP - Schema information could not be included in the replication request.
.
Language=Polish
ERROR_DS_DRA_SCHEMA_INFO_SHIP - Informacje o schemacie nie mogły być zawarte w żądaniu replikacji.
.
Language=Romanian
ERROR_DS_DRA_SCHEMA_INFO_SHIP - Schema information could not be included in the replication request.
.

MessageId=8543
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_SCHEMA_CONFLICT
Language=English
ERROR_DS_DRA_SCHEMA_CONFLICT - The replication operation could not be completed due to a schema incompatibility.
.
Language=Russian
ERROR_DS_DRA_SCHEMA_CONFLICT - The replication operation could not be completed due to a schema incompatibility.
.
Language=Polish
ERROR_DS_DRA_SCHEMA_CONFLICT - Nie można ukończyć operacji replikacji z powodu niezgodności schematów.
.
Language=Romanian
ERROR_DS_DRA_SCHEMA_CONFLICT - The replication operation could not be completed due to a schema incompatibility.
.

MessageId=8544
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT
Language=English
ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT - The replication operation could not be completed due to a previous schema incompatibility.
.
Language=Russian
ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT - The replication operation could not be completed due to a previous schema incompatibility.
.
Language=Polish
ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT - Nie można ukończyć operacji replikacji z powodu poprzedniej niezgodności schematów.
.
Language=Romanian
ERROR_DS_DRA_EARLIER_SCHEMA_CONLICT - The replication operation could not be completed due to a previous schema incompatibility.
.

MessageId=8545
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_OBJ_NC_MISMATCH
Language=English
ERROR_DS_DRA_OBJ_NC_MISMATCH - The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation.
.
Language=Russian
ERROR_DS_DRA_OBJ_NC_MISMATCH - The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation.
.
Language=Polish
ERROR_DS_DRA_OBJ_NC_MISMATCH - Nie można dokonać aktualizacji replikacji, ponieważ miejsce źródłowe lub docelowe nie otrzymało informacji odnośnie ostatniej operacji przenoszenia poza domenę.
.
Language=Romanian
ERROR_DS_DRA_OBJ_NC_MISMATCH - The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation.
.

MessageId=8546
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NC_STILL_HAS_DSAS
Language=English
ERROR_DS_NC_STILL_HAS_DSAS - The requested domain could not be deleted because there exist domain controllers that still host this domain.
.
Language=Russian
ERROR_DS_NC_STILL_HAS_DSAS - The requested domain could not be deleted because there exist domain controllers that still host this domain.
.
Language=Polish
ERROR_DS_NC_STILL_HAS_DSAS - Żądana domena nie mogła być usunięta ponieważ istnieją kontrolery domeny, które nadal są jej hostem.
.
Language=Romanian
ERROR_DS_NC_STILL_HAS_DSAS - The requested domain could not be deleted because there exist domain controllers that still host this domain.
.

MessageId=8547
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GC_REQUIRED
Language=English
ERROR_DS_GC_REQUIRED - The requested operation can be performed only on a global catalog server.
.
Language=Russian
ERROR_DS_GC_REQUIRED - The requested operation can be performed only on a global catalog server.
.
Language=Polish
ERROR_DS_GC_REQUIRED - Żądana operacja może być wykonana tylko na serwerze wykazu globalnego.
.
Language=Romanian
ERROR_DS_GC_REQUIRED - The requested operation can be performed only on a global catalog server.
.

MessageId=8548
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY
Language=English
ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY - A local group can only be a member of other local groups in the same domain.
.
Language=Russian
ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY - A local group can only be a member of other local groups in the same domain.
.
Language=Polish
ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY - Grupa lokalna może być tylko członkiem innej grupy lokalnej w tej samej domenie.
.
Language=Romanian
ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY - A local group can only be a member of other local groups in the same domain.
.

MessageId=8549
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS
Language=English
ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS - Foreign security principals cannot be members of universal groups.
.
Language=Russian
ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS - Foreign security principals cannot be members of universal groups.
.
Language=Polish
ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS - Konta lub grupy kont obcych zasad zabezpieczeń nie mogą być członkami grup uniwersalnych.
.
Language=Romanian
ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS - Foreign security principals cannot be members of universal groups.
.

MessageId=8550
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ADD_TO_GC
Language=English
ERROR_DS_CANT_ADD_TO_GC - The attribute is not allowed to be replicated to the GC because of security reasons.
.
Language=Russian
ERROR_DS_CANT_ADD_TO_GC - The attribute is not allowed to be replicated to the GC because of security reasons.
.
Language=Polish
ERROR_DS_CANT_ADD_TO_GC - Atrybut nie może być replikowany do GC z powodów bezpieczeństwa.
.
Language=Romanian
ERROR_DS_CANT_ADD_TO_GC - The attribute is not allowed to be replicated to the GC because of security reasons.
.

MessageId=8551
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_CHECKPOINT_WITH_PDC
Language=English
ERROR_DS_NO_CHECKPOINT_WITH_PDC - The checkpoint with the PDC could not be taken because there are too many modifications being processed currently.
.
Language=Russian
ERROR_DS_NO_CHECKPOINT_WITH_PDC - The checkpoint with the PDC could not be taken because there are too many modifications being processed currently.
.
Language=Polish
ERROR_DS_NO_CHECKPOINT_WITH_PDC - Nie można przejąć punktu kontrolnego PDC, ponieważ obecnie jest przetwarzanych zbyt wiele modyfikacji.
.
Language=Romanian
ERROR_DS_NO_CHECKPOINT_WITH_PDC - The checkpoint with the PDC could not be taken because there are too many modifications being processed currently.
.

MessageId=8552
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SOURCE_AUDITING_NOT_ENABLED
Language=English
ERROR_DS_SOURCE_AUDITING_NOT_ENABLED - The operation requires that source domain auditing be enabled.
.
Language=Russian
ERROR_DS_SOURCE_AUDITING_NOT_ENABLED - The operation requires that source domain auditing be enabled.
.
Language=Polish
ERROR_DS_SOURCE_AUDITING_NOT_ENABLED - Operacja wymaga włączenia inspekcji domeny źródłowej.
.
Language=Romanian
ERROR_DS_SOURCE_AUDITING_NOT_ENABLED - The operation requires that source domain auditing be enabled.
.

MessageId=8553
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC
Language=English
ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC - Security principal objects can only be created inside domain naming contexts.
.
Language=Russian
ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC - Security principal objects can only be created inside domain naming contexts.
.
Language=Polish
ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC - Obiekty główne zabezpieczeń mogą być tworzone jedynie wewnątrz kontekstów nazewnictwa domen.
.
Language=Romanian
ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC - Security principal objects can only be created inside domain naming contexts.
.

MessageId=8554
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_NAME_FOR_SPN
Language=English
ERROR_DS_INVALID_NAME_FOR_SPN - A Service Principal Name (SPN) could not be constructed because the provided hostname is not in the necessary format.
.
Language=Russian
ERROR_DS_INVALID_NAME_FOR_SPN - A Service Principal Name (SPN) could not be constructed because the provided hostname is not in the necessary format.
.
Language=Polish
ERROR_DS_INVALID_NAME_FOR_SPN - Nie można utworzyć głównej nazwy usługi (SPN), ponieważ podana nazwa hosta ma nieodpowiedni format.
.
Language=Romanian
ERROR_DS_INVALID_NAME_FOR_SPN - A Service Principal Name (SPN) could not be constructed because the provided hostname is not in the necessary format.
.

MessageId=8555
Severity=Success
Facility=System
SymbolicName=ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS
Language=English
ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS - A Filter was passed that uses constructed attributes.
.
Language=Russian
ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS - A Filter was passed that uses constructed attributes.
.
Language=Polish
ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS - Został przekazany filtr, który używa złożonych atrybutów.
.
Language=Romanian
ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS - A Filter was passed that uses constructed attributes.
.

MessageId=8556
Severity=Success
Facility=System
SymbolicName=ERROR_DS_UNICODEPWD_NOT_IN_QUOTES
Language=English
ERROR_DS_UNICODEPWD_NOT_IN_QUOTES - The unicodePwd attribute value must be enclosed in double quotes.
.
Language=Russian
ERROR_DS_UNICODEPWD_NOT_IN_QUOTES - The unicodePwd attribute value must be enclosed in double quotes.
.
Language=Polish
ERROR_DS_UNICODEPWD_NOT_IN_QUOTES - Wartość atrybutu unicodePwd musi być ujęta w cudzysłów.
.
Language=Romanian
ERROR_DS_UNICODEPWD_NOT_IN_QUOTES - The unicodePwd attribute value must be enclosed in double quotes.
.

MessageId=8557
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED
Language=English
ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED - Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased.
.
Language=Russian
ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED - Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased.
.
Language=Polish
ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED - Nie można dołączyć komputera do domeny. Została przekroczona maksymalna liczba kont, które możesz utworzyć w tej domenie. Skontaktuj się z administratorem systemu, aby ten limit zresetować lub zwiększyć.
.
Language=Romanian
ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED - Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased.
.

MessageId=8558
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MUST_BE_RUN_ON_DST_DC
Language=English
ERROR_DS_MUST_BE_RUN_ON_DST_DC - For security reasons, the operation must be run on the destination DC.
.
Language=Russian
ERROR_DS_MUST_BE_RUN_ON_DST_DC - For security reasons, the operation must be run on the destination DC.
.
Language=Polish
ERROR_DS_MUST_BE_RUN_ON_DST_DC - Aby zapewnić bezpieczeństwo, operacja musi być przeprowadzona na docelowym kontrolerze domeny.
.
Language=Romanian
ERROR_DS_MUST_BE_RUN_ON_DST_DC - For security reasons, the operation must be run on the destination DC.
.

MessageId=8559
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER
Language=English
ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER - For security reasons, the source DC must be NT4SP4 or greater.
.
Language=Russian
ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER - For security reasons, the source DC must be NT4SP4 or greater.
.
Language=Polish
ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER - Aby zapewnić bezpieczeństwo, źródłowy kontroler domeny musi pochodzić z dodatku NT4SP4 lub wyższego.
.
Language=Romanian
ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER - For security reasons, the source DC must be NT4SP4 or greater.
.

MessageId=8560
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ
Language=English
ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ - Critical Directory Service System objects cannot be deleted during tree delete operations. The tree delete may have been partially performed.
.
Language=Russian
ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ - Critical Directory Service System objects cannot be deleted during tree delete operations. The tree delete may have been partially performed.
.
Language=Polish
ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ - Nie można usunąć kluczowych obiektów usługi katalogowej podczas operacji usuwania drzewa. Być może drzewo zostało usunięte częściowo.
.
Language=Romanian
ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ - Critical Directory Service System objects cannot be deleted during tree delete operations. The tree delete may have been partially performed.
.

MessageId=8561
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INIT_FAILURE_CONSOLE
Language=English
ERROR_DS_INIT_FAILURE_CONSOLE - Directory Services could not start because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.
Language=Russian
ERROR_DS_INIT_FAILURE_CONSOLE - Directory Services could not start because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.
Language=Polish
ERROR_DS_INIT_FAILURE_CONSOLE - Nie można uruchomić usług katalogowych z powodu następującego błędu: %1.
Stan błędu: 0x%2. Kliknij przycisk OK, aby zamknąć system. Możesz użyć konsoli odzyskiwania do diagnozy systemu.
.
Language=Romanian
ERROR_DS_INIT_FAILURE_CONSOLE - Directory Services could not start because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.

MessageId=8562
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SAM_INIT_FAILURE_CONSOLE
Language=English
ERROR_DS_SAM_INIT_FAILURE_CONSOLE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.
Language=Russian
ERROR_DS_SAM_INIT_FAILURE_CONSOLE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.
Language=Polish
ERROR_DS_SAM_INIT_FAILURE_CONSOLE - Zainicjowanie Menedżera kont zabezpieczeń nie powiodło się z powodu następującego błędu: %1.
Stan błędu: 0x%2. Kliknij przycisk OK, aby zamknąć system. Możesz użyć konsoli odzyskiwania do diagnozy systemu.
.
Language=Romanian
ERROR_DS_SAM_INIT_FAILURE_CONSOLE - Security Accounts Manager initialization failed because of the following error: %1.
Error Status: 0x%2. Please click OK to shutdown the system. You can use the recovery console to diagnose the system further.
.

MessageId=8563
Severity=Success
Facility=System
SymbolicName=ERROR_DS_FOREST_VERSION_TOO_HIGH
Language=English
ERROR_DS_FOREST_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current forest functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this forest.
.
Language=Russian
ERROR_DS_FOREST_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current forest functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this forest.
.
Language=Polish
ERROR_DS_FOREST_VERSION_TOO_HIGH - Wersja zainstalowanego systemu operacyjnego jest niezgodna z bieżącym poziomem funkcjonalności lasu. Aby ten serwer mógł stać się kontrolerem domeny w tym lesie, trzeba uaktualnić system operacyjny do nowszej wersji.
.
Language=Romanian
ERROR_DS_FOREST_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current forest functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this forest.
.

MessageId=8564
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DOMAIN_VERSION_TOO_HIGH
Language=English
ERROR_DS_DOMAIN_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain.
.
Language=Russian
ERROR_DS_DOMAIN_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain.
.
Language=Polish
ERROR_DS_DOMAIN_VERSION_TOO_HIGH - Wersja zainstalowanego systemu operacyjnego jest niezgodna z bieżącym poziomem funkcjonalności domeny. Aby ten serwer mógł stać się kontrolerem domeny w tym lesie, trzeba uaktualnić system operacyjny do nowszej wersji.
.
Language=Romanian
ERROR_DS_DOMAIN_VERSION_TOO_HIGH - The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain.
.

MessageId=8565
Severity=Success
Facility=System
SymbolicName=ERROR_DS_FOREST_VERSION_TOO_LOW
Language=English
ERROR_DS_FOREST_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current forest functional level. You must raise the forest functional level before this server can become a domain controller in this forest.
.
Language=Russian
ERROR_DS_FOREST_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current forest functional level. You must raise the forest functional level before this server can become a domain controller in this forest.
.
Language=Polish
ERROR_DS_FOREST_VERSION_TOO_LOW - Wersja systemu operacyjnego zainstalowana na tym serwerze nie obsługuje już bieżącego poziomu funkcjonalności lasu. Aby ten serwer mógł stać się kontrolerem domeny w tym lesie, trzeba zwiększyć poziom funkcjonalności lasu.
.
Language=Romanian
ERROR_DS_FOREST_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current forest functional level. You must raise the forest functional level before this server can become a domain controller in this forest.
.

MessageId=8566
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DOMAIN_VERSION_TOO_LOW
Language=English
ERROR_DS_DOMAIN_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain.
.
Language=Russian
ERROR_DS_DOMAIN_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain.
.
Language=Polish
ERROR_DS_DOMAIN_VERSION_TOO_LOW - Wersja systemu operacyjnego zainstalowana na tym serwerze nie obsługuje już bieżącego poziomu funkcjonalności domeny. Aby ten serwer mógł stać się kontrolerem domeny w tym lesie, trzeba zwiększyć poziom funkcjonalności domeny.
.
Language=Romanian
ERROR_DS_DOMAIN_VERSION_TOO_LOW - This version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain.
.

MessageId=8567
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INCOMPATIBLE_VERSION
Language=English
ERROR_DS_INCOMPATIBLE_VERSION - The version of the operating system installed on this server is incompatible with the functional level of the domain or forest.
.
Language=Russian
ERROR_DS_INCOMPATIBLE_VERSION - The version of the operating system installed on this server is incompatible with the functional level of the domain or forest.
.
Language=Polish
ERROR_DS_INCOMPATIBLE_VERSION - Wersja zainstalowanego systemu operacyjnego na tym serwerze jest niezgodna z poziomem funkcjonalności domeny lub lasu
.
Language=Romanian
ERROR_DS_INCOMPATIBLE_VERSION - The version of the operating system installed on this server is incompatible with the functional level of the domain or forest.
.

MessageId=8568
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LOW_DSA_VERSION
Language=English
ERROR_DS_LOW_DSA_VERSION - The functional level of the domain (or forest) cannot be raised to the requested value, because there exist one or more domain controllers in the domain (or forest) that are at a lower incompatible functional level.
.
Language=Russian
ERROR_DS_LOW_DSA_VERSION - The functional level of the domain (or forest) cannot be raised to the requested value, because there exist one or more domain controllers in the domain (or forest) that are at a lower incompatible functional level.
.
Language=Polish
ERROR_DS_LOW_DSA_VERSION - Poziomu funkcjonalności domeny (lub lasu) nie można zwiększyć do żądanej wartości, ponieważ w domenie (lub lesie) istnieje co najmniej jeden kontroler domeny z niższym niezgodnym poziomem funkcjonalności.
.
Language=Romanian
ERROR_DS_LOW_DSA_VERSION - The functional level of the domain (or forest) cannot be raised to the requested value, because there exist one or more domain controllers in the domain (or forest) that are at a lower incompatible functional level.
.

MessageId=8569
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN
Language=English
ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN - The forest functional level cannot be raised to the requested level since one or more domains are still in mixed domain mode. All domains in the forest must be in native mode before you can raise the forest functional level.
.
Language=Russian
ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN - The forest functional level cannot be raised to the requested level since one or more domains are still in mixed domain mode. All domains in the forest must be in native mode before you can raise the forest functional level.
.
Language=Polish
ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN - Poziomu funkcjonalności lasu nie można zwiększyć do żądanej wartości, ponieważ co najmniej jedna domena jest nadal w trybie domeny mieszanej. Przed zwiększeniem poziomu funkcjonalności lasu wszystkie domeny w lesie muszą być w trybie macierzystym.
.
Language=Romanian
ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN - The forest functional level cannot be raised to the requested level since one or more domains are still in mixed domain mode. All domains in the forest must be in native mode before you can raise the forest functional level.
.

MessageId=8570
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_SUPPORTED_SORT_ORDER
Language=English
ERROR_DS_NOT_SUPPORTED_SORT_ORDER - The sort order requested is not supported.
.
Language=Russian
ERROR_DS_NOT_SUPPORTED_SORT_ORDER - The sort order requested is not supported.
.
Language=Polish
ERROR_DS_NOT_SUPPORTED_SORT_ORDER - Żądana kolejność sortowania nie jest obsługiwana.
.
Language=Romanian
ERROR_DS_NOT_SUPPORTED_SORT_ORDER - The sort order requested is not supported.
.

MessageId=8571
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_NOT_UNIQUE
Language=English
ERROR_DS_NAME_NOT_UNIQUE - The requested name already exists as a unique identifier.
.
Language=Russian
ERROR_DS_NAME_NOT_UNIQUE - The requested name already exists as a unique identifier.
.
Language=Polish
ERROR_DS_NAME_NOT_UNIQUE - Żądana nazwa już istnieje, jako unikatowy identyfikator.
.
Language=Romanian
ERROR_DS_NAME_NOT_UNIQUE - The requested name already exists as a unique identifier.
.

MessageId=8572
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4
Language=English
ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 - The machine account was created pre-NT4. The account needs to be recreated.
.
Language=Russian
ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 - The machine account was created pre-NT4. The account needs to be recreated.
.
Language=Polish
ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 - Konto komputera zostało utworzone przed systemem NT4. Konto musi być utworzone ponownie.
.
Language=Romanian
ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 - The machine account was created pre-NT4. The account needs to be recreated.
.

MessageId=8573
Severity=Success
Facility=System
SymbolicName=ERROR_DS_OUT_OF_VERSION_STORE
Language=English
ERROR_DS_OUT_OF_VERSION_STORE - The database is out of version store.
.
Language=Russian
ERROR_DS_OUT_OF_VERSION_STORE - The database is out of version store.
.
Language=Polish
ERROR_DS_OUT_OF_VERSION_STORE - Baza danych działa bez magazynu wersji.
.
Language=Romanian
ERROR_DS_OUT_OF_VERSION_STORE - The database is out of version store.
.

MessageId=8574
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INCOMPATIBLE_CONTROLS_USED
Language=English
ERROR_DS_INCOMPATIBLE_CONTROLS_USED - Unable to continue operation because multiple conflicting controls were used.
.
Language=Russian
ERROR_DS_INCOMPATIBLE_CONTROLS_USED - Unable to continue operation because multiple conflicting controls were used.
.
Language=Polish
ERROR_DS_INCOMPATIBLE_CONTROLS_USED - Nie można kontynuować operacji, ponieważ użyto wielu konfliktowych elementów sterujących.
.
Language=Romanian
ERROR_DS_INCOMPATIBLE_CONTROLS_USED - Unable to continue operation because multiple conflicting controls were used.
.

MessageId=8575
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_REF_DOMAIN
Language=English
ERROR_DS_NO_REF_DOMAIN - Unable to find a valid security descriptor reference domain for this partition.
.
Language=Russian
ERROR_DS_NO_REF_DOMAIN - Unable to find a valid security descriptor reference domain for this partition.
.
Language=Polish
ERROR_DS_NO_REF_DOMAIN - Nie można odnaleźć prawidłowej domeny odniesienia deskryptora zabezpieczeń dla tej partycji.
.
Language=Romanian
ERROR_DS_NO_REF_DOMAIN - Unable to find a valid security descriptor reference domain for this partition.
.

MessageId=8576
Severity=Success
Facility=System
SymbolicName=ERROR_DS_RESERVED_LINK_ID
Language=English
ERROR_DS_RESERVED_LINK_ID - Schema update failed: The link identifier is reserved.
.
Language=Russian
ERROR_DS_RESERVED_LINK_ID - Schema update failed: The link identifier is reserved.
.
Language=Polish
ERROR_DS_RESERVED_LINK_ID - Nie można zaktualizować schematu: identyfikator łącza jest zarezerwowany.
.
Language=Romanian
ERROR_DS_RESERVED_LINK_ID - Schema update failed: The link identifier is reserved.
.

MessageId=8577
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LINK_ID_NOT_AVAILABLE
Language=English
ERROR_DS_LINK_ID_NOT_AVAILABLE - Schema update failed: There are no link identifiers available.
.
Language=Russian
ERROR_DS_LINK_ID_NOT_AVAILABLE - Schema update failed: There are no link identifiers available.
.
Language=Polish
ERROR_DS_LINK_ID_NOT_AVAILABLE - Nie można zaktualizować schematu: brak dostępnych identyfikatorów łącza.
.
Language=Romanian
ERROR_DS_LINK_ID_NOT_AVAILABLE - Schema update failed: There are no link identifiers available.
.

MessageId=8578
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER
Language=English
ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER - An account group cannot have a universal group as a member.
.
Language=Russian
ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER - An account group cannot have a universal group as a member.
.
Language=Polish
ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER - Grupa uniwersalna nie może być członkiem grupy kont.
.
Language=Romanian
ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER - An account group cannot have a universal group as a member.
.

MessageId=8579
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE
Language=English
ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE - Rename or move operations on naming context heads or read-only objects are not allowed.
.
Language=Russian
ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE - Rename or move operations on naming context heads or read-only objects are not allowed.
.
Language=Polish
ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE - Operacje zmiany nazwy i przenoszenia dla początków kontekstu nazewnictwa i obiektów tylko do odczytu są niedozwolone.
.
Language=Romanian
ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE - Rename or move operations on naming context heads or read-only objects are not allowed.
.

MessageId=8580
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC
Language=English
ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC - Move operations on objects in the schema naming context are not allowed.
.
Language=Russian
ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC - Move operations on objects in the schema naming context are not allowed.
.
Language=Polish
ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC - Operacje przenoszenia obiektów w kontekście nazewnictwa schematu są niedozwolone.
.
Language=Romanian
ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC - Move operations on objects in the schema naming context are not allowed.
.

MessageId=8581
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG
Language=English
ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG - A system flag has been set on the object and does not allow the object to be moved or renamed.
.
Language=Russian
ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG - A system flag has been set on the object and does not allow the object to be moved or renamed.
.
Language=Polish
ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG - Dla obiektu ustawiono flagę systemową, która nie pozwala na przeniesienie obiektu ani zmianę jego nazwy.
.
Language=Romanian
ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG - A system flag has been set on the object and does not allow the object to be moved or renamed.
.

MessageId=8582
Severity=Success
Facility=System
SymbolicName=ERROR_DS_MODIFYDN_WRONG_GRANDPARENT
Language=English
ERROR_DS_MODIFYDN_WRONG_GRANDPARENT - This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers.
.
Language=Russian
ERROR_DS_MODIFYDN_WRONG_GRANDPARENT - This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers.
.
Language=Polish
ERROR_DS_MODIFYDN_WRONG_GRANDPARENT - Dla tego obiektu nie jest dozwolona zmiana jego kontenera nadrzędnego. Przenoszenie tego obiektu nie jest zabronione, ale jest ograniczone do kontenerów tego samego poziomu.
.
Language=Romanian
ERROR_DS_MODIFYDN_WRONG_GRANDPARENT - This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers.
.

MessageId=8583
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NAME_ERROR_TRUST_REFERRAL
Language=English
ERROR_DS_NAME_ERROR_TRUST_REFERRAL - Unable to resolve completely, a referral to another forest is generated.
.
Language=Russian
ERROR_DS_NAME_ERROR_TRUST_REFERRAL - Unable to resolve completely, a referral to another forest is generated.
.
Language=Polish
ERROR_DS_NAME_ERROR_TRUST_REFERRAL - Nie można w pełni rozpoznać; generowane jest odwołanie do innego lasu.
.
Language=Romanian
ERROR_DS_NAME_ERROR_TRUST_REFERRAL - Unable to resolve completely, a referral to another forest is generated.
.

MessageId=8584
Severity=Success
Facility=System
SymbolicName=ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER
Language=English
ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER - The requested action is not supported on standard server.
.
Language=Russian
ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER - The requested action is not supported on standard server.
.
Language=Polish
ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER - Żądana akcja nie jest obsługiwana na serwerze standardowym.
.
Language=Romanian
ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER - The requested action is not supported on standard server.
.

MessageId=8585
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD
Language=English
ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD - Could not access a partition of the Active Directory located on a remote server. Make sure at least one server is running for the partition in question.
.
Language=Russian
ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD - Could not access a partition of the Active Directory located on a remote server. Make sure at least one server is running for the partition in question.
.
Language=Polish
ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD - Nie można uzyskać dostępu do partycji usługi katalogowej znajdującej się na serwerze zdalnym. Upewnij się, że dla danej partycji jest uruchomiony przynajmniej jeden serwer.
.
Language=Romanian
ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD - Could not access a partition of the Active Directory located on a remote server. Make sure at least one server is running for the partition in question.
.

MessageId=8586
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2
Language=English
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 - The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica nor can it contact a replica of the naming context above the proposed naming context. Please ensure that the parent naming context is properly registered in DNS, and at least one replica of this naming context is reachable by the Domain Naming master.
.
Language=Russian
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 - The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica nor can it contact a replica of the naming context above the proposed naming context. Please ensure that the parent naming context is properly registered in DNS, and at least one replica of this naming context is reachable by the Domain Naming master.
.
Language=Polish
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 - Katalog nie może sprawdzić poprawności proponowanej nazwy kontekstu nazewnictwa (lub partycji), ponieważ nie przechowuje on repliki ani nie może skontaktować się z repliką kontekstu nazewnictwa ponad proponowanym kontekstem nazewnictwa. Upewnij się, że nadrzędny kontekst nazewnictwa jest poprawnie zarejestrowany w systemie DNS i przynajmniej jedna replika tego kontekstu nazewnictwa jest osiągalna dla wzorca nazw domen.
.
Language=Romanian
ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 - The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica nor can it contact a replica of the naming context above the proposed naming context. Please ensure that the parent naming context is properly registered in DNS, and at least one replica of this naming context is reachable by the Domain Naming master.
.

MessageId=8587
Severity=Success
Facility=System
SymbolicName=ERROR_DS_THREAD_LIMIT_EXCEEDED
Language=English
ERROR_DS_THREAD_LIMIT_EXCEEDED - The thread limit for this request was exceeded.
.
Language=Russian
ERROR_DS_THREAD_LIMIT_EXCEEDED - The thread limit for this request was exceeded.
.
Language=Polish
ERROR_DS_THREAD_LIMIT_EXCEEDED - Przekroczono limit wątków dla tego żądania.
.
Language=Romanian
ERROR_DS_THREAD_LIMIT_EXCEEDED - The thread limit for this request was exceeded.
.

MessageId=8588
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NOT_CLOSEST
Language=English
ERROR_DS_NOT_CLOSEST - The Global catalog server is not in the closet site.
.
Language=Russian
ERROR_DS_NOT_CLOSEST - The Global catalog server is not in the closet site.
.
Language=Polish
ERROR_DS_NOT_CLOSEST - Serwer wykazu globalnego nie znajduje się w najbliższej witrynie.
.
Language=Romanian
ERROR_DS_NOT_CLOSEST - The Global catalog server is not in the closet site.
.

MessageId=8589
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF
Language=English
ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the corresponding server object in the local DS database has no serverReference attribute.
.
Language=Russian
ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the corresponding server object in the local DS database has no serverReference attribute.
.
Language=Polish
ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF - Usługa katalogowa nie może uzyskać głównej nazwy usługi (SPN) używanej z serwerem docelowym do wzajemnego uwierzytelniania, ponieważ odpowiedni obiekt serwera w lokalnej bazie danych usługi katalogowej nie ma atrybutu serverReference.
.
Language=Romanian
ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the corresponding server object in the local DS database has no serverReference attribute.
.

MessageId=8590
Severity=Success
Facility=System
SymbolicName=ERROR_DS_SINGLE_USER_MODE_FAILED
Language=English
ERROR_DS_SINGLE_USER_MODE_FAILED - The Directory Service failed to enter single user mode.
.
Language=Russian
ERROR_DS_SINGLE_USER_MODE_FAILED - The Directory Service failed to enter single user mode.
.
Language=Polish
ERROR_DS_SINGLE_USER_MODE_FAILED - Nie można przełączyć usługi katalogowej do trybu jednego użytkownika.
.
Language=Romanian
ERROR_DS_SINGLE_USER_MODE_FAILED - The Directory Service failed to enter single user mode.
.

MessageId=8591
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NTDSCRIPT_SYNTAX_ERROR
Language=English
ERROR_DS_NTDSCRIPT_SYNTAX_ERROR - The Directory Service cannot parse the script because of a syntax error.
.
Language=Russian
ERROR_DS_NTDSCRIPT_SYNTAX_ERROR - The Directory Service cannot parse the script because of a syntax error.
.
Language=Polish
ERROR_DS_NTDSCRIPT_SYNTAX_ERROR - Usługa katalogowa nie może zanalizować skryptu z powodu błędu składniowego.
.
Language=Romanian
ERROR_DS_NTDSCRIPT_SYNTAX_ERROR - The Directory Service cannot parse the script because of a syntax error.
.

MessageId=8592
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NTDSCRIPT_PROCESS_ERROR
Language=English
ERROR_DS_NTDSCRIPT_PROCESS_ERROR - The Directory Service cannot process the script because of an error.
.
Language=Russian
ERROR_DS_NTDSCRIPT_PROCESS_ERROR - The Directory Service cannot process the script because of an error.
.
Language=Polish
ERROR_DS_NTDSCRIPT_PROCESS_ERROR - Usługa katalogowa nie może przetworzyć skryptu z powodu błędu.
.
Language=Romanian
ERROR_DS_NTDSCRIPT_PROCESS_ERROR - The Directory Service cannot process the script because of an error.
.

MessageId=8593
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DIFFERENT_REPL_EPOCHS
Language=English
ERROR_DS_DIFFERENT_REPL_EPOCHS - The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress).
.
Language=Russian
ERROR_DS_DIFFERENT_REPL_EPOCHS - The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress).
.
Language=Polish
ERROR_DS_DIFFERENT_REPL_EPOCHS - Usługa katalogowa nie może wykonać żądanej operacji, ponieważ serwery, których ona dotyczy, należą do różnych epok replikacji (zwykle wiąże się to z trwającą operacją zmiany nazwy domeny).
.
Language=Romanian
ERROR_DS_DIFFERENT_REPL_EPOCHS - The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress).
.

MessageId=8594
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRS_EXTENSIONS_CHANGED
Language=English
ERROR_DS_DRS_EXTENSIONS_CHANGED - The directory service binding must be renegotiated due to a change in the server extensions information.
.
Language=Russian
ERROR_DS_DRS_EXTENSIONS_CHANGED - The directory service binding must be renegotiated due to a change in the server extensions information.
.
Language=Polish
ERROR_DS_DRS_EXTENSIONS_CHANGED - Powiązanie usługi katalogowej musi być ponownie negocjowane z powodu zmiany informacji o rozszerzeniach serwera.
.
Language=Romanian
ERROR_DS_DRS_EXTENSIONS_CHANGED - The directory service binding must be renegotiated due to a change in the server extensions information.
.

MessageId=8595
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR
Language=English
ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR - Operation not allowed on a disabled cross ref.
.
Language=Russian
ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR - Operation not allowed on a disabled cross ref.
.
Language=Polish
ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR - Operacja niedozwolona dla wyłączonego odwołania krzyżowego.
.
Language=Romanian
ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR - Operation not allowed on a disabled cross ref.
.

MessageId=8596
Severity=Success
Facility=System
SymbolicName=ERROR_DS_NO_MSDS_INTID
Language=English
ERROR_DS_NO_MSDS_INTID - Schema update failed: No values for msDS-IntId are available.
.
Language=Russian
ERROR_DS_NO_MSDS_INTID - Schema update failed: No values for msDS-IntId are available.
.
Language=Polish
ERROR_DS_NO_MSDS_INTID - Nie można zaktualizować schematu: brak dostępnych wartości dla identyfikatora msDS-IntId.
.
Language=Romanian
ERROR_DS_NO_MSDS_INTID - Schema update failed: No values for msDS-IntId are available.
.

MessageId=8597
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUP_MSDS_INTID
Language=English
ERROR_DS_DUP_MSDS_INTID - Schema update failed: Duplicate msDS-IntId. Retry the operation.
.
Language=Russian
ERROR_DS_DUP_MSDS_INTID - Schema update failed: Duplicate msDS-IntId. Retry the operation.
.
Language=Polish
ERROR_DS_DUP_MSDS_INTID - Nie można zaktualizować schematu: zduplikowany identyfikator msDS-INtId. Ponów próbę wykonania operacji.
.
Language=Romanian
ERROR_DS_DUP_MSDS_INTID - Schema update failed: Duplicate msDS-IntId. Retry the operation.
.

MessageId=8598
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTS_IN_RDNATTID
Language=English
ERROR_DS_EXISTS_IN_RDNATTID - Schema deletion failed: attribute is used in rDNAttID.
.
Language=Russian
ERROR_DS_EXISTS_IN_RDNATTID - Schema deletion failed: attribute is used in rDNAttID.
.
Language=Polish
ERROR_DS_EXISTS_IN_RDNATTID - Usunięcie schematu nie powiodło się: atrybut jest używany w parametrze rDNAttID.
.
Language=Romanian
ERROR_DS_EXISTS_IN_RDNATTID - Schema deletion failed: attribute is used in rDNAttID.
.

MessageId=8599
Severity=Success
Facility=System
SymbolicName=ERROR_DS_AUTHORIZATION_FAILED
Language=English
ERROR_DS_AUTHORIZATION_FAILED - The directory service failed to authorize the request.
.
Language=Russian
ERROR_DS_AUTHORIZATION_FAILED - The directory service failed to authorize the request.
.
Language=Polish
ERROR_DS_AUTHORIZATION_FAILED - Usługa katalogowa nie może autoryzować żądania.
.
Language=Romanian
ERROR_DS_AUTHORIZATION_FAILED - The directory service failed to authorize the request.
.

MessageId=8600
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INVALID_SCRIPT
Language=English
ERROR_DS_INVALID_SCRIPT - The Directory Service cannot process the script because it is invalid.
.
Language=Russian
ERROR_DS_INVALID_SCRIPT - The Directory Service cannot process the script because it is invalid.
.
Language=Polish
ERROR_DS_INVALID_SCRIPT - Usługa katalogowa nie może przetworzyć skryptu, ponieważ jest on nieprawidłowy.
.
Language=Romanian
ERROR_DS_INVALID_SCRIPT - The Directory Service cannot process the script because it is invalid.
.

MessageId=8601
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REMOTE_CROSSREF_OP_FAILED
Language=English
ERROR_DS_REMOTE_CROSSREF_OP_FAILED - The remote create cross reference operation failed on the Domain Naming Master FSMO. The operation's error is in the extended data.
.
Language=Russian
ERROR_DS_REMOTE_CROSSREF_OP_FAILED - The remote create cross reference operation failed on the Domain Naming Master FSMO. The operation's error is in the extended data.
.
Language=Polish
ERROR_DS_REMOTE_CROSSREF_OP_FAILED - Operacja zdalnego utworzenia odwołania krzyżowego nie powiodła się dla operacji FSMO wzorca nazw domen. Błąd operacji występuje w danych rozszerzonych.
.
Language=Romanian
ERROR_DS_REMOTE_CROSSREF_OP_FAILED - The remote create cross reference operation failed on the Domain Naming Master FSMO. The operation's error is in the extended data.
.

MessageId=8602
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CROSS_REF_BUSY
Language=English
ERROR_DS_CROSS_REF_BUSY - A cross reference is in use locally with the same name.
.
Language=Russian
ERROR_DS_CROSS_REF_BUSY - A cross reference is in use locally with the same name.
.
Language=Polish
ERROR_DS_CROSS_REF_BUSY - Odsyłacz jest używany lokalnie z tą samą nazwą.
.
Language=Romanian
ERROR_DS_CROSS_REF_BUSY - A cross reference is in use locally with the same name.
.

MessageId=8603
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN
Language=English
ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the server's domain has been deleted from the forest.
.
Language=Russian
ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the server's domain has been deleted from the forest.
.
Language=Polish
ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN - Usługa katalogowa nie może uzyskać głównej nazwy usługi (SPN) używanej z serwerem docelowym do wzajemnego uwierzytelniania, ponieważ domena serwera została usunięta z lasu.
.
Language=Romanian
ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN - The DS cannot derive a service principal name (SPN) with which to mutually authenticate the target server because the server's domain has been deleted from the forest.
.

MessageId=8604
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC
Language=English
ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC - Writeable NCs prevent this DC from demoting.
.
Language=Russian
ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC - Writeable NCs prevent this DC from demoting.
.
Language=Polish
ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC - Zapisywalne klastry węzłów nie pozwalają na obniżenie poziomu tego kontrolera domeny.
.
Language=Romanian
ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC - Writeable NCs prevent this DC from demoting.
.

MessageId=8605
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DUPLICATE_ID_FOUND
Language=English
ERROR_DS_DUPLICATE_ID_FOUND - The requested object has a non-unique identifier and cannot be retrieved.
.
Language=Russian
ERROR_DS_DUPLICATE_ID_FOUND - The requested object has a non-unique identifier and cannot be retrieved.
.
Language=Polish
ERROR_DS_DUPLICATE_ID_FOUND - Żądany obiekt ma identyfikator, który nie jest unikatowy, i nie można go pobrać.
.
Language=Romanian
ERROR_DS_DUPLICATE_ID_FOUND - The requested object has a non-unique identifier and cannot be retrieved.
.

MessageId=8606
Severity=Success
Facility=System
SymbolicName=ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT
Language=English
ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT - Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and already garbage collected.
.
Language=Russian
ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT - Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and already garbage collected.
.
Language=Polish
ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT - Nadano atrybuty, które nie wystarczają do utworzenia obiektu. Ten obiekt może nie istnieć, ponieważ mógł zostać usunięty i wyrzucony jako element bezużyteczny.
.
Language=Romanian
ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT - Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and already garbage collected.
.

MessageId=8607
Severity=Success
Facility=System
SymbolicName=ERROR_DS_GROUP_CONVERSION_ERROR
Language=English
ERROR_DS_GROUP_CONVERSION_ERROR - The group cannot be converted due to attribute restrictions on the requested group type.
.
Language=Russian
ERROR_DS_GROUP_CONVERSION_ERROR - The group cannot be converted due to attribute restrictions on the requested group type.
.
Language=Polish
ERROR_DS_GROUP_CONVERSION_ERROR - Nie można konwertować grupy z powodu ograniczeń atrybutów w żądanym typie grupy.
.
Language=Romanian
ERROR_DS_GROUP_CONVERSION_ERROR - The group cannot be converted due to attribute restrictions on the requested group type.
.

MessageId=8608
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOVE_APP_BASIC_GROUP
Language=English
ERROR_DS_CANT_MOVE_APP_BASIC_GROUP - Cross-domain move of non-empty basic application groups is not allowed.
.
Language=Russian
ERROR_DS_CANT_MOVE_APP_BASIC_GROUP - Cross-domain move of non-empty basic application groups is not allowed.
.
Language=Polish
ERROR_DS_CANT_MOVE_APP_BASIC_GROUP - Przeniesienie poza domenę niepustych grup podstawowych aplikacji jest niedozwolone.
.
Language=Romanian
ERROR_DS_CANT_MOVE_APP_BASIC_GROUP - Cross-domain move of non-empty basic application groups is not allowed.
.

MessageId=8609
Severity=Success
Facility=System
SymbolicName=ERROR_DS_CANT_MOVE_APP_QUERY_GROUP
Language=English
ERROR_DS_CANT_MOVE_APP_QUERY_GROUP - Cross-domain move on non-empty query based application groups is not allowed.
.
Language=Russian
ERROR_DS_CANT_MOVE_APP_QUERY_GROUP - Cross-domain move on non-empty query based application groups is not allowed.
.
Language=Polish
ERROR_DS_CANT_MOVE_APP_QUERY_GROUP - Przeniesienie poza domenę niepustych grup podstawowych aplikacji opartych na zapytaniach jest niedozwolone.
.
Language=Romanian
ERROR_DS_CANT_MOVE_APP_QUERY_GROUP - Cross-domain move on non-empty query based application groups is not allowed.
.

MessageId=8610
Severity=Success
Facility=System
SymbolicName=ERROR_DS_ROLE_NOT_VERIFIED
Language=English
ERROR_DS_ROLE_NOT_VERIFIED - The role owner could not be verified because replication of its partition has not occurred recently.
.
Language=Russian
ERROR_DS_ROLE_NOT_VERIFIED - The role owner could not be verified because replication of its partition has not occurred recently.
.
Language=Polish
ERROR_DS_ROLE_NOT_VERIFIED - Nie można zweryfikować własności roli FSMO, ponieważ jej partycja katalogu nie replikowała pomyślnie z co najmniej jednym partnerem replikacji.
.
Language=Romanian
ERROR_DS_ROLE_NOT_VERIFIED - The role owner could not be verified because replication of its partition has not occurred recently.
.

MessageId=8611
Severity=Success
Facility=System
SymbolicName=ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL
Language=English
ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL - The target container for a redirection of a well-known object container cannot already be a special container.
.
Language=Russian
ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL - The target container for a redirection of a well-known object container cannot already be a special container.
.
Language=Polish
ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL - Kontener docelowy przekierowania dobrze znanych obiektów nie może już być kontenerem specjalnym.
.
Language=Romanian
ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL - The target container for a redirection of a well-known object container cannot already be a special container.
.

MessageId=8612
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DOMAIN_RENAME_IN_PROGRESS
Language=English
ERROR_DS_DOMAIN_RENAME_IN_PROGRESS - The Directory Service cannot perform the requested operation because a domain rename operation is in progress.
.
Language=Russian
ERROR_DS_DOMAIN_RENAME_IN_PROGRESS - The Directory Service cannot perform the requested operation because a domain rename operation is in progress.
.
Language=Polish
ERROR_DS_DOMAIN_RENAME_IN_PROGRESS - Usługa katalogowa nie może wykonać żądanej operacji, ponieważ trwa operacja zmiany nazwy domeny.
.
Language=Romanian
ERROR_DS_DOMAIN_RENAME_IN_PROGRESS - The Directory Service cannot perform the requested operation because a domain rename operation is in progress.
.

MessageId=8613
Severity=Success
Facility=System
SymbolicName=ERROR_DS_EXISTING_AD_CHILD_NC
Language=English
ERROR_DS_EXISTING_AD_CHILD_NC - The Active Directory detected an Active Directory child partition below the requested new partition name. The Active Directory's partition hierarchy must be created in a top-down method.
.
Language=Russian
ERROR_DS_EXISTING_AD_CHILD_NC - The Active Directory detected an Active Directory child partition below the requested new partition name. The Active Directory's partition hierarchy must be created in a top-down method.
.
Language=Polish
ERROR_DS_EXISTING_AD_CHILD_NC - Usługa katalogowa wykryła partycję podrzędną poniżej żądanej nazwy partycji. Hierarchię partycji należy tworzyć metodą zstępującą.
.
Language=Romanian
ERROR_DS_EXISTING_AD_CHILD_NC - The Active Directory detected an Active Directory child partition below the requested new partition name. The Active Directory's partition hierarchy must be created in a top-down method.
.

MessageId=8614
Severity=Success
Facility=System
SymbolicName=ERROR_DS_REPL_LIFETIME_EXCEEDED
Language=English
ERROR_DS_REPL_LIFETIME_EXCEEDED - The Active Directory cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime.
.
Language=Russian
ERROR_DS_REPL_LIFETIME_EXCEEDED - The Active Directory cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime.
.
Language=Polish
ERROR_DS_REPL_LIFETIME_EXCEEDED - Usługa katalogowa nie może replikować z tym serwerem, ponieważ czas, który upłynął od ostatniej replikacji z tym serwerem, przekroczył okres istnienia reliktu.
.
Language=Romanian
ERROR_DS_REPL_LIFETIME_EXCEEDED - The Active Directory cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime.
.

MessageId=8615
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER
Language=English
ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER - The requested operation is not allowed on an object under the system container.
.
Language=Russian
ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER - The requested operation is not allowed on an object under the system container.
.
Language=Polish
ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER - Żądana operacja jest niedozwolona na obiekcie znajdującym się w kontenerze systemowym.
.
Language=Romanian
ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER - The requested operation is not allowed on an object under the system container.
.

MessageId=8616
Severity=Success
Facility=System
SymbolicName=ERROR_DS_LDAP_SEND_QUEUE_FULL
Language=English
ERROR_DS_LDAP_SEND_QUEUE_FULL - The LDAP servers network send queue has filled up because the client is not processing the results of it's requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected.
.
Language=Russian
ERROR_DS_LDAP_SEND_QUEUE_FULL - The LDAP servers network send queue has filled up because the client is not processing the results of it's requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected.
.
Language=Polish
ERROR_DS_LDAP_SEND_QUEUE_FULL - Kolejka odbiorcza sieci serwerów LDAP wypełniła się, ponieważ klient nie przetwarza odpowiednio szybko wyników swoich żądań. Żadne żądania nie będą przetwarzane do czasu wyrównania klienta. Jeżeli klient nie zostanie wyrównany, zostanie rozłączony.
.
Language=Romanian
ERROR_DS_LDAP_SEND_QUEUE_FULL - The LDAP servers network send queue has filled up because the client is not processing the results of it's requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected.
.

MessageId=8617
Severity=Success
Facility=System
SymbolicName=ERROR_DS_DRA_OUT_SCHEDULE_WINDOW
Language=English
ERROR_DS_DRA_OUT_SCHEDULE_WINDOW - The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency.
.
Language=Russian
ERROR_DS_DRA_OUT_SCHEDULE_WINDOW - The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency.
.
Language=Polish
ERROR_DS_DRA_OUT_SCHEDULE_WINDOW - Zaplanowana replikacja nie została przeprowadzona, ponieważ system był zbyt zajęty, aby wykonać żądanie w zaplanowanym czasie. Kolejka replikacji jest przeciążona. Rozważ ograniczenie liczby partnerów lub zmniejszenie częstotliwości zaplanowanych replikacji.
.
Language=Romanian
ERROR_DS_DRA_OUT_SCHEDULE_WINDOW - The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency.
.

MessageId=9001
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_FORMAT_ERROR
Language=English
DNS_ERROR_RCODE_FORMAT_ERROR - DNS server unable to interpret format.
.
Language=Russian
DNS_ERROR_RCODE_FORMAT_ERROR - DNS server unable to interpret format.
.
Language=Polish
DNS_ERROR_RCODE_FORMAT_ERROR - DNS server unable to interpret format.
.
Language=Romanian
DNS_ERROR_RCODE_FORMAT_ERROR - DNS server unable to interpret format.
.

MessageId=9002
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_SERVER_FAILURE
Language=English
DNS_ERROR_RCODE_SERVER_FAILURE - DNS server failure.
.
Language=Russian
DNS_ERROR_RCODE_SERVER_FAILURE - DNS server failure.
.
Language=Polish
DNS_ERROR_RCODE_SERVER_FAILURE - DNS server failure.
.
Language=Romanian
DNS_ERROR_RCODE_SERVER_FAILURE - DNS server failure.
.

MessageId=9003
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_NAME_ERROR
Language=English
DNS_ERROR_RCODE_NAME_ERROR - DNS name does not exist.
.
Language=Russian
DNS_ERROR_RCODE_NAME_ERROR - DNS name does not exist.
.
Language=Polish
DNS_ERROR_RCODE_NAME_ERROR - DNS name does not exist.
.
Language=Romanian
DNS_ERROR_RCODE_NAME_ERROR - DNS name does not exist.
.

MessageId=9004
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_NOT_IMPLEMENTED
Language=English
DNS_ERROR_RCODE_NOT_IMPLEMENTED - DNS request not supported by name server.
.
Language=Russian
DNS_ERROR_RCODE_NOT_IMPLEMENTED - DNS request not supported by name server.
.
Language=Polish
DNS_ERROR_RCODE_NOT_IMPLEMENTED - DNS request not supported by name server.
.
Language=Romanian
DNS_ERROR_RCODE_NOT_IMPLEMENTED - DNS request not supported by name server.
.

MessageId=9005
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_REFUSED
Language=English
DNS_ERROR_RCODE_REFUSED - DNS operation refused.
.
Language=Russian
DNS_ERROR_RCODE_REFUSED - DNS operation refused.
.
Language=Polish
DNS_ERROR_RCODE_REFUSED - DNS operation refused.
.
Language=Romanian
DNS_ERROR_RCODE_REFUSED - DNS operation refused.
.

MessageId=9006
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_YXDOMAIN
Language=English
DNS_ERROR_RCODE_YXDOMAIN - DNS name that ought not exist, does exist.
.
Language=Russian
DNS_ERROR_RCODE_YXDOMAIN - DNS name that ought not exist, does exist.
.
Language=Polish
DNS_ERROR_RCODE_YXDOMAIN - DNS name that ought not exist, does exist.
.
Language=Romanian
DNS_ERROR_RCODE_YXDOMAIN - DNS name that ought not exist, does exist.
.

MessageId=9007
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_YXRRSET
Language=English
DNS_ERROR_RCODE_YXRRSET - DNS RR set that ought not exist, does exist.
.
Language=Russian
DNS_ERROR_RCODE_YXRRSET - DNS RR set that ought not exist, does exist.
.
Language=Polish
DNS_ERROR_RCODE_YXRRSET - DNS RR set that ought not exist, does exist.
.
Language=Romanian
DNS_ERROR_RCODE_YXRRSET - DNS RR set that ought not exist, does exist.
.

MessageId=9008
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_NXRRSET
Language=English
DNS_ERROR_RCODE_NXRRSET - DNS RR set that ought to exist, does not exist.
.
Language=Russian
DNS_ERROR_RCODE_NXRRSET - DNS RR set that ought to exist, does not exist.
.
Language=Polish
DNS_ERROR_RCODE_NXRRSET - DNS RR set that ought to exist, does not exist.
.
Language=Romanian
DNS_ERROR_RCODE_NXRRSET - DNS RR set that ought to exist, does not exist.
.

MessageId=9009
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_NOTAUTH
Language=English
DNS_ERROR_RCODE_NOTAUTH - DNS server not authoritative for zone.
.
Language=Russian
DNS_ERROR_RCODE_NOTAUTH - DNS server not authoritative for zone.
.
Language=Polish
DNS_ERROR_RCODE_NOTAUTH - DNS server not authoritative for zone.
.
Language=Romanian
DNS_ERROR_RCODE_NOTAUTH - DNS server not authoritative for zone.
.

MessageId=9010
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_NOTZONE
Language=English
DNS_ERROR_RCODE_NOTZONE - DNS name in update or prereq is not in zone.
.
Language=Russian
DNS_ERROR_RCODE_NOTZONE - DNS name in update or prereq is not in zone.
.
Language=Polish
DNS_ERROR_RCODE_NOTZONE - DNS name in update or prereq is not in zone.
.
Language=Romanian
DNS_ERROR_RCODE_NOTZONE - DNS name in update or prereq is not in zone.
.

MessageId=9016
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_BADSIG
Language=English
DNS_ERROR_RCODE_BADSIG - DNS signature failed to verify.
.
Language=Russian
DNS_ERROR_RCODE_BADSIG - DNS signature failed to verify.
.
Language=Polish
DNS_ERROR_RCODE_BADSIG - DNS signature failed to verify.
.
Language=Romanian
DNS_ERROR_RCODE_BADSIG - DNS signature failed to verify.
.

MessageId=9017
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_BADKEY
Language=English
DNS_ERROR_RCODE_BADKEY - DNS bad key.
.
Language=Russian
DNS_ERROR_RCODE_BADKEY - DNS bad key.
.
Language=Polish
DNS_ERROR_RCODE_BADKEY - DNS bad key.
.
Language=Romanian
DNS_ERROR_RCODE_BADKEY - DNS bad key.
.

MessageId=9018
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE_BADTIME
Language=English
DNS_ERROR_RCODE_BADTIME - DNS signature validity expired.
.
Language=Russian
DNS_ERROR_RCODE_BADTIME - DNS signature validity expired.
.
Language=Polish
DNS_ERROR_RCODE_BADTIME - DNS signature validity expired.
.
Language=Romanian
DNS_ERROR_RCODE_BADTIME - DNS signature validity expired.
.

MessageId=9501
Severity=Success
Facility=System
SymbolicName=DNS_INFO_NO_RECORDS
Language=English
DNS_INFO_NO_RECORDS - No records found for given DNS query.
.
Language=Russian
DNS_INFO_NO_RECORDS - No records found for given DNS query.
.
Language=Polish
DNS_INFO_NO_RECORDS - No records found for given DNS query.
.
Language=Romanian
DNS_INFO_NO_RECORDS - No records found for given DNS query.
.

MessageId=9502
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_BAD_PACKET
Language=English
DNS_ERROR_BAD_PACKET - Bad DNS packet.
.
Language=Russian
DNS_ERROR_BAD_PACKET - Bad DNS packet.
.
Language=Polish
DNS_ERROR_BAD_PACKET - Bad DNS packet.
.
Language=Romanian
DNS_ERROR_BAD_PACKET - Bad DNS packet.
.

MessageId=9503
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NO_PACKET
Language=English
DNS_ERROR_NO_PACKET - No DNS packet.
.
Language=Russian
DNS_ERROR_NO_PACKET - No DNS packet.
.
Language=Polish
DNS_ERROR_NO_PACKET - No DNS packet.
.
Language=Romanian
DNS_ERROR_NO_PACKET - No DNS packet.
.

MessageId=9504
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_RCODE
Language=English
DNS_ERROR_RCODE - DNS error, check rcode.
.
Language=Russian
DNS_ERROR_RCODE - DNS error, check rcode.
.
Language=Polish
DNS_ERROR_RCODE - DNS error, check rcode.
.
Language=Romanian
DNS_ERROR_RCODE - DNS error, check rcode.
.

MessageId=9505
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_UNSECURE_PACKET
Language=English
DNS_ERROR_UNSECURE_PACKET - Unsecured DNS packet.
.
Language=Russian
DNS_ERROR_UNSECURE_PACKET - Unsecured DNS packet.
.
Language=Polish
DNS_ERROR_UNSECURE_PACKET - Unsecured DNS packet.
.
Language=Romanian
DNS_ERROR_UNSECURE_PACKET - Unsecured DNS packet.
.

MessageId=9551
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_TYPE
Language=English
DNS_ERROR_INVALID_TYPE - Invalid DNS type.
.
Language=Russian
DNS_ERROR_INVALID_TYPE - Invalid DNS type.
.
Language=Polish
DNS_ERROR_INVALID_TYPE - Invalid DNS type.
.
Language=Romanian
DNS_ERROR_INVALID_TYPE - Invalid DNS type.
.

MessageId=9552
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_IP_ADDRESS
Language=English
DNS_ERROR_INVALID_IP_ADDRESS - Invalid IP address.
.
Language=Russian
DNS_ERROR_INVALID_IP_ADDRESS - Invalid IP address.
.
Language=Polish
DNS_ERROR_INVALID_IP_ADDRESS - Invalid IP address.
.
Language=Romanian
DNS_ERROR_INVALID_IP_ADDRESS - Invalid IP address.
.

MessageId=9553
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_PROPERTY
Language=English
DNS_ERROR_INVALID_PROPERTY - Invalid property.
.
Language=Russian
DNS_ERROR_INVALID_PROPERTY - Invalid property.
.
Language=Polish
DNS_ERROR_INVALID_PROPERTY - Invalid property.
.
Language=Romanian
DNS_ERROR_INVALID_PROPERTY - Invalid property.
.

MessageId=9554
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_TRY_AGAIN_LATER
Language=English
DNS_ERROR_TRY_AGAIN_LATER - Try DNS operation again later.
.
Language=Russian
DNS_ERROR_TRY_AGAIN_LATER - Try DNS operation again later.
.
Language=Polish
DNS_ERROR_TRY_AGAIN_LATER - Try DNS operation again later.
.
Language=Romanian
DNS_ERROR_TRY_AGAIN_LATER - Try DNS operation again later.
.

MessageId=9555
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NOT_UNIQUE
Language=English
DNS_ERROR_NOT_UNIQUE - Record for given name and type is not unique.
.
Language=Russian
DNS_ERROR_NOT_UNIQUE - Record for given name and type is not unique.
.
Language=Polish
DNS_ERROR_NOT_UNIQUE - Record for given name and type is not unique.
.
Language=Romanian
DNS_ERROR_NOT_UNIQUE - Record for given name and type is not unique.
.

MessageId=9556
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NON_RFC_NAME
Language=English
DNS_ERROR_NON_RFC_NAME - DNS name does not comply with RFC specifications.
.
Language=Russian
DNS_ERROR_NON_RFC_NAME - DNS name does not comply with RFC specifications.
.
Language=Polish
DNS_ERROR_NON_RFC_NAME - DNS name does not comply with RFC specifications.
.
Language=Romanian
DNS_ERROR_NON_RFC_NAME - DNS name does not comply with RFC specifications.
.

MessageId=9557
Severity=Success
Facility=System
SymbolicName=DNS_STATUS_FQDN
Language=English
DNS_STATUS_FQDN - DNS name is a fully-qualified DNS name.
.
Language=Russian
DNS_STATUS_FQDN - DNS name is a fully-qualified DNS name.
.
Language=Polish
DNS_STATUS_FQDN - DNS name is a fully-qualified DNS name.
.
Language=Romanian
DNS_STATUS_FQDN - DNS name is a fully-qualified DNS name.
.

MessageId=9558
Severity=Success
Facility=System
SymbolicName=DNS_STATUS_DOTTED_NAME
Language=English
DNS_STATUS_DOTTED_NAME - DNS name is dotted (multi-label).
.
Language=Russian
DNS_STATUS_DOTTED_NAME - DNS name is dotted (multi-label).
.
Language=Polish
DNS_STATUS_DOTTED_NAME - DNS name is dotted (multi-label).
.
Language=Romanian
DNS_STATUS_DOTTED_NAME - DNS name is dotted (multi-label).
.

MessageId=9559
Severity=Success
Facility=System
SymbolicName=DNS_STATUS_SINGLE_PART_NAME
Language=English
DNS_STATUS_SINGLE_PART_NAME - DNS name is a single-part name.
.
Language=Russian
DNS_STATUS_SINGLE_PART_NAME - DNS name is a single-part name.
.
Language=Polish
DNS_STATUS_SINGLE_PART_NAME - DNS name is a single-part name.
.
Language=Romanian
DNS_STATUS_SINGLE_PART_NAME - DNS name is a single-part name.
.

MessageId=9560
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_NAME_CHAR
Language=English
DNS_ERROR_INVALID_NAME_CHAR - DSN name contains an invalid character.
.
Language=Russian
DNS_ERROR_INVALID_NAME_CHAR - DSN name contains an invalid character.
.
Language=Polish
DNS_ERROR_INVALID_NAME_CHAR - DSN name contains an invalid character.
.
Language=Romanian
DNS_ERROR_INVALID_NAME_CHAR - DSN name contains an invalid character.
.

MessageId=9561
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NUMERIC_NAME
Language=English
DNS_ERROR_NUMERIC_NAME - DNS name is entirely numeric.
.
Language=Russian
DNS_ERROR_NUMERIC_NAME - DNS name is entirely numeric.
.
Language=Polish
DNS_ERROR_NUMERIC_NAME - DNS name is entirely numeric.
.
Language=Romanian
DNS_ERROR_NUMERIC_NAME - DNS name is entirely numeric.
.

MessageId=9562
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER
Language=English
DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER - The operation requested is not permitted on a DNS root server.
.
Language=Russian
DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER - The operation requested is not permitted on a DNS root server.
.
Language=Polish
DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER - The operation requested is not permitted on a DNS root server.
.
Language=Romanian
DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER - The operation requested is not permitted on a DNS root server.
.

MessageId=9563
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION
Language=English
DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION - The record could not be created because this part of the DNS namespace has been delegated to another server.
.
Language=Russian
DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION - The record could not be created because this part of the DNS namespace has been delegated to another server.
.
Language=Polish
DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION - The record could not be created because this part of the DNS namespace has been delegated to another server.
.
Language=Romanian
DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION - The record could not be created because this part of the DNS namespace has been delegated to another server.
.

MessageId=9564
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_CANNOT_FIND_ROOT_HINTS
Language=English
DNS_ERROR_CANNOT_FIND_ROOT_HINTS - The DNS server could not find a set of root hints.
.
Language=Russian
DNS_ERROR_CANNOT_FIND_ROOT_HINTS - The DNS server could not find a set of root hints.
.
Language=Polish
DNS_ERROR_CANNOT_FIND_ROOT_HINTS - The DNS server could not find a set of root hints.
.
Language=Romanian
DNS_ERROR_CANNOT_FIND_ROOT_HINTS - The DNS server could not find a set of root hints.
.

MessageId=9565
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INCONSISTENT_ROOT_HINTS
Language=English
DNS_ERROR_INCONSISTENT_ROOT_HINTS - The DNS server found root hints but they were not consistent across all adapters.
.
Language=Russian
DNS_ERROR_INCONSISTENT_ROOT_HINTS - The DNS server found root hints but they were not consistent across all adapters.
.
Language=Polish
DNS_ERROR_INCONSISTENT_ROOT_HINTS - The DNS server found root hints but they were not consistent across all adapters.
.
Language=Romanian
DNS_ERROR_INCONSISTENT_ROOT_HINTS - The DNS server found root hints but they were not consistent across all adapters.
.

MessageId=9601
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_DOES_NOT_EXIST
Language=English
DNS_ERROR_ZONE_DOES_NOT_EXIST - DNS zone does not exist.
.
Language=Russian
DNS_ERROR_ZONE_DOES_NOT_EXIST - DNS zone does not exist.
.
Language=Polish
DNS_ERROR_ZONE_DOES_NOT_EXIST - DNS zone does not exist.
.
Language=Romanian
DNS_ERROR_ZONE_DOES_NOT_EXIST - DNS zone does not exist.
.

MessageId=9602
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NO_ZONE_INFO
Language=English
DNS_ERROR_NO_ZONE_INFO - DNS zone information not available.
.
Language=Russian
DNS_ERROR_NO_ZONE_INFO - DNS zone information not available.
.
Language=Polish
DNS_ERROR_NO_ZONE_INFO - DNS zone information not available.
.
Language=Romanian
DNS_ERROR_NO_ZONE_INFO - DNS zone information not available.
.

MessageId=9603
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_ZONE_OPERATION
Language=English
DNS_ERROR_INVALID_ZONE_OPERATION - Invalid operation for DNS zone.
.
Language=Russian
DNS_ERROR_INVALID_ZONE_OPERATION - Invalid operation for DNS zone.
.
Language=Polish
DNS_ERROR_INVALID_ZONE_OPERATION - Invalid operation for DNS zone.
.
Language=Romanian
DNS_ERROR_INVALID_ZONE_OPERATION - Invalid operation for DNS zone.
.

MessageId=9604
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_CONFIGURATION_ERROR
Language=English
DNS_ERROR_ZONE_CONFIGURATION_ERROR - Invalid DNS zone configuration.
.
Language=Russian
DNS_ERROR_ZONE_CONFIGURATION_ERROR - Invalid DNS zone configuration.
.
Language=Polish
DNS_ERROR_ZONE_CONFIGURATION_ERROR - Invalid DNS zone configuration.
.
Language=Romanian
DNS_ERROR_ZONE_CONFIGURATION_ERROR - Invalid DNS zone configuration.
.

MessageId=9605
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_HAS_NO_SOA_RECORD
Language=English
DNS_ERROR_ZONE_HAS_NO_SOA_RECORD - DNS zone has no start of authority (SOA) record.
.
Language=Russian
DNS_ERROR_ZONE_HAS_NO_SOA_RECORD - DNS zone has no start of authority (SOA) record.
.
Language=Polish
DNS_ERROR_ZONE_HAS_NO_SOA_RECORD - DNS zone has no start of authority (SOA) record.
.
Language=Romanian
DNS_ERROR_ZONE_HAS_NO_SOA_RECORD - DNS zone has no start of authority (SOA) record.
.

MessageId=9606
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_HAS_NO_NS_RECORDS
Language=English
DNS_ERROR_ZONE_HAS_NO_NS_RECORDS - DNS zone has no name server (NS) record.
.
Language=Russian
DNS_ERROR_ZONE_HAS_NO_NS_RECORDS - DNS zone has no name server (NS) record.
.
Language=Polish
DNS_ERROR_ZONE_HAS_NO_NS_RECORDS - DNS zone has no name server (NS) record.
.
Language=Romanian
DNS_ERROR_ZONE_HAS_NO_NS_RECORDS - DNS zone has no name server (NS) record.
.

MessageId=9607
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_LOCKED
Language=English
DNS_ERROR_ZONE_LOCKED - DNS zone is locked.
.
Language=Russian
DNS_ERROR_ZONE_LOCKED - DNS zone is locked.
.
Language=Polish
DNS_ERROR_ZONE_LOCKED - DNS zone is locked.
.
Language=Romanian
DNS_ERROR_ZONE_LOCKED - DNS zone is locked.
.

MessageId=9608
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_CREATION_FAILED
Language=English
DNS_ERROR_ZONE_CREATION_FAILED - DNS zone creation failed.
.
Language=Russian
DNS_ERROR_ZONE_CREATION_FAILED - DNS zone creation failed.
.
Language=Polish
DNS_ERROR_ZONE_CREATION_FAILED - DNS zone creation failed.
.
Language=Romanian
DNS_ERROR_ZONE_CREATION_FAILED - DNS zone creation failed.
.

MessageId=9609
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_ALREADY_EXISTS
Language=English
DNS_ERROR_ZONE_ALREADY_EXISTS - DNS zone already exists.
.
Language=Russian
DNS_ERROR_ZONE_ALREADY_EXISTS - DNS zone already exists.
.
Language=Polish
DNS_ERROR_ZONE_ALREADY_EXISTS - DNS zone already exists.
.
Language=Romanian
DNS_ERROR_ZONE_ALREADY_EXISTS - DNS zone already exists.
.

MessageId=9610
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_AUTOZONE_ALREADY_EXISTS
Language=English
DNS_ERROR_AUTOZONE_ALREADY_EXISTS - DNS automatic zone already exists.
.
Language=Russian
DNS_ERROR_AUTOZONE_ALREADY_EXISTS - DNS automatic zone already exists.
.
Language=Polish
DNS_ERROR_AUTOZONE_ALREADY_EXISTS - DNS automatic zone already exists.
.
Language=Romanian
DNS_ERROR_AUTOZONE_ALREADY_EXISTS - DNS automatic zone already exists.
.

MessageId=9611
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_INVALID_ZONE_TYPE
Language=English
DNS_ERROR_INVALID_ZONE_TYPE - Invalid DNS zone type.
.
Language=Russian
DNS_ERROR_INVALID_ZONE_TYPE - Invalid DNS zone type.
.
Language=Polish
DNS_ERROR_INVALID_ZONE_TYPE - Invalid DNS zone type.
.
Language=Romanian
DNS_ERROR_INVALID_ZONE_TYPE - Invalid DNS zone type.
.

MessageId=9612
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP
Language=English
DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP - Secondary DNS zone requires master IP address.
.
Language=Russian
DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP - Secondary DNS zone requires master IP address.
.
Language=Polish
DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP - Secondary DNS zone requires master IP address.
.
Language=Romanian
DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP - Secondary DNS zone requires master IP address.
.

MessageId=9613
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_ZONE_NOT_SECONDARY
Language=English
DNS_ERROR_ZONE_NOT_SECONDARY - DNS zone not secondary.
.
Language=Russian
DNS_ERROR_ZONE_NOT_SECONDARY - DNS zone not secondary.
.
Language=Polish
DNS_ERROR_ZONE_NOT_SECONDARY - DNS zone not secondary.
.
Language=Romanian
DNS_ERROR_ZONE_NOT_SECONDARY - DNS zone not secondary.
.

MessageId=9614
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NEED_SECONDARY_ADDRESSES
Language=English
DNS_ERROR_NEED_SECONDARY_ADDRESSES - Need secondary IP address.
.
Language=Russian
DNS_ERROR_NEED_SECONDARY_ADDRESSES - Need secondary IP address.
.
Language=Polish
DNS_ERROR_NEED_SECONDARY_ADDRESSES - Need secondary IP address.
.
Language=Romanian
DNS_ERROR_NEED_SECONDARY_ADDRESSES - Need secondary IP address.
.

MessageId=9615
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_WINS_INIT_FAILED
Language=English
DNS_ERROR_WINS_INIT_FAILED - WINS initialization failed.
.
Language=Russian
DNS_ERROR_WINS_INIT_FAILED - WINS initialization failed.
.
Language=Polish
DNS_ERROR_WINS_INIT_FAILED - WINS initialization failed.
.
Language=Romanian
DNS_ERROR_WINS_INIT_FAILED - WINS initialization failed.
.

MessageId=9616
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NEED_WINS_SERVERS
Language=English
DNS_ERROR_NEED_WINS_SERVERS - Need WINS servers.
.
Language=Russian
DNS_ERROR_NEED_WINS_SERVERS - Need WINS servers.
.
Language=Polish
DNS_ERROR_NEED_WINS_SERVERS - Need WINS servers.
.
Language=Romanian
DNS_ERROR_NEED_WINS_SERVERS - Need WINS servers.
.

MessageId=9617
Severity=Success
Facility=System
SymbolicName=DNS_ERROR_NBSTAT_INIT_FAILED
Language=English
DNS_ERROR_NBSTAT_INIT_FAILED - NBTSTAT initialization call failed.
.
Language=Russian
DNS_ERROR_NBSTAT_INIT_FAILED - NBTSTAT initialization call failed.
.
Language=Polish
DNS_ERROR_NBSTAT_INIT_FAILED - NBTSTAT initialization call failed.
.
Language=Roma