/*
 * PROJECT:     ReactOS Printing Stack Marshalling Functions
 * LICENSE:     GPL-2.0+ (https://spdx.org/licenses/GPL-2.0+)
 * PURPOSE:     Marshalling definitions for PRINTER_INFO_*
 * COPYRIGHT:   Copyright 2015-2018 Colin Finck (colin@reactos.org)
 */

static const MARSHALLING PrinterInfoStressMarshalling = {
    sizeof(PRINTER_INFO_STRESS),
    {
        { FIELD_OFFSET(PRINTER_INFO_STRESS, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, pPrinterName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, pServerName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cJobs), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cJobs), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cJobs), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cTotalJobs), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalJobs), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalJobs), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cTotalBytes), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalBytes), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalBytes), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, stUpTime), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, stUpTime), sizeof(WORD), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, MaxcRef), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, MaxcRef), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, MaxcRef), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cTotalPagesPrinted), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalPagesPrinted), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cTotalPagesPrinted), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwGetVersion), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwGetVersion), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwGetVersion), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, fFreeBuild), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, fFreeBuild), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, fFreeBuild), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cSpooling), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cSpooling), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cSpooling), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cMaxSpooling), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cMaxSpooling), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cMaxSpooling), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cRef), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cRef), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cRef), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cErrorOutOfPaper), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cErrorOutOfPaper), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cErrorOutOfPaper), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cErrorNotReady), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cErrorNotReady), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cErrorNotReady), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cJobError), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cJobError), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cJobError), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwNumberOfProcessors), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwNumberOfProcessors), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwNumberOfProcessors), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwProcessorType), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwProcessorType), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwProcessorType), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwHighPartTotalBytes), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwHighPartTotalBytes), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwHighPartTotalBytes), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cChangeID), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cChangeID), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cChangeID), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwLastError), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwLastError), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwLastError), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, Status), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, Status), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, Status), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cEnumerateNetworkPrinters), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cEnumerateNetworkPrinters), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cEnumerateNetworkPrinters), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cAddNetPrinters), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cAddNetPrinters), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cAddNetPrinters), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, wProcessorArchitecture), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, wProcessorArchitecture), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, wProcessorArchitecture), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, wProcessorLevel), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, wProcessorLevel), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, wProcessorLevel), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, cRefIC), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cRefIC), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, cRefIC), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwReserved2), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwReserved2), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwReserved2), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_STRESS, dwReserved3), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwReserved3), RTL_FIELD_SIZE(PRINTER_INFO_STRESS, dwReserved3), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo1Marshalling = {
    sizeof(PRINTER_INFO_1W),
    {
        { FIELD_OFFSET(PRINTER_INFO_1W, Flags), RTL_FIELD_SIZE(PRINTER_INFO_1W, Flags), RTL_FIELD_SIZE(PRINTER_INFO_1W, Flags), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_1W, pDescription), RTL_FIELD_SIZE(PRINTER_INFO_1W, pDescription), RTL_FIELD_SIZE(PRINTER_INFO_1W, pDescription), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_1W, pName), RTL_FIELD_SIZE(PRINTER_INFO_1W, pName), RTL_FIELD_SIZE(PRINTER_INFO_1W, pName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_1W, pComment), RTL_FIELD_SIZE(PRINTER_INFO_1W, pComment), RTL_FIELD_SIZE(PRINTER_INFO_1W, pComment), TRUE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo2Marshalling = {
    sizeof(PRINTER_INFO_2W),
    {
        { FIELD_OFFSET(PRINTER_INFO_2W, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pServerName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPrinterName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pShareName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pShareName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pShareName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pPortName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPortName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPortName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pDriverName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDriverName), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDriverName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pComment), RTL_FIELD_SIZE(PRINTER_INFO_2W, pComment), RTL_FIELD_SIZE(PRINTER_INFO_2W, pComment), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pLocation), RTL_FIELD_SIZE(PRINTER_INFO_2W, pLocation), RTL_FIELD_SIZE(PRINTER_INFO_2W, pLocation), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDevMode), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pSepFile), RTL_FIELD_SIZE(PRINTER_INFO_2W, pSepFile), RTL_FIELD_SIZE(PRINTER_INFO_2W, pSepFile), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pPrintProcessor), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPrintProcessor), RTL_FIELD_SIZE(PRINTER_INFO_2W, pPrintProcessor), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pDatatype), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDatatype), RTL_FIELD_SIZE(PRINTER_INFO_2W, pDatatype), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pParameters), RTL_FIELD_SIZE(PRINTER_INFO_2W, pParameters), RTL_FIELD_SIZE(PRINTER_INFO_2W, pParameters), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, pSecurityDescriptor), RTL_FIELD_SIZE(PRINTER_INFO_2W, pSecurityDescriptor), RTL_FIELD_SIZE(PRINTER_INFO_2W, pSecurityDescriptor), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_2W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_2W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_2W, Attributes), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, Priority), RTL_FIELD_SIZE(PRINTER_INFO_2W, Priority), RTL_FIELD_SIZE(PRINTER_INFO_2W, Priority), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, DefaultPriority), RTL_FIELD_SIZE(PRINTER_INFO_2W, DefaultPriority), RTL_FIELD_SIZE(PRINTER_INFO_2W, DefaultPriority), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, StartTime), RTL_FIELD_SIZE(PRINTER_INFO_2W, StartTime), RTL_FIELD_SIZE(PRINTER_INFO_2W, StartTime), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, UntilTime), RTL_FIELD_SIZE(PRINTER_INFO_2W, UntilTime), RTL_FIELD_SIZE(PRINTER_INFO_2W, UntilTime), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, Status), RTL_FIELD_SIZE(PRINTER_INFO_2W, Status), RTL_FIELD_SIZE(PRINTER_INFO_2W, Status), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, cJobs), RTL_FIELD_SIZE(PRINTER_INFO_2W, cJobs), RTL_FIELD_SIZE(PRINTER_INFO_2W, cJobs), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_2W, AveragePPM), RTL_FIELD_SIZE(PRINTER_INFO_2W, AveragePPM), RTL_FIELD_SIZE(PRINTER_INFO_2W, AveragePPM), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo3Marshalling = {
    sizeof(PRINTER_INFO_3),
    {
        { FIELD_OFFSET(PRINTER_INFO_3, pSecurityDescriptor), RTL_FIELD_SIZE(PRINTER_INFO_3, pSecurityDescriptor), RTL_FIELD_SIZE(PRINTER_INFO_3, pSecurityDescriptor), TRUE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo4Marshalling = {
    sizeof(PRINTER_INFO_4W),
    {
        { FIELD_OFFSET(PRINTER_INFO_4W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_4W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_4W, pPrinterName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_4W, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_4W, pServerName), RTL_FIELD_SIZE(PRINTER_INFO_4W, pServerName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_4W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_4W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_4W, Attributes), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo5Marshalling = {
    sizeof(PRINTER_INFO_5W),
    {
        { FIELD_OFFSET(PRINTER_INFO_5W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_5W, pPrinterName), RTL_FIELD_SIZE(PRINTER_INFO_5W, pPrinterName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_5W, pPortName), RTL_FIELD_SIZE(PRINTER_INFO_5W, pPortName), RTL_FIELD_SIZE(PRINTER_INFO_5W, pPortName), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_5W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_5W, Attributes), RTL_FIELD_SIZE(PRINTER_INFO_5W, Attributes), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_5W, DeviceNotSelectedTimeout), RTL_FIELD_SIZE(PRINTER_INFO_5W, DeviceNotSelectedTimeout), RTL_FIELD_SIZE(PRINTER_INFO_5W, DeviceNotSelectedTimeout), FALSE },
        { FIELD_OFFSET(PRINTER_INFO_5W, TransmissionRetryTimeout), RTL_FIELD_SIZE(PRINTER_INFO_5W, TransmissionRetryTimeout), RTL_FIELD_SIZE(PRINTER_INFO_5W, TransmissionRetryTimeout), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo6Marshalling = {
    sizeof(PRINTER_INFO_6),
    {
        { FIELD_OFFSET(PRINTER_INFO_6, dwStatus), RTL_FIELD_SIZE(PRINTER_INFO_6, dwStatus), RTL_FIELD_SIZE(PRINTER_INFO_6, dwStatus), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo7Marshalling = {
    sizeof(PRINTER_INFO_7W),
    {
        { FIELD_OFFSET(PRINTER_INFO_7W, pszObjectGUID), RTL_FIELD_SIZE(PRINTER_INFO_7W, pszObjectGUID), RTL_FIELD_SIZE(PRINTER_INFO_7W, pszObjectGUID), TRUE },
        { FIELD_OFFSET(PRINTER_INFO_7W, dwAction), RTL_FIELD_SIZE(PRINTER_INFO_7W, dwAction), RTL_FIELD_SIZE(PRINTER_INFO_7W, dwAction), FALSE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo8Marshalling = {
    sizeof(PRINTER_INFO_8W),
    {
        { FIELD_OFFSET(PRINTER_INFO_8W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_8W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_8W, pDevMode), TRUE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING PrinterInfo9Marshalling = {
    sizeof(PRINTER_INFO_9W),
    {
        { FIELD_OFFSET(PRINTER_INFO_9W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_9W, pDevMode), RTL_FIELD_SIZE(PRINTER_INFO_9W, pDevMode), TRUE },
        { MAXDWORD, 0, 0, FALSE }
    }
};

static const MARSHALLING* pPrinterInfoMarshalling[] = {
    &PrinterInfoStressMarshalling,
    &PrinterInfo1Marshalling,
    &PrinterInfo2Marshalling,
    &PrinterInfo3Marshalling,
    &PrinterInfo4Marshalling,
    &PrinterInfo5Marshalling,
    &PrinterInfo6Marshalling,
    &PrinterInfo7Marshalling,
    &PrinterInfo8Marshalling,
    &PrinterInfo9Marshalling
};
