
/**
 * Prefix keyframes.
 * 
 *   @keyframes animation {
 *     from {
 *       opacity: 0;
 *     }
 *   
 *     to {
 *       opacity: 1;
 *     }
 *   }
 * 
 * yields:
 * 
 *   @keyframes animation {
 *     from {
 *       opacity: 0;
 *     }
 *   
 *     to {
 *       opacity: 1;
 *     }
 *   }
 * 
 *   @-webkit-keyframes animation {
 *     from {
 *       opacity: 0;
 *     }
 *   
 *     to {
 *       opacity: 1;
 *     }
 *   }
 * 
 */

module.exports = function(vendors) {
  return function(style, rework){
    vendors = vendors || rework.prefixes;

    style.rules.forEach(function(rule){
      if (!rule.keyframes) return;

      vendors.forEach(function(vendor){
        if (vendor == rule.vendor) return;
        var clone = cloneKeyframes(rule);
        clone.vendor = vendor;
        style.rules.push(clone);
      });
    });
  }
};

/**
 * Clone keyframes.
 *
 * @param {Object} rule
 * @api private
 */

function cloneKeyframes(rule) {
  var clone = { name: rule.name };
  clone.vendor = rule.vendor;
  clone.keyframes = [];
  rule.keyframes.forEach(function(keyframe){
    clone.keyframes.push(cloneKeyframe(keyframe));
  });
  return clone;
}

/**
 * Clone `keyframe`.
 *
 * @param {Object} keyframe
 * @api private
 */

function cloneKeyframe(keyframe) {
  var clone = {};
  clone.values = keyframe.values.slice();
  clone.declarations = keyframe.declarations.map(function(decl){
    return {
      property: decl.property,
      value: decl.value
    }
  });
  return clone;
}