
/**
 * Prefix selectors with `str`.
 * 
 *    button {
 *      color: red;
 *    }
 * 
 * yields:
 * 
 *    #dialog button {
 *      color: red;
 *    }
 * 
 */

module.exports = function(str) {
  return function(style){
    style.rules = style.rules.map(function(rule){
      if (!rule.selectors) return rule;
      rule.selectors = rule.selectors.map(function(selector){
        return str + ' ' + selector;
      });
      return rule;
    });
  }
};