---
title: Getting started with .NET Core
description: Find resources to learn how to build .NET Core applications on Windows, Linux and macOS.
keywords: .NET, .NET Core
author: mairaw
ms.author: mairaw
ms.date: 03/02/2017
ms.topic: article
ms.prod: .net-core
ms.devlang: dotnet
ms.assetid: d1453a0d-317c-4da6-b68e-422a2c0bfe49
---

# Getting started with .NET Core

.NET Core runs on [Windows](#windows), [Linux](#linux), and [macOS / OS X](#os-x--macos).

## Windows

Install .NET Core on [Windows](https://www.microsoft.com/net/core#windows). 

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Building a C# Hello World Application with .NET Core in Visual Studio 2017](../csharp/getting-started/with-visual-studio.md) - Learn to to build, debug, and publish a simple .NET Core console application using Visual Studio 2017.
* [Building a class library with C# and .NET Core in Visual Studio 2017](../csharp/getting-started/library-with-visual-studio-2017.md) - Learn how to build a class library written in C# using Visual Studio 2017
* [Get started with Visual Studio Code using C# and .NET Core on Windows](https://channel9.msdn.com/Blogs/dotnet/Get-started-with-VS-Code-using-CSharp-and-NET-Core) - This [Channel9](https://channel9.msdn.com) video shows you how to install and use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor, to create your first console application in .NET Core.
* [Getting started with .NET Core using the command-line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).

See the [Prerequisites for Windows development](windows-prerequisites.md) topic for a list of the supported Windows versions. 

## Linux

Install .NET Core on your distribution/version:

* [Red Hat Enterprise Linux 7 Server](https://www.microsoft.com/net/core#linuxredhat)
* [Ubuntu 14.04, 16.04 & Linux Mint 17](https://www.microsoft.com/net/core#linuxubuntu)
* [Debian 8.2](https://www.microsoft.com/net/core#linuxdebian)
* [Fedora 23](https://www.microsoft.com/net/core#linuxfedora)
* [CentOS 7.1 & Oracle Linux 7.1](https://www.microsoft.com/net/core#linuxcentos)
* [openSUSE 13.2](https://www.microsoft.com/net/core#linuxopensuse)

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Getting started with .NET Core using the command-line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).
* [Get started with VS Code using C# and .NET Core on Ubuntu](https://channel9.msdn.com/Blogs/dotnet/Get-started-with-VS-Code-Csharp-dotnet-Core-Ubuntu) - This [Channel9](https://channel9.msdn.com) video shows you how to install and use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor, to create your first console application in .NET Core on Ubuntu 14.04.

.NET Core is supported by the Linux distributions and versions listed above in the installation links.

## OS X / macOS

Install .NET Core for [macOS](https://www.microsoft.com/net/core#macos). .NET Core is supported on OS X El Capitan (version 10.11) and macOS Sierra (version 10.12).

You can get started developing .NET Core apps by following these step-by-step tutorials.

* [Get started with VS Code using C# and .NET Core on macOS](https://channel9.msdn.com/Blogs/dotnet/Get-started-with-VS-Code-using-CSharp-and-NET-Core-on-MacOS) - This [Channel9](https://channel9.msdn.com) video shows you how to install and use [Visual Studio Code](https://www.visualstudio.com/products/code-vs), Microsoft's lightweight cross-platform code editor, to create your first console application in .NET Core. 
* [Getting started with .NET Core on macOS, using Visual Studio Code](tutorials/using-on-macos.md) - A tour of the steps and workflow to create a .NET Core Solution using VS Code that includes unit tests, third-party libraries and how to use the debugging tools.
* [Getting started with .NET Core using the command-line](tutorials/using-with-xplat-cli.md) - Use any code editor with the [.NET Core cross-platform command-line interface (CLI)](tools/index.md).
