---
title: "Compiler Error CS0034 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0034"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0034"
ms.assetid: cb72ec9b-3a6b-40f3-b2ad-2ea122920edd
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0034
Operator 'operator' is ambiguous on operands of type 'type1' and 'type2'  
  
 An operator was used on two objects and the compiler found more than one conversion. Because conversions have to be unique, you either have to make a cast or to make one of the conversions explicit. For more information, see [Conversion Operators](../../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md).  
  
 The following sample generates CS0034:  
  
```  
// CS0034.cs  
public class A  
{  
   // allows for the conversion of A object to int  
   public static implicit operator int (A s)  
   {  
      return 0;  
   }  
  
   public static implicit operator string (A i)  
   {  
      return null;  
   }  
}  
  
public class B  
{  
   public static implicit operator int (B s)  
   // one way to resolve this CS0034 is to make one conversion explicit  
   // public static explicit operator int (B s)  
   {  
      return 0;  
   }  
  
   public static implicit operator string (B i)  
   {  
      return null;  
   }  
  
   public static implicit operator B (string i)  
   {  
      return null;  
   }  
  
   public static implicit operator B (int i)  
   {  
      return null;  
   }  
}  
  
public class C  
{  
   public static void Main ()  
   {  
      A a = new A();  
      B b = new B();  
      b = b + a;   // CS0034  
      // another way to resolve this CS0034 is to make a cast  
      // b = b + (int)a;  
   }  
}  
```  
  
 In C# 1.1 a compiler bug made it possible to define a class that has implicit user-defined conversions to both `int` and `bool`, and to use a bitwise `AND` operator (`&`) on objects of that type. In C# 2.0, this bug was fixed to bring the compiler into compliance with the C# specification, and therefore the following code will now cause CS0034:  
  
```  
namespace CS0034  
{  
    class TestClass2  
    {  
        public void Test()  
        {  
            TestClass o1 = new TestClass();  
            TestClass o2 = new TestClass();  
            TestClass o3 = o1 & o2; //CS0034  
        }  
    }  
  
    class TestClass  
    {  
        public static implicit operator int(TestClass o)  
        {  
            return 1;  
        }  
  
        public static implicit operator TestClass(int v)  
        {  
            return new TestClass();  
        }  
  
        public static implicit operator bool(TestClass o)  
        {  
            return true;  
        }  
    }  
  
}  
```