---
title: "Compiler Error CS0052 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0052"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0052"
ms.assetid: 3beed1c9-f482-4a48-b98d-b9fdc279b9d7
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0052
Inconsistent accessibility: field type 'type' is less accessible than field 'field'  
  
 The type of a field cannot be less accessible than the field itself because all public constructs must return a publicly accessible object.  
  
## Example  
 The following sample generates CS0052:  
  
```cs  
// CS0052.cs  
public class MyClass2  
{  
    // The following line causes an error because the field, M, is declared  
    // as public, but the type, MyClass, is private. Therefore the type is   
    // less accessible than the field.  
    public MyClass M;   // CS0052  
  
    private class MyClass  
    {  
    }  
    // One way to resolve the error is to change the accessibility of the type  
    // to public.   
    //public class MyClass  
    // Another solution is to change the accessibility of the field to private.  
    // private MyClass M;  
}  
  
    public class MainClass  
    {  
        public static void Main()  
        {  
        }  
    }  
```  
  
## See Also  
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Access Modifiers](../../../csharp/language-reference/keywords/access-modifiers.md)   
 [Accessibility Levels](../../../csharp/language-reference/keywords/accessibility-levels.md)   
 [Modifiers](../../../csharp/language-reference/keywords/modifiers.md)