---
title: "Compiler Warning (level 2) CS0108 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0108"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0108"
ms.assetid: 04330ed2-80d5-4bf2-b0c1-a0c2bec03074
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 2) CS0108
'member1' hides inherited member 'member2'. Use the new keyword if hiding was intended.  
  
 A variable was declared with the same name as a variable in a base class. However, the [new](../../../csharp/language-reference/keywords/new.md) keyword was not used. This warning informs you that you should use **new**; the variable is declared as if **new** had been used in the declaration.  
  
 The following sample generates CS0108:  
  
```  
// CS0108.cs  
// compile with: /W:2  
using System;  
  
namespace x  
{  
   public class clx  
   {  
      public int i = 1;  
   }  
  
   public class cly : clx  
   {  
      public static int i = 2;   // CS0108, use the new keyword  
      // Use the following line instead:  
      // public static new int i = 2;  
  
      public static void Main()  
      {  
         Console.WriteLine(i);  
      }  
   }  
}  
```  
  
## See Also  
 [new Modifier](../../../csharp/language-reference/keywords/new-modifier.md)   
 [new](../../../csharp/language-reference/keywords/new.md)