---
title: "Compiler Error CS0116 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0116"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0116"
ms.assetid: 4cb137b5-ec29-4c1a-adde-9f8424cb9496
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0116
A namespace does not directly contain members such as fields or methods  
  
 Inside a [namespace](../../../csharp/language-reference/keywords/namespace.md), the compiler only accepts classes, structures, unions, enumerations, interfaces, and delegates. This error is often generated by developers from a C/C++ background who forget that in C#, methods and variables must be declared and defined within a struct or class. For more information, see [General Structure of a C# Program](../../../csharp/programming-guide/inside-a-program/general-structure-of-a-csharp-program.md).  
  
## Example  
 The following sample generates CS0116:  
  
```  
// CS0116.cs  
namespace x  
{  
    using System;  
  
    // method must be in class/struct  
    void Method(string str) // CS0116  
    {  
        Console.WriteLine(str);  
    }  
    // To fix the error, you must  
    // enclose a method in a class:  
    class Program  
    {  
        void Method2(string str)  
        {  
            Console.WriteLine(str);  
        }  
    }  
}  
```  
  
## See Also  
 [General Structure of a C# Program](../../../csharp/programming-guide/inside-a-program/general-structure-of-a-csharp-program.md)   
 [Classes and Structs](../../../csharp/programming-guide/classes-and-structs/index.md)   
 [Namespaces](../../../csharp/programming-guide/namespaces/index.md)