---
title: "Compiler Error CS0163 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0163"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0163"
ms.assetid: 00139dcf-33cd-45ea-bf80-d6f26b10a5d2
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0163
Control cannot fall through from one case label ('label') to another  
  
 When a [switch statement](../../../csharp/language-reference/keywords/switch.md) contains more than one switch section, you must explicitly terminate each section, including the last one, by using one of the following keywords:  
  
-   [return](../../../csharp/language-reference/keywords/return.md)  
  
-   [goto](../../../csharp/language-reference/keywords/goto.md)  
  
-   [break](../../../csharp/language-reference/keywords/break.md)  
  
-   [throw](../../../csharp/language-reference/keywords/throw.md)  
  
-   [continue](../../../csharp/language-reference/keywords/continue.md)  
  
 If you want to implement "fall through" behavior from one section to the next, use `goto case #`. For more information and examples, see [switch](../../../csharp/language-reference/keywords/switch.md).  
  
 The following sample generates CS0163.  
  
```cs  
// CS0163.cs  
public class MyClass  
{  
    public static void Main()  
    {  
        int i = 0;  
  
        switch (i)   // CS0163  
        {  
            // Compiler error CS0163 is reported on the following line.  
            case 1:  
                i++;  
            // To resolve the error, uncomment one of the following example statements.  
            // return;  
            // break;  
            // goto case 3;  
  
            case 2:  
                i++;  
                return;  
  
            case 3:  
                i = 0;  
                return;  
  
            // Compiler error CS0163 is reported on the following line.  
            default:  
                Console.WriteLine("Default");  
                // To resolve the error, uncomment the following line:  
            //break;  
        }  
    }  
```