---
title: "Compiler Error CS0234 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0234"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0234"
ms.assetid: 413774cc-b63e-472b-8fe7-cf23ca970a5f
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0234
The type or namespace name 'name' does not exist in the namespace 'namespace' (are you missing an assembly reference?)  
  
 A type was expected. Possible causes for this error include the following:  
  
-   An assembly that contains the definition of a type was not referenced in the compilation; use [/reference (Import Metadata)](../../../csharp/language-reference/compiler-options/reference-compiler-option.md) to specify the assembly  
  
-   You passed a variable name to the [typeof](../../../csharp/language-reference/keywords/typeof.md) operator.  
  
-   You tried to reference an assembly that is not part of your target .NET Framework profile. For more information, see [Troubleshooting .NET Framework Targeting Errors](https://docs.microsoft.com/visualstudio/msbuild/troubleshooting-dotnet-framework-targeting-errors).  
  
 If you see this error after moving code from one development machine to another, make sure that the project on the new machine has the correct references, and that the versions of the assemblies are the same as on the old machine. You can also use the Object Browser to inspect an assembly and verify whether it contains the types that you expect it to contain.  
  
 The following sample generates CS0234:  
  
```  
// CS0234.cs  
public class C  
{  
   public static void Main()  
   {  
      System.DateTime x = new System.DateTim();   // CS0234  
      // try the following line instead  
      // System.DateTime x = new System.DateTime();  
   }  
}  
```