---
title: "Compiler Error CS0246 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0246"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0246"
ms.assetid: 4948fae2-2cc0-4ce4-b98c-ea69a8120b71
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0246
The type or namespace name 'type/namespace' could not be found (are you missing a using directive or an assembly reference?)  
  
 A type or namespace that is used in the program was not found. You might have forgotten to reference ([/reference](../../../csharp/language-reference/compiler-options/reference-compiler-option.md)) the assembly that contains the type, or you might not have added the required [using directive](../../../csharp/language-reference/keywords/using-directive.md).  Or, there might be an issue with the assembly you are trying to reference.  
  
 The following situations cause compiler error CS0246.  
  
-   Did you misspell the name of the type or namespace? Without the correct name, the compiler cannot find the definition for the type or namespace. This often occurs because the casing used in the name of the type is not correct. For example, `Dataset ds;` generates CS0246 because the s in Dataset must be capitalized.  
  
-   If the error is for a namespace name, did you add a reference ([/reference](../../../csharp/language-reference/compiler-options/reference-compiler-option.md)) to the assembly that contains the namespace? For example, your code might contain the directive `using Accessibility`. However, if your project does not reference the assembly Accessibility.dll, error CS0246 is reported. For more information, see [Managing references in a project](https://docs.microsoft.com/visualstudio/ide/managing-references-in-a-project)  
  
-   If the error is for a type name, did you include the proper [using](../../../csharp/language-reference/keywords/using.md) directive, or, alternatively, fully qualify the name of the type? Consider the following declaration: `DataSet ds`. To use the `DataSet` type, you need two things. First, you need a reference to the assembly that contains the definition for the `DataSet` type. Second, you need a `using` directive for the namespace where `DataSet` is located. For example, because `DataSet` is located in the **System.Data** namespace, you need the following directive at the beginning of your code: `using System.Data`.  
  
     The `using` directive is not required. However, if you omit the directive, you must fully qualify the `DataSet` type when referring to it. Full qualification means that you specify both the namespace and the type each time you refer to the type in your code. If you omit the `using` directive in the previous example, you must write `System.Data.DataSet ds` to declare `ds` instead of `DataSet ds`.  
  
-   Did you use a variable or some other language element where a type was expected? For example, in an **is** statement, if you use a `Type` object instead of an actual type, you get error CS0246.  
  
-   Did you use a *using alias directive* without fully qualifying the type name? A `using` alias directive does not use the `using` directives in the source code file to resolve types. The following example generates CS0246 because the type `List<int>` is not fully qualified. The `using` directive for `System.Collections.Generic` does not prevent the error.  
  
    ```cs  
    using System.Collections.Generic;  
  
    // The following declaration generates CS0246.  
    using myAliasName = List<int>;   
  
    // To avoid the error, fully qualify List.  
    using myAliasName2 = System.Collections.Generic.List<int>;  
  
    ```  
  
     If you get this error in code that was previously working, first look for missing or unresolved references in Solution Explorer. Do you need to re-install a [NuGet](https://www.nuget.org/)package? For information about how the build system searches for references, see [Resolving file references in team build](http://blogs.msdn.com/b/manishagarwal/archive/2005/09/28/474769.aspx). If all references seem to be correct, look in your source control history to see what has changed in your .csproj file and/or your local source file.  
  
     If you haven’t successfully accessed the reference yet, use the Object Browser to inspect the assembly that is supposed to contain this namespace and verify that the namespace is present. If you verify with Object Browser that the assembly contains the namespace, try removing the “using” directive for the namespace and see what else breaks. The root problem may be with some other type in another assembly.  
  
 The following example generates CS0246 because a necessary `using` directive is missing.  
  
```cs  
// CS0246.cs  
//using System.Diagnostics;  
  
public class MyClass  
{  
    // The following line causes CS0246. To fix the error, uncomment  
    // the using directive for the namespace for this attribute,  
    // System.Diagnostics.  
    [Conditional("A")]  
    public void Test()  
    {  
    }  
  
    public static void Main()  
    {  
    }  
}  
```  
  
 The following example causes CS0246 because an object of type `Type` was used where an actual type was expected.  
  
```cs  
// CS0246b.cs  
using System;  
  
class ExampleClass  
{  
    public bool supports(object o, Type t)  
    {  
        // The following line causes CS0246. You must use an  
        // actual type, such as ExampleClass, String, or Type.  
        if (o is t)  
        {  
            return true;  
        }  
        return false;  
    }  
}  
  
class Program  
{  
    public static void Main()  
    {  
        ExampleClass myC = new ExampleClass();  
        myC.supports(myC, myC.GetType());  
    }  
}  
  
```