---
title: "Compiler Warning (level 2) CS0467 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0467"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0467"
ms.assetid: ae082998-afd6-4f82-9c87-6b429ba8fd57
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 2) CS0467
Ambiguity between method 'method' and non-method 'non-method'.Using method group.  
  
 Inherited members from different interfaces that have the same signature  cause an ambiguity error.  
  
## Example  
 The following example generates CS0467.  
  
```cs  
// CS0467.cs  
interface IList   
{  
    int Count { get; set; }  
}  
  
interface ICounter  
{  
    void Count(int i);  
}  
  
interface IListCounter : IList, ICounter {}  
  
class Driver   
{  
    void Test(IListCounter x)  
    {  
        // The following line causes the warning. The assignment also  
        // causes an error because you can't assign a value to a method.  
        x.Count = 1;  
        x.Count(3);     
        // To resolve the warning, you can change the name of the method or   
        // the property.  
  
        // You also can disambiguate by specifying IList or ICounter.  
        ((IList)x).Count = 1;  
        ((ICounter)x).Count(3);  
    }  
  
    static void Main()   
    {  
    }  
}  
```