---
title: "Compiler Error CS0570 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0570"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0570"
ms.assetid: 6b378974-fdd9-451b-b595-6b5b19b4ab48
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0570
Property, indexer, or event 'name' is not supported by the language; try directly calling accessor method 'name!'  
  
 This error occurs when using imported metadata that was generated by another compiler. Your code attempted to use a class member that the compiler cannot process.  
  
## Example  
 The following C++ program uses an attribute, RequiredAttributeAttribute, which may not be consumed by other languages.  
  
```  
// CPP0570.cpp  
// compile with: /clr /LD  
  
using namespace System;  
using namespace System::Runtime::CompilerServices;  
  
namespace CS0570_Server {  
   [RequiredAttributeAttribute(Int32::typeid)]    
   public ref struct Scenario1 {  
      int intVar;  
   };  
  
   public ref struct CS0570Class {  
      Scenario1 ^ sc1_field;  
  
      property virtual Scenario1 ^ sc1_prop {  
         Scenario1 ^ get() { return sc1_field; }  
      }  
  
      Scenario1 ^ sc1_method() { return sc1_field; }  
   };  
};  
```  
  
## Example  
 The following sample generates CS0570.  
  
```  
// CS0570.cs  
// compile with: /reference:CPP0570.dll  
using System;  
using CS0570_Server;  
  
public class C {  
   public static int Main() {  
      CS0570Class r = new CS0570Class();  
      r.sc1_field = null;   // CS0570  
      object o = r.sc1_prop;   // CS0570  
      r.sc1_method();   // CS0570  
   }  
}  
```