---
title: "Compiler Error CS0840 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0840"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0840"
ms.assetid: f307083f-8d86-4142-a9fd-b735910687b2
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0840
'Property name' must declare a body because it is not marked abstract or extern. Automatically implemented properties must define both get and set accessors.  
  
 Unless a regular property is marked as `abstract` or `extern`, or is a member of a `partial` type, it must supply a body. Auto-implemented properties do not provide accessor bodies, but they must specify both accessors. To create a read-only auto-implemented property, make the set accessor `private`.  
  
## To correct this error  
  
1.  Supply the missing body or accessor or else use the [abstract](../../../csharp/language-reference/keywords/abstract.md), [extern](../../../csharp/language-reference/keywords/extern.md), or [partial (Type)](../../../csharp/language-reference/keywords/partial-type.md) modifiers on it and/or its enclosing type.  
  
## Example  
 The following example generates CS0840:  
  
```  
// cs0840.cs  
// Compile with /target:library  
using System;  
class Test  
{  
    public int myProp { get; } // CS0840  
  
    // to create a read-only property  
    // try the following line instead  
    public int myProp2 { get; private set; }  
  
}  
```  
  
## See Also  
 [Auto-Implemented Properties](../../../csharp/programming-guide/classes-and-structs/auto-implemented-properties.md)