---
title: "Compiler Error CS1019 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1019"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1019"
ms.assetid: 11a3acd8-bcab-4ead-a91b-a1498ea1eab5
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1019
Overloadable unary operator expected  
  
 Something that looks like an overloaded unary operator has been declared, but the operator is missing or is in the wrong location in the signature.  
  
 A *unary operator* is an operator that operates on a single operand. For example, `++` is a unary operator. You can overload some unary operators by using the `operator` keyword and specifying a single parameter of the type that the operator operates on. For example, if you want to overload the operator `++` for a user-defined class `Temperature` so that you can write `Temperature++`, you can define it in this way:  
  
```cs  
public static  Temperature operator ++ (Temperature temp)  
{  
    temp.Degrees++;  
    return temp;  
}  
```  
  
 When you receive this error, you have declared something that looks like an overloaded unary operator, except that the operator itself is missing or is in the wrong location in the signature. If you remove the `++` from the signature in the previous example, you will generate CS1019.  
  
 The following code generates CS1019:  
  
```cs  
// CS1019.cs  
public class ii  
{  
   int i  
   {  
      get  
      {  
         return 0;  
      }  
   }  
}  
  
public class a  
{  
    public int i;  
// Generates CS1019: "ii" is not a unary operator.  
   public static a operator ii(a aa)     
  
   // Use the following line instead:  
   //public static a operator ++(a aa)  
   {  
      aa.i++;  
      return aa;   
   }  
  
   public static void Main()  
   {  
   }  
}  
```  
  
## See Also  
 [Operators](../../../csharp/programming-guide/statements-expressions-operators/operators.md)