---
title: "Compiler Warning (level 1) CS1058 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1058"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1058"
ms.assetid: ed50590c-f130-47c3-976d-322a6c8f996d
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1058
A previous catch clause already catches all exceptions. All exceptions thrown will be wrapped in a System.Runtime.CompilerServices.RuntimeWrappedException  
  
 This attribute causes CS1058 if a `catch()` block has no specified exception type after a `catch (System.Exception e)` block. The warning advises that the `catch()` block will not catch any exceptions.  
  
 A `catch()` block after a `catch (System.Exception e)` block can catch non-CLS exceptions if the `RuntimeCompatibilityAttribute` is set to false in the AssemblyInfo.cs file: `[assembly: RuntimeCompatibilityAttribute(WrapNonExceptionThrows = false)]`. If this attribute is not set explicitly to false, all thrown non-CLS exceptions are wrapped as Exceptions and the `catch (System.Exception e)` block catches them. For more information, see [How to: Catch a non-CLS Exception](../../../csharp/programming-guide/exceptions/how-to-catch-a-non-cls-exception.md).  
  
## Example  
 The following example generates CS1058.  
  
```  
// CS1058.cs  
// CS1058 expected  
using System.Runtime.CompilerServices;  
  
// the following attribute is set to true by default in the C# compiler  
// set to false in your source code to resolve CS1058  
[assembly: RuntimeCompatibilityAttribute(WrapNonExceptionThrows = true)]  
  
class TestClass   
{  
   static void Main()   
   {  
      try {}  
  
      catch (System.Exception e) {   
         System. Console.WriteLine("Caught exception {0}", e);  
      }  
  
      catch {}   // CS1058. This line will never be reached.  
   }  
}  
```