---
title: "Compiler Error CS1112 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1112"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1112"
ms.assetid: 72c5f497-8572-41c7-8243-0d5670daca3f
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1112
Do not use 'System.Runtime.CompilerServices.ExtensionAttribute'. Use the 'this' keyword instead.  
  
 This error is generated when the <xref:System.Runtime.CompilerServices.ExtensionAttribute> is used on a non-static class that contains extension methods. If this attribute is used on a static class, another error, such as CS0708: "Cannot declare instance members in a static class," might occur.  
  
 In C#, extension methods must be defined in a static class and the first parameter of the method is modified with the `this` keyword. Do not use the attribute at all in the source code. For more information, see [Extension Methods](../../../csharp/programming-guide/classes-and-structs/extension-methods.md).  
  
## To correct this error  
  
1.  Remove the attribute and apply the `this` modifier to the first parameter of the method.  
  
## Example  
 The following example generates CS1112:  
  
```  
// cs1112.cs  
[System.Runtime.CompilerServices.ExtensionAttribute] // CS1112  
public class Extensions  
{  
    public bool A(bool b) { return b; }  
}  
  
class A { }   
```