---
title: "Compiler Warning (level 1) CS1616 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1616"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1616"
ms.assetid: 7fb99eba-8da3-4c1b-81a3-bc4a57822e45
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1616
Option 'option' overrides attribute 'attribute' given in a source file or added module  
  
 This warning occurs if the assembly attributes <xref:System.Reflection.AssemblyKeyFileAttribute> or <xref:System.Reflection.AssemblyKeyNameAttribute> found in source conflict with the [/keyfile](../../../csharp/language-reference/compiler-options/keyfile-compiler-option.md) or [/keycontainer](../../../csharp/language-reference/compiler-options/keycontainer-compiler-option.md) command line option or key file name or key container specified in the Project Properties.  
  
 For the example below, assume you have a key file  named `cs1616.snk`. This file could be generated with the command line:  
  
```  
sn –k CS1616.snk  
```  
  
 The following sample generates CS1616:  
  
```  
// CS1616.cs  
// compile with: /keyfile:cs1616.snk  
using System.Reflection;  
  
// To fix the error, remove the next line  
[assembly: AssemblyKeyFile("cs1616b.snk")]  // CS1616  
  
class C  
{  
  public static void Main()  
  {  
  }  
}  
```