---
title: "Compiler Warning (level 1) CS1691 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1691"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1691"
ms.assetid: 7f0fea4d-4215-446c-a249-57daa7e967d2
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS1691
'number' is not a valid warning number  
  
 A number that was passed to the [#pragma warning](../../../csharp/language-reference/preprocessor-directives/preprocessor-pragma-warning.md) preprocessor directive was not a valid warning number. Verify that the number represents a warning, not an error or another sequence of characters.  
  
## Example  
 The following example generates CS1691.  
  
```  
// CS1691.cs  
public class C  
{  
    int i = 1;  
    public static void Main()  
    {  
        C myC = new C();  
#pragma warning disable 151  // CS1691  
// Try the following line instead:  
// #pragma warning disable 1645    
        myC.i++;  
#pragma warning restore 151  // CS1691  
// Try the following line instead:  
// #pragma warning restore 1645    
    }  
}  
```