---
title: "Compiler Warning (level 2) CS1701 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1701"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1701"
ms.assetid: adbaf99e-c283-49a7-b940-4c9b84ebcb03
caps.latest.revision: 15
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 2) CS1701
Assuming assembly reference "Assembly Name #1" matches "Assembly Name #2", you may need to supply runtime policy  
  
 The two assemblies differ in release and/or version number. For unification to occur, you must specify directives in the application's .config file, and you must provide the correct strong name of an assembly, as demonstrated in the following example code.  
  
## Example  
 The following multifile sample references an assembly using two different external aliases. This first sample builds the older version of the code that creates assembly CS1701_d.  
  
```  
// CS1701_a.cs  
// compile with: /target:library /out:cs1701_d.dll /keyfile:mykey.snk  
using System.Reflection;  
[assembly:AssemblyVersion("1.0")]  
public class A {  
   public void M1() {}  
}  
  
public class C1 {}  
```  
  
## Example  
 This is the code that creates the newer version of assembly CS1701_d. Note that it compiles into a different directory than the older version, necessary since the output files have the same names.  
  
```  
// CS1701_b.cs  
// compile with: /target:library /out:c:\\cs1701_d.dll /keyfile:mykey.snk  
using System.Reflection;  
[assembly:AssemblyVersion("2.0")]  
public class A {  
   public void M2() {}  
   public void M1() {}  
}  
  
public class C2 {}  
public class C1 {}  
```  
  
## Example  
 This sample sets up the external aliases A1 and A2.  
  
```  
// CS1701_c.cs  
// compile with: /target:library /reference:A2=c:\\cs1701_d.dll /reference:A1=cs1701_d.dll  
  
extern alias A1;  
extern alias A2;  
// using System;  
using a1 = A1::A;  
using a2 = A2::A;  
  
public class Ref {  
   public static a1 A1() { return new a1(); }  
   public static a2 A2() { return new a2(); }  
  
   public static A1::C1 M1() { return new A1::C1(); }  
   public static A2::C2 M2() { return new A2::C2(); }  
}  
```  
  
## Example  
 This sample calls methods using two different aliases of A. The following sample generates C1701.  
  
```  
// CS1701_d.cs  
// compile with: /reference:c:\\CS1701_d.dll /reference:CS1701_c.dll  
// CS1701 expected  
class Tester {  
   public static void Main() {  
      Ref.A1().M1();  
      Ref.A2().M2();  
   }  
}  
```