---
title: "Compiler Error CS1921 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1921"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1921"
ms.assetid: 0e8326dc-4ad9-49b6-948c-d37f10e6abaf
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1921
The best overloaded method match for 'method' has wrong signature for the initializer element. The initializable Add must be an accessible instance method.  
  
 This error is generated when you try to use a collection initializer with a class that has no public non-static `Add` method. If the `Add` method is not accessible because of its protection level (`private`, `protected`, `internal`) then you will get CS0122, so that this error probably means that the method is defined as `static`.  
  
## Example  
 The following example generates CS1921:  
  
```  
// cs1921.cs  
using System.Collections;  
public class C : CollectionBase  
{  
    public static void Add(int i)  
    {  
    }  
}  
public class Test  
{  
    public static void Main()  
    {  
        var collection = new C { 1, 2, 3 }; // CS1921  
    }  
}  
```  
  
## See Also  
 [Object and Collection Initializers](../../../csharp/programming-guide/classes-and-structs/object-and-collection-initializers.md)