---
title: "Compiler Error CS1933 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1933"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1933"
ms.assetid: 80d719d3-1b39-44ec-90fd-039ae5570f01
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1933
Expression cannot contain query expressions  
  
 Some variables cannot be initialized with a query expression. Constants cannot be initialized with query expressions because constants may only be initialized with some combination of literals, named constants, and mathematical operators.  
  
## To correct this error  
  
1.  Remove the modifier from the query variable.  
  
## Example  
 The following example generates CS1933:  
  
```  
// cs1933.cs  
using System.Linq;  
using System.Collections;  
  
class P  
{  
    const IEnumerable e = from x in new[] { 1, 2, 3 } select x; // CS1933  
    static int Main()  
    {  
        return 1;  
    }  
}  
```  
  
## See Also  
 [LINQ Query Expressions](../../../csharp/programming-guide/linq-query-expressions/index.md)