---
title: "Exception Handling Statements (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "keywords [C#], exception handling"
ms.assetid: 6d0323a3-3164-411c-9b84-a3606bd0e13c
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Exception Handling Statements (C# Reference)
C# provides built-in support for handling anomalous situations, known as exceptions, which may occur during the execution of your program. These exceptions are handled by code that is outside the normal flow of control.  
  
 The following exception handling topics are explained in this section:  
  
-   [throw](../../../csharp/language-reference/keywords/throw.md)  
  
-   [try-catch](../../../csharp/language-reference/keywords/try-catch.md)  
  
-   [try-finally](../../../csharp/language-reference/keywords/try-finally.md)  
  
-   [try-catch-finally](../../../csharp/language-reference/keywords/try-catch-finally.md)  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Statement Keywords](../../../csharp/language-reference/keywords/statement-keywords.md)   
 [Exceptions and Exception Handling](../../../csharp/programming-guide/exceptions/index.md)