---
title: "Integral Types Table (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "integral types, C#"
  - "Visual C#, integral types"
  - "types [C#], integral types"
  - "ranges of integral types [C#]"
ms.assetid: 62e86126-46ff-40b0-9028-e61d7558268c
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Integral Types Table (C# Reference)
The following table shows the sizes and ranges of the integral types, which constitute a subset of simple types.  
  
|Type|Range|Size|  
|----------|-----------|----------|  
|[sbyte](../../../csharp/language-reference/keywords/sbyte.md)|-128 to 127|Signed 8-bit integer|  
|[byte](../../../csharp/language-reference/keywords/byte.md)|0 to 255|Unsigned 8-bit integer|  
|[char](../../../csharp/language-reference/keywords/char.md)|U+0000 to U+ffff|Unicode 16-bit character|  
|[short](../../../csharp/language-reference/keywords/short.md)|-32,768 to 32,767|Signed 16-bit integer|  
|[ushort](../../../csharp/language-reference/keywords/ushort.md)|0 to 65,535|Unsigned 16-bit integer|  
|[int](../../../csharp/language-reference/keywords/int.md)|-2,147,483,648 to 2,147,483,647|Signed 32-bit integer|  
|[uint](../../../csharp/language-reference/keywords/uint.md)|0 to 4,294,967,295|Unsigned 32-bit integer|  
|[long](../../../csharp/language-reference/keywords/long.md)|-9,223,372,036,854,775,808 to 9,223,372,036,854,775,807|Signed 64-bit integer|  
|[ulong](../../../csharp/language-reference/keywords/ulong.md)|0 to 18,446,744,073,709,551,615|Unsigned 64-bit integer|  
  
 If the value represented by an integer literal exceeds the range of `ulong`, a compilation error will occur.  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Built-In Types Table](../../../csharp/language-reference/keywords/built-in-types-table.md)   
 [Floating-Point Types Table](../../../csharp/language-reference/keywords/floating-point-types-table.md)   
 [Default Values Table](../../../csharp/language-reference/keywords/default-values-table.md)   
 [Formatting Numeric Results Table](../../../csharp/language-reference/keywords/formatting-numeric-results-table.md)   
 [Reference Tables for Types](../../../csharp/language-reference/keywords/reference-tables-for-types.md)