---
title: "Operator Keywords (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "keywords [C#], operators"
  - "operators [C#], keywords"
ms.assetid: f745c81f-f8d8-4673-86a1-0f3a85cc63c3
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Operator Keywords (C# Reference)
Used to perform miscellaneous actions such as creating objects, checking the run-time type of an object, obtaining the size of a type, and other actions. This section introduces the following keywords:  
  
-   [as](../../../csharp/language-reference/keywords/as.md) Converts an object to a compatible type.  
  
-   [await](../../../csharp/language-reference/keywords/await.md) Suspends an async method until an awaited task is completed.  
  
-   [is](../../../csharp/language-reference/keywords/is.md) Checks the run-time type of an object.  
  
-   [new](../../../csharp/language-reference/keywords/new.md)  
  
    -   [new Operator](../../../csharp/language-reference/keywords/new-operator.md) Creates objects.  
  
    -   [new Modifier](../../../csharp/language-reference/keywords/new-modifier.md) Hides an inherited member.  
  
    -   [new Constraint](../../../csharp/language-reference/keywords/new-constraint.md) Qualifies a type parameter.  
  
-   [sizeof](../../../csharp/language-reference/keywords/sizeof.md) Obtains the size of a type.  
  
-   [typeof](../../../csharp/language-reference/keywords/typeof.md) Obtains the **System.Type** object for a type.  
  
-   [true](../../../csharp/language-reference/keywords/true.md)  
  
    -   [true Operator](../../../csharp/language-reference/keywords/true-operator.md) Returns the boolean value true to indicate true and returns false otherwise.  
  
    -   [true Literal](../../../csharp/language-reference/keywords/true-literal.md) Represents the boolean value true.  
  
-   [false](../../../csharp/language-reference/keywords/false.md)  
  
    -   [false Operator](../../../csharp/language-reference/keywords/false-operator.md) Returns the Boolean value true to indicate false and returns false otherwise.  
  
    -   [false Literal](../../../csharp/language-reference/keywords/false-literal.md) Represents the boolean value false.  
  
-   [stackalloc](../../../csharp/language-reference/keywords/stackalloc.md) Allocates a block of memory on the stack.  
  
 The following keywords, which can be used as operators and as statements, are covered in the [Statements](../../../csharp/language-reference/keywords/statement-keywords.md) section:  
  
-   [checked](../../../csharp/language-reference/keywords/checked.md) Specifies checked context.  
  
-   [unchecked](../../../csharp/language-reference/keywords/unchecked.md) Specifies unchecked context.  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [C# Operators](../../../csharp/language-reference/operators/index.md)