---
title: "Types (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "types [C#]"
  - "data types [C#], type system"
ms.assetid: 16b984df-f417-4e02-b1e6-4589d4a614ea
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Types (C# Reference)
The C# typing system contains the following categories:  
  
-   [Value types](../../../csharp/language-reference/keywords/value-types.md)  
  
-   [Reference types](../../../csharp/language-reference/keywords/reference-types.md)  
  
-   [Pointer types](../../../csharp/programming-guide/unsafe-code-pointers/pointer-types.md)  
  
 Variables that are value types store data, and those that are reference types store references to the actual data. Reference types are also referred to as objects. Pointer types can be used only in [unsafe](../../../csharp/language-reference/keywords/unsafe.md) mode.  
  
 It is possible to convert a value type to a reference type, and back again to a value type, by using [boxing and unboxing](../../../csharp/programming-guide/types/boxing-and-unboxing.md). With the exception of a boxed value type, you cannot convert a reference type to a value type.  
  
 This section also introduces [void](../../../csharp/language-reference/keywords/void.md).  
  
 Value types are also nullable, which means they can store an additional non-value state. For more information, see [Nullable Types](../../../csharp/programming-guide/nullable-types/index.md).  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Reference Tables for Types](../../../csharp/language-reference/keywords/reference-tables-for-types.md)   
 [Casting and Type Conversions](../../../csharp/programming-guide/types/casting-and-type-conversions.md)   
 [Types](../../../csharp/programming-guide/types/index.md)