---
title: "C# Preprocessor Directives | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "cs.preprocessor"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "preprocessor directives [C#]"
  - "keywords [C#], preprocessor directives"
ms.assetid: f2406090-b244-4f7e-ab72-3698fefed724
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# C# Preprocessor Directives
This section contains information about the following C# preprocessor directives.  
  
 [#if](../../../csharp/language-reference/preprocessor-directives/preprocessor-if.md)  
  
 [#else](../../../csharp/language-reference/preprocessor-directives/preprocessor-else.md)  
  
 [#elif](../../../csharp/language-reference/preprocessor-directives/preprocessor-elif.md)  
  
 [#endif](../../../csharp/language-reference/preprocessor-directives/preprocessor-endif.md)  
  
 [#define](../../../csharp/language-reference/preprocessor-directives/preprocessor-define.md)  
  
 [#undef](../../../csharp/language-reference/preprocessor-directives/preprocessor-undef.md)  
  
 [#warning](../../../csharp/language-reference/preprocessor-directives/preprocessor-warning.md)  
  
 [#error](../../../csharp/language-reference/preprocessor-directives/preprocessor-error.md)  
  
 [#line](../../../csharp/language-reference/preprocessor-directives/preprocessor-line.md)  
  
 [#region](../../../csharp/language-reference/preprocessor-directives/preprocessor-region.md)  
  
 [#endregion](../../../csharp/language-reference/preprocessor-directives/preprocessor-endregion.md)  
  
 [#pragma](../../../csharp/language-reference/preprocessor-directives/preprocessor-pragma.md)  
  
 [#pragma warning](../../../csharp/language-reference/preprocessor-directives/preprocessor-pragma-warning.md)  
  
 [#pragma checksum](../../../csharp/language-reference/preprocessor-directives/preprocessor-pragma-checksum.md)  
  
 See the individual topics for more information and examples.  
  
 Although the compiler does not have a separate preprocessor, the directives described in this section are processed as if there were one. They are used to help in conditional compilation. Unlike C and C++ directives, you cannot use these directives to create macros.  
  
 A preprocessor directive must be the only instruction on a line.  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)