---
title: "Compiler Error CS0031 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0031"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0031"
ms.assetid: 91f11ae9-9143-41f4-8002-5c38c8ee0651
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0031
Constant value 'value' cannot be converted to a 'type'. (use 'unchecked' syntax to override)  
  
 An attempt was made to assign a value to a variable whose type cannot store the value. For more information, see [Types](../../csharp/programming-guide/types/index.md).  
  
 The following sample generates CS0031 in both checked and unchecked contexts:  
  
```  
// CS0031.cs  
namespace CS0031  
{  
   public class a  
   {  
      public static void Main()  
      {  
         int num = (int)2147483648M; //CS0031  
         // Try using a larger numeric type instead:  
         // long num = (long)2147483648M; //CS0031  
  
         const decimal d = -10M; // Decimal literal  
            unchecked  
            {  
                const byte b = (byte)d; // CS0031  
                // For small values try using a signed byte instead:  
                // const sbyte b = (sbyte)d;  
            }  
      }  
   }  
}  
```  
  
## See Also  
 [unchecked](../../csharp/language-reference/keywords/unchecked.md)