---
title: "Compiler Error CS0149 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0149"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0149"
ms.assetid: c3c0e48e-8dba-4ee6-86fd-cbb02c68255c
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0149
Method name expected  
  
 When creating a [delegate](../../csharp/language-reference/keywords/delegate.md), specify a method. For more information, see [Delegates](../../csharp/programming-guide/delegates/index.md).  
  
 The following sample generates CS0149:  
  
```  
// CS0149.cs  
using System;  
  
delegate string MyDelegate(int i);  
  
class MyClass  
{  
   // class member-field of the declared delegate type  
   static MyDelegate dt;     
  
   public static void Main()  
   {  
      dt = new MyDelegate(17.45);   // CS0149  
      // try the following line instead  
      // dt = new MyDelegate(Func2);  
      F(dt);  
   }  
  
   public static string Func2(int j)  
   {  
      Console.WriteLine(j);  
      return j.ToString();  
   }  
  
   public static void F(MyDelegate myFunc)  
   {  
      myFunc(8);  
   }  
}  
```