---
title: "Compiler Warning (level 1) CS0183 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0183"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0183"
ms.assetid: c8b8eb23-edae-46da-b3ae-2a00f86e56bc
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS0183
The given expression is always of the provided ('type') type  
  
 If a conditional statement always evaluates to **true**, then you do not need a conditional statement. This warning occurs when you try to evaluate a type using the **is** operator. If the evaluation is a value type, then the check is unnecessary.  
  
 The following sample generates CS0183:  
  
```  
// CS0183.cs  
// compile with: /W:1  
using System;  
public class Test  
{  
   public static void F(Int32 i32, String str)  
   {  
      if (str is Object)          // OK  
         Console.WriteLine( "str is an object" );  
      else  
         Console.WriteLine( "str is not an object" );  
  
      if (i32 is Object)   // CS0183  
         Console.WriteLine( "i32 is an object" );  
      else  
         Console.WriteLine( "i32 is not an object" ); // never reached  
   }  
  
   public static void Main()  
   {  
  
      F(0, "CS0183");  
      F(120, null);   
   }  
}  
```