---
title: "Compiler Error CS0214 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0214"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0214"
ms.assetid: be1ef909-a53e-485f-a79b-b1cc56cead15
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0214
Pointers and fixed size buffers may only be used in an unsafe context  
  
 Pointers can only be used with the [unsafe](../../csharp/language-reference/keywords/unsafe.md) keyword. For more information, see [Unsafe Code and Pointers](../../csharp/programming-guide/unsafe-code-pointers/index.md).  
  
 The following sample generates CS0214:  
  
```  
// CS0214.cs  
// compile with: /target:library /unsafe  
public struct S  
{  
   public int a;  
}  
  
public class MyClass  
{  
   public static void Test()  
   {  
      S s = new S();  
      S * s2 = &s;    // CS0214  
      s2->a = 3;      // CS0214  
      s.a = 0;  
   }  
  
   // OK  
   unsafe public static void Test2()  
   {  
      S s = new S();  
      S * s2 = &s;  
      s2->a = 3;  
      s.a = 0;  
   }  
}  
```