---
title: "Compiler Error CS0218 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0218"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0218"
ms.assetid: f675e06a-c55c-44a1-b5db-0df178fd8f79
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0218
The type ('type') must contain declarations of operator true and operator false  
  
 If you define an operator for a user-defined type, and then try to use the operator as a short-circuit operator, the user-defined operator must have operator true and operator false defined. For more information on short-circuit operators, see [&& Operator](../../csharp/language-reference/operators/conditional-and-operator.md) and [&#124;&#124; Operator](../../csharp/language-reference/operators/conditional-or-operator.md).  
  
 The following sample generates CS0218:  
  
```  
// CS0218.cs  
using System;  
public class MyClass  
{  
   // uncomment these operator declarations to resolve this CS0218  
   /*  
   public static bool operator true (MyClass f)  
   {  
      return false;  
   }  
  
   public static bool operator false (MyClass f)  
   {  
      return false;  
   }  
   */  
  
   public static implicit operator int(MyClass x)  
   {  
      return 0;  
   }  
  
   public static MyClass operator & (MyClass f1, MyClass f2)  
   {  
      return new MyClass();  
   }  
  
   public static void Main()  
   {  
      MyClass f = new MyClass();  
      int i = f && f;   // CS0218, requires operators true and false  
   }  
}  
```  
  
## See Also  
 [Conversion Operators](../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md)