---
title: "Compiler Error CS0231 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0231"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0231"
ms.assetid: e5e6a8e1-6c9f-4a88-8935-7bedfba88f8c
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0231
A params parameter must be the last parameter in a formal parameter list.  
  
 The [params](../../csharp/language-reference/keywords/params.md) parameter supports a variable numbers of arguments and must be after all other parameters. For more information, see [Methods](../../csharp/programming-guide/classes-and-structs/methods.md).  
  
 The following sample generates CS0231:  
  
```  
// CS0231.cs  
class Test  
{  
   public void TestMethod(params int[] p, int i) {} // CS0231  
   // To resolve the error, use the following line instead:  
   // public void TestMethod(int i, params int[] p) {}   
  
   static void Main()   
   {  
   }  
}  
```