---
title: "Compiler Error CS0312 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0312"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0312"
ms.assetid: 552db0ae-2ecf-4beb-9606-bbe58e5708f6
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0312
The type 'type1' cannot be used as type parameter 'name' in the generic type or method 'name'. The nullable type 'type1' does not satisfy the constraint of 'type2'.  
  
 A nullable type is distinct from its non-nullable counterpart; no implicit reference conversion or identify conversion exists between them. A nullable boxing conversion does not satisfy a generic type constraint. In the example that follows, the first type parameter is a `Nullable<int>` and the second type parameter is a `System.Int32`.  
  
## To correct this error  
  
1.  Remove the constraint.  
  
2.  In the following example, make the second type argument either `int?` or `object`.  
  
## Example  
 The following code generates CS0312:  
  
```  
// cs0312.cs  
class Program  
{  
    static void MTyVar<T, U>() where T : U { }  
  
    static int Main()  
    {  
        MTyVar<int?, int>(); // CS0312  
        return 1;  
    }  
}  
```  
  
 Although a nullable type is distinct from a non-nullable type, various kinds of conversions are allowed between nullable and non-nullable values.  
  
## See Also  
 [Nullable Types](../../csharp/programming-guide/nullable-types/index.md)