---
title: "Compiler Error CS0407 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0407"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0407"
ms.assetid: 59112fb9-4641-466e-b738-b3228539a09e
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0407
'return-type method' has the wrong return type  
  
 The method was not compatible with the delegate type. The argument types matched, but the return type was not the correct return type for that delegate. To avoid this error, use a different method, change the method's return type, or change the delegate's return type.  
  
## Example  
 The following sample generates CS0407:  
  
```  
// CS0407.cs  
public delegate int MyDelegate();  
  
class C  
{  
    MyDelegate d;  
  
    public C()  
    {  
        d = new MyDelegate(F);  // OK: F returns int  
        d = new MyDelegate(G);  // CS0407 – G doesn't return int  
    }  
  
    public int F()  
    {  
        return 1;  
    }  
  
    public void G()  
    {  
    }  
  
    public static void Main()  
    {  
        C c1 = new C();  
    }  
}  
```