---
title: "Compiler Error CS0428 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0428"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0428"
ms.assetid: 967c08f4-2761-415d-99fc-bb791d7dfc4e
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0428
Cannot convert method group 'Identifier' to non-delegate type 'type'.  Did you  intend to invoke the method?  
  
 This error occurs when converting a method group to a non-delegate type, or attempting to invoke a method without using parentheses.  
  
## Example  
 The following sample generates CS0428:  
  
```cs  
// CS0428.cs  
namespace ConsoleApplication1  
{  
    class Program  
    {  
        delegate int Del1();  
        delegate object Del2();  
  
        static void Main(string[] args)  
        {  
            ExampleClass ec = new ExampleClass();  
  
            // The following assignment statement causes compiler error CS0428.  
            // It attempts to assign the address of Method1 to an integer variable.   
            // You can only assign the address to an appropriate delegate type.   
            int i = ec.Method1;  
  
            // Del1 is a delegate type that is appropriate for a method like   
            // Method1 that returns an int. The following assignment statement  
            // does not cause an error.  
            Del1 d1 = ec.Method1;  
  
            // You can invoke Method1 and assign the int that is returned to   
            // integer variable i.  
            i = ec.Method1();  
  
            // The following assignment statement causes compiler error CS0428.  
            // It attempts to assign the address of Method2 to an instance of   
            // ExampleClass. You can only assign the address to a delegate type.   
            ec = ExampleClass.Method2;   
  
            // Del2 is a delegate type that is appropriate for a method like   
            // Method2 that returns an instance of a class. The following assignment  
            // statement does not cause an error.  
            Del2 d2 = ExampleClass.Method2;  
  
            // Similarly, you can invoke Method2 and assign the result returned to ec.  
            ec = ExampleClass.Method2();  
        }  
    }  
  
    public class ExampleClass  
    {  
        public int Method1() { return 1; }  
        public static ExampleClass Method2() { return null; }  
    }  
}  
```