---
title: "Compiler Error CS0459 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0459"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0459"
ms.assetid: 01b058dd-8d65-4e9d-9de1-d47f9488d22a
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0459
Cannot take the address of a read-only local variable  
  
 There are three common scenarios in the C# language that generate read-only local variables: `foreach`, `using`, and `fixed`. In each of these cases, you are not allowed to write to the read-only local variable, or to take its address. This error is generated when the compiler realizes you are trying to take the address of a read-only local variable.  
  
## Example  
 The following example generates CS0459 when an attempt is made to take the address of a read-only local variable in a `foreach` loop and in a `fixed` statement block.  
  
```  
// CS0459.cs  
// compile with: /unsafe  
  
class A  
{  
    public unsafe void M1()  
    {  
        int[] ints = new int[] { 1, 2, 3 };  
        foreach (int i in ints)  
        {  
            int *j = &i;  // CS0459  
        }  
  
        fixed (int *i = &_i)  
        {  
            int **j = &i;  // CS0459  
        }  
    }  
  
    private int _i = 0;  
}  
```