---
title: "Compiler Error CS0578 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0821"
  - "CS1648"
  - "CS0444"
  - "CS0609"
  - "CS2034"
  - "CS2013"
  - "CS0582"
  - "CS1597"
  - "CS3014"
  - "CS0704"
  - "CS3006"
  - "CS0538"
  - "CS1594"
  - "CS1715"
  - "CS0763"
  - "CS0442"
  - "CS1689"
  - "CS1631"
  - "CS0657"
  - "CS0076"
  - "CS1553"
  - "CS0280"
  - "CS1562"
  - "CS0164"
  - "CS1556"
  - "CS1912"
  - "CS2016"
  - "CS1102"
  - "CS0766"
  - "CS0617"
  - "CS0148"
  - "CS0706"
  - "CS0755"
  - "CS1109"
  - "CS1681"
  - "CS0578"
  - "CS1680"
  - "CS0762"
  - "CS0620"
  - "CS1649"
  - "CS0068"
  - "CS0216"
  - "CS0450"
  - "CS1622"
  - "CS0248"
  - "CS0636"
  - "CS0824"
  - "CS1202"
  - "CS1688"
  - "CS1665"
  - "CS0244"
  - "CS0132"
  - "CS1584"
  - "CS0268"
  - "CS0692"
  - "CS1623"
  - "CS1930"
  - "CS1687"
  - "CS0528"
  - "CS0674"
  - "CS1909"
  - "CS1103"
  - "CS0544"
  - "CS0730"
  - "CS1035"
  - "CS0533"
  - "CS0567"
  - "CS1676"
  - "CS0192"
  - "CS0569"
  - "CS1723"
  - "CS0520"
  - "CS0557"
  - "CS0682"
  - "CS1662"
  - "CS0715"
  - "CS0251"
  - "CS1939"
  - "CS0841"
  - "CS1641"
  - "CS0761"
  - "CS0529"
  - "CS0275"
  - "CS0837"
  - "CS1638"
  - "CS1581"
  - "CS0448"
  - "CS0456"
  - "CS3022"
  - "CS1677"
  - "CS1913"
  - "CS2033"
  - "CS0316"
  - "CS0670"
  - "CS1945"
  - "CS0073"
  - "CS0231"
  - "CS0610"
  - "CS0220"
  - "CS1925"
  - "CS0734"
  - "CS1675"
  - "CS0180"
  - "CS2003"
  - "CS1608"
  - "CS0541"
  - "CS0261"
  - "CS0590"
  - "CS0072"
  - "CS1686"
  - "CS1722"
  - "CS1104"
  - "CS1673"
  - "CS1724"
  - "CS0174"
  - "CS1203"
  - "CS0514"
  - "CS0440"
  - "CS2011"
  - "CS3026"
  - "CS0594"
  - "CS1561"
  - "CS3010"
  - "CS1629"
  - "CS1536"
  - "CS0599"
  - "CS0750"
  - "CS0066"
  - "CS0631"
  - "CS0643"
  - "CS0279"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0578"
ms.assetid: fbc5c884-e358-48f1-aeac-5ec8fd9f0c40
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0578
The Conditional attribute is not valid on 'function' because its return type is not void  
  
 <xref:System.Diagnostics.ConditionalAttribute> cannot be applied to a method that has a return type other than `void`. The reason for this is that any other return type for a method may be needed by another part of your program.  
  
## Example  
 The following sample generates CS0578. To resolve this error, you must either delete <xref:System.Diagnostics.ConditionalAttribute>, or you must change the return value of the method to `void`.  
  
```  
// CS0578.cs  
// compile with: /target:library  
public class MyClass  
{  
   [System.Diagnostics.ConditionalAttribute("a")]   // CS0578  
   public int TestMethod()  
   {  
      return 0;  
   }  
}  
```