---
title: "Compiler Error CS0620 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0620"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0620"
ms.assetid: cadd7156-0c3c-460b-844b-c9bbfb8f62df
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0620
Indexers cannot have void type  
  
 The return type of an [indexer](../../csharp/programming-guide/indexers/index.md) cannot be `void`. An indexer must return a value.  
  
 The following sample generates CS0620:  
  
```  
// CS0620.cs  
class MyClass  
{  
   public static void Main()  
   {  
      MyClass test = new MyClass();  
      System.Console.WriteLine(test[2]);  
   }  
  
   void this [int intI]   // CS0620, return type cannot be void  
   {  
      get  
      {  
         // will need to return some value  
      }  
   }  
}  
```  
  
## See Also  
 [void](../../csharp/language-reference/keywords/void.md)