---
title: "Compiler Error CS0668 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0668"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0668"
ms.assetid: 7bdaa795-ce13-4284-b753-a617c1735cfa
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0668
Two indexers have different names; the IndexerName attribute must be used with the same name on every indexer within a type  
  
 The values passed to the **IndexerName** attribute must be the same for all indexers in a type. For more information on the **IndexerName** attribute, see [IndexerNameAttribute Class](xref:System​.Runtime​.CompilerServices.IndexerNameAttribute).  
  
 The following sample generates CS0668:  
  
```cs
// CS0668.cs  
using System;  
using System.Runtime.CompilerServices;  
  
class IndexerClass  
{  
   [IndexerName("IName1")]  
   public int this [int index]   // indexer declaration  
   {  
      get  
      {  
         return index;  
      }  
      set  
      {  
      }  
   }  
  
   [IndexerName("IName2")]  
   public int this [string s]    // CS0668, change IName2 to IName1  
   {  
      get  
      {  
         return int.Parse(s);  
      }  
      set  
      {  
      }  
   }  
  
   void Main()  
   {  
   }  
}  
```