---
title: "Compiler Error CS0739 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0739"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0739"
ms.assetid: c2a83015-401c-4d85-bb19-ed29800904c1
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0739
'type name' duplicate TypeForwardedToAttribute.  
  
 An assembly can have no more than one <xref:System.Runtime.CompilerServices.TypeForwardedToAttribute> to an external type.  
  
## To correct this error  
  
1.  Locate and remove the duplicate <xref:System.Runtime.CompilerServices.TypeForwardedToAttribute>.  
  
## Example  
 The following code generates CS0739:  
  
```  
// CS0739.cs  
// CS0739  
// Assume that a class Test is declared in a separate dll  
// with a namespace that is named cs739dll.  
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(cs739dll.Test))]  
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(cs739dll.Test))]  
namespace cs0739  
{  
    class Program  
    {  
        static void Main(string[] args)  
        {  
        }  
    }  
}  
```  
  
## See Also  
 <xref:System.Runtime.CompilerServices.TypeForwardedToAttribute>