---
title: "Compiler Error CS0811 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0811"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0811"
ms.assetid: 99f81ad3-684f-47aa-adb8-360e24901454
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0811
The fully qualified name for 'name' is too long for debug information. Compile without '/debug' option.  
  
 There are size constraints on variable and type names in debug information.  
  
## To correct this error  
  
1.  If modifying the name is not possible, the only alternative is to compile without the [/debug](../../csharp/language-reference/compiler-options/debug-compiler-option.md) option.  
  
## Example  
 The following code generates CS0811:  
  
```  
// cs0811.cs  
//Compile with: /debug  
using System;  
using System.Collections.Generic;  
  
namespace TestNamespace  
{  
    using Long = List<List<List<List<List<List<List<List<List<List<List<List<List  
   <List<List<List<List<List<List<List<List<List<List<List<List<List<List<List<int>>>>>>>>>>>>>>>>>>>>>>>>>>>>; // CS0811  
  
    class Test  
    {  
        static int Main()  
        {  
            return 1;  
        }  
    }  
}  
```