---
title: "Compiler Error CS1512 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1512"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1512"
ms.assetid: 50740d85-598d-478f-bfe3-e8c2e1a02ab8
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1512
Keyword 'base' is not available in the current context  
  
 The [base](../../csharp/language-reference/keywords/base.md) keyword was used outside of a method, property, or constructor.  
  
 The following example generates CS1512:  
  
```  
// CS1512.cs  
using System;  
  
class Base {}  
  
class CMyClass : Base  
{  
    private String xx = base.ToString();   // CS1512  
    // Try putting this initialization in the constructor instead:  
    // public CMyClass()  
    // {  
    //    xx = base.ToString();  
    // }  
  
    public static void Main()  
    {  
        CMyClass z = new CMyClass();  
    }  
}  
```