---
title: "Compiler Error CS1625 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1625"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1625"
ms.assetid: 0b25b7f9-a585-49b0-9ee6-4384e87fcea6
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1625
Cannot yield in the body of a finally clause  
  
 A yield statement is not allowed in the body of a finally clause. To avoid this error, move the yield statement out of the finally clause.  
  
 The following sample generates CS1625:  
  
```  
// CS1625.cs  
using System.Collections;  
  
class C : IEnumerable  
{  
   public IEnumerator GetEnumerator()  
   {  
      try  
      {  
      }  
      finally  
      {  
        yield return this;  // CS1625  
      }  
   }  
}  
  
public class CMain  
{  
   public static void Main() { }  
}  
  
```